/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.planning.spareparts.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.AppLogFactory;
import com.kingdee.eas.base.log.IAppLog;
import com.kingdee.eas.base.log.app.LogServerUtil;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.archives.EquipmentArchivesException;
import com.kingdee.eas.eqm.common.core.GeneBillBaseInfo;
import com.kingdee.eas.eqm.common.core.GeneBillBaseStatusEnum;
import com.kingdee.eas.eqm.common.core.GeneException;
import com.kingdee.eas.eqm.common.core.app.util.GeneServerUtils;
import com.kingdee.eas.eqm.common.core.app.util.GeneSeverMetadataUtils;
import com.kingdee.eas.eqm.common.core.util.GeneParamUtil;
import com.kingdee.eas.eqm.common.core.verify.IVerifyItem;
import com.kingdee.eas.eqm.common.core.verify.IVerifyManager;
import com.kingdee.eas.eqm.common.eqmcore.app.util.DataImportEqmTools;
import com.kingdee.eas.eqm.planning.spareparts.ISparepartPlanOrder;
import com.kingdee.eas.eqm.planning.spareparts.SparePartsPlanOrderException;
import com.kingdee.eas.eqm.planning.spareparts.SparepartPlanOrderFactory;
import com.kingdee.eas.eqm.planning.spareparts.SparepartPlanOrderInfo;
import com.kingdee.eas.eqm.planning.spareparts.app.AbstractSparepartPlanOrderControllerBean;
import com.kingdee.eas.eqm.planning.spareparts.app.verify.SparepartPlanOrderUnAuditVerifyItem;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.scm.sm.pur.IPurRequest;
import com.kingdee.eas.scm.sm.pur.PurRequestFactory;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SparepartPlanOrderControllerBean
extends AbstractSparepartPlanOrderControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.eqm.planning.spareparts.app.SparepartPlanOrderControllerBean");
    private static final String AFTER_FORCECLOSE = "After_ForceComplete";
    private static final String SPPLANORDER_RESOURCE_PATH = "com.kingdee.eas.eqm.planning.spareparts.SharepartPlanOrderResource";
    protected Set _cacheAuthorizedOrgUnits = null;
    protected Map cache_storageInfo = new HashMap();
    private Set unableOrgSet = new HashSet();

    @Override
    public SparepartPlanOrderInfo getSparepartPlanOrderInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            return super.getSparepartPlanOrderInfo(ctx, pk);
        }
        catch (ObjectNotFoundException e) {
            throw new GeneException(GeneException.OBJECTNOEXIST);
        }
    }

    @Override
    public SparepartPlanOrderInfo getSparepartPlanOrderInfo(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        try {
            return super.getSparepartPlanOrderInfo(ctx, pk, selector);
        }
        catch (ObjectNotFoundException e) {
            throw new GeneException(GeneException.OBJECTNOEXIST);
        }
    }

    @Override
    protected void _forceComplete(Context ctx, IObjectPK billID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        GeneBillBaseInfo info = (GeneBillBaseInfo)this.getValue(ctx, billID);
        if (info.getBillStatus() != GeneBillBaseStatusEnum.Audit) {
            throw new SparePartsPlanOrderException(SparePartsPlanOrderException.NOTAUDITED, new String[]{info.getBillStatus().getAlias()});
        }
        sql.setLength(0);
        sql.append(" UPDATE T_EQM_SparepartPlanOrder SET FBillStatus = ? ");
        sql.append(" WHERE FID = ? ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{new Integer(65), billID.toString()});
        sql.setLength(0);
        sql.append("select FID from t_sm_purrequest where FSOURCEBILLID=? and fbasestatus=?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{billID.toString(), new Integer(1)});
        StringBuffer purIds = new StringBuffer();
        purIds.append("'null'");
        try {
            while (rs != null && rs.next()) {
                purIds.append(",'" + rs.getString("FID") + "'");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (purIds.length() > 6) {
            sql.setLength(0);
            sql.append("delete from t_sm_purrequestentry where FParentID in (").append(purIds.toString()).append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("delete from t_sm_purrequest where FID in (").append(purIds.toString()).append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("delete from t_bot_Relation where FSrcObjectID=? and FDestObjectID in (").append(purIds.toString()).append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{billID.toString()});
        }
        this.fireServerAction(ctx, info, AFTER_FORCECLOSE);
    }

    protected IVerifyManager getUnAuditVerifyManager(Context ctx, GeneBillBaseInfo info) {
        IVerifyManager verifymanager = super.getUnAuditVerifyManager(ctx, info);
        String number = info.getNumber();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("sourcebillid", (Object)info.getId().toString(), CompareType.EQUALS));
        viewInfo.setFilter(filter);
        try {
            IPurRequest ipr = PurRequestFactory.getLocalInstance((Context)ctx);
            CoreBaseCollection c = ipr.getCollection(viewInfo);
            SparepartPlanOrderUnAuditVerifyItem verifyItem = new SparepartPlanOrderUnAuditVerifyItem(number, c.size());
            verifymanager.addVerifyItem((IVerifyItem)verifyItem);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return verifymanager;
    }

    protected boolean isAuditBySubmit(Context ctx, GeneBillBaseInfo info) throws BOSException, EASBizException {
        boolean isAutoAudit = GeneParamUtil.paramIsSelected((Context)ctx, (String)"EQM010", (String)info.getMainOrgUnit().getId().toString());
        return isAutoAudit;
    }

    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ISparepartPlanOrder entity = SparepartPlanOrderFactory.getLocalInstance(ctx);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("name");
        selector.add("number");
        selector.add("storageOrgUnit.number");
        selector.add("storageOrgUnit.name");
        SparepartPlanOrderInfo info = entity.getSparepartPlanOrderInfo(pk, selector);
        StorageOrgUnitInfo orgInfo = info.getStorageOrgUnit();
        GeneServerUtils.checkPermission((Context)ctx, (IObjectPK)new ObjectUuidPK(orgInfo.getId()), (String)"eqm_SparepartPlanOrder_07unAudit");
        SparepartPlanOrderInfo model = this.getSparepartPlanOrderInfo(ctx, pk);
        if (this.canUnAudit(ctx, (GeneBillBaseInfo)model)) {
            try {
                super._unAudit(ctx, pk);
                this.writeLog(ctx, info, "unaudit", new Boolean(true));
            }
            catch (BOSException e1) {
                this.writeLog(ctx, info, "unaudit", new Boolean(false));
                throw e1;
            }
            catch (EASBizException e2) {
                this.writeLog(ctx, info, "unaudit", new Boolean(false));
                throw e2;
            }
        } else {
            this.writeLog(ctx, info, "_unAudit", new Boolean(false));
            throw new SparePartsPlanOrderException(SparePartsPlanOrderException.PARAMCANNOTUNAUDIT, new String[0]);
        }
    }

    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ISparepartPlanOrder entity = SparepartPlanOrderFactory.getLocalInstance(ctx);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("name");
        selector.add("number");
        selector.add("storageOrgUnit.number");
        selector.add("storageOrgUnit.name");
        SparepartPlanOrderInfo info = entity.getSparepartPlanOrderInfo(pk, selector);
        StorageOrgUnitInfo orgInfo = info.getStorageOrgUnit();
        GeneServerUtils.checkPermission((Context)ctx, (IObjectPK)new ObjectUuidPK(orgInfo.getId()), (String)"eqm_SparepartPlanOrder_06audit");
        try {
            super._audit(ctx, pk);
            this.writeLog(ctx, info, "audit", new Boolean(true));
        }
        catch (BOSException e1) {
            this.writeLog(ctx, info, "audit", new Boolean(false));
            throw e1;
        }
        catch (EASBizException e2) {
            this.writeLog(ctx, info, "audit", new Boolean(false));
            throw e2;
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ISparepartPlanOrder entity = SparepartPlanOrderFactory.getLocalInstance(ctx);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("name");
        selector.add("number");
        selector.add("storageOrgUnit.number");
        selector.add("storageOrgUnit.name");
        SparepartPlanOrderInfo info = entity.getSparepartPlanOrderInfo(pk, selector);
        StorageOrgUnitInfo orgInfo = info.getStorageOrgUnit();
        GeneServerUtils.checkPermission((Context)ctx, (IObjectPK)new ObjectUuidPK(orgInfo.getId()), (String)"eqm_SparepartPlanOrder_05delete");
        try {
            super._delete(ctx, pk);
            this.writeLog(ctx, info, "delete", new Boolean(true));
        }
        catch (BOSException e1) {
            this.writeLog(ctx, info, "delete", new Boolean(false));
            throw e1;
        }
        catch (EASBizException e2) {
            this.writeLog(ctx, info, "delete", new Boolean(false));
            throw e2;
        }
    }

    private boolean canUnAudit(Context ctx, GeneBillBaseInfo info) throws BOSException, EASBizException {
        return GeneParamUtil.paramIsSelected((Context)ctx, (String)"EQM011", (String)info.getMainOrgUnit().getId().toString());
    }

    @Override
    protected List _getBotpList(Context ctx, List idList) throws BOSException, EASBizException {
        ArrayList geneList = new ArrayList();
        ArrayList<String> unGeneList = new ArrayList<String>();
        for (int i = 0; i < idList.size(); ++i) {
            SparepartPlanOrderInfo info = super.getSparepartPlanOrderInfo(ctx, (IObjectPK)new ObjectUuidPK(idList.get(i).toString()));
            OrgUnitCollection unitCol = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(info.getStorageOrgUnit().getId().toString(), 4, 1);
            if (unitCol == null || unitCol.size() < 1) {
                unGeneList.add(info.getNumber() + " " + SparepartPlanOrderControllerBean.getString(ctx, "CheckToOrgIsNull"));
                continue;
            }
            geneList.add(idList.get(i));
        }
        if (geneList.size() < 1) {
            StringBuffer tips = new StringBuffer();
            for (int i = 0; i < unGeneList.size(); ++i) {
                tips.append("\n").append(unGeneList.get(i));
            }
            throw new EquipmentArchivesException(EquipmentArchivesException.CHECK_BOTP, new Object[]{tips.toString()});
        }
        return geneList;
    }

    public static String getString(Context ctx, String resourceName) {
        String strTemp = ResourceBase.getString((String)SPPLANORDER_RESOURCE_PATH, (String)resourceName, (Locale)ctx.getLocale());
        if (strTemp.equals("Missing Resource")) {
            return "Missing Resource{" + resourceName + "}";
        }
        return strTemp;
    }

    private void writeLog(Context ctx, SparepartPlanOrderInfo spPlanOrderInfo, String operation, Boolean isSuccessed) throws BOSException {
        if (this.getLogItem(operation) == null || "".equals(this.getLogItem(operation))) {
            return;
        }
        IAppLog appLog = AppLogFactory.getLocalInstance((Context)ctx);
        EntityObjectInfo entityObjectInfo = GeneSeverMetadataUtils.getBOSEntity((Context)ctx, (BOSObjectType)this.getBOSType());
        HashMap<String, Object> hashLog = new HashMap<String, Object>();
        LogServerUtil.setLogInfo(null, (Context)ctx, hashLog);
        hashLog.put("isSuccessed", new Boolean(false));
        hashLog.put("successed", isSuccessed);
        hashLog.put("FEntityID", this.getBOSType().toString());
        hashLog.put("FEntityName", entityObjectInfo.getName());
        hashLog.put("FEntityAlias_L1", entityObjectInfo.getAlias(ctx.getLocale()));
        hashLog.put("FEntityAlias_L2", entityObjectInfo.getAlias(ctx.getLocale()));
        hashLog.put("FEntityAlias_L3", entityObjectInfo.getAlias(ctx.getLocale()));
        hashLog.put("FMethodName", "close");
        hashLog.put("FCompanyName_L1", spPlanOrderInfo.getStorageOrgUnit().getName(ctx.getLocale()));
        hashLog.put("FCompanyName_L2", spPlanOrderInfo.getStorageOrgUnit().getName(ctx.getLocale()));
        hashLog.put("FCompanyName_L3", spPlanOrderInfo.getStorageOrgUnit().getName(ctx.getLocale()));
        hashLog.put("FInstanceID", spPlanOrderInfo.getId().toString());
        hashLog.put("FInstanceNo", spPlanOrderInfo.getLogInfo());
        hashLog.put("FItemName", this.getLogItem(operation));
        hashLog.put("LOG_HIDDEN_WRITE_MODE", "LOG_HIDDEN_WRITE_MODE");
        appLog.writeLog(hashLog);
    }

    private Object getLogItem(String operation) {
        String logItem = "";
        if (operation.equals("delete")) {
            logItem = "eqm_SparepartPlanOrder_delete";
        } else if (operation.equals("audit")) {
            logItem = "eqm_SparepartPlanOrder_audit";
        } else if (operation.equals("unaudit")) {
            logItem = "eqm_SparepartPlanOrder_unAudit";
        }
        return logItem;
    }

    @Override
    public Set _checkOrgExportPermission(Context ctx, Set orgSet) throws BOSException {
        for (String orgNumber : orgSet) {
            StorageOrgUnitInfo org;
            if (this.isAuthorizedOrgUnit(ctx, orgNumber) || (org = this.getStorageOrgUnitInfoFromNumber(ctx, orgNumber)) == null) continue;
            this.unableOrgSet.add(org.getNumber() + "_" + org.getName() + "\n");
        }
        return this.unableOrgSet;
    }

    private boolean isAuthorizedOrgUnit(Context ctx, String orgNumber) throws BOSException {
        if (this._cacheAuthorizedOrgUnits == null) {
            try {
                OrgUnitInfo[] orgUnits = DataImportEqmTools.getAuthorizedBizOrgUnits((Context)ctx, (OrgType)OrgType.Storage, (String)"eqm_SparepartPlanOrder_12export");
                if (orgUnits != null && orgUnits.length > 0) {
                    this._cacheAuthorizedOrgUnits = new HashSet();
                    for (int i = 0; i < orgUnits.length; ++i) {
                        this._cacheAuthorizedOrgUnits.add(orgUnits[i].getNumber());
                    }
                }
            }
            catch (Exception e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
        return this._cacheAuthorizedOrgUnits != null && this._cacheAuthorizedOrgUnits.contains(orgNumber);
    }

    protected StorageOrgUnitInfo getStorageOrgUnitInfoFromNumber(Context ctx, String storageOrgNumber) throws BOSException {
        if (storageOrgNumber == null || storageOrgNumber.trim().length() == 0) {
            return null;
        }
        String ckey = storageOrgNumber;
        if (this.cache_storageInfo.get(ckey) != null) {
            return (StorageOrgUnitInfo)this.cache_storageInfo.get(ckey);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("CU.*"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)storageOrgNumber, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        StorageOrgUnitInfo info = null;
        if (storageOrgNumber != null && storageOrgNumber.trim().length() > 0) {
            IStorageOrgUnit iStorageOrgUnit = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
            StorageOrgUnitCollection collection = iStorageOrgUnit.getStorageOrgUnitCollection(viewInfo);
            if (collection != null && collection.size() == 1) {
                info = collection.get(0);
            }
            this.cache_storageInfo.put(ckey, info);
        }
        return info;
    }
}

