/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.planning.spareparts.app.calculation;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.backport.concurrent.Callable;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPCalcParam;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPConstant;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPDetailInfo;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPDetialTableDAO;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPMaterialDataInfo;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPMaterialTableDAO;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPNetReqSaver;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPPlanVersionPeriod;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPProgressUpdater;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPResource;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPStep;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

public class SPCalcMaterials
extends SPStep
implements Callable {
    private List materialIDLst;
    SPNetReqSaver dataSaver;
    private int materialCount = 0;
    private int detailLineCount = 0;
    private int calQty;

    public SPCalcMaterials(List materialIDLst, SPCalcParam runParam, int calQty) {
        this.materialIDLst = materialIDLst;
        this.runParam = runParam;
        this.calQty = calQty;
        this.dataSaver = new SPNetReqSaver(runParam);
    }

    public Object call() throws Exception {
        return this.execute(this.runParam);
    }

    protected SPDetailInfo getDetailInfoByRequiredDate(SPDetailInfo[] infos, Date requiredDate) {
        SPDetailInfo info2 = null;
        boolean flag = false;
        for (SPDetailInfo info2 : infos) {
            if (null == info2.getRequiredDate() || requiredDate.compareTo(info2.getRequiredDate()) != 0) continue;
            flag = true;
            break;
        }
        if (!flag) {
            info2 = null;
        }
        return info2;
    }

    @Override
    protected Object innerExecute(SPCalcParam runParam) throws EASBizException, BOSException {
        if (this.materialIDLst.isEmpty()) {
            return null;
        }
        SPMaterialDataInfo[] materialDatas = SPMaterialTableDAO.getLevelMaterials(runParam, this.materialIDLst);
        this.materialCount = materialDatas.length;
        List list = runParam.getPlanVersionSetPeriodList();
        if (runParam.isNeedNetRequirement()) {
            for (SPMaterialDataInfo materialInfo : materialDatas) {
                BigDecimal initInvQty;
                String materialID = materialInfo.getMaterialID();
                SPDetailInfo[] grossDatas = SPDetialTableDAO.getMaterialDetialData(runParam, materialID, "null", "G");
                SPDetailInfo[] estimatedDatas = SPDetialTableDAO.getMaterialDetialData(runParam, materialID, "null", "N");
                SPPlanVersionPeriod.PeriodVO vo = null;
                BigDecimal canUseInvQty = initInvQty = materialInfo.getOnHandQty();
                SPDetailInfo grossInfo = null;
                SPDetailInfo estimatedInfo = null;
                BigDecimal netReq = null;
                BigDecimal grossReq = null;
                BigDecimal estimatedReq = null;
                BigDecimal safeInv = null == materialInfo.getSafeStockQty() ? SPConstant.ZERO : materialInfo.getSafeStockQty();
                BigDecimal plannedQty = null;
                Date periodBeginDate = null;
                int count = list.size();
                for (int i = 0; i < count; ++i) {
                    vo = (SPPlanVersionPeriod.PeriodVO)list.get(i);
                    periodBeginDate = vo.getBeginDate();
                    grossInfo = this.getDetailInfoByRequiredDate(grossDatas, vo.getBeginDate());
                    estimatedInfo = this.getDetailInfoByRequiredDate(estimatedDatas, vo.getBeginDate());
                    grossReq = null != grossInfo ? grossInfo.getBaseQty() : SPConstant.ZERO;
                    estimatedReq = null != estimatedInfo ? estimatedInfo.getBaseQty() : SPConstant.ZERO;
                    netReq = grossReq.subtract(canUseInvQty).subtract(estimatedReq).add(safeInv);
                    plannedQty = SPConstant.ZERO.compareTo(netReq) < 0 ? this.adjustQtyByBatchPolicy(materialInfo, netReq) : SPConstant.ZERO;
                    if (SPConstant.ZERO.compareTo(plannedQty) < 0) {
                        this.createPlanOrder(materialInfo, plannedQty, periodBeginDate);
                    }
                    canUseInvQty = canUseInvQty.add(estimatedReq).subtract(grossReq).add(plannedQty);
                }
            }
        } else {
            SPDetailInfo grossInfo = null;
            SPPlanVersionPeriod.PeriodVO vo = null;
            Date periodBeginDate = null;
            BigDecimal plannedQty = null;
            for (SPMaterialDataInfo materialInfo : materialDatas) {
                String materialID = materialInfo.getMaterialID();
                SPDetailInfo[] grossDatas = SPDetialTableDAO.getMaterialDetialData(runParam, materialID, "null", "G");
                int count = list.size();
                for (int i = 0; i < count; ++i) {
                    vo = (SPPlanVersionPeriod.PeriodVO)list.get(i);
                    periodBeginDate = vo.getBeginDate();
                    grossInfo = this.getDetailInfoByRequiredDate(grossDatas, periodBeginDate);
                    BigDecimal bigDecimal = plannedQty = null == grossInfo ? SPConstant.ZERO : grossInfo.getBaseQty();
                    if (SPConstant.ZERO.compareTo(plannedQty) >= 0) continue;
                    plannedQty = this.adjustQtyByBatchPolicy(materialInfo, plannedQty);
                    this.createPlanOrder(materialInfo, plannedQty, periodBeginDate);
                }
            }
        }
        SPProgressUpdater.updateMaterialCalcProgress(runParam);
        this.detailLineCount += this.dataSaver.execute(true);
        return null;
    }

    protected BigDecimal adjustQtyByBatchPolicy(SPMaterialDataInfo materialdataInfo, BigDecimal netReq) {
        if (null == materialdataInfo || null == netReq) {
            return null;
        }
        BigDecimal plannedQty = netReq;
        switch (materialdataInfo.getBatchPolicy()) {
            case 1: {
                if (materialdataInfo.getFixationBatchQty() == null || materialdataInfo.getFixationBatchQty().compareTo(SPConstant.ZERO) <= 0) break;
                BigDecimal batch = plannedQty.divide(materialdataInfo.getFixationBatchQty(), 0, 2);
                plannedQty = batch.multiply(materialdataInfo.getFixationBatchQty()).setScale(materialdataInfo.getBaseQtyPrc(), 2);
                break;
            }
            case 2: {
                if (materialdataInfo.getMinBatchQty() != null && plannedQty.compareTo(materialdataInfo.getMinBatchQty()) < 0) {
                    plannedQty = materialdataInfo.getMinBatchQty();
                }
                if (materialdataInfo.getRoundUpMultipleQty() != null && materialdataInfo.getRoundUpMultipleQty().compareTo(SPConstant.ZERO) > 0) {
                    BigDecimal batchM = plannedQty.divide(materialdataInfo.getRoundUpMultipleQty(), 0, 2);
                    plannedQty = batchM.multiply(materialdataInfo.getRoundUpMultipleQty()).setScale(materialdataInfo.getBaseQtyPrc(), 2);
                }
                if (materialdataInfo.getBatchIncQty() == null) break;
                plannedQty = plannedQty.add(materialdataInfo.getBatchIncQty());
                break;
            }
        }
        return plannedQty;
    }

    protected SPDetailInfo createPlanOrder(SPMaterialDataInfo materialInfo, BigDecimal plannedQty, Date orderDate) throws EASBizException, BOSException {
        SPDetailInfo orderInfo = new SPDetailInfo();
        orderInfo.setMaterialId(materialInfo.getMaterialID());
        orderInfo.setRequiredDate(orderDate);
        orderInfo.setBaseQty(plannedQty);
        orderInfo.setBaseUnitId(materialInfo.getBaseUnitID());
        orderInfo.setBillNumber(this.getOrderNumber(this.calQty));
        orderInfo.setMaterialInvId(materialInfo.getMaterialInvId());
        orderInfo.setMaterialPlanId(materialInfo.getMaterialPlanId());
        this.dataSaver.addInsertList(orderInfo);
        this.runParam.generateOrder();
        return orderInfo;
    }

    protected String getOrderNumber(int calQty) throws EASBizException, BOSException {
        return this.runParam.getPONumber(calQty);
    }

    @Override
    protected String getStepDesc() {
        return "THREAD NAME IS " + Thread.currentThread().getName() + "  " + SPResource.getString(this.runParam.getCtx(), "SP_CALCMATERIALS") + "," + SPResource.getString(this.runParam.getCtx(), "SYM_MATERIAL") + SPResource.getString(this.runParam.getCtx(), "SYM_NUMBER") + ":" + String.valueOf(this.materialCount) + ": detail line count : " + String.valueOf(this.detailLineCount);
    }

    @Override
    protected String getStepNum() {
        return "60.02";
    }

    @Override
    protected boolean isNeedUpdateProgress() {
        return false;
    }

    @Override
    protected int getProgressPercent() {
        return 0;
    }

    @Override
    protected void logEnd() throws BOSException {
        super.logEnd();
        logger.info((Object)("thread end and thread name is " + Thread.currentThread().getName()));
    }
}

