/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.planning.spareparts.app.calculation;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.backport.concurrent.Callable;
import com.kingdee.bos.util.backport.concurrent.ExecutionException;
import com.kingdee.bos.util.backport.concurrent.Executor;
import com.kingdee.bos.util.backport.concurrent.ExecutorCompletionService;
import com.kingdee.bos.util.backport.concurrent.ExecutorService;
import com.kingdee.bos.util.backport.concurrent.Executors;
import com.kingdee.bos.util.backport.concurrent.Future;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPCalcMaterials;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPCalcParam;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPMaterialTableDAO;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPResource;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPStep;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPUtil;
import java.util.List;

public class SPCalcNetDemand
extends SPStep {
    private static int THREADCOUNT = Runtime.getRuntime().availableProcessors() * 2;

    @Override
    protected boolean isNeedUpdateProgress() {
        return false;
    }

    @Override
    protected int getProgressPercent() {
        return 0;
    }

    @Override
    protected String getStepDesc() {
        return SPResource.getString(this.runParam.getCtx(), "SP_CALCNETDEMAND");
    }

    @Override
    protected String getStepNum() {
        return "60.99";
    }

    @Override
    protected void logBegin() {
        super.logBegin();
        String msg = "60.00:" + this.getStepDesc() + SPResource.getString(this.runParam.getCtx(), "SYM_BEGIN");
        this.logInfo(msg);
    }

    @Override
    protected Object innerExecute(SPCalcParam runParam) throws EASBizException, BOSException {
        String tableName = null;
        try {
            tableName = SPUtil.createTempTable(runParam.getCtx(), "  CREATE TABLE RESULTTABLE (\r\nFID INT ,\r\nFMATERIALID VARCHAR(44) NOT NULL,\r\nFPlanVersionID VARCHAR(44) NOT NULL,\r\nFRunLogID VARCHAR(44) NOT NULL,\r\nFREQUIREDDATE DATETIME NOT NULL,\r\nFBASEQTY NUMERIC(21,8), \r\nFBASEUNITID VARCHAR(44) NOT NULL,\r\nFBILLNUMBER NVARCHAR(80), \r\nFMATERIALINVID VARCHAR(44), \r\nFMATERIALPLANID VARCHAR(44) \r\n) ");
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
        runParam.getTempTableList().add(tableName);
        runParam.setResultTableName(tableName);
        int calQty = runParam.getMaterialCalQty();
        int threadCount = calQty < THREADCOUNT ? 1 : THREADCOUNT;
        ExecutorService exec = Executors.newFixedThreadPool((int)threadCount);
        ExecutorCompletionService ecs = new ExecutorCompletionService((Executor)exec);
        Future[] futrues = new Future[calQty];
        for (int i = 0; i < calQty; ++i) {
            List materialIdList = null;
            materialIdList = 1 == calQty ? SPMaterialTableDAO.getLevelMaterialIDs(runParam, -1) : SPMaterialTableDAO.getLevelMaterialIDs(runParam, i + 1);
            SPCalcMaterials calc = new SPCalcMaterials(materialIdList, runParam, i);
            if (exec.isShutdown()) continue;
            futrues[i] = ecs.submit((Callable)calc);
        }
        try {
            for (int j = 0; j < calQty; ++j) {
                futrues[j].get();
            }
        }
        catch (InterruptedException e) {
            throw new BOSException(e.getCause());
        }
        catch (ExecutionException e) {
            throw new BOSException(e.getCause());
        }
        finally {
            exec.shutdown();
        }
        return null;
    }
}

