/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.planning.spareparts.app.calculation;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPCalcParam;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPDetailInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;

public class SPDetialTableDAO {
    public static SPDetailInfo[] getMaterialDetialData(SPCalcParam runParam, String materialID, String exCludeID, String flag) throws EASBizException, BOSException {
        if (null == materialID || null == flag || "".equals(materialID.trim()) || "".equals(flag.trim())) {
            return new SPDetailInfo[0];
        }
        String tableName = flag.equalsIgnoreCase("G") ? runParam.getGrossRequirementTableName() : runParam.getEstimatedQtyTableName();
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT FID, FMATERIALID, FBASEQTY, FREQUIREDDATE FROM ").append(tableName).append(" WHERE FPLANVERSIONID = ? AND FMATERIALID = ?  ").append(" AND FMATERIALID <> ? ").append(" ORDER BY FREQUIREDDATE ASC ");
        IRowSet rs = DbUtil.executeQuery((Context)runParam.getCtx(), (String)sb.toString(), (Object[])new Object[]{runParam.getPlanVersionID(), materialID, exCludeID});
        SPDetailInfo[] detailDatas = new SPDetailInfo[rs.size()];
        int i = 0;
        try {
            while (rs.next()) {
                detailDatas[i++] = SPDetailInfo.readRow(rs, flag);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return detailDatas;
    }

    public static StringBuffer getInsertPartSql(SPCalcParam runParam) throws EASBizException, BOSException {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("Insert Into ").append(runParam.getMrpCalcDetailTableName()).append("(FID,FPlanVersionID,FRunLogID,FPlanningMode,FMRPClassify,FMRPItem,FBillSeqNo,").append("FMaterialID,FBillID,FBillEntryID,FBillDate,FWorkDaySeqID,").append("FBillType,FBillNumber,FBillRowSeq,").append("FAvaliable,FSR,FAllocation,FIndependent,FDependent)");
        return insertSql;
    }
}

