/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.planning.spareparts.app.calculation;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPCalcParam;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPMaterialDataInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class SPMaterialTableDAO {
    public static int getLevelMaterialCount(SPCalcParam runParam) throws EASBizException, BOSException {
        String sql = "select count(*) materialcount from " + runParam.getMaterialTableName() + " where FRunLogID = ? and FLowsetCode = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)runParam.getCtx(), (String)sql, (Object[])new Object[]{runParam.getRunLogID(), new Integer(runParam.getLevel())});
        try {
            if (rs.next() && rs.getObject("materialcount") != null) {
                return rs.getInt("materialcount");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return 0;
    }

    public static List getAllLevelCode(SPCalcParam runParam) throws EASBizException, BOSException {
        ArrayList<Integer> lowerLevelCodeLst = new ArrayList<Integer>(10);
        String sql = "select distinct FLowsetCode from " + runParam.getMaterialTableName() + " where FRunLogID = ? order by FLowsetCode asc";
        IRowSet rs = DbUtil.executeQuery((Context)runParam.getCtx(), (String)sql, (Object[])new Object[]{runParam.getRunLogID()});
        try {
            while (rs.next()) {
                lowerLevelCodeLst.add(new Integer(rs.getInt(1)));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return lowerLevelCodeLst;
    }

    public static List getLevelMaterialIDs(SPCalcParam runParam, int level) throws EASBizException, BOSException {
        String sql = "SELECT FID FROM " + runParam.getUsingMaterialTableName() + " WHERE  FCOMPUTELEVEL = ? ";
        ArrayList<String> idList = new ArrayList<String>();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)runParam.getCtx());
            ps = conn.prepareStatement(sql);
            ps.setInt(1, level);
            rs = ps.executeQuery();
            while (rs.next()) {
                idList.add(rs.getString("FID"));
            }
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return idList;
    }

    public static SPMaterialDataInfo[] getLevelMaterials(SPCalcParam runParam, List idList) throws EASBizException, BOSException {
        if (idList == null || idList.size() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer("SELECT FID,FMATERIALID,FMATERIALNUMBER,FBASEUNITID,FBASEQTYPRC,FONHAND,FQTYMAX,FSAFESTOCK,").append("FBATCHPOLICY,FFIXATIONBATCHQTY,FMINBATCHQTY,FROUNDUPMULTIPLEQTY,FBATCHINCQTY,FRECEIVINGLEADTIME,FFORWARDPROCESSTIME,").append("FBACKWARDPROCESSTIME,FMATERIALINVID,FMATERIALPLANID FROM ").append(runParam.getUsingMaterialTableName()).append(" WHERE ");
        for (int i = 0; i < idList.size(); ++i) {
            sb.append(" FID = ?");
            if (i == idList.size() - 1) continue;
            sb.append(" OR ");
        }
        IRowSet rs = DbUtil.executeQuery((Context)runParam.getCtx(), (String)sb.toString(), (Object[])idList.toArray());
        SPMaterialDataInfo[] materialDatas = new SPMaterialDataInfo[rs.size()];
        int i = 0;
        try {
            while (rs.next()) {
                materialDatas[i++] = SPMaterialDataInfo.readRow(runParam.getCtx(), rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return materialDatas;
    }
}

