/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.planning.spareparts.app.calculation;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPCalcParam;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPDetailInfo;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPResource;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;

public class SPNetReqSaver {
    private ArrayList listInsertData = new ArrayList();
    private String insertSql;
    private int updateCount = 0;
    private int insertCount = 0;
    private SPCalcParam runParam = null;

    public SPNetReqSaver(SPCalcParam runParam) {
        this.runParam = runParam;
        StringBuffer insertSB = new StringBuffer();
        insertSB.append(" INSERT INTO ").append(runParam.getResultTableName()).append(" (FID,FPLANVERSIONID,FRUNLOGID,FMATERIALID,FREQUIREDDATE,FBASEQTY,FBASEUNITID,FBILLNUMBER,FMATERIALINVID,FMATERIALPLANID) ").append(" values (");
        for (int i = 0; i < 9; ++i) {
            insertSB.append("?,");
        }
        insertSB.append("?)");
        this.insertSql = insertSB.toString();
    }

    public void addInsertList(SPDetailInfo data) {
        this.listInsertData.add(data);
    }

    private void executeInsert(String sql) throws EASBizException, BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)this.runParam.getCtx());
            pstmt = conn.prepareStatement(sql);
            int index = 1;
            for (int i = 0; i < this.listInsertData.size(); ++i) {
                index = 1;
                SPDetailInfo detInfo = (SPDetailInfo)this.listInsertData.get(i);
                pstmt.setString(index++, null);
                pstmt.setString(index++, this.runParam.getPlanVersionID());
                pstmt.setString(index++, this.runParam.getRunLogID());
                pstmt.setString(index++, detInfo.getMaterialId());
                pstmt.setTimestamp(index++, new Timestamp(detInfo.getRequiredDate().getTime()));
                pstmt.setBigDecimal(index++, detInfo.getBaseQty());
                pstmt.setString(index++, detInfo.getBaseUnitId());
                pstmt.setString(index++, detInfo.getBillNumber());
                pstmt.setString(index++, detInfo.getMaterialInvId());
                pstmt.setString(index++, detInfo.getMaterialPlanId());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)conn);
    }

    private void clear() {
        this.listInsertData.clear();
    }

    protected String getStepDesc() {
        return MessageFormat.format(SPResource.getString(this.runParam.getCtx(), "SP_BATCHSAVEDETDATA"), String.valueOf(this.updateCount), String.valueOf(this.insertCount));
    }

    protected String getStepNum() {
        return "60.01";
    }

    public int execute(boolean forceSave) throws EASBizException, BOSException {
        int lineCount = 0;
        if (forceSave || this.listInsertData.size() >= 1000) {
            if (this.listInsertData.size() > 0) {
                this.executeInsert(this.insertSql);
            }
            this.insertCount = this.listInsertData.size();
            lineCount = this.updateCount + this.insertCount;
            this.clear();
        }
        return lineCount;
    }
}

