/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.planning.spareparts.app.calculation;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.WorkDateTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.basedata.BalanceAllocationRuleEnum;
import com.kingdee.eas.eqm.basedata.IPlanningHorizon;
import com.kingdee.eas.eqm.basedata.PlanningHorizonEntryCollection;
import com.kingdee.eas.eqm.basedata.PlanningHorizonEntryInfo;
import com.kingdee.eas.eqm.basedata.PlanningHorizonFactory;
import com.kingdee.eas.eqm.basedata.PlanningHorizonInfo;
import com.kingdee.eas.eqm.planning.spareparts.SparePartsPlanException;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPCalcParam;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPDate;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPResource;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPStep;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPUtil;
import com.kingdee.eas.mm.basedata.FactoryCalendarEntryCollection;
import com.kingdee.eas.mm.basedata.FactoryCalendarEntryFactory;
import com.kingdee.eas.mm.basedata.FactoryCalendarEntryInfo;
import com.kingdee.eas.mm.basedata.IFactoryCalendarEntry;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class SPPlanVersionPeriod
extends SPStep {
    @Override
    protected String getStepDesc() {
        return SPResource.getString(this.runParam.getCtx(), "SP_GETPLANVERSIONPERIOD");
    }

    @Override
    protected String getStepNum() {
        return "30.01";
    }

    @Override
    protected Object innerExecute(SPCalcParam runParam) throws EASBizException, BOSException {
        PeriodVO vo;
        int periodLength;
        java.util.Date startDate;
        PlanningHorizonEntryInfo tmpInfo;
        String tableName = null;
        try {
            tableName = SPUtil.createTempTable(runParam.getCtx(), "  CREATE TABLE PLANVERSIONPERIOD (\r\nFID INT NOT NULL,\r\nFPlanVersionID VARCHAR(44) NOT NULL,\r\nFRunLogID VARCHAR(44) NOT NULL,\r\nFSTARTDATE DATETIME NOT NULL,\r\nFENDDATE DATETIME NOT NULL \r\n) ");
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
        runParam.getTempTableList().add(tableName);
        runParam.setPlanVersionSetPeriodTableName(tableName);
        IPlanningHorizon iph = PlanningHorizonFactory.getLocalInstance((Context)runParam.getCtx());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entries.*"));
        PlanningHorizonInfo info = iph.getPlanningHorizonInfo((IObjectPK)new ObjectUuidPK(runParam.getPlanSchemaParam().getInfo().getPlanningHorizon().getId()), sic);
        if (info.isIsEqualCycle()) {
            PlanningHorizonEntryInfo info1;
            PlanningHorizonEntryCollection collection = info.getEntries();
            collection.clear();
            int phLength = info.getHorizonLength();
            int cycleLength = info.getCycleLength();
            BalanceAllocationRuleEnum bare = info.getBalAllocRule();
            int periodLength2 = phLength / cycleLength;
            for (int i = 0; i < periodLength2 - 1; ++i) {
                info1 = new PlanningHorizonEntryInfo();
                info1.setPeriodLength(cycleLength);
                collection.add(info1);
            }
            int mod = phLength % cycleLength;
            if (0 != mod) {
                if (bare == BalanceAllocationRuleEnum.ADDCYCLE) {
                    info1 = new PlanningHorizonEntryInfo();
                    info1.setPeriodLength(cycleLength);
                    collection.add(info1);
                    info1 = new PlanningHorizonEntryInfo();
                    info1.setPeriodLength(cycleLength);
                    collection.add(info1);
                } else if (bare == BalanceAllocationRuleEnum.UNITEATLAST) {
                    info1 = new PlanningHorizonEntryInfo();
                    info1.setPeriodLength(cycleLength + mod);
                    collection.add(info1);
                } else {
                    info1 = new PlanningHorizonEntryInfo();
                    info1.setPeriodLength(cycleLength);
                    collection.add(info1);
                    info1 = new PlanningHorizonEntryInfo();
                    info1.setPeriodLength(mod);
                    collection.add(info1);
                }
            } else {
                info1 = new PlanningHorizonEntryInfo();
                info1.setPeriodLength(cycleLength);
                collection.add(info1);
            }
            info.getEntries().addCollection(collection);
        }
        Calendar beginDate = runParam.getPlanDate().getDate();
        Calendar endDate = null;
        int phLengthAfterAdjust = 0;
        PlanningHorizonEntryCollection collection = info.getEntries();
        int count = collection.size();
        for (int i = 0; i < count; ++i) {
            phLengthAfterAdjust += collection.get(i).getPeriodLength();
        }
        FactoryCalendarVO fcvo = this.getFactoryCalendarCollection(runParam, phLengthAfterAdjust);
        int periodSize = info.getEntries().size();
        ArrayList<PeriodVO> periodVOList = new ArrayList<PeriodVO>();
        if (fcvo.isEmpty()) {
            tmpInfo = null;
            startDate = beginDate.getTime();
            periodLength = 0;
            for (int i = 0; i < periodSize; ++i) {
                tmpInfo = collection.get(i);
                periodLength = tmpInfo.getPeriodLength();
                vo = new PeriodVO();
                vo.setSeq(i);
                vo.setBeginDate(startDate);
                Calendar cal = SPUtil.createCalendar(startDate);
                cal.add(5, periodLength);
                vo.setEndDate(cal.getTime());
                startDate = cal.getTime();
                periodVOList.add(vo);
            }
            SPDate endMRPDate = new SPDate();
            endDate = SPUtil.createCalendar(beginDate.getTime());
            endDate.add(5, phLengthAfterAdjust);
            endMRPDate.setDate(endDate);
            runParam.setMRPEndDate(endMRPDate);
            Calendar displayEndDate = endDate;
            displayEndDate.add(6, -1);
            runParam.setDisplayEndDate(displayEndDate.getTime());
        } else {
            tmpInfo = null;
            startDate = beginDate.getTime();
            if (startDate.compareTo(fcvo.beginDate) > 0) {
                startDate = fcvo.beginDate;
            }
            periodLength = 0;
            for (int i = 0; i < periodSize; ++i) {
                tmpInfo = collection.get(i);
                periodLength = tmpInfo.getPeriodLength();
                vo = new PeriodVO();
                vo.setSeq(i);
                vo.setBeginDate(startDate);
                if (startDate.compareTo(fcvo.getBeginDate()) >= 0 && startDate.compareTo(fcvo.getEndDate()) <= 0) {
                    for (int j = 0; j < periodLength; ++j) {
                        startDate = fcvo.getNextWorkDate(runParam, startDate);
                    }
                    vo.setEndDate(startDate);
                } else if (startDate.compareTo(fcvo.getEndDate()) > 0) {
                    startDate = this.getFactoryCalendarEndDate(runParam, startDate, periodLength).getTime();
                    vo.setEndDate(startDate);
                } else {
                    for (int j = 0; j < periodLength; ++j) {
                        startDate = fcvo.getNextWorkDate(runParam, startDate);
                    }
                    vo.setEndDate(startDate);
                }
                periodVOList.add(vo);
                if (i != periodSize - 1) continue;
                endDate = SPUtil.createCalendar();
                endDate.setTime(vo.getEndDate());
                SPDate endMRPDate = new SPDate();
                Calendar displayEnd = SPUtil.createCalendar();
                java.util.Date displayEndDate = fcvo.getPreWorkDate(runParam, endDate.getTime());
                displayEnd.setTime(displayEndDate);
                endMRPDate.setDate(displayEnd);
                runParam.setMRPEndDate(endMRPDate);
                runParam.setDisplayEndDate(displayEndDate);
            }
        }
        if (periodVOList.isEmpty()) {
            throw new SparePartsPlanException(SparePartsPlanException.PLANVERSIONSETPERIODERROR);
        }
        runParam.setPlanVersionSetPeriodList(periodVOList);
        Connection conn = null;
        PreparedStatement batchStatement = null;
        String sql = "INSERT INTO " + runParam.getPlanVersionSetPeriodTableName() + " (FID,FPlanVersionID,FRunLogID,FSTARTDATE,FENDDATE) " + " VALUES(?,?,?,?,?) ";
        try {
            conn = EJBFactory.getConnection((Context)runParam.getCtx());
            batchStatement = conn.prepareStatement(sql);
            PeriodVO vo2 = null;
            int count2 = periodVOList.size();
            for (int i = 0; i < count2; ++i) {
                vo2 = (PeriodVO)periodVOList.get(i);
                batchStatement.setInt(1, vo2.getSeq());
                batchStatement.setString(2, runParam.getPlanVersionID());
                batchStatement.setString(3, runParam.getRunLogID());
                batchStatement.setTimestamp(4, new Timestamp(vo2.getBeginDate().getTime()));
                batchStatement.setTimestamp(5, new Timestamp(vo2.getEndDate().getTime()));
                batchStatement.addBatch();
            }
            batchStatement.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
        return null;
    }

    protected FactoryCalendarVO getFactoryCalendarCollection(SPCalcParam runParam, int phLength) throws BOSException {
        FactoryCalendarVO vo = new FactoryCalendarVO();
        int workDaySeqID = 0;
        Calendar beginDate = Calendar.getInstance();
        Calendar endDate = Calendar.getInstance();
        int beginSeq = 0;
        int endSeq = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("select t0.fid,t0.fworkDateSeq,t0.fweekSeq,t0.fseq,").append("\r\n").append("t0.fmonthSeq,t0.FNextWorkDaySeq,t0.FPreWorkDaySeq ").append("\r\n").append("from t_mm_factorycalendarentry t0 ,t_mm_factorycalendar t1 ").append("\r\n").append("where t0.fparentid = t1.fid ").append("\r\n").append("and t0.fworkdate = to_date('").append(SPUtil.dateToString(runParam.getPlanDate().getDate().getTime(), "yyyy-MM-dd")).append("') ").append("\r\n").append("and t1.fstorageorgunitid = ? ");
        IRowSet rs = DbUtil.executeQuery((Context)runParam.getCtx(), (String)sql.toString(), (Object[])new Object[]{runParam.getStorageOrgUnitID()});
        try {
            if (rs.next()) {
                workDaySeqID = rs.getInt("fworkDateSeq");
                if (workDaySeqID == 0) {
                    workDaySeqID = rs.getInt("FPreWorkDaySeq");
                    sql.setLength(0);
                    sql.append("select t0.fid,t0.fworkdate,t0.fweekSeq,t0.fmonthSeq,t0.fseq,t0.fworkDateSeq ").append("\r\n").append("from t_mm_factorycalendarentry t0 ,t_mm_factorycalendar t1 ").append("\r\n").append("where t0.fparentid = t1.fid ").append("\r\n").append("and t0.fworkDateSeq = ? ").append("\r\n").append("and t1.fstorageorgunitid = ? ");
                    rs = DbUtil.executeQuery((Context)runParam.getCtx(), (String)sql.toString(), (Object[])new Object[]{new Integer(workDaySeqID), runParam.getStorageOrgUnitID()});
                    if (rs.next()) {
                        rs.getDate("fworkdate", beginDate);
                        beginSeq = rs.getInt("fworkDateSeq");
                    }
                } else {
                    beginDate = runParam.getPlanDate().getDate();
                    beginSeq = workDaySeqID;
                }
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(runParam.getPlanDate().getDate().getTime());
            cal.add(6, phLength);
            java.util.Date endDate1 = cal.getTime();
            sql.setLength(0);
            sql.append("select t0.fid,t0.fworkDateSeq,t0.fweekSeq,t0.fseq,").append("\r\n").append("t0.fmonthSeq,t0.FNextWorkDaySeq,t0.FPreWorkDaySeq ").append("\r\n").append("from t_mm_factorycalendarentry t0 ,t_mm_factorycalendar t1 ").append("\r\n").append("where t0.fparentid = t1.fid ").append("\r\n").append("and t0.fworkdate = to_date('").append(SPUtil.dateToString(endDate1, "yyyy-MM-dd")).append("') ").append("\r\n").append("and t1.fstorageorgunitid = ? ");
            rs = DbUtil.executeQuery((Context)runParam.getCtx(), (String)sql.toString(), (Object[])new Object[]{runParam.getStorageOrgUnitID()});
            if (rs.next()) {
                workDaySeqID = rs.getInt("fworkDateSeq");
                if (workDaySeqID == 0) {
                    workDaySeqID = rs.getInt("FPreWorkDaySeq");
                    sql.setLength(0);
                    sql.append("select t0.fid,t0.fworkdate,t0.fweekSeq,t0.fmonthSeq,t0.fseq,t0.fworkDateSeq ").append("\r\n").append("from t_mm_factorycalendarentry t0 ,t_mm_factorycalendar t1 ").append("\r\n").append("where t0.fparentid = t1.fid ").append("\r\n").append("and t0.fworkDateSeq = ? ").append("\r\n").append("and t1.fstorageorgunitid = ? ");
                    rs = DbUtil.executeQuery((Context)runParam.getCtx(), (String)sql.toString(), (Object[])new Object[]{new Integer(workDaySeqID), runParam.getStorageOrgUnitID()});
                    if (rs.next()) {
                        rs.getDate("fworkdate", endDate);
                        endSeq = rs.getInt("fworkDateSeq");
                    }
                } else {
                    endDate = cal;
                    endSeq = workDaySeqID;
                }
            }
            if (0 != beginSeq || 0 != endSeq) {
                sql.setLength(0);
                sql.append("select min(t0.fworkDateSeq) minSeq,max(t0.fworkDateSeq) maxSeq ").append("\r\n").append("from t_mm_factorycalendarentry t0 ,t_mm_factorycalendar t1 ").append("\r\n").append("where t0.fparentid = t1.fid ").append("\r\n").append("and t0.FDateType=1 and t0.fworkDateSeq <> 0 ").append("\r\n").append("and t1.fstorageorgunitid = ? ");
                rs = DbUtil.executeQuery((Context)runParam.getCtx(), (String)sql.toString(), (Object[])new Object[]{runParam.getStorageOrgUnitID()});
                int minSeq = 0;
                int maxSeq = 0;
                if (rs.next()) {
                    minSeq = rs.getInt("minSeq");
                    maxSeq = rs.getInt("maxSeq");
                }
                if (0 == beginSeq) {
                    beginSeq = minSeq;
                }
                if (0 == endSeq) {
                    endSeq = maxSeq;
                }
                if (0 != beginSeq && 0 != endSeq) {
                    int beginSeq1 = 0;
                    int endSeq1 = 0;
                    sql.setLength(0);
                    sql.append("select t0.fworkdate,t0.fseq ").append("\r\n").append("from t_mm_factorycalendarentry t0 ,t_mm_factorycalendar t1 ").append("\r\n").append("where t0.fparentid = t1.fid ").append("\r\n").append("and t0.FDateType=1 and t0.fworkDateSeq <> 0 ").append("\r\n").append("and t1.fstorageorgunitid = ? and ( t0.fworkDateSeq = ? or t0.fworkDateSeq = ? ) ").append("\r\n").append("order by t0.fworkdate asc  ");
                    rs = DbUtil.executeQuery((Context)runParam.getCtx(), (String)sql.toString(), (Object[])new Object[]{runParam.getStorageOrgUnitID(), new Integer(beginSeq), new Integer(endSeq)});
                    if (rs.next()) {
                        rs.getDate("fworkdate", beginDate);
                        beginSeq1 = rs.getInt("fseq");
                    }
                    if (rs.next()) {
                        rs.getDate("fworkdate", endDate);
                        endSeq1 = rs.getInt("fseq");
                    } else if (beginSeq == endSeq) {
                        endSeq1 = beginSeq1;
                    }
                    IFactoryCalendarEntry ifce = FactoryCalendarEntryFactory.getLocalInstance((Context)runParam.getCtx());
                    EntityViewInfo view = new EntityViewInfo();
                    SelectorItemCollection sic1 = new SelectorItemCollection();
                    sic1.add(new SelectorItemInfo("workDate"));
                    sic1.add(new SelectorItemInfo("workDateSeq"));
                    sic1.add(new SelectorItemInfo("seq"));
                    sic1.add(new SelectorItemInfo("dateType"));
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("parent.storageOrgUnit.id", (Object)runParam.getStorageOrgUnitID(), CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("Seq", (Object)new Integer(beginSeq1), CompareType.GREATER_EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("Seq", (Object)new Integer(endSeq1), CompareType.LESS_EQUALS));
                    SorterItemCollection sic2 = new SorterItemCollection();
                    SorterItemInfo sii = new SorterItemInfo("seq");
                    sii.setSortType(SortType.ASCEND);
                    sic2.add(sii);
                    view.setSelector(sic1);
                    view.setSorter(sic2);
                    view.setFilter(filter);
                    FactoryCalendarEntryCollection collection1 = ifce.getFactoryCalendarEntryCollection(view);
                    vo.setBeginDate(beginDate.getTime());
                    vo.setEndDate(endDate.getTime());
                    vo.setCollection(collection1);
                    vo.toMap();
                    vo.setEmpty(vo.getCollection().size() <= 0);
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return vo;
    }

    protected Calendar getFactoryCalendarEndDate(SPCalcParam runParam, java.util.Date startDate, int phLength) throws BOSException {
        Calendar endDate;
        block10: {
            int workDaySeqID = 0;
            Calendar beginDate = SPUtil.createCalendar();
            endDate = SPUtil.createCalendar();
            StringBuffer sql = new StringBuffer();
            sql.append("select t0.fid,t0.fworkDateSeq,t0.fweekSeq,t0.fseq,").append("\r\n").append("t0.fmonthSeq,t0.FNextWorkDaySeq,t0.FPreWorkDaySeq ").append("\r\n").append("from t_mm_factorycalendarentry t0 ,t_mm_factorycalendar t1 ").append("\r\n").append("where t0.fparentid = t1.fid ").append("\r\n").append("and t0.fworkdate = to_date('").append(SPUtil.dateToString(startDate, "yyyy-MM-dd")).append("') ").append("\r\n").append("and t1.fstorageorgunitid = ? ");
            IRowSet rs = DbUtil.executeQuery((Context)runParam.getCtx(), (String)sql.toString(), (Object[])new Object[]{runParam.getStorageOrgUnitID()});
            try {
                if (rs.next() && (workDaySeqID = rs.getInt("fworkDateSeq")) == 0) {
                    workDaySeqID = rs.getInt("FNextWorkDaySeq");
                    sql.setLength(0);
                    sql.append("select t0.fid,t0.fworkdate,t0.fweekSeq,t0.fmonthSeq,t0.fseq,t0.fworkDateSeq ").append("\r\n").append("from t_mm_factorycalendarentry t0 ,t_mm_factorycalendar t1 ").append("\r\n").append("where t0.fparentid = t1.fid ").append("\r\n").append("and t0.fworkDateSeq = ? ").append("\r\n").append("and t1.fstorageorgunitid = ? ");
                    rs = DbUtil.executeQuery((Context)runParam.getCtx(), (String)sql.toString(), (Object[])new Object[]{new Integer(workDaySeqID), runParam.getStorageOrgUnitID()});
                    if (rs.next()) {
                        startDate = rs.getDate("fworkdate", beginDate);
                    }
                }
                Calendar cal = SPUtil.createCalendar();
                cal.setTime(startDate);
                FactoryCalendarVO fcvo = new FactoryCalendarVO();
                for (int j = 0; j < phLength; ++j) {
                    cal.setTime(fcvo.getNextWorkDate(runParam, cal.getTime()));
                }
                java.util.Date endDate1 = cal.getTime();
                sql.setLength(0);
                sql.append("select t0.fid,t0.fworkDateSeq,t0.fweekSeq,t0.fseq,").append("\r\n").append("t0.fmonthSeq,t0.FNextWorkDaySeq,t0.FPreWorkDaySeq ").append("\r\n").append("from t_mm_factorycalendarentry t0 ,t_mm_factorycalendar t1 ").append("\r\n").append("where t0.fparentid = t1.fid ").append("\r\n").append("and t0.fworkdate = to_date('").append(SPUtil.dateToString(endDate1, "yyyy-MM-dd")).append("') ").append("\r\n").append("and t1.fstorageorgunitid = ? ");
                rs = DbUtil.executeQuery((Context)runParam.getCtx(), (String)sql.toString(), (Object[])new Object[]{runParam.getStorageOrgUnitID()});
                if (rs.next()) {
                    workDaySeqID = rs.getInt("fworkDateSeq");
                    if (workDaySeqID == 0) {
                        workDaySeqID = rs.getInt("FNextWorkDaySeq");
                        sql.setLength(0);
                        sql.append("select t0.fid,t0.fworkdate,t0.fweekSeq,t0.fmonthSeq,t0.fseq,t0.fworkDateSeq ").append("\r\n").append("from t_mm_factorycalendarentry t0 ,t_mm_factorycalendar t1 ").append("\r\n").append("where t0.fparentid = t1.fid ").append("\r\n").append("and t0.fworkDateSeq = ? ").append("\r\n").append("and t1.fstorageorgunitid = ? ");
                        rs = DbUtil.executeQuery((Context)runParam.getCtx(), (String)sql.toString(), (Object[])new Object[]{new Integer(workDaySeqID), runParam.getStorageOrgUnitID()});
                        if (rs.next()) {
                            Date end = rs.getDate("fworkdate", endDate);
                            endDate.setTime(end);
                        }
                    } else {
                        endDate = cal;
                    }
                    break block10;
                }
                throw new SparePartsPlanException(SparePartsPlanException.FACTORYCALENDAR_ERROR);
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return endDate;
    }

    @Override
    protected boolean isNeedUpdateProgress() {
        return true;
    }

    @Override
    protected int getProgressPercent() {
        return 3;
    }

    public static class FactoryCalendarVO {
        private java.util.Date beginDate = null;
        private java.util.Date endDate = null;
        private FactoryCalendarEntryCollection collection = null;
        private Map map = new HashMap();
        private boolean empty = true;

        public boolean isEmpty() {
            return this.empty;
        }

        public void setEmpty(boolean empty) {
            this.empty = empty;
        }

        public java.util.Date getBeginDate() {
            return this.beginDate;
        }

        public void setBeginDate(java.util.Date beginDate) {
            this.beginDate = beginDate;
        }

        public java.util.Date getEndDate() {
            return this.endDate;
        }

        public void setEndDate(java.util.Date endDate) {
            this.endDate = endDate;
        }

        public FactoryCalendarEntryCollection getCollection() {
            return this.collection;
        }

        public void setCollection(FactoryCalendarEntryCollection collection) {
            this.collection = collection;
        }

        public void toMap() {
            FactoryCalendarEntryInfo info = null;
            int count = this.collection.size();
            for (int i = 0; i < count; ++i) {
                info = this.collection.get(i);
                this.map.put(SPUtil.dateToString(info.getWorkDate(), "yyyy-MM-dd"), new Integer(i));
            }
        }

        public java.util.Date getNextWorkDate(SPCalcParam runParam, java.util.Date date) {
            java.util.Date returnDate = date;
            FactoryCalendarEntryInfo info = null;
            boolean flag = false;
            Integer integer = (Integer)this.map.get(SPUtil.dateToString(date, "yyyy-MM-dd"));
            if (null != integer) {
                int count = this.collection.size();
                for (int i = integer + 1; i < count; ++i) {
                    info = this.collection.get(i);
                    returnDate = info.getWorkDate();
                    if (info.getDateType() != WorkDateTypeEnum.WORKDAY) continue;
                    flag = true;
                    break;
                }
            }
            if (!flag) {
                int workDaySeqID = 0;
                Calendar cal = SPUtil.createCalendar();
                cal.setTime(date);
                cal.add(6, 1);
                java.util.Date calDate = cal.getTime();
                StringBuffer sql = new StringBuffer();
                sql.append("select t0.fid,t0.fworkDateSeq,t0.fweekSeq,t0.fseq,").append("\r\n").append("t0.fmonthSeq,t0.FNextWorkDaySeq,t0.FPreWorkDaySeq ").append("\r\n").append("from t_mm_factorycalendarentry t0 ,t_mm_factorycalendar t1 ").append("\r\n").append("where t0.fparentid = t1.fid ").append("\r\n").append("and t0.fworkdate = to_date('").append(SPUtil.dateToString(calDate, "yyyy-MM-dd")).append("') ").append("\r\n").append("and t1.fstorageorgunitid = ? ");
                try {
                    IRowSet rs = DbUtil.executeQuery((Context)runParam.getCtx(), (String)sql.toString(), (Object[])new Object[]{runParam.getStorageOrgUnitID()});
                    if (rs.next()) {
                        workDaySeqID = rs.getInt("fworkDateSeq");
                        if (workDaySeqID == 0) {
                            workDaySeqID = rs.getInt("FNextWorkDaySeq");
                            sql.setLength(0);
                            sql.append("select t0.fid,t0.fworkdate,t0.fweekSeq,t0.fmonthSeq,t0.fseq,t0.fworkDateSeq ").append("\r\n").append("from t_mm_factorycalendarentry t0 ,t_mm_factorycalendar t1 ").append("\r\n").append("where t0.fparentid = t1.fid ").append("\r\n").append("and t0.fworkDateSeq = ? ").append("\r\n").append("and t1.fstorageorgunitid = ? ");
                            rs = DbUtil.executeQuery((Context)runParam.getCtx(), (String)sql.toString(), (Object[])new Object[]{new Integer(workDaySeqID), runParam.getStorageOrgUnitID()});
                            if (rs.next()) {
                                returnDate = rs.getDate("fworkdate", cal);
                            }
                        } else {
                            returnDate = calDate;
                        }
                        flag = true;
                    }
                }
                catch (SQLException e) {
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (null == returnDate || !flag) {
                Calendar cal = SPUtil.createCalendar();
                cal.setTime(date);
                cal.add(5, 1);
                returnDate = cal.getTime();
            }
            return returnDate;
        }

        public java.util.Date getPreWorkDate(SPCalcParam runParam, java.util.Date date) {
            int workDaySeqID = 0;
            Calendar cal = SPUtil.createCalendar();
            cal.setTime(date);
            Calendar calPre = SPUtil.createCalendar();
            calPre.setTime(date);
            java.util.Date returnDate = calPre.getTime();
            StringBuffer sql = new StringBuffer();
            sql.append("select t0.fid,t0.fworkDateSeq,t0.fweekSeq,t0.fseq,").append("\r\n").append("t0.fmonthSeq,t0.FNextWorkDaySeq,t0.FPreWorkDaySeq ").append("\r\n").append("from t_mm_factorycalendarentry t0 ,t_mm_factorycalendar t1 ").append("\r\n").append("where t0.fparentid = t1.fid ").append("\r\n").append("and t0.fworkdate = to_date('").append(SPUtil.dateToString(date, "yyyy-MM-dd")).append("') ").append("\r\n").append("and t1.fstorageorgunitid = ? ");
            try {
                IRowSet rs = DbUtil.executeQuery((Context)runParam.getCtx(), (String)sql.toString(), (Object[])new Object[]{runParam.getStorageOrgUnitID()});
                if (rs.next() && (workDaySeqID = rs.getInt("fworkDateSeq")) == 0) {
                    workDaySeqID = rs.getInt("FNextWorkDaySeq");
                    sql.setLength(0);
                    sql.append("select t0.fid,t0.fworkdate,t0.fweekSeq,t0.fmonthSeq,t0.fseq,t0.fworkDateSeq ").append("\r\n").append("from t_mm_factorycalendarentry t0 ,t_mm_factorycalendar t1 ").append("\r\n").append("where t0.fparentid = t1.fid ").append("\r\n").append("and t0.fworkDateSeq = ? ").append("\r\n").append("and t1.fstorageorgunitid = ? ");
                    rs = DbUtil.executeQuery((Context)runParam.getCtx(), (String)sql.toString(), (Object[])new Object[]{new Integer(workDaySeqID), runParam.getStorageOrgUnitID()});
                    if (rs.next()) {
                        returnDate = rs.getDate("fworkdate", cal);
                    }
                }
            }
            catch (SQLException e) {
            }
            catch (Exception e) {
                // empty catch block
            }
            return returnDate;
        }
    }

    public static class PeriodVO {
        private int seq = 0;
        private java.util.Date beginDate = null;
        private java.util.Date endDate = null;

        public int getSeq() {
            return this.seq;
        }

        public void setSeq(int seq) {
            this.seq = seq;
        }

        public java.util.Date getBeginDate() {
            return this.beginDate;
        }

        public void setBeginDate(java.util.Date beginDate) {
            this.beginDate = beginDate;
        }

        public java.util.Date getEndDate() {
            return this.endDate;
        }

        public void setEndDate(java.util.Date endDate) {
            this.endDate = endDate;
        }
    }
}

