/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.planning.spareparts.app.calculation;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.basedata.ISparepartPlanSchema;
import com.kingdee.eas.eqm.basedata.SparepartPlanSchemaFactory;
import com.kingdee.eas.eqm.basedata.SparepartPlanSchemaInfo;
import com.kingdee.eas.eqm.planning.spareparts.ISparePartsPlanRunLog;
import com.kingdee.eas.eqm.planning.spareparts.SparePartsPlanException;
import com.kingdee.eas.eqm.planning.spareparts.SparePartsPlanRunLogFactory;
import com.kingdee.eas.eqm.planning.spareparts.SparePartsPlanRunLogInfo;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPCalcParam;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPDate;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPPlanSchemaParam;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPResource;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPStep;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;

public class SPRunStart
extends SPStep {
    @Override
    protected int getProgressPercent() {
        return 0;
    }

    @Override
    protected String getStepDesc() {
        StringBuffer sb = new StringBuffer();
        sb.append(SPResource.getString(this.runParam.getCtx(), "SP_START")).append("\r\n").append("runlog nubmer: ").append(this.runParam.getRunLogInfo().getNumber()).append("\r\n").append("planversion number: ").append(this.runParam.getPlanVersion().getNumber()).append("\r\n");
        if (this.runParam.getPlanDate() != null && this.runParam.getPlanDate().getDate() != null) {
            DateFormat sdFormat = BOSLocaleUtil.getDateFormat();
            sb.append("plan date: ").append(sdFormat.format(this.runParam.getPlanDate().getDate().getTime())).append("\r\n");
        }
        return sb.toString();
    }

    @Override
    protected String getStepNum() {
        return "10.01";
    }

    @Override
    protected Object innerExecute(SPCalcParam runParam) throws EASBizException, BOSException {
        runParam.setRunStartTime(new Date());
        this.saveLog();
        ISparepartPlanSchema ips = SparepartPlanSchemaFactory.getLocalInstance((Context)runParam.getCtx());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("billParamEntry.*"));
        sic.add(new SelectorItemInfo("planningHorizon.*"));
        SparepartPlanSchemaInfo info = ips.getSparepartPlanSchemaInfo((IObjectPK)new ObjectUuidPK(runParam.getPlanVersion().getId()), sic);
        SPPlanSchemaParam ssp = new SPPlanSchemaParam(info, runParam.getCtx());
        ssp.doIt();
        runParam.setPlanSchemaParam(ssp);
        return runParam;
    }

    @Override
    protected boolean isNeedUpdateProgress() {
        return false;
    }

    protected boolean isUseFactoryCalendar() {
        boolean flag = false;
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT FID FROM T_MM_FACTORYCALENDAR WHERE FSTORAGEORGUNITID = ? ");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.runParam.getCtx(), (String)sb.toString(), (Object[])new Object[]{this.runParam.getStorageOrgUnitID()});
            if (rs.next()) {
                flag = true;
            }
        }
        catch (BOSException e) {
            logger.error((Object)"error in SPRunStart:isUseFactoryCalendar() ", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)"error in SPRunStart:isUseFactoryCalendar() SQLEXP ", (Throwable)e);
        }
        return flag;
    }

    private void adjustPlanDate() throws EASBizException, BOSException {
        SPDate planDate = new SPDate();
        this.runParam.setUseFactoryCalendar(false);
        if (this.runParam.isUseFactoryCalendar()) {
            block8: {
                Calendar theDate = SPUtil.createCalendar(this.runParam.getRunLogInfo().getPlanDate());
                int workDaySeqID = 0;
                StringBuffer sql = new StringBuffer();
                sql.append("select t0.fid,t0.fworkDateSeq,t0.fweekSeq,").append("\r\n").append("t0.fmonthSeq,t0.FNextWorkDaySeq,t0.FPreWorkDaySeq ").append("\r\n").append("from t_mm_factorycalendarentry t0 ,t_mm_factorycalendar t1 ").append("\r\n").append("where t0.fparentid = t1.fid ").append("\r\n").append("and t0.fworkdate = to_date('").append(SPUtil.dateToString(theDate.getTime(), "yyyy-MM-dd")).append("')").append("\r\n").append("and t1.fstorageorgunitid = ? ");
                IRowSet rs = DbUtil.executeQuery((Context)this.runParam.getCtx(), (String)sql.toString(), (Object[])new Object[]{this.runParam.getStorageOrgUnitID()});
                try {
                    if (rs.next()) {
                        workDaySeqID = rs.getInt("fworkDateSeq");
                        if (workDaySeqID == 0) {
                            workDaySeqID = rs.getInt("FPreWorkDaySeq");
                            sql.setLength(0);
                            sql.append("select t0.fid,t0.fworkdate,t0.fweekSeq,t0.fmonthSeq ").append("\r\n").append("from t_mm_factorycalendarentry t0 ,t_mm_factorycalendar t1 ").append("\r\n").append("where t0.fparentid = t1.fid ").append("\r\n").append("and t0.fworkDateSeq = ? ").append("\r\n").append("and t1.fstorageorgunitid = ? ");
                            rs = DbUtil.executeQuery((Context)this.runParam.getCtx(), (String)sql.toString(), (Object[])new Object[]{new Integer(workDaySeqID), this.runParam.getStorageOrgUnitID()});
                            if (rs.next()) {
                                rs.getDate("fworkdate", theDate);
                                planDate.setCalendarID(rs.getString("fid"));
                                planDate.setDate(theDate);
                                planDate.setWorkDaySeqID(workDaySeqID);
                                planDate.setWeekSeqID(rs.getInt("fweekSeq"));
                                planDate.setMonthSeqID(rs.getInt("fmonthSeq"));
                            }
                        } else {
                            planDate.setCalendarID(rs.getString("fid"));
                            planDate.setDate(theDate);
                            planDate.setWorkDaySeqID(workDaySeqID);
                            planDate.setWeekSeqID(rs.getInt("fweekSeq"));
                            planDate.setMonthSeqID(rs.getInt("fmonthSeq"));
                        }
                        break block8;
                    }
                    throw new SparePartsPlanException(SparePartsPlanException.FACTORYCALENDAR_ERROR);
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
            }
            this.runParam.setPlanDate(planDate);
        } else {
            planDate.setDate(SPUtil.createCalendar(this.runParam.getRunLogInfo().getPlanDate()));
            this.runParam.setPlanDate(planDate);
        }
    }

    private void saveLog() throws EASBizException, BOSException {
        ISparePartsPlanRunLog mrpRunLog = SparePartsPlanRunLogFactory.getLocalInstance(this.runParam.getCtx());
        SparePartsPlanRunLogInfo logValue = this.runParam.getRunLogInfo();
        if (logValue.getId() == null) {
            logValue.setId(BOSUuid.create((BOSObjectType)logValue.getBOSType()));
        }
        logValue.setPercent(0);
        logValue.setDesc(SPResource.getString(this.runParam.getCtx(), "SP_START"));
        logValue.setStartTime(new Date());
        logValue.setName(logValue.getNumber());
        this.adjustPlanDate();
        mrpRunLog.addnew((CoreBaseInfo)logValue);
    }
}

