/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.planning.spareparts.app.calculation;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPCalcParam;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPProgressUpdater;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPResource;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPRunCrush;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.log4j.Logger;

public abstract class SPStep {
    protected static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPStep");
    protected SPCalcParam runParam;
    protected Date beginTime;
    protected Date endTime;

    public Object execute(SPCalcParam runParam) throws EASBizException, BOSException {
        this.runParam = runParam;
        if (!(this instanceof SPRunCrush)) {
            runParam.setCurrentStep(this.getStepNum() + ":" + this.getStepDesc());
        }
        this.logBegin();
        Object ret = this.innerExecute(runParam);
        this.logEnd();
        return ret;
    }

    protected void logBegin() {
        if (logger.isInfoEnabled()) {
            this.beginTime = new Date();
        }
    }

    protected void logEnd() throws BOSException {
        if (logger.isInfoEnabled()) {
            this.endTime = new Date();
            BigDecimal e = new BigDecimal(String.valueOf(this.endTime.getTime()));
            BigDecimal b = new BigDecimal(String.valueOf(this.beginTime.getTime()));
            BigDecimal runSecs = e.subtract(b).divide(new BigDecimal("1000"), 2, 4);
            logger.info((Object)(this.runParam.getRunLogInfo().getNumber() + ":" + this.getStepNum() + ":" + this.getStepDesc() + "," + SPResource.getString(this.runParam.getCtx(), "SYM_RUNTIMES") + "\uff1a" + String.valueOf(runSecs) + "s"));
        }
        if (this.isNeedUpdateProgress()) {
            SPProgressUpdater.updateProgerss(this.runParam, this.getProgressPercent());
        }
    }

    public void logInfo(String msg) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)(this.runParam.getRunLogInfo().getNumber() + ":" + msg));
        }
    }

    protected abstract boolean isNeedUpdateProgress();

    protected abstract int getProgressPercent();

    protected abstract String getStepNum();

    protected abstract String getStepDesc();

    protected abstract Object innerExecute(SPCalcParam var1) throws EASBizException, BOSException;
}

