/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.planning.spareparts.app.calculation;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPResource;
import com.kingdee.eas.framework.report.app.CreateTempTableResult;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public final class SPUtil {
    protected static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.eqm.planning.spareparts.app.calculation.SPUtil");

    public static Calendar createCalendar() {
        Calendar cal = Calendar.getInstance();
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public static Calendar createCalendar(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    public static boolean dateEquals(Calendar d1, Calendar d2) {
        return d1.get(1) == d2.get(1) && d1.get(2) == d2.get(2) && d1.get(5) == d2.get(5);
    }

    public static Calendar copyDate(Calendar d1) {
        Calendar d2 = SPUtil.createCalendar();
        d2.set(d1.get(1), d1.get(2), d1.get(5));
        return d2;
    }

    public static void logBegin(Date beginTime, String msg) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)msg);
        }
    }

    public static void logEnd(Context ctx, Date beginTime, String msg) {
        if (logger.isInfoEnabled()) {
            Date endTime = new Date();
            long runSecs = (endTime.getTime() - beginTime.getTime()) / 1000L;
            logger.info((Object)(msg + "," + SPResource.getString(ctx, "SYM_RUNTIMES") + "\uff1a" + String.valueOf(runSecs) + "s"));
        }
    }

    public static Date formatDate(Date inDate, String hmsvalue) {
        DateFormat format = BOSLocaleUtil.getDateTimeFormat();
        String str = null;
        str = SPUtil.dateToString(inDate, "yyyy-MM-dd") + " " + hmsvalue;
        try {
            return format.parse(str);
        }
        catch (ParseException e) {
            logger.error((Object)e);
            return inDate;
        }
    }

    public static String dateToString(Date inDate, String formatstring) {
        SimpleDateFormat sf = new SimpleDateFormat(formatstring);
        return sf.format(inDate);
    }

    public static String dateToString(Date inDate) {
        DateFormat sf = BOSLocaleUtil.getDateTimeFormat();
        return sf.format(inDate);
    }

    public static String getResourceValue(String name) {
        return name;
    }

    public static String getBosType() {
        return "F94043EF";
    }

    public static int executeUpdate(Context ctx, String sql, Object[] params) throws BOSException {
        int i;
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            for (i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            i = ps.executeUpdate();
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql222 execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        return i;
    }

    public static int executeUpdate(Context ctx, String sql) throws BOSException {
        Connection conn = null;
        Statement statement = null;
        int count = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            count = statement.executeUpdate(sql);
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)("sql 1 sql is:" + sql), (Throwable)exc);
                throw new BOSException("Sql1 execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)conn);
        return count;
    }

    public static String getBizNumber(Context ctx, IObjectValue bizObject, String orgID) throws BOSException, EASBizException {
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        RuleStatus ruleStatus = codingRuleManager.getRuleStatus(bizObject, orgID);
        String number = null;
        if (ruleStatus.isExist()) {
            number = codingRuleManager.getNumber(bizObject, orgID);
        }
        return number;
    }

    public static CreateTempTableResult executeCreateAsSelectInto(Context ctx, String sql, SqlParams parameters) throws BOSException {
        Connection con = null;
        try {
            CreateTempTableResult result;
            con = EJBFactory.getConnection((Context)ctx);
            CreateTempTableResult createTempTableResult = result = DBUtil.executeSelectIntoForTempTable((Context)ctx, (String)sql, (SqlParams)parameters, (Connection)con);
            return createTempTableResult;
        }
        catch (SQLException e) {
            e.setNextException(new SQLException("SQL: " + sql));
            throw new SQLDataException(e);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(null, null, (Connection)con);
        }
    }

    public static String createTempTableIndex(Context ctx, String tableName, String columns, boolean isUnique) throws Exception {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        return pool.createIndex(tableName, columns, false, false);
    }

    public static String createTempTable(Context ctx, String createTableSQL) throws Exception {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        return pool.createTempTable(createTableSQL);
    }

    public static void releaseTempTable(Context ctx, String tableName) {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        pool.releaseTable(tableName);
    }

    public static void releasseAllTmpTable(Context ctx, List tmpTableNameList) {
        String str = null;
        int count = tmpTableNameList.size();
        for (int i = 0; i < count; ++i) {
            str = (String)tmpTableNameList.get(i);
            if (null == str || "".equals(str.trim())) continue;
            SPUtil.releaseTempTable(ctx, str);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releasseAllTmpIdx(Context ctx, List tmpIdxNameList) {
        if (null == tmpIdxNameList || tmpIdxNameList.size() == 0) {
            return;
        }
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            String sql = " DROP INDEX  ";
            String str = "";
            int count = tmpIdxNameList.size();
            for (int i = 0; i < count; ++i) {
                str = (String)tmpIdxNameList.get(i);
                if (null == str || "".equals(str.trim())) continue;
                stmt.addBatch(sql + str);
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
        }
        finally {
            SQLUtils.cleanup(null, (Statement)stmt, (Connection)conn);
        }
    }
}

