/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.planning.util;

import com.kingdee.bos.ctrl.common.variant.ChinaComparator;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.ISortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.icons.ResourceManager;
import com.kingdee.bos.ctrl.kdf.util.render.CellTextIconRender;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.eas.eqm.basedata.EquipmentStatusMontorInfo;
import java.awt.Point;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class CheckingPlanningSortManager
implements ISortManager,
KDTMouseListener {
    protected static final ImageIcon ICON_ASEND = ResourceManager.getImageIcon((String)"bill_icon_6.gif");
    protected static final ImageIcon ICON_DESEND = ResourceManager.getImageIcon((String)"bill_icon_5.gif");
    protected KDTable table;
    public int colIndex = -1;
    protected IBasicRender oldRender;
    protected int sortType = 0;
    protected IBasicRender render;
    protected int clickCount = 2;
    protected int button = 1;
    boolean isSortAuto = true;
    protected List groupSortConfig;
    protected boolean enableSortable = false;

    public CheckingPlanningSortManager(KDTable table) {
        this.table = table;
        if (this.table.getSortMange() != null) {
            this.restoreHeadStyle();
            table.removeKDTMouseListener((KDTMouseListener)this.table.getSortMange());
        }
    }

    public void tableClicked(KDTMouseEvent e) {
        if (e.getButton() == this.getButton() && e.getClickCount() == this.getClickCount() && e.getType() == 0) {
            this.setRefresh(false);
            this.sort(e.getColIndex());
            this.setRefresh(true);
        }
    }

    protected void setRefresh(boolean b) {
        this.table.setRefresh(b);
        if (b) {
            this.table.repaint();
        }
    }

    public void clear() {
        if (this.colIndex != -1 && this.table.getHead() != null && this.table.getHeadRow(0) != null && this.table.getHeadRow(0).getCell(this.colIndex) != null) {
            this.table.getHeadRow(0).getCell(this.colIndex).setRenderer(null);
        }
        this.colIndex = -1;
        this.oldRender = null;
        this.sortType = 0;
    }

    public void sort(int colIndex) {
        IColumn column;
        if (colIndex < 0) {
            return;
        }
        if (this.enableSortable && (column = this.table.getColumn(colIndex)) == null) {
            return;
        }
        int sortType = this.colIndex == colIndex ? this.getNextSortType(this.sortType) : 0;
        this.sort(colIndex, sortType);
    }

    public boolean isSortAuto() {
        return this.isSortAuto;
    }

    public void setSortAuto(boolean isSortAuto) {
        this.isSortAuto = isSortAuto;
    }

    public void addGroup(int from, int to) {
        if (this.groupSortConfig == null) {
            this.groupSortConfig = new ArrayList();
        }
        this.groupSortConfig.add(new Point(from, to));
    }

    public void clearGroup() {
        this.groupSortConfig = null;
    }

    public void sort(int colIndex, int sortType) {
        if (this.isSortAuto()) {
            IColumn column = this.table.getColumn(colIndex);
            if (column == null) {
                return;
            }
            boolean refresh = this.table.isRefresh();
            this.table.setRefresh(false);
            this.changeHeadStatus(this.colIndex, colIndex, sortType);
            List rows = this.table.getBody().getRows();
            if (this.groupSortConfig != null && this.groupSortConfig.size() > 0) {
                this.sortByGroups(colIndex, sortType);
            } else {
                Collections.sort(rows, new TableCellComparator(this.colIndex, sortType));
            }
            this.table.setRefresh(refresh);
        } else {
            this.changeHeadStatus(this.colIndex, colIndex, sortType);
        }
    }

    public void sortByGroups(int colIndex, int sortType) {
        int size = this.groupSortConfig.size();
        for (int i = 0; i < size; ++i) {
            Point scope = (Point)this.groupSortConfig.get(i);
            List rows = this.table.getBody().getRows();
            int rowCount = rows.size();
            ArrayList group = new ArrayList();
            for (int m = scope.x; m <= scope.y && m <= rowCount - 1; ++m) {
                Object row = rows.get(m);
                group.add(row);
            }
            Collections.sort(group, new TableCellComparator(this.colIndex, sortType));
            int n = 0;
            for (int m = scope.x; m <= scope.y; ++m) {
                rows.set(m, group.get(n));
                ++n;
            }
        }
    }

    protected void changeHeadStatus(int oldIndex, int newIndex, int sortType) {
        IRow row = this.table.getHeadRow(0);
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            if (row.getCell(i) == null) continue;
            row.getCell(i).setRenderer(null);
        }
        if (oldIndex == -1) {
            this.colIndex = newIndex;
            this.sortType = sortType;
            this.oldRender = row.getCell(newIndex).getRenderer();
            row.getCell(newIndex).setRenderer(this.getRender(sortType));
        } else if (oldIndex != newIndex) {
            ICell oldCell = row.getCell(oldIndex);
            oldCell.setRenderer(null);
            this.colIndex = newIndex;
            this.sortType = sortType;
            this.oldRender = row.getCell(newIndex).getRenderer();
            row.getCell(newIndex).setRenderer(this.getRender(sortType));
        } else {
            this.sortType = sortType;
            row.getCell(newIndex).setRenderer(this.getRender(sortType));
        }
        this.table.repaint();
    }

    private void restoreHeadStyle() {
        IRow row = this.table.getHeadRow(0);
        if (this.colIndex > -1) {
            ICell oldCell = row.getCell(this.colIndex);
            oldCell.setRenderer(this.oldRender);
        }
    }

    protected int getNextSortType(int sortType) {
        if (sortType == 0) {
            return 1;
        }
        return 0;
    }

    public IBasicRender getRender(int sortType) {
        if (this.render == null) {
            this.render = new CellTextIconRender();
        }
        if (sortType == 0) {
            ((CellTextIconRender)this.render).setIcon((Icon)ICON_ASEND);
        } else {
            ((CellTextIconRender)this.render).setIcon((Icon)ICON_DESEND);
        }
        return this.render;
    }

    public int getButton() {
        return this.button;
    }

    public void setButton(int button) {
        this.button = button;
    }

    public int getClickCount() {
        return this.clickCount;
    }

    public void setClickCount(int clickCount) {
        this.clickCount = clickCount;
    }

    public int getColIndex() {
        return this.colIndex;
    }

    public int getSortType() {
        return this.sortType;
    }

    public boolean isEnableSortable() {
        return this.enableSortable;
    }

    public void setEnableSortable(boolean enableSortable) {
        this.enableSortable = enableSortable;
    }

    class TableCellComparator
    implements Comparator {
        int colIndex = 0;
        int sortType;
        Collator comparator;

        public TableCellComparator(int i, int sortType) {
            this.colIndex = i;
            this.sortType = sortType;
            Comparator c = ChinaComparator.getInstance();
            this.comparator = c instanceof Collator ? (Collator)c : Collator.getInstance(Locale.getDefault());
        }

        public int compare(Object kdtRow1, Object kdtRow2) {
            int result = this.doCompare(kdtRow1, kdtRow2);
            if (this.sortType == 0) {
                return result;
            }
            if (result < 0) {
                return 1;
            }
            if (result > 0) {
                return -1;
            }
            return result;
        }

        public int doCompare(Object kdtRow1, Object kdtRow2) {
            Object o1 = null;
            Object o2 = null;
            Object cell = null;
            if (kdtRow1 != null) {
                cell = ((KDTRow)kdtRow1).getCell(this.colIndex);
            }
            if (cell != null) {
                o1 = cell.getValue();
            }
            if ((cell = kdtRow2 != null ? ((KDTRow)kdtRow2).getCell(this.colIndex) : null) != null) {
                o2 = cell.getValue();
            }
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null && o2 != null) {
                return -1;
            }
            if (o1 != null && o2 == null) {
                return 1;
            }
            if (o1 instanceof Number) {
                if (o2 instanceof Number) {
                    double d2;
                    double d1 = ((Number)o1).doubleValue();
                    if (d1 == (d2 = ((Number)o2).doubleValue())) {
                        return 0;
                    }
                    if (d1 < d2) {
                        return -1;
                    }
                    return 1;
                }
                return o1.toString().compareTo(o2.toString());
            }
            if (o1 instanceof String) {
                if (o2 instanceof String) {
                    return this.comparator.compare(o1, o2);
                }
                return ((String)o1).compareTo(o2.toString());
            }
            if (o1 instanceof Date) {
                if (o2 instanceof Date) {
                    return ((Date)o1).compareTo((Date)o2);
                }
                return o1.toString().compareTo(o2.toString());
            }
            if (o1 instanceof Calendar) {
                if (o2 instanceof Calendar) {
                    long d2;
                    long d1 = ((Calendar)o1).getTimeInMillis();
                    if (d1 == (d2 = ((Calendar)o2).getTimeInMillis())) {
                        return 0;
                    }
                    if (d1 < d2) {
                        return -1;
                    }
                    return 1;
                }
                return o1.toString().compareTo(o2.toString());
            }
            if (o1 instanceof EquipmentStatusMontorInfo) {
                return ((EquipmentStatusMontorInfo)o1).getMeter().getNumber().compareTo(((EquipmentStatusMontorInfo)o2).getMeter().getNumber());
            }
            if (o1 instanceof Comparable) {
                if (o2 instanceof Comparable) {
                    return ((Comparable)o1).compareTo((Comparable)o2);
                }
                return o1.toString().compareTo(o2.toString());
            }
            return o1.toString().compareTo(o2.toString());
        }
    }
}

