/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.eqm.archives.EquipmentBizStatus;
import com.kingdee.eas.eqm.basedata.EquipmentCategoryInfo;
import com.kingdee.eas.eqm.basedata.EquipmentTechLevelInfo;
import com.kingdee.eas.eqm.basedata.EquipmentTypeInfo;
import com.kingdee.eas.eqm.report.util.EQMReportServerUtils;
import com.kingdee.eas.eqm.report.util.ReportUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class EQMAmountDraftAgeReport
extends ReportServerBase {
    private static String RESOURCE_PATH = "com.kingdee.eas.eqm.report.EQMReportResource";
    private static String REPORT_BY_BIZSTATUS = "t.FBizStatus";
    private static String REPORT_BY_ABCIDENTIRY = "t.FAbcIdentify";

    protected IRowSet getReportData(String reportID, RptParams filter) throws Exception {
        return null;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BaseException {
        String storagenumber = "";
        if (filter.getString("storageOrgUnit") != null && !"".equals(filter.getString("storageOrgUnit"))) {
            storagenumber = ReportUtil.StringUtil(filter.getString("storageOrgUnit"));
            StringBuffer sql = new StringBuffer();
            sql.append(" select FName_" + this.getContext().getLocale() + " from T_ORG_Storage storage where  storage.FNumber in(" + storagenumber + ")");
            storagenumber = ReportUtil.getNameByNumber(sql, storagenumber, this.getContext());
        } else {
            storagenumber = "" + EQMReportServerUtils.getResourceString(RESOURCE_PATH, "REPORT_ALL");
        }
        String staticsDate = "";
        if (filter.getString("staticsDate") != null && filter.getString("staticsDate").length() > 0) {
            staticsDate = filter.getString("staticsDate").substring(0, 10);
        }
        ReportTitles titles = new ReportTitles();
        titles.AddTitle(0, EQMReportServerUtils.getResourceString(RESOURCE_PATH, "STORAGE_TITLE") + "\uff1a" + storagenumber);
        titles.AddTitle(1, EQMReportServerUtils.getResourceString(RESOURCE_PATH, "REPORTBIASIS_TIME") + "\uff1a" + staticsDate);
        return titles;
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BaseException {
        String tempTableNameMain;
        String tempTableNameMainInner;
        StringBuffer createTableMainInner = this.getTempTableMaininner(filter);
        StringBuffer createTableMain = this.getTempTableMain(filter);
        try {
            tempTableNameMainInner = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTableMainInner.toString());
            tempTableNameMain = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTableMain.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        Connection conn = null;
        Statement statement1 = null;
        Statement statement2 = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getContext());
            statement1 = conn.createStatement();
            List ins = this.buildSelectResultInner(filter, tempTableNameMainInner);
            if (ins.size() > 0) {
                int count = ins.size();
                for (int j = 0; j < count; ++j) {
                    statement1.addBatch((String)ins.get(j));
                }
                statement1.executeBatch();
                DbUtil.execute((Context)this.getContext(), (String)this.insertTable(tempTableNameMain, filter));
                statement2 = conn.createStatement();
                List list = this.updateTable(tempTableNameMain, tempTableNameMainInner, filter);
                int count2 = list.size();
                for (int i = 0; i < count2; ++i) {
                    statement2.addBatch((String)list.get(i));
                }
                statement2.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement1, (Connection)conn);
                SQLUtils.cleanup(statement2);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement1, (Connection)conn);
        SQLUtils.cleanup(statement2);
        int colIntvalue = new Integer(filter.getString("reportBasis"));
        if (colIntvalue == 5) {
            DbUtil.execute((Context)this.getContext(), (String)this.updateTableForEQMBizStatus(tempTableNameMain, filter));
        }
        if (colIntvalue == 6) {
            DbUtil.execute((Context)this.getContext(), (String)this.updateTableForBizABCStatus(tempTableNameMain, filter));
        }
        DbUtil.execute((Context)this.getContext(), (String)this.insertTableTotal(tempTableNameMain, filter));
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(tempTableNameMainInner);
        return tempTableNameMain;
    }

    private String updateTableForBizABCStatus(String tempTableNameMain, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("update " + tempTableNameMain + " set FreportBasisStr = " + " case FreportBasis when 10 then '" + EQMReportServerUtils.getResourceString(RESOURCE_PATH, "AKEY") + "' when 20 then '" + EQMReportServerUtils.getResourceString(RESOURCE_PATH, "BIMPORTMANT") + "' else '" + EQMReportServerUtils.getResourceString(RESOURCE_PATH, "CCOMMON") + "' end");
        return sql.toString();
    }

    private String updateTableForEQMBizStatus(String tempTableNameMain, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("update " + tempTableNameMain + " set FreportBasisStr = " + " case FreportBasis when 10 then '" + "" + EQMReportServerUtils.getResourceString(RESOURCE_PATH, "ARCHIVE_USE") + "' when 20 then '" + EQMReportServerUtils.getResourceString(RESOURCE_PATH, "ARCHIVE_MAINTAIN") + "' when 30 then '" + EQMReportServerUtils.getResourceString(RESOURCE_PATH, "ARCHIVE_FC") + "' when " + "40 then '" + EQMReportServerUtils.getResourceString(RESOURCE_PATH, "ARCHIVE_SCRAP") + "' when 50 then '" + EQMReportServerUtils.getResourceString(RESOURCE_PATH, "ARCHIVE_SAIL") + "' when 60 then '" + EQMReportServerUtils.getResourceString(RESOURCE_PATH, "ARCHIVE_RENT") + "' when 70 then '" + EQMReportServerUtils.getResourceString(RESOURCE_PATH, "ARCHIVE_GH") + "' when 72 then '" + EquipmentBizStatus.idle.getAlias() + "' when 74 then '" + EquipmentBizStatus.transferred.getAlias() + "' when 76 then '" + EquipmentBizStatus.discontinuation.getAlias() + "' when 78 then '" + EquipmentBizStatus.backup.getAlias() + "' when 80 then '" + EquipmentBizStatus.damaged.getAlias() + "' when 81 then '" + EquipmentBizStatus.repairing.getAlias() + "' else '" + EquipmentBizStatus.other.getAlias() + "' end");
        return sql.toString();
    }

    private String insertTableTotal(String tempTableNameMain, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into " + tempTableNameMain + "(FForOrder,FreportBasisStr,FEQMAmout,FEQMValue ");
        int start = Integer.valueOf(filter.getString("useYearRangeFrom"));
        int end = Integer.valueOf(filter.getString("useYearRangeTo"));
        int range = Integer.valueOf(filter.getString("yearRange"));
        for (int i = start; i < end; i += range) {
            sql.append(",FColAmout" + i + "," + "FColValue" + i + " ");
        }
        sql.append(") (select 2,'" + EQMReportServerUtils.getResourceString(RESOURCE_PATH, "AGGREGATELY") + "',sum(FEQMAmout),sum(FEQMValue)");
        int start_value = Integer.valueOf(filter.getString("useYearRangeFrom"));
        int end_value = Integer.valueOf(filter.getString("useYearRangeTo"));
        int range_value = Integer.valueOf(filter.getString("yearRange"));
        for (int i = start_value; i < end_value; i += range_value) {
            sql.append(",sum(FColAmout" + i + ")," + "sum(FColValue" + i + ") ");
        }
        sql.append("from " + tempTableNameMain + ")");
        return sql.toString();
    }

    private List updateTable(String tempTableNameMain, String tempTableNameMainInner, RptParams filter) {
        StringBuffer sql = new StringBuffer();
        ArrayList<String> list = new ArrayList<String>();
        int start = Integer.valueOf(filter.getString("useYearRangeFrom"));
        int end = Integer.valueOf(filter.getString("useYearRangeTo"));
        int range = Integer.valueOf(filter.getString("yearRange"));
        for (int i = start; i < end; i += range) {
            sql.append("update " + tempTableNameMain + " as temp1 set (" + "FColAmout" + i + ",FColAmoutPer" + i + ",FColValue" + i + ",FColValuePer" + i + ") = " + "(select FColAmout,FColAmoutPer,FColValue,FColValuePer from " + tempTableNameMainInner + " temp2 " + "where temp2.FSEQ = " + i + " " + "and temp2.FreportBasis = temp1.FreportBasis) ");
            list.add(sql.toString());
            sql.setLength(0);
        }
        return list;
    }

    private StringBuffer getTempTableMaininner(RptParams filter) {
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table getEQMAmountDaResultInner ( ");
        if (this.getReportBasis(filter).equals(REPORT_BY_BIZSTATUS) || this.getReportBasis(filter).equals(REPORT_BY_ABCIDENTIRY)) {
            createTable.append("FreportBasis decimal(21,2)  default(0)");
        } else {
            createTable.append("FreportBasis varchar(44) DEFAULT(' ')");
        }
        createTable.append(",Fseq decimal(21,2)  default(0)");
        createTable.append(",FColAmout decimal(21,0)  default(0)");
        createTable.append(",FColAmoutPer decimal(21,2)  default(0)");
        createTable.append(",FColValue decimal(21,2)  default(0)");
        createTable.append(",FColValuePer decimal(21,2)  default(0) ");
        createTable.append(" ) ");
        return createTable;
    }

    private List buildSelectResultInner(RptParams filter, String tempTableNameMainInner) throws BaseException {
        StringBuffer sb = new StringBuffer();
        ArrayList<String> list = new ArrayList<String>();
        int start = Integer.valueOf(filter.getString("useYearRangeFrom"));
        int end = Integer.valueOf(filter.getString("useYearRangeTo"));
        int range = Integer.valueOf(filter.getString("yearRange"));
        String eqmCount = "select count(*) from t_eqm_equipmentarchives t " + this.getTabCondition(filter) + "where " + this.buildWhereFilters(filter);
        String assetValue = "select sum(FAssetValue) from t_eqm_equipmentarchives t " + this.getTabCondition(filter) + "where " + this.buildWhereFilters(filter);
        int count = 0;
        int value = 0;
        String eqmPercent = "0";
        String eqmAssetPercent = "0";
        try {
            IRowSet rs1 = DbUtil.executeQuery((Context)this.getContext(), (String)eqmCount);
            IRowSet rs2 = DbUtil.executeQuery((Context)this.getContext(), (String)assetValue);
            while (rs1.next()) {
                count = rs1.getInt(1);
            }
            while (rs2.next()) {
                value = rs2.getInt(1);
            }
        }
        catch (SQLException e) {
            throw new BaseException();
        }
        if (count > 0) {
            eqmPercent = "round(count(t.fid)*1.0/(select count(*) from t_eqm_equipmentarchives t " + this.getTabCondition(filter) + "where " + this.buildWhereFilters(filter) + ")*100,2) as AmoutPer";
        }
        if (value > 0) {
            eqmAssetPercent = "round(sum(t.FAssetValue)*1.0/(select sum(FAssetValue) from t_eqm_equipmentarchives t " + this.getTabCondition(filter) + "where " + this.buildWhereFilters(filter) + ")*100,2) as EQMValuePer";
        }
        for (int i = start; i < end; i += range) {
            sb.append("Insert Into " + tempTableNameMainInner + " " + "(FreportBasis,Fseq,FColAmout,FColAmoutPer,FColValue,FColValuePer)");
            sb.append(" (select isnull(" + this.getReportBasisForNull(filter) + ")," + i + ", count(t.fid) as EQMAmout" + i + "," + eqmPercent + i + "," + "sum(t.FAssetValue) as EQMValue" + i + "," + eqmAssetPercent + i + " ");
            sb.append(" from t_eqm_equipmentarchives t left join T_ORG_Storage t1 on t.FStorageOrgUnitID=t1.fid left join T_EQM_EquipmentType t2 on t.FTypeID=t2.fid left join T_EQM_EquipmentCategory t3 on t.FCategoryID=t3.fid left join T_EQM_EquipmentTechLevel t4 on t.FTechLevelID=t4.fid left join T_ORG_Admin t5 on t.FUsingDeptID=t5.fid ");
            sb.append("where ");
            sb.append("FLOOR(to_decimal(datediff(to_date(tochar(t.feffectdate,'YYYY-MM-DD HH24:MI:SS')),to_date(tochar(to_date('" + filter.getString("staticsDate") + "'),'YYYY-MM-DD HH24:MI:SS')))*1.0/(60 * 60 * 24))) >= " + i * 365 + " ");
            sb.append("and FLOOR(to_decimal(datediff(to_date(tochar(t.feffectdate,'YYYY-MM-DD HH24:MI:SS')),to_date(tochar(to_date('" + filter.getString("staticsDate") + "'),'YYYY-MM-DD HH24:MI:SS')))*1.0/(60 * 60 * 24))) < " + (i + range) * 365 + " and");
            sb.append("" + this.buildWhereFilters(filter));
            sb.append(" group by ");
            sb.append(this.getReportBasis(filter) + " )");
            list.add(sb.toString());
            sb.setLength(0);
        }
        return list;
    }

    private String insertTable(String tempTableNameMain, RptParams filter) throws BaseException {
        StringBuffer sql = new StringBuffer();
        sql.append(" Insert Into " + tempTableNameMain + " (FreportBasis,");
        if (!this.getReportBasis(filter).equals(REPORT_BY_BIZSTATUS) && !this.getReportBasis(filter).equals(REPORT_BY_ABCIDENTIRY)) {
            sql.append("FreportBasisStr,");
        }
        sql.append("FEQMAmout,FAmoutPer,FEQMValue,FEQMValuePer,FAverageYear,FForOrder,");
        int start = Integer.valueOf(filter.getString("useYearRangeFrom"));
        int end = Integer.valueOf(filter.getString("useYearRangeTo"));
        int range = Integer.valueOf(filter.getString("yearRange"));
        int i = start;
        while (i < end) {
            sql.append("FColAmout" + i + "," + "FColAmoutPer" + i + "," + "FColValue" + i + "," + "FColValuePer" + i + "");
            if ((i += range) >= end) continue;
            sql.append(",");
        }
        sql.append(") \n");
        sql.append(this.buildSelectResult(filter));
        return sql.toString();
    }

    public String getReportBasisForNull(RptParams filter) {
        StringBuffer reportBasis_condition = new StringBuffer();
        switch (new Integer(filter.getString("reportBasis"))) {
            case 1: {
                reportBasis_condition.append("t.FStorageOrgUnitID,'11111'");
                break;
            }
            case 3: {
                reportBasis_condition.append("t.FCategoryID,'11111'");
                break;
            }
            case 4: {
                reportBasis_condition.append("t.FTypeID,'11111'");
                break;
            }
            case 7: {
                reportBasis_condition.append("t.FTechLevelID,'11111'");
                break;
            }
            case 6: {
                reportBasis_condition.append("t.FAbcIdentify,11111");
                break;
            }
            case 5: {
                reportBasis_condition.append("t.FBizStatus,11111");
                break;
            }
            default: {
                reportBasis_condition.append("t.FUsingDeptID,'11111'");
            }
        }
        return reportBasis_condition.toString();
    }

    public String getReportBasis(RptParams filter) {
        StringBuffer reportBasis_condition = new StringBuffer();
        switch (new Integer(filter.getString("reportBasis"))) {
            case 1: {
                reportBasis_condition.append("t.FStorageOrgUnitID");
                break;
            }
            case 3: {
                reportBasis_condition.append("t.FCategoryID");
                break;
            }
            case 4: {
                reportBasis_condition.append("t.FTypeID");
                break;
            }
            case 7: {
                reportBasis_condition.append("t.FTechLevelID");
                break;
            }
            case 6: {
                reportBasis_condition.append("t.FAbcIdentify");
                break;
            }
            case 5: {
                reportBasis_condition.append("t.FBizStatus");
                break;
            }
            default: {
                reportBasis_condition.append("t.FUsingDeptID");
            }
        }
        return reportBasis_condition.toString();
    }

    public String getReportBasisDispl(RptParams filter) {
        StringBuffer reportBasis_displ = new StringBuffer();
        switch (new Integer(filter.getString("reportBasis"))) {
            case 1: {
                reportBasis_displ.append(EQMReportServerUtils.getResourceString(RESOURCE_PATH, "STORAGE_TITLE"));
                break;
            }
            case 3: {
                reportBasis_displ.append(EQMReportServerUtils.getResourceString(RESOURCE_PATH, "EQMCATEGORY"));
                break;
            }
            case 4: {
                reportBasis_displ.append(EQMReportServerUtils.getResourceString(RESOURCE_PATH, "EQMTYPE"));
                break;
            }
            case 7: {
                reportBasis_displ.append(EQMReportServerUtils.getResourceString(RESOURCE_PATH, "EQMTECHLEVEL"));
                break;
            }
            case 6: {
                reportBasis_displ.append(EQMReportServerUtils.getResourceString(RESOURCE_PATH, "ABCIDENTIFY"));
                break;
            }
            case 5: {
                reportBasis_displ.append(EQMReportServerUtils.getResourceString(RESOURCE_PATH, "EQMSTATUS"));
                break;
            }
            default: {
                reportBasis_displ.append(EQMReportServerUtils.getResourceString(RESOURCE_PATH, "EQMDEPT"));
            }
        }
        return reportBasis_displ.toString();
    }

    public String getReportBasisDisplDate(RptParams filter) {
        StringBuffer reportBasis_displ = new StringBuffer();
        switch (new Integer(filter.getString("reportBasis"))) {
            case 1: {
                reportBasis_displ.append("t1.fname_" + this.getContext().getLocale());
                break;
            }
            case 3: {
                reportBasis_displ.append("t3.fname_" + this.getContext().getLocale());
                break;
            }
            case 4: {
                reportBasis_displ.append("t2.fname_" + this.getContext().getLocale());
                break;
            }
            case 7: {
                reportBasis_displ.append("t4.fname_" + this.getContext().getLocale());
                break;
            }
            case 6: {
                reportBasis_displ.append("t.FAbcIdentify");
                break;
            }
            case 5: {
                reportBasis_displ.append("t.FBizStatus");
                break;
            }
            default: {
                reportBasis_displ.append("t5.fname_" + this.getContext().getLocale());
            }
        }
        return reportBasis_displ.toString();
    }

    public String getTabCondition(RptParams filter) {
        StringBuffer tab_condition = new StringBuffer();
        tab_condition.append("left join T_ORG_Storage t1 on t.FStorageOrgUnitID=t1.fid left join T_EQM_EquipmentType t2 on t.FTypeID=t2.fid left join T_EQM_EquipmentCategory t3 on t.FCategoryID=t3.fid left join T_EQM_EquipmentTechLevel t4 on t.FTechLevelID=t4.fid left join T_ORG_Admin t5 on t.FUsingDeptID=t5.fid ");
        return tab_condition.toString();
    }

    private Object buildSelectResult(RptParams filter) throws BaseException {
        StringBuffer sb = new StringBuffer();
        String sfilter = "";
        String eqmCount = "(select count(*) from t_eqm_equipmentarchives t " + this.getTabCondition(filter) + "where " + this.buildWhereFilters(filter) + ")";
        String assetValue = "(select sum(FAssetValue) from t_eqm_equipmentarchives t " + this.getTabCondition(filter) + "where " + this.buildWhereFilters(filter) + ")";
        int count = 0;
        int value = 0;
        String eqmPercent = "0";
        String eqmAssetPercent = "0";
        String averageYear = "0";
        try {
            IRowSet rs1 = DbUtil.executeQuery((Context)this.getContext(), (String)eqmCount);
            IRowSet rs2 = DbUtil.executeQuery((Context)this.getContext(), (String)assetValue);
            while (rs1.next()) {
                count = rs1.getInt(1);
            }
            while (rs2.next()) {
                value = rs2.getInt(1);
            }
        }
        catch (SQLException e) {
            throw new BaseException();
        }
        if (count > 0) {
            eqmPercent = "round(count(t.fid)*1.0/(select count(*) from t_eqm_equipmentarchives t " + this.getTabCondition(filter) + "where " + this.buildWhereFilters(filter) + ")*100,2) as AmoutPer";
            averageYear = "round(sum(FLOOR(to_decimal(datediff(dd, to_date(tochar(t.feffectdate,'YYYY-MM-DD HH24:MI:SS')),to_date(tochar(to_date('" + filter.getString("staticsDate") + "'),'YYYY-MM-DD HH24:MI:SS'))))))*1.0/(60 * 60 * 24)/(count(t.fid)*365),1) as AverageYear";
        }
        if (value > 0) {
            eqmAssetPercent = "round(sum(t.FAssetValue)*1.0/(select sum(FAssetValue) from t_eqm_equipmentarchives t " + this.getTabCondition(filter) + "where " + this.buildWhereFilters(filter) + ")*100,2) as EQMValuePer";
        }
        sb.append("select isnull(" + this.getReportBasisForNull(filter) + "),");
        if (!this.getReportBasis(filter).equals(REPORT_BY_BIZSTATUS) && !this.getReportBasis(filter).equals(REPORT_BY_ABCIDENTIRY)) {
            sb.append(this.getReportBasisDisplDate(filter) + ",");
        }
        sb.append("count(t.fid) as EQMAmout," + eqmPercent + "," + "sum(t.FAssetValue) as EQMValue," + eqmAssetPercent + "," + averageYear + "," + "1" + ",");
        int start = Integer.valueOf(filter.getString("useYearRangeFrom"));
        int end = Integer.valueOf(filter.getString("useYearRangeTo"));
        int range = Integer.valueOf(filter.getString("yearRange"));
        int i = start;
        while (i < end) {
            sb.append("0,0,0,0");
            if ((i += range) >= end) continue;
            sb.append(",");
        }
        sb.append(" from t_eqm_equipmentarchives t " + this.getTabCondition(filter) + "where " + this.buildWhereFilters(filter));
        sb.append(" and FLOOR(to_decimal(datediff(dd, to_date(tochar(t.feffectdate,'YYYY-MM-DD HH24:MI:SS')),to_date(tochar(to_date('" + filter.getString("staticsDate") + "'),'YYYY-MM-DD HH24:MI:SS')))*1.0/(60 * 60 * 24))) >= " + start * 365 + " ");
        sb.append("and FLOOR(to_decimal(datediff(dd, to_date(tochar(t.feffectdate,'YYYY-MM-DD HH24:MI:SS')),to_date(tochar(to_date('" + filter.getString("staticsDate") + "'),'YYYY-MM-DD HH24:MI:SS')))*1.0/(60 * 60 * 24))) < " + (end + range) * 365 + "");
        sb.append(" group by ");
        sb.append(this.getReportBasis(filter) + "," + this.getReportBasisDisplDate(filter));
        sfilter = sb.toString();
        return sfilter;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        ReportHeader root = new ReportHeader();
        Hashtable<String, ReportHeader> dctHeader = new Hashtable<String, ReportHeader>();
        dctHeader.put("root", root);
        String headerDispl = this.getReportBasisDispl(filter);
        ReportHeader child = root.addChild("FreportBasisStr", headerDispl);
        dctHeader.put(child.getFieldName(), child);
        child = root.addChild("FEQMAmout", EQMReportServerUtils.getResourceString(RESOURCE_PATH, "EQMAMOUNT"));
        dctHeader.put(child.getFieldName(), child);
        child.setType(2);
        child.setAlign(3);
        child = root.addChild("FAmoutPer", EQMReportServerUtils.getResourceString(RESOURCE_PATH, "EQMAMOUNTPER"));
        dctHeader.put(child.getFieldName(), child);
        child.setType(2);
        child.setAlign(3);
        child.setDecimal(2);
        child = root.addChild("FEQMValue", EQMReportServerUtils.getResourceString(RESOURCE_PATH, "EQMVALUE"));
        dctHeader.put(child.getFieldName(), child);
        child.setType(2);
        child.setAlign(3);
        child.setDecimal(2);
        child = root.addChild("FEQMValuePer", EQMReportServerUtils.getResourceString(RESOURCE_PATH, "EQMVALUEPER"));
        dctHeader.put(child.getFieldName(), child);
        child.setType(2);
        child.setAlign(3);
        child.setDecimal(2);
        child = root.addChild("FAverageYear", EQMReportServerUtils.getResourceString(RESOURCE_PATH, "EQMAVYEAR"));
        dctHeader.put(child.getFieldName(), child);
        child.setType(2);
        child.setAlign(3);
        child.setDecimal(1);
        int start = Integer.valueOf(filter.getString("useYearRangeFrom"));
        int end = Integer.valueOf(filter.getString("useYearRangeTo"));
        int range = Integer.valueOf(filter.getString("yearRange"));
        for (int i = start; i < end; i += range) {
            child = i > end || i + range >= end ? root.addChild("FRANGEHEADER" + i, EQMReportServerUtils.getResourceString(RESOURCE_PATH, "REPORT_USEING") + i + "~" + end + EQMReportServerUtils.getResourceString(RESOURCE_PATH, "REPORT_YERA")) : root.addChild("FRANGEHEADER" + i, EQMReportServerUtils.getResourceString(RESOURCE_PATH, "REPORT_USEING") + i + "~" + (i + range) + EQMReportServerUtils.getResourceString(RESOURCE_PATH, "REPORT_YERA"));
            ReportHeader nextChild = child.addChild("FColAmout" + i, EQMReportServerUtils.getResourceString(RESOURCE_PATH, "REPORT_AMOUNT"));
            dctHeader.put(nextChild.getFieldName(), nextChild);
            nextChild.setLevel(2);
            nextChild.setType(2);
            nextChild.setAlign(3);
            nextChild = child.addChild("FColAmoutPer" + i, EQMReportServerUtils.getResourceString(RESOURCE_PATH, "EQMAMOUNTPER"));
            dctHeader.put(nextChild.getFieldName(), nextChild);
            nextChild.setLevel(2);
            nextChild.setType(2);
            nextChild.setAlign(3);
            nextChild.setDecimal(2);
            nextChild = child.addChild("FColValue" + i, EQMReportServerUtils.getResourceString(RESOURCE_PATH, "REPORT_VALUE"));
            dctHeader.put(nextChild.getFieldName(), nextChild);
            nextChild.setLevel(2);
            nextChild.setType(2);
            nextChild.setAlign(3);
            nextChild.setDecimal(2);
            nextChild = child.addChild("FColValuePer" + i, EQMReportServerUtils.getResourceString(RESOURCE_PATH, "EQMVALUEPER"));
            dctHeader.put(nextChild.getFieldName(), nextChild);
            nextChild.setLevel(2);
            nextChild.setType(2);
            nextChild.setAlign(3);
            nextChild.setDecimal(2);
        }
        return root;
    }

    private StringBuffer getTempTableMain(RptParams filter) {
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table getEQMAmountDaResult ( ");
        if (this.getReportBasis(filter).equals(REPORT_BY_BIZSTATUS) || this.getReportBasis(filter).equals(REPORT_BY_ABCIDENTIRY)) {
            createTable.append("FreportBasis decimal(21,2)  default(null)");
        } else {
            createTable.append("FreportBasis varchar(1000) DEFAULT(' ')");
        }
        createTable.append(",FreportBasisStr varchar(1000) DEFAULT(' ')");
        createTable.append(",FEQMAmout decimal(21,0)  default(null)");
        createTable.append(",FAmoutPer decimal(21,2)  default(null)");
        createTable.append(",FEQMValue decimal(21,2)  default(null)");
        createTable.append(",FEQMValuePer decimal(21,2)  default(null)");
        createTable.append(",FAverageYear decimal(21,1) default(null) ");
        createTable.append(",FForOrder int default(0) ");
        int start = Integer.valueOf(filter.getString("useYearRangeFrom"));
        int end = Integer.valueOf(filter.getString("useYearRangeTo"));
        int range = Integer.valueOf(filter.getString("yearRange"));
        for (int i = start; i < end; i += range) {
            createTable.append(",FColAmout" + i + " decimal(21,0) default(null) ");
            createTable.append(",FColAmoutPer" + i + " decimal(21,2) default(null) ");
            createTable.append(",FColValue" + i + " decimal(21,2) default(null) ");
            createTable.append(",FColValuePer" + i + " decimal(21,2) default(null) ");
        }
        createTable.append(" ) ");
        return createTable;
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BaseException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FreportBasisStr,FEQMAmout,FAmoutPer,FEQMValue,FEQMValuePer,FAverageYear,");
        int from = Integer.valueOf(filter.getString("useYearRangeFrom"));
        int to = Integer.valueOf(filter.getString("useYearRangeTo"));
        int range = Integer.valueOf(filter.getString("yearRange"));
        int i = from;
        while (i < to) {
            sql.append("FColAmout" + i + "");
            sql.append(",FColAmoutPer" + i + "");
            sql.append(",FColValue" + i + "");
            sql.append(",FColValuePer" + i + "");
            if ((i += range) >= to) continue;
            sql.append(",");
        }
        sql.append(" FROM " + tableName + " order by FForOrder asc \n");
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString(), (int)start, (int)rows);
        return rs;
    }

    private String buildWhereFilters(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        String sfilter = "";
        if (filter.getString("storageOrgUnit") != null && !"".equals(filter.getString("storageOrgUnit"))) {
            sb.append(" t1.FNumber in(" + ReportUtil.StringUtil(filter.getString("storageOrgUnit")));
            sb.append(")");
        }
        if (filter.getObject("useDepartmentFrom") != null && !"".equals(filter.getObject("useDepartmentFrom"))) {
            sb.append(" and t5.FNumber >='").append(((AdminOrgUnitInfo)filter.getObject("useDepartmentFrom")).getNumber()).append("'");
        }
        if (filter.getObject("useDepartmentTo") != null && !"".equals(filter.getObject("useDepartmentTo"))) {
            sb.append(" and t5.FNumber <='").append(((AdminOrgUnitInfo)filter.getObject("useDepartmentTo")).getNumber()).append("'");
        }
        if (filter.getObject("eqmCategoryFrom") != null && !"".equals(filter.getObject("eqmCategoryFrom"))) {
            sb.append(" and t3.FNumber >='").append(((EquipmentCategoryInfo)filter.getObject("eqmCategoryFrom")).getNumber()).append("'");
        }
        if (filter.getObject("eqmCategoryTo") != null && !"".equals(filter.getObject("eqmCategoryTo"))) {
            sb.append(" and t3.FNumber <='").append(((EquipmentCategoryInfo)filter.getObject("eqmCategoryTo")).getNumber()).append("'");
        }
        if (filter.getObject("eqmTypeFrom") != null && !"".equals(filter.getObject("eqmTypeFrom"))) {
            sb.append(" and t2.FNumber >='").append(((EquipmentTypeInfo)filter.getObject("eqmTypeFrom")).getNumber()).append("'");
        }
        if (filter.getObject("eqmTypeTo") != null && !"".equals(filter.getObject("eqmTypeTo"))) {
            sb.append(" and t2.FNumber <='").append(((EquipmentTypeInfo)filter.getObject("eqmTypeTo")).getNumber()).append("'");
        }
        if (filter.getObject("eqmTechLevelFrom") != null && !"".equals(filter.getObject("eqmTechLevelFrom"))) {
            sb.append(" and t4.FNumber >='").append(((EquipmentTechLevelInfo)filter.getObject("eqmTechLevelFrom")).getNumber()).append("'");
        }
        if (filter.getObject("eqmTechLevelTo") != null && !"".equals(filter.getObject("eqmTechLevelTo"))) {
            sb.append(" and t4.FNumber <='").append(((EquipmentTechLevelInfo)filter.getObject("eqmTechLevelTo")).getNumber()).append("'");
        }
        List statusList = EquipmentBizStatus.getEnumList();
        boolean selectedStatus = false;
        StringBuffer statusSb = new StringBuffer();
        for (int i = 0; i < statusList.size(); ++i) {
            EquipmentBizStatus status = (EquipmentBizStatus)statusList.get(i);
            String key = "kDCheckBox" + status.getName();
            if (!filter.getBoolean(key)) continue;
            selectedStatus = true;
            statusSb.append("t.FBizStatus = " + status.getValue());
            statusSb.append(" or ");
        }
        if (selectedStatus) {
            String statusStr = "";
            if (statusSb.lastIndexOf(" or ") > -1) {
                statusStr = statusSb.substring(0, statusSb.lastIndexOf(" or "));
            }
            sb.append(" and (").append(statusStr).append(") ");
        } else {
            sb.append(" and t.FBizStatus = 999 ");
        }
        if (filter.getBoolean("kDCheckBoxKeyLoc") || filter.getBoolean("kDCheckBoxImportantLoc") || filter.getBoolean("kDCheckBoxGeneralLoc")) {
            sb.append(" and (");
        } else {
            sb.append(" and t.FAbcIdentify = 999");
        }
        if (filter.getBoolean("kDCheckBoxKeyLoc")) {
            sb.append("t.FAbcIdentify = 10");
            if (filter.getBoolean("kDCheckBoxImportantLoc") || filter.getBoolean("kDCheckBoxGeneralLoc")) {
                sb.append(" or ");
            }
        }
        if (filter.getBoolean("kDCheckBoxImportantLoc")) {
            sb.append("t.FAbcIdentify = 20");
            if (filter.getBoolean("kDCheckBoxGeneralLoc")) {
                sb.append(" or ");
            }
        }
        if (filter.getBoolean("kDCheckBoxGeneralLoc")) {
            sb.append("t.FAbcIdentify = 30");
        }
        if (filter.getBoolean("kDCheckBoxKeyLoc") || filter.getBoolean("kDCheckBoxImportantLoc") || filter.getBoolean("kDCheckBoxGeneralLoc")) {
            sb.append(") ");
        }
        sfilter = sb.toString();
        return sfilter;
    }
}

