/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.ArApConstants;
import com.kingdee.eas.fi.arap.app.writeback.handler.BizActionEnum;
import com.kingdee.eas.fi.arap.app.writeback.handler.BizSceneEnum;
import com.kingdee.eas.fi.arap.app.writeback.handler.IWriteBackHandler;
import com.kingdee.eas.fi.arap.app.writeback.handler.WriteBackFactory;
import com.kingdee.eas.fi.cas.BillDisposerAction;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.IPaymentDisposer;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;

public class ApRefundBillDisposer
implements IPaymentDisposer {
    public BigDecimal getCashRebate(Date billDate, BigDecimal apAmount, String srcBillId, String srcBillEntryId) {
        return null;
    }

    public void dispose(Context ctx, BillDisposerAction action) throws BOSException, EASBizException {
        PaymentBillInfo info = (PaymentBillInfo)action.getDestBill();
        if (!SourceTypeEnum.AP.equals((Object)info.getSourceType())) {
            return;
        }
        DisposerActionEnum actionType = action.getActionType();
        if (DisposerActionEnum.PAY.equals((Object)actionType)) {
            this.dispose4Pay(ctx, info);
        }
        if ((DisposerActionEnum.PAY.equals((Object)actionType) || DisposerActionEnum.CANCEL_PAY.equals((Object)actionType)) && !info.isIsTransBill()) {
            this.writeBackSrcBill4Refund(ctx, action);
        }
    }

    public void writeBackSrcBill4Refund(Context ctx, BillDisposerAction action) throws BOSException, EASBizException {
        DisposerActionEnum actionType = action.getActionType();
        BizActionEnum bizAction = DisposerActionEnum.PAY.equals((Object)actionType) ? BizActionEnum.PAY : BizActionEnum.CANCEL_PAY;
        PaymentBillInfo redPayInfo = (PaymentBillInfo)action.getDestBill();
        boolean isPrePay = redPayInfo.getPayBillType().isIsPrePay();
        BizSceneEnum bizScene = isPrePay ? BizSceneEnum.PRE_RECPAY_SCENE : BizSceneEnum.RECPAY_SCENE;
        ArrayList<BOSObjectType> typeList = new ArrayList<BOSObjectType>();
        typeList.add(ArApConstants.PURORDER_TYPE);
        typeList.add(ArApConstants.PURCONTRACT_TYPE);
        typeList.add(ArApConstants.SUBCONTRACT_TYPE);
        typeList.add(ArApConstants.PAYREQUEST_TYPE);
        for (BOSObjectType type : typeList) {
            IWriteBackHandler handler = WriteBackFactory.getRefundWriteBackHandler(type);
            if (null == handler) continue;
            handler.handle(ctx, bizAction, bizScene, (IObjectValue)redPayInfo);
        }
    }

    private void dispose4Pay(Context ctx, PaymentBillInfo destBill) throws BOSException, EASBizException {
        ArApBillFacadeFactory.getLocalInstance((Context)ctx).autoVerify4Refund((CoreBillBaseInfo)destBill);
    }
}

