/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.IEASBillHeadInfo;
import com.kingdee.eas.fi.ap.AbstractPayRequestBillInfo;
import com.kingdee.eas.fi.ap.PayRequestBillEntryCollection;
import com.kingdee.eas.fi.ap.PayRequestBillEntryInfo;
import com.kingdee.eas.fi.ap.PayRequestSumEntryCollection;
import com.kingdee.eas.fi.ap.PayRequestSumEntryInfo;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;

public class PayRequestBillInfo
extends AbstractPayRequestBillInfo
implements Serializable,
IEASBillHeadInfo {
    public PayRequestBillInfo() {
    }

    protected PayRequestBillInfo(String pkField) {
        super(pkField);
    }

    public IObjectCollection getEntries() {
        return this.getEntrys();
    }

    private BOSObjectType getSrcEntryType() {
        if (this.getEntries() == null || this.getEntries().getObject(0) == null) {
            return null;
        }
        PayRequestBillEntryInfo entryInfo = (PayRequestBillEntryInfo)this.getEntries().getObject(0);
        if (StringUtils.isEmpty((String)entryInfo.getSourceBillEntryId())) {
            return null;
        }
        return BOSUuid.read((String)entryInfo.getSourceBillEntryId()).getType();
    }

    public boolean isBotpBill() {
        return this.getSrcEntryType() != null;
    }

    public void lockSumEntrys() {
        this.getEntrys();
        this.getSumEntry();
    }

    public void sumEntrys() {
        PayRequestSumEntryCollection sumEntryColl = this.getSumEntry();
        if (null == sumEntryColl || sumEntryColl.size() == 0) {
            return;
        }
        Iterator sumEntryIterator = sumEntryColl.iterator();
        PayRequestSumEntryInfo sumEntryInfo = null;
        HashMap<String, PayRequestSumEntryInfo> sumEntryMap = new HashMap<String, PayRequestSumEntryInfo>();
        while (sumEntryIterator.hasNext()) {
            sumEntryInfo = (PayRequestSumEntryInfo)sumEntryIterator.next();
            sumEntryInfo.setLockAmount(BigDecimal.ZERO);
            sumEntryInfo.setLockAmountLoc(BigDecimal.ZERO);
            sumEntryInfo.setUnLockAmount(BigDecimal.ZERO);
            sumEntryInfo.setUnLockAmountLoc(BigDecimal.ZERO);
            sumEntryInfo.setPayedAmt(BigDecimal.ZERO);
            sumEntryInfo.setUnpayAmount(BigDecimal.ZERO);
            sumEntryMap.put(sumEntryInfo.getId().toString(), sumEntryInfo);
        }
        PayRequestBillEntryCollection entryColl = this.getEntrys();
        Iterator entryIterator = entryColl.iterator();
        PayRequestBillEntryInfo entryInfo = null;
        while (entryIterator.hasNext()) {
            entryInfo = (PayRequestBillEntryInfo)entryIterator.next();
            sumEntryInfo = (PayRequestSumEntryInfo)sumEntryMap.get(entryInfo.getSumEntryID());
            if (null == sumEntryInfo) continue;
            sumEntryInfo.setLockAmount(sumEntryInfo.getLockAmount().add(entryInfo.getLockAmount()));
            sumEntryInfo.setLockAmountLoc(sumEntryInfo.getLockAmountLoc().add(entryInfo.getLockAmountLoc()));
            sumEntryInfo.setUnLockAmount(sumEntryInfo.getUnLockAmount().add(entryInfo.getUnLockAmount()));
            sumEntryInfo.setUnLockAmountLoc(sumEntryInfo.getUnLockAmountLoc().add(entryInfo.getUnLockAmountLoc()));
            sumEntryInfo.setPayedAmt(sumEntryInfo.getPayedAmt().add(entryInfo.getTotalPayAmt()));
            sumEntryInfo.setUnpayAmount(sumEntryInfo.getUnpayAmount().add(entryInfo.getUnpayAmount()));
            sumEntryMap.put(sumEntryInfo.getId().toString(), sumEntryInfo);
        }
    }

    public boolean isPrePayBill() {
        PayRequestBillEntryCollection entrys = this.getEntrys();
        if (entrys == null || entrys.size() == 0) {
            return false;
        }
        String sourceBillId = entrys.get(0).getSourceBillId();
        if (StringUtils.isEmpty((String)sourceBillId) || !BOSUuid.isValid((String)sourceBillId, (boolean)true)) {
            return false;
        }
        String srcBosType = BOSUuid.read((String)sourceBillId).getType().toString();
        return "78B50853".equals(srcBosType) || "3171BFAD".equals(srcBosType) || "F99EE589".equals(srcBosType);
    }
}

