/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.ARAccountAnalysisParamsCollection;
import com.kingdee.eas.fi.ap.ARAccountAnalysisParamsFactory;
import com.kingdee.eas.fi.ap.ARAccountAnalysisParamsInfo;
import com.kingdee.eas.fi.ap.IARAccountAnalysisParams;
import com.kingdee.eas.fi.ap.app.AbstractARAccountAnalysisParamsControllerBean;
import com.kingdee.eas.fi.arap.app.util.ArApServerUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ARAccountAnalysisParamsControllerBean
extends AbstractARAccountAnalysisParamsControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ap.app.ARAccountAnalysisParamsControllerBean");

    @Override
    protected IObjectCollection _getAnalysisParamCollection(Context ctx, String keyVal, boolean isTotalBill) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSorter().add(new SorterItemInfo("startDay"));
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo arOtherParamFilter = new FilterItemInfo("arOtherParam", (Object)keyVal, CompareType.EQUALS);
        filterInfo.getFilterItems().add(arOtherParamFilter);
        FilterItemInfo IsBillFilter = new FilterItemInfo("isBill", (Object)isTotalBill, CompareType.EQUALS);
        filterInfo.getFilterItems().add(IsBillFilter);
        filterInfo.setMaskString("(#0 and #1)");
        view.setFilter(filterInfo);
        IARAccountAnalysisParams iARAccountAnalysisParams = ARAccountAnalysisParamsFactory.getLocalInstance(ctx);
        ARAccountAnalysisParamsCollection params = iARAccountAnalysisParams.getARAccountAnalysisParamsCollection(view);
        return ARAccountAnalysisParamsControllerBean.resetAccountAge4MutilLanguage(ctx, params);
    }

    public static IObjectCollection resetAccountAge4MutilLanguage(Context ctx, ARAccountAnalysisParamsCollection params) {
        if (null == params || params.size() == 0) {
            return params;
        }
        Locale locale = ctx.getLocale();
        for (int i = 0; i < params.size(); ++i) {
            ARAccountAnalysisParamsInfo param = params.get(i);
            int startDay = param.getStartDay();
            int endDay = param.getEndDay();
            if (startDay == 0 && endDay == 0) {
                param.setAccountAge(ArApServerUtils.getArResource(locale, "217_UNDO", null));
                continue;
            }
            if (startDay != 0 && endDay == 0) {
                param.setAccountAge(ArApServerUtils.getArResource(locale, "218_OverDays", new Object[]{startDay}));
                continue;
            }
            if (endDay == 0) continue;
            param.setAccountAge(ArApServerUtils.getArResource(locale, "Lbl_FUL", new Object[]{startDay, startDay}));
        }
        return params;
    }

    protected IObjectCollection getAgeAnalysisParam(Context ctx, String keyVal, String field, String CPGroupID) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSorter().add(new SorterItemInfo("startDay"));
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo arOtherParamFilter = new FilterItemInfo("arOtherParam", (Object)keyVal, CompareType.EQUALS);
        filterInfo.getFilterItems().add(arOtherParamFilter);
        FilterItemInfo CSSFilter = new FilterItemInfo(field, (Object)CPGroupID, CompareType.EQUALS);
        filterInfo.getFilterItems().add(CSSFilter);
        FilterItemInfo IsBillFilter = new FilterItemInfo("isBill", (Object)Integer.valueOf("0"), CompareType.EQUALS);
        filterInfo.getFilterItems().add(IsBillFilter);
        StringBuffer sbFormula = new StringBuffer("");
        if (filterInfo.getFilterItems() != null && filterInfo.getFilterItems().size() > 0) {
            sbFormula.append("(").append(" ").append("#").append(0).append(" ").append(")").append(" ");
            for (int i = 1; i < filterInfo.getFilterItems().size(); ++i) {
                sbFormula.append("and").append(" ").append("(").append(" ").append("#").append(i).append(" ").append(")").append(" ");
            }
        }
        filterInfo.setMaskString(sbFormula.toString());
        view.setFilter(filterInfo);
        IARAccountAnalysisParams iARAccountAnalysisParams = ARAccountAnalysisParamsFactory.getLocalInstance(ctx);
        ARAccountAnalysisParamsCollection col = iARAccountAnalysisParams.getARAccountAnalysisParamsCollection(view);
        return ARAccountAnalysisParamsControllerBean.resetAccountAge4MutilLanguage(ctx, col);
    }

    @Override
    protected Map _getAnalysisParamMapByCustomer(Context ctx, String keyVal) throws BOSException {
        HashMap<String, IObjectCollection> map = new HashMap<String, IObjectCollection>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "select distinct FCSSPGroupID from T_AR_AnalysisParams where FAROtherParamID = ?";
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, keyVal);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String CSSPGroupID = rs.getString("FCSSPGroupID");
                if (CSSPGroupID == null) continue;
                IObjectCollection objectCollection = this.getAgeAnalysisParam(ctx, keyVal, "CSSPGroupID", CSSPGroupID);
                map.put(CSSPGroupID, objectCollection);
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return map;
    }

    @Override
    protected void _deleteCustomerAgeAanlysis(Context ctx, String otherParamID) throws BOSException {
        Connection connection = null;
        PreparedStatement pstmt = null;
        String sql = "delete from T_AR_AnalysisParams where FArOtherParamID in (select fid from T_BAS_ParamItem where FKeyID in (select fid from T_BAS_Param where FID = ? ))";
        try {
            connection = this.getConnection(ctx);
            pstmt = connection.prepareStatement(sql);
            pstmt.setString(1, otherParamID);
            pstmt.execute();
        }
        catch (SQLException sqle) {
            try {
                throw new BOSException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)connection);
    }

    @Override
    protected Map _getAlyParamByCCSPGroup(Context ctx, String keyVal) throws BOSException {
        HashMap<String, IObjectCollection> map = new HashMap<String, IObjectCollection>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "select distinct FCCSPGroupID from T_AR_AnalysisParams where FAROtherParamID = ?";
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, keyVal);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String CCSPGroupID = rs.getString("FCCSPGroupID");
                if (CCSPGroupID == null) continue;
                IObjectCollection objectCollection = this.getAgeAnalysisParam(ctx, keyVal, "CCSPGroupID", CCSPGroupID);
                map.put(CCSPGroupID, objectCollection);
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return map;
    }

    @Override
    protected String _getCCSPGroupID(Context ctx, String keyVal) throws BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "select distinct FCCSPGroupID from T_AR_AnalysisParams where FAROtherParamID = ?";
        String CCSPGroupID = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, keyVal);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                CCSPGroupID = rs.getString("FCCSPGroupID");
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return CCSPGroupID;
    }

    @Override
    protected boolean _isHasParam(Context ctx, String keyVal, String CCSID) throws BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection conn;
        block4: {
            boolean bl;
            conn = null;
            pstmt = null;
            rs = null;
            String sql = "select FCCSPGroupID from T_AR_AnalysisParams where FCompanyID = ? and FCCSPGroupID = ?";
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, keyVal);
                pstmt.setString(2, CCSID);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block4;
                bl = true;
            }
            catch (SQLException e) {
                try {
                    throw new SQLAccessException(e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return false;
    }

    @Override
    protected List _getCSSID(Context ctx, String keyVal, String ccsID) throws BOSException {
        ArrayList<String> list = new ArrayList<String>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "select FCSSPGroupID from T_AR_AnalysisParams where FAROtherParamID = ? and FCCSPGroupID = ?";
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, keyVal);
            pstmt.setString(2, ccsID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String FCSSPGroupID = rs.getString("FCSSPGroupID");
                list.add(FCSSPGroupID);
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return list;
    }

    @Override
    protected boolean _existCustomerAgeAanlysis(Context ctx, String otherParamID) throws BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection connection;
        block4: {
            boolean bl;
            connection = null;
            pstmt = null;
            rs = null;
            String sql = "select count(0) from T_AR_AnalysisParams where FArOtherParamID in (select fid from T_BAS_ParamItem where FKeyID in (select fid from T_BAS_Param where FID = ? ))";
            try {
                connection = this.getConnection(ctx);
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, otherParamID);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block4;
                bl = true;
            }
            catch (SQLException sqle) {
                try {
                    throw new BOSException((Throwable)sqle);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, pstmt, (Connection)connection);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)connection);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)connection);
        return false;
    }

    @Override
    protected boolean _deleteParamByCondition(Context ctx, Map param) throws BOSException, EASBizException {
        if (null != param.get("companyId") && null != param.get("cssGroupID")) {
            String companyId = param.get("companyId").toString();
            String cssGroupID = param.get("cssGroupID").toString();
            Connection connection = null;
            PreparedStatement pstmt = null;
            String sql = "delete from T_AR_AnalysisParams where FCompanyID = ? and FCCSPGroupID = ?";
            try {
                connection = this.getConnection(ctx);
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, companyId);
                pstmt.setString(2, cssGroupID);
                pstmt.execute();
            }
            catch (SQLException sqle) {
                try {
                    throw new BOSException((Throwable)sqle);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pstmt, (Connection)connection);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)connection);
        }
        return false;
    }
}

