/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.ap.app.AbstractApBalanceFacadeControllerBean;
import com.kingdee.eas.fi.ar.ArApCommonException;
import com.kingdee.eas.fi.ar.app.CaItemAp2PrerecTransSql;
import com.kingdee.eas.fi.ar.app.CaItemApApVPay_PaySql;
import com.kingdee.eas.fi.ar.app.CaItemApArVAp_ApSql;
import com.kingdee.eas.fi.ar.app.CaItemApBillSql;
import com.kingdee.eas.fi.ar.app.CaItemApPrePayVPreRec_PayVRecSql;
import com.kingdee.eas.fi.ar.app.CaItemApPreRecVPrePay_RecVPaySql;
import com.kingdee.eas.fi.ar.app.CaItemApTransSql;
import com.kingdee.eas.fi.ar.app.CaItemApVAr_ArSql;
import com.kingdee.eas.fi.ar.app.CaItemApVPay_ApVArSql;
import com.kingdee.eas.fi.ar.app.CaItemAr2PrepayTransSql;
import com.kingdee.eas.fi.ar.app.CaItemArBillSql;
import com.kingdee.eas.fi.ar.app.CaItemArPrePayVPreRec_PayVRecSql;
import com.kingdee.eas.fi.ar.app.CaItemArPreRecVPrePay_RecVPaySql;
import com.kingdee.eas.fi.ar.app.CaItemArTransSql;
import com.kingdee.eas.fi.ar.app.CaItemArVRec_ArVApSql;
import com.kingdee.eas.fi.ar.app.CaItemArVRec_RecSql;
import com.kingdee.eas.fi.ar.app.CaItemBadAcctSql;
import com.kingdee.eas.fi.ar.app.CaItemBadRecASql;
import com.kingdee.eas.fi.ar.app.CaItemBadRec_BadSql;
import com.kingdee.eas.fi.ar.app.CaItemBadRec_RecSql;
import com.kingdee.eas.fi.ar.app.CaItemPay2ArTransSql;
import com.kingdee.eas.fi.ar.app.CaItemPayBillSql;
import com.kingdee.eas.fi.ar.app.CaItemPayTransSql;
import com.kingdee.eas.fi.ar.app.CaItemRec2ApTransSql;
import com.kingdee.eas.fi.ar.app.CaItemRecBillSql;
import com.kingdee.eas.fi.ar.app.CaItemRecTransSql;
import com.kingdee.eas.fi.ar.app.util.CommonServerUtils;
import com.kingdee.eas.fi.arap.util.CollectionUtil;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class ApBalanceFacadeControllerBean
extends AbstractApBalanceFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ap.ApBalanceFacadeControllerBean");

    @Override
    protected HashMap _getApBalance(Context ctx, IObjectPK companyPK, IObjectPK customerPK) throws BOSException, EASBizException {
        return this.getCreditBal(ctx, companyPK, customerPK, SourceTypeEnum.AP);
    }

    @Override
    protected HashMap _getArBalance(Context ctx, IObjectPK companyPK, IObjectPK customerPK) throws BOSException, EASBizException {
        return this.getCreditBal(ctx, companyPK, customerPK, SourceTypeEnum.AR);
    }

    private HashMap getCreditBal(Context ctx, IObjectPK companyPK, IObjectPK customerPK, SourceTypeEnum source) throws BOSException, EASBizException {
        this.checkParams(companyPK, customerPK);
        CompanyOrgUnitInfo companyInfo = this.getCompanyInfo(ctx, companyPK);
        Set companyIdSet = this.getCompanyIdSet(ctx, companyInfo);
        if (companyIdSet == null || companyIdSet.size() == 0) {
            return null;
        }
        BigDecimal bal = SysConstant.BIGZERO;
        ArrayList<String> customerIds = new ArrayList<String>();
        customerIds.add(customerPK.getKeyValue("id").toString());
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        HashMap<String, BigDecimal> balMap = new HashMap<String, BigDecimal>();
        try {
            con = this.getConnection(ctx);
            String tableName = null;
            String bizAmtSql = null;
            tableName = this.getCompsCustsCreditBalTbl(ctx, null, companyIdSet, customerIds, null, false);
            bizAmtSql = this.balQuery(tableName, companyPK.getKeyValue("id").toString(), customerPK.getKeyValue("id").toString());
            logger.debug((Object)("credit Bal balAmt sql: \r\n" + bizAmtSql));
            pstmt = con.prepareStatement(bizAmtSql);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                balMap.put("Debit", rs.getBigDecimal("FDebit"));
                balMap.put("Credit", rs.getBigDecimal("FCredit"));
                balMap.put("Balance", rs.getBigDecimal("FBalance"));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"error while get the CreditBal(bizCode:)", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)con);
        logger.debug((Object)("bizCodeCreditBal:" + bal));
        return balMap;
    }

    private String balQuery(String tableName, String companyId, String customerId) {
        StringBuffer selectSQL = new StringBuffer();
        selectSQL.append("select FDebit, FCredit, FBalance from \r\n");
        selectSQL.append(tableName);
        selectSQL.append(" where FCompanyId = '").append(companyId).append("' ");
        selectSQL.append(" and FCustomerId = '").append(customerId).append("' ");
        return selectSQL.toString();
    }

    private void checkParams(IObjectPK companyPK, IObjectPK customerPK) throws EASBizException {
        if (companyPK == null || StringUtils.isEmpty((String)companyPK.toString())) {
            throw new ArApCommonException(ArApCommonException.COMPANY_NULL);
        }
        if (customerPK == null || StringUtils.isEmpty((String)customerPK.toString())) {
            throw new ArApCommonException(ArApCommonException.CUSTOMER_NULL);
        }
    }

    private CompanyOrgUnitInfo getCompanyInfo(Context ctx, IObjectPK companyPK) throws BOSException, EASBizException {
        String oql = "select id, isOnlyUnion, longNumber, CU.id where id = '" + companyPK + "' ";
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo companyInfo = iCompany.getCompanyOrgUnitInfo(oql);
        if (companyInfo == null) {
            throw new ArApCommonException(ArApCommonException.COMPANY_NULL);
        }
        return companyInfo;
    }

    private Set getCompanyIdSet(Context ctx, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        Set<Object> companyIds = new HashSet<BOSUuid>();
        boolean fGroup = companyInfo.isIsOnlyUnion();
        if (fGroup) {
            companyIds = this.getSubCompanyIds(ctx, companyInfo.getLongNumber());
        } else {
            companyIds.add(companyInfo.getId());
        }
        return companyIds;
    }

    private Set getSubCompanyIds(Context ctx, String comLongNum) throws BOSException {
        HashSet<String> subIds = new HashSet<String>();
        String sql = "select FId from t_org_company where FLongNumber like ? and FIsLeaf = 1 and FIsOnlyUnion = 0";
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            pstmt = con.prepareStatement(sql);
            pstmt.setString(1, comLongNum + "%");
            rs = pstmt.executeQuery();
            while (rs.next()) {
                subIds.add(rs.getString(1));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return subIds;
    }

    private String getCompanyPeriodTbl(Context ctx, Set companyIds, boolean fAR) throws BOSException, EASBizException {
        String tableDefine = "(FCompanyId varchar(44), FCurrentPeriodId varchar(44), FBeginDate datetime)";
        Connection con = null;
        Statement stmt = null;
        String tmpTableName = null;
        try {
            con = this.getConnection(ctx);
            tmpTableName = CommonServerUtils.createTempTable(ctx, con, "ArCustomersCredit_CompPeriodTbl", tableDefine);
            StringBuffer sql = new StringBuffer();
            sql.append("insert into ").append(tmpTableName).append("\r\n ");
            sql.append("select t1.FCompanyId, t1.FCurrentPeriodId,");
            sql.append(" t4.FBeginDate from T_BD_SystemStatusCtrol t1");
            sql.append(" left join T_BD_SystemStatus t2 on");
            sql.append(" t1.FSystemStatusId = t2.FId left join t_org_company");
            sql.append(" t3 on t1.FCompanyId = t3.FId left join ");
            sql.append(" t_bd_period t4 on t1.FCurrentPeriodId = t4.FId ");
            sql.append("\r\n where t3.FId in (").append(CollectionUtil.ids2SqlString(companyIds));
            sql.append(") and t2.FName = ");
            sql.append(fAR ? 12 : 13);
            sql.append(" and t1.FCurrentPeriodId is not null ");
            stmt = con.createStatement();
            logger.debug((Object)("query companys with periods :\r\n" + sql));
            stmt.execute(sql.toString());
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"get the companys with periods", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)con);
        return tmpTableName;
    }

    private String getCompsCustsCreditBalTbl(Context ctx, CompanyOrgUnitInfo companyInfo, Set companyIdSet, List customerIds, Date endDate, boolean fAR) throws BOSException, EASBizException {
        boolean hasEndDate;
        String sEndNxtDate = null;
        boolean bl = hasEndDate = endDate != null;
        if (hasEndDate) {
            Date endNxtDate = new Date(endDate.getTime() + 86400000L);
            SimpleDateFormat dtFormat = new SimpleDateFormat("yyyy-MM-dd");
            sEndNxtDate = dtFormat.format(endNxtDate);
        }
        String compPeriodTbl = this.getCompanyPeriodTbl(ctx, companyIdSet, fAR);
        String custTbl = this.getCussAcctRange(ctx, null, null, customerIds);
        String custRange = "select Fid from " + custTbl;
        String tempTable = null;
        StringBuffer tmpTableDefine = new StringBuffer();
        tmpTableDefine.append("(FCompanyId varchar(44), ");
        tmpTableDefine.append("FCustomerId varchar(44), ");
        tmpTableDefine.append("FDebit decimal(28, 10) NOT NULL DEFAULT 0, ");
        tmpTableDefine.append("FCredit decimal(28, 10) NOT NULL DEFAULT 0, ");
        tmpTableDefine.append("FBalance decimal(28, 10) NOT NULL DEFAULT 0, ");
        tmpTableDefine.append("FIsFinal int default 0)");
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        PreparedStatement pstmt = null;
        try {
            con = this.getConnection(ctx);
            tempTable = CommonServerUtils.createTempTable(ctx, con, "ArCustomersCreditBalTbl", tmpTableDefine.toString());
            stmt = con.createStatement();
            StringBuffer insPrefix = new StringBuffer();
            insPrefix.append("insert into ").append(tempTable);
            insPrefix.append(" (FCompanyId, FCustomerId, FDebit, ");
            insPrefix.append(" FCredit, FBalance) \r\n");
            StringBuffer sql = new StringBuffer();
            sql.append(insPrefix);
            sql.append(this.customersBalSql(custRange, compPeriodTbl, null, fAR));
            logger.debug((Object)("compCust customers Bal sql 0:\r\n" + sql));
            stmt.execute(sql.toString());
            sql.delete(0, sql.length());
            sql.append(insPrefix);
            sql.append(this.compCustsBizArSql(compPeriodTbl, custRange, hasEndDate, sEndNxtDate, fAR));
            logger.debug((Object)("compCust customers Bal sql 0ar:\r\n" + sql));
            stmt.execute(sql.toString());
            sql.delete(0, sql.length());
            sql.append(insPrefix);
            sql.append(this.compCustsBizApSql(compPeriodTbl, custRange, hasEndDate, sEndNxtDate, fAR));
            logger.debug((Object)("compCust customers Bal sql 0ap:\r\n" + sql));
            stmt.execute(sql.toString());
            StringBuffer sSql = new StringBuffer();
            sSql.append("select t1.FID FQryId, t2.FID FWithSameBizCodeId");
            sSql.append("\r\n from ").append(custTbl).append(" t1 ");
            sSql.append(" left join ").append(custTbl).append(" t2 ");
            sSql.append("\r\n on t1.FBizAnalysisCodeId = t2.FBizAnalysisCodeId");
            sSql.append("\r\n where t1.FId != t2.FId ");
            sSql.append(" and t1.FBizAnalysisCodeId is not null ");
            sSql.append(" and t1.FIsByBizCode = 0 and t2.FIsByBizCode =1");
            String uSql = "update " + tempTable + " set FCustomerId = ? where FCustomerId = ?";
            logger.debug((Object)("compCust mergeData sql 0: \r\n" + uSql));
            pstmt = con.prepareStatement(uSql);
            logger.debug((Object)("compCust merge Data sql 1: \r\n" + sSql));
            rs = stmt.executeQuery(sSql.toString());
            boolean fMerge = false;
            while (rs.next()) {
                pstmt.setString(1, rs.getString(1));
                pstmt.setString(2, rs.getString(2));
                fMerge = true;
                pstmt.addBatch();
            }
            if (fMerge) {
                pstmt.executeBatch();
            }
            sql.delete(0, sql.length());
            sql.append("insert  into ").append(tempTable);
            insPrefix.append(" (FCompanyId, FCustomerId, FDebit, ");
            insPrefix.append(" FCredit, FBalance, FIsFinal) \r\n");
            sql.append(" select FCompanyId, FCustomerId, sum(FDebit) FDebit,");
            sql.append(" sum(FCredit) FCredit, sum(FBalance) ");
            sql.append(" FBalance, 1 FIsFinal \r\n from ").append(tempTable);
            sql.append(" group by FCompanyId, FCustomerId");
            logger.debug((Object)("compCust customers sumBal sql:\r\n" + sql));
            stmt.execute(sql.toString());
            sql.delete(0, sql.length());
            sql.append("delete ").append(tempTable);
            sql.append(" where FIsFinal = 0");
            logger.debug((Object)("compCust customers delTemp sql:\r\n" + sql));
            stmt.execute(sql.toString());
            if (companyInfo != null && companyInfo.isIsOnlyUnion()) {
                sql.delete(0, sql.length());
                sql.append("insert into ").append(tempTable);
                sql.append(" (FCompanyId, FCustomerId, FDebit,");
                sql.append(" FCredit, FBalance, FIsFinal) \r\n");
                sql.append(" select '").append(companyInfo.getId());
                sql.append("' FCompanyId, FCustomerId, ");
                sql.append("sum(FDebit) FDebit, sum(FCredit) FCredit, ");
                sql.append(" sum(FBalance) FBalance, 1 FIsFinal from ");
                sql.append(tempTable);
                sql.append(" group by FCustomerId");
                logger.debug((Object)("compCust sumVirtual company Bal sql 3:\r\n" + sql));
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"prepareArCreditBal execute sql exception. ", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return tempTable;
    }

    private String getCussAcctRange(Context ctx, CompanyOrgUnitInfo companyInfo, Set companyIds, List customerIds) throws BOSException, EASBizException {
        String tableDefine = "(FId varchar(44), FNumber nvarchar(200),  FBizAnalysisCodeId varchar(44), FIsByBizCode int default 0, FIsCust int default 1)";
        Connection con = null;
        Statement stmt = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String tmpTableName = null;
        try {
            con = this.getConnection(ctx);
            tmpTableName = CommonServerUtils.createTempTable(ctx, con, "ArCustomersCredit_CustomerTbl", tableDefine);
            stmt = con.createStatement();
            String sql = null;
            logger.debug((Object)("customerIds " + customerIds.toArray().toString()));
            logger.debug((Object)("customerIds.size()" + customerIds.size()));
            if (customerIds == null || customerIds.size() == 0) {
                sql = "insert into " + tmpTableName + " (FId, FNumber)\r\n" + this.companysCustsSql(ctx, companyInfo, companyIds);
                logger.debug((Object)("insert cust range sql \r\n" + sql));
                stmt.execute(sql);
            } else {
                sql = "insert into " + tmpTableName + " (FId) values (?) ";
                logger.debug((Object)("insert cust range sql \r\n" + sql));
                pstmt = con.prepareStatement(sql);
                int n = customerIds.size();
                for (int i = 0; i < n; ++i) {
                    String id = customerIds.get(i).toString();
                    pstmt.setString(1, id);
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
            }
            StringBuffer uSql = new StringBuffer();
            uSql.append("update ").append(tmpTableName);
            uSql.append(" set FBizAnalysisCodeId = ? ");
            uSql.append(" where FId = ?");
            if (pstmt != null) {
                pstmt.close();
            }
            logger.debug((Object)("set qryCust bizCode sql\r\n" + uSql));
            pstmt = con.prepareStatement(uSql.toString());
            StringBuffer sSql = new StringBuffer();
            sSql.append(" select FBizAnalysisCodeId, FId from ");
            sSql.append(" t_bd_customer ");
            sSql.append(" where FBizAnalysisCodeId is not null");
            sSql.append(" and fid in (select fid from ");
            sSql.append(tmpTableName).append(") ");
            logger.debug((Object)("get custBizCode sql: \r\n" + sSql));
            rs = stmt.executeQuery(sSql.toString());
            boolean fHasBizCode = false;
            while (rs.next()) {
                pstmt.setString(1, rs.getString(1));
                pstmt.setString(2, rs.getString(2));
                pstmt.addBatch();
                fHasBizCode = true;
            }
            if (fHasBizCode) {
                pstmt.executeBatch();
                StringBuffer iSql = new StringBuffer();
                iSql.append("insert into ").append(tmpTableName);
                iSql.append(" (FId, FBizAnalysisCodeId, FNumber,");
                iSql.append(" FIsByBizCode, FIsCust) \r\n");
                iSql.append(" select FId, FBizAnalysisCodeId, ");
                iSql.append(" FNumber, 1, 1 from ");
                iSql.append(" t_bd_customer where FBizAnalysisCodeId in");
                iSql.append("\r\n  (select FBizAnalysisCodeId from ");
                iSql.append(tmpTableName).append(") and FId not in (");
                iSql.append("select FId from ").append(tmpTableName);
                iSql.append(") \r\n union all \r\n");
                iSql.append(" select FId, FBizAnalysisCodeId, ");
                iSql.append(" FNumber, 1, 0 from ");
                iSql.append(" t_bd_supplier where FBizAnalysisCodeId in (");
                iSql.append("select FBizAnalysisCodeId from ");
                iSql.append(tmpTableName);
                iSql.append(") ");
                logger.debug((Object)("ins sameBizCode Sql: \r\n" + iSql));
                stmt.execute(iSql.toString());
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"excpetion while query cussAccts", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt);
                SQLUtils.cleanup(rs, pstmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt);
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return tmpTableName;
    }

    private String companysCustsSql(Context ctx, CompanyOrgUnitInfo companyInfo, Set companyIds) throws BOSException, EASBizException {
        String qryName = "com.kingdee.eas.basedata.master.cssp.app.F7CustomerCompanyQuery";
        MetaDataPK cussQryPK = MetaDataPK.create((String)qryName);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)cussQryPK);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("id");
        view.getSelector().add("number");
        ObjectUuidPK cuPK = new ObjectUuidPK(companyInfo.getCU().getId());
        ICustomer iCust = CustomerFactory.getLocalInstance((Context)ctx);
        FilterInfo cuFilter = iCust.getDatabaseDFilter((IObjectPK)cuPK, "id", "adminCU.id");
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo item = new FilterItemInfo("companyOrgUnit.id", (Object)companyIds, CompareType.INCLUDE);
        FilterItemInfo itemStatus = new FilterItemInfo("usedStatus", (Object)"1");
        filterInfo.getFilterItems().add(itemStatus);
        filterInfo.getFilterItems().add(item);
        filterInfo.mergeFilter(cuFilter, "and");
        view.setFilter(filterInfo);
        exec.setObjectView(view);
        return exec.getSQL();
    }

    private String customersBalSql(String custRange, String comCurrPeriodsTbl, Date endDate, boolean fAR) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select tSum.FCompanyId FCompanyId, tSum.FCustomerId ");
        sql.append("FCustomerId, sum(tSum.FDebit) FDebit,");
        sql.append(" sum(tSum.FCredit) FCredit,");
        sql.append(" sum(tSum.FBalance) FBalance from \r\n(");
        sql.append("  select t1.FCompanyId FCompanyId, ");
        sql.append("t1.FAsstActId FCustomerId, ");
        sql.append(" sum(t1.FBeginBalanceLocal) FDebit, 0 FCredit,");
        sql.append(" sum(t1.FBeginBalanceLocal) FBalance\r\n from ");
        sql.append(fAR ? " t_ar_arBalance" : "t_ap_apBalance");
        sql.append(" t1\r\n inner join ").append(comCurrPeriodsTbl);
        sql.append(" t2 on t1.FCompanyId = t2.FCompanyId and ");
        sql.append(" t1.FPeriodId = t2.FCurrentPeriodId \r\n");
        sql.append("  where 1=1 and t1.FAsstActId in (").append(custRange);
        sql.append(") and t1.FBalType IN (").append(101);
        sql.append(fAR ? ", 104" : "").append(")");
        sql.append("\r\n    group by t1.FCompanyId, t1.FAsstActId");
        sql.append("\r\n  union all \r\n");
        sql.append("  select t1.FCompanyId FCompanyId, ");
        sql.append("  t1.FAsstActId FCustomerId, ");
        sql.append(" 0 FDebit, sum(t1.FBeginBalanceLocal) FCredit,");
        sql.append(" 0-sum(t1.FBeginBalanceLocal) FBalance\r\n from ");
        sql.append(fAR ? " t_ap_apBalance" : "t_ar_arBalance");
        sql.append(" t1\r\n inner join ").append(comCurrPeriodsTbl);
        sql.append(" t2 on t1.FCompanyId = t2.FCompanyId and ");
        sql.append(" t1.FPeriodId = t2.FCurrentPeriodId\r\n where");
        sql.append(" t1.FAsstActId in (").append(custRange);
        sql.append(") and t1.FBalType IN (").append(101);
        sql.append(fAR ? ", 104" : "").append(")");
        sql.append("\r\n    group by t1.FCompanyId, t1.FAsstActId");
        sql.append("\r\n) tSum group by tSum.FCompanyId, tSum.FCustomerId");
        logger.debug((Object)("customersBalSql" + sql.toString()));
        return sql.toString();
    }

    private StringBuffer compCustsBizArSql(String comCurrPeriodsTbl, String custRange, boolean hasEndDate, String sEndNxtDate, boolean fAR) {
        StringBuffer sql = new StringBuffer();
        sql.append("  select tBiz.FCompanyId FCompanyId, ");
        sql.append(" tBiz.FCustomerId FCustomerId, ");
        sql.append(fAR ? "sum(tBiz.FDebit)-sum(tBiz.FCredit)" : "0");
        sql.append(" FDebit, ");
        sql.append(fAR ? "0" : "sum(tBiz.FCredit)-sum(tBiz.FDebit)");
        sql.append(" FCredit, sum(tBiz.FAmt) FBalance from\r\n  (");
        sql.append(new CaItemArBillSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR));
        sql.append(" AND t1.FIsBizBill = 0 ");
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemRecBillSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemBadAcctSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemBadRecASql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemBadRec_BadSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemBadRec_RecSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemArVRec_ArVApSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemArVRec_RecSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemArPreRecVPrePay_RecVPaySql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemApVAr_ArSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemArPrePayVPreRec_PayVRecSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemArTransSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemRecTransSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemAr2PrepayTransSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemRec2ApTransSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR));
        sql.append("\r\n  ) tBiz group by tBiz.FCompanyId, tBiz.FCustomerId");
        logger.debug((Object)("compCustsBizArSql" + sql));
        return sql;
    }

    private String compCustsBizApSql(String comCurrPeriodsTbl, String custRange, boolean hasEndDate, String sEndNxtDate, boolean fAR) {
        StringBuffer sql = new StringBuffer();
        sql.append("  select tBiz.FCompanyId FCompanyId, ");
        sql.append(" tBiz.FCustomerId FCustomerId, ");
        sql.append(fAR ? "0" : "sum(tBiz.FDebit)-sum(tBiz.FCredit)");
        sql.append(" FDebit, ");
        sql.append(fAR ? "sum(tBiz.FCredit)-sum(tBiz.FDebit)" : "0");
        sql.append(" FCredit, sum(tBiz.FAmt) FBalance from\r\n  (");
        sql.append(new CaItemApBillSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR));
        sql.append(" AND t1.FIsBizBill = 0");
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemPayBillSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemApVPay_ApVArSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemApApVPay_PaySql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemApPrePayVPreRec_PayVRecSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemApArVAp_ApSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemApPreRecVPrePay_RecVPaySql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemApTransSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemPayTransSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemAp2PrerecTransSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemPay2ArTransSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR));
        sql.append("\r\n  ) tBiz group by tBiz.FCompanyId, tBiz.FCustomerId");
        logger.debug((Object)("compCustsBizApSql" + sql.toString()));
        return sql.toString();
    }
}

