/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.ap.ApInvoiceEntryCollection;
import com.kingdee.eas.fi.ap.ApInvoiceEntryInfo;
import com.kingdee.eas.fi.ap.ApInvoiceFactory;
import com.kingdee.eas.fi.ap.ApInvoiceInfo;
import com.kingdee.eas.fi.ap.IApInvoice;
import com.kingdee.eas.fi.ap.IOtherBillentry;
import com.kingdee.eas.fi.ap.OtherBillentryFactory;
import com.kingdee.eas.fi.ap.OtherBillentryInfo;
import com.kingdee.eas.fi.ap.app.AbstractApInvoiceControllerBean;
import com.kingdee.eas.fi.ap.app.ApBillAutoInvGenerator;
import com.kingdee.eas.fi.ap.app.ApInvoiceReverser;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.arap.InvoiceException;
import com.kingdee.eas.fi.arap.InvoiceTypeEnum;
import com.kingdee.eas.fi.arap.app.InvoiceValidator;
import com.kingdee.eas.fi.arap.util.ArApParamHelper;
import com.kingdee.eas.fi.arap.util.H;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ApInvoiceControllerBean
extends AbstractApInvoiceControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ap.app.ApInvoiceControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkValid(ctx, model);
        this.setDefaultValue(ctx, model);
        IObjectPK pk = super._submit(ctx, model);
        this._reverseBill(ctx, pk);
        return pk;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ApInvoiceInfo arInvoiceInfo = (ApInvoiceInfo)model;
        if (arInvoiceInfo == null) {
            return null;
        }
        arInvoiceInfo.setBillStatus(BillStatusEnum.SAVE);
        if (arInvoiceInfo.getCU() == null) {
            arInvoiceInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        if (arInvoiceInfo.getNumber() == null || arInvoiceInfo.getNumber().equals("")) {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            String strCompanyID = arInvoiceInfo.getCompany() != null ? arInvoiceInfo.getCompany().getId().toString() : null;
            String orgNumber = null;
            boolean flag = iCodingRuleManager.isExist((IObjectValue)arInvoiceInfo, strCompanyID, "type");
            orgNumber = flag ? iCodingRuleManager.getNumber((IObjectValue)arInvoiceInfo, strCompanyID, "type", "") : arInvoiceInfo.getId().toString();
            arInvoiceInfo.setNumber(orgNumber);
        }
        return super._save(ctx, (IObjectValue)arInvoiceInfo);
    }

    protected void setDefaultValue(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ApInvoiceInfo info = (ApInvoiceInfo)model;
        ApInvoiceEntryCollection entries = info.getEntries();
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            ApInvoiceEntryInfo entryInfo = (ApInvoiceEntryInfo)it.next();
            if (entryInfo.getTaxRate() == null) {
                entryInfo.setTaxRate(SysConstant.BIGZERO);
            }
            if (entryInfo.getTaxAmount() != null) continue;
            entryInfo.setTaxAmount(SysConstant.BIGZERO);
        }
    }

    @Override
    protected void _checkValid(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        InvoiceValidator.checkValid(ctx, model);
        ApInvoiceInfo info = (ApInvoiceInfo)model;
        if (!info.isIsCreatedByElev()) {
            InvoiceValidator.checkNumber(ctx, model);
        }
        this.checkAmt(ctx, model);
        this.checkInvicesLimits(ctx, model);
        info.setBillStatus(BillStatusEnum.SUBMITED);
    }

    private void checkInvicesLimits(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BigDecimal decimalValue;
        ApInvoiceInfo info = (ApInvoiceInfo)model;
        String value = null;
        String companyId = info.getCompany().getId().toString();
        value = InvoiceTypeEnum.VAT.equals((Object)info.getType()) ? ArApParamHelper.getAPInvoicesVATlimits(ctx, companyId) : ArApParamHelper.getAPInvoicesNORMALlimits(ctx, companyId);
        if (value != null && (decimalValue = new BigDecimal(value)).abs().compareTo(SysConstant.BIGZERO) > 0 && this.getAmountTotal(model).abs().compareTo(decimalValue.abs()) > 0) {
            throw new InvoiceException(InvoiceException.INVOICES_LIMITS_SET);
        }
    }

    private BigDecimal getAmountTotal(IObjectValue model) {
        ApInvoiceInfo info = (ApInvoiceInfo)model;
        ApInvoiceEntryCollection entries = info.getEntries();
        Iterator it = entries.iterator();
        BigDecimal totalAmount = SysConstant.BIGZERO;
        BigDecimal amt = SysConstant.BIGZERO;
        while (it.hasNext()) {
            ApInvoiceEntryInfo entryInfo = (ApInvoiceEntryInfo)it.next();
            amt = entryInfo.getAmount();
            if (amt == null) continue;
            totalAmount = totalAmount.add(amt);
        }
        return totalAmount;
    }

    @Override
    protected void _reverseBill(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ApInvoiceReverser reverser = ApInvoiceReverser.getInstance();
        reverser.reverseBill(ctx, pk);
    }

    private void checkAmt(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        Map srcEntryIds = this.summaryInvEntryAmt(model);
        IOtherBillentry iSrcBill = OtherBillentryFactory.getLocalInstance(ctx);
        Set set = srcEntryIds.keySet();
        Iterator it = set.iterator();
        Object srcEntryId = null;
        while (it.hasNext()) {
            srcEntryId = it.next();
            OtherBillentryInfo srcInfo = iSrcBill.getOtherBillentryInfo("select recievePayAmountLocal, invoicedAmt where id = '" + srcEntryId + "'");
            BigDecimal freeInvAmt = srcInfo.getRecievePayAmountLocal().subtract(srcInfo.getInvoicedAmt());
            BigDecimal invAmt = (BigDecimal)srcEntryIds.get(srcEntryId);
            int srcAmtSign = srcInfo.getRecievePayAmountLocal().signum();
            if (srcAmtSign != invAmt.signum()) {
                logger.error((Object)("srcAmt: " + srcInfo.getRecievePayAmountLocal() + ", invAmt: " + invAmt));
                throw new InvoiceException(InvoiceException.AMT_SIGN_DIFF);
            }
            if (srcAmtSign != -1 && invAmt.compareTo(freeInvAmt) == 1) {
                logger.error((Object)(" invoiceAmt: " + invAmt + ", freeInvAmt:" + freeInvAmt));
                throw new InvoiceException(InvoiceException.AMT_GT_FREEINVAMT);
            }
            if (srcAmtSign != -1 || invAmt.compareTo(freeInvAmt) != -1) continue;
            logger.error((Object)(" invoiceAmt: " + invAmt + ", freeInvAmt:" + freeInvAmt));
            throw new InvoiceException(InvoiceException.AMT_LT_FREEINVAMT);
        }
    }

    private Map summaryInvEntryAmt(IObjectValue model) {
        ApInvoiceInfo info = (ApInvoiceInfo)model;
        ApInvoiceEntryCollection entries = info.getEntries();
        Iterator it = entries.iterator();
        Hashtable<BOSUuid, BigDecimal> srcEntryIds = new Hashtable<BOSUuid, BigDecimal>();
        while (it.hasNext()) {
            ApInvoiceEntryInfo entryInfo = (ApInvoiceEntryInfo)it.next();
            if (entryInfo.getSourceBillEntryId() == null) continue;
            if (!srcEntryIds.containsKey(entryInfo.getSourceBillEntryId())) {
                srcEntryIds.put(entryInfo.getSourceBillEntryId(), entryInfo.getActualAmount());
                continue;
            }
            BigDecimal amt = (BigDecimal)srcEntryIds.get(entryInfo.getSourceBillEntryId());
            amt = amt.add(entryInfo.getActualAmount());
        }
        return srcEntryIds;
    }

    @Override
    protected void _blankout(Context ctx, IObjectPK[] pks, boolean fRecycleNum) throws BOSException, EASBizException {
        ArrayList<IObjectPK> pkList = new ArrayList<IObjectPK>();
        int size = pks.length;
        for (int i = 0; i < size; ++i) {
            pkList.add(pks[i]);
        }
        ApInvoiceReverser reverser = ApInvoiceReverser.getInstance();
        reverser.blankout(ctx, pkList, fRecycleNum, true);
    }

    @Override
    protected boolean _isInfoValid(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean fValid = false;
        try {
            this._checkValid(ctx, model);
            fValid = true;
        }
        catch (Exception e) {
            logger.error((Object)"info Validation in wf", (Throwable)e);
        }
        return fValid;
    }

    @Override
    protected boolean _isAutoVat(Context ctx, BOSUuid companyId) throws BOSException, EASBizException {
        return ArApParamHelper.isBillAutoVatInv(ctx, companyId.toString(), false);
    }

    @Override
    protected String _getWFVatBotMappingId(Context ctx) throws BOSException, EASBizException {
        return new ApBillAutoInvGenerator().getWFBotMappingId(ctx);
    }

    @Override
    protected IObjectValue _getVatBotMapping(Context ctx) throws BOSException, EASBizException {
        return new ApBillAutoInvGenerator().getBotMapping(ctx, false, null);
    }

    @Override
    protected String _transVatFromSrcBill(Context ctx, BOSUuid srcBillId, String mappingId) throws BOSException, EASBizException {
        return new ApBillAutoInvGenerator().transVatFromSrcBill(ctx, srcBillId, mappingId);
    }

    @Override
    protected boolean _isVatBotShowUI(Context ctx, String mappingId) throws BOSException, EASBizException {
        return new ApBillAutoInvGenerator().isBotShowUI(ctx, mappingId);
    }

    @Override
    protected BTPTransformResult _transVatFromSrcBills(Context ctx, List srcBillIds, BOSUuid mappingId) throws BOSException, EASBizException {
        return new ApBillAutoInvGenerator().transVatFromSrcBills(ctx, srcBillIds, mappingId);
    }

    @Override
    protected IObjectPK _transSubmit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model != null) {
            ((ApInvoiceInfo)model).setBillStatus(BillStatusEnum.SUBMITED);
        }
        return this._submit(ctx, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IApInvoice iapi = ApInvoiceFactory.getLocalInstance(ctx);
        if (H.same(ctx.get((Object)"revertInvoice"), true) && H.same(H.BOSTYPE(pk), H.BOSTYPE(ApInvoiceInfo.class)) && iapi.exists("where isCreatedByElev=1  and id='" + pk.toString() + "'")) {
            super._delete(ctx, pk);
            return;
        }
        if (!iapi.exists("where billstatus=1 and id='" + pk.toString() + "'")) {
            throw new InvoiceException(InvoiceException.INVOICE_SAVE_BILL_DELETE);
        }
        super._delete(ctx, pk);
    }
}

