/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.server.QueryDataAccessFactory;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.fi.ap.AbstractOtherBillInfo;
import com.kingdee.eas.fi.ap.IOtherBill;
import com.kingdee.eas.fi.ap.OtherBillCollection;
import com.kingdee.eas.fi.ap.OtherBillFactory;
import com.kingdee.eas.fi.ap.OtherBillInfo;
import com.kingdee.eas.fi.ap.OtherBillType;
import com.kingdee.eas.fi.ap.OtherBillentryInfo;
import com.kingdee.eas.fi.ap.VerificateBillTypeEnum;
import com.kingdee.eas.fi.ar.AbstractArApBillBaseInfo;
import com.kingdee.eas.fi.ar.ArApBillBaseInfo;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.arap.app.ARAPImportHelper;
import com.kingdee.eas.fi.arap.app.OtherBillDataImport;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.arap.util.ArApBillUtil;
import com.kingdee.eas.fi.arap.util.BaseDataValidator;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ApOtherBillDataImport
extends OtherBillDataImport {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ap.app.ApOtherBillDataImport");
    private final String[] AP_DECIMAL_FIELDS = new String[]{"FExchangeRate"};
    private final String[] AP_DECIMAL_OBJS = new String[]{"exchangeRate"};
    private final String[] AP_ENTRY_DECIMAL_FIELDS = new String[]{"FEntry_recievePayAmount", "FEntry_recievePayAmountLocal", "FEntry_verifyAmount", "FEntry_verifyAmountLocal", "FEntry_quantity", "FEntry_price", "FEntry_taxPrice", "FEntry_taxRate", "FEntry_taxAmount", "FEntry_taxAmountLocal", "FEntry_actualPrice", "FEntry_discountType", "FEntry_discountRate", "FEntry_discountAmount", "FEntry_discountAmountLocal", "FEntry_amount", "FEntry_amountLocal", "FEntry_assistQty", "FEntry_realPrice"};
    private final String[] AP_ENTRY_DECIMAL_OBJS = new String[]{"recievePayAmount", "recievePayAmountLocal", "verifyAmount", "verifyAmountLocal", "quantity", "price", "taxPrice", "taxRate", "taxAmount", "taxAmountLocal", "actualPrice", "discountType", "discountRate", "discountAmount", "discountAmountLocal", "amount", "amountLocal", "assistQty", "realPrice"};

    @Override
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return OtherBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        Hashtable data = ARAPImportHelper.reverseTableValue(hsData);
        OtherBillInfo head = this.generateApOtherbillInfo(ctx, data);
        head.put("entries", (Object)head.getEntry());
        return head;
    }

    private OtherBillInfo generateApOtherbillInfo(Context ctx, Hashtable tableData) throws TaskExternalException {
        try {
            BaseDataValidator baseDataValidator;
            boolean validate;
            StringBuffer entryErrorMsg = new StringBuffer();
            String errorMsg = "";
            AbstractArApBillBaseInfo head = null;
            OtherBillentryInfo entry = null;
            boolean isUpdateImport = false;
            boolean isExistedBill = false;
            HashMap<Integer, OtherBillentryInfo> entryMap = new HashMap<Integer, OtherBillentryInfo>();
            Enumeration dataEnumeration = tableData.keys();
            IOtherBill iOtherBill = OtherBillFactory.getLocalInstance(ctx);
            String number = null;
            while (dataEnumeration.hasMoreElements()) {
                Object key = dataEnumeration.nextElement();
                Hashtable hsData = (Hashtable)tableData.get(key);
                this.initDatas(ctx, hsData, false);
                number = ARAPImportHelper.getDataString(hsData, "FNumber");
                this.curKey = this.currentCompany.getNumber() + number;
                if (StringUtils.isEmpty((String)number)) {
                    throw new TaskExternalException(ApOtherBillDataImport.getString("NumberNoFound", ctx));
                }
                if (!this.infoMap.containsKey(this.curKey)) {
                    OtherBillCollection otherColl;
                    this.infoMap.clear();
                    if (this.isSltImportUpdate()) {
                        otherColl = iOtherBill.getOtherBillCollection("where number = '" + number + "' and company.number = '" + this.currentCompany.getNumber().toString() + "'");
                        if (otherColl != null && otherColl.size() > 0) {
                            head = otherColl.get(0);
                            isExistedBill = true;
                            if (!BillStatusEnum.SAVE.equals((Object)head.getBillStatus())) {
                                throw new TaskExternalException(ApOtherBillDataImport.getString("BillStatusSave", ctx));
                            }
                        }
                        if (head != null) {
                            if (((AbstractOtherBillInfo)head).getEntry() != null && ((AbstractOtherBillInfo)head).getEntry().size() > 0 && ((AbstractOtherBillInfo)head).getEntry().get(0).getSourceBillId() != null) {
                                errorMsg = ApOtherBillDataImport.getString("CANNOT_OVER_IMPORT", ctx) + ApOtherBillDataImport.getString("AP", "AP_ImportAPBill", ctx);
                                throw new TaskExternalException(errorMsg);
                            }
                            for (int i = 0; i < ((AbstractOtherBillInfo)head).getEntry().size(); ++i) {
                                entry = ((AbstractOtherBillInfo)head).getEntry().get(i);
                                entryMap.put(entry.getSeq(), entry);
                            }
                        }
                    } else if (!this.isSltImportUpdate() && !this.isImportDataByRule && (otherColl = iOtherBill.getOtherBillCollection("where number = '" + number + "' and company.number = '" + this.currentCompany.getNumber().toString() + "'")) != null && otherColl.size() > 0) {
                        throw new TaskExternalException(ApOtherBillDataImport.getString("FBillNumber_IsExist", ctx));
                    }
                    if (head == null) {
                        head = new OtherBillInfo();
                        head.setNumber(number);
                    }
                    head.setCompany(this.currentCompany);
                    this.parseHead(hsData, ctx, (OtherBillInfo)head);
                    this.infoMap.put(this.curKey, head);
                } else {
                    isUpdateImport = true;
                    head = (OtherBillInfo)this.infoMap.get(this.curKey);
                }
                try {
                    entry = this.parseEntry(ctx, hsData, (OtherBillInfo)head, entryMap);
                }
                catch (Exception e) {
                    String seq = ARAPImportHelper.getDataString(hsData, "FSeq");
                    entryErrorMsg.append(ARAPImportHelper.getTempleFieldName(hsData, "FSeq") + " " + seq + ":" + e.getMessage()).append("\r\n");
                    continue;
                }
                if (!this.isImportDataByRule || isUpdateImport || isExistedBill) continue;
                try {
                    ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                    String cid = this.currentCompany.getId().toString();
                    if (iCodingRuleManager.isExist((IObjectValue)head, cid)) {
                        head.setNumber(iCodingRuleManager.getNumber((IObjectValue)head, cid, ""));
                        continue;
                    }
                    throw new TaskExternalException(ApOtherBillDataImport.getString("CodingRule_Error", ctx));
                }
                catch (Exception e) {
                    throw new TaskExternalException(ApOtherBillDataImport.getString("CodingRule_Error", ctx));
                }
            }
            if (entryErrorMsg.length() > 0) {
                throw new TaskExternalException(entryErrorMsg.toString());
            }
            if (!(StringUtils.isEmpty((String)head.getAsstActID()) || this.isInitBill || (validate = (baseDataValidator = new BaseDataValidator(head.getCompany().getId().toString(), QueryDataAccessFactory.getLocalInstance((Context)ctx))).validate(head.getAsstActID())))) {
                BOSUuid uuid = BOSUuid.read((String)head.getAsstActID());
                IObjectValue asscactInfo = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(uuid.getType(), (IObjectPK)new ObjectUuidPK(uuid));
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ARImportData", (String)"ASST_FREEZE", (Locale)ctx.getLocale(), (Object[])new Object[]{asscactInfo.get("name")}));
            }
            this.setBillAmtFromEntry((ArApBillBaseInfo)head);
            ((AbstractOtherBillInfo)head).setThisApAmount(head.getAmount());
            ARAPImportHelper.checkCalculate(ctx, (ArApBillBaseInfo)head, number);
            return head;
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage());
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    private OtherBillentryInfo parseEntry(Context ctx, Hashtable hsData, OtherBillInfo otherBillInfo, Map<Integer, OtherBillentryInfo> entryMap) throws BaseException {
        OtherBillentryInfo entryInfo = null;
        try {
            String[] notNullAmountField = new String[]{"FEntry_amount", "FEntry_amountLocal", "FEntry_recievePayAmount", "FEntry_recievePayAmountLocal"};
            this.checkFieldisNull(ctx, hsData, notNullAmountField);
            String data = ARAPImportHelper.getDataString(hsData, "FSeq");
            if (data != null) {
                int seq = Integer.parseInt(data);
                if (this.isSltImportUpdate() && entryMap.get(seq) != null) {
                    entryInfo = entryMap.get(seq);
                }
                if (entryInfo == null) {
                    entryInfo = new OtherBillentryInfo();
                    entryInfo.setHead(otherBillInfo);
                    entryInfo.setSeq(seq);
                    otherBillInfo.getEntry().add(entryInfo);
                    entryMap.put(seq, entryInfo);
                }
            } else {
                throw new TaskExternalException(ApOtherBillDataImport.getString("EntrySeq_NoFound", ctx));
            }
            entryInfo.setCompany(String.valueOf(otherBillInfo.getCompany().getId()));
            entryInfo.setBillDate(otherBillInfo.getBillDate());
            this.createEntryInfo(ctx, otherBillInfo, entryInfo, hsData);
        }
        catch (NumberFormatException e) {
            String msg = ApOtherBillDataImport.getString("NumberField_Wrong", ctx);
            msg = MessageFormat.format(msg, "FSeq_E");
            throw new TaskExternalException(msg, (Throwable)e);
        }
        return entryInfo;
    }

    private void createEntryInfo(Context ctx, OtherBillInfo otherBillInfo, OtherBillentryInfo entryInfo, Hashtable hsData) throws BaseException {
        int qtyPrecision;
        int i;
        AccountViewInfo account = null;
        String str = null;
        BigDecimal decVal = null;
        CurrencyInfo currency = this.getCurrencyByCache(ctx, hsData, "FCurrency_number");
        int scale = 4;
        if (currency != null) {
            scale = currency.getPrecision();
        }
        int scaleLocal = this.baseCurrency != null ? this.baseCurrency.getPrecision() : scale;
        for (i = 0; i < this.AP_ENTRY_DECIMAL_FIELDS.length; ++i) {
            decVal = ARAPImportHelper.getDataDeciaml(ctx, hsData, this.AP_ENTRY_DECIMAL_FIELDS[i]);
            try {
                if (decVal != null) {
                    if (this.AP_ENTRY_DECIMAL_FIELDS[i].toLowerCase().indexOf("Local".toLowerCase()) != -1) {
                        decVal = decVal.setScale(scaleLocal, 4);
                    } else if (this.AP_ENTRY_DECIMAL_FIELDS[i].toLowerCase().indexOf("Amount".toLowerCase()) != -1) {
                        decVal = decVal.setScale(scale, 4);
                    }
                    if (!this.checkIsPositiveRate(this.AP_ENTRY_DECIMAL_OBJS[i], decVal.toString())) {
                        String msg = ApOtherBillDataImport.getString("NumberField_Wrong", ctx);
                        msg = MessageFormat.format(msg, this.AP_ENTRY_DECIMAL_FIELDS[i]);
                        throw new TaskExternalException(msg);
                    }
                    if (!this.isInitBill && (this.checkIsVerifyamount(this.AP_ENTRY_DECIMAL_OBJS[i]) || this.checkIsVerifyamountLocal(this.AP_ENTRY_DECIMAL_OBJS[i]))) continue;
                    entryInfo.setBigDecimal(this.AP_ENTRY_DECIMAL_OBJS[i], decVal);
                    continue;
                }
                entryInfo.setBigDecimal(this.AP_ENTRY_DECIMAL_OBJS[i], ARAPImportHelper.ZERO);
                continue;
            }
            catch (NumberFormatException nex) {
                String msg = ApOtherBillDataImport.getString("NumberField_Wrong", ctx);
                msg = MessageFormat.format(msg, this.AP_ENTRY_DECIMAL_FIELDS[i]);
                throw new TaskExternalException(msg);
            }
        }
        for (i = 0; i < this.ENTRY_STRING_FIELDS.length; ++i) {
            str = ARAPImportHelper.getDataString(hsData, this.ENTRY_STRING_FIELDS[i]);
            entryInfo.setString(this.ENTRY_STRING_OBJS[i], str);
        }
        entryInfo.setCoreBillEntrySeq(ARAPImportHelper.getCoreBillSeq(ctx, hsData, "FEntry_coreBillEntrySeq"));
        Boolean isQtyZero = this.getDataboolean(hsData, "FEntry_isQtyZero");
        entryInfo.setIsQtyZero(isQtyZero);
        OtherBillType billType = otherBillInfo.getBillType();
        MeasureUnitInfo unit = this.getMeasureUnitInfoByCache(ctx, hsData, "FEntry$measureUnit_number");
        entryInfo.setMeasureUnit(unit);
        MultiMeasureUnitInfo multiUnifInfo = null;
        if (billType.getValue() == 202) {
            qtyPrecision = 4;
            int assistQtyPrecision = 4;
            int pricePrcision = 4;
            MaterialInfo material = this.getMaterialInfoByCache(ctx, hsData, "FEntry$material_number");
            if (material == null) {
                ARAPImportHelper.throwFieldErrorMsg(ctx, hsData, "FEntry$material_number");
            }
            if (unit == null) {
                ARAPImportHelper.throwFieldErrorMsg(ctx, hsData, "FEntry$measureUnit_number");
            }
            if ((multiUnifInfo = this.getMultiMeasureUnitByCache(ctx, unit, material)) != null) {
                qtyPrecision = multiUnifInfo.getQtyPrecision();
            }
            entryInfo.setQuantity(entryInfo.getQuantity().setScale(qtyPrecision, 4));
            pricePrcision = material.getPricePrecision();
            entryInfo.setPrice(entryInfo.getPrice().setScale(pricePrcision, 4));
            entryInfo.setTaxPrice(entryInfo.getTaxPrice().setScale(pricePrcision, 4));
            entryInfo.setMaterial(material);
            entryInfo.setMaterialName(material.getName());
            entryInfo.setBaseUnit(material.getBaseUnit());
            entryInfo.setAssistUnit(material.getAssistUnit());
            entryInfo.setMaterialModel(material.getModel());
            if (material.getAssistAttr() != null) {
                AsstAttrValueInfo asstAttrValueInfo = this.getAsstAttrValueInfoByCache(ctx, hsData, "FEntry$assistProperty_number", material.getAssistAttr());
                entryInfo.setAssistProperty(asstAttrValueInfo);
            }
            entryInfo.setBaseQty(this.getBaseUnitQty(ctx, unit, material, entryInfo.getQuantity()));
            if (entryInfo.getAssistUnit() != null) {
                multiUnifInfo = this.getMultiMeasureUnitByCache(ctx, entryInfo.getAssistUnit(), material);
                if (multiUnifInfo != null) {
                    assistQtyPrecision = multiUnifInfo.getQtyPrecision();
                }
                entryInfo.setAssistQty(entryInfo.getAssistQty().setScale(assistQtyPrecision, 4));
            } else {
                entryInfo.setAssistQty(BigDecimal.ZERO);
            }
        } else {
            qtyPrecision = 9;
            int pricePrcision = 7;
            ExpenseTypeInfo expenseItem = this.getExpenseItemInfoByCache(ctx, hsData, "FEntry$expenseItem_number");
            if (expenseItem == null) {
                ARAPImportHelper.throwFieldErrorMsg(ctx, hsData, "FEntry$expenseItem_number");
            }
            entryInfo.setExpenseItem(expenseItem);
            entryInfo.setBaseUnit(unit);
            if (unit != null) {
                qtyPrecision = unit.getQtyPrecision();
            }
            entryInfo.setQuantity(entryInfo.getQuantity().setScale(qtyPrecision, 4));
            entryInfo.setPrice(entryInfo.getPrice().setScale(pricePrcision, 4));
            entryInfo.setTaxPrice(entryInfo.getTaxPrice().setScale(pricePrcision, 4));
            entryInfo.setBaseQty(entryInfo.getQuantity());
            entryInfo.setAssistQty(BigDecimal.ZERO);
        }
        entryInfo.setCoreBillType(this.getBillTypeByCache(ctx, hsData, "FEntry$coreBillType_number"));
        account = this.getAccountViewInfoByCache(ctx, hsData, "FEntry$account_number", this.currentCompany.getId().toString(), currency.getId().toString());
        if (this.isInitBill && account == null) {
            throw new TaskExternalException(ApOtherBillDataImport.getString("AP_Account_Is_Null", ctx));
        }
        entryInfo.setAccount(account);
        this.checkIsContrastAccountByCache(ctx, otherBillInfo.getCompany(), entryInfo.getAccount(), false);
        entryInfo.setOppAccount(this.getAccountViewInfoByCache(ctx, hsData, "FEntry$oppAccount_number", this.currentCompany.getId().toString(), currency.getId().toString()));
        entryInfo.setDiscountType(ARAPImportHelper.getDiscountTypeInfo(ctx, hsData, "FEntry_discountType"));
        if (DiscountModeEnum.NULL.equals((Object)entryInfo.getDiscountType())) {
            entryInfo.setDiscountRate(ARAPImportHelper.ZERO);
            entryInfo.setDiscountAmount(ARAPImportHelper.ZERO);
            entryInfo.setDiscountAmountLocal(ARAPImportHelper.ZERO);
        }
        if (entryInfo.getQuantity().compareTo(ARAPImportHelper.ZERO) == 0 && otherBillInfo.getBillType().getValue() == 203) {
            entryInfo.setQuantity(BigDecimal.ONE);
        }
        if (!this.isInitBill) {
            entryInfo.setVerifyAmount(ARAPImportHelper.ZERO);
            entryInfo.setVerifyAmountLocal(ARAPImportHelper.ZERO);
            entryInfo.setUnVerifyAmount(entryInfo.getRecievePayAmount());
            entryInfo.setUnVerifyAmountLocal(entryInfo.getRecievePayAmountLocal());
        } else {
            if (entryInfo.getVerifyAmount().abs().compareTo(entryInfo.getRecievePayAmount().abs()) >= 0) {
                throw new TaskExternalException(ApOtherBillDataImport.getString("VerifyAmtNotBigAPAmt", ctx));
            }
            entryInfo.setUnVerifyAmount(entryInfo.getRecievePayAmount().subtract(entryInfo.getVerifyAmount()));
            entryInfo.setUnVerifyAmountLocal(entryInfo.getRecievePayAmountLocal().subtract(entryInfo.getVerifyAmountLocal()));
        }
        entryInfo.setLockVerifyAmt(entryInfo.getVerifyAmount());
        entryInfo.setLockVerifyAmtLocal(entryInfo.getVerifyAmountLocal());
        entryInfo.setLockUnVerifyAmt(entryInfo.getUnVerifyAmount());
        entryInfo.setLockUnVerifyAmtLocal(entryInfo.getUnVerifyAmountLocal());
        if (otherBillInfo.isIsInitializeBill()) {
            entryInfo.setHisUnVerifyAmount(entryInfo.getUnVerifyAmount());
            entryInfo.setHisUnVerifyAmountLocal(entryInfo.getUnVerifyAmountLocal());
        }
        entryInfo.setUnwriteOffBaseQty(entryInfo.getBaseQty());
        entryInfo.setLocalUnwriteOffAmount(entryInfo.getRecievePayAmountLocal());
        entryInfo.setApportionAmount(ARAPImportHelper.ZERO);
        entryInfo.setUnApportionAmount(entryInfo.getAmountLocal());
        if (entryInfo.isIsQtyZero()) {
            this.clearQtyZeroFields(entryInfo);
        }
        boolean isRedBill = entryInfo.isRed();
        ArApBillHelper.handleRedBill((IObjectValue)entryInfo, isRedBill);
        try {
            this.checkVerifyAmount(ctx, otherBillInfo, entryInfo, currency, scale);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        this.setMakeInvoiceReqRelationFields(entryInfo);
    }

    private void parseHead(Hashtable hsData, Context ctx, OtherBillInfo otherBillInfo) throws TaskExternalException, BOSException, EASBizException {
        Date date = null;
        String str = null;
        for (int i = 0; i < this.DATE_FIELDS.length; ++i) {
            date = ARAPImportHelper.getDataDate(ctx, hsData, this.DATE_FIELDS[i]);
            if (date == null) {
                ARAPImportHelper.throwFieldNullMsg(ctx, hsData, this.DATE_FIELDS[i]);
            }
            otherBillInfo.setDate(this.DATE_OBJS[i], date);
        }
        this.isInitBill = otherBillInfo.getBillDate().before(this.startPeriod.getBeginDate());
        this.checkOrgPermission(ctx, false, this.isInitBill);
        this.isFinish = otherBillInfo.getBillDate().before(this.currentPeriod.getBeginDate());
        if (this.isInitBill && this.arIsStart) {
            String errorMsg = MessageFormat.format(ApOtherBillDataImport.getString("Cannot_InitBill_Wrong", ctx), this.defaultSysEnum.getAlias());
            throw new TaskExternalException(errorMsg);
        }
        if (!this.isInitBill && this.isFinish) {
            String errorMsg = MessageFormat.format(ApOtherBillDataImport.getString("Cannot_FinistBill_Wrong", ctx), this.defaultSysEnum.getAlias());
            throw new TaskExternalException(errorMsg);
        }
        otherBillInfo.setIsInitializeBill(this.isInitBill);
        CurrencyInfo currency = this.getCurrencyByCache(ctx, hsData, "FCurrency_number");
        int scale = 4;
        if (currency != null) {
            scale = currency.getPrecision();
        }
        ExchangeRateInfo exgRateInfo = null;
        try {
            if (this.currentCompany != null && currency != null) {
                exgRateInfo = this.getExchangeRateInfoByCache(ctx, this.currentCompany, currency);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ArApBillUtil.printExceptionMsg(ex), (Throwable)ex);
        }
        if (exgRateInfo != null) {
            scale = exgRateInfo.getPrecision();
            if (exgRateInfo.getExchangeAux() != null) {
                scale = exgRateInfo.getExchangeAux().getPrecision();
            }
        }
        for (int i = 0; i < this.AP_DECIMAL_FIELDS.length; ++i) {
            BigDecimal amtVal = ARAPImportHelper.getDataDeciaml(ctx, hsData, this.AP_DECIMAL_FIELDS[i]);
            otherBillInfo.setBigDecimal(this.AP_DECIMAL_OBJS[i], amtVal.setScale(scale, 4));
            if (amtVal != null && amtVal.compareTo(ARAPImportHelper.ZERO) != 0) continue;
            ARAPImportHelper.throwFieldNullMsg(ctx, hsData, this.AP_DECIMAL_FIELDS[i]);
        }
        BigDecimal exchangeRate = otherBillInfo.getExchangeRate();
        if (currency.getId().toString().equals(this.currentCompany.getBaseCurrency().getId().toString())) {
            exchangeRate = BigDecimal.ONE;
        }
        exchangeRate = exchangeRate.compareTo(ARAPImportHelper.ZERO) == 0 ? ARAPImportHelper.ONE : exchangeRate;
        otherBillInfo.setExchangeRate(exchangeRate);
        otherBillInfo.setLastExhangeRate(otherBillInfo.getExchangeRate().setScale(scale, 4));
        for (int i = 0; i < this.STRING_FIELDS.length; ++i) {
            str = ARAPImportHelper.getDataString(hsData, this.STRING_FIELDS[i]);
            otherBillInfo.setString(this.STRING_OBJS[i], str);
        }
        otherBillInfo.setBillStatus(BillStatusEnum.SAVE);
        otherBillInfo.setSourceBillType(VerificateBillTypeEnum.OTHER);
        otherBillInfo.setBillType(ARAPImportHelper.getAPBillType(hsData, "FBillType"));
        boolean isInTax = true;
        boolean isPriceWiTax = true;
        if (OtherBillType.DebitAdjust.equals((Object)otherBillInfo.getBillType())) {
            isPriceWiTax = false;
        }
        otherBillInfo.setIsInTax(isInTax);
        otherBillInfo.setIsPriceWithoutTax(isPriceWiTax);
        otherBillInfo.setIsBizBill(this.getDataboolean(hsData, "FIsBizBill"));
        PaymentTypeInfo paymentType = this.getPaymentTypeInfoByCache(ctx, hsData, "FPaymentType_number", false);
        otherBillInfo.setPaymentType(paymentType);
        otherBillInfo.setPurchaseGroup(ARAPImportHelper.getPurchaseGroupInfo(ctx, hsData, "FPurchaseGroup_number", this.cuId));
        otherBillInfo.setSettleType(this.getSettlementTypeInfoByCache(ctx, hsData, "FSettleType_number"));
        otherBillInfo.setCurrency(this.getCurrencyByCache(ctx, hsData, "FCurrency_number"));
        otherBillInfo.setCU(this.currentCompany.getCU());
        otherBillInfo.setCompany(this.currentCompany);
        otherBillInfo.setAdminOrgUnit(this.getAdminOrgUnitInfoByCache(ctx, hsData, "FAdminOrgUnit_number"));
        otherBillInfo.setPerson(this.getPersonInfoByCache(ctx, hsData, "FPerson_number"));
        PurchaseOrgUnitInfo info = ARAPImportHelper.getPurchaseOrg(ctx, hsData, "FPurOrg_number", this.cuId);
        if (info == null && !this.isInitBill && this.isConnSCM && otherBillInfo.getBillType().getValue() != 201) {
            throw new TaskExternalException(ApOtherBillDataImport.getString("APInvoiceBill_Org_IsNull", ctx));
        }
        otherBillInfo.setPurOrg(info);
        AsstActTypeInfo asstActTypeInfo = this.getAsstActTypeInfoByCache(ctx, hsData, "FAsstActType_number");
        otherBillInfo.setAsstActType(asstActTypeInfo);
        if (!this.checkAsstAccID(ctx, asstActTypeInfo, hsData, otherBillInfo)) {
            throw new TaskExternalException(ApOtherBillDataImport.getString("AsstActNumber_Wrong", ctx));
        }
        if (!this.isExistAsstActByCompanyByCache(ctx, this.currentCompany, otherBillInfo.getAsstActType(), otherBillInfo.getAsstActID()).booleanValue()) {
            throw new TaskExternalException(ARAPImportHelper.getString("AsstActNotBelongCompany", ctx));
        }
        if (!this.checkAsstActStatusByCache(ctx, otherBillInfo.getAsstActType(), otherBillInfo.getAsstActID()).booleanValue()) {
            throw new TaskExternalException(ARAPImportHelper.getString("AsstActNotApproved", ctx));
        }
        otherBillInfo.setCashDiscount(this.getCashDiscountInfoByCache(ctx, hsData, "FCashDiscount_number"));
        otherBillInfo.setIsImportBill(true);
    }

    public static String getString(String resName, Context ctx) {
        return ApOtherBillDataImport.getString("AR", resName, ctx);
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            OtherBillInfo otherBillInfo = (OtherBillInfo)coreBaseInfo;
            otherBillInfo.getEntry().sort("seq");
            otherBillInfo.setReqCalculate4Srv(false);
            otherBillInfo.getPlans().clear();
            IObjectPK pk = this.getController(ctx).save(coreBaseInfo);
            if (coreBaseInfo != null && coreBaseInfo.getId() != null) {
                coreBaseInfo.setId(BOSUuid.read((String)pk.toString()));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.ap.app.OtherBillQuery";
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FCompany_number", rs.getString("company.number"));
            this.putTable(result, "FBillDate", rs.getString("billDate"));
            this.putTable(result, "FBillType", rs.getString("billType"));
            this.putTable(result, "FPaymentType_number", rs.getString("paymentType.number"));
            this.putTable(result, "FBizDate", rs.getString("bizDate"));
            this.putTable(result, "FAsstActType_number", rs.getString("asstActType.number"));
            this.putTable(result, "FAsstActNumber", rs.getString("asstActNumber"));
            this.putTable(result, "FAdminOrgUnit_number", rs.getString("adminOrgUnit.number"));
            this.putTable(result, "FPurOrg_number", rs.getString("purOrg.number"));
            this.putTable(result, "FPurchaseGroup_number", rs.getString("purchaseGroup.number"));
            this.putTable(result, "FPerson_number", rs.getString("person.number"));
            this.putTable(result, "FCurrency_number", rs.getString("currency.number"));
            this.putTable(result, "FExchangeRate", rs.getBigDecimal("exchangeRate"));
            this.putTable(result, "FAbstractName", rs.getString("abstractName"));
            this.putTable(result, "FCashDiscount_number", rs.getString("cashDiscount.number"));
            this.putTable(result, "FSettleType_number", rs.getString("settleType.number"));
            this.putTable(result, "FIsBizBill", rs.getString("isBizBill"));
            this.putTable(result, "FSeq", rs.getString("entry.seq"));
            this.putTable(result, "FEntry$material_number", rs.getString("material.number"));
            this.putTable(result, "FEntry$assistProperty_number", rs.getString("assistProperty.number"));
            this.putTable(result, "FEntry$expenseItem_number", rs.getString("expenseItem.number"));
            this.putTable(result, "FEntry$measureUnit_number", rs.getString("measureUnit.number"));
            this.putTable(result, "FEntry_quantity", rs.getBigDecimal("entry.quantity"));
            this.putTable(result, "FEntry_isQtyZero", rs.getString("entry.isQtyZero"));
            this.putTable(result, "FEntry$assistUnit_number", rs.getString("assistUnit.number"));
            this.putTable(result, "FEntry_assistQty", rs.getBigDecimal("entry.assistQty"));
            this.putTable(result, "FEntry_taxRate", rs.getBigDecimal("entry.taxRate"));
            this.putTable(result, "FEntry_price", rs.getBigDecimal("entry.price"));
            this.putTable(result, "FEntry_taxPrice", rs.getBigDecimal("entry.taxPrice"));
            this.putTable(result, "FEntry_discountType", rs.getString("entry.discountType"));
            this.putTable(result, "FEntry_discountRate", rs.getBigDecimal("entry.discountRate"));
            this.putTable(result, "FEntry_discountAmount", rs.getBigDecimal("entry.discountAmount"));
            this.putTable(result, "FEntry_discountAmountLocal", rs.getBigDecimal("entry.discountAmountLocal"));
            this.putTable(result, "FEntry_realPrice", rs.getBigDecimal("entry.realPrice"));
            this.putTable(result, "FEntry_actualPrice", rs.getBigDecimal("entry.actualPrice"));
            this.putTable(result, "FEntry_amount", rs.getBigDecimal("entry.amount"));
            this.putTable(result, "FEntry_amountLocal", rs.getBigDecimal("entry.amountLocal"));
            this.putTable(result, "FEntry_taxAmount", rs.getBigDecimal("entry.taxAmount"));
            this.putTable(result, "FEntry_taxAmountLocal", rs.getBigDecimal("entry.taxAmountLocal"));
            this.putTable(result, "FEntry$oppAccount_number", rs.getString("oppAccount.number"));
            this.putTable(result, "FEntry$account_number", rs.getString("account.number"));
            this.putTable(result, "FEntry_recievePayAmount", rs.getBigDecimal("entry.recievePayAmount"));
            this.putTable(result, "FEntry_recievePayAmountLocal", rs.getBigDecimal("entry.recievePayAmountLocal"));
            this.putTable(result, "FEntry_verifyAmount", rs.getBigDecimal("entry.verifyAmount"));
            this.putTable(result, "FEntry_verifyAmountLocal", rs.getBigDecimal("entry.verifyAmountLocal"));
            this.putTable(result, "FEntry$coreBillType_number", rs.getString("coreBillType.number"));
            this.putTable(result, "FEntry_coreBillNumber", rs.getString("entry.coreBillNumber"));
            this.putTable(result, "FEntry_coreBillEntrySeq", rs.getString("entry.coreBillEntrySeq"));
            this.putTable(result, "FEntry_remark", rs.getString("entry.remark"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }
}

