/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.wssc.BillImageFacadeFactory;
import com.kingdee.eas.base.wssc.IBillImageFacade;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.IVerificationBill;
import com.kingdee.eas.fi.ap.VerificationBillCollection;
import com.kingdee.eas.fi.ap.VerificationBillFactory;
import com.kingdee.eas.fi.ap.VerificationBillInfo;
import com.kingdee.eas.fi.ap.app.AbstractApVerificationFacadeControllerBean;
import com.kingdee.eas.fi.arap.ARAPVerifynException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.sql.RowSet;

public class ApVerificationFacadeControllerBean
extends AbstractApVerificationFacadeControllerBean {
    private static final long serialVersionUID = 1158691553857892494L;
    private static final int DEFAULT_QUERY_COUNT = 10000;
    private final BigDecimal ZERO = new BigDecimal("0.00");
    private static final String REC_AR_AGENT = "104";
    private static final String REC_AR_REFUNDMENT_AGENT = "105";
    private static final String REC_AR_PRE_REC = "101";
    private static final String REC_AR_REFUNDMENT_PRE_REC = "103";
    private static final String PAY_AP_AGENT = "205";
    private static final String PAY_AP_REFUNDMENT_AGENT = "206";
    private static final String PAY_AP_PRE_PAYMENT = "202";
    private static final String PAY_AP_REFUNDMENT_PRE_PAYMENT = "204";

    @Override
    protected RowSet _getArBill(Context ctx, HashMap filter) throws BOSException, EASBizException {
        String lang = ctx.getLocale().getLanguage();
        StringBuffer sb = new StringBuffer("select top ");
        sb.append(10000);
        sb.append(" t1.fid as billid,");
        sb.append("t3.fid as company_id,");
        sb.append("t3.FName_").append(lang).append(" as company_name,");
        sb.append("8 as billtype,");
        sb.append("t1.FBillType as billsubtype,");
        sb.append("t1.fnumber as b_number,");
        sb.append("t1.FBillDate as billdate,");
        sb.append("t4.fid as acctCussType_id,");
        sb.append("t4.FName_").append(lang).append(" as acctCussType_name,");
        sb.append("t4.fnumber as acctCussType_number,");
        sb.append("t1.FAsstActID as acctCuss_id,");
        sb.append("t1.FcurrencyID as currency_id,");
        sb.append("t5.FName_").append(lang).append(" as currency_name,");
        sb.append("t5.fnumber as currency_number,");
        sb.append("t2.fid as entryid,");
        sb.append("t6.FID as accountid,");
        sb.append("t6.FNumber as accountnumber,");
        sb.append("t6.FName_").append(lang).append(" as accountname,");
        sb.append("t2.FOppAccountID as oppAccount,");
        sb.append("t1.FLastExhangeRate as exchangerate,");
        sb.append("t2.FRecievePayAmount as billamt,");
        sb.append("t2.FRecievePayAmountLocal as billamtloc,");
        sb.append("t2.FLockVerifyAmt as verificateamt,");
        sb.append("t2.FLockVerifyAmtLocal as verificateamtloc,");
        sb.append("t2.FLockUnVerifyAmt as unverificateamt,");
        sb.append("t2.FLockUnVerifyAmtLocal as unverificateamtloc,");
        sb.append("t1.FAbstractName as description ");
        sb.append(",t1.FAdminOrgUnitID as FAdminOrgUnitID, ");
        sb.append("t1.FPersonID as FPersonID ");
        sb.append(",t2.FCoreBillNumber as coreBillNumber ");
        sb.append(", t2.FCoreBillEntrySeq as coreBillEntrySeq ");
        sb.append(",t7.FID as FMaterialID ");
        sb.append(",t7.FNumber as FMaterialNumber ");
        sb.append(",t7.FName_").append(lang).append(" as FMaterialName ");
        sb.append(",t8.FID as FExpenseItemID ");
        sb.append(",t8.FNumber as FExpenseItemNumber ");
        sb.append(",t8.FName_").append(lang).append(" as FExpenseItemName ");
        sb.append("from T_AR_OtherBill as t1 ");
        sb.append("inner join T_AR_OtherBillEntry as t2 on t1.fid = t2.fparentid ");
        sb.append("inner join t_org_company AS t3 on t1.FCompanyID = t3.FID ");
        sb.append("inner join T_BD_AsstActType as t4 on t1.FAsstActTypeID = t4.fid ");
        sb.append("inner join t_bd_currency AS t5 on t1.fcurrencyid = t5.FID ");
        sb.append("left join T_BD_AccountView t6 on t2.FAccountID = t6.fid ");
        sb.append("left join T_BD_Material t7 on t2.FMaterialID = t7.fid ");
        sb.append("left join T_BC_ExpenseType t8 on t2.FExpenseItemID = t8.fid ");
        sb.append("where (t2.FLockUnVerifyAmt <> 0) and ");
        FilterInfo filters = new FilterInfo();
        filters.getFilterItems().add(new FilterItemInfo("t1.FBillStatus", (Object)new Integer(3)));
        filters.getFilterItems().add(new FilterItemInfo("t1.FCompanyID", filter.get("company")));
        filters.getFilterItems().add(new FilterItemInfo("t1.FCurrencyID", filter.get("currency")));
        if (filter.containsKey("assActType")) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FAsstActTypeID", filter.get("assActType")));
        }
        if (filter.containsKey("number")) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FNumber", filter.get("number")));
        }
        if (filter.containsKey("assactFrom")) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FAsstActNumber", filter.get("assactFrom"), CompareType.GREATER_EQUALS));
        }
        if (filter.containsKey("assactTo")) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FAsstActNumber", filter.get("assactTo"), CompareType.LESS_EQUALS));
        }
        if (filter.containsKey("startdate")) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FBillDate", filter.get("startdate"), CompareType.GREATER_EQUALS));
        }
        if (filter.containsKey("enddate")) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FBillDate", filter.get("enddate"), CompareType.LESS_EQUALS));
        }
        if (filter.containsKey("coreNum")) {
            filters.getFilterItems().add(new FilterItemInfo("t2.FCoreBillNumber", filter.get("coreNum")));
        }
        sb.append(filters.toString());
        sb.append("order by billdate ASC");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        return result;
    }

    @Override
    protected RowSet _getPayment(Context ctx, HashMap filter) throws BOSException, EASBizException {
        String lang = ctx.getLocale().getLanguage();
        StringBuffer sb = new StringBuffer("select top ");
        sb.append(10000);
        sb.append(" t1.fid as billid,");
        sb.append("t3.fid as company_id,");
        sb.append("t3.fname_").append(ctx.getLocale().getLanguage()).append(" as company_name,");
        sb.append("4 as billtype,");
        sb.append("t7.fnumber as billsubtype,");
        sb.append("t1.fnumber as b_number,");
        sb.append("t1.FBizDate as billdate,");
        sb.append("t1.FPayeeTypeID as acctCussType_id,");
        sb.append("t5.fname_").append(ctx.getLocale().getLanguage()).append(" as acctCussType_name,");
        sb.append("t5.fnumber as acctCussType_number,");
        sb.append("t1.fpayeeid as acctCuss_id,");
        sb.append("t1.fpayeename as acctCuss_name,");
        sb.append("t1.fpayeenumber as acctCuss_number,");
        sb.append("t1.fcurrencyid as currency_id,");
        sb.append("t4.fname_").append(ctx.getLocale().getLanguage()).append(" as currency_name,");
        sb.append("t4.fnumber as currency_number,");
        sb.append("t2.fid as entryid,");
        sb.append("t6.FID as accountid,");
        sb.append("t6.FNumber as accountnumber,");
        sb.append("t6.FName_").append(lang).append(" as accountname,");
        sb.append("t1.FOppAccountID as oppAccount,");
        sb.append("t1.FLastExhangeRate as exchangerate,");
        sb.append("t2.FAmount as billamt,");
        sb.append("t2.FLocalAmount as billamtloc,");
        sb.append("t2.FActualAmt as actualAmt,");
        sb.append("t2.FActualLocAmt as actualAmtLoc,");
        sb.append("t2.FRebate as rebateAmt,");
        sb.append("t2.FRebateLocAmt as rebateAmtLoc,");
        sb.append("t2.FLockAmt as verificateamt,");
        sb.append("t2.FLockLocAmt as verificateamtloc,");
        sb.append("t2.FUnLockAmt as unverificateamt,");
        sb.append("t2.FUnLockLocAmt as unverificateamtloc,");
        sb.append("t1.FDescription as description ");
        sb.append(",t1.FAdminOrgUnitID as FAdminOrgUnitID, ");
        sb.append("t1.FPersonID as FPersonID ");
        sb.append(",t2.FCoreBillNumber as coreBillNumber ");
        sb.append(", t2.FCoreBillEntrySeq as coreBillEntrySeq ");
        sb.append("from T_CAS_PaymentBill as t1 ");
        sb.append("inner join T_CAS_PaymentBillEntry as t2 on t1.fid = t2.FPaymentBillID ");
        sb.append("left join T_ORG_Company AS t3 on t1.FCompanyID = t3.FID ");
        sb.append("left join T_BD_Currency as t4 on t1.FCurrencyid = t4.FID ");
        sb.append("left join T_BD_AsstActType as t5 on t1.FPayeeTypeID = t5.FID ");
        sb.append("left join T_BD_AccountView t6 on t1.FPayerAccountID = t6.fid ");
        sb.append("left join t_cas_paymentbilltype as t7 on t1.FPayBillTypeID = t7.FID ");
        sb.append(" WHERE ");
        sb.append(this._transferToPayFilterInfo(filter).toString());
        sb.append("order by billdate ASC");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        return result;
    }

    private FilterInfo _transferToPayFilterInfo(HashMap filter) {
        FilterInfo filters = new FilterInfo();
        StringBuffer maskStr = new StringBuffer();
        int i = 0;
        filters.getFilterItems().add(new FilterItemInfo("t1.FBillStatus", (Object)new Integer(15)));
        filters.getFilterItems().add(new FilterItemInfo("t1.FBillStatus", (Object)new Integer(16)));
        filters.getFilterItems().add(new FilterItemInfo("t1.FSourceType", (Object)new Integer(100)));
        filters.getFilterItems().add(new FilterItemInfo("t1.FSourceType", (Object)new Integer(101)));
        maskStr.append("(#0 OR #1) AND (#2 OR #3)");
        if (filter.get("paymenttype") == null || "all".equalsIgnoreCase(filter.get("paymenttype").toString())) {
            filters.getFilterItems().add(new FilterItemInfo("t7.Fnumber", (Object)PAY_AP_AGENT, CompareType.NOTEQUALS));
            filters.getFilterItems().add(new FilterItemInfo("t7.Fnumber", (Object)PAY_AP_REFUNDMENT_AGENT, CompareType.NOTEQUALS));
            maskStr.append(" AND #4 AND #5 ");
            i = 6;
        } else if ("payment".equalsIgnoreCase(filter.get("paymenttype").toString())) {
            filters.getFilterItems().add(new FilterItemInfo("t7.Fnumber", (Object)PAY_AP_AGENT));
            filters.getFilterItems().add(new FilterItemInfo("t7.Fnumber", (Object)PAY_AP_REFUNDMENT_AGENT));
            maskStr.append(" AND (#4 OR #5)");
            i = 6;
        } else if ("prepayment".equalsIgnoreCase(filter.get("paymenttype").toString())) {
            filters.getFilterItems().add(new FilterItemInfo("t7.Fnumber", (Object)PAY_AP_PRE_PAYMENT));
            filters.getFilterItems().add(new FilterItemInfo("t7.Fnumber", (Object)PAY_AP_REFUNDMENT_PRE_PAYMENT));
            maskStr.append(" AND (#4 OR #5)");
            i = 6;
        }
        filters.getFilterItems().add(new FilterItemInfo("t2.FUnLockAmt", (Object)this.ZERO, CompareType.NOTEQUALS));
        maskStr.append(" AND #");
        maskStr.append(i++);
        filters.getFilterItems().add(new FilterItemInfo("t1.FCompanyID", filter.get("company")));
        maskStr.append(" AND #");
        maskStr.append(i++);
        filters.getFilterItems().add(new FilterItemInfo("t1.FCurrencyID", filter.get("currency")));
        maskStr.append(" AND #");
        maskStr.append(i++);
        if (filter.containsKey("assActType")) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FPayeeTypeID", filter.get("assActType")));
            maskStr.append(" AND #");
            maskStr.append(i++);
        }
        if (filter.containsKey("number")) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FNumber", filter.get("number")));
            maskStr.append(" AND #");
            maskStr.append(i++);
        }
        if (filter.containsKey("assactFrom")) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FPayeeNumber", filter.get("assactFrom"), CompareType.GREATER_EQUALS));
            maskStr.append(" AND #");
            maskStr.append(i++);
        }
        if (filter.containsKey("assactTo")) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FPayeeNumber", filter.get("assactTo"), CompareType.LESS_EQUALS));
            maskStr.append(" AND #");
            maskStr.append(i++);
        }
        if (filter.containsKey("startdate")) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FBizDate", filter.get("startdate"), CompareType.GREATER_EQUALS));
            maskStr.append(" AND #");
            maskStr.append(i++);
        }
        if (filter.containsKey("enddate")) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FBizDate", filter.get("enddate"), CompareType.LESS_EQUALS));
            maskStr.append(" AND #");
            maskStr.append(i++);
        }
        if (filter.containsKey("coreNum")) {
            filters.getFilterItems().add(new FilterItemInfo("t2.FCoreBillNumber", filter.get("coreNum")));
            maskStr.append(" AND #");
            maskStr.append(i++);
        }
        filters.setMaskString(maskStr.toString());
        return filters;
    }

    @Override
    protected RowSet _getReceive(Context ctx, HashMap filter) throws BOSException, EASBizException {
        String lang = ctx.getLocale().getLanguage();
        StringBuffer sb = new StringBuffer("select top ");
        sb.append(10000);
        sb.append(" t1.fid as billid,");
        sb.append("t3.fid as company_id,");
        sb.append("t3.fname_").append(ctx.getLocale().getLanguage()).append(" as company_name,");
        sb.append("6 as billtype,");
        sb.append("t7.fnumber as billsubtype,");
        sb.append("t1.fnumber as b_number,");
        sb.append("t1.fbizdate as billdate,");
        sb.append("t1.FPayerTypeID as acctCussType_id,");
        sb.append("t5.fname_").append(ctx.getLocale().getLanguage()).append(" as acctCussType_name,");
        sb.append("t5.fnumber as acctCussType_number,");
        sb.append("t1.fpayerid as acctCuss_id,");
        sb.append("t1.fpayername as acctCuss_name,");
        sb.append("t1.fpayernumber as acctCuss_number,");
        sb.append("t1.fcurrencyid as currency_id,");
        sb.append("t4.fname_").append(ctx.getLocale().getLanguage()).append(" as currency_name,");
        sb.append("t4.fnumber as currency_number,");
        sb.append("t2.fid as entryid,");
        sb.append("t6.FID as accountid,");
        sb.append("t6.FID as accountnumber,");
        sb.append("t6.FName_").append(lang).append(" as accountname,");
        sb.append("t1.FOppAccountID as oppAccount,");
        sb.append("t1.FLastExhangeRate as exchangerate,");
        sb.append("t2.FAmount as billamt,");
        sb.append("t2.FLocalAmount as billamtloc,");
        sb.append("t2.FActualAmt as actualAmt,");
        sb.append("t2.FActualLocAmt as actualAmtLoc,");
        sb.append("t2.FRebate as rebateAmt,");
        sb.append("t2.FRebateLocAmt as rebateAmtLoc,");
        sb.append("t2.FLockAmt as verificateamt,");
        sb.append("t2.FLockLocAmt as verificateamtloc,");
        sb.append("t2.FUnLockAmt as unverificateamt,");
        sb.append("t2.FUnLockLocAmt as unverificateamtloc,");
        sb.append("t1.FDescription as description ");
        sb.append(",t1.FAdminOrgUnitID as FAdminOrgUnitID, ");
        sb.append("t1.FPersonID as FPersonID ");
        sb.append(",t2.FCoreBillNumber as coreBillNumber ");
        sb.append(", t2.FCoreBillEntrySeq as coreBillEntrySeq ");
        sb.append("from T_CAS_ReceivingBill as t1 ");
        sb.append("inner join T_CAS_ReceivingBillEntry as t2 on t1.fid = t2.FReceivingBillID ");
        sb.append("left join T_ORG_Company AS t3 on t1.FCompanyID = t3.FID ");
        sb.append("left join T_BD_Currency as t4 on t1.FCurrencyID = t4.FID ");
        sb.append("left join T_BD_AsstActType as t5 on t1.FPayerTypeID = t5.FID ");
        sb.append("left join T_BD_AccountView t6 on t1.FPayeeAccountID = t6.fid ");
        sb.append("left join t_cas_receivingbilltype as t7 on t1.FRecBillTypeID = t7.FID ");
        sb.append("where ");
        sb.append(this._transferToRecFilterInfo(filter).toString());
        sb.append(" order by billdate ASC");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        return result;
    }

    private FilterInfo _transferToRecFilterInfo(HashMap filter) {
        FilterInfo filters = new FilterInfo();
        StringBuffer maskStr = new StringBuffer();
        int i = 0;
        filters.getFilterItems().add(new FilterItemInfo("t1.FBillStatus", (Object)new Integer(14)));
        filters.getFilterItems().add(new FilterItemInfo("t1.FBillStatus", (Object)new Integer(16)));
        maskStr.append("(#0 OR #1)");
        filters.getFilterItems().add(new FilterItemInfo("t1.FSourceType", (Object)new Integer(100)));
        filters.getFilterItems().add(new FilterItemInfo("t1.FSourceType", (Object)new Integer(101)));
        maskStr.append(" AND (#2 OR #3)");
        if (filter.get("receivetype") == null || "all".equalsIgnoreCase(filter.get("receivetype").toString())) {
            filters.getFilterItems().add(new FilterItemInfo("t7.FNumber", (Object)REC_AR_AGENT, CompareType.NOTEQUALS));
            filters.getFilterItems().add(new FilterItemInfo("t7.FNumber", (Object)REC_AR_REFUNDMENT_AGENT, CompareType.NOTEQUALS));
            maskStr.append(" AND #4 AND #5 ");
            i = 6;
        } else if ("receive".equalsIgnoreCase(filter.get("receivetype").toString())) {
            i = 6;
            filters.getFilterItems().add(new FilterItemInfo("t7.FNumber", (Object)REC_AR_AGENT));
            filters.getFilterItems().add(new FilterItemInfo("t7.FNumber", (Object)REC_AR_REFUNDMENT_AGENT));
            maskStr.append(" AND (#4 OR #5)");
        } else if ("prereceive".equalsIgnoreCase(filter.get("receivetype").toString())) {
            i = 6;
            filters.getFilterItems().add(new FilterItemInfo("t7.FNumber", (Object)REC_AR_PRE_REC));
            filters.getFilterItems().add(new FilterItemInfo("t7.FNumber", (Object)REC_AR_REFUNDMENT_PRE_REC));
            maskStr.append(" AND (#4 OR #5)");
        }
        filters.getFilterItems().add(new FilterItemInfo("t2.FUnLockAmt", (Object)this.ZERO, CompareType.NOTEQUALS));
        maskStr.append(" AND #");
        maskStr.append(i++);
        filters.getFilterItems().add(new FilterItemInfo("t1.FCompanyID", filter.get("company")));
        maskStr.append(" AND #");
        maskStr.append(i++);
        filters.getFilterItems().add(new FilterItemInfo("t1.FCurrencyID", filter.get("currency")));
        maskStr.append(" AND #");
        maskStr.append(i++);
        if (filter.containsKey("assActType")) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FPayerTypeID", filter.get("assActType")));
            maskStr.append(" AND #");
            maskStr.append(i++);
        }
        if (filter.containsKey("number")) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FNumber", filter.get("number")));
            maskStr.append(" AND #");
            maskStr.append(i++);
        }
        if (filter.containsKey("assactFrom")) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FPayerNumber", filter.get("assactFrom"), CompareType.GREATER_EQUALS));
            maskStr.append(" AND #");
            maskStr.append(i++);
        }
        if (filter.containsKey("assactTo")) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FPayerNumber", filter.get("assactTo"), CompareType.LESS_EQUALS));
            maskStr.append(" AND #");
            maskStr.append(i++);
        }
        if (filter.containsKey("startdate")) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FBizDate", filter.get("startdate"), CompareType.GREATER_EQUALS));
            maskStr.append(" AND #");
            maskStr.append(i++);
        }
        if (filter.containsKey("enddate")) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FBizDate", filter.get("enddate"), CompareType.LESS_EQUALS));
            maskStr.append(" AND #");
            maskStr.append(i++);
        }
        if (filter.containsKey("coreNum")) {
            filters.getFilterItems().add(new FilterItemInfo("t2.FCoreBillNumber", filter.get("coreNum")));
            maskStr.append(" AND #");
            maskStr.append(i++);
        }
        filters.setMaskString(maskStr.toString());
        return filters;
    }

    @Override
    protected RowSet _getApBill(Context ctx, HashMap filter) throws BOSException, EASBizException {
        String lang = ctx.getLocale().getLanguage();
        StringBuffer sb = new StringBuffer("select top ");
        sb.append(10000);
        sb.append(" t1.fid as billid,");
        sb.append("t3.fid as company_id,");
        sb.append("t3.FName_").append(lang).append(" as company_name,");
        sb.append("9 as billtype,");
        sb.append("t1.FBillType as billsubtype,");
        sb.append("t1.fnumber as b_number,");
        sb.append("t1.FBillDate as billdate,");
        sb.append("t4.fid as acctCussType_id,");
        sb.append("t4.FName_").append(lang).append(" as acctCussType_name,");
        sb.append("t4.fnumber as acctCussType_number,");
        sb.append("t1.FAsstActID as acctCuss_id,");
        sb.append("t1.FcurrencyID as currency_id,");
        sb.append("t5.FName_").append(lang).append(" as currency_name,");
        sb.append("t5.fnumber as currency_number,");
        sb.append("t2.fid as entryid,");
        sb.append("t6.FID as accountid,");
        sb.append("t6.FNumber as accountnumber,");
        sb.append("t6.FName_").append(lang).append(" as accountname,");
        sb.append("t2.FOppAccountID as oppAccount,");
        sb.append("t1.FLastExhangeRate as exchangerate,");
        sb.append("t2.FRecievePayAmount as billamt,");
        sb.append("t2.FRecievePayAmountLocal as billamtloc,");
        sb.append("t2.FLockVerifyAmt as verificateamt,");
        sb.append("t2.FLockVerifyAmtLocal as verificateamtloc,");
        sb.append("t2.FLockUnVerifyAmt as unverificateamt,");
        sb.append("t2.FLockUnVerifyAmtLocal as unverificateamtloc,");
        sb.append("t1.FAbstractName as description ");
        sb.append(",t1.FAdminOrgUnitID as FAdminOrgUnitID, ");
        sb.append("t1.FPersonID as FPersonID ");
        sb.append(",t2.FCoreBillNumber as coreBillNumber ");
        sb.append(", t2.FCoreBillEntrySeq as coreBillEntrySeq ");
        sb.append(",t7.FID as FMaterialID ");
        sb.append(",t7.FNumber as FMaterialNumber ");
        sb.append(",t7.FName_").append(lang).append(" as FMaterialName ");
        sb.append(",t8.FID as FExpenseItemID ");
        sb.append(",t8.FNumber as FExpenseItemNumber ");
        sb.append(",t8.FName_").append(lang).append(" as FExpenseItemName ");
        sb.append("from T_AP_OtherBill as t1 ");
        sb.append("inner join T_AP_OtherBillEntry AS t2 on t1.fid = t2.FParentID ");
        sb.append("inner join t_org_company AS t3 on t1.FCompanyID = t3.FID ");
        sb.append("inner join T_BD_AsstActType as t4 on t1.FAsstActTypeID = t4.fid ");
        sb.append("inner join t_bd_currency AS t5 on t1.fcurrencyid = t5.FID ");
        sb.append("left join T_BD_AccountView t6 on t2.FAccountID = t6.fid ");
        sb.append("left join T_BD_Material t7 on t2.FMaterialID = t7.fid ");
        sb.append("left join T_BC_ExpenseType t8 on t2.FExpenseItemID = t8.fid ");
        sb.append("where (t2.FLockUnVerifyAmt <> 0) and (t1.FBillStatus = 3) and ");
        FilterInfo filters = new FilterInfo();
        filters.getFilterItems().add(new FilterItemInfo("t1.FBillStatus", (Object)new Integer(3)));
        filters.getFilterItems().add(new FilterItemInfo("t1.FCompanyID", filter.get("company")));
        filters.getFilterItems().add(new FilterItemInfo("t1.FCurrencyID", filter.get("currency")));
        if (filter.containsKey("assActType")) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FAsstActTypeID", filter.get("assActType")));
        }
        if (filter.containsKey("assactFrom")) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FAsstActNumber", filter.get("assactFrom"), CompareType.GREATER_EQUALS));
        }
        if (filter.containsKey("number")) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FNumber", filter.get("number")));
        }
        if (filter.containsKey("assactTo")) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FAsstActNumber", filter.get("assactTo"), CompareType.LESS_EQUALS));
        }
        if (filter.containsKey("startdate")) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FBillDate", filter.get("startdate"), CompareType.GREATER_EQUALS));
        }
        if (filter.containsKey("enddate")) {
            filters.getFilterItems().add(new FilterItemInfo("t1.FBillDate", filter.get("enddate"), CompareType.LESS_EQUALS));
        }
        if (filter.containsKey("coreNum")) {
            filters.getFilterItems().add(new FilterItemInfo("t2.FCoreBillNumber", filter.get("coreNum")));
        }
        sb.append(filters.toString());
        sb.append("order by billdate ASC");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        return result;
    }

    @Override
    protected IObjectPK _verification(Context ctx, IObjectValue verificationBill) throws BOSException, EASBizException {
        String bosType;
        VerificationBillInfo billInfo = (VerificationBillInfo)verificationBill;
        IVerificationBill iVerify = VerificationBillFactory.getLocalInstance(ctx);
        IObjectPK verifyPk = iVerify.submit((CoreBaseInfo)billInfo);
        IBillImageFacade image = BillImageFacadeFactory.getLocalInstance((Context)ctx);
        String imageNumber = image.getImageNumber(bosType = "2F368848", verifyPk.toString());
        if (StringUtils.isEmpty((String)imageNumber)) {
            imageNumber = image.genImageNumber(bosType, verifyPk.toString());
        }
        return verifyPk;
    }

    @Override
    protected boolean _unVerification(Context ctx, String[] billIDs) throws BOSException, EASBizException {
        Set<String> idSet = new HashSet<String>(Arrays.asList(billIDs));
        if ((idSet = this.checkHasReverse(ctx, idSet)).size() != billIDs.length) {
            Object[] arr = new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"verification_condition_notInclude", (Locale)ctx.getLocale())};
            throw new ARAPVerifynException(ARAPVerifynException.COMMON, arr);
        }
        Object[] idArr = idSet.toArray();
        if (idArr != null && idArr.length > 0) {
            ArrayList<Object> al = new ArrayList<Object>();
            for (int i = 0; i < idArr.length; ++i) {
                if (al.contains(idArr[i])) continue;
                al.add(idArr[i]);
            }
            IVerificationBill iVerify = VerificationBillFactory.getLocalInstance(ctx);
            iVerify.unVerify(al, true);
        }
        return true;
    }

    private Set checkHasReverse(Context ctx, Set idSet) throws BOSException {
        IVerificationBill iVerificationBill = VerificationBillFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isReversed", (Object)false));
        filter.getFilterItems().add(new FilterItemInfo("isReverseBill", (Object)false));
        view.setFilter(filter);
        VerificationBillCollection validCol = iVerificationBill.getVerificationBillCollection(view);
        idSet = new HashSet<String>(validCol.size());
        int len = validCol.size();
        for (int i = 0; i < len; ++i) {
            idSet.add(validCol.get(i).getId().toString());
        }
        return idSet;
    }

    @Override
    protected IObjectValue _getAsstActType(Context ctx, String flag) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer("select fid as asst_id,");
        sb.append("fname_").append(ctx.getLocale().getLanguage()).append(" as asst_name,");
        sb.append("fnumber as asst_number,");
        sb.append("fdefaultqueryname as query_name ");
        sb.append("from T_BD_AsstActType where fassthgattribute = ? ");
        ArrayList<String> vs = new ArrayList<String>();
        vs.add(flag);
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])vs.toArray());
        try {
            if (result.next()) {
                AsstActTypeInfo asstActTypeInfo = new AsstActTypeInfo();
                asstActTypeInfo.setId(BOSUuid.read((String)result.getString("asst_id")));
                asstActTypeInfo.setName(result.getString("asst_name"));
                asstActTypeInfo.setNumber(result.getString("asst_number"));
                asstActTypeInfo.setDefaultQueryName(result.getString("query_name"));
                return asstActTypeInfo;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    @Override
    protected boolean _isVerified(Context ctx, String billId) throws BOSException, EASBizException {
        if (billId == null || billId.trim().length() == 0) {
            return false;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("select fid from T_AR_VerificationBillEntry where FBillID = ? ");
        sb.append(" union all ");
        sb.append("select fid from T_AP_VerificationBillEntry where FBillID = ? ");
        ArrayList<String> vs = new ArrayList<String>();
        vs.add(billId);
        vs.add(billId);
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])vs.toArray());
        try {
            if (result.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return false;
    }

    @Override
    protected IObjectPK _pay2RecVerification(Context ctx, IObjectValue verificationBill) throws BOSException, EASBizException {
        return this._verification(ctx, verificationBill);
    }

    @Override
    protected IObjectPK _ap2ArVerification(Context ctx, IObjectValue verificationBill) throws BOSException, EASBizException {
        return this._verification(ctx, verificationBill);
    }

    @Override
    protected IObjectPK _preparePay2PreRecVerification(Context ctx, IObjectValue verificationBill) throws BOSException, EASBizException {
        return this._verification(ctx, verificationBill);
    }

    protected IObjectPK _PurVerification(Context ctx, IObjectValue verificationBill) throws BOSException, EASBizException {
        return this._verification(ctx, verificationBill);
    }

    @Override
    protected IObjectPK _purVerification(Context ctx, IObjectValue verificationBill) throws BOSException, EASBizException {
        return this._verification(ctx, verificationBill);
    }

    @Override
    protected RowSet _getApVerificationBill(Context ctx, String billID) throws BOSException, EASBizException {
        String lang = ctx.getLocale().getLanguage();
        StringBuffer sb = new StringBuffer("select top ");
        sb.append(10000);
        sb.append("VERIFICATIONBILL.FID AS ID,");
        sb.append("COMPANY.FName_").append(lang).append(" AS COMPANY_NAME,");
        sb.append("VERIFICATIONBILL.FNumber AS NUMBER,");
        sb.append("VERIFICATIONBILL.FBizDate AS BIZDATE,");
        sb.append("ENTRYS.FBillDate AS ENTRYS_BILLDATE,");
        sb.append("ENTRYS.FBillNumber AS ENTRYS_BILLNUMBER,");
        sb.append("ENTRYS.FBillType AS ENTRYS_BILLTYPE,");
        sb.append("ENTRYS.FBillSubType AS ENTRYS_BILLSUBTYPE,");
        sb.append("ENTRYS.FVeriRecPayTypeName AS ENTRYS_VERIRECPAYTYPENAME,");
        sb.append("ENTRYS.FAcctCussName_").append(lang).append(" AS ENTRYS_ACCTCUSSNAME,");
        sb.append("ENTRYS.FComment AS ENTRYS_COMMENT,");
        sb.append("ADMINORGUNIT.FName_").append(lang).append(" AS ADMINORGUNIT_NAME,");
        sb.append("PERSON.FName_").append(lang).append(" AS PERSON_NAME,");
        sb.append("CURRENCY.FName_").append(lang).append(" AS CURRENCY_NAME,");
        sb.append("CURRENCY.FPrecision AS CURRENCY_PRECISION,");
        sb.append("ENTRYS.FMaterialNumber AS ENTRYS_MATERIALNUMBER,");
        sb.append("ENTRYS.FMaterialName AS ENTRYS_MATERIALNAME,");
        sb.append("ENTRYS.FThisVerificateAmt AS ENTRYS_THISVERIFICATEAMT,");
        sb.append("ENTRYS.FThisVerificateAmtLoc AS ENTRYS_THISVERIFICATEAMTLOC,");
        sb.append("ENTRYS.FGainAndLoss AS ENTRYS_GAINANDLOSS,");
        sb.append("CREATOR.FName_").append(lang).append(" AS CREATOR_NAME,");
        sb.append("VERIFICATIONBILL.FVerificationType AS VERIFICATIONTYPE,");
        sb.append("VERIFICATIONBILL.FISCASHSALEPUR AS ISCASHSALEPUR,");
        sb.append("VERIFICATIONBILL.FFiVouchered AS FIVOUCHERED,");
        sb.append("VOUCHERTYPE.FName_").append(lang).append(" AS VOUCHERTYPE_NAME,");
        sb.append("VOUCHER.FNumber AS VOUCHER_NUMBER,");
        sb.append("ENTRYS.FBillID AS ENTRYS_BILLID ");
        sb.append(" FROM T_AP_VerificationBill AS VERIFICATIONBILL ");
        sb.append(" INNER JOIN T_AP_VerificationBillentry AS ENTRYS ");
        sb.append(" ON ENTRYS.FParentID = VERIFICATIONBILL.FID ");
        sb.append(" LEFT OUTER JOIN T_ORG_Company AS COMPANY ");
        sb.append(" ON VERIFICATIONBILL.FCompanyID = COMPANY.FID ");
        sb.append(" LEFT OUTER JOIN T_PM_User AS CREATOR");
        sb.append(" ON VERIFICATIONBILL.FCreatorID = CREATOR.FID ");
        sb.append(" LEFT OUTER JOIN T_GL_Voucher AS VOUCHER");
        sb.append(" ON VERIFICATIONBILL.FVoucherID = VOUCHER.FID ");
        sb.append(" LEFT OUTER JOIN T_BD_VoucherTypes AS VOUCHERTYPE ");
        sb.append(" ON VERIFICATIONBILL.FVoucherTypeID = VOUCHERTYPE.FID ");
        sb.append(" LEFT OUTER JOIN T_BD_Currency AS CURRENCY ");
        sb.append(" ON ENTRYS.FCurrencyID = CURRENCY.FID ");
        sb.append(" LEFT OUTER JOIN T_ORG_Admin AS ADMINORGUNIT ");
        sb.append(" ON ENTRYS.FAdminOrgUnitID = ADMINORGUNIT.FID ");
        sb.append(" LEFT OUTER JOIN T_BD_Person AS PERSON ");
        sb.append(" ON ENTRYS.FPersonID = PERSON.FID ");
        sb.append(" WHERE ENTRYS.FParentID in (" + billID + ")");
        sb.append(" ORDER BY NUMBER ASC ");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        return result;
    }
}

