/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.ApBalanceFactory;
import com.kingdee.eas.fi.ap.BillStatusEnum;
import com.kingdee.eas.fi.ap.IApBalance;
import com.kingdee.eas.fi.ap.IInitDataInputAP;
import com.kingdee.eas.fi.ap.InitDataInputAPFactory;
import com.kingdee.eas.fi.ap.InitDataInputAPInfo;
import com.kingdee.eas.fi.ap.InitDataInputAPentryCollection;
import com.kingdee.eas.fi.ap.InitDataInputAPentryFactory;
import com.kingdee.eas.fi.ap.InitDataInputAPentryInfo;
import com.kingdee.eas.fi.ap.OtherBillFactory;
import com.kingdee.eas.fi.ap.app.AbstractInitDataInputAPControllerBean;
import com.kingdee.eas.fi.ap.app.util.ApServerUtils;
import com.kingdee.eas.fi.ar.ArApCommonException;
import com.kingdee.eas.fi.ar.IManageAccount;
import com.kingdee.eas.fi.ar.ManageAccountFactory;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.app.util.BaseDataUtil;
import com.kingdee.eas.fi.ar.app.util.CommonServerUtils;
import com.kingdee.eas.fi.arap.ProxyBillFactory;
import com.kingdee.eas.fi.arap.app.util.ArApServerUtils;
import com.kingdee.eas.fi.arap.util.ArApMutextUtils;
import com.kingdee.eas.fi.arap.util.ArApParamHelper;
import com.kingdee.eas.fi.arap.util.DataUtils;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.sql.RowSet;

public class InitDataInputAPControllerBean
extends AbstractInitDataInputAPControllerBean {
    private static final long serialVersionUID = 1L;
    public static final String GEN_LOC_CURRENCY = "11111111-1111-1111-1111-111111111111DEB58FDC";
    public static final String GEN_RPT_CURRENCY = "22222222-2222-2222-2222-222222222222DEB58FDC";
    public static final String NEW_LINE = " \r\n ";

    @Override
    protected RowSet _getBillHead(Context ctx, String companyID, String currencyID, java.util.Date date) throws BOSException, EASBizException {
        String lang = ctx.getLocale().getLanguage();
        StringBuilder sb = new StringBuilder(200).append(" select ").append(NEW_LINE);
        sb.append("t1.fid as id,");
        sb.append("t1.fstartPeriodid as period_id,");
        sb.append("t2.fperiodyear as period_year,");
        sb.append("t2.fperiodnumber as period_number,");
        sb.append("t1.fcreatorid as creator_id,");
        sb.append("t3.fname_").append(lang).append(" as creator_name,");
        sb.append("t3.fnumber as creator_number,");
        sb.append("t1.fcreatetime as createdate ").append(NEW_LINE);
        sb.append("from T_AP_InitDataInput t1 ");
        sb.append("left outer join T_BD_Period t2 on t1.fstartPeriodid = t2.fid ").append(NEW_LINE);
        sb.append("left outer join T_PM_User t3 on t1.fcreatorid = t3.fid ").append(NEW_LINE);
        sb.append("where t1.fcompanyid = ? and t1.fcurrencyid = ?");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new String[]{companyID, currencyID});
        return result;
    }

    @Override
    protected RowSet _getBillDetail(Context ctx, String companyID, String currencyID) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select id, number, name where id = '" + companyID + "'");
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.ACCOUNTSPAYABLE, (CompanyOrgUnitInfo)company);
        if (null == startPeriod) {
            throw new OtherBillBizException(OtherBillBizException.STARTPERIODISNULL, new Object[]{company.getName() + SystemEnum.ACCOUNTSPAYABLE.getAlias()});
        }
        String lang = ctx.getLocale().getLanguage();
        StringBuilder sb = new StringBuilder(800).append(" select ").append(NEW_LINE);
        sb.append("result.company_id as company_id,");
        sb.append("result.currency_id as currency_id,");
        sb.append("result.bizdate as bizDate,");
        sb.append("result.biztype as bizType,");
        sb.append("result.account_id as account_id,");
        sb.append("t2.fnumber as account_number,");
        sb.append("t2.fname_").append(lang).append(" as account_name,");
        sb.append("result.acctcusstype_id as acctcussType_id,").append(NEW_LINE);
        sb.append("t3.fname_").append(lang).append(" as acctcussType_name,").append(NEW_LINE);
        sb.append("t3.fnumber as acctcussType_number,").append(NEW_LINE);
        sb.append("t3.fdefaultqueryname as acctcussType_query,").append(NEW_LINE);
        sb.append("t3.FRealtionDataObject as realtionDataObject,").append(NEW_LINE);
        sb.append("result.acctcuss_id as acctcuss_id,").append(NEW_LINE);
        sb.append("result.isImpFromGL as isImpFromGL,").append(NEW_LINE);
        sb.append("result.year_direction as year_direction,").append(NEW_LINE);
        sb.append("0.0 as year_Amt,").append(NEW_LINE);
        sb.append("0.0 as year_AmtLoc,").append(NEW_LINE);
        sb.append("isnull(result.total_DebitAmt,0.0) as total_DebitAmt,").append(NEW_LINE);
        sb.append("isnull(result.total_DebitAmtLoc,0.0) as total_DebitAmtLoc,").append(NEW_LINE);
        sb.append("isnull(result.total_CreditAmt,0.0) as total_CreditAmt,").append(NEW_LINE);
        sb.append("isnull(result.total_CreditAmtLoc,0.0) as total_CreditAmtLoc,").append(NEW_LINE);
        sb.append("result.period_direction as period_direction,").append(NEW_LINE);
        sb.append("isnull(result.period_Amt,0.0) as period_Amt,").append(NEW_LINE);
        sb.append("isnull(result.period_AmtLoc,0.0) as period_AmtLoc, ").append(NEW_LINE);
        sb.append("result.isFromBill as isFromBill, ").append(NEW_LINE);
        sb.append("result.isBillCollected as isBillCollected, ").append(NEW_LINE);
        sb.append("result.isBizBill as isBizBill, ").append(NEW_LINE);
        sb.append("result.adminOrgUnit as adminOrgUnitId, ").append(NEW_LINE);
        sb.append("result.person as personId, ").append(NEW_LINE);
        sb.append("tAdmin.fnumber as adminOrgUnit_number,").append(NEW_LINE);
        sb.append("tAdmin.fname_").append(lang).append(" as adminOrgUnit_name,").append(NEW_LINE);
        sb.append("tPer.fnumber as person_number,").append(NEW_LINE);
        sb.append("tPer.fname_").append(lang).append(" as person_name ").append(NEW_LINE);
        String viewStr = this.createViewsNew(ctx, startPeriod, companyID, currencyID);
        sb.append("from (").append(viewStr).append(")  result ").append(NEW_LINE);
        sb.append("left outer join T_BD_AccountView t2 on result.account_id = t2.fid ").append(NEW_LINE);
        sb.append("left outer join T_BD_AsstActType t3 on result.acctcusstype_id = t3.fid ").append(NEW_LINE);
        sb.append("left join T_ORG_Admin tAdmin on result.adminOrgUnit = tAdmin.fid ").append(NEW_LINE);
        sb.append("left join T_BD_Person tPer on result.person = tPer.fid ").append(NEW_LINE);
        sb.append("order by  result.isFromBill desc,result.isbillcollected desc ");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        return result;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        InitDataInputAPInfo billInfo = (InitDataInputAPInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)billInfo.getCompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)billInfo.getCurrency().getId().toString()));
        filter.setMaskString(" #0 and #1");
        IInitDataInputAP inter = InitDataInputAPFactory.getLocalInstance(ctx);
        inter.delete(filter);
        InitDataInputAPInfo billInfo_temp = (InitDataInputAPInfo)model;
        InitDataInputAPentryCollection billentyInfo_temp = billInfo_temp.getEntrys();
        billInfo_temp.remove("entrys");
        IObjectPK billID = super._submit(ctx, (IObjectValue)billInfo_temp);
        billInfo_temp.setId(BOSUuid.read((String)billID.toString()));
        IORMappingDAO idao = null;
        Connection cn = this.getConnection(ctx);
        idao = ORMappingDAO.getInstance((BOSObjectType)new InitDataInputAPentryInfo().getBOSType(), (Context)ctx, (Connection)cn);
        int entrySize = 0;
        int size = billentyInfo_temp.size();
        for (int i = 0; i < size; ++i) {
            InitDataInputAPentryInfo billentyInfo = billentyInfo_temp.get(i);
            billentyInfo.setParent(billInfo_temp);
            idao.addNewBatch((IObjectValue)billentyInfo);
            if (++entrySize <= 2000) continue;
            idao.executeBatch();
            entrySize = 0;
        }
        if (entrySize > 0) {
            idao.executeBatch();
        }
        SQLUtils.cleanup((Connection)cn);
        return billID;
    }

    @Override
    protected Vector _doCheck(Context ctx, String companyID) throws BOSException, EASBizException {
        Vector result = new Vector();
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo company = iCompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyID)));
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.ACCOUNTSPAYABLE, (CompanyOrgUnitInfo)company);
        if (currentPeriod == null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("error", "period_isnull");
            result.add(map);
            return result;
        }
        HashMap paramMap = new HashMap();
        paramMap.put("AP_INIT_CHECK_TYPE", companyID);
        IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
        paramMap = iParamControl.getParamHashMap(paramMap);
        boolean isContrastByBillAccount = ArApParamHelper.isContrastByBillAccount(ctx, companyID, currentPeriod.getNumber(), false);
        paramMap.put("AR_045", isContrastByBillAccount);
        String period_id = currentPeriod.getString("id");
        this.doNonControlAccountCheck(ctx, company, period_id, result, paramMap);
        this.doDetailCheck(ctx, company, currentPeriod, result, paramMap);
        this.doNonControlDetailCheck(ctx, company, period_id, result, paramMap);
        this.filterCheckResult(result);
        return result;
    }

    private void filterCheckResult(Vector result) {
        BigDecimal ZERO = new BigDecimal("0.00");
        for (int i = 0; i < result.size(); ++i) {
            HashMap hmResult = (HashMap)result.get(i);
            if (hmResult.get("debitAmt") == null && hmResult.get("debitAmt") == null && hmResult.get("debitAmtLoc") == null && hmResult.get("creditAmt") == null && hmResult.get("creditAmtLoc") == null && hmResult.get("periodAmt") == null && hmResult.get("periodAmtLoc") == null && ((BigDecimal)hmResult.get("glDebitAmt")).compareTo(ZERO) == 0 && ((BigDecimal)hmResult.get("glDebitAmtLoc")).compareTo(ZERO) == 0 && ((BigDecimal)hmResult.get("glCreditAmt")).compareTo(ZERO) == 0 && ((BigDecimal)hmResult.get("glCreditAmtLoc")).compareTo(ZERO) == 0 && ((BigDecimal)hmResult.get("glPeriodAmt")).compareTo(ZERO) == 0 && ((BigDecimal)hmResult.get("glPeriodAmtLoc")).compareTo(ZERO) == 0) {
                result.remove(hmResult);
                --i;
                continue;
            }
            if (hmResult.get("glDebitAmt") != null || hmResult.get("glDebitAmt") != null || hmResult.get("glDebitAmtLoc") != null || hmResult.get("glCreditAmt") != null || hmResult.get("glCreditAmtLoc") != null || hmResult.get("glPeriodAmt") != null || hmResult.get("glPeriodAmtLoc") != null || ((BigDecimal)hmResult.get("debitAmt")).compareTo(ZERO) != 0 || ((BigDecimal)hmResult.get("debitAmtLoc")).compareTo(ZERO) != 0 || ((BigDecimal)hmResult.get("creditAmt")).compareTo(ZERO) != 0 || ((BigDecimal)hmResult.get("creditAmtLoc")).compareTo(ZERO) != 0 || ((BigDecimal)hmResult.get("periodAmt")).compareTo(ZERO) != 0 || ((BigDecimal)hmResult.get("periodAmtLoc")).compareTo(ZERO) != 0) continue;
            result.remove(hmResult);
            --i;
        }
    }

    private void doDetailCheck(Context ctx, CompanyOrgUnitInfo company, PeriodInfo period, Vector result, Map paramMap) throws BOSException, EASBizException {
        String periodId = period.getId().toString();
        String lang = ctx.getLocale().getLanguage();
        String companyId = company.getString("id");
        boolean isNewContrast = (Boolean)paramMap.get("AR_045");
        int checkType = Integer.parseInt((String)paramMap.get("AP_INIT_CHECK_TYPE"));
        String tableName = ArApServerUtils.getContrastTableName(isNewContrast, false);
        StringBuffer sb = new StringBuffer("select * from (");
        sb.append("select Distinct ");
        sb.append("t1.FAccount as account_id,t2.FNumber as account_number,t2.FName_").append(lang).append(" as account_name,");
        sb.append("t1.FCurrencyID as currency_id,t3.FNumber as currency_number,");
        sb.append("t3.FName_").append(lang).append(" as currency_name,t3.FPrecision as currency_prec ");
        sb.append("from " + tableName + " t1 ");
        sb.append("inner join T_BD_AccountView t2 on t1.FAccount = t2.FID ");
        sb.append("inner join T_BD_Currency t3 on t1.FCurrencyID = t3.FID ");
        sb.append("inner join T_BD_AsstActType t4 on t1.FAsstActTypeID = t4.FID ");
        sb.append("where t2.FIsLeaf = 1 and t2.FControl = ").append(2).append(" ");
        if (isNewContrast) {
            sb.append(" and t1.FISDELETED = 0 ");
        }
        sb.append("and t1.FCompanyID = ? and t1.FPeriodID= ? ");
        sb.append("and t1.FCurrencyID !='").append(GEN_LOC_CURRENCY).append("' ");
        sb.append("and t1.FCurrencyID !='").append(GEN_RPT_CURRENCY).append("' ");
        sb.append("union ");
        sb.append("select Distinct ");
        sb.append("t1.FAccountID as account_id,t2.FNumber as account_number,t2.FName_").append(lang).append(" as account_name,");
        sb.append("t1.FCurrencyID as currency_id,t3.FNumber as currency_number,");
        sb.append("t3.FName_").append(lang).append(" as currency_name,t3.FPrecision as currency_prec ");
        sb.append("from T_GL_AssistBalance_5F t1 ");
        sb.append("inner join T_BD_AccountView t2 on t1.FAccountID = t2.FID ");
        sb.append("inner join T_BD_Currency t3 on t1.FCurrencyID = t3.FID ");
        sb.append("where t2.FIsLeaf = 1 and t2.FControl = ").append(2);
        sb.append(" and t1.ForgUnitID = ? and t1.FPeriod = ? ");
        sb.append(")  result ");
        sb.append(" order by result.currency_number ,result.account_number");
        ArrayList<Object> vs = new ArrayList<Object>();
        vs.add(companyId);
        vs.add(periodId);
        vs.add(companyId);
        vs.add(period.getNumber());
        IRowSet account = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])vs.toArray());
        sb = new StringBuffer("select distinct ");
        sb.append("FAsstActTypeID from T_BD_AsstActTypeDefault ");
        sb.append("where FIsAccountCussent = 1 and FCompanyID = ? ");
        vs.clear();
        vs.add(companyId);
        IRowSet defaultAsstActTypes = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])vs.toArray());
        Vector<String> v_def_asstacttype = new Vector<String>();
        Vector<String> v_all_asstacttype = new Vector<String>();
        boolean isEmptyAsstType = false;
        try {
            while (defaultAsstActTypes.next()) {
                isEmptyAsstType = true;
                v_def_asstacttype.add(defaultAsstActTypes.getString("FAsstActTypeID"));
                v_all_asstacttype.add(defaultAsstActTypes.getString("FAsstActTypeID"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (!isEmptyAsstType) {
            throw new ArApCommonException(ArApCommonException.NOTSETASSTTYPE);
        }
        sb = new StringBuffer("select distinct ");
        sb.append("FAsstActTypeID from " + tableName + " ");
        sb.append("where FCompanyID = ? and FPeriodID = ? ");
        if (isNewContrast) {
            sb.append(" and FISDELETED = 0 ");
        }
        vs.clear();
        vs.add(companyId);
        vs.add(periodId);
        IRowSet apAsstActTypes = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])vs.toArray());
        Vector<String> v_ap_asstacttype = new Vector<String>();
        try {
            while (apAsstActTypes.next()) {
                v_ap_asstacttype.add(apAsstActTypes.getString("FAsstActTypeID"));
                if (v_all_asstacttype.contains(apAsstActTypes.getString("FAsstActTypeID"))) continue;
                v_all_asstacttype.add(apAsstActTypes.getString("FAsstActTypeID"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        try {
            HashMap<String, Object> filter = null;
            while (account.next()) {
                Vector<String> vcAsst = new Vector<String>();
                String asstAccountID = null;
                sb = new StringBuffer("select distinct t4.FID as asstacttype_id ,t4.FNumber,t1.FCAA as asstAccountID ");
                sb.append(" from T_BD_AccountView t1 ");
                sb.append(" inner join T_BD_AsstAccount t2 on t1.FCAA=t2.FID ");
                sb.append(" inner join T_BD_AsstActGroupDetail t3 on t3.FAsstAccountID=t2.FID ");
                sb.append(" inner join T_BD_AsstActType t4 on t3.FAsstActTypeID = t4.FID ");
                sb.append(" inner join T_AR_ContrastAccountView t5 on t1.FID = t5.FAccountID");
                sb.append(" where t1.FControl = ").append(2).append(" and t1.FID = ? ");
                sb.append(" and t5.FAsstActTypeID = t4.FID");
                sb.append(" order by t4.FNumber ");
                vs.clear();
                vs.add(account.getString("account_id"));
                IRowSet account_asstacttypes = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])vs.toArray());
                Vector<String> v_account_asstacttype = new Vector<String>();
                try {
                    boolean brFlag = false;
                    while (account_asstacttypes.next()) {
                        brFlag = true;
                        v_account_asstacttype.add(account_asstacttypes.getString("asstacttype_id"));
                        asstAccountID = account_asstacttypes.getString("asstAccountID");
                        if (v_all_asstacttype.contains(account_asstacttypes.getString("asstacttype_id"))) continue;
                        v_all_asstacttype.add(account_asstacttypes.getString("asstacttype_id"));
                    }
                    if (!brFlag) {
                        continue;
                    }
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
                for (int x = 0; x < v_all_asstacttype.size(); ++x) {
                    int i;
                    filter = new HashMap<String, Object>();
                    ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)v_all_asstacttype.get(x).toString()));
                    AsstActTypeInfo asstacttype = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeInfo((IObjectPK)pk);
                    filter.put("tableName", asstacttype.getRealtionDataObject());
                    filter.put("fieldName", asstacttype.getMappingFieldName());
                    filter.put("contrastTableName", tableName);
                    filter.put("company_id", companyId);
                    filter.put("account_id", account.getString("account_id"));
                    filter.put("currency_id", account.getString("currency_id"));
                    filter.put("period_id", periodId);
                    filter.put("period_number", period.getNumber());
                    filter.put("asstacttype_id", v_all_asstacttype.get(x));
                    HashMap<String, String> tmp = null;
                    Vector<HashMap<String, String>> apbalance = new Vector<HashMap<String, String>>();
                    if (v_ap_asstacttype.contains(v_all_asstacttype.get(x))) {
                        if (v_account_asstacttype.contains(v_all_asstacttype.get(x))) {
                            vcAsst.add(asstAccountID);
                        }
                        RowSet tmprowset = ArApServerUtils.getArApBalance(ctx, filter, checkType, false, false);
                        while (tmprowset.next()) {
                            tmp = new HashMap<String, String>();
                            tmp.put("acctcuss_id", tmprowset.getString("acctcuss_id"));
                            tmp.put("acctcuss_number", tmprowset.getString("acctcuss_number"));
                            tmp.put("acctcuss_name", tmprowset.getString("acctcuss_name"));
                            tmp.put("debitAmt", (String)((Object)tmprowset.getBigDecimal("debitAmt")));
                            tmp.put("debitAmtLoc", (String)((Object)tmprowset.getBigDecimal("debitAmtLoc")));
                            tmp.put("creditAmt", (String)((Object)tmprowset.getBigDecimal("creditAmt")));
                            tmp.put("creditAmtLoc", (String)((Object)tmprowset.getBigDecimal("creditAmtLoc")));
                            tmp.put("periodAmt", (String)((Object)tmprowset.getBigDecimal("periodAmt")));
                            tmp.put("periodAmtLoc", (String)((Object)tmprowset.getBigDecimal("periodAmtLoc")));
                            apbalance.add(tmp);
                        }
                    }
                    Vector<HashMap<String, String>> glbalance = new Vector<HashMap<String, String>>();
                    if (v_def_asstacttype.contains(v_all_asstacttype.get(x)) && v_account_asstacttype.contains(v_all_asstacttype.get(x))) {
                        if (v_ap_asstacttype.contains(v_all_asstacttype.get(x)) || vcAsst.contains(asstAccountID)) {
                            // empty if block
                        }
                        RowSet tmprowset = ArApServerUtils.getGlBalance(ctx, filter, checkType, false, false);
                        while (tmprowset.next()) {
                            tmp = new HashMap<String, String>();
                            tmp.put("acctcuss_id", tmprowset.getString("acctcuss_id"));
                            tmp.put("acctcuss_number", tmprowset.getString("acctcuss_number"));
                            tmp.put("acctcuss_name", tmprowset.getString("acctcuss_name"));
                            tmp.put("glDebitAmt", (String)((Object)tmprowset.getBigDecimal("glDebitAmt")));
                            tmp.put("glDebitAmtLoc", (String)((Object)tmprowset.getBigDecimal("glDebitAmtLoc")));
                            tmp.put("glCreditAmt", (String)((Object)tmprowset.getBigDecimal("glCreditAmt")));
                            tmp.put("glCreditAmtLoc", (String)((Object)tmprowset.getBigDecimal("glCreditAmtLoc")));
                            tmp.put("glPeriodAmt", (String)((Object)tmprowset.getBigDecimal("glPeriodAmt")));
                            tmp.put("glPeriodAmtLoc", (String)((Object)tmprowset.getBigDecimal("glPeriodAmtLoc")));
                            glbalance.add(tmp);
                        }
                    }
                    HashMap tmp1 = null;
                    HashMap tmp2 = null;
                    block15: for (i = 0; i < apbalance.size(); ++i) {
                        tmp1 = (HashMap)apbalance.get(i);
                        for (int j = 0; j < glbalance.size(); ++j) {
                            tmp2 = (HashMap)glbalance.get(j);
                            if (!tmp1.get("acctcuss_id").toString().equals(tmp2.get("acctcuss_id").toString())) continue;
                            if (((BigDecimal)tmp1.get("debitAmt")).compareTo((BigDecimal)tmp2.get("glDebitAmt")) != 0 || ((BigDecimal)tmp1.get("debitAmtLoc")).compareTo((BigDecimal)tmp2.get("glDebitAmtLoc")) != 0 || ((BigDecimal)tmp1.get("creditAmt")).compareTo((BigDecimal)tmp2.get("glCreditAmt")) != 0 || ((BigDecimal)tmp1.get("creditAmtLoc")).compareTo((BigDecimal)tmp2.get("glCreditAmtLoc")) != 0 || ((BigDecimal)tmp1.get("periodAmt")).compareTo((BigDecimal)tmp2.get("glPeriodAmt")) != 0 || ((BigDecimal)tmp1.get("periodAmtLoc")).compareTo((BigDecimal)tmp2.get("glPeriodAmtLoc")) != 0) {
                                tmp1.putAll(tmp2);
                                tmp1.put("account", account.getString("account_number") + " " + account.getString("account_name"));
                                tmp1.put("currency", account.getString("currency_name"));
                                tmp1.put("currency_prec", account.getString("currency_prec"));
                                tmp1.put("asstacttype", asstacttype.getName());
                                result.add(tmp1);
                            }
                            apbalance.remove(tmp1);
                            glbalance.remove(tmp2);
                            --i;
                            continue block15;
                        }
                    }
                    for (i = 0; i < apbalance.size(); ++i) {
                        tmp = (HashMap<String, String>)apbalance.get(i);
                        tmp.put("account", account.getString("account_number") + " " + account.getString("account_name"));
                        tmp.put("currency", account.getString("currency_name"));
                        tmp.put("currency_prec", account.getString("currency_prec"));
                        tmp.put("asstacttype", asstacttype.getName());
                        result.add(tmp);
                    }
                    for (i = 0; i < glbalance.size(); ++i) {
                        tmp = (HashMap)glbalance.get(i);
                        tmp.put("account", account.getString("account_number") + " " + account.getString("account_name"));
                        tmp.put("currency", account.getString("currency_name"));
                        tmp.put("currency_prec", account.getString("currency_prec"));
                        tmp.put("asstacttype", asstacttype.getName());
                        result.add(tmp);
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    protected boolean finishedInit(Context ctx, String companyID, boolean flag, java.util.Date date) throws BOSException, EASBizException {
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo company = iCompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyID)));
        SystemStatusCtrolInfo sysStsCtrInfo = CommonServerUtils.getSysStatusCtrolInfo(ctx, companyID, SystemEnum.ACCOUNTSPAYABLE);
        PeriodInfo startPeriod = null == sysStsCtrInfo ? null : sysStsCtrInfo.getStartPeriod();
        boolean isContrastByBillAccount = false;
        if (startPeriod == null) {
            throw new ArApCommonException(ArApCommonException.STARTPERIOD_NULL);
        }
        if (flag) {
            this._checkBillBeforeFin(ctx, companyID, date);
            this.checkAccountIsNullNew(ctx, startPeriod.getBeginDate(), companyID, startPeriod.getId().toString());
            ArApParamHelper.updateStartPeriodForAR_045(ctx, companyID, startPeriod, false);
            IApBalance iApBalance = ApBalanceFactory.getLocalInstance(ctx);
            iApBalance.initialEnd(flag);
            IManageAccount iManageAccount = ManageAccountFactory.getLocalInstance(ctx);
            iManageAccount.reComputeApInitAccountBalance();
            ApServerUtils.apStart(ctx, company);
        } else {
            ApServerUtils.apReverseStart(ctx, company);
            ArApServerUtils.checkForReverseInit(ctx, companyID, false);
        }
        UserInfo currentUser = (UserInfo)ctx.get((Object)"UserInfo");
        Connection cnn = this.getConnection(ctx);
        PreparedStatement ps = null;
        StringBuilder sb = new StringBuilder(200);
        try {
            sb.append("update T_AP_OtherBill set ");
            sb.append("FBillStatus = ?, FAuditorID = ?, FAuditDate = ? ,FFivouchered = ? ").append(NEW_LINE);
            sb.append("where FCompanyID = ? and FBillDate < ? ").append(NEW_LINE);
            sb.append(" and Fsourcebilltype != ").append(14).append(NEW_LINE);
            sb.append(" and FIsInitializeBill = 1 ");
            ps = cnn.prepareStatement(sb.toString());
            if (flag) {
                ps.setInt(1, 3);
                ps.setString(2, currentUser.getString("id"));
                ps.setDate(3, this.changeDate(date, -1));
                ps.setInt(4, 1);
                ps.setString(5, companyID);
                ps.setDate(6, (Date)date);
            } else {
                ps.setInt(1, 2);
                ps.setNull(2, 12);
                ps.setNull(3, 91);
                ps.setInt(4, 0);
                ps.setString(5, companyID);
                ps.setDate(6, (Date)date);
            }
            ps.execute();
            sb.setLength(0);
            sb.append("UPDATE T_AP_OTHERBILLENTRY AS entry SET");
            if (flag) {
                sb.append(" FWRITTENOFFBASEQTY = FBASEQTY, FLOCALWRITTENOFFAMOUNT = FAMOUNTLOCAL,");
                sb.append(" FUNWRITEOFFBASEQTY = 0, FLOCALUNWRITEOFFAMOUNT = 0");
            } else {
                sb.append(" FWRITTENOFFBASEQTY = 0, FLOCALWRITTENOFFAMOUNT = 0,");
                sb.append(" FUNWRITEOFFBASEQTY = FBASEQTY, FLOCALUNWRITEOFFAMOUNT = FAMOUNTLOCAL");
            }
            sb.append(" WHERE EXISTS (SELECT 1 FROM T_AP_OTHERBILL bill WHERE");
            sb.append(" bill.FID = entry.FParentID AND bill.FCompanyID = ? AND bill.FBillDate < ?");
            sb.append(" AND bill.Fsourcebilltype != 14 AND bill.FIsInitializeBill = 1 ");
            sb.append(" and bill.FIsBizBill = 0 and entry.FSourceBillID is null )");
            ps = cnn.prepareStatement(sb.toString());
            ps.setString(1, companyID);
            ps.setDate(2, (Date)date);
            ps.execute();
            sb.setLength(0);
            sb.append("update T_CAS_PaymentBill set ");
            sb.append("FBillStatus = ?, FAuditorID = ?, FCashierID = ?,FAuditDate = ? ,FFivouchered = ? ");
            sb.append("where (FSourceType = ").append(100).append(" or FSourceType = ").append(101).append(") and FIsInitializeBill = 1 and FCompanyID = ? ");
            ps = cnn.prepareStatement(sb.toString());
            if (flag) {
                ps.setInt(1, 15);
                ps.setString(2, currentUser.getString("id"));
                ps.setString(3, currentUser.getString("id"));
                ps.setDate(4, this.changeDate(date, -1));
                ps.setInt(5, 1);
                ps.setString(6, companyID);
            } else {
                ps.setInt(1, 11);
                ps.setNull(2, 12);
                ps.setNull(3, 12);
                ps.setNull(4, 91);
                ps.setInt(5, 0);
                ps.setString(6, companyID);
            }
            ps.execute();
            if (!flag) {
                sb.setLength(0);
                sb.append("DELETE FROM %s WHERE FCOMPANYID = ?");
                ArrayList<String> tableNames = new ArrayList<String>(2);
                tableNames.add("T_AP_ApBalance");
                tableNames.add(isContrastByBillAccount ? "T_AP_ApBillAccountBalance" : "T_AP_ApBalanceCollate");
                for (int i = 0; i < tableNames.size(); ++i) {
                    ps = cnn.prepareStatement(String.format(sb.toString(), tableNames.get(i)));
                    ps.setString(1, companyID);
                    ps.execute();
                }
                DbUtil.execute((Context)ctx, (String)("DELETE FROM T_ARAP_CONTRASTPARAMRECORD WHERE FCOMPANYID = '" + companyID + "' AND FISAR = 0"));
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)cnn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)cnn);
        return true;
    }

    private void _checkBillBeforeFin(Context ctx, String companyID, java.util.Date date) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("BillStatus", (Object)new Integer(BillStatusEnum.AUDITED.getValue()), CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("CompanyOrgUnit.id", (Object)companyID));
        filterInfo.getFilterItems().add(new FilterItemInfo("BillDate", (Object)date, CompareType.LESS));
        filterInfo.setMaskString("#0 and #1 and #2");
        viewInfo.setFilter(filterInfo);
        CoreBillBaseCollection collection = ProxyBillFactory.getLocalInstance(ctx).getCoreBillBaseCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            throw new ArApCommonException(ArApCommonException.INITEXIST_UNAUDIT_PROXYBILL);
        }
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("billStatus", (Object)BillStatusEnum.SAVE));
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyID));
        filterInfo.getFilterItems().add(new FilterItemInfo("isInitializeBill", (Object)Boolean.TRUE));
        viewInfo.setFilter(filterInfo);
        collection = OtherBillFactory.getLocalInstance(ctx).getCoreBillBaseCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            throw new ArApCommonException(ArApCommonException.INITEXIST_SAVE_APOTHERBILL);
        }
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("billStatus", (Object)com.kingdee.eas.fi.cas.BillStatusEnum.SAVE));
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyID));
        filterInfo.getFilterItems().add(new FilterItemInfo("isInitializeBill", (Object)Boolean.TRUE));
        filterInfo.getFilterItems().add(new FilterItemInfo("sourceType", (Object)101, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        collection = PaymentBillFactory.getLocalInstance((Context)ctx).getCoreBillBaseCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            throw new ArApCommonException(ArApCommonException.INITEXIST_SAVE_PAYBILL);
        }
    }

    private Date changeDate(java.util.Date oldTime, int count) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(oldTime.getTime() + 86400000L * (long)count);
        GregorianCalendar result = new GregorianCalendar(calendar.get(1), calendar.get(2), calendar.get(5));
        return new Date(result.getTime().getTime());
    }

    @Override
    protected boolean _finishedInit(Context ctx, String companyID, java.util.Date date) throws BOSException, EASBizException {
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)this.getBOSType(), null, (String)"", (String)"ap_initdata_finished");
        boolean ret = this.finishedInit(ctx, companyID, true, date);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
        return ret;
    }

    @Override
    protected boolean _unFinishedInit(Context ctx, String companyID, java.util.Date date) throws BOSException, EASBizException {
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)this.getBOSType(), null, (String)"", (String)"ap_initdata_unFinished");
        boolean ret = this.finishedInit(ctx, companyID, false, date);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchFinishInit(Context ctx, boolean isDoFinish, List companyIdList) throws BOSException {
        ISystemStatusCtrol sys = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        PeriodInfo startPeriod = null;
        java.util.Date beginDate = null;
        HashMap<String, String> result = new HashMap<String, String>();
        String res = "com.kingdee.eas.fi.arap.ArapResource";
        Uuid mutexID = Uuid.create();
        MutexParameter param = null;
        boolean isLocked = false;
        int len = companyIdList.size();
        for (int i = 0; i < len; ++i) {
            String companyId = (String)companyIdList.get(i);
            try {
                param = ArApMutextUtils.getAPInitMutextPara(ctx, mutexID, MutexLockType.EXCLUSIVE_LOCK, BOSUuid.read((String)companyId), ContextUtil.getCurrentUserInfo((Context)ctx).getId(), ctx.getAIS());
                isLocked = ArApMutextUtils.requestMutex(ctx, param);
                if (isLocked) {
                    startPeriod = sys.getStartPeriod(13, companyId);
                    beginDate = startPeriod.getBeginDate();
                    boolean bool = isDoFinish ? this._finishedInit(ctx, companyId, beginDate) : this._unFinishedInit(ctx, companyId, beginDate);
                    result.put(companyId, ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ArapResource", (String)"success", (Locale)ctx.getLocale()));
                    continue;
                }
                result.put(companyId, ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ArapResource", (String)"FINISH_INIT_MUTEX", (Locale)ctx.getLocale()));
                continue;
            }
            catch (EASBizException e) {
                result.put(companyId, ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ArapResource", (String)"fail", (Locale)ctx.getLocale(), (Object[])new String[]{e.getMessage()}));
                continue;
            }
            catch (BOSException e) {
                result.put(companyId, ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ArapResource", (String)"fail", (Locale)ctx.getLocale(), (Object[])new String[]{"BOSException Occured!"}));
                continue;
            }
            finally {
                if (isLocked) {
                    ArApMutextUtils.releaseMutex(ctx, mutexID);
                }
            }
        }
        return result;
    }

    private String createViewsNew(Context ctx, PeriodInfo startPeriod, String companyId, String currencyId) throws BOSException, EASBizException {
        String startPeriodID = startPeriod.getId().toString();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(startPeriod.getBeginDate());
        String dateStr = calendar.get(1) + "-" + (calendar.get(2) + 1) + "-" + calendar.get(5);
        StringBuilder sbWhere = new StringBuilder(100);
        sbWhere.append("(y2.FBizType = ").append(0);
        sbWhere.append(" or y2.FBizType = ").append(10);
        sbWhere.append(" or y2.FBizType = ").append(9);
        sbWhere.append(") ").append(NEW_LINE);
        String whereStr = sbWhere.toString();
        StringBuilder sb = new StringBuilder(600);
        sb.append("select t1.company_id AS company_id, t1.currency_id AS currency_id, t1.acctcussid AS acctcuss_id,").append(NEW_LINE);
        sb.append("\t\tnull bizDate, ").append(NEW_LINE);
        sb.append("\t\tCASE t1.billType ");
        sb.append("\t\t\tWHEN N'").append("204").append("' THEN ").append(204);
        sb.append("\t\t\telse ").append(202);
        sb.append("\t\tEND AS bizType, ").append(NEW_LINE);
        sb.append(" \tt1.accountID account_id, ").append(NEW_LINE);
        sb.append("\t\tt1.acctcussType_id, t1.period_direction AS year_direction, 0 total_DebitAmt,").append(NEW_LINE);
        sb.append("\t\t0 total_DebitAmtLoc, 0 total_CreditAmt,").append(NEW_LINE);
        sb.append("\t\t0 total_CreditAmtLoc, t1.period_direction period_direction,").append(NEW_LINE);
        sb.append("\t\tt1.billAmt AS period_Amt, t1.billAmtLoc AS period_AmtLoc, ").append(NEW_LINE);
        sb.append("\t\tt1.isImpFromGL, t1.isBizBill,").append(NEW_LINE);
        sb.append("\t\t1 isFromBill, t1.adminOrgUnit,t1.person ,1 isBillCollected ").append(NEW_LINE);
        sb.append("from ");
        sb.append("\t(select  company_id, currency_id, acctcussid, billType, acctcussType_id, ").append(NEW_LINE);
        sb.append("\t\t\tadminOrgUnit, person, accountID, 1 as period_direction, 0 isImpFromGL, 0 isBizBill, ").append(NEW_LINE);
        sb.append("\t\t\tsum(billAmt) billAmt, sum(billAmtLoc) billAmtLoc from ").append(NEW_LINE);
        sb.append(" \t\t( select a1.FCompanyID company_id, a1.FCurrencyId currency_id, a1.FPayeeid acctcussid,").append(NEW_LINE);
        sb.append(" \t\tcase when a4.FISPRESET = 1 then a4.fnumber else a5.fnumber END as billType, ").append(NEW_LINE);
        sb.append("\t\t\ta1.FPayeeTypeID acctcussType_id, a1.FAdminOrgUnitId adminOrgUnit,a1.FPersonID person, ").append(NEW_LINE);
        sb.append("\t\ta1.FOppAccountID accountID, a3.fdc fdc, a2.FHisUnVcAmount billAmt, a2.FHisUnVcLocAmount billAmtLoc ").append(NEW_LINE);
        sb.append(" \t\tFrom t_cas_paymentbill a1 Inner join T_Cas_PaymentBillEntry a2 ON a1.fid = a2.FPaymentBillID ").append(NEW_LINE);
        sb.append(" \t\tleft outer join T_BD_AccountView a3 on a1.FOppAccountID = a3.fid  ").append(NEW_LINE);
        sb.append("\t\tinner join T_CAS_PaymentBillType a4 on a1.FPayBillTypeID = a4.fid ").append(NEW_LINE);
        sb.append(" \tleft join T_CAS_PaymentBillType a5 on a4.FPRESETBILLTYPEID = a5.fid ").append(NEW_LINE);
        sb.append("\t\tWhere (a1.FSourceType = ").append(100);
        sb.append(" \tor a1.FSourceType = ").append(101).append(") ").append(NEW_LINE);
        sb.append("\t\tand a1.FBillStatus != ").append(10).append(" ").append(NEW_LINE);
        sb.append("\t\tand a1.FBizDate < {").append(dateStr).append("} ").append(NEW_LINE);
        sb.append("\t\tand a1.FCompanyID  = '").append(companyId).append("' ").append(NEW_LINE);
        sb.append("\t\tand a1.FCurrencyId  = '").append(currencyId).append("' ").append(NEW_LINE);
        sb.append(" \tand a1.FIsInitializeBill = 1 ) as temp ").append(NEW_LINE);
        sb.append("\t\tGroup by company_id, billType, currency_id, acctcussid, acctcussType_id,adminOrgUnit ,person, \taccountID, fdc ").append(NEW_LINE);
        sb.append(") t1 ").append(NEW_LINE);
        sb.append("UNION ALL ").append(NEW_LINE);
        sb.append("SELECT y1.FCompanyID AS company_id, y1.FCurrencyID AS currency_id,").append(NEW_LINE);
        sb.append("\t\ty2.FAcctCussID AS acctcuss_id, y2.FBizDate AS bizDate, y2.FBizType AS bizType,").append(NEW_LINE);
        sb.append("\t\ty2.FAccountID AS account_id, y2.FAcctCussType AS acctcussType_id,").append(NEW_LINE);
        sb.append("\t\ty2.FInitYearDirection AS year_direction, y2.FYearTotalDebitAmt AS total_DebitAmt,").append(NEW_LINE);
        sb.append("\t\ty2.FYearTotalDebitAmtLocal AS total_DebitAmtLoc,").append(NEW_LINE);
        sb.append("\t\ty2.FYearTotalCreditAmt AS total_CreditAmt,y2.FYearTotalCreditAmtLocal AS total_CreditAmtLoc,").append(NEW_LINE);
        sb.append("\t\ty2.FInitPeriodDirection AS period_direction, y2.finitperiodamt AS period_Amt,y2.finitperiodamtlocal AS period_AmtLoc, ").append(NEW_LINE);
        sb.append("\t\ty2.FIsImpFromGL as isImpFromGL, y2.FIsBizBill isBizBill,").append(NEW_LINE);
        sb.append("\t\t0 isFromBill ,y2.FAdminOrgUnitId adminOrgUnit,y2.FPersonId person ,y2.FIsBillCollected isBillCollected ").append(NEW_LINE);
        sb.append("FROM T_AP_InitDataInput y1 ").append(NEW_LINE);
        sb.append("\t\tINNER JOIN T_AP_InitDataInputEntry y2 ON y1.FID = y2.FParentID ").append(NEW_LINE);
        sb.append("where ( y2.FBizType = ").append(204);
        sb.append(" or   y2.FBizType =").append(202).append(" ) ").append(NEW_LINE);
        sb.append(" and y1.FStartPeriodID = '").append(startPeriodID).append("' ").append(NEW_LINE);
        sb.append("\tand y1.FCompanyID  = '").append(companyId).append("' ").append(NEW_LINE);
        sb.append("\tand y1.FCurrencyId  = '").append(currencyId).append("' ").append(NEW_LINE);
        sb.append("UNION ALL ").append(NEW_LINE);
        sb.append("SELECT t1.company_id, t1.currency_id, t1.acctcussid AS acctcuss_id,").append(NEW_LINE);
        sb.append("\t\tnull bizDate, ").append(NEW_LINE);
        sb.append("\t\tCASE t1.billType ");
        sb.append("\t\t\tWHEN ").append(201).append(" THEN ").append(9);
        sb.append("\t\t\tWHEN ").append(202).append(" THEN ").append(0);
        sb.append("\t\t\tWHEN ").append(203).append(" THEN ").append(10);
        sb.append("\t\t\tWHEN 1 THEN ").append(9);
        sb.append("\t\t\tWHEN 2 THEN ").append(0);
        sb.append("\t\tEND AS bizType, ").append(NEW_LINE);
        sb.append("\t\tt1.accountID account_id,");
        sb.append("\t\tt1.acctcussType_id, t1.period_direction AS year_direction, ").append(NEW_LINE);
        sb.append("\t\t0 total_DebitAmt,0 total_DebitAmtLoc, 0 total_CreditAmt,0 total_CreditAmtLoc,").append(NEW_LINE);
        sb.append("\t\tt1.period_direction period_direction,").append(NEW_LINE);
        sb.append("\t\tt1.billAmt AS period_Amt, t1.billAmtLoc AS period_AmtLoc, ").append(NEW_LINE);
        sb.append("\t\tt1.isImpFromGL AS isImpFromGL, t1.isBizBill,").append(NEW_LINE);
        sb.append(" \t1 isFromBill, t1.adminOrgUnit,t1.person ,1 isBillCollected  ").append(NEW_LINE);
        sb.append("FROM ").append(NEW_LINE);
        sb.append("\t\t(SELECT a1.FCompanyID AS company_id, a1.FcurrencyID AS currency_id, ").append(NEW_LINE);
        sb.append("\t\t\ta1.FAsstActID AS acctcussid, a1.FBillType AS billType,a1.FAsstActTypeID AS acctcussType_id, ").append(NEW_LINE);
        sb.append("\t\t\ta1.FAdminOrgUnitId adminOrgUnit ,a1.FPersonId person, ").append(NEW_LINE);
        sb.append(" \t\ta2.FAccountID accountID, -1 as period_direction, ").append(NEW_LINE);
        sb.append(" \t\t0 AS isImpFromGL, a1.FIsBizBill isBizBill, ").append(NEW_LINE);
        sb.append("\t\t\tSUM(a2.FHisUnVerifyAmount) AS billAmt,SUM(a2.FHisUnVerifyAmountLocal) AS billAmtLoc ").append(NEW_LINE);
        sb.append("\t\tFROM T_Ap_OtherBill a1 ").append(NEW_LINE);
        sb.append("\t\t\tINNER JOIN T_Ap_OtherBillEntry a2 ON a1.FId = a2.FParentID ").append(NEW_LINE);
        sb.append(" \t\tleft outer join T_BD_AccountView a3 on a2.FAccountID = a3.fid ").append(NEW_LINE);
        sb.append("\t\tWHERE a1.FBillDate < {").append(dateStr).append("} ").append(NEW_LINE);
        sb.append("\t\tand a1.FBillStatus != ").append(1).append(" ").append(NEW_LINE);
        sb.append(" \tand a1.FIsInitializeBill = 1 ").append(NEW_LINE);
        sb.append("\t    and a1.FCompanyID = '").append(companyId).append("' ").append(NEW_LINE);
        sb.append("  \tand a1.FCurrencyId = '").append(currencyId).append("' ").append(NEW_LINE);
        sb.append("\t\tGROUP BY a1.FCompanyID, a1.FCurrencyID, a1.FAsstActID, a1.FBillType, a1.FAsstActTypeID,a1.FAdminOrgUnitId ,a1.FPersonId ").append(NEW_LINE);
        sb.append(" \t,a2.FAccountID, a3.fdc,a1.FIsBizBill ").append(NEW_LINE);
        sb.append(") t1 ").append(NEW_LINE);
        sb.append("UNION ALL ").append(NEW_LINE);
        sb.append("SELECT y1.FCompanyID AS company_id, y1.FCurrencyID AS currency_id,").append(NEW_LINE);
        sb.append("\t\ty2.FAcctCussID AS acctcuss_id, y2.FBizDate AS bizDate, y2.FBizType AS bizType,").append(NEW_LINE);
        sb.append("\t\ty2.FAccountID AS account_id, y2.FAcctCussType AS acctcussType_id,").append(NEW_LINE);
        sb.append("\t\ty2.FInitYearDirection AS year_direction, y2.FYearTotalDebitAmt AS total_DebitAmt,").append(NEW_LINE);
        sb.append("\t\ty2.FYearTotalDebitAmtLocal AS total_DebitAmtLoc,y2.FYearTotalCreditAmt AS total_CreditAmt,").append(NEW_LINE);
        sb.append("\t\ty2.FYearTotalCreditAmtLocal AS total_CreditAmtLoc,").append(NEW_LINE);
        sb.append("\t\ty2.FInitPeriodDirection AS period_direction, y2.finitperiodamt AS period_Amt,y2.finitperiodamtlocal AS period_AmtLoc, ").append(NEW_LINE);
        sb.append("\t\ty2.FIsImpFromGL AS isImpFromGL, y2.FIsBizBill AS isBizBill, ").append(NEW_LINE);
        sb.append("\t\t0 isFromBill ,y2.FAdminOrgUnitId adminOrgUnit,y2.FPersonId person ,y2.FIsBillCollected isBillCollected ").append(NEW_LINE);
        sb.append("FROM T_AP_InitDataInput y1 ").append(NEW_LINE);
        sb.append("\t\tINNER JOIN T_AP_InitDataInputEntry y2 ON y1.FID = y2.FParentID ").append(NEW_LINE);
        sb.append("WHERE ").append(whereStr);
        sb.append(" and y1.FStartPeriodID = '").append(startPeriodID).append("' ").append(NEW_LINE);
        sb.append("\tand y1.FCompanyID  = '").append(companyId).append("' ").append(NEW_LINE);
        sb.append("\tand y1.FCurrencyId  = '").append(currencyId).append("' ").append(NEW_LINE);
        return sb.toString();
    }

    private boolean checkAccountIsNullNew(Context ctx, java.util.Date date, String companyID, String startPeriodId) throws BOSException, EASBizException {
        boolean flag = true;
        GregorianCalendar calendar = new GregorianCalendar();
        String lang = ctx.getLocale().getLanguage();
        calendar.setTime(date);
        String dateStr = calendar.get(1) + "-" + (calendar.get(2) + 1) + "-" + calendar.get(5);
        StringBuilder sb = new StringBuilder(600);
        sb.append("select t1.company_id AS company_id, t1.currency_id AS currency_id, ");
        sb.append("\t\tt1.acctcussid AS acctcuss_id,").append(NEW_LINE);
        sb.append("\t\tt1.acctcussname AS acctcuss_name, ").append(NEW_LINE);
        sb.append("\t\tCASE t1.billType ");
        sb.append("\t\t\tWHEN N'").append("204").append("' THEN ").append(204);
        sb.append("\t\t\telse ").append(202);
        sb.append("\t\tEND AS bizType, ").append(NEW_LINE);
        sb.append("\t\tt1.acctcussType_id,t1.accountid as accountid, t1.billAmt as billAmt, t1.adminID as adminID,t1.personID as personID,0 as isBizBill ").append(NEW_LINE);
        sb.append("from ").append(NEW_LINE);
        sb.append("\t(select  company_id, currency_id, acctcussid, acctcussname, billType, acctcussType_id, ").append(NEW_LINE);
        sb.append("\t\t\tadminID, personID, accountID, -1 as period_direction, 0 isImpFromGL, 0 isBizBill, ").append(NEW_LINE);
        sb.append("\t\t\tsum(billAmt) billAmt, sum(billAmtLoc) billAmtLoc from ").append(NEW_LINE);
        sb.append(" \t\t( select a1.FCompanyID company_id, a1.FCurrencyId currency_id, a1.FPayeeid acctcussid,a1.FPAYEENAME acctcussname, ").append(NEW_LINE);
        sb.append(" \t\tcase when a4.FISPRESET = 1 then a4.fnumber else a5.fnumber END as billType, ").append(NEW_LINE);
        sb.append("\t\t\ta1.FPayeeTypeID acctcussType_id, a1.FAdminOrgUnitId adminID,a1.FPersonID personID, ").append(NEW_LINE);
        sb.append("\t\ta1.FOppAccountID accountID, a3.fdc fdc, a2.FHisUnVcAmount billAmt, a2.FHisUnVcLocAmount billAmtLoc ").append(NEW_LINE);
        sb.append(" \t\tFrom t_cas_paymentbill a1 Inner join T_Cas_PaymentBillEntry a2 ON a1.fid = a2.FPaymentBillID ").append(NEW_LINE);
        sb.append(" \t\tleft outer join T_BD_AccountView a3 on a1.FOppAccountID = a3.fid  ").append(NEW_LINE);
        sb.append("\t\tinner join T_CAS_PaymentBillType a4 on a1.FPayBillTypeID = a4.fid ").append(NEW_LINE);
        sb.append(" \tleft join T_CAS_PaymentBillType a5 on a4.FPRESETBILLTYPEID = a5.fid ").append(NEW_LINE);
        sb.append("\t\tWhere (a1.FSourceType = ").append(100);
        sb.append(" \tor a1.FSourceType = ").append(101).append(") ").append(NEW_LINE);
        sb.append("\t\tand a1.FBillStatus != ").append(10).append(" ").append(NEW_LINE);
        sb.append("\t\tand a1.FBizDate < {").append(dateStr).append("} ").append(NEW_LINE);
        sb.append(" \tand a1.FIsInitializeBill = 1 ) as temp ").append(NEW_LINE);
        sb.append("\t\tGroup by company_id, billType, currency_id, acctcussid, acctcussname, acctcussType_id,adminID ,personID, accountID, fdc ").append(NEW_LINE);
        sb.append(") t1 ").append(NEW_LINE);
        sb.append("where t1.company_id = '").append(companyID).append("' ").append(NEW_LINE);
        sb.append("UNION ALL ").append(NEW_LINE);
        sb.append("SELECT t1.company_id as company_id, t1.currency_id as currency_id, ").append(NEW_LINE);
        sb.append("\t\tt1.acctcussid AS acctcuss_id,").append(NEW_LINE);
        sb.append("\t\tt1.acctcussname AS acctcuss_name, ").append(NEW_LINE);
        sb.append("\t\tCASE t1.billType ");
        sb.append("\t\t\tWHEN ").append(201).append(" THEN ").append(9);
        sb.append("\t\t\tWHEN ").append(202).append(" THEN ").append(0);
        sb.append("\t\t\tWHEN ").append(203).append(" THEN ").append(10);
        sb.append("\t\t\tWHEN 1 THEN ").append(9);
        sb.append("\t\t\tWHEN 2 THEN ").append(0);
        sb.append("\t\tEND AS bizType, ").append(NEW_LINE);
        sb.append("\t\tt1.acctcussType_id AS acctcussType_id, t1.accountid as accountid, t1.billAmt as billAmt, t1.adminID as adminID,t1.personID as personID,t1.isBizBill ").append(NEW_LINE);
        sb.append("FROM ").append(NEW_LINE);
        sb.append("\t\t(SELECT a1.FCompanyID AS company_id, a1.FcurrencyID AS currency_id, ").append(NEW_LINE);
        sb.append("\t\t\ta1.FAsstActID AS acctcussid,a1.FAsstActName_").append(lang).append(" AS acctcussname, a1.FBillType AS billType,a1.FAsstActTypeID AS acctcussType_id, ").append(NEW_LINE);
        sb.append("\t\t\ta2.FAccountID as accountid,SUM(a2.FHisUnVerifyAmount) AS billAmt,a1.FAdminOrgUnitId as adminID ,a1.FPersonID as personID,a1.FIsBizBill as isBizBill ").append(NEW_LINE);
        sb.append("\t\tFROM T_Ap_OtherBill a1 ").append(NEW_LINE);
        sb.append("\t\t\tINNER JOIN T_Ap_OtherBillEntry AS a2 ON a1.FId = a2.FParentID ").append(NEW_LINE);
        sb.append("\t\tWHERE a1.FBillDate < {").append(dateStr).append("} ").append(NEW_LINE);
        sb.append("\t\tand a1.FBillStatus != ").append(1).append(" ").append(NEW_LINE);
        sb.append(" \tand a1.FIsInitializeBill = 1 ");
        sb.append("\t\tGROUP BY a1.FCompanyID, a1.FCurrencyID, a1.FAsstActID, a1.FBillType,a1.FAsstActName_").append(lang).append(", a1.FAsstActTypeID  ,a1.FAdminOrgUnitId ,a1.FPersonID,a2.FAccountID,a1.FIsBizBill ").append(NEW_LINE);
        sb.append(") t1 ").append(NEW_LINE);
        sb.append("where t1.company_id = '").append(companyID).append("' ");
        IRowSet rsCheck = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            InitDataInputAPentryCollection colls;
            ICurrency iCurr = CurrencyFactory.getLocalInstance((Context)ctx);
            StringBuilder ids = new StringBuilder(200);
            StringBuilder newIds = new StringBuilder(200);
            Object[] params = new Object[1];
            int count = 0;
            while (rsCheck.next()) {
                sb.setLength(0);
                sb.append("SELECT t2.fid as entryid FROM T_AP_InitDataInput t1 ").append(NEW_LINE);
                sb.append("\t\tINNER JOIN T_AP_InitDataInputEntry t2 ON t1.FID = t2.FParentID ").append(NEW_LINE);
                sb.append("WHERE t1.FCompanyID = '").append(rsCheck.getString("company_id")).append("' ").append(NEW_LINE);
                sb.append("and t1.FCurrencyID = '").append(rsCheck.getString("currency_id")).append("' ").append(NEW_LINE);
                sb.append("and t1.FStartPeriodID = '").append(startPeriodId).append("' ").append(NEW_LINE);
                sb.append("and t2.FAcctCussID = '").append(rsCheck.getString("acctcuss_id")).append("' ").append(NEW_LINE);
                sb.append("and t2.FAcctCussType = '").append(rsCheck.getString("acctcussType_id")).append("' ").append(NEW_LINE);
                sb.append("and t2.FBizType = ").append(rsCheck.getInt("bizType")).append(" ").append(NEW_LINE);
                sb.append("and t2.FIsBillCollected = 1").append(" ").append(NEW_LINE);
                sb.append("and t2.FAccountID = '").append(rsCheck.getString("accountid")).append("' ").append(NEW_LINE);
                sb.append("and t2.Finitperiodamt = ").append(rsCheck.getBigDecimal("billAmt")).append(" ").append(NEW_LINE);
                sb.append("and t2.FIsBizBill = ").append(rsCheck.getString("isBizBill")).append(" ").append(NEW_LINE);
                if (rsCheck.getString("adminID") != null) {
                    sb.append("and t2.fadminorgunitid = '").append(rsCheck.getString("adminID")).append("' ").append(NEW_LINE);
                } else {
                    sb.append("and t2.fadminorgunitid is null ").append(NEW_LINE);
                }
                if (rsCheck.getString("personID") != null) {
                    sb.append("and t2.fpersonid = '").append(rsCheck.getString("personID")).append("' ").append(NEW_LINE);
                } else {
                    sb.append("and t2.fpersonid is null ").append(NEW_LINE);
                }
                IRowSet rsIsInInitData = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                if (rsIsInInitData.next()) {
                    if (++count == 999) {
                        ids.deleteCharAt(ids.length() - 1);
                        newIds.append(" and id not in (").append(ids.toString()).append(")");
                        ids.setLength(0);
                        count = 0;
                    }
                    ids.append("'").append(rsIsInInitData.getString("entryid")).append("',");
                    continue;
                }
                params[0] = InitDataInputAPControllerBean.getCurrencyName(ctx, iCurr, rsCheck.getString("currency_id"));
                throw new ArApCommonException(ArApCommonException.INITDATAOTHERCURRENCYNEW, params);
            }
            StringBuilder oql = new StringBuilder(300);
            oql.append("select parent.currency.name where parent.company ='").append(companyID).append("'");
            oql.append(" and isBillCollected = 1 ");
            if (newIds.length() > 0) {
                oql.append(newIds.toString());
            }
            if (ids.length() > 0) {
                ids.deleteCharAt(ids.length() - 1);
                oql.append(" and id not in (").append(ids.toString()).append(")");
            }
            if ((colls = InitDataInputAPentryFactory.getLocalInstance(ctx).getInitDataInputAPentryCollection(oql.toString())) != null && colls.size() > 0) {
                params[0] = colls.get(0).getParent().getCurrency().getName();
                throw new ArApCommonException(ArApCommonException.INITDATAOTHERCURRENCYNEW, params);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return flag;
    }

    private static String getCurrencyName(Context ctx, ICurrency iCurr, String id) throws EASBizException, BOSException {
        ObjectUuidPK pk = null;
        CurrencyInfo currInfo = null;
        pk = new ObjectUuidPK(id);
        SelectorItemCollection selects = new SelectorItemCollection();
        selects.add(new SelectorItemInfo("name"));
        currInfo = iCurr.getCurrencyInfo((IObjectPK)pk, selects);
        return currInfo.getName(ctx.getLocale());
    }

    private void doNonControlAccountCheck(Context ctx, CompanyOrgUnitInfo company, String periodId, Vector result, Map paramMap) throws BOSException, EASBizException {
        HashMap tmp1;
        int i;
        PeriodInfo period = BaseDataUtil.getPeriod(ctx, periodId);
        ObjectUuidPK orgPk = new ObjectUuidPK(company.getId());
        int checkType = Integer.parseInt((String)paramMap.get("AP_INIT_CHECK_TYPE"));
        boolean isNewContrast = (Boolean)paramMap.get("AR_045");
        String tableName = ArApServerUtils.getContrastTableName(isNewContrast, false);
        String lang = ctx.getLocale().getLanguage();
        String companyId = company.getString("id");
        StringBuffer sb = new StringBuffer("select t1.FCompanyID as company_id,");
        sb.append("t1.FAccount,t2.FName_").append(lang).append(" as account_name,t2.FNumber as account_number,");
        sb.append("t1.FCurrencyID,t3.FName_").append(lang).append(" as currency_name,t3.FNumber as currency_number,t3.FPrecision,");
        sb.append(ArApServerUtils.getArApBalanceAmtSql(checkType, false));
        sb.append("from " + tableName + " t1 ");
        sb.append("inner join T_BD_AccountView t2 on t1.FAccount = t2.fid ");
        sb.append("inner join T_BD_Currency t3 on t1.FCurrencyID = t3.fid ");
        sb.append("inner join T_AR_ContrastAccountView t4 on t1.FAccount = t4.FAccountID ");
        sb.append("where t1.FCompanyID = '").append(companyId).append("' ");
        if (isNewContrast) {
            sb.append(" and t1.FISDELETED = 0 ");
        }
        sb.append("and t1.FPeriodID= '").append(periodId).append("' ");
        sb.append("and t4.FSystem = 2 ");
        sb.append("and t4.FCompanyID = '").append(companyId).append("' ");
        sb.append("and t4.FPeriodYear = ").append(period.getPeriodYear());
        sb.append("and t4.FPeriodNumber = ").append(period.getPeriodNumber());
        sb.append("and ( t2.FControl = ").append(0).append(" ");
        sb.append("or t2.FControl = ").append(2).append(" ) ");
        sb.append("group by t1.FCompanyID,t1.FAccount,t1.FCurrencyID,t2.FName_").append(lang).append(",");
        sb.append("t2.FNumber,t3.FName_").append(lang).append(",t3.FNumber,t3.FPrecision");
        IRowSet tmprowset = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        Vector apbalance = new Vector();
        try {
            while (tmprowset.next()) {
                StringBuffer chkAccoutSb = new StringBuffer("select distinct t4.FID as asstacttype_id ");
                chkAccoutSb.append("from T_BD_AccountView t1 ");
                chkAccoutSb.append("inner join T_BD_AsstAccount t2 on t1.FCAA=t2.FID ");
                chkAccoutSb.append("inner join T_BD_AsstActGroupDetail t3 on t3.FAsstAccountID=t2.FID ");
                chkAccoutSb.append("inner join T_BD_AsstActType t4 on t3.FAsstActTypeID = t4.FID ");
                chkAccoutSb.append("where t1.FID = '").append(tmprowset.getString("FAccount")).append("'");
                IRowSet rsAccountAsstType = DbUtil.executeQuery((Context)ctx, (String)chkAccoutSb.toString());
                if (rsAccountAsstType.next()) continue;
                HashMap<String, Object> tmp = new HashMap<String, Object>();
                tmp.put("account_id", tmprowset.getString("FAccount"));
                tmp.put("account", tmprowset.getString("account_number") + " " + tmprowset.getString("account_name"));
                tmp.put("currency_id", tmprowset.getString("FCurrencyID"));
                tmp.put("currency", tmprowset.getString("currency_name"));
                tmp.put("currency_prec", tmprowset.getString("FPrecision"));
                tmp.put("debitAmt", tmprowset.getBigDecimal("debitAmt"));
                tmp.put("debitAmtLoc", tmprowset.getBigDecimal("debitAmtLoc"));
                tmp.put("creditAmt", tmprowset.getBigDecimal("creditAmt"));
                tmp.put("creditAmtLoc", tmprowset.getBigDecimal("creditAmtLoc"));
                tmp.put("periodAmt", tmprowset.getBigDecimal("periodAmt"));
                tmp.put("periodAmtLoc", tmprowset.getBigDecimal("periodAmtLoc"));
                apbalance.add(tmp);
            }
        }
        catch (SQLException ex) {
            throw new SQLDataException(ex);
        }
        sb = new StringBuffer("select t1.FOrgUnitID as company_id,");
        sb.append("t1.FAccountID,t2.FName_").append(lang).append(" as account_name,t2.FNumber as account_number,");
        sb.append("t1.FCurrencyID,t3.FName_").append(lang).append(" as currency_name,t3.FNumber as currency_number,t3.FPrecision,");
        sb.append(ArApServerUtils.getGLBalanceAmtSql(checkType, false));
        sb.append("from T_GL_AccountBalance_5f t1 ");
        sb.append("inner join T_BD_AccountView t2 on t1.faccountid = t2.fid ");
        sb.append("inner join T_BD_Currency t3 on t1.FCurrencyID = t3.fid ");
        sb.append("inner join T_AR_ContrastAccountView t4 on t1.FAccountid = t4.FAccountID ");
        sb.append("where t1.FOrgUnitID = '").append(companyId).append("' ");
        sb.append(" and t1.FPeriod = ").append(period.getNumber());
        sb.append(" and t4.FSystem = 2 ");
        sb.append("and t4.FCompanyID = '").append(companyId).append("' ");
        sb.append("and t4.FPeriodYear = ").append(period.getPeriodYear());
        sb.append("and t4.FPeriodNumber = ").append(period.getPeriodNumber());
        sb.append("and (t2.FControl = ").append(0).append(" ");
        sb.append("or t2.FControl = ").append(2).append(" ) ");
        sb.append("group by t1.FOrgUnitID,t1.FAccountID,t1.FCurrencyID,t2.FName_").append(lang).append(",");
        sb.append("t2.FNumber,t3.FName_").append(lang).append(",t3.FNumber,t3.FPrecision ");
        tmprowset = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        Vector glbalance = new Vector();
        try {
            while (tmprowset.next()) {
                StringBuffer chkAccoutSb = new StringBuffer("select distinct t4.FID as asstacttype_id ");
                chkAccoutSb.append("from T_BD_AccountView t1 ");
                chkAccoutSb.append("inner join T_BD_AsstAccount t2 on t1.FCAA=t2.FID ");
                chkAccoutSb.append("inner join T_BD_AsstActGroupDetail t3 on t3.FAsstAccountID=t2.FID ");
                chkAccoutSb.append("inner join T_BD_AsstActType t4 on t3.FAsstActTypeID = t4.FID ");
                chkAccoutSb.append("where t1.FID = '").append(tmprowset.getString("FAccountID")).append("'");
                IRowSet rsAccountAsstType = DbUtil.executeQuery((Context)ctx, (String)chkAccoutSb.toString());
                if (rsAccountAsstType.next()) continue;
                HashMap<String, Object> tmp = new HashMap<String, Object>();
                tmp.put("account_id", tmprowset.getString("FAccountID"));
                tmp.put("account", tmprowset.getString("account_number") + " " + tmprowset.getString("account_name"));
                tmp.put("currency_id", tmprowset.getString("FCurrencyID"));
                tmp.put("currency", tmprowset.getString("currency_name"));
                tmp.put("currency_prec", tmprowset.getString("FPrecision"));
                tmp.put("glDebitAmt", tmprowset.getBigDecimal("glDebitAmt"));
                tmp.put("glDebitAmtLoc", tmprowset.getBigDecimal("glDebitAmtLoc"));
                tmp.put("glCreditAmt", tmprowset.getBigDecimal("glCreditAmt"));
                tmp.put("glCreditAmtLoc", tmprowset.getBigDecimal("glCreditAmtLoc"));
                tmp.put("glPeriodAmt", tmprowset.getBigDecimal("glPeriodAmt"));
                tmp.put("glPeriodAmtLoc", tmprowset.getBigDecimal("glPeriodAmtLoc"));
                glbalance.add(tmp);
            }
        }
        catch (SQLException ex) {
            throw new SQLDataException(ex);
        }
        block6: for (i = 0; i < apbalance.size(); ++i) {
            tmp1 = (HashMap)apbalance.get(i);
            for (int j = 0; j < glbalance.size(); ++j) {
                HashMap tmp2 = (HashMap)glbalance.get(j);
                if (!tmp1.get("account_id").equals(tmp2.get("account_id")) || !tmp1.get("currency_id").equals(tmp2.get("currency_id"))) continue;
                if (((BigDecimal)tmp1.get("debitAmt")).compareTo((BigDecimal)tmp2.get("glDebitAmt")) != 0 || ((BigDecimal)tmp1.get("debitAmtLoc")).compareTo((BigDecimal)tmp2.get("glDebitAmtLoc")) != 0 || ((BigDecimal)tmp1.get("creditAmt")).compareTo((BigDecimal)tmp2.get("glCreditAmt")) != 0 || ((BigDecimal)tmp1.get("creditAmtLoc")).compareTo((BigDecimal)tmp2.get("glCreditAmtLoc")) != 0 || ((BigDecimal)tmp1.get("periodAmt")).compareTo((BigDecimal)tmp2.get("glPeriodAmt")) != 0 || ((BigDecimal)tmp1.get("periodAmtLoc")).compareTo((BigDecimal)tmp2.get("glPeriodAmtLoc")) != 0) {
                    tmp1.put("glDebitAmt", tmp2.get("glDebitAmt"));
                    tmp1.put("glDebitAmtLoc", tmp2.get("glDebitAmtLoc"));
                    tmp1.put("glCreditAmt", tmp2.get("glCreditAmt"));
                    tmp1.put("glCreditAmtLoc", tmp2.get("glCreditAmtLoc"));
                    tmp1.put("glPeriodAmt", tmp2.get("glPeriodAmt"));
                    tmp1.put("glPeriodAmtLoc", tmp2.get("glPeriodAmtLoc"));
                    result.add(tmp1);
                }
                apbalance.remove(tmp1);
                glbalance.remove(tmp2);
                --i;
                continue block6;
            }
        }
        for (i = 0; i < apbalance.size(); ++i) {
            tmp1 = (HashMap)apbalance.get(i);
            result.add(tmp1);
        }
        for (i = 0; i < glbalance.size(); ++i) {
            tmp1 = (HashMap)glbalance.get(i);
            result.add(tmp1);
        }
    }

    private void doNonControlDetailCheck(Context ctx, CompanyOrgUnitInfo company, String periodId, Vector result, Map paramMap) throws BOSException, EASBizException {
        StringBuffer sbAccountAst;
        Vector<String> v_account_asstacttype;
        int i;
        int i2;
        PeriodInfo period = BaseDataUtil.getPeriod(ctx, periodId);
        String lang = ctx.getLocale().getLanguage();
        String companyId = company.getString("id");
        boolean isNewContrast = (Boolean)paramMap.get("AR_045");
        int checkType = Integer.parseInt((String)paramMap.get("AP_INIT_CHECK_TYPE"));
        String tableName = ArApServerUtils.getContrastTableName(isNewContrast, false);
        StringBuffer defaultAsstActTypeSB = new StringBuffer("select distinct ");
        defaultAsstActTypeSB.append("FAsstActTypeID from T_BD_AsstActTypeDefault ");
        defaultAsstActTypeSB.append("where FIsAccountCussent = 1 and FCompanyID = '").append(companyId).append("' ");
        IRowSet defaultAsstActTypes = DbUtil.executeQuery((Context)ctx, (String)defaultAsstActTypeSB.toString());
        Vector<String> v_def_asstacttype = new Vector<String>();
        boolean isEmptyAsstType = false;
        try {
            while (defaultAsstActTypes.next()) {
                isEmptyAsstType = true;
                v_def_asstacttype.add(defaultAsstActTypes.getString("FAsstActTypeID"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (!isEmptyAsstType) {
            throw new ArApCommonException(ArApCommonException.NOTSETASSTTYPE);
        }
        StringBuffer sb = new StringBuffer("select Distinct ");
        sb.append("t1.FAccount as account_id,t2.FNumber as account_number,t2.FName_").append(lang).append(" as account_name,");
        sb.append("t1.FCurrencyID as currency_id,t3.FNumber as currency_number,");
        sb.append("t3.FName_").append(lang).append(" as currency_name,t3.FPrecision as currency_prec ");
        sb.append("from " + tableName + " t1 ");
        sb.append("inner join T_BD_AccountView t2 on t1.FAccount = t2.FID ");
        sb.append("inner join T_BD_Currency t3 on t1.FCurrencyID = t3.FID ");
        sb.append("inner join T_BD_AsstActType t4 on t1.FAsstActTypeID = t4.FID ");
        sb.append("inner join T_AR_ContrastAccountView t5 on t1.FAccount = t5.FAccountID ");
        sb.append("where t1.FCompanyID = '").append(companyId).append("' ");
        if (isNewContrast) {
            sb.append(" and t1.FISDELETED = 0 ");
        }
        sb.append("and t1.FPeriodID= '").append(periodId).append("' ");
        sb.append("and t5.FSystem = 2 ");
        sb.append(" and t5.FCompanyID = '").append(companyId).append("' ");
        sb.append("and t5.FPeriodYear = ").append(period.getPeriodYear());
        sb.append("and t5.FPeriodNumber = ").append(period.getPeriodNumber());
        sb.append("and t2.FControl = ").append(0).append(" ");
        sb.append("and t1.FCurrencyID !='").append(GEN_LOC_CURRENCY).append("' ");
        sb.append("and t1.FCurrencyID !='").append(GEN_RPT_CURRENCY).append("' ");
        IRowSet account_arap = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        Vector v_account_arap = new Vector();
        try {
            while (account_arap.next()) {
                HashMap<String, String> hmArAp = new HashMap<String, String>();
                hmArAp.put("account_id", account_arap.getString("account_id"));
                hmArAp.put("account_number", account_arap.getString("account_number"));
                hmArAp.put("account_name", account_arap.getString("account_name"));
                hmArAp.put("currency_id", account_arap.getString("currency_id"));
                hmArAp.put("currency_number", account_arap.getString("currency_number"));
                hmArAp.put("currency_name", account_arap.getString("currency_name"));
                hmArAp.put("currency_prec", account_arap.getString("currency_prec"));
                v_account_arap.add(hmArAp);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        sb = new StringBuffer("select Distinct ");
        sb.append("t1.FAccountID as account_id,t2.FNumber as account_number,t2.FName_").append(lang).append(" as account_name,");
        sb.append("t1.FCurrencyID as currency_id,t3.FNumber as currency_number,");
        sb.append("t3.FName_").append(lang).append(" as currency_name,t3.FPrecision as currency_prec ");
        sb.append("from T_GL_AssistBalance_5F t1 ");
        sb.append("inner join T_BD_AccountView t2 on t1.FAccountID = t2.FID ");
        sb.append("inner join T_BD_Currency t3 on t1.FCurrencyID = t3.FID ");
        sb.append("inner join T_AR_ContrastAccountView t5 on t1.FAccountID = t5.FAccountID ");
        sb.append("where t1.ForgUnitID = '").append(companyId).append("' ");
        sb.append(" and t1.FPeriod= ").append(period.getNumber());
        sb.append("and t5.FPeriodYear = ").append(period.getPeriodYear());
        sb.append("and t5.FPeriodNumber = ").append(period.getPeriodNumber());
        sb.append("and t2.FControl = ").append(0).append(" ");
        sb.append(" and t5.FSystem = 2 ");
        sb.append(" and t5.FCompanyID = '").append(companyId).append("' ");
        IRowSet account_gl = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        Vector v_account_gl = new Vector();
        try {
            while (account_gl.next()) {
                HashMap<String, String> hmGL = new HashMap<String, String>();
                hmGL.put("account_id", account_gl.getString("account_id"));
                hmGL.put("account_number", account_gl.getString("account_number"));
                hmGL.put("account_name", account_gl.getString("account_name"));
                hmGL.put("currency_id", account_gl.getString("currency_id"));
                hmGL.put("currency_number", account_gl.getString("currency_number"));
                hmGL.put("currency_name", account_gl.getString("currency_name"));
                hmGL.put("currency_prec", account_gl.getString("currency_prec"));
                v_account_gl.add(hmGL);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        Vector<HashMap> v_same_account = new Vector<HashMap>();
        Vector v_arap_more_account = new Vector();
        Vector v_gl_more_account = new Vector();
        HashMap hmArApTemp = new HashMap();
        HashMap hmGLTemp = new HashMap();
        block21: for (i2 = 0; i2 < v_account_arap.size(); ++i2) {
            hmArApTemp = (HashMap)v_account_arap.get(i2);
            for (int j = 0; j < v_account_gl.size(); ++j) {
                hmGLTemp = (HashMap)v_account_gl.get(j);
                if (!hmArApTemp.get("account_id").toString().equals(hmGLTemp.get("account_id").toString()) || !hmArApTemp.get("currency_id").toString().equals(hmGLTemp.get("currency_id").toString())) continue;
                v_same_account.add(hmGLTemp);
                v_account_arap.remove(hmArApTemp);
                v_account_gl.remove(hmGLTemp);
                --i2;
                continue block21;
            }
        }
        for (i2 = 0; i2 < v_account_arap.size(); ++i2) {
            v_arap_more_account.add(v_account_arap.get(i2));
        }
        for (int j = 0; j < v_account_gl.size(); ++j) {
            v_gl_more_account.add(v_account_gl.get(j));
        }
        IAsstActType iAsstActType = AsstActTypeFactory.getLocalInstance((Context)ctx);
        HashMap hmSameAccount = null;
        for (i = 0; i < v_same_account.size(); ++i) {
            hmSameAccount = (HashMap)v_same_account.get(i);
            v_account_asstacttype = new Vector<String>();
            sbAccountAst = new StringBuffer("select distinct t2.FAsstActTypeID as asstacttype_id ,t1.FCAA as asstAccountID ");
            sbAccountAst.append("from T_BD_AccountView t1 ");
            sbAccountAst.append("inner join t_ar_contrastaccountview t2 on t1.FID = t2.FAccountID ");
            sbAccountAst.append("where t2.FAsstActTypeID is not null and t1.FID = '").append(hmSameAccount.get("account_id").toString()).append("' ");
            sb.append("and t2.FPeriodYear = ").append(period.getPeriodYear());
            sb.append("and t2.FPeriodNumber = ").append(period.getPeriodNumber());
            String accountAsstActTypeID = null;
            IRowSet rsAccountAsstType = DbUtil.executeQuery((Context)ctx, (String)sbAccountAst.toString());
            try {
                boolean brFlag = false;
                while (rsAccountAsstType.next()) {
                    brFlag = true;
                    v_account_asstacttype.add(rsAccountAsstType.getString("asstacttype_id"));
                    accountAsstActTypeID = rsAccountAsstType.getString("asstacttype_id");
                }
                if (!brFlag) {
                    continue;
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            BigDecimal ZERO = new BigDecimal("0.0");
            HashMap<String, BigDecimal> arapZeroFilter = new HashMap<String, BigDecimal>();
            arapZeroFilter.put("debitAmt", ZERO);
            arapZeroFilter.put("debitAmtLoc", ZERO);
            arapZeroFilter.put("creditAmt", ZERO);
            arapZeroFilter.put("creditAmtLoc", ZERO);
            arapZeroFilter.put("periodAmt", ZERO);
            arapZeroFilter.put("periodAmtLoc", ZERO);
            HashMap<String, BigDecimal> glZeroFilter = new HashMap<String, BigDecimal>();
            glZeroFilter.put("glDebitAmt", ZERO);
            glZeroFilter.put("glDebitAmtLoc", ZERO);
            glZeroFilter.put("glCreditAmt", ZERO);
            glZeroFilter.put("glCreditAmtLoc", ZERO);
            glZeroFilter.put("glPeriodAmt", ZERO);
            glZeroFilter.put("glPeriodAmtLoc", ZERO);
            ArrayList arapList = new ArrayList();
            ArrayList glList = new ArrayList();
            ObjectUuidPK asstActPK = new ObjectUuidPK(BOSUuid.read((String)accountAsstActTypeID));
            AsstActTypeInfo asstActType = iAsstActType.getAsstActTypeInfo((IObjectPK)asstActPK);
            HashMap<String, Object> glfilter = new HashMap<String, Object>();
            glfilter.put("tableName", asstActType.getRealtionDataObject());
            glfilter.put("fieldName", asstActType.getMappingFieldName());
            glfilter.put("company_id", companyId);
            glfilter.put("period_id", periodId);
            glfilter.put("period_number", period.getNumber());
            glfilter.put("account_id", hmSameAccount.get("account_id").toString());
            glfilter.put("currency_id", hmSameAccount.get("currency_id").toString());
            glfilter.put("asstacttype_id", accountAsstActTypeID);
            StringBuffer sbArAp = new StringBuffer("select Distinct ");
            sbArAp.append("t1.FAsstActTypeID as asstActTypeId ,t1.FCurrencyID as currencyId ");
            sbArAp.append("from " + tableName + " t1 ");
            sbArAp.append("where t1.FAccount = '").append(hmSameAccount.get("account_id").toString()).append("' ");
            if (isNewContrast) {
                sb.append(" and t1.FISDELETED = 0 ");
            }
            sbArAp.append("and t1.FCurrencyID = '").append(hmSameAccount.get("currency_id").toString()).append("' ");
            sbArAp.append("and t1.FCompanyID = '").append(companyId).append("' ");
            sbArAp.append("and t1.FPeriodID = '").append(periodId).append("' ");
            IRowSet rs_account_check_arap = DbUtil.executeQuery((Context)ctx, (String)sbArAp.toString());
            try {
                while (rs_account_check_arap.next()) {
                    HashMap<String, String> filter = new HashMap<String, String>();
                    ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)rs_account_check_arap.getString("asstActTypeId")));
                    AsstActTypeInfo arAsstActType = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeInfo((IObjectPK)pk);
                    filter.put("tableName", arAsstActType.getRealtionDataObject());
                    filter.put("fieldName", arAsstActType.getMappingFieldName());
                    filter.put("contrastTableName", tableName);
                    filter.put("company_id", companyId);
                    filter.put("period_id", periodId);
                    filter.put("account_id", hmSameAccount.get("account_id").toString());
                    filter.put("currency_id", rs_account_check_arap.getString("currencyId"));
                    filter.put("asstacttype_id", rs_account_check_arap.getString("asstActTypeId"));
                    RowSet tmpRowSet_ArAp = ArApServerUtils.getArApBalance(ctx, filter, checkType, true, false);
                    while (tmpRowSet_ArAp.next()) {
                        HashMap<String, Object> tmp_ArAp = new HashMap<String, Object>();
                        BigDecimal debitAmt = tmpRowSet_ArAp.getBigDecimal("debitAmt");
                        BigDecimal creditAmt = tmpRowSet_ArAp.getBigDecimal("creditAmt");
                        BigDecimal periodAmt = tmpRowSet_ArAp.getBigDecimal("periodAmt");
                        if (DataUtils.IsZeroBigDecimal(debitAmt) && DataUtils.IsZeroBigDecimal(creditAmt) && DataUtils.IsZeroBigDecimal(periodAmt)) continue;
                        tmp_ArAp.put("account", hmSameAccount.get("account_number").toString() + " " + hmSameAccount.get("account_name").toString());
                        tmp_ArAp.put("currency", hmSameAccount.get("currency_name").toString());
                        tmp_ArAp.put("currency_prec", hmSameAccount.get("currency_prec").toString());
                        tmp_ArAp.put("asstacttype", arAsstActType.getName());
                        tmp_ArAp.put("acctcuss_id", tmpRowSet_ArAp.getString("acctcuss_id"));
                        tmp_ArAp.put("acctcuss_number", tmpRowSet_ArAp.getString("acctcuss_number"));
                        tmp_ArAp.put("acctcuss_name", tmpRowSet_ArAp.getString("acctcuss_name"));
                        tmp_ArAp.put("debitAmt", debitAmt);
                        tmp_ArAp.put("debitAmtLoc", tmpRowSet_ArAp.getBigDecimal("debitAmtLoc"));
                        tmp_ArAp.put("creditAmt", creditAmt);
                        tmp_ArAp.put("creditAmtLoc", tmpRowSet_ArAp.getBigDecimal("creditAmtLoc"));
                        tmp_ArAp.put("periodAmt", periodAmt);
                        tmp_ArAp.put("periodAmtLoc", tmpRowSet_ArAp.getBigDecimal("periodAmtLoc"));
                        arapList.add(tmp_ArAp);
                    }
                }
                RowSet tmpRowSet_Gl = ArApServerUtils.getGlBalance(ctx, glfilter, checkType, true, false);
                while (tmpRowSet_Gl.next()) {
                    HashMap<String, Object> tmp_GL = new HashMap<String, Object>();
                    BigDecimal glDebitAmt = tmpRowSet_Gl.getBigDecimal("glDebitAmt");
                    BigDecimal glCreditAmt = tmpRowSet_Gl.getBigDecimal("glCreditAmt");
                    BigDecimal glPeriodAmt = tmpRowSet_Gl.getBigDecimal("glPeriodAmt");
                    if (DataUtils.IsZeroBigDecimal(glDebitAmt) && DataUtils.IsZeroBigDecimal(glCreditAmt) && DataUtils.IsZeroBigDecimal(glPeriodAmt)) continue;
                    tmp_GL.put("account", hmSameAccount.get("account_number").toString() + " " + hmSameAccount.get("account_name").toString());
                    tmp_GL.put("currency", hmSameAccount.get("currency_name").toString());
                    tmp_GL.put("currency_prec", hmSameAccount.get("currency_prec").toString());
                    tmp_GL.put("asstacttype", asstActType.getName());
                    tmp_GL.put("acctcuss_id", tmpRowSet_Gl.getString("acctcuss_id"));
                    tmp_GL.put("acctcuss_number", tmpRowSet_Gl.getString("acctcuss_number"));
                    tmp_GL.put("acctcuss_name", tmpRowSet_Gl.getString("acctcuss_name"));
                    tmp_GL.put("glDebitAmt", glDebitAmt);
                    tmp_GL.put("glDebitAmtLoc", tmpRowSet_Gl.getBigDecimal("glDebitAmtLoc"));
                    tmp_GL.put("glCreditAmt", glCreditAmt);
                    tmp_GL.put("glCreditAmtLoc", tmpRowSet_Gl.getBigDecimal("glCreditAmtLoc"));
                    tmp_GL.put("glPeriodAmt", glPeriodAmt);
                    tmp_GL.put("glPeriodAmtLoc", tmpRowSet_Gl.getBigDecimal("glPeriodAmtLoc"));
                    glList.add(tmp_GL);
                }
                int size = arapList.size();
                for (int m = 0; m < size; ++m) {
                    HashMap arapMap = (HashMap)arapList.get(m);
                    String arap_asstactID = (String)arapMap.get("acctcuss_id");
                    String arap_currencyID = (String)arapMap.get("currency");
                    String arap_accountID = (String)arapMap.get("account");
                    boolean isFindGLData = false;
                    int glSize = glList.size();
                    for (int n = glSize - 1; n >= 0; --n) {
                        HashMap glMap = (HashMap)glList.get(n);
                        String gl_asstactID = (String)glMap.get("acctcuss_id");
                        String gl_currencyID = (String)glMap.get("currency");
                        String gl_accountID = (String)glMap.get("account");
                        if (!arap_asstactID.equals(gl_asstactID) || !arap_currencyID.equals(gl_currencyID) || !arap_accountID.equals(gl_accountID)) continue;
                        isFindGLData = true;
                        if (((BigDecimal)arapMap.get("debitAmt")).compareTo((BigDecimal)glMap.get("glDebitAmt")) != 0 || ((BigDecimal)arapMap.get("debitAmtLoc")).compareTo((BigDecimal)glMap.get("glDebitAmtLoc")) != 0 || ((BigDecimal)arapMap.get("creditAmt")).compareTo((BigDecimal)glMap.get("glCreditAmt")) != 0 || ((BigDecimal)arapMap.get("creditAmtLoc")).compareTo((BigDecimal)glMap.get("glCreditAmtLoc")) != 0 || ((BigDecimal)arapMap.get("periodAmt")).compareTo((BigDecimal)glMap.get("glPeriodAmt")) != 0 || ((BigDecimal)arapMap.get("periodAmtLoc")).compareTo((BigDecimal)glMap.get("glPeriodAmtLoc")) != 0) {
                            arapMap.putAll(glMap);
                            result.add(arapMap);
                        }
                        glList.remove(glMap);
                    }
                    if (isFindGLData) continue;
                    arapMap.putAll(glZeroFilter);
                    result.add(arapMap);
                    isFindGLData = false;
                }
                size = glList.size();
                for (int k = 0; k < size; ++k) {
                    HashMap glMap = (HashMap)glList.get(k);
                    glMap.putAll(arapZeroFilter);
                    result.add(glMap);
                }
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        for (i = 0; i < v_arap_more_account.size(); ++i) {
            hmArApTemp = (HashMap)v_arap_more_account.get(i);
            StringBuffer sbAccountAst2 = new StringBuffer("select distinct t4.FID as asstacttype_id ,t1.FCAA as asstAccountID ");
            sbAccountAst2.append("from T_BD_AccountView t1 ");
            sbAccountAst2.append("inner join T_BD_AsstAccount t2 on t1.FCAA = t2.FID ");
            sbAccountAst2.append("inner join T_BD_AsstActGroupDetail t3 on t3.FAsstAccountID = t2.FID ");
            sbAccountAst2.append("inner join T_BD_AsstActType t4 on t3.FAsstActTypeID = t4.FID ");
            sbAccountAst2.append("where t1.FID = '").append(hmArApTemp.get("account_id").toString()).append("' ");
            IRowSet rsAccountAsstType = DbUtil.executeQuery((Context)ctx, (String)sbAccountAst2.toString());
            try {
                boolean brFlag = false;
                while (rsAccountAsstType.next()) {
                    brFlag = true;
                }
                if (!brFlag) {
                    continue;
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            StringBuffer sbArAp = new StringBuffer("select Distinct ");
            sbArAp.append("t1.FAsstActTypeID as asstActTypeId ,t1.FAsstActID as asstActId,t1.FCurrencyID as currencyId ");
            sbArAp.append("from " + tableName + " t1 ");
            sbArAp.append("where t1.FAccount = '").append(hmArApTemp.get("account_id").toString()).append("' ");
            if (isNewContrast) {
                sbArAp.append(" and t1.FISDELETED = 0 ");
            }
            sbArAp.append("and t1.FCurrencyID = '").append(hmArApTemp.get("currency_id").toString()).append("' ");
            sbArAp.append("and t1.FCompanyID = '").append(companyId).append("' ");
            sbArAp.append("and t1.FPeriodID = '").append(periodId).append("' ");
            IRowSet rs_account_check_arap = DbUtil.executeQuery((Context)ctx, (String)sbArAp.toString());
            try {
                while (rs_account_check_arap.next()) {
                    HashMap<String, String> filter = new HashMap<String, String>();
                    HashMap<String, Object> tmp_ArAp = null;
                    ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)rs_account_check_arap.getString("asstActTypeId")));
                    AsstActTypeInfo asstacttype = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeInfo((IObjectPK)pk);
                    filter.put("tableName", asstacttype.getRealtionDataObject());
                    filter.put("fieldName", asstacttype.getMappingFieldName());
                    filter.put("contrastTableName", tableName);
                    filter.put("company_id", companyId);
                    filter.put("period_id", periodId);
                    filter.put("account_id", hmArApTemp.get("account_id").toString());
                    filter.put("currency_id", rs_account_check_arap.getString("currencyId"));
                    filter.put("asstacttype_id", rs_account_check_arap.getString("asstActTypeId"));
                    filter.put("asstact_id", rs_account_check_arap.getString("asstActId"));
                    RowSet tmpRowSet_ArAp = ArApServerUtils.getArApBalance(ctx, filter, checkType, false, false);
                    if (!tmpRowSet_ArAp.next()) continue;
                    tmp_ArAp = new HashMap<String, Object>();
                    tmp_ArAp.put("acctcuss_id", tmpRowSet_ArAp.getString("acctcuss_id"));
                    tmp_ArAp.put("acctcuss_number", tmpRowSet_ArAp.getString("acctcuss_number"));
                    tmp_ArAp.put("acctcuss_name", tmpRowSet_ArAp.getString("acctcuss_name"));
                    tmp_ArAp.put("debitAmt", tmpRowSet_ArAp.getBigDecimal("debitAmt"));
                    tmp_ArAp.put("debitAmtLoc", tmpRowSet_ArAp.getBigDecimal("debitAmtLoc"));
                    tmp_ArAp.put("creditAmt", tmpRowSet_ArAp.getBigDecimal("creditAmt"));
                    tmp_ArAp.put("creditAmtLoc", tmpRowSet_ArAp.getBigDecimal("creditAmtLoc"));
                    tmp_ArAp.put("periodAmt", tmpRowSet_ArAp.getBigDecimal("periodAmt"));
                    tmp_ArAp.put("periodAmtLoc", tmpRowSet_ArAp.getBigDecimal("periodAmtLoc"));
                    tmp_ArAp.put("account", hmArApTemp.get("account_number").toString() + " " + hmArApTemp.get("account_name").toString());
                    tmp_ArAp.put("currency", hmArApTemp.get("currency_name").toString());
                    tmp_ArAp.put("currency_prec", hmArApTemp.get("currency_prec").toString());
                    tmp_ArAp.put("asstacttype", asstacttype.getName());
                    result.add(tmp_ArAp);
                }
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        for (int j = 0; j < v_gl_more_account.size(); ++j) {
            hmGLTemp = (HashMap)v_gl_more_account.get(j);
            v_account_asstacttype = new Vector();
            sbAccountAst = new StringBuffer("select distinct t2.FAsstActTypeID as asstacttype_id ,t1.FCAA as asstAccountID ");
            sbAccountAst.append("from T_BD_AccountView t1 ");
            sbAccountAst.append("inner join t_ar_contrastaccountview t2 on t1.fid = t2.faccountid ");
            sbAccountAst.append("where t2.FAsstActTypeID is not null and t1.FID = '").append(hmGLTemp.get("account_id").toString()).append("' ");
            sb.append("and t2.FPeriodYear = ").append(period.getPeriodYear());
            sb.append("and t2.FPeriodNumber = ").append(period.getPeriodNumber());
            IRowSet rsAccountAsstType = DbUtil.executeQuery((Context)ctx, (String)sbAccountAst.toString());
            try {
                boolean brFlag = false;
                while (rsAccountAsstType.next()) {
                    brFlag = true;
                    v_account_asstacttype.add(rsAccountAsstType.getString("asstacttype_id"));
                }
                if (!brFlag) {
                    continue;
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            for (int k = 0; k < v_account_asstacttype.size(); ++k) {
                HashMap<String, Object> hmIsGLFilter = new HashMap<String, Object>();
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)v_account_asstacttype.get(k).toString()));
                AsstActTypeInfo asstActTypeForGL = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeInfo((IObjectPK)pk);
                hmIsGLFilter.put("tableName", asstActTypeForGL.getRealtionDataObject());
                hmIsGLFilter.put("fieldName", asstActTypeForGL.getMappingFieldName());
                hmIsGLFilter.put("company_id", companyId);
                hmIsGLFilter.put("account_id", hmGLTemp.get("account_id").toString());
                hmIsGLFilter.put("currency_id", hmGLTemp.get("currency_id").toString());
                hmIsGLFilter.put("period_number", period.getNumber());
                hmIsGLFilter.put("asstacttype_id", v_account_asstacttype.get(k).toString());
                if (!v_def_asstacttype.contains(v_account_asstacttype.get(k))) continue;
                RowSet tmpRowSetForGL = ArApServerUtils.getGlBalance(ctx, hmIsGLFilter, checkType, false, false);
                try {
                    while (tmpRowSetForGL.next()) {
                        HashMap<String, Object> tmpIsGL = new HashMap<String, Object>();
                        tmpIsGL.put("acctcuss_id", tmpRowSetForGL.getString("acctcuss_id"));
                        tmpIsGL.put("acctcuss_number", tmpRowSetForGL.getString("acctcuss_number"));
                        tmpIsGL.put("acctcuss_name", tmpRowSetForGL.getString("acctcuss_name"));
                        tmpIsGL.put("glDebitAmt", tmpRowSetForGL.getBigDecimal("glDebitAmt"));
                        tmpIsGL.put("glDebitAmtLoc", tmpRowSetForGL.getBigDecimal("glDebitAmtLoc"));
                        tmpIsGL.put("glCreditAmt", tmpRowSetForGL.getBigDecimal("glCreditAmt"));
                        tmpIsGL.put("glCreditAmtLoc", tmpRowSetForGL.getBigDecimal("glCreditAmtLoc"));
                        tmpIsGL.put("glPeriodAmt", tmpRowSetForGL.getBigDecimal("glPeriodAmt"));
                        tmpIsGL.put("glPeriodAmtLoc", tmpRowSetForGL.getBigDecimal("glPeriodAmtLoc"));
                        tmpIsGL.put("account", hmGLTemp.get("account_number").toString() + " " + hmGLTemp.get("account_name").toString());
                        tmpIsGL.put("currency", hmGLTemp.get("currency_name").toString());
                        tmpIsGL.put("currency_prec", hmGLTemp.get("currency_prec").toString());
                        tmpIsGL.put("asstacttype", asstActTypeForGL.getName());
                        result.add(tmpIsGL);
                    }
                    continue;
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
            }
        }
    }

    @Override
    protected IObjectPK _impSubmit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._submit(ctx, model);
    }

    @Override
    @Deprecated
    protected boolean _updateAssAct(Context ctx, HashMap param) throws BOSException {
        StringBuffer sbsql = new StringBuffer();
        String lang = ctx.getLocale().getLanguage();
        sbsql.append("select distinct t1.frealtiondataobject realtiondataobject from t_bd_AsstActType t1 where t1.fid in (");
        sbsql.append("select fasstacttypeid from t_bd_asstacttypedefault where  ");
        sbsql.append("fisaccountcussent=1 )");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbsql.toString());
        sbsql.setLength(0);
        try {
            String realtiondataobject = null;
            ArrayList<String> listObject = new ArrayList<String>();
            while (rs.next()) {
                realtiondataobject = rs.getString("realtiondataobject");
                if (realtiondataobject == null || listObject.contains(realtiondataobject)) continue;
                listObject.add(realtiondataobject);
                sbsql.append("update t_ar_otherbill as t1 set(fasstactnumber,fasstactname_l1,fasstactname_l2,fasstactname_l3)= ");
                sbsql.append("(select t2.fnumber,t2.fname_l1,t2.fname_l2,t2.fname_l3 from " + realtiondataobject + " ").append(" t2 inner join t_ar_otherbill t3 on t3.fasstactid=t2.fid where t3.fid=t1.fid) ");
                DbUtil.execute((Context)ctx, (String)sbsql.toString());
                sbsql.setLength(0);
                sbsql.append("update t_ar_otherbillentry as t1 set(FORDCUSTNUMBER,FORDCUSTNAME)= ");
                sbsql.append(" (select  t3.FORDCUSTNUMBER,t3.FORDCUSTNAME from ");
                sbsql.append(" (select  t5.fid,t2.fnumber  AS FORDCUSTNUMBER,  t2.fname_").append(lang).append(" AS FORDCUSTNAME ");
                sbsql.append(" from t_ar_otherbillentry t5 left join " + realtiondataobject + " ").append(" t2 on t5.FORDERCUSTOMERID=t2.fid ");
                sbsql.append(" where  t2.fid is not null) t3 ");
                sbsql.append(" where t1.fid = t3.fid ) ");
                DbUtil.execute((Context)ctx, (String)sbsql.toString());
                sbsql.setLength(0);
                sbsql.append("update t_ar_otherbillentry as t1 set(FSERCUSTNUMBER,FSERCUSTNAME)= ");
                sbsql.append(" (select  t3.FSERCUSTNUMBER,t3.FSERCUSTNAME from ");
                sbsql.append(" (select  t5.fid,t2.fnumber  AS FSERCUSTNUMBER,  t2.fname_").append(lang).append(" AS FSERCUSTNAME ");
                sbsql.append(" from t_ar_otherbillentry t5 left join " + realtiondataobject + " ").append(" t2 on t5.FSERVICECUSTOMERID=t2.fid ");
                sbsql.append(" where  t2.fid is not null) t3 ");
                sbsql.append(" where t1.fid = t3.fid ) ");
                DbUtil.execute((Context)ctx, (String)sbsql.toString());
                sbsql.setLength(0);
                sbsql.append("update t_ar_otherbillentry as t1 set(FRECASSTACTNUMBER,FRECASSTACTNAME_L1,FRECASSTACTNAME_L2,FRECASSTACTNAME_L3)= ");
                sbsql.append(" (select  t3.FRECASSTACTNUMBER,t3.FRECASSTACTNAME_L1,t3.FRECASSTACTNAME_L2,t3.FRECASSTACTNAME_L3 from ");
                sbsql.append(" (select  t5.fid,t2.fnumber  AS FRECASSTACTNUMBER, t2.fname_l1 AS FRECASSTACTNAME_L1, t2.fname_l2 AS FRECASSTACTNAME_L2, t2.fname_l3 AS FRECASSTACTNAME_L3 ");
                sbsql.append(" from t_ar_otherbillentry t5 left join " + realtiondataobject + " ").append(" t2 on t5.FRECASSTACTID=t2.fid ");
                sbsql.append(" where  t2.fid is not null) t3 ");
                sbsql.append(" where t1.fid = t3.fid ) ");
                DbUtil.execute((Context)ctx, (String)sbsql.toString());
                sbsql.setLength(0);
                sbsql.append("update t_ap_otherbill as t1 set(fasstactnumber,fasstactname_l1,fasstactname_l2,fasstactname_l3)= ");
                sbsql.append("(select t2.fnumber,t2.fname_l1,t2.fname_l2,t2.fname_l3 from " + realtiondataobject + " ").append(" t2 inner join t_ap_otherbill t3 on t3.fasstactid=t2.fid where t3.fid=t1.fid) ");
                DbUtil.execute((Context)ctx, (String)sbsql.toString());
                sbsql.setLength(0);
                sbsql.append("update t_arp_proxybill as t1 set(FRecAsstActNum,FRecAsstActName_l1,FRecAsstActName_l2,FRecAsstActName_l3)= ");
                sbsql.append("(select t2.fnumber,t2.FName_l1,t2.FName_l2,t2.FName_l3 from " + realtiondataobject + " ").append(" t2 inner join t_arp_proxybill t3 on t3.FRecAsstActId=t2.fid where t3.fid=t1.fid) ");
                DbUtil.execute((Context)ctx, (String)sbsql.toString());
                sbsql.setLength(0);
                sbsql.append("update T_ARP_ProxyBillEntry as t1 set(FPayAsstActNum,FPayAsstActName_l1,FPayAsstActName_l2,FPayAsstActName_l3)= ");
                sbsql.append("(select t2.fnumber,t2.FName_l1,t2.FName_l2,t2.FName_l3 from " + realtiondataobject + " ").append(" t2 inner join T_ARP_ProxyBillEntry t3 on t3.FPayAsstActId=t2.fid where t3.fid=t1.fid) ");
                DbUtil.execute((Context)ctx, (String)sbsql.toString());
                sbsql.setLength(0);
                sbsql.append("update t_ar_arInvoice as t1 set(FAsstActNumber, FAsstActName_l1, FAsstActName_l2 ,FAsstActName_l3)= ");
                sbsql.append("(select t2.fnumber,t2.FName_l1,t2.FName_l2,t2.FName_l3 from " + realtiondataobject + " ").append(" t2 inner join t_ar_arInvoice t3 on t3.FAsstActID=t2.fid where t3.fid=t1.fid) ");
                DbUtil.execute((Context)ctx, (String)sbsql.toString());
                sbsql.setLength(0);
                sbsql.append("update t_ap_apInvoice as t1 set(FAsstActNumber, FAsstActName_l1, FAsstActName_l2 ,FAsstActName_l3)= ");
                sbsql.append("(select t2.fnumber,t2.FName_l1,t2.FName_l2,t2.FName_l3 from " + realtiondataobject + " ").append(" t2 inner join t_ap_apInvoice t3 on t3.FAsstActID=t2.fid where t3.fid=t1.fid) ");
                DbUtil.execute((Context)ctx, (String)sbsql.toString());
                sbsql.setLength(0);
                sbsql.append("update T_AR_ArExgRateBillEntry as t1 set(FAsstActNumber, FAsstActName_l1, FAsstActName_l2, FAsstActName_l3)= ");
                sbsql.append("(select t2.fnumber,t2.FName_l1,t2.FName_l2,t2.FName_l3 from " + realtiondataobject + " ").append(" t2 inner join T_AR_ArExgRateBillEntry t3 on t3.FAsstActId=t2.fid where t3.fid=t1.fid) ");
                DbUtil.execute((Context)ctx, (String)sbsql.toString());
                sbsql.setLength(0);
                sbsql.append("update T_AP_ApExgRateBillEntry as t1 set(FAsstActNumber, FAsstActName_l1, FAsstActName_l2, FAsstActName_l3)= ");
                sbsql.append("(select t2.fnumber,t2.FName_l1,t2.FName_l2,t2.FName_l3 from " + realtiondataobject + " ").append(" t2 inner join T_AP_ApExgRateBillEntry t3 on t3.FAsstActId=t2.fid where t3.fid=t1.fid) ");
                DbUtil.execute((Context)ctx, (String)sbsql.toString());
                sbsql.setLength(0);
                sbsql.append("update T_AR_InitBadAccount as t1 set(FAcctCussentName_l1,FAcctCussentName_l2,FAcctCussentName_l3)= ");
                sbsql.append("(select t2.fname_l1,t2.fname_l2,t2.fname_l3 from " + realtiondataobject + " ").append(" t2 inner join T_AR_InitBadAccount t3 on t3.FAcctCussentID=t2.fid where t3.fid=t1.fid) ");
                DbUtil.execute((Context)ctx, (String)sbsql.toString());
                sbsql.setLength(0);
                sbsql.append("update T_AR_BadAcct as t1 set(FAcctCussentName_l1,FAcctCussentName_l2,FAcctCussentName_l3)= ");
                sbsql.append("(select t2.fname_l1,t2.fname_l2,t2.fname_l3 from " + realtiondataobject + " ").append(" t2 inner join T_AR_BadAcct t3 on t3.FAcctCussentID=t2.fid where t3.fid=t1.fid) ");
                DbUtil.execute((Context)ctx, (String)sbsql.toString());
                sbsql.setLength(0);
                sbsql.append("update  t_cas_receivingbill  as entry ");
                sbsql.append("set (FPayerNumber, FPayerName, FPayerName_l1, FPayerName_l2, FPayerName_l3 ) = ");
                sbsql.append("(select t2.fnumber , t2.fname_").append(lang).append(" as fname, t2.fname_l1,t2.fname_l2,t2.fname_l3 from t_cas_receivingbill t1 inner  join " + realtiondataobject + " ").append(" t2 on t2.fid = t1.FPayerID where   t1.fid = entry.fid) ");
                DbUtil.execute((Context)ctx, (String)sbsql.toString());
                sbsql.setLength(0);
                sbsql.append("update  t_cas_paymentbill  as entry ");
                sbsql.append("set (FPayeeNumber, FPayeeName, FPayeeName_l1, FPayeeName_l2, FPayeeName_l3 )= ");
                sbsql.append("(select t2.fnumber , t2.fname_").append(lang).append(" as fname, t2.fname_l1,t2.fname_l2,t2.fname_l3 from t_cas_paymentbill t1 inner  join " + realtiondataobject + " ").append(" t2\ton t2.fid = t1.FPayeeID where   t1.fid = entry.fid) ");
                DbUtil.execute((Context)ctx, (String)sbsql.toString());
                sbsql.setLength(0);
                sbsql.append("update  t_ar_verificationbillentry  as entry ");
                sbsql.append("set (FAcctCussName_l1,FAcctCussName_l2,FAcctCussName_l3 )= ");
                sbsql.append("(select t2.fname_l1,t2.fname_l2,t2.fname_l3 from t_ar_verificationbillentry t1 inner  join " + realtiondataobject + " ").append(" t2 on t2.fid = t1.facctcussid where   t1.fid = entry.fid) ");
                DbUtil.execute((Context)ctx, (String)sbsql.toString());
                sbsql.setLength(0);
                sbsql.append("update  t_ap_verificationbillentry  as entry ");
                sbsql.append("set (FAcctCussName_l1,FAcctCussName_l2,FAcctCussName_l3 )= ");
                sbsql.append("(select t2.fname_l1,t2.fname_l2,t2.fname_l3 from t_ap_verificationbillentry t1 inner  join " + realtiondataobject + " ").append(" t2 on t2.fid = t1.facctcussid where   t1.fid = entry.fid) ");
                DbUtil.execute((Context)ctx, (String)sbsql.toString());
                sbsql.setLength(0);
                sbsql.append("update t_ap_payrequestbillentry as t1 set(FAsstActNumber, FAsstActName)= ");
                sbsql.append("(select t2.fnumber,t2.FName_").append(lang).append(" from " + realtiondataobject + " ").append(" t2 inner join t_ap_payrequestbillentry t3 on t3.FAsstActID=t2.fid where t3.fid=t1.fid) ");
                DbUtil.execute((Context)ctx, (String)sbsql.toString());
                sbsql.setLength(0);
                sbsql.append("update T_AP_PayRequestSumEntry as t1 set(FAsstActNumber, FAsstActName)= ");
                sbsql.append("(select t2.fnumber,t2.FName_").append(lang).append(" from " + realtiondataobject + " ").append(" t2 inner join T_AP_PayRequestSumEntry t3 on t3.FAsstActID=t2.fid where t3.fid=t1.fid) ");
                DbUtil.execute((Context)ctx, (String)sbsql.toString());
                sbsql.setLength(0);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return true;
    }
}

