/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.bos.workflow.exception.MatchAssignmentException;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.wssc.BillImageFacadeFactory;
import com.kingdee.eas.base.wssc.BillImageMapCollection;
import com.kingdee.eas.base.wssc.BillImageMapFactory;
import com.kingdee.eas.base.wssc.IBillImageFacade;
import com.kingdee.eas.base.wssc.IBillImageMap;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.IPayRequestBill;
import com.kingdee.eas.fi.ap.IPayRequestBillEntry;
import com.kingdee.eas.fi.ap.PayRequestBillBizException;
import com.kingdee.eas.fi.ap.PayRequestBillCollection;
import com.kingdee.eas.fi.ap.PayRequestBillEntryCollection;
import com.kingdee.eas.fi.ap.PayRequestBillEntryFactory;
import com.kingdee.eas.fi.ap.PayRequestBillEntryInfo;
import com.kingdee.eas.fi.ap.PayRequestBillFactory;
import com.kingdee.eas.fi.ap.PayRequestBillInfo;
import com.kingdee.eas.fi.ap.PayRequestSumEntryCollection;
import com.kingdee.eas.fi.ap.PayRequestSumEntryInfo;
import com.kingdee.eas.fi.ap.PaymentBillBizException;
import com.kingdee.eas.fi.ap.app.AbstractPayRequestBillControllerBean;
import com.kingdee.eas.fi.ap.app.util.AP2POWriteBackForInvoice;
import com.kingdee.eas.fi.ap.app.util.PayReqCommmonServerUtil;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.app.util.BaseDataUtil;
import com.kingdee.eas.fi.ar.app.util.CommonServerUtils;
import com.kingdee.eas.fi.ar.util.ListUtil;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.IArApBillFacade;
import com.kingdee.eas.fi.arap.app.util.ArApServerUtils;
import com.kingdee.eas.fi.arap.app.writeback.handler.BizActionEnum;
import com.kingdee.eas.fi.arap.app.writeback.handler.BizSceneEnum;
import com.kingdee.eas.fi.arap.app.writeback.handler.IWriteBackHandler;
import com.kingdee.eas.fi.arap.app.writeback.handler.WriteBackFactory;
import com.kingdee.eas.fi.arap.invoiceMatch.util.MatchConstant;
import com.kingdee.eas.fi.arap.invoiceMatch.util.MatchUtils;
import com.kingdee.eas.fi.arap.invoiceMatch.util.RecordToBillParams;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.arap.util.ArApBillUtil;
import com.kingdee.eas.fi.arap.util.ArApParamHelper;
import com.kingdee.eas.fi.arap.util.ArApSelectorFactory;
import com.kingdee.eas.fi.arap.util.DBUtil;
import com.kingdee.eas.fi.arap.util.invoice.IncomeInvoiceServerUtils;
import com.kingdee.eas.fi.cas.IPaymentBillType;
import com.kingdee.eas.fi.cas.PaymentBillTypeCollection;
import com.kingdee.eas.fi.cas.PaymentBillTypeFactory;
import com.kingdee.eas.fi.cas.PaymentBillTypeInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.ArApRecPayServerHelper;
import com.kingdee.eas.fi.cas.validate.currency.GeneralCurrencyCheckBuilder;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.framework.BillBaseCollection;
import com.kingdee.eas.framework.BillEntryBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.ma.nbudget.BgControlCaller;
import com.kingdee.eas.ma.nbudget.face.IControlResult;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.framework.bizflow.app.BizFlowServerHelper;
import com.kingdee.eas.scm.framework.bizflow.util.BizBillValueChangeUtil;
import com.kingdee.eas.scm.sm.pur.IPurOrderEntry;
import com.kingdee.eas.scm.sm.pur.PurContractEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PayRequestBillControllerBean
extends AbstractPayRequestBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ap.app.PayRequestBillControllerBean");
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    private static final String PREPAYTYPE_UUID = "NLGLdwEREADgAAHjwKgSRj6TKVs=";
    private static final String REFUND_PREPAYTYPE_UUID = "NLGLdwEREADgAAHuwKgSRj6TKVs=";
    private static final String AP_RESOURCE = "com.kingdee.eas.fi.ap.ApResource";

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._addnew(ctx, model);
        return pk;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
    }

    @Override
    protected IObjectCollection _getAsstActTypeColl(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer("");
        sql.append("SELECT DISTINCT contrastAccountView.FAsstActTypeID as fAsstActTypeID").append("\r\t");
        sql.append(" FROM T_AR_ContrastAccountView AS contrastAccountView ").append("\r\t");
        sql.append(" INNER JOIN T_BD_AccountView AS account ").append("\r\t");
        sql.append(" ON contrastAccountView.FAccountID = account.FID ").append("\r\t");
        sql.append(" LEFT OUTER JOIN T_BD_AccountCurrency AS CURRENCYACCOUNT ").append("\r\t");
        sql.append(" ON account.FID = CURRENCYACCOUNT.FAccountViewID ").append("\r\t");
        sql.append(" LEFT OUTER JOIN T_BD_Currency AS CURRENCY ").append("\r\t");
        sql.append(" ON CURRENCYACCOUNT.FCurrencyID = CURRENCY.FID ").append("\r\t");
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<String> asstActTypeIDs = new ArrayList<String>();
        AsstActTypeCollection col = new AsstActTypeCollection();
        IAsstActType iasstType = AsstActTypeFactory.getLocalInstance((Context)ctx);
        try {
            con = this.getConnection(ctx);
            pstmt = con.prepareStatement(sql.toString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String fAsstActTypeID = rs.getString("fAsstActTypeID");
                if (fAsstActTypeID == null || "".equals(fAsstActTypeID)) continue;
                asstActTypeIDs.add(fAsstActTypeID);
            }
            for (int i = 0; i < asstActTypeIDs.size(); ++i) {
                try {
                    String fid = (String)asstActTypeIDs.get(i);
                    ObjectUuidPK objectPk = new ObjectUuidPK(fid);
                    col.add(iasstType.getAsstActTypeInfo((IObjectPK)objectPk));
                    continue;
                }
                catch (EASBizException e) {
                    logger.error((Object)e);
                }
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)("sql: " + sql.toString()));
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return col;
    }

    @Override
    protected void _antiAudit(Context ctx, IObjectPK billID) throws BOSException, EASBizException {
        this.antiAuditBill(ctx, billID, "");
    }

    protected void antiAuditBill(Context ctx, IObjectPK billID, String flag) throws BOSException, EASBizException, PayRequestBillBizException, OtherBillBizException {
        int i;
        if (billID == null) {
            throw new IllegalArgumentException();
        }
        DBUtil.addSQLLock(ctx, new IObjectPK[]{billID});
        PayRequestBillInfo info = this.getPayRequestBillInfo(ctx, billID, ArApSelectorFactory.getPayRequestBillSelector(true));
        if (info == null) {
            throw new PayRequestBillBizException(PayRequestBillBizException.BILL_NOTEXIST);
        }
        if (!BillStatusEnum.AUDITED.equals((Object)info.getBillStatus())) {
            throw new PayRequestBillBizException(PayRequestBillBizException.SAVE_SUBMIT_NOT_ANAUDIT);
        }
        if (this.hasCloseEntry(info)) {
            throw new PayRequestBillBizException(PayRequestBillBizException.HASCLOSE_CANNOTDOTHIS);
        }
        if (!"ignore".equalsIgnoreCase(flag) && !"backTo".equalsIgnoreCase(flag) && this._checkDestBillExist(ctx, billID)) {
            throw new PayRequestBillBizException(PayRequestBillBizException.DESBILL_EXISTED_ANTIAUDIT);
        }
        HashSet<String> entryIdSet = new HashSet<String>();
        for (int i2 = 0; i2 < info.getEntrys().size(); ++i2) {
            entryIdSet.add(info.getEntrys().get(i2).getId().toString());
        }
        ArApServerUtils.addSQLLock(ctx, entryIdSet);
        if (info != null) {
            this.handleInvoiceInfo(ctx, info, "unAudit");
            AP2POWriteBackForInvoice.PRBWriteBackOrderForInvoiceByUpdate(ctx, info, BOTBillOperStateEnum.DELETE);
        }
        UserInfo currentUser = CommonServerUtils.getCurrentUser(ctx);
        if (ArApParamHelper.isPayRequestBillSameAuditor(ctx, info.getCompany().getId().toString()) && !ArApBillHelper.idEquals((CoreBaseInfo)info.getAuditor(), (CoreBaseInfo)currentUser)) {
            throw new OtherBillBizException(OtherBillBizException.ARAPBILL_IS_SAMEAUDITOR_PERSON);
        }
        PayRequestBillEntryCollection entrys = info.getEntrys();
        PayRequestBillEntryInfo entry = null;
        if (!"ignore".equals(flag)) {
            info.setBillStatus(BillStatusEnum.SAVE);
            info.setAuditor(null);
            info.setAuditDate(null);
            for (i = 0; i < entrys.size(); ++i) {
                entry = entrys.get(i);
                entry.setEntryStatus(BillStatusEnum.SAVE);
            }
        } else {
            info.setBillStatus(BillStatusEnum.DELETED);
            for (i = 0; i < entrys.size(); ++i) {
                entry = entrys.get(i);
                entry.setEntryStatus(BillStatusEnum.DELETED);
            }
        }
        if (info.getSourceBillType() != null) {
            this.batchWriteback(ctx, billID, info, BatchActionEnum.UNAUDIT);
        }
        ArApServerUtils.injectBizFlow(ctx, (IObjectValue)info, BatchActionEnum.UNAUDIT);
        EnactmentServiceFactory.createEnactService((Context)ctx).abortProcessByHoldedObjectId(billID.toString());
        int value = this.getPayReqBgCtrlParam(ctx, info.getCompany().getId().toString(), "AP_BG_01");
        if (value == 1 || value == 0) {
            BgControlCaller caller = new BgControlCaller();
            caller.returnBudget(ctx, info.getId());
        }
        this.updatePartial(ctx, (CoreBaseInfo)info, this.getAuditSelector("unAudit"));
    }

    @Override
    protected void _audit(Context ctx, IObjectPK billID) throws BOSException, EASBizException {
        IControlResult result;
        BgControlCaller caller;
        boolean checkPass;
        if (billID == null) {
            throw new IllegalArgumentException();
        }
        SelectorItemCollection selector = ArApSelectorFactory.getPayRequestBillSelector(true);
        PayRequestBillInfo info = this.getPayRequestBillInfo(ctx, billID, selector);
        if (info == null) {
            throw new PayRequestBillBizException(PayRequestBillBizException.BILL_NOTEXIST);
        }
        if (!BillStatusEnum.SUBMITED.equals((Object)info.getBillStatus())) {
            throw new PayRequestBillBizException(PayRequestBillBizException.SAVINGORAUDITEDNOTAUDIT);
        }
        UserInfo userinfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        userinfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        String[] keys = new String[]{"APBILL_IS_SAME_PERSON", "AP_QTY_GT_PO", "ORDERPAYMENT", "AP_BG_01", "AP_CONTRACT"};
        IParamControl paramControl = ParamControlFactory.getLocalInstance((Context)ctx);
        HashMap keysValue = paramControl.getParamHashMap(keys, info.getCompany().getId().toString());
        boolean APBILL_IS_SAME_PERSON = false;
        boolean AP_QTY_GT_PO = false;
        boolean ORDERPAYMENT = false;
        int ctrlParamValue = 2;
        if (keysValue != null && keysValue.size() > 0) {
            APBILL_IS_SAME_PERSON = this.getParamValue(keysValue, "APBILL_IS_SAME_PERSON");
            AP_QTY_GT_PO = this.getParamValue(keysValue, "AP_QTY_GT_PO");
            ORDERPAYMENT = this.getParamValue(keysValue, "ORDERPAYMENT");
            if (keysValue.containsKey("AP_BG_01")) {
                String strSysParamValue = keysValue.get("AP_BG_01").toString();
                if (strSysParamValue == null || strSysParamValue.equals("")) {
                    ctrlParamValue = 2;
                } else if (strSysParamValue.equals("0")) {
                    ctrlParamValue = 0;
                } else if (strSysParamValue.equals("1")) {
                    ctrlParamValue = 1;
                } else if (strSysParamValue.equals("2")) {
                    ctrlParamValue = 2;
                }
            }
        }
        if (APBILL_IS_SAME_PERSON && ArApBillHelper.idEquals((CoreBaseInfo)info.getCreator(), (CoreBaseInfo)userinfo)) {
            throw new OtherBillBizException(OtherBillBizException.ARAPBILL_IS_SAME_PERSON);
        }
        PayRequestBillEntryCollection entrycollection = info.getEntrys();
        PayRequestBillEntryInfo entry = null;
        Integer payType = null;
        ArApRecPayServerHelper arapHelper = new ArApRecPayServerHelper();
        HashSet<String> payTypeIDSet = new HashSet<String>();
        for (int i = 0; i < entrycollection.size(); ++i) {
            entry = entrycollection.get(i);
            if (entry.getPayType() == null || entry.getPayType().getId() == null) continue;
            payTypeIDSet.add(entry.getPayType().getId().toString());
        }
        HashMap<BOSUuid, PaymentBillTypeInfo> payBillTypeMap = new HashMap<BOSUuid, PaymentBillTypeInfo>();
        if (payTypeIDSet.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("id"));
            view.getSelector().add(new SelectorItemInfo("isPreSet"));
            view.getSelector().add(new SelectorItemInfo("number"));
            view.getSelector().add(new SelectorItemInfo("preSetBillType.id"));
            view.getSelector().add(new SelectorItemInfo("preSetBillType.number"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", payTypeIDSet, CompareType.INCLUDE));
            view.setFilter(filter);
            PaymentBillTypeCollection payBillTypeColl = PaymentBillTypeFactory.getLocalInstance((Context)ctx).getPaymentBillTypeCollection(view);
            if (payBillTypeColl != null && payBillTypeColl.size() > 0) {
                int size = payBillTypeColl.size();
                for (int i = 0; i < size; ++i) {
                    payBillTypeMap.put(payBillTypeColl.get(i).getId(), payBillTypeColl.get(i));
                }
            }
        }
        PaymentBillTypeInfo payTypeInfo = null;
        for (int i = 0; i < entrycollection.size(); ++i) {
            entry = entrycollection.get(i);
            if (entry.getReqPayAmount().signum() != entry.getAuditAmount().signum() && entry.getAuditAmount().compareTo(ZERO) != 0) {
                throw new PayRequestBillBizException(PayRequestBillBizException.PAYAUDIT_TYPEAMTNOTMATCH);
            }
            if (entry.getReqPayAmount().signum() == -1) {
                if (entry.getReqPayAmount().abs().compareTo(entry.getAuditAmount().abs()) == -1) {
                    throw new PayRequestBillBizException(PayRequestBillBizException.AUDITAMTABS_NOTGL_REYPAYABS);
                }
            } else if (entry.getReqPayAmount().compareTo(entry.getAuditAmount()) == -1) {
                throw new PayRequestBillBizException(PayRequestBillBizException.AUDIT_AMT_NOTGT_REQPAY_AMT);
            }
            if (!payBillTypeMap.containsKey(entry.getPayType().getId())) continue;
            payTypeInfo = (PaymentBillTypeInfo)payBillTypeMap.get(entry.getPayType().getId());
            if (payTypeInfo.isIsPreSet()) {
                payType = Integer.valueOf(payTypeInfo.getNumber());
            } else if (payTypeInfo.getPreSetBillType() != null) {
                payType = Integer.valueOf(payTypeInfo.getPreSetBillType().getNumber());
            }
            boolean blueFlag = arapHelper.checkIsDefaultBlueBillType(payType);
            boolean redFlag = arapHelper.checkIsDefaultRedBillType(payType);
            int sign = entry.getReqPayAmount().signum();
            int auditAmountSign = entry.getAuditAmount().signum();
            if (blueFlag && sign == -1 || redFlag && sign == 1) {
                throw new PayRequestBillBizException(PayRequestBillBizException.PAYREQ_TYPEAMTNOTMATCH);
            }
            if ((!blueFlag || auditAmountSign != -1) && (!redFlag || auditAmountSign != 1)) continue;
            throw new PayRequestBillBizException(PayRequestBillBizException.PAYREQ_TYPEAUDITAMTNOTMATCH);
        }
        this.checkGtOrderOrConstractAmt(ctx, keysValue, info);
        ArApServerUtils.injectBizFlow(ctx, (IObjectValue)info, BatchActionEnum.AUDIT);
        String sql = "update T_AP_PAYREQUESTBILL set FBillStatus=?, FAuditDate=?, FAUDITORID=?, FApQtyGtPO=?, FOrderpayment=? where FId=?";
        Object[] params = new Object[]{3, new Timestamp(System.currentTimeMillis()), userinfo.getId().toString(), AP_QTY_GT_PO ? 0 : 1, ORDERPAYMENT ? 0 : 1, billID.toString()};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        sql = "update T_AP_PAYREQUESTBILLENTRY set FEntryStatus = ? where FParentID = ?";
        params = new Object[]{3, billID.toString()};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        if (ctrlParamValue == 1 && (checkPass = (caller = new BgControlCaller()).checkBizUnitInfo(ctx, info.getId(), null)) && (result = caller.requestBudget(ctx, info.getId())).getResult() != 1) {
            if (result.getCause() instanceof List) {
                throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{((String)result.getCause().get(0)).toString()});
            }
            throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{result.getCause().toString()});
        }
        if (info.getSourceBillType() != null) {
            this.batchWriteback(ctx, billID, info, BatchActionEnum.AUDIT);
        }
        this.handleInvoiceInfo(ctx, info, "audit");
    }

    private void writeBackSourceBill(Context ctx, PayRequestBillInfo info, BatchActionEnum actionType) throws BOSException, EASBizException {
        if (!BatchActionEnum.AUDIT.equals((Object)actionType) && !BatchActionEnum.UNAUDIT.equals((Object)actionType)) {
            return;
        }
        BizActionEnum bizAction = BatchActionEnum.AUDIT.equals((Object)actionType) ? BizActionEnum.AUDIT : BizActionEnum.UNAUDIT;
        boolean isPrePay = info.getEntrys().size() > 0 && info.getEntrys().get(0).getPayType().isIsPrePay();
        BizSceneEnum bizScene = isPrePay ? BizSceneEnum.PRE_RECPAY_SCENE : BizSceneEnum.RECPAY_SCENE;
        HashSet<IWriteBackHandler> handlers = new HashSet<IWriteBackHandler>();
        handlers.add(WriteBackFactory.getInstance().getWriteBackHandler("78B50853", "D001019A"));
        handlers.add(WriteBackFactory.getInstance().getWriteBackHandler("3171BFAD", "D001019A"));
        handlers.add(WriteBackFactory.getInstance().getWriteBackHandler("48DA3A71", "D001019A"));
        for (IWriteBackHandler handler : handlers) {
            handler.handle(ctx, bizAction, bizScene, (IObjectValue)info);
        }
    }

    protected void checkGtOrderOrConstractAmt(Context ctx, HashMap keysValue, PayRequestBillInfo billInfo) throws PayRequestBillBizException, BOSException {
        if (billInfo.getEntrys() == null || billInfo.getEntrys().size() == 0) {
            return;
        }
        PayRequestBillEntryInfo entry = billInfo.getEntrys().get(0);
        String sourceBillEntry = entry.getSourceBillEntryId();
        if (StringUtils.isEmpty((String)sourceBillEntry)) {
            return;
        }
        BOSUuid uuid = BOSUuid.read((String)sourceBillEntry);
        String bosType = uuid.getType().toString();
        boolean ORDERPAYMENT = this.getParamValue(keysValue, "ORDERPAYMENT");
        boolean AP_038 = this.getParamValue(keysValue, "AP_CONTRACT");
        StringBuffer checkSql = new StringBuffer(50);
        String billId = billInfo.getId().toString();
        IRowSet rs = null;
        if (!ORDERPAYMENT && new PurOrderEntryInfo().getBOSType().toString().equals(bosType)) {
            checkSql.append(" SELECT entry.FSEQ  FROM T_AP_PAYREQUESTBILLENTRY entry ").append(" INNER JOIN T_SM_PURORDERENTRY purOrder on purOrder.FID = entry.FSOURCEBILLENTRYID ").append(" where entry.FPARENTID = '").append(billId).append("'").append(" and  (entry.FAUDITAMOUNT + purOrder.FTotalPrePayAmt) > purOrder.FPREPAYMENT ");
            rs = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString());
            checkSql.setLength(0);
        }
        if (!AP_038 && new PurContractEntryInfo().getBOSType().toString().equals(bosType)) {
            checkSql.append(" SELECT entry.FSEQ  FROM T_AP_PAYREQUESTBILLENTRY entry ").append(" INNER JOIN T_SM_PURCONTRACTENTRY contract on contract.FID = entry.FSOURCEBILLENTRYID ").append(" where entry.FPARENTID = '").append(billId).append("'").append(" and  (entry.FAUDITAMOUNT + contract.FTotalPreAmt) > contract.FPREPAYMENT ");
            rs = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString());
        }
        try {
            if (rs != null && rs.next()) {
                throw new PayRequestBillBizException(PayRequestBillBizException.REQAMT_GT_PREPAY);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getCause());
        }
    }

    protected boolean getParamValue(HashMap keysValue, String paramKey) {
        String value;
        boolean paramValue = false;
        if (keysValue.containsKey(paramKey) && ("true".equalsIgnoreCase(value = keysValue.get(paramKey).toString()) || "1".equalsIgnoreCase(value))) {
            paramValue = true;
        }
        return paramValue;
    }

    @Override
    protected void _cancelBill(Context ctx, IObjectPK pk) throws BOSException {
    }

    @Override
    protected boolean _checkDestBillExist(Context ctx, IObjectPK pk) throws BOSException {
        StringBuffer sql = new StringBuffer("");
        boolean hasDestBill = false;
        sql.append("select fsrcobjectid from t_bot_relation where fsrcentityid='");
        sql.append(new PayRequestBillInfo().getBOSType().toString());
        sql.append("' and FDestEntityID !='1343913D'");
        sql.append(" and fsrcobjectid ='");
        sql.append(pk.toString());
        sql.append("';").append("\r\t");
        Connection con = null;
        Statement pstmt = null;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            hasDestBill = rs.next();
        }
        catch (Exception ex) {
            logger.info((Object)ex);
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, pstmt, con);
        }
        return hasDestBill;
    }

    @Override
    protected void _backWrite(Context ctx, IObjectPK pk) throws BOSException {
    }

    private void batchWriteback(Context ctx, IObjectPK pk, PayRequestBillInfo info, BatchActionEnum batchActionEnum) throws BOSException, EASBizException {
        String tableName = "T_AP_PayRequestBillEntry";
        if (pk != null && SCMServerUtils.isExistsBizFlowField((Context)ctx, (String)tableName) && SCMServerUtils.isHasBizFlowValue((Context)ctx, (String)tableName, (String)pk.toString())) {
            return;
        }
        this.writeBackSourceBill(ctx, info, batchActionEnum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super.delete(ctx, pk);
        boolean isEnable = WfEventListenerStateManager.getInstance().isEnable();
        if (isEnable) {
            WfEventListenerStateManager.getInstance().disableEventListener();
        }
        try {
            BOSUuid uuid = BOSUuid.read((String)pk.toString());
            String bosType = uuid.getType().toString();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("bosType", (Object)bosType));
            filter.getFilterItems().add(new FilterItemInfo("billID", (Object)pk.toString()));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("imageNumber"));
            view.setSelector(sic);
            IBillImageMap billImageMap = BillImageMapFactory.getLocalInstance((Context)ctx);
            BillImageMapCollection billImageMapCollection = billImageMap.getBillImageMapCollection(view);
            if (billImageMapCollection.size() > 0) {
                BillImageFacadeFactory.getLocalInstance((Context)ctx).deleteSSCAndImageDataByBillID(pk.toString(), true);
            }
        }
        finally {
            if (isEnable) {
                WfEventListenerStateManager.getInstance().enableEventListener();
            }
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BgControlCaller caller;
        IControlResult result;
        String tableName = "T_AP_PayRequestBillEntry";
        IPayRequestBill ipayRequestbill = PayRequestBillFactory.getLocalInstance(ctx);
        PayRequestBillInfo info = ipayRequestbill.getPayRequestBillInfo(pk);
        if (info != null) {
            AP2POWriteBackForInvoice.PRBWriteBackOrderForInvoiceByUpdate(ctx, info, BOTBillOperStateEnum.DELETE);
            this.handleInvoiceInfo(ctx, info, "delete");
        }
        if (info == null) {
            throw new PayRequestBillBizException(PayRequestBillBizException.BILL_NOTEXIST);
        }
        if (BillStatusEnum.AUDITED.equals((Object)info.getBillStatus())) {
            throw new PayRequestBillBizException(PayRequestBillBizException.AUDIT_DELETE);
        }
        if (BillStatusEnum.DELETED.equals((Object)info.getBillStatus())) {
            throw new PayRequestBillBizException(PayRequestBillBizException.HASIGNORE_CANNOTDELETE);
        }
        if (BillStatusEnum.COLSED.equals((Object)info.getBillStatus())) {
            throw new PayRequestBillBizException(PayRequestBillBizException.HASCLOSE_CANNOTDELETE);
        }
        if (this._checkDestBillExist(ctx, pk)) {
            throw new PayRequestBillBizException(PayRequestBillBizException.DESBILL_EXISTED_DELETE);
        }
        int value = this.getPayReqBgCtrlParam(ctx, info.getCompany().getId().toString(), "AP_BG_01");
        if (value != 0 || (result = (caller = new BgControlCaller()).returnBudget(ctx, info.getId())).getResult() == 1) {
            // empty if block
        }
        WriteBackFactory.getInstance().getWriteBackHandler("48DA3A71", "D001019A").handle(ctx, BizActionEnum.DELETE, null, (IObjectValue)info);
        if (SCMServerUtils.isExistsBizFlowField((Context)ctx, (String)tableName) && SCMServerUtils.isHasBizFlowValue((Context)ctx, (String)tableName, (String)pk.toString())) {
            SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)info, (BatchActionEnum)BatchActionEnum.DELETE);
        }
        this.recycleNumber(ctx, pk, null);
        super._delete(ctx, pk);
    }

    private void recycleNumber(Context ctx, IObjectPK pk, PayRequestBillInfo info) throws CodingRuleException, EASBizException, BOSException {
        if (info == null || info.getNumber() == null || info.getCompany() == null || info.getCU() == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("number");
            sic.add("company.id");
            sic.add("cu.id");
            info = (PayRequestBillInfo)this._getValue(ctx, pk, sic);
        }
        if (info.getNumber() != null) {
            String companyID = info.getCompany().getId().toString();
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            CodingRuleInfo codeRuleInfo = iCodingRuleManager.getCodingRule((IObjectValue)info, companyID);
            if (codeRuleInfo != null && (iCodingRuleManager.isUseIntermitNumber((IObjectValue)info, companyID) || codeRuleInfo.isIsaddnewbreak())) {
                iCodingRuleManager.recycleNumber((IObjectValue)info, companyID, info.getNumber());
            }
        }
    }

    protected void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws BOSException, EASBizException {
        IObjectValue objectValue;
        int i;
        int size = collection.size();
        for (i = 0; i < size; ++i) {
            objectValue = collection.getObject(i);
            if (!(objectValue instanceof PayRequestBillInfo)) continue;
            PayRequestBillInfo payReqInfo = (PayRequestBillInfo)objectValue;
            this.handleInvoiceMatch(ctx, payReqInfo);
            CurrencyInfo currency = payReqInfo.getCurrency();
            CurrencyInfo baseCurrency = payReqInfo.getCompany().getBaseCurrency();
            if (!ArApBillHelper.idEquals((CoreBaseInfo)currency, (CoreBaseInfo)baseCurrency)) continue;
            payReqInfo.setExchange_rate(BigDecimal.ONE);
        }
        super._handleAfterTransform(ctx, action, collection);
        size = collection.size();
        for (i = 0; i < size; ++i) {
            objectValue = null;
            objectValue = collection.getObject(i);
            if (!(objectValue instanceof PayRequestBillInfo)) continue;
            this._handleAfterTransform(ctx, action, (IObjectValue)((PayRequestBillInfo)objectValue));
        }
    }

    protected void _handleAfterTransform(Context ctx, String action, IObjectValue objectValue) throws BOSException, EASBizException {
        PayRequestBillInfo payReqInfo;
        BillBaseCollection collection = new BillBaseCollection();
        collection.addObject(objectValue);
        ArApServerUtils.checkBillStatusForBotp(ctx, (IObjectCollection)collection, new String[]{"3171BFAD", "48DA3A71"});
        if (objectValue instanceof PayRequestBillInfo) {
            payReqInfo = (PayRequestBillInfo)objectValue;
            this.handleInvoiceMatch(ctx, payReqInfo);
            CurrencyInfo currency = payReqInfo.getCurrency();
            CurrencyInfo baseCurrency = payReqInfo.getCompany().getBaseCurrency();
            if (ArApBillHelper.idEquals((CoreBaseInfo)currency, (CoreBaseInfo)baseCurrency)) {
                payReqInfo.setExchange_rate(BigDecimal.ONE);
            }
        }
        super._handleAfterTransform(ctx, action, objectValue);
        if (objectValue instanceof PayRequestBillInfo) {
            payReqInfo = (PayRequestBillInfo)objectValue;
            if (null == payReqInfo.getCU()) {
                payReqInfo.setCU(payReqInfo.getCompany() == null ? null : payReqInfo.getCompany().getCU());
            }
            if (payReqInfo.getCurrency() == null) {
                throw new PayRequestBillBizException(PayRequestBillBizException.CURRENCY_NOTSET);
            }
            this.setExchangeRate(ctx, payReqInfo);
            this.checkPrepayAmount(ctx, payReqInfo);
            this.setAdminOrgUnitByPerson(ctx, payReqInfo);
            this.setCostCenter(ctx, payReqInfo);
            this.setAccountBankAndAccountBankNo(ctx, payReqInfo);
            this.setDefaultValue(ctx, payReqInfo);
            this.genNumberForBotp(ctx, payReqInfo);
            boolean isPaySchedual = ArApParamHelper.isPaySchedual(ctx, payReqInfo.getCompany().getId().toString());
            payReqInfo.setIsPaySchedule(isPaySchedual);
        }
    }

    protected void genNumberForBotp(Context ctx, PayRequestBillInfo info) throws BOSException, EASBizException {
        ICodingRuleManager iCodingMgr = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String companyId = info.getCompany() == null ? null : info.getCompany().getId().toString();
        CodingRuleInfo codingRuleInfo = null;
        if (companyId != null) {
            codingRuleInfo = iCodingMgr.getCodingRule((IObjectValue)info, companyId.toString());
        }
        if (codingRuleInfo == null) {
            if (info.getId() == null) {
                info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
            }
            if (StringUtils.isEmpty((String)info.getNumber())) {
                info.setNumber("AutoNumberFromBTP_" + info.getId());
            }
        } else if (!codingRuleInfo.isIsMainRule()) {
            PayRequestBillControllerBean.getNumber(ctx, (IObjectValue)info, codingRuleInfo, iCodingMgr, false);
        }
    }

    protected void setAccountBankAndAccountBankNo(Context ctx, PayRequestBillInfo info) throws BOSException, EASBizException {
        PayRequestBillEntryCollection collection = info.getEntrys();
        HashMap<String, SupplierInfo> supplyInfoCache = new HashMap<String, SupplierInfo>();
        HashMap<String, CustomerInfo> customInfoCache = new HashMap<String, CustomerInfo>();
        HashMap<String, AccountBankInfo> accountBankInfoCache = new HashMap<String, AccountBankInfo>();
        HashMap<String, Map> personBankCache = new HashMap<String, Map>();
        String asstActID = null;
        ICustomer icustomer = CustomerFactory.getLocalInstance((Context)ctx);
        ISupplier iSupplier = SupplierFactory.getLocalInstance((Context)ctx);
        BOSUuid companyId = info.getCompany() == null ? null : info.getCompany().getId();
        for (int i = 0; i < collection.size(); ++i) {
            String bankNumber;
            PayRequestBillEntryInfo entryInfo = (PayRequestBillEntryInfo)collection.getObject(i);
            if (entryInfo.getPayBank() != null && entryInfo.getPayBank().getBank() == null) {
                String payBankId = entryInfo.getPayBank().getId().toString();
                AccountBankInfo accountBankInfo = (AccountBankInfo)accountBankInfoCache.get(payBankId);
                if (accountBankInfo == null) {
                    accountBankInfo = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(payBankId));
                    accountBankInfoCache.put(payBankId, accountBankInfo);
                }
                entryInfo.setPayBank(accountBankInfo);
            }
            if (StringUtils.isEmpty((String)(asstActID = StringUtils.trim((String)entryInfo.getAsstActID())))) continue;
            if (BOSUuid.read((String)asstActID).getType().equals((Object)new SupplierInfo().getBOSType()) && entryInfo.getAccountBank() == null) {
                SupplierInfo supInfo = (SupplierInfo)supplyInfoCache.get(asstActID);
                if (null == supInfo) {
                    supInfo = iSupplier.getSupplierInfo((IObjectPK)new ObjectUuidPK(asstActID));
                    supplyInfoCache.put(asstActID, supInfo);
                }
                this.setSupplierBank2Entry(ctx, entryInfo, supInfo, companyId);
                continue;
            }
            if (BOSUuid.read((String)asstActID).getType().equals((Object)new CustomerInfo().getBOSType()) && entryInfo.getAccountBank() == null) {
                CustomerInfo cusInfo = (CustomerInfo)customInfoCache.get(asstActID);
                if (null == cusInfo) {
                    cusInfo = icustomer.getCustomerInfo((IObjectPK)new ObjectUuidPK(asstActID));
                    customInfoCache.put(asstActID, cusInfo);
                }
                this.setCustomerBank2Entry(ctx, entryInfo, cusInfo, companyId);
                continue;
            }
            if (!BOSUuid.read((String)asstActID).getType().equals((Object)new PersonInfo().getBOSType()) || info.getCurrency() == null || !StringUtils.isEmpty((String)entryInfo.getAccountBank()) || !StringUtils.isEmpty((String)entryInfo.getAccountBankNo())) continue;
            Map personBankInfo = (Map)personBankCache.get(asstActID);
            if (personBankInfo == null) {
                personBankInfo = ArApBillHelper.getAccountInfoByPerson(ctx, asstActID, info.getCurrency().getId().toString());
                personBankCache.put(asstActID, personBankInfo);
            }
            entryInfo.setAccountBank((String)personBankInfo.get("bank"));
            entryInfo.setAccountBankNo((String)personBankInfo.get("bankAccount"));
            BEBankInfo bebank = (BEBankInfo)personBankInfo.get("bebank");
            String string = bankNumber = bebank == null ? null : bebank.getNumber();
            if (!StringUtils.isEmpty((String)entryInfo.getBankNumber())) continue;
            entryInfo.setBankNumber(bankNumber);
        }
    }

    protected void setExchangeRate(Context ctx, PayRequestBillInfo info) throws BOSException, EASBizException {
        if (info.getExchange_rate() == null) {
            CurrencyInfo currency = info.getCurrency();
            CurrencyInfo baseCurrency = null;
            if (info.getCompany() != null) {
                baseCurrency = info.getCompany().getBaseCurrency();
            }
            ExchangeRateInfo exchangeRate = null;
            if (baseCurrency != null && currency != null && !currency.getId().equals((Object)baseCurrency.getId())) {
                exchangeRate = BaseDataUtil.getExchangeRate(ctx, info.getCompany(), currency, info.getBizDate());
                if (exchangeRate != null) {
                    info.setExchange_rate(exchangeRate.getConvertRate());
                }
            } else {
                info.setExchange_rate(BigDecimal.ONE);
            }
        }
    }

    protected boolean isBillContainsPrePayType(PayRequestBillInfo payReqInfo) {
        return PayReqCommmonServerUtil.isBillContainsPrePayType(payReqInfo);
    }

    protected void checkPrepayAmount(Context ctx, PayRequestBillInfo info) throws BOSException, EASBizException {
        boolean ORDERPAYMENT = ArApParamHelper.isPrePayAmoutCanOverOrderPrepayAmt(ctx, info.getCompany().getId().toString());
        if (ORDERPAYMENT) {
            return;
        }
        PayRequestBillEntryCollection collection = info.getEntrys();
        PayRequestBillEntryInfo entryinfo = null;
        String SrcBillId = info.getSourceBillId();
        IPurOrderEntry ipurorderentry = PurOrderEntryFactory.getLocalInstance((Context)ctx);
        PurOrderEntryInfo pOrderentry = null;
        String SrcBillEntryId = null;
        if (SrcBillId != null && BOSUuid.read((String)SrcBillId).getType().equals((Object)new PurOrderInfo().getBOSType())) {
            for (int i = collection.size() - 1; i > -1; --i) {
                entryinfo = collection.get(i);
                SrcBillEntryId = entryinfo.getSourceBillEntryid();
                pOrderentry = ipurorderentry.getPurOrderEntryInfo((IObjectPK)new ObjectUuidPK(SrcBillEntryId));
                if (pOrderentry.getTotalPrePayAmt().compareTo(pOrderentry.getPrepayment()) < 0) continue;
                info.getEntrys().removeObject(i);
            }
            if (info.getEntrys().size() == 0) {
                throw new PayRequestBillBizException(new NumericExceptionSubItem("603", ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"24_PayRequestBillControllerBean", (Locale)ctx.getLocale())));
            }
        }
    }

    protected void setDefaultValue(Context ctx, PayRequestBillInfo info) throws BOSException, EASBizException {
        PayRequestSumEntryCollection sumEntry;
        UserInfo user;
        SelectorItemCollection sic;
        if (info.getCompany() == null) {
            throw new OtherBillBizException(OtherBillBizException.COMPANY_NOTSET);
        }
        PayRequestBillEntryCollection collection = info.getEntrys();
        PayRequestBillEntryInfo entryInfo = null;
        BOSUuid companyId = info.getCompany() == null ? null : info.getCompany().getId();
        BigDecimal totalRequestAmount = ZERO;
        BigDecimal totalAuditAmount = ZERO;
        boolean isDirectExchange = true;
        CompanyOrgUnitInfo newCompanyInfo = null;
        if (info.getCompany().getBaseCurrency() == null || info.getCompany().getBaseCurrency().getPrecision() == 0) {
            sic = this.getCompanySelector();
            newCompanyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getCompany().getId()), sic);
            info.setCompany(newCompanyInfo);
        }
        if (null == info.getCU() || null == info.getCU().getNumber()) {
            if (null == newCompanyInfo) {
                sic = this.getCompanySelector();
                newCompanyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getCompany().getId()), sic);
            }
            info.setCU(newCompanyInfo.getCU());
        }
        if (info.getCurrency() != null && info.getCompany().getBaseCurrency() != null) {
            if (!info.getCurrency().getId().equals((Object)info.getCompany().getBaseCurrency().getId())) {
                ExchangeRateInfo rateInfo = BaseDataUtil.getExchangeRate(ctx, info.getCompany(), info.getCurrency(), info.getBizDate());
                if (rateInfo != null && rateInfo.getExchangeAux() != null && ConvertModeEnum.DIRECTEXCHANGERATE.equals((Object)rateInfo.getExchangeAux().getConvertMode())) {
                    isDirectExchange = true;
                } else if (rateInfo != null && rateInfo.getExchangeAux() != null && ConvertModeEnum.INDIRECTEXCHANGERATE.equals((Object)rateInfo.getExchangeAux().getConvertMode())) {
                    isDirectExchange = false;
                }
            } else {
                info.setExchange_rate(BigDecimal.ONE);
            }
        }
        Date defaultPayabbleDate = new Date();
        for (int i = 0; i < collection.size(); ++i) {
            entryInfo = (PayRequestBillEntryInfo)collection.getObject(i);
            entryInfo.setTotalPayAmt(ZERO);
            if (entryInfo.getSrcPpayUnreqAmt() == null) {
                entryInfo.setSrcPpayUnreqAmt(ZERO);
            }
            if (entryInfo.getSrcUnreqAmt() == null) {
                entryInfo.setSrcUnreqAmt(ZERO);
            }
            if (entryInfo.getUnpayAmount() == null || entryInfo.getUnpayAmount().compareTo(entryInfo.getReqPayAmount()) != 0) {
                entryInfo.setUnpayAmount(entryInfo.getReqPayAmount() != null ? entryInfo.getReqPayAmount() : ZERO);
            }
            if (entryInfo.getTotalPayAmt() == null) {
                entryInfo.setTotalPayAmt(ZERO);
            }
            if (entryInfo.getReqPayAmount() == null) {
                entryInfo.setReqPayAmount(ZERO);
            }
            if (entryInfo.getAuditAmount() == null) {
                entryInfo.setAuditAmount(entryInfo.getReqPayAmount());
            }
            if (totalRequestAmount == null) {
                totalRequestAmount = ZERO;
            }
            if (totalAuditAmount == null) {
                totalAuditAmount = ZERO;
            }
            totalRequestAmount = totalRequestAmount.add(entryInfo.getReqPayAmount() != null ? entryInfo.getReqPayAmount() : ZERO);
            totalAuditAmount = totalAuditAmount.add(entryInfo.getAuditAmount() != null ? entryInfo.getAuditAmount() : ZERO);
            if ((entryInfo.getAuditAmountLoc() == null || entryInfo.getAuditAmountLoc().compareTo(ZERO) == 0) && info.getExchange_rate() != null && info.getCompany() != null && info.getCompany().getBaseCurrency() != null && entryInfo.getAuditAmount() != null) {
                if (isDirectExchange) {
                    entryInfo.setAuditAmountLoc(entryInfo.getAuditAmount().multiply(info.getExchange_rate()).setScale(info.getCompany().getBaseCurrency().getPrecision(), 4));
                } else {
                    entryInfo.setAuditAmountLoc(entryInfo.getAuditAmount().divide(info.getExchange_rate(), info.getCompany().getBaseCurrency().getPrecision(), 4));
                }
            }
            if (null == entryInfo.getUnLockAmount() || ZERO.compareTo(entryInfo.getUnLockAmount()) == 0) {
                entryInfo.setUnLockAmount(entryInfo.getReqPayAmount());
            }
            if (null != entryInfo.getUnLockAmountLoc() && ZERO.compareTo(entryInfo.getUnLockAmountLoc()) != 0) continue;
            entryInfo.setUnLockAmountLoc(entryInfo.getAuditAmountLoc());
        }
        info.setRequestAmount(totalRequestAmount);
        info.setAuditAmount(totalAuditAmount);
        if (info.getApplyer() == null && (user = (UserInfo)ctx.get((Object)"UserInfo")) != null) {
            info.setApplyer(user.getPerson());
        }
        if (null == info.getCreator()) {
            info.setCreator(CommonServerUtils.getCurrentUser(ctx));
        }
        if (null == info.getCreateTime()) {
            info.setCreateTime(new Timestamp(new Date().getTime()));
        }
        if ((sumEntry = info.getSumEntry()) == null || sumEntry.isEmpty()) {
            PayReqCommmonServerUtil.handleSumEntrys(info);
        }
    }

    private void setAdminOrgUnitByPerson(Context ctx, PayRequestBillInfo info) throws BOSException {
        PersonInfo person = info.getApplyer();
        if (person != null && info.getDepartment() == null) {
            EntityViewInfo viewIn = new EntityViewInfo();
            FilterInfo filterIn = new FilterInfo();
            filterIn.getFilterItems().add(new FilterItemInfo("person", (Object)person.getId()));
            filterIn.getFilterItems().add(new FilterItemInfo("isPrimary", (Object)Boolean.TRUE));
            viewIn.setFilter(filterIn);
            SelectorItemCollection selectorAdmin = new SelectorItemCollection();
            selectorAdmin.add(new SelectorItemInfo("position.adminOrgUnit.*"));
            viewIn.setSelector(selectorAdmin);
            try {
                IPositionMember iPositionMember = PositionMemberFactory.getLocalInstance((Context)ctx);
                PositionMemberCollection positionColl = iPositionMember.getPositionMemberCollection(viewIn);
                if (positionColl.size() > 0) {
                    info.setDepartment(positionColl.get(0).getPosition().getAdminOrgUnit());
                } else {
                    info.setDepartment(null);
                }
            }
            catch (BOSException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    public void setCostCenter(Context ctx, PayRequestBillInfo info) throws EASBizException, BOSException {
        if (info.getDepartment() != null && info.getCompany() != null && info.getCostCenter() == null) {
            CostCenterOrgUnitInfo costCenterInfo = null;
            costCenterInfo = SCMUtils.getCostCenterByOrgInfo((Context)ctx, (String)info.getCompany().getId().toString(), (String)info.getDepartment().getId().toString());
            info.setCostCenter(costCenterInfo);
        }
    }

    public boolean isInclundCostCenter(Context ctx, String costCenterInfoID, String companyOrgInfoID) throws EASBizException, BOSException {
        boolean flag = false;
        if (costCenterInfoID == null || companyOrgInfoID == null) {
            return flag;
        }
        Set ids = SCMUtils.getCostCenterByCompanyOrgInfo((Context)ctx, (String)companyOrgInfoID);
        flag = ids.contains(costCenterInfoID);
        return flag;
    }

    public void isRemoveCostCenter(Context ctx, PayRequestBillInfo info) throws EASBizException, BOSException {
        boolean flag;
        String costCenterOrgUnitID = null;
        if (info.getCostCenter().getId() != null) {
            costCenterOrgUnitID = info.getCostCenter().getId().toString();
        }
        if (!(flag = this.isInclundCostCenter(ctx, costCenterOrgUnitID, info.getCompany().getId().toString()))) {
            info.setCostCenter(null);
        }
    }

    public void setSupplierBank2Entry(Context ctx, PayRequestBillEntryInfo entry, SupplierInfo asscActInfo, BOSUuid companyid) throws BOSException, EASBizException {
        if (asscActInfo.getId() != null) {
            Map bankInfo = ArApBillUtil.getBankInfoByPayee(ctx, "t_bd_supplier", asscActInfo.getId().toString(), companyid.toString());
            if (entry.getAccountBank() == null && bankInfo.get("payeeBank") != null) {
                entry.setAccountBank((String)bankInfo.get("payeeBank"));
            }
            if (entry.getAccountBankNo() == null && bankInfo.get("bankAccount") != null) {
                entry.setAccountBankNo((String)bankInfo.get("bankAccount"));
            }
            if (StringUtils.isEmpty((String)entry.getBankNumber()) && bankInfo.get("bankNumber") != null) {
                entry.setBankNumber((String)bankInfo.get("bankNumber"));
            }
        }
    }

    public void setCustomerBank2Entry(Context ctx, PayRequestBillEntryInfo entry, CustomerInfo asscActInfo, BOSUuid companyid) throws BOSException, EASBizException {
        if (asscActInfo.getId() != null) {
            Map bankInfo = ArApBillUtil.getBankInfoByPayee(ctx, "t_bd_customer", asscActInfo.getId().toString(), companyid.toString());
            if (entry.getAccountBank() == null && bankInfo.get("payeeBank") != null) {
                entry.setAccountBank((String)bankInfo.get("payeeBank"));
            }
            if (entry.getAccountBankNo() == null && bankInfo.get("bankAccount") != null) {
                entry.setAccountBankNo((String)bankInfo.get("bankAccount"));
            }
            if (StringUtils.isEmpty((String)entry.getBankNumber()) && bankInfo.get("bankNumber") != null) {
                entry.setBankNumber((String)bankInfo.get("bankNumber"));
            }
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = null;
        try {
            pk = this.submitBill(ctx, model, null);
        }
        catch (MatchAssignmentException e) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource", (String)"Msg_BindWfInstance", (Locale)ctx.getOriginLocale()));
        }
        return pk;
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.submitBill(ctx, model, pk);
    }

    private void checkSourceCurrency(Context ctx, AbstractObjectCollection entries, String currencyId) throws BOSException, EASBizException {
        if (!entries.isEmpty()) {
            HashSet<String> sourceBillIds = new HashSet<String>();
            for (int i = 0; i < entries.size(); ++i) {
                PayRequestBillEntryInfo entry = (PayRequestBillEntryInfo)entries.getObject(i);
                if (StringUtils.isEmpty((String)entry.getSourceBillId())) continue;
                sourceBillIds.add(entry.getSourceBillId());
            }
            if (sourceBillIds.isEmpty()) {
                return;
            }
            GeneralCurrencyCheckBuilder currencyCheck = new GeneralCurrencyCheckBuilder(ctx, new ArrayList(sourceBillIds), ResourceBase.getString((String)AP_RESOURCE, (String)"PayReqBill", (Locale)ctx.getLocale()));
            currencyCheck.check(currencyId);
        }
    }

    protected IObjectPK submitBill(Context ctx, IObjectValue model, IObjectPK infoPK) throws BOSException, EASBizException {
        int value;
        BillEntryBaseInfo entryInfo;
        Iterator entryIterator;
        PayRequestSumEntryCollection entryColl;
        PayRequestBillInfo info = (PayRequestBillInfo)model;
        PayRequestBillInfo oldModel = null;
        if (model.get("id") != null) {
            String id = model.get("id").toString();
            try {
                oldModel = (PayRequestBillInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(id));
            }
            catch (Exception e) {
                oldModel = null;
            }
        }
        PayRequestBillEntryCollection entrycollection = info.getEntrys();
        this.checkSourceCurrency(ctx, entrycollection, info.getCurrency().getId().toString());
        this.beforeSaveOrSubmit(ctx, info);
        if (null != info.getSumEntry()) {
            entryColl = info.getSumEntry();
            entryIterator = entryColl.iterator();
            entryInfo = null;
            BigDecimal totalSumPayReqAmt = BigDecimal.ZERO;
            BigDecimal totalSumAuditAmt = BigDecimal.ZERO;
            while (entryIterator.hasNext()) {
                entryInfo = (PayRequestSumEntryInfo)entryIterator.next();
                if (entryInfo.getReqPayAmount() != null) {
                    totalSumPayReqAmt = totalSumPayReqAmt.add(entryInfo.getReqPayAmount());
                }
                if (entryInfo.getAuditAmount() == null) continue;
                totalSumAuditAmt = totalSumAuditAmt.add(entryInfo.getAuditAmount());
            }
            if (totalSumPayReqAmt.compareTo(info.getRequestAmount()) != 0 || totalSumAuditAmt.compareTo(info.getAuditAmount()) != 0) {
                throw new PayRequestBillBizException(PayRequestBillBizException.SUM_AMT_NOT_EQUAL_BILL_AMT);
            }
        }
        if (info.isIsPaySchedule()) {
            entryColl = info.getSumEntry();
            entryIterator = entryColl.iterator();
            entryInfo = null;
            while (entryIterator.hasNext()) {
                entryInfo = (PayRequestSumEntryInfo)entryIterator.next();
                if (null == entryInfo.getFundPropertyNew()) {
                    throw new PayRequestBillBizException(PayRequestBillBizException.FUNDPROPERTY_NOTSET);
                }
                if (null == entryInfo.getPayableDate()) {
                    throw new PayRequestBillBizException(PayRequestBillBizException.PAYABLE_DATE_NOT_NULL);
                }
                if (null == entryInfo.getAccountBank()) {
                    throw new PayRequestBillBizException(PayRequestBillBizException.ACCOUNTBANKNAME_NOT_NULL);
                }
                if (null != entryInfo.getAccountBankNo()) continue;
                throw new PayRequestBillBizException(PayRequestBillBizException.ACCOUNTBANKNO_NOT_NULL);
            }
        }
        if (oldModel != null) {
            if (oldModel.getBillStatus() != null && oldModel.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) {
                throw new PayRequestBillBizException(new NumericExceptionSubItem("603", ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"5_PayRequestBillEditUI", (Locale)ctx.getLocale())));
            }
            if (oldModel.getBillStatus() != null && BillStatusEnum.DELETED.equals((Object)oldModel.getBillStatus())) {
                throw new PayRequestBillBizException(PayRequestBillBizException.HASIGNORE_CANNOTSUBMIT);
            }
        }
        this.checkHead4submit(ctx, info);
        this.checkEntry4submit(ctx, info);
        BigDecimal totalAuditAmount = new BigDecimal("0.00");
        boolean isDirectExchange = true;
        if (info.getCompany().getBaseCurrency() == null || info.getCompany().getBaseCurrency().getPrecision() == 0) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("baseExchangeTable.id"));
            sic.add(new SelectorItemInfo("baseCurrency.id"));
            sic.add(new SelectorItemInfo("baseCurrency.precision"));
            info.setCompany(CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getCompany().getId()), sic));
        }
        if (!info.getCurrency().getId().equals((Object)info.getCompany().getBaseCurrency().getId())) {
            ExchangeRateInfo rateInfo = BaseDataUtil.getExchangeRate(ctx, info.getCompany(), info.getCurrency(), info.getBizDate());
            if (rateInfo != null && rateInfo.getExchangeAux() != null && ConvertModeEnum.DIRECTEXCHANGERATE.equals((Object)rateInfo.getExchangeAux().getConvertMode())) {
                isDirectExchange = true;
            } else if (rateInfo != null && rateInfo.getExchangeAux() != null && ConvertModeEnum.INDIRECTEXCHANGERATE.equals((Object)rateInfo.getExchangeAux().getConvertMode())) {
                isDirectExchange = false;
            }
        }
        for (int i = 0; i < entrycollection.size(); ++i) {
            entryInfo = null;
            entryInfo = entrycollection.get(i);
            if (entryInfo.getAsstActID() == null && entryInfo.getAsstActNumber() != null) {
                entryInfo.setAsstActName(entryInfo.getAsstActNumber());
            }
            entryInfo.setUnpayAmount(entryInfo.getAuditAmount());
            if (isDirectExchange) {
                entryInfo.setAuditAmountLoc(entryInfo.getAuditAmount().multiply(info.getExchange_rate()).setScale(info.getCompany().getBaseCurrency().getPrecision(), 4));
            } else {
                entryInfo.setAuditAmountLoc(entryInfo.getAuditAmount().divide(info.getExchange_rate(), info.getCompany().getBaseCurrency().getPrecision(), 4));
            }
            totalAuditAmount = totalAuditAmount.add(entryInfo.getAuditAmount());
        }
        boolean isAddNew = true;
        if (info.getId() == null) {
            this._save(ctx, (IObjectValue)info);
        } else if (info.getId() != null && this.exists(ctx, (IObjectPK)new ObjectUuidPK(info.getId()))) {
            isAddNew = false;
        }
        if (!isAddNew) {
            AP2POWriteBackForInvoice.PRBWriteBackOrderForInvoiceByUpdate(ctx, info.getId().toString(), BOTBillOperStateEnum.DELETE);
        }
        PayRequestBillControllerBean.setNumber(ctx, (IObjectValue)info);
        if (StringUtils.isEmpty((String)info.getNumber())) {
            throw new PayRequestBillBizException(PayRequestBillBizException.NUMBER_NOTSET);
        }
        info.setBillStatus(BillStatusEnum.SUBMITED);
        info.setAuditAmount(totalAuditAmount);
        for (int i = 0; i < entrycollection.size(); ++i) {
            entryInfo = null;
            entryInfo = entrycollection.get(i);
            entryInfo.setEntryStatus(BillStatusEnum.SUBMITED);
        }
        this.check4submit(ctx, info);
        this.writeBackOtherbill(ctx, info);
        ArApBillUtil.checkAmtAndAmtLocalPrecision(ctx, info, info.getCurrency());
        ArApBillUtil.setDefaultValueZero(ctx, info);
        IObjectPK pk = null;
        if (null == infoPK) {
            pk = super._submit(ctx, (IObjectValue)info);
        } else {
            pk = infoPK;
            super._submit(ctx, infoPK, (IObjectValue)info);
        }
        ArrayList<BOSUuid> entryPayBankIDList = new ArrayList<BOSUuid>();
        for (int i = 0; i < entrycollection.size(); ++i) {
            entryInfo = null;
            entryInfo = entrycollection.get(i);
            if (entryInfo.getPayBank() == null) continue;
            entryPayBankIDList.add(entryInfo.getPayBank().getId());
        }
        if (entryPayBankIDList.size() > 0) {
            IArApBillFacade iArAp = ArApBillFacadeFactory.getLocalInstance((Context)ctx);
            Map bankToCurrency = iArAp.getAccountCurrencyMap(entryPayBankIDList, info.getId().toString());
            String infoCurrencyID = info.getCurrency().getId().toString();
            String entryCurrencyID = "";
            String entrySeq = "";
            String payBankID = "";
            for (int i = 0; i < entrycollection.size(); ++i) {
                PayRequestBillEntryInfo entry = entrycollection.get(i);
                entrySeq = entry.getSeq() + "";
                if (entry.getPayBank() == null) continue;
                payBankID = entry.getPayBank().getId().toString();
                if (bankToCurrency == null || !bankToCurrency.containsKey(entrySeq) || (entryCurrencyID = (String)bankToCurrency.get(entrySeq)) == null || infoCurrencyID.equals(entryCurrencyID)) continue;
                throw new PayRequestBillBizException(PayRequestBillBizException.APCURRENCYNOTEQUAL, new String[]{entrySeq});
            }
        }
        boolean needCheck = false;
        String companyID = info.getCompany().getId().toString();
        HashMap<String, String> hashKey = new HashMap<String, String>();
        hashKey.put("AP_033", companyID);
        hashKey.put("ORDERPAYMENT", companyID);
        hashKey.put("AP_CONTRACT", companyID);
        HashMap apPaymentBankMap = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(hashKey);
        needCheck = Boolean.valueOf((String)apPaymentBankMap.get("AP_033"));
        PayRequestBillEntryCollection entryCollection = info.getEntrys();
        this.checkGtOrderOrConstractAmt(ctx, apPaymentBankMap, info);
        if (needCheck) {
            this.checkAmtForRedBlueSourceBill(ctx, info);
        }
        this.writeBackBillEntrySumID(ctx, pk);
        ArApServerUtils.injectBizFlow(ctx, (IObjectValue)info, BatchActionEnum.SUBMIT);
        try {
            this.doAfterSaveSubmit(ctx, info);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (!model.getBoolean("isFromAudit")) {
            this.checkAuditAmtGtPrePay(ctx, info);
        }
        if (model.containsKey("isFromAudit")) {
            model.remove("isFromAudit");
        }
        String tableName = "T_AP_PAYREQUESTBILLENTRY";
        boolean isHasBizFlow = false;
        if (SCMServerUtils.isExistsBizFlowField((Context)ctx, (String)tableName) && SCMServerUtils.isHasBizFlowValue((Context)ctx, (String)tableName, (String)pk.toString())) {
            isHasBizFlow = true;
        }
        if (isHasBizFlow) {
            if (oldModel != null && oldModel.getBillStatus().getValue() == 2) {
                try {
                    BizBillValueChangeUtil.handleBillSubmit((Context)ctx, (IObjectValue)oldModel, (IObjectValue)info);
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
            ArApServerUtils.doWriteBack(ctx, (IObjectValue)info, BatchActionEnum.SUBMIT);
            if (oldModel != null && oldModel.getBillStatus().getValue() == 2) {
                try {
                    BizBillValueChangeUtil.resetBillChange((Context)ctx, (IObjectValue)model);
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        if ((value = this.getPayReqBgCtrlParam(ctx, info.getCompany().getId().toString(), "AP_BG_01")) == 0) {
            IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
            String strSysParamValue = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()), "MBG_C001");
            if (strSysParamValue != null && strSysParamValue.equals("false")) {
                this.verifyBillInfoAndBillBudget(ctx, info);
                BgControlCaller caller = new BgControlCaller();
                IControlResult result = caller.requestBudget(ctx, BOSUuid.read((String)pk.toString()));
                if (result.getResult() != 1) {
                    if (result.getCause() instanceof List) {
                        throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{((String)result.getCause().get(0)).toString()});
                    }
                    throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{result.getCause().toString()});
                }
            } else {
                BgControlCaller caller = new BgControlCaller();
                IControlResult result = caller.requestBudget(ctx, BOSUuid.read((String)pk.toString()));
                if (result.getResult() != 1) {
                    if (result.getCause() instanceof List) {
                        throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{((String)result.getCause().get(0)).toString()});
                    }
                    throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{result.getCause().toString()});
                }
            }
        }
        AP2POWriteBackForInvoice.PRBWriteBackOrderForInvoiceByUpdate(ctx, info, BOTBillOperStateEnum.ADDNEW);
        if (isAddNew) {
            DbUtil.execute((Context)ctx, (String)("update T_AP_PayRequestBill set FLastUpdateUserID=null,FLastUpdateTime=null where FID='" + pk.toString() + "'"));
        }
        return pk;
    }

    protected void checkHead4submit(Context ctx, PayRequestBillInfo info) throws EASBizException, BOSException {
        if (info.getEntrys() == null || info.getEntrys().size() == 0) {
            throw new PayRequestBillBizException(PayRequestBillBizException.ENTRY_NOTEXIST);
        }
        if (info.isIsPaySchedule() && null != info.getSumEntry() && info.getSumEntry().size() > 1) {
            throw new PayRequestBillBizException(PayRequestBillBizException.PAY_SCHEDUAL_ONLY_ONE);
        }
        if (info.getBillStatus() != null && info.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) {
            throw new PayRequestBillBizException(new NumericExceptionSubItem("603", ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"5_PayRequestBillEditUI", (Locale)ctx.getLocale())));
        }
        if (info.getBillStatus() != null) {
            if (BillStatusEnum.DELETED.equals((Object)info.getBillStatus())) {
                throw new PayRequestBillBizException(PayRequestBillBizException.HASIGNORE_CANNOTSUBMIT);
            }
        }
        if (info.getCompany() == null) {
            throw new PayRequestBillBizException(PayRequestBillBizException.COMPANY_NOTSET);
        }
        if (info.getBizDate() == null) {
            throw new PayRequestBillBizException(PayRequestBillBizException.BILLDATE_NOTSET);
        }
        if (info.getApplyer() == null) {
            throw new PayRequestBillBizException(PayRequestBillBizException.APPLYER_NOSET);
        }
        if (info.getCurrency() == null) {
            throw new PayRequestBillBizException(PayRequestBillBizException.CURRENCY_NOTSET);
        }
        if (info.getRequestAmount() == null) {
            throw new PayRequestBillBizException(PayRequestBillBizException.REQ_AMT_NOSET);
        }
        if (info.getExchange_rate() == null || info.getExchange_rate().compareTo(ZERO) == 0) {
            throw new PayRequestBillBizException(PayRequestBillBizException.EXCHANGE_RATE_CANNOT_NULL);
        }
    }

    protected void checkEntry4submit(Context ctx, PayRequestBillInfo info) throws EASBizException, BOSException {
        PayRequestBillEntryCollection entrycollection = info.getEntrys();
        String curentCurrencyid = null;
        String tempCurrencyid = null;
        ArApRecPayServerHelper arapHelper = new ArApRecPayServerHelper();
        Integer payType = null;
        SourceTypeEnum sourceTypeEnum = null;
        IPaymentBillType iPaymentBillType = PaymentBillTypeFactory.getLocalInstance((Context)ctx);
        HashMap<String, PaymentBillTypeInfo> cacheMap = new HashMap<String, PaymentBillTypeInfo>(5);
        HashMap<String, Boolean> isExistAsstActByCompanyMap = new HashMap<String, Boolean>(5);
        for (int i = 0; i < entrycollection.size(); ++i) {
            PaymentBillTypeInfo prePayType;
            PayRequestBillEntryInfo entryInfo = null;
            entryInfo = entrycollection.get(i);
            if (entryInfo.getPayType() == null) {
                throw new PayRequestBillBizException(PayRequestBillBizException.PAY_TYPE_NOSET);
            }
            if (entryInfo.getAsstActID() == null && entryInfo.getAsstActNumber() == null) {
                throw new PayRequestBillBizException(PayRequestBillBizException.ASSTNO_NOSET);
            }
            if (entryInfo.getReqPayAmount() == null || entryInfo.getReqPayAmount().compareTo(ZERO) == 0) {
                throw new PayRequestBillBizException(PayRequestBillBizException.ENTRY_REQ_AMT_NOSET);
            }
            if (i == 0 && entryInfo.getSourceCurrency() != null) {
                curentCurrencyid = entryInfo.getSourceCurrency().getId().toString();
                tempCurrencyid = entryInfo.getSourceCurrency().getId().toString();
            } else if (i == 0 && entryInfo.getSourceCurrency() == null) {
                curentCurrencyid = "";
                tempCurrencyid = "";
            } else if (i != 0 && entryInfo.getSourceCurrency() != null) {
                tempCurrencyid = entryInfo.getSourceCurrency().getId().toString();
            } else if (i != 0 && entryInfo.getSourceCurrency() == null) {
                tempCurrencyid = "";
            }
            if (!tempCurrencyid.equals(curentCurrencyid)) {
                throw new PayRequestBillBizException(PayRequestBillBizException.ENTRY_SOURCUR_NOSAME);
            }
            String paymentBillTypeId = entryInfo.getPayType().getId().toString();
            if (!cacheMap.containsKey(paymentBillTypeId)) {
                cacheMap.put(paymentBillTypeId, iPaymentBillType.getPaymentBillTypeInfo((IObjectPK)new ObjectUuidPK(paymentBillTypeId)));
            }
            if ((prePayType = (PaymentBillTypeInfo)cacheMap.get(paymentBillTypeId)).isIsPreSet()) {
                payType = Integer.valueOf(prePayType.getNumber());
            } else if (prePayType.getPreSetBillType() != null) {
                paymentBillTypeId = prePayType.getPreSetBillType().getId().toString();
                if (!cacheMap.containsKey(paymentBillTypeId)) {
                    cacheMap.put(paymentBillTypeId, iPaymentBillType.getPaymentBillTypeInfo((IObjectPK)new ObjectUuidPK(paymentBillTypeId)));
                }
                prePayType = (PaymentBillTypeInfo)cacheMap.get(paymentBillTypeId);
                payType = new Integer(prePayType.getNumber());
            }
            boolean blueFlag = arapHelper.checkIsDefaultBlueBillType(payType);
            boolean redFlag = arapHelper.checkIsDefaultRedBillType(payType);
            int sign = entryInfo.getReqPayAmount().signum();
            if (blueFlag && sign == -1 || redFlag && sign == 1) {
                throw new PayRequestBillBizException(PayRequestBillBizException.PAYREQ_TYPEAMTNOTMATCH);
            }
            String cacheKey = this.getIsExistAsstActByCompanyCacheKey(info.getCompany(), entryInfo.getAsstActType(), entryInfo.getAsstActID());
            if (!isExistAsstActByCompanyMap.containsKey(cacheKey)) {
                isExistAsstActByCompanyMap.put(cacheKey, this.isExistAsstActByCompany(ctx, info.getCompany(), entryInfo.getAsstActType(), entryInfo.getAsstActID()));
            }
            if (!((Boolean)isExistAsstActByCompanyMap.get(cacheKey)).booleanValue()) {
                throw new OtherBillBizException(OtherBillBizException.ACCTCUSSENT_NOTBELONGCOMORG);
            }
            if (sourceTypeEnum == null) {
                sourceTypeEnum = prePayType.getSourceSysType();
            }
            if (sourceTypeEnum.equals((Object)prePayType.getSourceSysType())) continue;
            throw new PayRequestBillBizException(PayRequestBillBizException.SOURCETYPEENUMDIF);
        }
    }

    protected void check4submit(Context ctx, PayRequestBillInfo info) throws EASBizException, BOSException {
        String companyId = info.getCompany().getId().toString();
        ArApServerUtils.commonBugdetCheck(ctx, companyId, (IObjectValue)info);
        if (info.getId() == null) {
            return;
        }
        if (!this._exists(ctx, (IObjectPK)new ObjectUuidPK(info.getId()))) {
            return;
        }
        boolean isNotAudited = this._exists(ctx, "where (billStatus=1 or billStatus=2) and id = '" + info.getId() + "'");
        if (!isNotAudited) {
            throw new OtherBillBizException(OtherBillBizException.BILLISAUDITED);
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PayRequestBillInfo payRequestBillInfo = (PayRequestBillInfo)model;
        this.checkSourceCurrency(ctx, payRequestBillInfo.getEntrys(), payRequestBillInfo.getCurrency().getId().toString());
        boolean isBillInShareFlow = false;
        if (null != payRequestBillInfo && null != payRequestBillInfo.getId() && null != payRequestBillInfo.getBillStatus()) {
            String billID = payRequestBillInfo.getId().toString();
            isBillInShareFlow = ArApBillUtil.isBillInShareFlow(ctx, isBillInShareFlow, billID, payRequestBillInfo.getBillStatus().getValue(), 2);
        }
        if (isBillInShareFlow) {
            return this._submit(ctx, model);
        }
        this.beforeSaveOrSubmit(ctx, payRequestBillInfo);
        if (payRequestBillInfo.getEntrys() == null || payRequestBillInfo.getEntrys().size() == 0) {
            throw new PayRequestBillBizException(PayRequestBillBizException.ENTRY_NOTEXIST);
        }
        if (payRequestBillInfo.getCompany() == null) {
            throw new PayRequestBillBizException(PayRequestBillBizException.COMPANY_NOTSET);
        }
        PayRequestBillControllerBean.setNumber(ctx, model);
        payRequestBillInfo.setBillStatus(BillStatusEnum.SAVE);
        for (int i = 0; i < payRequestBillInfo.getEntrys().size(); ++i) {
            payRequestBillInfo.getEntrys().get(i).setEntryStatus(BillStatusEnum.SAVE);
        }
        boolean isAddNew = true;
        if (payRequestBillInfo.getId() != null && this.exists(ctx, (IObjectPK)new ObjectUuidPK(payRequestBillInfo.getId()))) {
            isAddNew = false;
        }
        if (!isAddNew) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("billStatus");
            sic.add("CU.id");
            sic.add("invoiceNumber");
            sic.add("invoiceCode");
            sic.add("entrys.reqPayAmount");
            sic.add("entrys.coreBillId");
            sic.add("entrys.coreBillEntryId");
            sic.add("entrys.sourceBillId");
            PayRequestBillInfo oldBillInfo = this.getPayRequestBillInfo(ctx, (IObjectPK)new ObjectUuidPK(payRequestBillInfo.getId()), sic);
            if (oldBillInfo.getBillStatus().getValue() == 2) {
                throw new OtherBillBizException(OtherBillBizException.SUBMMITED_CANNNOTSAVE);
            }
            if (oldBillInfo.getBillStatus().getValue() == 3) {
                throw new OtherBillBizException(OtherBillBizException.AUDIT_BILL_CANNOT_SAVE);
            }
            AP2POWriteBackForInvoice.PRBWriteBackOrderForInvoiceByUpdate(ctx, oldBillInfo, BOTBillOperStateEnum.DELETE);
        }
        this.writeBackOtherbill(ctx, payRequestBillInfo);
        ArApBillUtil.setDefaultValueZero(ctx, payRequestBillInfo);
        IObjectPK pk = super._save(ctx, model);
        try {
            this.doAfterSaveSubmit(ctx, payRequestBillInfo);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        ArApServerUtils.injectBizFlow(ctx, (IObjectValue)payRequestBillInfo, BatchActionEnum.SAVE);
        if (isAddNew) {
            DbUtil.execute((Context)ctx, (String)("update T_AP_PayRequestBill set FLastUpdateUserID=null,FLastUpdateTime=null where FID='" + pk.toString() + "'"));
        }
        this.writeBackBillEntrySumID(ctx, pk);
        this.handleInvoiceInfo(ctx, payRequestBillInfo, "save");
        AP2POWriteBackForInvoice.PRBWriteBackOrderForInvoiceByUpdate(ctx, payRequestBillInfo, BOTBillOperStateEnum.ADDNEW);
        return pk;
    }

    private void handleInvoiceInfo(Context ctx, PayRequestBillInfo info, String method) throws EASBizException, BOSException {
        if ("save".equals(method)) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("billId", info.getId().toString());
            params.put("bizBillNumber", info.getNumber());
            params.put("bizBillType", MatchConstant.TYPEID_PAYREQUESTBILL);
            params.put("invoiceCode", info.getInvoiceCode());
            params.put("invoiceNumber", info.getInvoiceNumber());
            params.put("ctx", (String)ctx);
            IncomeInvoiceServerUtils.updateInvoiceInfoAndBotp(params);
        } else if ("audit".equals(method)) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("ctx", ctx);
            params.put("billId", info.getId().toString());
            String typeId = this.getPurOrderTypeId(ctx, info);
            params.put("rowType", typeId);
            IncomeInvoiceServerUtils.updateInvoiceInfo(params);
        } else if ("delete".equals(method)) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("billId", info.getId().toString());
            params.put("ctx", (String)ctx);
            IncomeInvoiceServerUtils.delInvoiceInfoAndBotp(params);
        } else if ("unAudit".equals(method)) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("billId", info.getId().toString());
            params.put("ctx", (String)ctx);
            IncomeInvoiceServerUtils.deleteInvoiceInfo(params);
        }
    }

    private String getPurOrderTypeId(Context ctx, PayRequestBillInfo info) throws BOSException {
        PayRequestBillEntryCollection entrys = info.getEntrys();
        PayRequestBillEntryInfo entry = null;
        String typeId = null;
        if (entrys.size() > 0) {
            entry = entrys.get(0);
            String sql = "SELECT FRowTypeID  FROM T_SM_PurOrderEntry WHERE FParentID = '" + entry.getCoreBillId() + "'  AND fid = '" + entry.getCoreBillEntryId() + "'";
            IRowSet rs = null;
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (rs.next()) {
                    typeId = rs.getString("FRowTypeID");
                }
            }
            catch (Exception ex) {
                logger.info((Object)ex);
                throw new BOSException((Throwable)ex);
            }
        }
        return typeId;
    }

    private void handleInvoiceMatch(Context ctx, PayRequestBillInfo info) {
        if (MatchConstant.MATCHBOTP.equals(ctx.get((Object)MatchConstant.MATCHBOTP))) {
            RecordToBillParams params = (RecordToBillParams)ctx.get((Object)MatchConstant.MATCHPARAMS);
            String codeStr = MatchUtils.getStringFromCollection(params.getInvoiceCodeList());
            String numberStr = MatchUtils.getStringFromCollection(params.getInvoiceNumberList());
            info.setInvoiceCode(codeStr);
            info.setInvoiceNumber(numberStr);
            for (int i = 0; i < info.getEntrys().size(); ++i) {
                PayRequestBillEntryInfo entry = info.getEntrys().get(i);
                entry.setReqPayAmount(params.getMatchedAmt().get(entry.getSourceBillEntryId()));
                entry.setAuditAmount(params.getMatchedAmt().get(entry.getSourceBillEntryId()));
            }
        }
    }

    protected void writeBackOtherbill(Context ctx, PayRequestBillInfo payRequestBillInfo) throws EASBizException, BOSException {
        BOSUuid payRequestBillId = payRequestBillInfo.getId();
        if (payRequestBillId != null && this.exists(ctx, (IObjectPK)new ObjectUuidPK(payRequestBillId))) {
            PayRequestBillInfo oldInfo = this.getPayRequestBillInfo(ctx, (IObjectPK)new ObjectUuidPK(payRequestBillInfo.getId()));
            WriteBackFactory.getInstance().getWriteBackHandler("48DA3A71", "D001019A").handle(ctx, BizActionEnum.DELETE, null, (IObjectValue)oldInfo);
        }
        WriteBackFactory.getInstance().getWriteBackHandler("48DA3A71", "D001019A").handle(ctx, BizActionEnum.SAVE, null, (IObjectValue)payRequestBillInfo);
    }

    @Override
    protected int _batchSubmit(Context ctx, Set idSet) throws BOSException, EASBizException {
        int success = 0;
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo entityView = new EntityViewInfo();
        entityView.setFilter(filter);
        entityView.setSelector(ArApSelectorFactory.getPayRequestBillSelector(true));
        PayRequestBillCollection payRequestbillCol = this.getPayRequestBillCollection(ctx, entityView);
        if (payRequestbillCol.size() > 0 && payRequestbillCol.size() <= 100) {
            int n = payRequestbillCol.size();
            for (int i = 0; i < n; ++i) {
                PayRequestBillInfo info = payRequestbillCol.get(i);
                logger.info((Object)("checkOtherBillInfoForSubmit(ctx, info)" + this.checkPayRequestbillInfoForSubmit(ctx, info)));
                if (info == null || !this.checkPayRequestbillInfoForSubmit(ctx, info)) continue;
                try {
                    BOTRelationCollection btpRelationCollection = iBTPManager.getRelationCollection(info.get("id").toString());
                    iBTPManager.submitRelations((CoreBillBaseInfo)info, btpRelationCollection);
                }
                catch (MatchAssignmentException e) {
                    throw new BOSException(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource", (String)"Msg_BindWfInstance", (Locale)ctx.getOriginLocale()));
                }
                ++success;
            }
        }
        return success;
    }

    @Override
    protected void _submit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        if (pk != null) {
            idSet.add(pk.toString());
            this.batchSubmit(ctx, idSet);
        }
    }

    private boolean checkPayRequestbillInfoForSubmit(Context ctx, PayRequestBillInfo info) throws EASBizException, BOSException {
        IMetaDataLoader imdl = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        EntityObjectInfo eoi = imdl.getEntity(this.getBOSType());
        if (info.getBillStatus().getValue() == 1) {
            if (info.getCompany() == null) {
                String alias = eoi.getPropertyByName("company").getAlias();
                throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{alias});
            }
            if (info.getNumber() == null) {
                String alias = eoi.getPropertyByName("number").getAlias();
                throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{alias});
            }
            if (info.getBizDate() == null) {
                String alias = eoi.getPropertyByName("bizDate").getAlias();
                throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{alias});
            }
            if (info.getApplyer() == null) {
                String alias = eoi.getPropertyByName("applyer").getAlias();
                throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{alias});
            }
            if (info.getCurrency() == null) {
                String alias = eoi.getPropertyByName("currency").getAlias();
                throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{alias});
            }
            if (info.getExchange_rate() == null) {
                String alias = eoi.getPropertyByName("exchante_rate").getAlias();
                throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{alias});
            }
            PayRequestBillEntryCollection entryCol = info.getEntrys();
            eoi = imdl.getEntity(new PayRequestBillEntryInfo().getBOSType());
            IPayRequestBillEntry iEntry = PayRequestBillEntryFactory.getLocalInstance(ctx);
            for (int i = entryCol.size() - 1; i > -1; --i) {
                PayRequestBillEntryInfo entryinfo = entryCol.get(i);
                if ((entryinfo = iEntry.getPayRequestBillEntryInfo((IObjectPK)new ObjectUuidPK(entryinfo.getId()))).getReqPayAmount() == null || entryinfo.getReqPayAmount().compareTo(ZERO) == 0) {
                    throw new PayRequestBillBizException(PayRequestBillBizException.ENTRY_REQ_AMT_NOSET);
                }
                if (entryinfo.getPayType() == null) {
                    String alias = eoi.getPropertyByName("payType").getAlias();
                    throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{alias});
                }
                if (entryinfo.getAsstActType() == null && !"NLGLdwEREADgAAIGwKgSRj6TKVs=".equals(entryinfo.getPayType().getId().toString())) {
                    String alias = eoi.getPropertyByName("asstActType").getAlias();
                    throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{alias});
                }
                if (entryinfo.getPayType() == null) {
                    String alias = eoi.getPropertyByName("payType").getAlias();
                    throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{alias});
                }
                if (entryinfo.getAsstActNumber() == null) {
                    String alias = eoi.getPropertyByName("asstActNumber").getAlias();
                    throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{alias});
                }
                if (entryinfo.getAsstActName() == null) {
                    String alias = eoi.getPropertyByName("asstActName").getAlias();
                    throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{alias});
                }
                if (entryinfo.getReqPayAmount() == null) {
                    String alias = eoi.getPropertyByName("reqPayAmount").getAlias();
                    throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{alias});
                }
                if (entryinfo.getAuditAmount() == null) {
                    entryinfo.setAuditAmount(ZERO);
                }
                if (entryinfo.getSurceReqAmt() == null) {
                    entryinfo.setSurceReqAmt(ZERO);
                }
                if (entryinfo.getSrcPpayUnreqAmt() == null) {
                    entryinfo.setSrcPpayUnreqAmt(ZERO);
                }
                if (entryinfo.getSrcUnreqAmt() == null) {
                    entryinfo.setSrcUnreqAmt(ZERO);
                }
                if (entryinfo.getTotalPayAmt() == null) {
                    entryinfo.setTotalPayAmt(ZERO);
                }
                if (entryinfo.getUnpayAmount() != null) continue;
                entryinfo.setUnpayAmount(ZERO);
            }
            if (info.getEntrys().size() == 0) {
                this.delete(ctx, (IObjectPK)new ObjectUuidPK(info.getId()));
            }
        }
        if (info.getBillStatus().getValue() == 3) {
            throw new EASBizException(new NumericExceptionSubItem("603", ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"25_PayRequestBillControllerBean", (Locale)ctx.getLocale())));
        }
        if (BillStatusEnum.DELETED.equals((Object)info.getBillStatus())) {
            throw new PayRequestBillBizException(PayRequestBillBizException.HASIGNORE_CANNOTSUBMIT);
        }
        if (this.hasCloseEntry(info)) {
            throw new PayRequestBillBizException(PayRequestBillBizException.HASCLOSE_CANNOTSUBMIT);
        }
        return true;
    }

    public static void setNumber(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PayRequestBillInfo info = (PayRequestBillInfo)model;
        String companyId = null;
        boolean autoAndNewView = false;
        if (info.getCompany() != null) {
            companyId = info.getCompany().getId().toString();
        }
        if (StringUtils.isEmpty(companyId)) {
            return;
        }
        ICodingRuleManager iCodingMgr = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CodingRuleInfo codingRuleInfo = iCodingMgr.getCodingRule((IObjectValue)info, companyId);
        if (codingRuleInfo != null) {
            autoAndNewView = codingRuleInfo.isIsAddView();
        }
        if (!StringUtils.isEmpty((String)info.getNumber()) && PayRequestBillControllerBean.hasSameNumber(ctx, info, info.getNumber()) && codingRuleInfo == null) {
            throw new OtherBillBizException(OtherBillBizException.CHECKNUMBERDUP, new String[]{info.getNumber()});
        }
        if (!StringUtils.isEmpty((String)info.getNumber()) && !PayRequestBillControllerBean.hasSameNumber(ctx, info, info.getNumber())) {
            return;
        }
        if (StringUtils.isEmpty((String)info.getNumber()) && codingRuleInfo != null) {
            PayRequestBillControllerBean.getNumber(ctx, model, codingRuleInfo, iCodingMgr, false);
        } else if (!StringUtils.isEmpty((String)info.getNumber()) && PayRequestBillControllerBean.hasSameNumber(ctx, info, info.getNumber()) && codingRuleInfo != null) {
            PayRequestBillControllerBean.getNumber(ctx, model, codingRuleInfo, iCodingMgr, true);
        }
        if (StringUtils.isEmpty((String)info.getNumber()) && codingRuleInfo == null) {
            throw new PayRequestBillBizException(PayRequestBillBizException.NUMBER_NOT_NULL);
        }
        if (!StringUtils.isEmpty((String)info.getNumber()) && codingRuleInfo != null && PayRequestBillControllerBean.hasSameNumber(ctx, info, info.getNumber())) {
            throw new OtherBillBizException(OtherBillBizException.CHECKNUMBERDUP, new String[]{info.getNumber()});
        }
    }

    public static void getNumber(Context ctx, IObjectValue model, CodingRuleInfo codingRuleInfo, ICodingRuleManager iCodingMgr, boolean isHasSameNumber) throws BOSException, EASBizException {
        PayRequestBillInfo info = (PayRequestBillInfo)model;
        String companyId = null;
        if (info.getCompany() != null) {
            companyId = info.getCompany().getId().toString();
        }
        String number = null;
        if (codingRuleInfo != null) {
            number = iCodingMgr.getNumber((IObjectValue)info, companyId, "");
            if (PayRequestBillControllerBean.hasSameNumber(ctx, info, number)) {
                PayRequestBillControllerBean.getNumber(ctx, (IObjectValue)info, codingRuleInfo, iCodingMgr, true);
            } else {
                info.setNumber(number);
            }
        }
    }

    private static boolean hasSameNumber(Context ctx, PayRequestBillInfo model, String number) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company.number", (Object)model.getCompany().getNumber(), CompareType.EQUALS));
        if (model.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)model.getId(), CompareType.NOTEQUALS));
        }
        IPayRequestBill ipayreq = PayRequestBillFactory.getLocalInstance(ctx);
        return ipayreq.exists(filter);
    }

    private int getPayReqBgCtrlParam(Context ctx, String mainOrgUnitID, String paramNumber) throws BOSException, EASBizException {
        String strSysParamValue;
        int ctrlParamValue = 2;
        IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK mainOrgUnitPK = null;
        if (mainOrgUnitID != null) {
            mainOrgUnitPK = new ObjectUuidPK(mainOrgUnitID);
        }
        if ((strSysParamValue = iParamControl.getParamValue(mainOrgUnitPK, paramNumber)) == null || strSysParamValue.equals("")) {
            ctrlParamValue = 2;
        } else if (strSysParamValue.equals("0")) {
            ctrlParamValue = 0;
        } else if (strSysParamValue.equals("1")) {
            ctrlParamValue = 1;
        } else if (strSysParamValue.equals("2")) {
            ctrlParamValue = 2;
        }
        return ctrlParamValue;
    }

    private void verifyBillInfoAndBillBudget(Context ctx, PayRequestBillInfo info) throws EASBizException, BOSException {
        BgControlCaller caller = new BgControlCaller();
        if (info != null && caller.checkBizUnitInfo(ctx, (IObjectValue)info, null)) {
            if (BillStatusEnum.SUBMITED.equals((Object)info.getBillStatus())) {
                caller.returnBudget(ctx, BOSUuid.read((String)info.getId().toString()));
            }
            caller.checkBudget(ctx, (IObjectValue)info);
        }
    }

    protected boolean isExistBillInfo(Context ctx, String where) throws BOSException, EASBizException {
        boolean isExist = false;
        StringBuffer sbsql = new StringBuffer();
        sbsql = sbsql.append("select fid from T_AP_PayRequestBill  ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)(sbsql = sbsql.append(where)).toString());
        if (rs.size() > 0) {
            isExist = true;
        }
        return isExist;
    }

    protected String getIsExistAsstActByCompanyCacheKey(CompanyOrgUnitInfo comOrgInfo, AsstActTypeInfo assactTypeInfo, String asstActId) {
        StringBuilder buf = new StringBuilder(200);
        if (null != comOrgInfo) {
            buf.append(comOrgInfo.getId().toString());
        }
        if (null != assactTypeInfo) {
            buf.append(assactTypeInfo.getId().toString());
        }
        buf.append(asstActId);
        return buf.toString();
    }

    protected boolean isExistAsstActByCompany(Context ctx, CompanyOrgUnitInfo comOrgInfo, AsstActTypeInfo assactTypeInfo, String asstActId) throws BOSException, EASBizException {
        if (assactTypeInfo == null) {
            return true;
        }
        StringBuffer sql = new StringBuffer("");
        String relationDataObject = assactTypeInfo.getRealtionDataObject();
        if (relationDataObject == null) {
            assactTypeInfo = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(assactTypeInfo.getId()));
            relationDataObject = assactTypeInfo.getRealtionDataObject();
        }
        boolean fCust = relationDataObject.equalsIgnoreCase("T_BD_Customer");
        boolean fSupp = relationDataObject.equalsIgnoreCase("T_BD_Supplier");
        boolean isexists = false;
        if (fCust) {
            sql.append(" SELECT CUSTOMER.FID FROM T_BD_Customer AS CUSTOMER ");
            sql.append(" INNER JOIN T_BD_CustomerCompanyInfo AS CUSTOMERCOMPANYINFO ");
            sql.append(" ON CUSTOMER.FID = CUSTOMERCOMPANYINFO.FCustomerID ");
            sql.append(" LEFT OUTER JOIN T_ORG_Company AS COMPANYORGUNIT ");
            sql.append(" ON CUSTOMERCOMPANYINFO.FComOrgID = COMPANYORGUNIT.FID ");
            sql.append(" where COMPANYORGUNIT.FID = ?  and CUSTOMER.fid= ? ");
        } else if (fSupp) {
            sql.append(" SELECT SUPPLIER.FID FROM T_BD_Supplier AS SUPPLIER ");
            sql.append(" INNER JOIN T_BD_SupplierCompanyInfo AS SUPPLIERCOMPANY ");
            sql.append(" ON SUPPLIER.FID = SUPPLIERCOMPANY.FSupplierID ");
            sql.append(" LEFT OUTER JOIN T_ORG_Company AS COMPANYORGUNIT ");
            sql.append(" ON SUPPLIERCOMPANY.FComOrgID = COMPANYORGUNIT.FID ");
            sql.append(" where COMPANYORGUNIT.FID = ?  and SUPPLIER.fid= ? ");
        } else {
            return true;
        }
        Object[] param = new Object[]{comOrgInfo.getId().toString(), asstActId};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
        if (rowSet.size() > 0) {
            isexists = true;
        } else {
            logger.info((Object)("CompanyID: " + comOrgInfo.getId().toString() + " AsstActID: " + asstActId));
        }
        return isexists;
    }

    @Override
    protected void _update4Audit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean isMultiApprove;
        Object obj = model.get("isMultiApprove");
        boolean bl = isMultiApprove = obj == null ? false : Boolean.valueOf(obj.toString());
        if (isMultiApprove) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("billStatus"));
            PayRequestBillInfo info = (PayRequestBillInfo)model;
            if (info.getId() == null) {
                throw new IllegalArgumentException();
            }
            PayRequestBillInfo realInfo = this.getPayRequestBillInfo(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), selector);
            if (realInfo == null) {
                throw new PayRequestBillBizException(PayRequestBillBizException.BILL_NOTEXIST);
            }
            if (!BillStatusEnum.SUBMITED.equals((Object)realInfo.getBillStatus())) {
                throw new PayRequestBillBizException(PayRequestBillBizException.SAVINGORAUDITEDNOTAUDIT);
            }
            this.writeBackOtherbill(ctx, info);
            this.updatePartial(ctx, (CoreBaseInfo)info, this.getAuditSelector("audit"));
        } else {
            if (null != model) {
                model.setBoolean("isFromAudit", true);
            }
            IObjectPK pk = this.submitBill(ctx, model, null);
            this._audit(ctx, pk);
        }
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            return super._getValue(ctx, pk);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e.getMessage());
            return null;
        }
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        try {
            return super._getValue(ctx, pk, selector);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e.getMessage());
            return null;
        }
    }

    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector, SorterItemCollection sorter) throws BOSException, EASBizException {
        try {
            return super._getValue(ctx, pk, selector, sorter);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e.getMessage());
            return null;
        }
    }

    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SorterItemCollection sorter) throws BOSException, EASBizException {
        try {
            return super._getValue(ctx, pk, sorter);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e.getMessage());
            return null;
        }
    }

    @Override
    protected IObjectValue _getValue(Context ctx, String oql) throws BOSException, EASBizException {
        try {
            return super._getValue(ctx, oql);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e.getMessage());
            return null;
        }
    }

    protected void _newHandleAfterTransform(Context ctx, String action, IObjectCollection collection, String mappingId, IObjectCollection relationCol) throws BOSException, EASBizException {
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            BizFlowServerHelper.bizProcessParamBuilder((Context)ctx, (IObjectValue)collection.getObject(i), (IObjectCollection)relationCol, (BatchActionEnum)BatchActionEnum.SAVE);
            collection.getObject(i).put("mappingId", (Object)mappingId);
        }
    }

    protected void _newHandleAfterTransform(Context ctx, String action, IObjectValue objectValue, String mappingId, IObjectCollection relationCol) throws BOSException, EASBizException {
        BizFlowServerHelper.bizProcessParamBuilder((Context)ctx, (IObjectValue)objectValue, (IObjectCollection)relationCol, (BatchActionEnum)BatchActionEnum.SAVE);
        objectValue.put("mappingId", (Object)mappingId);
    }

    private void beforeSaveOrSubmit(Context ctx, PayRequestBillInfo info) throws BOSException, EASBizException {
        BigDecimal auditamt;
        this.setDefaultValue(ctx, info);
        PayRequestBillEntryCollection entrys = info.getEntrys();
        PayRequestBillEntryInfo entry = null;
        BigDecimal amt = auditamt = BigDecimal.ZERO;
        Iterator entrysIterator = entrys.iterator();
        while (entrysIterator.hasNext()) {
            String bankNumber;
            entry = (PayRequestBillEntryInfo)entrysIterator.next();
            if (StringUtils.isEmpty((String)entry.getAsstActID()) && StringUtils.isEmpty((String)entry.getAsstActNumber()) && (null == entry.getReqPayAmount() || entry.getReqPayAmount().compareTo(ZERO) == 0)) {
                entrysIterator.remove();
                continue;
            }
            BigDecimal entry_amt = entry.getReqPayAmount();
            BigDecimal entry_auditamt = entry.getAuditAmount();
            if (entry_amt != null) {
                amt = amt.add(entry_amt);
            }
            if (entry_auditamt != null) {
                auditamt = auditamt.add(entry_auditamt);
            }
            if (null == (bankNumber = entry.getAccountBankNo())) continue;
            entry.setAccountBankNo(bankNumber.replace(" ", ""));
        }
        info.setRequestAmount(amt);
        info.setAuditAmount(auditamt);
        String reqReason = info.getRequestReason();
        if (!StringUtils.isEmpty((String)reqReason) && reqReason.length() > 255) {
            info.setRequestReason(reqReason.substring(0, 255));
        }
        if (null != info.getSumEntry()) {
            PayRequestSumEntryCollection sumEntryColl = info.getSumEntry();
            Iterator sumEntryIterator = sumEntryColl.iterator();
            PayRequestSumEntryInfo sumEntry = null;
            while (sumEntryIterator.hasNext()) {
                sumEntry = (PayRequestSumEntryInfo)sumEntryIterator.next();
                if (!StringUtils.isEmpty((String)sumEntry.getAsstActID()) || !StringUtils.isEmpty((String)sumEntry.getAsstActNumber()) || null != sumEntry.getReqPayAmount() && sumEntry.getReqPayAmount().compareTo(ZERO) != 0) continue;
                sumEntryIterator.remove();
            }
        }
        entrys = info.getEntrys();
        for (int i = 0; i < entrys.size(); ++i) {
            entrys.get(i).setSeq(i + 1);
        }
    }

    private SelectorItemCollection getAuditSelector(String audit) {
        SelectorItemCollection col = new SelectorItemCollection();
        if ("audit".equals(audit)) {
            col.add(new SelectorItemInfo("billStatus"));
            col.add(new SelectorItemInfo("auditor"));
            col.add(new SelectorItemInfo("auditDate"));
            col.add(new SelectorItemInfo("apQtyGtPO"));
            col.add(new SelectorItemInfo("orderpayment"));
            col.add(new SelectorItemInfo("entrys.auditAmount"));
            col.add(new SelectorItemInfo("entrys.auditAmountLoc"));
            col.add(new SelectorItemInfo("auditAmount"));
            col.add(new SelectorItemInfo("entrys.unpayAmount"));
            col.add(new SelectorItemInfo("entrys.entryStatus"));
        } else if ("unAudit".equals(audit)) {
            col.add(new SelectorItemInfo("billStatus"));
            col.add(new SelectorItemInfo("auditor"));
            col.add(new SelectorItemInfo("auditDate"));
            col.add(new SelectorItemInfo("entrys.entryStatus"));
        }
        return col;
    }

    protected void doAfterSaveSubmit(Context ctx, PayRequestBillInfo payreqBill) throws BOSException, UuidException, SQLException {
        BOSUuid billId = payreqBill.getId();
        HashSet<String> srcIdSet = new HashSet<String>();
        IObjectCollection coll = payreqBill.getEntries();
        for (int i = 0; i < coll.size(); ++i) {
            String sourceBillId = coll.getObject(i).getString("sourceBillId");
            if (StringUtils.isEmpty((String)sourceBillId)) continue;
            srcIdSet.add(sourceBillId);
        }
        String relation = payreqBill.getExtendedProperty("rebuildBOTRelation");
        IBillImageFacade image = BillImageFacadeFactory.getLocalInstance((Context)ctx);
        String imageNumber = image.getImageNumber(payreqBill.getBOSType().toString(), billId.toString());
        if (StringUtils.isEmpty((String)imageNumber)) {
            imageNumber = image.genImageNumber(payreqBill.getBOSType().toString(), billId.toString());
        }
        payreqBill.put("coverNumber", imageNumber);
        if (!(payreqBill == null || billId == null || srcIdSet.isEmpty() || relation != null && Boolean.valueOf(relation).booleanValue())) {
            ArApServerUtils.createBotpRelation(ctx, srcIdSet, billId.toString());
        }
    }

    protected void checkReqPayAmt(Context ctx, PayRequestBillInfo info) throws PayRequestBillBizException {
        PayRequestBillEntryCollection entrys = info.getEntrys();
        Iterator entryIte = entrys.iterator();
        while (entryIte.hasNext()) {
            PayRequestBillEntryInfo entryInfo = (PayRequestBillEntryInfo)entryIte.next();
            BigDecimal reqPayAmt = entryInfo.getReqPayAmount();
            if (null != reqPayAmt && reqPayAmt.compareTo(new BigDecimal("0.00")) != 0) continue;
            entryIte.remove();
        }
        if (info.getEntrys().size() == 0) {
            throw new PayRequestBillBizException(new NumericExceptionSubItem("603", ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"24_PayRequestBillControllerBean", (Locale)ctx.getLocale())));
        }
    }

    protected void writeBackBillEntrySumID(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        IPayRequestBill iPayRequestBill = PayRequestBillFactory.getLocalInstance(ctx);
        PayReqCommmonServerUtil.writeBackBillEntrySumID(ctx, pk, iPayRequestBill);
    }

    @Override
    protected void _backTo4PP(Context ctx, IObjectPK billID, String flag) throws BOSException, EASBizException {
        this.antiAuditBill(ctx, billID, flag);
    }

    @Override
    protected void _ignore(Context ctx, IObjectPK billID) throws BOSException, EASBizException {
        BgControlCaller caller;
        IControlResult result;
        PayRequestBillInfo info = this.getPayRequestBillInfo(ctx, billID, ArApSelectorFactory.getPayRequestBillSelector(true));
        this.check4Ignore(ctx, info);
        if (BillStatusEnum.AUDITED.equals((Object)info.getBillStatus())) {
            this.antiAuditBill(ctx, billID, "ignore");
        }
        WriteBackFactory.getInstance().getWriteBackHandler("48DA3A71", "D001019A").handle(ctx, BizActionEnum.DELETE, null, (IObjectValue)info);
        int value = this.getPayReqBgCtrlParam(ctx, info.getCompany().getId().toString(), "AP_BG_01");
        if (value != 0 || !BillStatusEnum.SUBMITED.equals((Object)info.getBillStatus()) || (result = (caller = new BgControlCaller()).returnBudget(ctx, info.getId())).getResult() == 1) {
            // empty if block
        }
        info.setBillStatus(BillStatusEnum.DELETED);
        PayRequestBillEntryCollection entrys = info.getEntrys();
        PayRequestBillEntryInfo entry = null;
        for (int i = 0; i < entrys.size(); ++i) {
            entry = entrys.get(i);
            entry.setEntryStatus(BillStatusEnum.DELETED);
        }
        SelectorItemCollection col = new SelectorItemCollection();
        col.add(new SelectorItemInfo("billStatus"));
        col.add(new SelectorItemInfo("entrys.entryStatus"));
        this.updatePartial(ctx, (CoreBaseInfo)info, col);
    }

    private void check4Ignore(Context ctx, PayRequestBillInfo info) throws EASBizException, BOSException {
        if (info.getId() == null) {
            return;
        }
        if (!this._exists(ctx, (IObjectPK)new ObjectUuidPK(info.getId()))) {
            return;
        }
        Object entry = null;
        if (BillStatusEnum.AUDITED.equals((Object)info.getBillStatus())) {
            throw new PayRequestBillBizException(PayRequestBillBizException.AUDITED_BILL_EDIT);
        }
        if (BillStatusEnum.DELETED.equals((Object)info.getBillStatus())) {
            throw new PayRequestBillBizException(PayRequestBillBizException.HASIGNORE_CNNOTIGNORE);
        }
        if (this.hasCloseEntry(info)) {
            throw new PayRequestBillBizException(PayRequestBillBizException.HASCLOSE_CANNOTIGNORE);
        }
    }

    protected boolean hasCloseEntry(PayRequestBillInfo info) {
        Boolean hasColseEntry = false;
        if (info.getEntrys() == null || info.getEntrys().size() == 0) {
            return hasColseEntry;
        }
        PayRequestBillEntryInfo entry = null;
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            entry = info.getEntrys().get(i);
            if (!BillStatusEnum.COLSED.equals((Object)entry.getEntryStatus())) continue;
            hasColseEntry = true;
            break;
        }
        return hasColseEntry;
    }

    protected SelectorItemCollection getCompanySelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("CU.number"));
        sic.add(new SelectorItemInfo("CU.code"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("CU.longNumber"));
        sic.add(new SelectorItemInfo("baseExchangeTable.id"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        return sic;
    }

    public void checkAmtForRedBlueSourceBill(Context ctx, PayRequestBillInfo info) throws BOSException, EASBizException {
        if (info.getEntries().size() == 0) {
            return;
        }
        String sourceBillId = info.getEntrys().get(0).getSourceBillId();
        if (sourceBillId == null) {
            return;
        }
        String srcEntryTable = "T_AP_OTHERBILLENTRY";
        String sumFieldName = "entry.FUNVERIFYAMOUNT";
        String billName = ResourceBase.getString((String)AP_RESOURCE, (String)"APBill", (Locale)ctx.getLocale());
        String amountName = ResourceBase.getString((String)AP_RESOURCE, (String)"UnVerifyAmt", (Locale)ctx.getLocale());
        PayRequestBillEntryCollection infoCollection = info.getEntrys();
        PayRequestBillEntryInfo entryInfo = null;
        HashSet<String> srcIdSet = new HashSet<String>();
        for (int i = 0; i < infoCollection.size(); ++i) {
            entryInfo = infoCollection.get(i);
            if (StringUtils.isEmpty((String)entryInfo.getSourceBillId())) continue;
            srcIdSet.add(entryInfo.getSourceBillId());
        }
        String payBillId = info.getId().toString();
        String sourceBillIds = ListUtil.transList2String(srcIdSet);
        StringBuilder sqlBuilder = new StringBuilder(500);
        sqlBuilder.append("SELECT * FROM (");
        sqlBuilder.append("\t\tSELECT entry.FPARENTID FID");
        sqlBuilder.append("\t\t\t,sum(").append(sumFieldName).append(") FAmount");
        sqlBuilder.append("\t\tFROM ").append(srcEntryTable).append(" entry");
        sqlBuilder.append("\t\tWHERE entry.FPARENTID IN ").append(sourceBillIds);
        sqlBuilder.append("\t\tGROUP BY entry.FPARENTID");
        sqlBuilder.append("\t\t) result1");
        sqlBuilder.append(" INNER JOIN (");
        sqlBuilder.append("\t\tSELECT entry.FSOURCEBILLID FID");
        sqlBuilder.append("\t\t\t,sum(entry.FAUDITAMOUNT) FAmount");
        sqlBuilder.append("\t\tFROM T_AP_PAYREQUESTBILLENTRY entry");
        sqlBuilder.append("\t\tWHERE entry.FPARENTID = '").append(payBillId).append("'");
        sqlBuilder.append("\t\tGROUP BY entry.FSOURCEBILLID");
        sqlBuilder.append("\t\t) result2 ON result1.FID = result2.FID");
        sqlBuilder.append("\tWHERE result1.FID IN ").append(sourceBillIds);
        sqlBuilder.append("\t\tAND abs(result2.FAmount) > abs(result1.Famount)");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sqlBuilder.toString());
        try {
            if (result.next()) {
                throw new PaymentBillBizException(PaymentBillBizException.PAYREQAMTLESSAPPAYAMY, new Object[]{billName, amountName});
            }
        }
        catch (SQLException exc) {
            throw new BOSException("CONFIG_EXCEPTION", (Throwable)exc);
        }
    }

    public boolean _needCheckRebuild4DAP(Context ctx) throws BOSException {
        return true;
    }

    protected void checkAuditAmtGtPrePay(Context ctx, PayRequestBillInfo info) throws EASBizException, BOSException {
        String sourceBillEntry = info.getEntrys().get(0).getSourceBillEntryId();
        if (StringUtils.isEmpty((String)sourceBillEntry)) {
            return;
        }
        BOSUuid uuid = BOSUuid.read((String)sourceBillEntry);
        String bosType = uuid.getType().toString();
        String companyID = info.getCompany().getId().toString();
        HashMap<String, String> hashKey = new HashMap<String, String>();
        hashKey.put("ORDERPAYMENT", companyID);
        hashKey.put("AP_CONTRACT", companyID);
        HashMap paramMap = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(hashKey);
        boolean ORDERPAYMENT = this.getParamValue(paramMap, "ORDERPAYMENT");
        boolean PURCONTRACTPREPAY = this.getParamValue(paramMap, "AP_CONTRACT");
        if (new PurOrderEntryInfo().getBOSType().toString().equals(bosType) && !ORDERPAYMENT) {
            this.checkForPurOrder(ctx, info);
        } else if (new PurContractEntryInfo().getBOSType().toString().equals(bosType) && !PURCONTRACTPREPAY) {
            this.checkForPurContract(ctx, info);
        }
    }

    protected void checkForSubContractOrder(Context ctx, PayRequestBillInfo info) throws BOSException, PayRequestBillBizException {
        StringBuilder checkSQL = new StringBuilder(300);
        checkSQL.append(" SELECT reqBill.FNUMBER AS FNUMBER");
        checkSQL.append(" FROM T_AP_PAYREQUESTBILL reqBill");
        checkSQL.append(" INNER JOIN T_AP_PAYREQUESTBILLENTRY reqEntry ON reqBill.FID = reqEntry.FPARENTID");
        checkSQL.append(" INNER JOIN T_SM_SUBCONTRACTORDERENTRY orderEntry ON reqEntry.FSOURCEBILLENTRYID = orderEntry.FID");
        checkSQL.append(" WHERE reqBill.FID = '").append(info.getId()).append("'");
        checkSQL.append(" AND abs(reqEntry.FAUDITAMOUNT) > abs(orderEntry.FUNPREPAIDAMOUNT)");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)checkSQL.toString());
        try {
            if (result.next()) {
                throw new PayRequestBillBizException(PayRequestBillBizException.REQ_AMT_GT_PRE_PAY_AMT, new Object[]{info.getNumber()});
            }
        }
        catch (SQLException e) {
            throw new BOSException("PayRequestBillControllerBean.checkAuditAmtGtPrePay SQLError", (Throwable)e);
        }
    }

    protected void checkForPurOrder(Context ctx, PayRequestBillInfo info) throws BOSException, PayRequestBillBizException {
        HashSet<String> coreBillEntrySet = new HashSet<String>();
        PayRequestBillEntryCollection entryColl = info.getEntrys();
        PayRequestBillEntryInfo entryInfo = null;
        for (int i = 0; i < entryColl.size(); ++i) {
            entryInfo = entryColl.get(i);
            if (StringUtils.isEmpty((String)entryInfo.getSourceBillEntryId())) continue;
            coreBillEntrySet.add(entryInfo.getSourceBillEntryId());
        }
        if (coreBillEntrySet.isEmpty()) {
            return;
        }
        String coreBillEntryStr = ListUtil.transList2String(coreBillEntrySet);
        StringBuilder checkSQL = new StringBuilder(300);
        checkSQL.append(" SELECT FORDERID");
        checkSQL.append(" FROM (");
        checkSQL.append(" \tSELECT reqEntry.FSOURCEBILLENTRYID AS FORDERID");
        checkSQL.append(" \t\t,sum(reqEntry.FAUDITAMOUNT) AS FAUDITAMT");
        checkSQL.append(" \tFROM T_AP_PAYREQUESTBILL reqBill");
        checkSQL.append(" \tINNER JOIN T_AP_PAYREQUESTBILLENTRY reqEntry ON reqBill.FID = reqEntry.FPARENTID");
        checkSQL.append(" \tWHERE reqEntry.FSourceBillEntryid in ").append(coreBillEntryStr);
        checkSQL.append(" \t\tAND reqBill.FBILLSTATUS = ").append(2);
        checkSQL.append(" \tGROUP BY reqEntry.FSOURCEBILLENTRYID");
        checkSQL.append(" \t) AS result ");
        checkSQL.append(" INNER JOIN T_SM_PURORDERENTRY orderEntry ON orderEntry.FID = result.FORDERID");
        checkSQL.append(" WHERE orderEntry.FID IN ").append(coreBillEntryStr).append("");
        checkSQL.append(" AND (result.FAUDITAMT) > (orderEntry.FPREPAYMENT-isnull(orderEntry.FTOTALPREPAYAMT, 0))");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)checkSQL.toString());
        try {
            if (result.next()) {
                throw new PayRequestBillBizException(PayRequestBillBizException.REQ_AMT_GT_PRE_PAY_AMT, new Object[]{info.getNumber()});
            }
        }
        catch (SQLException e) {
            throw new BOSException("PayRequestBillControllerBean.checkAuditAmtGtPrePay SQLError", (Throwable)e);
        }
    }

    protected void checkForPurContract(Context ctx, PayRequestBillInfo info) throws BOSException, PayRequestBillBizException {
        HashSet<String> coreBillEntrySet = new HashSet<String>();
        PayRequestBillEntryCollection entryColl = info.getEntrys();
        PayRequestBillEntryInfo entryInfo = null;
        for (int i = 0; i < entryColl.size(); ++i) {
            entryInfo = entryColl.get(i);
            if (StringUtils.isEmpty((String)entryInfo.getSourceBillEntryId())) continue;
            coreBillEntrySet.add(entryInfo.getSourceBillEntryId());
        }
        if (coreBillEntrySet.isEmpty()) {
            return;
        }
        String coreBillEntryStr = ListUtil.transList2String(coreBillEntrySet);
        StringBuilder checkSQL = new StringBuilder(300);
        checkSQL.append(" SELECT FORDERID");
        checkSQL.append(" FROM (");
        checkSQL.append(" \tSELECT reqEntry.FSOURCEBILLENTRYID AS FORDERID");
        checkSQL.append(" \t\t,sum(reqEntry.FAUDITAMOUNT) AS FAUDITAMT");
        checkSQL.append(" \tFROM T_AP_PAYREQUESTBILL reqBill");
        checkSQL.append(" \tINNER JOIN T_AP_PAYREQUESTBILLENTRY reqEntry ON reqBill.FID = reqEntry.FPARENTID");
        checkSQL.append(" \tWHERE reqEntry.FSourceBillEntryid in ").append(coreBillEntryStr);
        checkSQL.append(" \t\tAND reqBill.FBILLSTATUS = ").append(2);
        checkSQL.append(" \tGROUP BY reqEntry.FSOURCEBILLENTRYID");
        checkSQL.append(" \t) AS result ");
        checkSQL.append(" INNER JOIN T_SM_PurContractEntry orderEntry ON orderEntry.FID = result.FORDERID");
        checkSQL.append(" WHERE orderEntry.FID IN ").append(coreBillEntryStr).append("");
        checkSQL.append(" AND (result.FAUDITAMT) > (orderEntry.FPREPAYMENT-isnull(orderEntry.FTOTALPREAMT, 0))");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)checkSQL.toString());
        try {
            if (result.next()) {
                throw new PayRequestBillBizException(PayRequestBillBizException.REQ_AMT_GT_CONTRACT_PRE_PAY_AMT, new Object[]{info.getNumber()});
            }
        }
        catch (SQLException e) {
            throw new BOSException("PayRequestBillControllerBean.checkAuditAmtGtPrePay SQLError", (Throwable)e);
        }
    }

    @Override
    protected void _close(Context ctx, IObjectPK pk, IObjectPK billId, String reasonCode) throws BOSException, EASBizException {
        ArApServerUtils.addSQLLock(ctx, pk);
        IPayRequestBillEntry iPayrequestEntry = PayRequestBillEntryFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = this.getEntrySelect();
        PayRequestBillEntryInfo entryInfo = iPayrequestEntry.getPayRequestBillEntryInfo(pk, sic);
        String companyId = entryInfo.getParent().getCompany().getId().toString();
        String detail = this.getStrRes(ctx, "NUMBER_SEQ", new Object[]{entryInfo.getParent().getNumber(), entryInfo.getSeq()});
        IObjectPK LogPK = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)entryInfo.getBOSType(), null, (String)detail, (String)"fi_ap_Payrequestbill_close", (String)companyId);
        this.checkForClose(ctx, entryInfo);
        entryInfo.setEntryStatus(BillStatusEnum.COLSED);
        entryInfo.setReason(reasonCode);
        entryInfo.setIsManualClose(true);
        iPayrequestEntry.update(pk, (CoreBaseInfo)entryInfo);
        this._updateBillStatus(ctx, "'" + pk.toString() + "'", true);
        PayRequestBillInfo info = entryInfo.getParent();
        info.getEntrys().add(entryInfo);
        this.writeBackSourceBill(ctx, BizActionEnum.CLOSE, info);
        LogUtil.afterLog((Context)ctx, (IObjectPK)LogPK);
    }

    @Override
    protected void _updateBillStatus(Context ctx, Set idSet, boolean isClose) throws BOSException, EASBizException {
        String idStr = ArApBillHelper.ids2SqlString(idSet);
        this._updateBillStatus(ctx, idStr, isClose);
    }

    @Override
    protected void _updateBillStatus(Context ctx, String idStr, boolean isClose) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)idStr)) {
            return;
        }
        StringBuilder updateSql = new StringBuilder(200);
        updateSql.append("update T_AP_PayRequestBill set fbillStatus = ").append(isClose ? -2 : 3);
        updateSql.append(" where fid in ");
        updateSql.append("( select bill.fid ");
        updateSql.append(" from T_AP_PayRequestBill bill inner join T_AP_PayRequestBillEntry entry on bill.fid = entry.FParentID ");
        updateSql.append(" where bill.fid in (select distinct FParentID from T_AP_PayRequestBillEntry where fid in (").append(idStr).append("))");
        updateSql.append(" and bill.fbillStatus = ").append(isClose ? 3 : -2);
        updateSql.append(" group by bill.fid having avg(entry.fEntrystatus) ");
        updateSql.append(isClose ? " = " : " <> ").append(-2).append(")");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
    }

    protected SelectorItemCollection getEntrySelect() {
        SelectorItemCollection sic = ArApSelectorFactory.getPayRequestBillEntrySelector(null);
        sic.add("parent.id");
        sic.add("parent.number");
        sic.add("parent.company.id");
        sic.add("parent.isPaySchedule");
        return sic;
    }

    protected void writeBackSourceBill(Context ctx, BizActionEnum bizAction, PayRequestBillInfo info) throws EASBizException, BOSException {
        boolean isPrePay = info.getEntrys().size() > 0 && info.getEntrys().get(0).getPayType().isIsPrePay();
        BizSceneEnum bizScene = isPrePay ? BizSceneEnum.PRE_RECPAY_SCENE : BizSceneEnum.RECPAY_SCENE;
        HashSet<IWriteBackHandler> handlers = new HashSet<IWriteBackHandler>();
        handlers.add(WriteBackFactory.getInstance().getWriteBackHandler("78B50853", "D001019A"));
        handlers.add(WriteBackFactory.getInstance().getWriteBackHandler("3171BFAD", "D001019A"));
        handlers.add(WriteBackFactory.getInstance().getWriteBackHandler("48DA3A71", "D001019A"));
        for (IWriteBackHandler handler : handlers) {
            handler.handle(ctx, bizAction, bizScene, (IObjectValue)info);
        }
    }

    private PayRequestBillEntryCollection getPayrequestBillEnrtyCollection(Context ctx, Set idSet) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        return PayRequestBillEntryFactory.getLocalInstance(ctx).getPayRequestBillEntryCollection(ev);
    }

    private void checkForClose(Context ctx, PayRequestBillEntryInfo entryInfo) throws EASBizException, BOSException {
        if (!BillStatusEnum.AUDITED.equals((Object)entryInfo.getEntryStatus())) {
            throw new PayRequestBillBizException(PayRequestBillBizException.ONLY_CLOSE_AUDIT_BILL);
        }
        if (entryInfo.getLockAmount().compareTo(entryInfo.getTotalPayAmt()) != 0) {
            throw new PayRequestBillBizException(PayRequestBillBizException.ENTRY_TOTALPAYAMT_NOTEQ_LOCKAMT);
        }
        if (entryInfo.getParent().isIsPaySchedule()) {
            throw new PayRequestBillBizException(PayRequestBillBizException.PS_PAYREQUEST_NOT_CLOSE);
        }
    }

    @Override
    protected void _unClose(Context ctx, IObjectPK pk, IObjectPK billId) throws BOSException, EASBizException {
        IPayRequestBillEntry iPayrequestEntry = PayRequestBillEntryFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = this.getEntrySelect();
        sic.add("parent.isPaySchedule");
        PayRequestBillEntryInfo entryInfo = iPayrequestEntry.getPayRequestBillEntryInfo(pk, sic);
        String companyId = entryInfo.getParent().getCompany().getId().toString();
        String detail = this.getStrRes(ctx, "NUMBER_SEQ", new Object[]{entryInfo.getParent().getNumber(), entryInfo.getSeq()});
        IObjectPK LogPK = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)entryInfo.getBOSType(), null, (String)detail, (String)"fi_ap_Payrequestbill_unClose", (String)companyId);
        this.checkForUnClose(ctx, entryInfo);
        entryInfo.setEntryStatus(BillStatusEnum.AUDITED);
        entryInfo.setReason(null);
        entryInfo.setIsManualClose(false);
        iPayrequestEntry.update(pk, (CoreBaseInfo)entryInfo);
        this._updateBillStatus(ctx, "'" + pk.toString() + "'", false);
        PayRequestBillInfo info = entryInfo.getParent();
        info.getEntrys().add(entryInfo);
        info.setId(entryInfo.getParent().getId());
        this.writeBackSourceBill(ctx, BizActionEnum.UNCLOSE, info);
        LogUtil.afterLog((Context)ctx, (IObjectPK)LogPK);
    }

    private void checkForUnClose(Context ctx, PayRequestBillEntryInfo entryInfo) throws EASBizException, BOSException {
        if (!BillStatusEnum.COLSED.equals((Object)entryInfo.getEntryStatus())) {
            throw new PayRequestBillBizException(PayRequestBillBizException.ENTRY_NOTCLOSE_CANNOT_UNCLOSE);
        }
        if (!entryInfo.isIsManualClose()) {
            throw new PayRequestBillBizException(PayRequestBillBizException.ENTRY_HASPAY_CANNOTUNCLOSE);
        }
        if (entryInfo.getAuditAmount().abs().compareTo(entryInfo.getTotalPayAmt().abs()) <= 0) {
            throw new PayRequestBillBizException(null);
        }
        if (entryInfo.getParent().isIsPaySchedule()) {
            throw new PayRequestBillBizException(PayRequestBillBizException.PS_PAYREQUEST_NOT_UNCLOSE);
        }
    }

    public String getStrRes(Context ctx, String key, Object[] params) {
        return ResourceBase.getString((String)AP_RESOURCE, (String)key, (Locale)ctx.getLocale(), (Object[])params);
    }

    public String getStrRes(Context ctx, String key) {
        return ResourceBase.getString((String)AP_RESOURCE, (String)key, (Locale)ctx.getLocale());
    }

    protected void _reverseSave(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum billOperStateEnun, IObjectValue relationInfo, IObjectValue destBillVO) throws BOSException, EASBizException {
    }
}

