/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountException;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomerCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplierCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.OtherBillBizException;
import com.kingdee.eas.fi.ap.PayRequestBillFactory;
import com.kingdee.eas.fi.ap.PayRequestBillInfo;
import com.kingdee.eas.fi.ap.RelatedApOtherBillInfo;
import com.kingdee.eas.fi.ap.app.AbstractPayRequestBillFacadeControllerBean;
import com.kingdee.eas.fi.ap.app.web.PayRequestBillService;
import com.kingdee.eas.fi.ap.app.web.PaymentReqBillCreateService;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.arap.util.ArApBillUtil;
import com.kingdee.eas.fi.arap.util.CollectionUtil;
import com.kingdee.eas.fi.arap.util.DBUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PayRequestBillFacadeControllerBean
extends AbstractPayRequestBillFacadeControllerBean {
    private static final int NOT_CLOSED = 0;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ap.app.PayRequestBillFacadeControllerBean");
    private static final long serialVersionUID = 8402613235909093681L;

    @Override
    protected Map<String, Object> _getExchange(Context ctx, String excTableid, String basecurrencyid, String currencyid, String billDate) throws BOSException, EASBizException {
        PayRequestBillService pbs = new PayRequestBillService(ctx);
        return pbs.getExchange(excTableid, basecurrencyid, currencyid, billDate);
    }

    @Override
    protected Map<String, Object> _getUIcache(Context ctx, String billId, String companyid, String status) throws BOSException, EASBizException {
        PayRequestBillService pbs = new PayRequestBillService(ctx);
        return pbs.getUIcache(billId, companyid, status);
    }

    @Override
    protected CoreBillBaseInfo _createBill(Context ctx, String mainOrgId) throws BOSException, EASBizException {
        PaymentReqBillCreateService pbs = new PaymentReqBillCreateService(ctx);
        return pbs.createBill(mainOrgId, null);
    }

    @Override
    protected CoreBillEntryBaseInfo _createBillEntry(Context ctx, String companyid) throws BOSException, EASBizException {
        PaymentReqBillCreateService pbs = new PaymentReqBillCreateService(ctx);
        return pbs.createBillEntry(companyid);
    }

    @Override
    protected Object _getAsstActCompanyBankInfo(Context ctx, String companyId, String asstActId, String asstActTypeId) throws BOSException, EASBizException {
        Object result = null;
        try {
            StringBuffer oql = new StringBuffer();
            IRowSet rs = null;
            oql.append("select fid, fRealtionDataObject from t_bd_asstActType where fid = '").append(asstActTypeId).append("'");
            rs = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
            String tableName = null;
            if (rs.next()) {
                tableName = rs.getString("fRealtionDataObject");
            }
            ObjectUuidPK companyPK = new ObjectUuidPK(companyId);
            HashMap<String, ObjectUuidPK> hashKey = new HashMap<String, ObjectUuidPK>();
            hashKey.put("AP_PAYBILL_BANK", companyPK);
            HashMap apPaymentBankMap = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(hashKey);
            Boolean isApPaymentBank = Boolean.valueOf((String)apPaymentBankMap.get("AP_PAYBILL_BANK"));
            Object asstActInfo = this.getAsstActInfo(ctx, tableName, asstActId);
            if ("T_BD_Customer".equals(tableName)) {
                if (((CustomerInfo)asstActInfo).isIsInternalCompany()) {
                    if (isApPaymentBank.booleanValue() && (result = this.getCustomerCompanyBankInfo(ctx, companyId, asstActId)) == null && ((CustomerInfo)asstActInfo).getInternalCompany() != null) {
                        result = this.getCompanyAccount(ctx, ((CustomerInfo)asstActInfo).getInternalCompany().getId().toString());
                    }
                } else {
                    result = this.getCustomerCompanyBankInfo(ctx, companyId, asstActId);
                }
            } else if ("T_BD_Supplier".equals(tableName)) {
                if (((SupplierInfo)asstActInfo).isIsInternalCompany()) {
                    if (isApPaymentBank.booleanValue() && (result = this.getSupplierCompanyBankInfo(ctx, companyId, asstActId)) == null && ((SupplierInfo)asstActInfo).getInternalCompany() != null) {
                        result = this.getCompanyAccount(ctx, ((SupplierInfo)asstActInfo).getInternalCompany().getId().toString());
                    }
                } else {
                    result = this.getSupplierCompanyBankInfo(ctx, companyId, asstActId);
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private Object getAsstActInfo(Context ctx, String tableName, String asstActId) throws BOSException, EASBizException {
        CustomerInfo asstActInfo = null;
        SelectorItemCollection selCol = new SelectorItemCollection();
        selCol.add(new SelectorItemInfo("isInternalCompany"));
        selCol.add(new SelectorItemInfo("internalCompany.id"));
        if ("T_BD_Customer".equals(tableName)) {
            asstActInfo = CustomerFactory.getLocalInstance((Context)ctx).getCustomerInfo((IObjectPK)new ObjectUuidPK(asstActId), selCol);
        } else if ("T_BD_Supplier".equals(tableName)) {
            asstActInfo = SupplierFactory.getLocalInstance((Context)ctx).getSupplierInfo((IObjectPK)new ObjectUuidPK(asstActId), selCol);
        }
        return asstActInfo;
    }

    private Map<String, Object> getCompanyAccount(Context ctx, String interalCompanyID) throws BOSException, EASBizException {
        HashMap<String, String> map = null;
        AccountBankInfo accountBankInfo = null;
        accountBankInfo = ArApBillUtil.getDefaultAcct(ctx, interalCompanyID);
        if (accountBankInfo != null) {
            map = new HashMap<String, String>();
            map.put("bank", accountBankInfo.getBank().getName());
            map.put("bankAccount", accountBankInfo.getBankAccountNumber());
            map.put("number", accountBankInfo.getNumber());
        }
        return map;
    }

    private SupplierCompanyBankInfo getSupplierCompanyBankInfo(Context ctx, String companyId, String supplierId) throws BOSException, EASBizException {
        StringBuilder oql = new StringBuilder(200);
        EntityViewInfo view = null;
        oql.append("select id where companyOrgUnit.id = ").append("'").append(companyId).append("'").append(" and supplier.id = ").append("'").append(supplierId).append("'");
        try {
            view = new EntityViewInfo(oql.toString());
            ISupplierCompanyInfo iCustComp = SupplierCompanyInfoFactory.getLocalInstance((Context)ctx);
            SupplierCompanyInfoCollection infos = iCustComp.getSupplierCompanyInfoCollection(view);
            if (infos != null && infos.size() > 0) {
                SupplierCompanyInfoInfo supCompInfo = infos.get(0);
                return ArApBillUtil.fetchSupplierCompanyBank(ctx, supCompInfo.getId().toString(), null, null);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    private CustomerCompanyBankInfo getCustomerCompanyBankInfo(Context ctx, String companyId, String customerId) throws BOSException, EASBizException {
        StringBuilder oql = new StringBuilder(200);
        EntityViewInfo view = null;
        oql.append("select id where companyOrgUnit.id = ").append("'").append(companyId).append("'").append(" and customer.id = ").append("'").append(customerId).append("'");
        try {
            view = new EntityViewInfo(oql.toString());
            ICustomerCompanyInfo iCustComp = CustomerCompanyInfoFactory.getLocalInstance((Context)ctx);
            CustomerCompanyInfoCollection infos = iCustComp.getCustomerCompanyInfoCollection(view);
            if (infos != null && infos.size() > 0) {
                CustomerCompanyInfoInfo custCompInfo = infos.get(0);
                return ArApBillUtil.fetchCustomerCompanyBank(ctx, custCompInfo.getId().toString(), null, null);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    @Override
    protected Map<String, Object> _handlerPersonChange(Context ctx, String personId) throws BOSException, EASBizException {
        PayRequestBillService pbs = new PayRequestBillService(ctx);
        return pbs.handlePersonChange(personId);
    }

    @Override
    protected List _getCombAsstActTypeItem(Context ctx, String companyid) throws BOSException {
        PayRequestBillService pbs = new PayRequestBillService(ctx);
        return pbs.getCombAsstActTypeItem(companyid);
    }

    @Override
    protected CoreBillEntryBaseInfo _createSumEntry(Context ctx, String companyid) throws BOSException, EASBizException {
        PaymentReqBillCreateService pbs = new PaymentReqBillCreateService(ctx);
        return pbs.createBillEntry(companyid);
    }

    @Override
    protected Map _getAccountF7(Context ctx, String companyID, String currencyID) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        EntityViewInfo companyEvi = new EntityViewInfo();
        FilterInfo comFilter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("baseCurrency.*"));
        sic.add(new SelectorItemInfo("accountTable.*"));
        companyEvi.setSelector(sic);
        companyEvi.setFilter(comFilter);
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID));
        CurrencyInfo baseCurrency = company.getBaseCurrency();
        if (company.getAccountTable() == null) {
            throw new AccountException(AccountException.CURRENTCOMPANYHASNOSTARTACCOUNTTABLE);
        }
        BOSUuid acctTableId = company.getAccountTable().getId();
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)company.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)acctTableId.toString()));
        filter.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)Boolean.FALSE));
        FilterInfo filterAcctCurrency = new FilterInfo();
        filterAcctCurrency.getFilterItems().add(new FilterItemInfo("accountingcurrency", (Object)new Integer(2)));
        filterAcctCurrency.getFilterItems().add(new FilterItemInfo("accountingcurrency", (Object)new Integer(1)));
        filterAcctCurrency.getFilterItems().add(new FilterItemInfo("id", (Object)("select FACCOUNTVIEWID from t_bd_accountcurrency where FCURRENCYID = '" + currencyID + "'"), CompareType.INNER));
        if (baseCurrency != null) {
            boolean isSameCurrency = baseCurrency.getId().toString().equals(currencyID);
            if (isSameCurrency) {
                filterAcctCurrency.getFilterItems().add(new FilterItemInfo("accountingcurrency", (Object)new Integer(0)));
                filterAcctCurrency.setMaskString("(#0) OR (#1 AND #2) OR (#3)");
            } else {
                filterAcctCurrency.setMaskString("(#0) OR (#1 AND #2) ");
            }
        } else {
            filterAcctCurrency.setMaskString("(#0) OR (#1 AND #2) ");
        }
        if (currencyID != null) {
            filter.mergeFilter(filterAcctCurrency, "AND");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accountTableID", acctTableId);
        map.put("filter", filter.toString());
        return map;
    }

    @Override
    protected IObjectPK _apiSave(Context ctx, PayRequestBillInfo billInfo) throws BOSException, EASBizException {
        billInfo.setBillStatus(BillStatusEnum.SAVE);
        if (billInfo.getCompany() == null) {
            throw new com.kingdee.eas.fi.ar.OtherBillBizException(com.kingdee.eas.fi.ar.OtherBillBizException.COMPANY_NOTSET);
        }
        String paySchedual = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(billInfo.getCompany().getId()), (String)"AP_PAY_SCHEDUAL");
        billInfo.setIsPaySchedule(Boolean.parseBoolean(paySchedual));
        billInfo.getEntrys().sort("seq");
        if (null != billInfo.getCompany()) {
            billInfo.setCU(billInfo.getCompany().getCU());
        }
        billInfo.setId(null);
        return PayRequestBillFactory.getLocalInstance(ctx).save((CoreBaseInfo)billInfo);
    }

    @Override
    protected List _queryRelatedApBills(Context ctx, String billId) throws BOSException, EASBizException {
        ArrayList<RelatedApOtherBillInfo> resultList = new ArrayList<RelatedApOtherBillInfo>();
        if (StringUtils.isEmpty((String)billId) || !BOSUuid.isValid((String)billId, (boolean)true)) {
            throw new OtherBillBizException(OtherBillBizException.SOURCE_AP_NOT_EXISTS);
        }
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        view.setFilter(filterInfo);
        filterInfo.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)billId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)"48DA3A71", CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)"D001019A", CompareType.EQUALS));
        BOTRelationCollection collection = iBOTRelation.getCollection(view);
        if (collection.isEmpty()) {
            throw new OtherBillBizException(OtherBillBizException.SOURCE_AP_NOT_EXISTS);
        }
        ArrayList<String> idList = new ArrayList<String>();
        for (int i = 0; i < collection.size(); ++i) {
            BOTRelationInfo relationInfo = collection.get(i);
            idList.add(relationInfo.getSrcObjectID());
        }
        String querySql = "select fid,fnumber,fcompanyid,finvoiceType,finvoiceNumber from t_ap_otherbill where fid in (" + CollectionUtil.ids2SqlString(idList) + ")";
        IRowSet iRowSet = DBUtil.executeQuery((Context)ctx, (String)querySql);
        try {
            while (iRowSet.next()) {
                RelatedApOtherBillInfo info = new RelatedApOtherBillInfo();
                info.setBillId(iRowSet.getString("fid"));
                info.setBillNumber(iRowSet.getString("fnumber"));
                info.setCompanyId(iRowSet.getString("fcompanyid"));
                info.setInvoiceType(PayInvoiceTypeEnum.getEnum((String)iRowSet.getString("finvoiceType")));
                info.setInvoiceNumber(iRowSet.getString("finvoiceNumber"));
                resultList.add(info);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (resultList.isEmpty()) {
            throw new OtherBillBizException(OtherBillBizException.SOURCE_AP_NOT_EXISTS);
        }
        return resultList;
    }
}

