/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupInfo;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.fi.ap.PayRequestBillCollection;
import com.kingdee.eas.fi.ap.PayRequestBillEntryInfo;
import com.kingdee.eas.fi.ap.PayRequestBillFactory;
import com.kingdee.eas.fi.ap.PayRequestBillInfo;
import com.kingdee.eas.fi.ap.app.PayRequestImportCache;
import com.kingdee.eas.fi.ap.app.util.PayReqCommmonServerUtil;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.ar.app.util.BaseDataUtil;
import com.kingdee.eas.fi.arap.app.ARAPImportHelper;
import com.kingdee.eas.fi.cas.FundFlowItemInfo;
import com.kingdee.eas.fi.cas.PaymentBillTypeInfo;
import com.kingdee.eas.fm.pp.SetFundPropertyInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class PayRequestBillImport
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ap.app.PayRequestBillImport");
    private FullOrgUnitCollection permissionOrgCol = null;
    private PayRequestBillInfo info;
    private PayRequestBillEntryInfo entry;
    private Map templateFieldMap;
    private boolean isCodingRule = false;
    private PayRequestImportCache cache = new PayRequestImportCache();
    private boolean isNeedClearBillCache = false;
    private Map<Integer, Integer> entrySeqMap = null;
    OrgType orgType = OrgType.Company;
    private static String msgResource = "com.kingdee.eas.fi.ar.ARImportData";

    protected boolean isSltImportUpdate() {
        return super.isSltImportUpdate();
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return PayRequestBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        Hashtable data = ARAPImportHelper.reverseTableValue(hsData);
        this.isCodingRule = this.cache.isCodingRuleByCache(ctx);
        if (this.templateFieldMap == null) {
            this.templateFieldMap = ARAPImportHelper.getTempleFieldNameMap(ctx, "PayRequestBillImport");
        }
        if (this.permissionOrgCol == null) {
            try {
                IPermission permission = PermissionFactory.getLocalInstance((Context)ctx);
                ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)this.orgType));
                this.permissionOrgCol = permission.getAuthorizedOrg(ctx.getCaller(), this.orgType, (IObjectPK)treePK, "PRBill_Addnew");
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
        }
        try {
            PayRequestBillInfo info = this.genPayRequestBill(ctx, data);
            info.put("entries", (Object)info.getEntrys());
            return info;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    public CoreBaseInfo transmit(Map hsData, Context ctx) throws TaskExternalException {
        ARAPImportHelper.beforeTransmit(hsData);
        return super.transmit(hsData, ctx);
    }

    protected PayRequestBillInfo genPayRequestBill(Context ctx, Hashtable data) throws TaskExternalException {
        boolean isUpdate = this.isSltImportUpdate();
        if (this.info == null || this.isNeedClearBillCache) {
            this.info = new PayRequestBillInfo();
            this.isNeedClearBillCache = false;
        } else {
            this.info.getEntrys().clear();
        }
        this.info.setId(null);
        this.info.setNumber(null);
        if (this.entry == null) {
            this.entry = new PayRequestBillEntryInfo();
        }
        Enumeration dataEnumeration = data.keys();
        while (dataEnumeration.hasMoreElements()) {
            Object key = dataEnumeration.nextElement();
            Hashtable hsData = (Hashtable)data.get(key);
            hsData.put("templateFieldMap", this.templateFieldMap);
            if (this.info.getNumber() == null) {
                this.genHead(ctx, hsData, this.info, isUpdate);
            }
            this.genEntry(ctx, hsData, this.entry, this.info);
        }
        if (null != this.info.getCompany()) {
            this.info.setCU(this.info.getCompany().getCU());
        }
        if (this.isCodingRule && (!isUpdate || isUpdate && this.info.getId() == null)) {
            try {
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                String cid = this.info.getCompany().getId().toString();
                if (!iCodingRuleManager.isExist((IObjectValue)this.info, cid)) {
                    throw new TaskExternalException(ResourceBase.getString((String)msgResource, (String)"CodingRule_Error", (Locale)ctx.getLocale()));
                }
                this.info.setNumber(iCodingRuleManager.getNumber((IObjectValue)this.info, cid, ""));
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
        }
        PayReqCommmonServerUtil.handleSumEntrys(this.info);
        return this.info;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            PayRequestBillInfo payRequestbillInfo = (PayRequestBillInfo)coreBaseInfo;
            payRequestbillInfo.getEntries().sort("seq");
            PayRequestBillFactory.getLocalInstance(ctx).save(coreBaseInfo);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    protected void genEntry(Context ctx, Hashtable hsData, PayRequestBillEntryInfo info, PayRequestBillInfo head) throws TaskExternalException {
        boolean isNewEntry = true;
        int seq = ARAPImportHelper.getDataInt(hsData, "FSeq");
        if (seq < 1) {
            throw new TaskExternalException(ResourceBase.getString((String)msgResource, (String)"ENTRY_SEQ_ERROR", (Locale)ctx.getLocale()));
        }
        if (this.entrySeqMap != null && this.entrySeqMap.size() > 0 && this.entrySeqMap.get(seq) != null) {
            info = head.getEntrys().get(this.entrySeqMap.get(seq));
            isNewEntry = false;
        } else {
            info.setId(null);
            info.setSeq(seq);
            info.setSumEntryID(null);
        }
        try {
            String payTypeNumber = ARAPImportHelper.getDataString(hsData, "FEntrys$payType_number");
            if (payTypeNumber == null || info.getPayType() == null || !payTypeNumber.equals(info.getPayType().getNumber())) {
                PaymentBillTypeInfo payType = this.cache.getPayTypeByCache(ctx, hsData, "FEntrys$payType_number");
                info.setPayType(payType);
            }
            AsstActTypeInfo asstActType = this.cache.getAsstActTypeByCache(ctx, hsData, "FEntrys$asstActType_number");
            info.setAsstActType(asstActType);
            String asstActNumber = ARAPImportHelper.getDataString(hsData, "FEntrys_asstActNumber");
            if (info.getAsstActType() == null) {
                info.setAsstActID(null);
                info.setAsstActName(asstActNumber);
                info.setAsstActNumber(asstActNumber);
            } else {
                Map rs = this.cache.getAsstActByCache(ctx, hsData, "FEntrys_asstActNumber", info.getAsstActType());
                info.setAsstActID((String)rs.get("id"));
                info.setAsstActName((String)rs.get("name"));
                info.setAsstActNumber((String)rs.get("number"));
            }
            BigDecimal reqAmt = ARAPImportHelper.getDataDeciaml(ctx, hsData, "FEntrys_reqPayAmount");
            reqAmt = reqAmt.setScale(head.getCurrency().getPrecision(), 4);
            if (!isNewEntry) {
                head.setRequestAmount(head.getRequestAmount().subtract(info.getReqPayAmount()));
                head.setAuditAmount(head.getRequestAmount().subtract(info.getReqPayAmount()));
            }
            info.setReqPayAmount(reqAmt);
            info.setAuditAmount(reqAmt);
            info.setTotalPayAmt(BigDecimal.ZERO);
            head.setRequestAmount(reqAmt.add(head.getRequestAmount() == null ? BigDecimal.ZERO : head.getRequestAmount()));
            head.setAuditAmount(reqAmt.add(head.getRequestAmount() == null ? BigDecimal.ZERO : head.getRequestAmount()));
            boolean isDirectExchangeRate = (Boolean)this.cache.getIsDirectExchangeRate().get(head.getCurrency().getNumber() + head.getCompany().getNumber());
            BigDecimal reqAmtLoc = BaseDataUtil.caculateLocalAmount(reqAmt, head.getExchange_rate(), isDirectExchangeRate, head.getCompany().getBaseCurrency().getPrecision());
            info.setAuditAmountLoc(reqAmtLoc);
            info.setAccountBankNo(ARAPImportHelper.getDataString(hsData, "FEntrys_accountBankNo"));
            info.setAccountBank(ARAPImportHelper.getDataString(hsData, "FEntrys_accountBank"));
            String balanceType = ARAPImportHelper.getDataString(hsData, "FEntrys$banlanceType_number");
            if (balanceType == null || info.getBanlanceType() == null || !balanceType.equals(info.getBanlanceType().getNumber())) {
                SettlementTypeInfo settlementType = this.cache.getSettlementTypeByCache(ctx, hsData, "FEntrys$banlanceType_number");
                info.setBanlanceType(settlementType);
            }
            String payBank = ARAPImportHelper.getDataString(hsData, "FEntrys$payBank_number");
            if (payBank == null || info.getPayBank() == null || !payBank.equals(info.getPayBank().getNumber())) {
                AccountBankInfo payBankInfo = this.cache.getAccountBankByCache(ctx, hsData, "FEntrys$payBank_number");
                info.setPayBank(payBankInfo);
            }
            String payBankAccount = ARAPImportHelper.getDataString(hsData, "FEntrys_payBankAccount");
            info.setPayBankAccount(payBankAccount);
            String account = ARAPImportHelper.getDataString(hsData, "FEntrys$account_number");
            if (account == null || info.getAccount() == null || !account.equals(info.getAccount().getNumber())) {
                AccountViewInfo accountInfo = this.cache.getAccountViewByCache(ctx, hsData, "FEntrys$account_number", head.getCompany().getId().toString());
                info.setAccount(accountInfo);
            }
            String materialNumber = ARAPImportHelper.getDataString(hsData, "FEntrys$materialNo_number");
            if (materialNumber == null || info.getMaterialNo() == null || !materialNumber.equals(info.getMaterialNo().getNumber())) {
                MaterialInfo material = this.cache.getMaterialByCache(ctx, hsData, "FEntrys$materialNo_number");
                info.setMaterialNo(material);
                if (material != null) {
                    info.setMaterialName(material == null ? null : material.getName());
                    info.setSpec(material.getModel());
                }
            }
            String expenseItemNumber = ARAPImportHelper.getDataString(hsData, "FEntrys$expenseItem_number");
            if (expenseItemNumber == null || info.getExpenseItem() == null || !expenseItemNumber.equals(info.getExpenseItem().getNumber())) {
                ExpenseTypeInfo expenseItem = this.cache.getExpenseItemByCache(ctx, hsData, "FEntrys$expenseItem_number");
                info.setExpenseItem(expenseItem);
                info.setExpenseItemName(expenseItem == null ? null : expenseItem.getName());
            }
            String remark = ARAPImportHelper.getDataString(hsData, "FEntrys_remark");
            info.setRemark(remark);
            String outBgItemNumber = ARAPImportHelper.getDataString(hsData, "FEntrys_outBgItemNumber");
            if (outBgItemNumber == null || !outBgItemNumber.equals(info.getOutBgItemNumber())) {
                Map outBgItem = this.cache.getOutBgItemByCache(ctx, hsData, "FEntrys_outBgItemNumber");
                info.setOutBgItem((String)outBgItem.get("fid"));
                info.setOutBgItemName((String)outBgItem.get("fName"));
                info.setOutBgItemNumber((String)outBgItem.get("fNumber"));
            }
            String fundFlowNumber = ARAPImportHelper.getDataString(hsData, "FEntrys$fundFlowItem_number");
            if (fundFlowNumber == null || info.getFundFlowItem() == null || !fundFlowNumber.equals(info.getFundFlowItem().getNumber())) {
                FundFlowItemInfo fundFlowItem = this.cache.getFundFlowItemByCache(ctx, hsData, "FEntrys$fundFlowItem_number");
                info.setFundFlowItem(fundFlowItem);
            }
            String fundPropertyNumber = ARAPImportHelper.getDataString(hsData, "FEntrys$fundProperty_number");
            if (fundPropertyNumber == null || info.getFundPropertyNew() == null || !fundPropertyNumber.equals(info.getFundPropertyNew().getNumber())) {
                SetFundPropertyInfo fundProperty = this.cache.getFundPropertyByCache(ctx, hsData, "FEntrys$fundProperty_number");
                info.setFundPropertyNew(fundProperty);
            }
            info.setPayDay(head.getBizDate());
            info.setPayableDate(head.getBizDate());
            info.setUnLockAmount(info.getAuditAmount());
            info.setUnLockAmountLoc(info.getAuditAmountLoc());
            info.setUnpayAmount(info.getReqPayAmount());
            this.checkBillEntry(ctx, info, head, hsData);
            if (isNewEntry) {
                head.getEntrys().add((PayRequestBillEntryInfo)info.clone());
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(ResourceBase.getString((String)msgResource, (String)"ENTRY_SEQ", (Locale)ctx.getLocale()) + info.getSeq() + e.getMessage(), e.getCause());
        }
    }

    private void checkBillEntry(Context ctx, PayRequestBillEntryInfo info, PayRequestBillInfo head, Hashtable hsData) throws TaskExternalException {
        if (info.getReqPayAmount() == null || info.getReqPayAmount().compareTo(BigDecimal.ZERO) == 0) {
            throw new TaskExternalException(ResourceBase.getString((String)msgResource, (String)"REQ_AMOUNT_CANNOT_NULL", (Locale)ctx.getLocale()));
        }
        if (info.getPayType() == null) {
            throw new TaskExternalException(ResourceBase.getString((String)msgResource, (String)"PaymentType_Is_Null", (Locale)ctx.getLocale()));
        }
        if (info.getAsstActType() == null && !"NLGLdwEREADgAAIGwKgSRj6TKVs=".equals(info.getPayType().getId().toString())) {
            throw new TaskExternalException(ResourceBase.getString((String)msgResource, (String)"AsstActTypeID_Null", (Locale)ctx.getLocale()));
        }
        if (info.getAsstActNumber() == null && ARAPImportHelper.getDataString(hsData, "FEntrys_asstActNumber") == null) {
            ARAPImportHelper.throwFieldNullMsg(ctx, hsData, "FEntrys_asstActNumber");
        } else if (info.getAsstActType() != null && info.getAsstActID() == null) {
            ARAPImportHelper.throwFieldErrorMsg(ctx, hsData, "FEntrys_asstActNumber");
        }
        if (info.getAccount() != null && !info.getAccount().isIsLeaf()) {
            throw new TaskExternalException(ResourceBase.getString((String)msgResource, (String)"ACCOUNT_IS_NOT_LEAF", (Locale)ctx.getLocale()));
        }
        try {
            if (info.getAsstActID() != null && info.getAsstActType() != null) {
                ARAPImportHelper.isExistAsstActByCompany(ctx, head.getCompany(), info.getAsstActType(), info.getAsstActID());
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    protected void genHead(Context ctx, Hashtable hsData, PayRequestBillInfo info, boolean isUpdate) throws TaskExternalException {
        try {
            CompanyOrgUnitInfo company;
            String paySchedual = "";
            String companyData = ARAPImportHelper.getDataString(hsData, "FCompany_number");
            if (info.getCompany() != null && info.getCompany().getNumber().equals(companyData)) {
                company = info.getCompany();
            } else {
                company = this.cache.getCompanyByCache(ctx, hsData, "FCompany_number");
                paySchedual = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(company.getId()), (String)"AP_PAY_SCHEDUAL");
                info.setIsPaySchedule(Boolean.parseBoolean(paySchedual));
            }
            if (this.permissionOrgCol.get((Object)company.getId()) == null) {
                throw new TaskExternalException(ResourceBase.getString((String)msgResource, (String)"MULTIORGIMPORT", (Locale)ctx.getLocale(), (Object[])new String[]{company.getName()}));
            }
            String number = ARAPImportHelper.getDataString(hsData, "FNumber");
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filters = new FilterInfo();
            filters.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
            filters.getFilterItems().add(new FilterItemInfo("company.number", (Object)company.getNumber(), CompareType.EQUALS));
            ev.setFilter(filters);
            PayRequestBillCollection existedBill = PayRequestBillFactory.getLocalInstance(ctx).getPayRequestBillCollection(ev);
            if (existedBill.size() > 0) {
                if (!isUpdate && !this.isCodingRule) {
                    throw new TaskExternalException(ResourceBase.getString((String)msgResource, (String)"FBillNumber_IsExist", (Locale)ctx.getLocale()));
                }
                if (isUpdate) {
                    info = existedBill.get(0);
                    this.entrySeqMap = new HashMap<Integer, Integer>();
                    for (int i = 0; i < info.getEntrys().size(); ++i) {
                        this.entrySeqMap.put(info.getEntrys().get(i).getSeq(), i);
                    }
                    this.isNeedClearBillCache = true;
                    if (info.getEntrys().get(0).getSourceBillEntryId() != null) {
                        throw new TaskExternalException(ResourceBase.getString((String)msgResource, (String)"CANNOT_OVER_IMPORT", (Locale)ctx.getLocale()));
                    }
                    if (!info.getBillStatus().equals((Object)BillStatusEnum.SAVE)) {
                        throw new TaskExternalException(ResourceBase.getString((String)msgResource, (String)"BillStatusSave", (Locale)ctx.getLocale()));
                    }
                }
            } else {
                this.entrySeqMap = null;
            }
            info.setBillStatus(BillStatusEnum.SAVE);
            info.setNumber(number);
            info.setCompany(company);
            String CUId = company.getCU().getId().toString();
            Date bizDate = ARAPImportHelper.getDataDate(ctx, hsData, "FBizDate");
            info.setBizDate(bizDate);
            PurchaseOrgUnitInfo purChase = this.cache.getPurchaseOrgByCache(ctx, hsData, "FPurOrgCompany_number", CUId);
            info.setPurOrgCompany(purChase);
            PurchaseGroupInfo purchaseGroup = this.cache.getPurchaseGroupByCache(ctx, hsData, "FPurOrgGroup_number", CUId);
            info.setPurOrgGroup(purchaseGroup);
            String currencyData = ARAPImportHelper.getDataString(hsData, "FCurrency_number");
            if (currencyData == null || info.getCurrency() == null || !currencyData.equals(info.getCurrency().getNumber())) {
                CurrencyInfo currency = this.cache.getCurrencyByCache(ctx, hsData, "FCurrency_number", company);
                info.setCurrency(currency);
            }
            BigDecimal exchangeRate = ARAPImportHelper.getDataDeciaml(ctx, hsData, "FExchange_rate");
            ExchangeRateInfo rateInfo = BaseDataUtil.getExchangeRate(ctx, info.getCompany(), info.getCurrency(), new Date());
            if (info.getCurrency().equals((Object)info.getCompany().getBaseCurrency())) {
                info.setExchange_rate(BigDecimal.ONE);
            } else if (rateInfo != null) {
                info.setExchange_rate(exchangeRate.setScale(rateInfo.getPrecision(), RoundingMode.HALF_UP));
            } else {
                info.setExchange_rate(exchangeRate);
            }
            AdminOrgUnitInfo department = this.cache.getAdminOrgUnitByCache(ctx, hsData, "FDepartment_number", CUId);
            info.setDepartment(department);
            PersonInfo applier = this.cache.getApplierByCache(ctx, hsData, "FApplyer_number", CUId);
            info.setApplyer(applier);
            CostCenterOrgUnitInfo costCenter = this.cache.getCostCenterByCache(ctx, hsData, "FCostCenter_number", CUId);
            info.setCostCenter(costCenter);
            String reason = ARAPImportHelper.getDataString(hsData, "FRequestReason");
            info.setRequestReason(reason);
            this.checkBillHead(ctx, info);
            info.setIsImportBill(true);
            this.info = info;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    public int getSubmitType() {
        return 1;
    }

    private void checkBillHead(Context ctx, PayRequestBillInfo info) throws TaskExternalException {
        if (info.getNumber() == null) {
            throw new TaskExternalException(ResourceBase.getString((String)msgResource, (String)"BILL_NUMBER_IS_NULL", (Locale)ctx.getLocale()));
        }
        if (info.getBizDate() == null) {
            throw new TaskExternalException(ResourceBase.getString((String)msgResource, (String)"DateIsNull", (Locale)ctx.getLocale()));
        }
        if (info.getExchange_rate() == null || info.getExchange_rate().compareTo(BigDecimal.ZERO) == 0) {
            throw new TaskExternalException(ResourceBase.getString((String)msgResource, (String)"FExchangeRate_IsNull", (Locale)ctx.getLocale()));
        }
        if (info.getApplyer() == null) {
            throw new TaskExternalException(ResourceBase.getString((String)msgResource, (String)"APPLIER_IS_NULL", (Locale)ctx.getLocale()));
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = null;
        try {
            result = new Hashtable();
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FCompany_number", rs.getString("COMPANY.NUMBER"));
            this.putTable(result, "FBizDate", rs.getString("bizDate"));
            this.putTable(result, "FPurOrgCompany_number", rs.getString("PURORGCOMPANY.NUMBER"));
            this.putTable(result, "FPurOrgGroup_number", rs.getString("PURORGGROUP.NUMBER"));
            this.putTable(result, "FCurrency_number", rs.getString("CURRENCY.NUMBER"));
            this.putTable(result, "FExchange_rate", rs.getString("EXCHANGE_RATE"));
            this.putTable(result, "FDepartment_number", rs.getString("DEPARTMENT.NUMBER"));
            this.putTable(result, "FApplyer_number", rs.getString("APPLYER.NUMBER"));
            this.putTable(result, "FCostCenter_number", rs.getString("COSTCENTER.NUMBER"));
            this.putTable(result, "FRequestReason", rs.getString("REQUESTREASON"));
            this.putTable(result, "FSeq", rs.getString("ENTRYS.SEQ"));
            this.putTable(result, "FEntrys$payType_number", rs.getString("ENTRYS_PAYTYPE.NUMBER"));
            this.putTable(result, "FEntrys$asstActType_number", rs.getString("ASSTACTTYPE.NUMBER"));
            this.putTable(result, "FEntrys_asstActNumber", rs.getString("ENTRYS.ASSTACTNUMBER"));
            this.putTable(result, "FEntrys_reqPayAmount", rs.getString("ENTRYS.REQPAYAMOUNT"));
            this.putTable(result, "FEntrys_accountBankNo", rs.getString("ENTRYS.ACCOUNTBANKNO"));
            this.putTable(result, "FEntrys_accountBank", rs.getString("ENTRYS.ACCOUNTBANK"));
            this.putTable(result, "FEntrys$banlanceType_number", rs.getString("ENTRYS_BANLANCETYPE.NUMBER"));
            this.putTable(result, "FEntrys$payBank_number", rs.getString("ENTRYS_PAYBANK.NUMBER"));
            this.putTable(result, "FEntrys_payBankAccount", rs.getString("ENTRYS.PAYBANKACCOUNT"));
            this.putTable(result, "FEntrys$account_number", rs.getString("ACCOUNT.NUMBER"));
            this.putTable(result, "FEntrys$materialNo_number", rs.getString("ENTRYS.MATERIALNO.NUMBER"));
            this.putTable(result, "FEntrys$expenseItem_number", rs.getString("EXPENSEITEM.NUMBER"));
            this.putTable(result, "FEntrys_remark", rs.getString("ENTRYS.REMARK"));
            this.putTable(result, "FEntrys_outBgItemNumber", rs.getString("ENTRYS.OUTBGITEMNUMBER"));
            this.putTable(result, "FEntrys$fundFlowItem_number", rs.getString("FUNDFLOWITEM.NUMBER"));
            this.putTable(result, "FEntrys$fundProperty_number", rs.getString("FUNDPROPERTYNEW.NUMBER"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        return result;
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.ap.app.PayRequestBillQuery";
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = new FilterInfo();
        String filterStr = null;
        if (this.getContextMap().get("filterItems") != null) {
            filterStr = this.getContextMap().get("filterItems").toString();
        }
        if (this.getContextMap().get("bizCommonQueryFilter") != null) {
            filterStr = this.getContextMap().get("bizCommonQueryFilter").toString();
        }
        if (!StringUtils.isEmpty((String)filterStr)) {
            filterStr = filterStr.replace("$", "'");
            try {
                filter = new FilterInfo(filterStr);
            }
            catch (ParserException e) {
                logger.error((Object)e.getMessage());
            }
        }
        return filter;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        boolean rs = false;
        if (firstData != null && currentData != null) {
            String firstMainField = StringUtil.cnulls(firstData.get("FNumber")) + StringUtil.cnulls(firstData.get("FCompany_number"));
            String currentMainField = StringUtil.cnulls(currentData.get("FNumber")) + StringUtil.cnulls(currentData.get("FCompany_number"));
            if (firstMainField.isEmpty() && currentMainField.isEmpty()) {
                rs = false;
            } else if (firstMainField.equals(currentMainField)) {
                rs = true;
            }
        }
        return rs;
    }
}

