/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.app;

import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupInfo;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.fi.ar.app.util.BaseDataUtil;
import com.kingdee.eas.fi.arap.app.ARAPImportHelper;
import com.kingdee.eas.fi.cas.FundFlowItemInfo;
import com.kingdee.eas.fi.cas.PaymentBillTypeInfo;
import com.kingdee.eas.fm.pp.SetFundPropertyInfo;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.sql.RowSet;

public class PayRequestImportCache {
    private Map companyCache = new HashMap(10);
    private Map purchaseCache = new HashMap(10);
    private Map purchaseGroupCache = new HashMap(10);
    private Map currencyCache = new HashMap(10);
    private Map departmentCache = new HashMap(10);
    private Map applierCache = new HashMap(10);
    private Map costCenterCache = new HashMap(10);
    private Map payTypeCache = new HashMap(10);
    private Map asstActTypeCache = new HashMap(10);
    private Map asstActCache = new HashMap(10);
    private Map accountBankCache = new HashMap(10);
    private Map settlementTypeCache = new HashMap(10);
    private Map accountCache = new HashMap(10);
    private Map materialCache = new HashMap(10);
    private Map expenseItemCache = new HashMap(10);
    private Map outBgItemCache = new HashMap(10);
    private Map fundFlowItemCache = new HashMap(10);
    private Map fundPropertyCache = new HashMap(10);
    private Map isCodingRuleCache = new HashMap(1);
    private Map isDirectExchangeRateCache = new HashMap(10);

    public CompanyOrgUnitInfo getCompanyByCache(Context ctx, Hashtable hsData, String field) throws TaskExternalException {
        String companyNumber = ARAPImportHelper.getDataString(hsData, field);
        CompanyOrgUnitInfo info = null;
        if (this.companyCache.get(companyNumber) != null) {
            return (CompanyOrgUnitInfo)this.companyCache.get(companyNumber);
        }
        try {
            info = ARAPImportHelper.getCompany(ctx, hsData, field);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        this.companyCache.put(companyNumber, info);
        return info;
    }

    public PurchaseOrgUnitInfo getPurchaseOrgByCache(Context ctx, Hashtable hsData, String field, String CUId) throws TaskExternalException {
        String purchaseNumber = ARAPImportHelper.getDataString(hsData, field);
        PurchaseOrgUnitInfo info = null;
        if (this.purchaseCache.get(purchaseNumber + CUId) != null) {
            return (PurchaseOrgUnitInfo)this.purchaseCache.get(purchaseNumber + CUId);
        }
        try {
            info = ARAPImportHelper.getPurchaseOrg(ctx, hsData, field, CUId);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        this.purchaseCache.put(purchaseNumber + CUId, info);
        return info;
    }

    public PurchaseGroupInfo getPurchaseGroupByCache(Context ctx, Hashtable hsData, String field, String CUId) throws TaskExternalException {
        String purchaseGroupNumber = ARAPImportHelper.getDataString(hsData, field);
        PurchaseGroupInfo info = null;
        if (this.purchaseGroupCache.get(purchaseGroupNumber + CUId) != null) {
            return (PurchaseGroupInfo)this.purchaseGroupCache.get(purchaseGroupNumber + CUId);
        }
        try {
            info = ARAPImportHelper.getPurchaseGroupInfo(ctx, hsData, field, CUId);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        this.purchaseGroupCache.put(purchaseGroupNumber + CUId, info);
        return info;
    }

    public CurrencyInfo getCurrencyByCache(Context ctx, Hashtable hsData, String field, CompanyOrgUnitInfo company) throws TaskExternalException {
        boolean isDirectExchangeRate;
        String currencyNumber = ARAPImportHelper.getDataString(hsData, field);
        CurrencyInfo info = null;
        if (this.currencyCache.get(currencyNumber) != null) {
            return (CurrencyInfo)this.currencyCache.get(currencyNumber);
        }
        try {
            info = ARAPImportHelper.getCurrencyInfo(ctx, hsData, field);
            isDirectExchangeRate = BaseDataUtil.isDirectExchangeRate(BaseDataUtil.getExchangeRate(ctx, company, info, new Date()));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        this.currencyCache.put(currencyNumber, info);
        this.isDirectExchangeRateCache.put(currencyNumber + company.getNumber(), isDirectExchangeRate);
        return info;
    }

    public AdminOrgUnitInfo getAdminOrgUnitByCache(Context ctx, Hashtable hsData, String field, String CUId) throws TaskExternalException {
        String departmentNumber = ARAPImportHelper.getDataString(hsData, field);
        AdminOrgUnitInfo info = null;
        if (this.departmentCache.get(departmentNumber + CUId) != null) {
            return (AdminOrgUnitInfo)this.departmentCache.get(departmentNumber + CUId);
        }
        try {
            info = ARAPImportHelper.getAdminOrgUnitInfo(ctx, hsData, field, CUId);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        this.departmentCache.put(departmentNumber + CUId, info);
        return info;
    }

    public PersonInfo getApplierByCache(Context ctx, Hashtable hsData, String field, String CUId) throws TaskExternalException {
        String applierNumber = ARAPImportHelper.getDataString(hsData, field);
        PersonInfo info = null;
        if (this.applierCache.get(applierNumber + CUId) != null) {
            return (PersonInfo)this.applierCache.get(applierNumber + CUId);
        }
        try {
            info = ARAPImportHelper.getPersonInfo(ctx, hsData, field, CUId);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        this.applierCache.put(applierNumber + CUId, info);
        return info;
    }

    public CostCenterOrgUnitInfo getCostCenterByCache(Context ctx, Hashtable hsData, String field, String CUId) throws TaskExternalException {
        String costCenterNumber = ARAPImportHelper.getDataString(hsData, field);
        CostCenterOrgUnitInfo info = null;
        if (this.costCenterCache.get(costCenterNumber + CUId) != null) {
            return (CostCenterOrgUnitInfo)this.costCenterCache.get(costCenterNumber + CUId);
        }
        try {
            info = ARAPImportHelper.getDataCostCenter(ctx, hsData, field, CUId);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        this.costCenterCache.put(costCenterNumber + CUId, info);
        return info;
    }

    public PaymentBillTypeInfo getPayTypeByCache(Context ctx, Hashtable hsData, String field) throws TaskExternalException {
        String payTypeNumber = ARAPImportHelper.getDataString(hsData, field);
        PaymentBillTypeInfo info = null;
        if (this.payTypeCache.get(payTypeNumber) != null) {
            return (PaymentBillTypeInfo)this.payTypeCache.get(payTypeNumber);
        }
        try {
            info = ARAPImportHelper.getPaymentBillType(ctx, hsData, field);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        this.payTypeCache.put(payTypeNumber, info);
        return info;
    }

    public AsstActTypeInfo getAsstActTypeByCache(Context ctx, Hashtable hsData, String field) throws TaskExternalException {
        String asstActTypeNumber = ARAPImportHelper.getDataString(hsData, field);
        AsstActTypeInfo info = null;
        if (this.asstActTypeCache.get(asstActTypeNumber) != null) {
            return (AsstActTypeInfo)this.asstActTypeCache.get(asstActTypeNumber);
        }
        try {
            info = ARAPImportHelper.getAsstActTypeWithNull(ctx, hsData, field);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        this.asstActTypeCache.put(asstActTypeNumber, info);
        return info;
    }

    public Map getAsstActByCache(Context ctx, Hashtable hsData, String field, AsstActTypeInfo asstActTypeInfo) throws TaskExternalException {
        String asstActNumber = ARAPImportHelper.getDataString(hsData, field);
        String key = asstActNumber + asstActTypeInfo.getRealtionDataObject() + (asstActTypeInfo.getGlAsstActTypeGrp() == null ? "" : asstActTypeInfo.getGlAsstActTypeGrp().getId().toString());
        HashMap<String, String> info = new HashMap<String, String>();
        RowSet rs = null;
        if (this.asstActCache.get(key) != null) {
            return (Map)this.asstActCache.get(key);
        }
        try {
            rs = ARAPImportHelper.getAsstActInfo(ctx, asstActNumber, asstActTypeInfo);
            if (rs == null) {
                return info;
            }
            while (rs.next()) {
                info.put("id", rs.getString("fid"));
                info.put("name", rs.getString("fname"));
                info.put("number", rs.getString("fnumber"));
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        this.asstActCache.put(key, info);
        return info;
    }

    public AccountBankInfo getAccountBankByCache(Context ctx, Hashtable hsData, String field) throws TaskExternalException {
        String accountBankNumber = ARAPImportHelper.getDataString(hsData, field);
        AccountBankInfo info = null;
        if (this.accountBankCache.get(accountBankNumber) != null) {
            return (AccountBankInfo)this.accountBankCache.get(accountBankNumber);
        }
        try {
            info = ARAPImportHelper.getDataAccountBank(ctx, hsData, field);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        this.accountBankCache.put(accountBankNumber, info);
        return info;
    }

    public SettlementTypeInfo getSettlementTypeByCache(Context ctx, Hashtable hsData, String field) throws TaskExternalException {
        String settlementTypeNumber = ARAPImportHelper.getDataString(hsData, field);
        SettlementTypeInfo info = null;
        if (this.settlementTypeCache.get(settlementTypeNumber) != null) {
            return (SettlementTypeInfo)this.settlementTypeCache.get(settlementTypeNumber);
        }
        try {
            info = ARAPImportHelper.getSettlementTypeInfo(ctx, hsData, field);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        this.settlementTypeCache.put(settlementTypeNumber, info);
        return info;
    }

    public AccountViewInfo getAccountViewByCache(Context ctx, Hashtable hsData, String field, String companyId) throws TaskExternalException {
        String accountViewNumber = ARAPImportHelper.getDataString(hsData, field);
        AccountViewInfo info = null;
        if (this.accountCache.get(accountViewNumber) != null) {
            return (AccountViewInfo)this.accountCache.get(accountViewNumber);
        }
        try {
            info = ARAPImportHelper.getAccountViewInfo(ctx, hsData, field, companyId);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        this.accountCache.put(accountViewNumber, info);
        return info;
    }

    public MaterialInfo getMaterialByCache(Context ctx, Hashtable hsData, String field) throws TaskExternalException {
        String materialNumber = ARAPImportHelper.getDataString(hsData, field);
        MaterialInfo info = null;
        if (this.materialCache.get(materialNumber) != null) {
            return (MaterialInfo)this.materialCache.get(materialNumber);
        }
        try {
            info = ARAPImportHelper.getMaterialInfo(ctx, hsData, field);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        this.materialCache.put(materialNumber, info);
        return info;
    }

    public ExpenseTypeInfo getExpenseItemByCache(Context ctx, Hashtable hsData, String field) throws TaskExternalException {
        String expenseItemNumber = ARAPImportHelper.getDataString(hsData, field);
        ExpenseTypeInfo info = null;
        if (this.expenseItemCache.get(expenseItemNumber) != null) {
            return (ExpenseTypeInfo)this.expenseItemCache.get(expenseItemNumber);
        }
        try {
            info = ARAPImportHelper.getExpenseItemInfo(ctx, hsData, field);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        this.expenseItemCache.put(expenseItemNumber, info);
        return info;
    }

    public Map getOutBgItemByCache(Context ctx, Hashtable hsData, String field) throws TaskExternalException {
        String outBgItemNumber = ARAPImportHelper.getDataString(hsData, field);
        Map info = null;
        if (this.outBgItemCache.get(outBgItemNumber) != null) {
            return (Map)this.outBgItemCache.get(outBgItemNumber);
        }
        try {
            info = ARAPImportHelper.getDataVisualItem(ctx, hsData, field);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        this.outBgItemCache.put(outBgItemNumber, info);
        return info;
    }

    public FundFlowItemInfo getFundFlowItemByCache(Context ctx, Hashtable hsData, String field) throws TaskExternalException {
        String fundFlowItemNumber = ARAPImportHelper.getDataString(hsData, field);
        FundFlowItemInfo info = null;
        if (this.fundFlowItemCache.get(fundFlowItemNumber) != null) {
            return (FundFlowItemInfo)this.fundFlowItemCache.get(fundFlowItemNumber);
        }
        try {
            info = ARAPImportHelper.getDataFundFlowItem(ctx, hsData, field);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        this.fundFlowItemCache.put(fundFlowItemNumber, info);
        return info;
    }

    public SetFundPropertyInfo getFundPropertyByCache(Context ctx, Hashtable hsData, String field) throws TaskExternalException {
        String fundPropertyNumber = ARAPImportHelper.getDataString(hsData, field);
        SetFundPropertyInfo info = null;
        if (this.fundPropertyCache.get(fundPropertyNumber) != null) {
            return (SetFundPropertyInfo)this.fundPropertyCache.get(fundPropertyNumber);
        }
        try {
            info = ARAPImportHelper.getDataFundProperty(ctx, hsData, field);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        this.fundPropertyCache.put(fundPropertyNumber, info);
        return info;
    }

    public boolean isCodingRuleByCache(Context ctx) throws TaskExternalException {
        boolean isCodingRule = false;
        if (this.isCodingRuleCache.get("flag") != null) {
            return (Boolean)this.fundPropertyCache.get("flag");
        }
        try {
            isCodingRule = ARAPImportHelper.getImportParam(ctx);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        this.fundPropertyCache.put("flag", isCodingRule);
        return isCodingRule;
    }

    public Map getIsDirectExchangeRate() {
        return this.isDirectExchangeRateCache;
    }
}

