/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.ISettlementList;
import com.kingdee.eas.fi.ap.OtherBillPlanInfo;
import com.kingdee.eas.fi.ap.SettlementListFactory;
import com.kingdee.eas.fi.ap.SettlementListInfo;
import com.kingdee.eas.fi.ap.app.AbstractSettlementListControllerBean;
import com.kingdee.eas.fi.ar.OtherBillentryInfo;
import com.kingdee.eas.fi.arap.app.WriteBackOtherBill;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SettlementListControllerBean
extends AbstractSettlementListControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ap.app.SettlementListControllerBean");
    public static final String CR = "\r\n";

    @Override
    protected void _createRelationship(Context ctx, String[] billIDs) throws BOSException, EASBizException {
        long begin = System.currentTimeMillis();
        ISettlementList iSettle = SettlementListFactory.getLocalInstance(ctx);
        Map entryMap = this.getEntryData(ctx, billIDs);
        Map planMap = this.getPlanData(ctx, billIDs);
        CoreBaseCollection settlementInfoListAll_addnew = new CoreBaseCollection();
        CoreBaseCollection settlementInfoListAll_update = new CoreBaseCollection();
        for (String billId : billIDs) {
            List payDateAndCustomArr = (List)planMap.get(billId);
            List apBillEntryList = (List)entryMap.get(billId);
            CoreBaseCollection lockCol = iSettle.getCollection("where billId='" + billId + "' order by payableDate asc");
            CoreBaseCollection settlementInfoList_addnew = new CoreBaseCollection();
            HashMap<String, SettlementListInfo> splitedEntryMap = new HashMap<String, SettlementListInfo>();
            int size_list = apBillEntryList.size();
            for (int j = 0; j < size_list; ++j) {
                OtherBillentryInfo entry = (OtherBillentryInfo)apBillEntryList.get(j);
                if (payDateAndCustomArr.size() <= 0) continue;
                this.splitEntryByPayPlan(settlementInfoList_addnew, billId, entry, payDateAndCustomArr);
                SettlementListInfo lastSettle = (SettlementListInfo)settlementInfoList_addnew.get(settlementInfoList_addnew.size() - 1);
                if (lastSettle.isIsSplited()) continue;
                splitedEntryMap.put(entry.getId().toString(), lastSettle);
            }
            if (lockCol.size() > 0) {
                this.appendLockSettle(settlementInfoList_addnew, lockCol, splitedEntryMap);
                settlementInfoListAll_update.addCollection(lockCol);
            }
            settlementInfoListAll_addnew.addCollection(settlementInfoList_addnew);
        }
        this.addnew(ctx, settlementInfoListAll_addnew);
        if (settlementInfoListAll_update.size() > 0) {
            this.update(ctx, settlementInfoListAll_update);
        }
        logger.info((Object)("createRelationship cost: " + (System.currentTimeMillis() - begin) + "ms" + CR));
    }

    @Override
    protected void _deleteRelationship(Context ctx, String[] billIds) throws BOSException, EASBizException {
        String sql = "delete from T_AP_SettlementList where fBillId in (" + this.getBillIdOql(billIds) + ") and fLockAmount = 0";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    @Override
    protected void _createDetail(Context ctx, int settlementType, int billType, String[] billIds) throws BOSException, EASBizException {
        String ids = this.getBillIdOql(billIds);
        this.createDetail(ctx, settlementType, billType, ids);
    }

    @Override
    protected void _deleteDetail(Context ctx, String[] billIds) throws BOSException, EASBizException {
        String ids = this.getBillIdOql(billIds);
        this.deleteDetail(ctx, ids);
    }

    private Map getEntryData(Context ctx, String[] billIds) throws BOSException {
        StringBuffer buf = new StringBuffer();
        buf.append("select fParentId, fid, fRecievePayAmount, fRecievePayAmountLocal, ").append("fLockVerifyAmt, fLockVerifyAmtLocal, fLockUnVerifyAmt, fLockUnVerifyAmtLocal ").append("from T_AP_OtherBillentry where fParentId in (").append(this.getBillIdOql(billIds)).append(") order by fseq asc");
        HashMap entryMap = new HashMap();
        List<OtherBillentryInfo> entries = null;
        OtherBillentryInfo entry = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buf.toString());
            String billId = "";
            while (rs.next()) {
                billId = rs.getString("fParentId");
                if (entryMap.containsKey(billId)) {
                    entries = (List)entryMap.get(billId);
                } else {
                    entries = new ArrayList();
                    entryMap.put(billId, entries);
                }
                entry = new OtherBillentryInfo();
                entry.setId(BOSUuid.read((String)rs.getString("fid")));
                entry.setRecievePayAmount(rs.getBigDecimal("fRecievePayAmount"));
                entry.setRecievePayAmountLocal(rs.getBigDecimal("fRecievePayAmountLocal"));
                entry.setLockVerifyAmt(rs.getBigDecimal("fLockVerifyAmt"));
                entry.setLockVerifyAmtLocal(rs.getBigDecimal("fLockVerifyAmtLocal"));
                entry.setLockUnVerifyAmt(rs.getBigDecimal("fLockUnVerifyAmt"));
                entry.setLockUnVerifyAmtLocal(rs.getBigDecimal("fLockUnVerifyAmtLocal"));
                entries.add(entry);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return entryMap;
    }

    private Map getPlanData(Context ctx, String[] billIds) throws BOSException {
        StringBuffer buf = new StringBuffer();
        buf.append("select fid, fParentId, fRecievePayDate, fRecievePayAmount, fRecievePayAmountLocal, ").append("fLockAmount, fLockAmountLoc from T_AP_OtherBillPlan where fParentId in (").append(this.getBillIdOql(billIds)).append(") order by fRecievePayDate asc");
        HashMap planMap = new HashMap();
        List<OtherBillPlanInfo> entries = null;
        OtherBillPlanInfo entry = null;
        String billId = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buf.toString());
            while (rs.next()) {
                billId = rs.getString("fParentId");
                if (planMap.containsKey(billId)) {
                    entries = (List)planMap.get(billId);
                } else {
                    entries = new ArrayList();
                    planMap.put(billId, entries);
                }
                entry = new OtherBillPlanInfo();
                entry.setId(BOSUuid.read((String)rs.getString("fid")));
                entry.setRecievePayDate(rs.getDate("fRecievePayDate"));
                entry.setRecievePayAmount(rs.getBigDecimal("fRecievePayAmount"));
                entry.setRecievePayAmountLocal(rs.getBigDecimal("fRecievePayAmountLocal"));
                entry.setLockAmount(rs.getBigDecimal("fLockAmount"));
                entry.setLockAmountLoc(rs.getBigDecimal("fLockAmountLoc"));
                entries.add(entry);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return planMap;
    }

    private String getBillIdOql(String[] billIds) {
        StringBuffer buf = new StringBuffer();
        int len = billIds.length;
        for (int k = 0; k < len; ++k) {
            buf.append("'").append(billIds[k]).append("',");
        }
        if (buf.length() > 0) {
            return buf.substring(0, buf.length() - 1);
        }
        return null;
    }

    private void splitEntryByPayPlan(CoreBaseCollection splitResultList, String billId, OtherBillentryInfo entry, List payDateAndCustomArr) {
        OtherBillPlanInfo plan = null;
        SettlementListInfo splitResult = null;
        boolean isSplited = false;
        boolean isFinish = false;
        while (payDateAndCustomArr.size() > 0) {
            plan = (OtherBillPlanInfo)payDateAndCustomArr.get(0);
            Date payableDate = plan.getRecievePayDate();
            splitResult = new SettlementListInfo();
            splitResult.setBillId(billId);
            splitResult.setEntryId(entry.getId().toString());
            splitResult.setIsSplited(isSplited);
            splitResult.setSettlementAmount(BigDecimal.ZERO);
            splitResult.setSettlementAmountLoc(BigDecimal.ZERO);
            splitResult.setSeq(splitResultList.size() + 1);
            splitResult.setPayableDate(payableDate);
            splitResult.setPlanId(plan.getId().toString());
            BigDecimal amt = entry.getRecievePayAmount();
            BigDecimal amtLoc = entry.getRecievePayAmountLocal();
            BigDecimal planAmt = plan.getRecievePayAmount();
            BigDecimal planAmtLoc = plan.getRecievePayAmountLocal();
            BigDecimal unlockAmt = amt.subtract(entry.getLockVerifyAmt());
            BigDecimal unlockAmtLoc = amtLoc.subtract(entry.getLockVerifyAmtLocal());
            BigDecimal planUnlockAmount = planAmt.subtract(plan.getLockAmount());
            BigDecimal planUnlockAmountLoc = planAmtLoc.subtract(plan.getLockAmountLoc());
            isFinish = unlockAmt.abs().compareTo(planUnlockAmount.abs()) <= 0;
            if (isFinish) {
                if (planUnlockAmount.compareTo(BigDecimal.ZERO) <= 0) {
                    payDateAndCustomArr.remove(0);
                } else {
                    planAmt = planAmt.subtract(unlockAmt);
                    planAmtLoc = planAmtLoc.subtract(unlockAmtLoc);
                    plan.setRecievePayAmount(planAmt);
                    plan.setRecievePayAmountLocal(planAmtLoc);
                }
            } else {
                payDateAndCustomArr.remove(0);
                if (!isSplited) {
                    isSplited = true;
                    splitResult.setIsSplited(isSplited);
                }
                unlockAmt = planUnlockAmount;
                unlockAmtLoc = planUnlockAmountLoc;
                entry.setRecievePayAmount(amt.subtract(unlockAmt));
                entry.setRecievePayAmountLocal(amtLoc.subtract(unlockAmtLoc));
            }
            splitResult.setPayableAmount(unlockAmt);
            splitResult.setPayableAmountLoc(unlockAmtLoc);
            splitResultList.add((CoreBaseInfo)splitResult);
            if (!isFinish) continue;
            break;
        }
    }

    private void appendLockSettle(CoreBaseCollection settlementInfoList_addnew, CoreBaseCollection lockCol, Map splitedEntryMap) {
        SettlementListInfo settleSplit;
        SettlementListInfo settleLock;
        int splitIdx = settlementInfoList_addnew.size() - 1;
        block0: for (int i = lockCol.size() - 1; i >= 0; --i) {
            settleLock = (SettlementListInfo)lockCol.get(i);
            if (splitedEntryMap.containsKey(settleLock.getEntryId())) {
                settleSplit = (SettlementListInfo)splitedEntryMap.get(settleLock.getEntryId());
                if (settleSplit.getPlanId().equals(settleLock.getPlanId())) {
                    splitedEntryMap.put(settleLock.getEntryId(), settleLock);
                } else {
                    settleSplit.setIsSplited(true);
                    settleLock.setIsSplited(true);
                }
            }
            while (splitIdx >= 0) {
                settleSplit = (SettlementListInfo)settlementInfoList_addnew.get(splitIdx);
                if (settleLock.getPayableDate().compareTo(settleSplit.getPayableDate()) == 0 && settleLock.getEntryId().equals(settleSplit.getEntryId())) {
                    BigDecimal amtSplit = settleSplit.getPayableAmount();
                    BigDecimal amtLocSplit = settleSplit.getPayableAmountLoc();
                    BigDecimal lockAmt = settleLock.getLockAmount();
                    BigDecimal lockAmtLoc = settleLock.getLockAmountLoc();
                    settleLock.setPayableAmount(amtSplit.add(lockAmt));
                    settleLock.setPayableAmountLoc(amtLocSplit.add(lockAmtLoc));
                    settlementInfoList_addnew.removeObject(splitIdx);
                    continue block0;
                }
                if (settleLock.getPayableDate().compareTo(settleSplit.getPayableDate()) > 0) {
                    BigDecimal lockAmt = settleLock.getLockAmount();
                    BigDecimal lockAmtLoc = settleLock.getLockAmountLoc();
                    settleLock.setPayableAmount(lockAmt);
                    settleLock.setPayableAmountLoc(lockAmtLoc);
                    continue block0;
                }
                --splitIdx;
            }
        }
        int seq = 1;
        int addnewSize = settlementInfoList_addnew.size();
        int lockIdx = 0;
        int lockSize = lockCol.size();
        splitIdx = 0;
        while (lockIdx < lockSize && splitIdx < addnewSize) {
            settleLock = (SettlementListInfo)lockCol.get(lockIdx);
            settleSplit = (SettlementListInfo)settlementInfoList_addnew.get(splitIdx);
            if (settleSplit.getPayableDate().compareTo(settleLock.getPayableDate()) > 0) {
                settleLock.setSeq(seq++);
                ++lockIdx;
                continue;
            }
            settleSplit.setSeq(seq++);
            ++splitIdx;
        }
        while (lockIdx < lockSize) {
            settleLock = (SettlementListInfo)lockCol.get(lockIdx);
            settleLock.setSeq(seq++);
            ++lockIdx;
        }
        while (splitIdx < addnewSize) {
            settleSplit = (SettlementListInfo)settlementInfoList_addnew.get(splitIdx);
            settleSplit.setSeq(seq++);
            ++splitIdx;
        }
    }

    @Override
    public void _createDetail(Context ctx, int settlementType, int billType, String billIds) throws BOSException, EASBizException {
        if (billIds == null || billIds.length() < 5) {
            return;
        }
        if (801 == settlementType) {
            this.reverseBill(ctx, settlementType, billType, billIds);
        } else if (201 == settlementType || 207 == settlementType) {
            this.updateVerificatesql(ctx, billIds, settlementType);
        } else if (203 == settlementType || 103 == settlementType || 209 == settlementType || 109 == settlementType || 830 == settlementType || 820 == settlementType) {
            this.createDetail4Split(ctx, settlementType, billType, billIds);
        } else {
            this.createDetail4Split(ctx, settlementType, billType, billIds);
        }
        this.updatePlan(ctx, billIds);
    }

    @Override
    public void _deleteDetail(Context ctx, String billids) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update  T_AP_SettlementList as list set (FSettlementAmount, FSettlementAmountLoc, ");
        sql.append(" FLockAmount,FLockAmountLoc) =(select ");
        sql.append(" (list.FSettlementAmount-entry.famount) as FSettlementAmount ,");
        sql.append(" (list.FSettlementAmountLoc -entry.FAMOUNTLOC) as FSettlementAmountLoc , ");
        sql.append(" (list.FLockAmount -entry.famount) as FLockAmount,");
        sql.append(" (list.FLockAmountLoc -entry.FAMOUNTLOC) as FLockAmountLoc ");
        sql.append(" from (select ");
        sql.append(" sum(FAMOUNT) as FAMOUNT , sum(FAMOUNTLOC) as FAMOUNTLOC ,fparentid  ");
        sql.append(" from T_AP_SettlementListentry ");
        sql.append(" where FSETTLEMENTBILLID in (").append(billids).append(" )");
        sql.append(" group by fparentid ");
        sql.append(" ) as entry ");
        sql.append(" where list.fid = entry.fparentid )");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" update  T_AP_SettlementList as list set ( ");
        sql.append(" FLockAmount,FLockAmountLoc) =(select ");
        sql.append(" (list.FLockAmount +entry.famount) as FLockAmount,");
        sql.append(" (list.FLockAmountLoc +entry.FAMOUNTLOC) as FLockAmountLoc ");
        sql.append(" from (select ");
        sql.append(" sum(sentry.FAMOUNT) as FAMOUNT , sum(sentry.FAMOUNTLOC) as FAMOUNTLOC ,sentry.fparentid  ");
        sql.append(" from T_AP_SettlementListentry as sentry ");
        sql.append(" where sentry.FSETTLEMENTBILLID in (");
        sql.append(" select  fparentid from T_AP_VerificationBillentry ");
        sql.append(" where fparentid in (").append(billids).append(")");
        sql.append(" and  FIsFromBOTP =1  ");
        sql.append(" ) group by sentry.fparentid ");
        sql.append(" ) as entry ");
        sql.append(" where list.fid = entry.fparentid )");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        this.updatePlan(ctx, billids);
        sql.setLength(0);
        sql.append(" delete from T_AP_SettlementListentry ");
        sql.append(" where FSETTLEMENTBILLID in (").append(billids).append(" )");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private String updateVerificatesql(Context ctx, String ids, int settlementType) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(" insert into T_AP_SettlementListEntry ");
        sql.append(" (fid,FCreateTime,FSettlementBillId,FSettlementBillType,FSettlementBillNumber,");
        sql.append(" FSettlementBillEntryId,FAmount,FAmountLoc,FSettlementType,");
        sql.append(" FParentID )");
        sql.append(" (select newbosid('0DE6DA05'),now(),vbill.fid,").append(30);
        sql.append(" ,vbill.fnumber,ventry.fid,ventry.FThisVerificateAmt,ventry.FThisVerificateAmtLoc,");
        sql.append(settlementType).append(", slist.fid ");
        sql.append(" from  T_AP_VerificationBill as vbill  ");
        sql.append(" inner join T_AP_VerificationBillentry as ventry  on vbill.fid = ventry.fparentid ");
        sql.append(" inner join T_CAS_PaymentBillEntry as pentry on pentry.FId = ventry.FEntryID ");
        sql.append(" inner join T_AP_SettlementList as slist ");
        sql.append(" on  to_char(pentry.FPayableDate,'yyyy-mm-dd')  = to_char(slist.fPayableDate,'yyyy-mm-dd') and pentry.FSourceBillEntryId = slist.fentryid");
        sql.append(" where vbill.fid in (").append(ids).append(" )");
        sql.append(" )");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" insert into T_AP_SettlementListEntry ");
        sql.append(" (fid,FCreateTime,FSettlementBillId,FSettlementBillType,FSettlementBillNumber,");
        sql.append(" FSettlementBillEntryId,FAmount,FAmountLoc,FSettlementType,");
        sql.append(" FParentID )");
        sql.append(" (select newbosid('0DE6DA05'),now(),vbill.fid,").append(30);
        sql.append(" ,vbill.fnumber,ventry.fid,ventry.FThisVerificateAmt,ventry.FThisVerificateAmtLoc,");
        sql.append(settlementType).append(", slist.fid ");
        sql.append(" from  T_AP_VerificationBill as vbill  ");
        sql.append(" inner join T_AP_VerificationBillentry as ventry  on vbill.fid = ventry.fparentid ");
        sql.append(" inner join T_CAS_PaymentBillEntry as pentry on pentry.FId = ventry.FEntryID ");
        sql.append(" inner join T_ap_PayrequestBillEntry as rentry on rentry.FId = pentry.FSourceBillEntryId ");
        sql.append(" inner join T_AP_SettlementList as slist ");
        sql.append(" on  to_char(rentry.FPayableDate,'yyyy-mm-dd')  = to_char(slist.fPayableDate,'yyyy-mm-dd') and rentry.FSOURCEBILLENTRYID = slist.fentryid");
        sql.append(" where vbill.fid in (").append(ids).append(" )");
        sql.append(" )");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" update  T_AP_SettlementList as slist set (FSettlementAmount,FSettlementAmountLoc,FLockAmount,FLockAmountLoc) = ");
        sql.append(" (select slist.FSettlementAmount+t.FThisVerificateAmt,slist.FSettlementAmountLoc+t.FThisVerificateAmtLoc, ");
        sql.append("  slist.FLockAmount+t.FLockAmount,slist.FLockAmountLoc+t.FLockAmountLoc ");
        sql.append(" from (select pentry.FPayableDate,pentry.FSourceBillEntryId,");
        sql.append(" sum(ventry.FThisVerificateAmt ) as FThisVerificateAmt,sum(ventry.FThisVerificateAmtLoc) as FThisVerificateAmtLoc ");
        sql.append(" ,sum(case when isnull(ventry.FIsFromBOTP,0) = 0 then ventry.FThisVerificateAmt else 0 end) as FLockAmount ");
        sql.append(" ,sum(case when isnull(ventry.FIsFromBOTP,0) = 0 then ventry.FThisVerificateAmtLoc else 0 end)  as FLockAmountLoc ");
        sql.append(" from  T_AP_VerificationBill as vbill  ");
        sql.append(" inner join T_AP_VerificationBillentry as ventry  on vbill.fid = ventry.fparentid ");
        sql.append(" inner join T_CAS_PaymentBillEntry as pentry on pentry.FId = ventry.FEntryID ");
        sql.append(" where vbill.fid in (").append(ids).append(" )");
        sql.append(" group by pentry.FPayableDate,pentry.FSourceBillEntryId ");
        sql.append(" ) as t where to_char(t.FPayableDate,'yyyy-mm-dd') = to_char(slist.fPayableDate,'yyyy-mm-dd') and t.FSourceBillEntryId = slist.fentryid ");
        sql.append(" )");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" update  T_AP_SettlementList as slist set (FSettlementAmount,FSettlementAmountLoc,FLockAmount,FLockAmountLoc) = ");
        sql.append(" (select slist.FSettlementAmount+t.FThisVerificateAmt,slist.FSettlementAmountLoc+t.FThisVerificateAmtLoc, ");
        sql.append("  slist.FLockAmount+t.FLockAmount,slist.FLockAmountLoc+t.FLockAmountLoc ");
        sql.append(" from (select rentry.FPayableDate,rentry.FSOURCEBILLENTRYID,");
        sql.append(" sum(ventry.FThisVerificateAmt ) as FThisVerificateAmt,sum(ventry.FThisVerificateAmtLoc) as FThisVerificateAmtLoc ");
        sql.append(" ,sum(case when isnull(ventry.FIsFromBOTP,0) = 0 then ventry.FThisVerificateAmt else 0 end) as FLockAmount ");
        sql.append(" ,sum(case when isnull(ventry.FIsFromBOTP,0) = 0 then ventry.FThisVerificateAmtLoc else 0 end)  as FLockAmountLoc ");
        sql.append(" from  T_AP_VerificationBill as vbill  ");
        sql.append(" inner join T_AP_VerificationBillentry as ventry  on vbill.fid = ventry.fparentid ");
        sql.append(" inner join T_CAS_PaymentBillEntry as pentry on pentry.FId = ventry.FEntryID ");
        sql.append(" inner join T_ap_PayrequestBillEntry as rentry on rentry.FId = pentry.FSourceBillEntryId ");
        sql.append(" where vbill.fid in (").append(ids).append(" )");
        sql.append(" group by rentry.FPayableDate,rentry.FSourceBillEntryId ");
        sql.append(" ) as t where to_char(t.FPayableDate,'yyyy-mm-dd') = to_char(slist.fPayableDate,'yyyy-mm-dd') and t.FSOURCEBILLENTRYID = slist.fentryid ");
        sql.append(" )");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        return sql.toString();
    }

    private String getupdatesql4RecAP(String ids) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select s.fid,(s.FPayableAmountLoc-s.FLockAmountLoc) as unsetAmountLoc,");
        sql.append(" (s.FPayableAmount-s.FLockAmount) as unsetAmount,entry.fid as fentryid, ");
        sql.append(" entry.FThisVerificateAmtLoc as fRecievePayAmountLocal,entry.FThisVerificateAmt as fRecievePayAmount, ");
        sql.append(" bill.fid as FBillId ,bill.fnumber, bill.FVerificationType ");
        sql.append(" from T_AP_SettlementList as s inner join  T_AP_VerificationBillentry as entry ");
        sql.append(" on entry.FEntryID = s.FEntryId ");
        sql.append(" inner join T_AP_VerificationBill as bill on bill.fid = entry.fparentid ");
        sql.append(" where bill.fid in (").append(ids).append(" )");
        sql.append(" and (s.FPayableAmountLoc-s.FLockAmountLoc) >0 ");
        sql.append(" order by s.FEntryId,s.fPayableDate ");
        return sql.toString();
    }

    private String getupdatesql4RecAR(String ids) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select s.fid,(s.FPayableAmountLoc-s.FLockAmountLoc) as unsetAmountLoc,");
        sql.append(" (s.FPayableAmount-s.FLockAmount) as unsetAmount,entry.fid as fentryid, ");
        sql.append(" entry.FThisVerificateAmtLoc as fRecievePayAmountLocal,entry.FThisVerificateAmt as fRecievePayAmount, ");
        sql.append(" bill.fid as FBillId ,bill.fnumber, bill.FVerificationType ");
        sql.append(" from T_AP_SettlementList as s inner join  T_AR_VerificationBillentry as entry ");
        sql.append(" on entry.FEntryID = s.FEntryId ");
        sql.append(" inner join T_AR_VerificationBill as bill on bill.fid = entry.fparentid ");
        sql.append(" where bill.fid in (").append(ids).append(" )");
        sql.append(" and (s.FPayableAmountLoc-s.FLockAmountLoc) >0 ");
        sql.append(" order by s.FEntryId,s.fPayableDate ");
        return sql.toString();
    }

    private String getupdatesql4TransBill(String ids) {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(" select s.fid,(s.FPayableAmountLoc-s.FLockAmountLoc) as unsetAmountLoc,");
        sql.append(" (s.FPayableAmount-s.FLockAmount) as unsetAmount,entry.fid as fentryid, ");
        sql.append(" entry.fRecievePayAmountLocal,entry.fRecievePayAmount, ");
        sql.append(" bill.fid as FBillId ,bill.fnumber ");
        sql.append(" from T_AP_SettlementList as s inner join  T_AP_OtherBillentry as entry ");
        sql.append(" on entry.FSOURCEBILLENTRYID = s.FEntryId ");
        sql.append(" inner join T_AP_OtherBill as bill on bill.fid = entry.fparentid ");
        sql.append(" where bill.fid in (").append(ids).append(" )");
        sql.append(" and (s.FPayableAmountLoc-s.FLockAmountLoc) >0 ");
        sql.append(" order by s.FEntryId,s.fPayableDate");
        return sql.toString();
    }

    private String getupdatesql4PreRecBill(String ids) {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(" select s.fid,(s.FPayableAmountLoc-s.FLockAmountLoc) as unsetAmountLoc,");
        sql.append(" (s.FPayableAmount-s.FLockAmount) as unsetAmount,entry.fid as fentryid, ");
        sql.append(" entry.fLocalAmount as fRecievePayAmountLocal,entry.FAMOUNT as fRecievePayAmount, ");
        sql.append(" bill.fid as FBillId ,bill.fnumber");
        sql.append(" from T_AP_SettlementList as s inner join  T_CAS_ReceivingBillentry as entry ");
        sql.append(" on entry.FSOURCEBILLENTRYID = s.FEntryId ");
        sql.append(" inner join T_CAS_ReceivingBill as bill on bill.fid = entry.FReceivingBillID ");
        sql.append(" where bill.fid in (").append(ids).append(" )");
        sql.append(" and (s.FPayableAmountLoc-s.FLockAmountLoc) >0 ");
        sql.append(" order by s.FEntryId,s.fPayableDate");
        return sql.toString();
    }

    private void createDetail4Split(Context ctx, int settlementType, int billType, String billIds) throws BOSException {
        StringBuffer sql = new StringBuffer();
        StringBuffer insertsql = new StringBuffer();
        insertsql.append(" insert into T_AP_SettlementListEntry ");
        insertsql.append(" (fid,FSettlementBillId,FSettlementBillType,FSettlementBillNumber,");
        insertsql.append(" FSettlementBillEntryId,FAmount,FAmountLoc,FSettlementType,");
        insertsql.append(" FParentID,FCreateTime )");
        insertsql.append(" values (newbosid('0DE6DA05'),?,?,?,?,?,?,?,?,now())");
        boolean isVerificate = false;
        sql.setLength(0);
        String updatesql = null;
        if (820 == settlementType) {
            updatesql = this.getupdatesql4TransBill(billIds);
        } else if (830 == settlementType) {
            updatesql = this.getupdatesql4PreRecBill(billIds);
        } else if (203 == settlementType || 209 == settlementType) {
            updatesql = this.getupdatesql4RecAP(billIds);
            isVerificate = true;
        } else if (103 == settlementType || 109 == settlementType) {
            updatesql = this.getupdatesql4RecAR(billIds);
            isVerificate = true;
        } else {
            return;
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)updatesql);
        sql.setLength(0);
        sql.append(" update T_AP_SettlementList set FSettlementAmount=FSettlementAmount+?, ");
        sql.append(" FSettlementAmountLoc = FSettlementAmountLoc+?,FLockAmount=FLockAmount+?,FLockAmountLoc=FLockAmountLoc+?  ");
        sql.append(" where fid = ? ");
        Object[] param = null;
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        HashMap<String, BigDecimal> payAmountMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> payAmountLocMap = new HashMap<String, BigDecimal>();
        BigDecimal payAmount = null;
        BigDecimal payAmountLoc = null;
        BigDecimal curAmount = null;
        BigDecimal curAmountLoc = null;
        Object[] insertparam = null;
        ArrayList<Object[]> insertparamList = new ArrayList<Object[]>();
        BigDecimal ZERO = new BigDecimal("0.0");
        try {
            while (rs.next()) {
                param = new Object[5];
                String key = rs.getString("FEntryId");
                if (!payAmountMap.containsKey(key)) {
                    payAmount = rs.getBigDecimal("fRecievePayAmount");
                    payAmountLoc = rs.getBigDecimal("fRecievePayAmountLocal");
                    payAmountMap.put(key, payAmount);
                    payAmountLocMap.put(key, payAmountLoc);
                } else {
                    payAmount = (BigDecimal)payAmountMap.get(key);
                    payAmountLoc = (BigDecimal)payAmountLocMap.get(key);
                }
                if (payAmount.compareTo(ZERO) == 0) continue;
                curAmountLoc = rs.getBigDecimal("unsetAmountLoc");
                curAmount = rs.getBigDecimal("unsetAmount");
                if (payAmountLoc.abs().compareTo(curAmountLoc.abs()) >= 0) {
                    payAmountLoc = payAmountLoc.subtract(curAmountLoc);
                    payAmount = payAmount.subtract(curAmount);
                } else {
                    curAmount = payAmount;
                    curAmountLoc = payAmountLoc;
                    payAmountLoc = ZERO;
                    payAmount = ZERO;
                }
                payAmountMap.put(key, payAmount);
                payAmountLocMap.put(key, payAmountLoc);
                param[0] = curAmount;
                param[1] = curAmountLoc;
                param[2] = curAmount;
                param[3] = curAmountLoc;
                param[4] = rs.getString("fid");
                paramList.add(param);
                insertparam = new Object[]{rs.getString("FBillId"), billType, rs.getString("fnumber"), rs.getString("FEntryId"), curAmount, curAmountLoc, isVerificate ? Integer.valueOf(rs.getInt("FVerificationType")) : Integer.valueOf(settlementType), rs.getString("fid")};
                insertparamList.add(insertparam);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        DbUtil.executeBatch((Context)ctx, (String)sql.toString(), paramList);
        DbUtil.executeBatch((Context)ctx, (String)insertsql.toString(), insertparamList);
    }

    private List getSEntryDataNoSplit(Context ctx, int settlementType, int billType, String ids) throws BOSException {
        ArrayList<Object[]> settlementEntryDataList = new ArrayList<Object[]>();
        if (801 == settlementType) {
            StringBuffer sql = new StringBuffer();
            sql.append(" select s.fid,s.FBillId,s.FEntryId,bill.fnumber,");
            sql.append(" s.fSettlementAmountLoc,s.FSettlementAmount ");
            sql.append(" from T_AP_SettlementList as s  ");
            sql.append(" inner join T_AP_OtherBillentry as entry on entry.fid = s.FEntryId ");
            sql.append(" inner join T_AP_OtherBill as bill on entry.fparentid = bill.fid ");
            sql.append(" where s.FBillId in ( ").append(ids).append(" )");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                while (rs.next()) {
                    Object[] result = new Object[]{rs.getString("FBillId"), billType, rs.getString("fnumber"), rs.getString("FEntryId"), rs.getBigDecimal("FSettlementAmount"), rs.getBigDecimal("fSettlementAmountLoc"), settlementType, rs.getString("fid")};
                    settlementEntryDataList.add(result);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return settlementEntryDataList;
    }

    private void reverseBill(Context ctx, int settlementType, int billType, String ids) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_AP_SettlementList set FSettlementAmount=FPayableAmount, ");
        sql.append(" FSettlementAmountLoc = FPayableAmountLoc,FLockAmount=FPayableAmount,FLockAmountLoc=FPayableAmountLoc ");
        sql.append(" where FBillId in (").append(ids).append(" )");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" insert into T_AP_SettlementListEntry ");
        sql.append(" (fid,FSettlementBillId,FSettlementBillType,FSettlementBillNumber,");
        sql.append(" FSettlementBillEntryId,FAmount,FAmountLoc,FSettlementType,");
        sql.append(" FParentID,FCreateTime )");
        sql.append("( select newbosid('0DE6DA05'),s.FBillId,");
        sql.append(billType).append(",bill.fnumber,s.FEntryId,");
        sql.append(" s.fSettlementAmountLoc,s.FSettlementAmount, ");
        sql.append(settlementType).append(", s.fid,now() ");
        sql.append(" from T_AP_SettlementList as s  ");
        sql.append(" inner join T_AP_OtherBillentry as entry on entry.fid = s.FEntryId ");
        sql.append(" inner join T_AP_OtherBill as bill on entry.fparentid = bill.fid ");
        sql.append(" where s.FBillId in ( ").append(ids).append(" ))");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    public void updatePlan(Context ctx, String ids) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select sbill1.fbillid from T_AP_SettlementList as sbill1 ");
        sql.append(" inner join T_AP_SettlementListentry as sEntry on sentry.fparentid = sbill1.fid ");
        sql.append(" where sEntry.FSETTLEMENTBILLID in (").append(ids).append(") ");
        WriteBackOtherBill.updateOtherbill(ctx, sql.toString());
    }
}

