/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.netctrl.app.MutexService;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.IVerificationBill;
import com.kingdee.eas.fi.ap.VerificationBillCollection;
import com.kingdee.eas.fi.ap.VerificationBillFactory;
import com.kingdee.eas.fi.ap.VerificationBillInfo;
import com.kingdee.eas.fi.ap.VerificationBillentryCollection;
import com.kingdee.eas.fi.ap.VerificationBillentryInfo;
import com.kingdee.eas.fi.ap.app.AbstractVerificationBillControllerBean;
import com.kingdee.eas.fi.ap.app.util.ApServerUtils;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.arap.ARAPVerifynException;
import com.kingdee.eas.fi.arap.VerificationBillBaseInfo;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.arap.util.ArApParamsUtil;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class VerificationBillControllerBean
extends AbstractVerificationBillControllerBean {
    private static Logger logger = Logger.getLogger(VerificationBillControllerBean.class);

    @Override
    protected boolean _isVouchered(Context ctx, String billID) throws BOSException {
        String sql = "select ffivouchered from t_ap_verificationbill where fid = ? ";
        ArrayList<String> vs = new ArrayList<String>();
        vs.add(billID);
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])vs.toArray());
        try {
            if (result.next()) {
                return result.getBoolean("ffivouchered");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return false;
    }

    @Override
    protected RowSet _getBillIDs(Context ctx, String[] billIDs) throws BOSException {
        if (billIDs != null && billIDs.length > 0) {
            StringBuffer sql = new StringBuffer("select t2.fbillid as billid, t1.FCompanyID FCompanyID,t1.FCreatorID FCreatorID,t1.FID FID ");
            sql.append("from t_ap_verificationbill t1");
            sql.append("\tinner join t_ap_verificationbillentry t2 on t1.fid = t2.fparentid where ");
            for (int i = 0; i < billIDs.length; ++i) {
                if (i == 0) {
                    sql.append("t1.fid = '").append(billIDs[i]).append("' ");
                    continue;
                }
                sql.append("or t1.fid = '").append(billIDs[i]).append("' ");
            }
            return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        }
        return null;
    }

    @Override
    protected boolean _isLocked(Context ctx, String billID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("select t2.fbillid as billid ");
        sql.append("from t_ap_verificationbill t1");
        sql.append("\tinner join t_ap_verificationbillentry t2 on t1.fid = t2.fparentid ");
        sql.append("where t1.fid = ? ");
        ArrayList<String> vs = new ArrayList<String>();
        vs.add(billID);
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])vs.toArray());
        try {
            MutexService mutex = MutexService.getInstance();
            while (result.next()) {
                String srcBillID = result.getString("billid");
                if (mutex.requestObjIDForUpdate(ctx, srcBillID)) {
                    mutex.releaseObjIDForUpdate(ctx, srcBillID);
                    continue;
                }
                return true;
            }
        }
        catch (SQLException ex) {
            throw new SQLDataException(ex);
        }
        return false;
    }

    @Override
    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo botRelation = (BOTRelationInfo)bOTRelationInfo;
        VerificationBillInfo billInfo = null;
        if ("2652E01E".equals(botRelation.getDestEntityID())) {
            billInfo = this.getVerificationBillInfo(ctx, srcBillPK);
            if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
                billInfo.setFiVouchered(false);
                billInfo.setVoucher(null);
                billInfo.setVoucherType(null);
            } else {
                VoucherInfo voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(botRelation.getDestObjectID()));
                billInfo.setVoucher(voucherInfo);
                billInfo.setFiVouchered(true);
                billInfo.setVoucherNumber(voucherInfo.getNumber());
                billInfo.setVoucherType(voucherInfo.getVoucherType());
            }
        }
        super._reverseSave(ctx, srcBillPK, (IObjectValue)billInfo, bOTBillOperStateEnum, bOTRelationInfo);
    }

    @Override
    protected void _unVerify(Context ctx, Collection billIDs, boolean checkBizBill) throws BOSException, EASBizException {
        super._unVerify(ctx, billIDs, checkBizBill);
    }

    @Override
    protected void _unVeriCheck(Context ctx, String ids, Collection billIDs, List lockObjs, boolean checkBizBill) throws BOSException, EASBizException {
        IObjectPK[] col = this.getPKList(ctx, "select id, number where id in(" + ids + ") and fivouchered=1");
        if (col != null && col.length > 0) {
            throw new ARAPVerifynException(ARAPVerifynException.VERIBILL_HASVOUCHERED);
        }
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        RowSet rs = this.getBillIDs(ctx, billIDs.toArray(new String[0]));
        UserInfo defaultUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        boolean dataMutex = false;
        VerificationBillCollection billColl = new VerificationBillCollection();
        try {
            ArrayList<String> requestLockIDList = new ArrayList<String>();
            ArrayList<String> otherLockedList = new ArrayList<String>();
            while (rs.next()) {
                String billID = rs.getString("billid");
                if (!requestLockIDList.contains(billID)) {
                    requestLockIDList.add(billID);
                }
                VerificationBillInfo info = new VerificationBillInfo();
                CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
                companyInfo.setId(BOSUuid.read((String)rs.getString("FCompanyID")));
                info.setCompany(companyInfo);
                info.setId(BOSUuid.read((String)rs.getString("FID")));
                if (rs.getString("FCreatorID") != null) {
                    UserInfo userInfo = new UserInfo();
                    userInfo.setId(BOSUuid.read((String)rs.getString("FCreatorID")));
                    info.setCreator(userInfo);
                }
                billColl.add(info);
            }
            if (requestLockIDList != null && requestLockIDList.size() > 0) {
                Map map = mutex.batchRequestObjIDForUpdate(requestLockIDList);
                String id = null;
                int size = requestLockIDList.size();
                for (int i = 0; i < size; ++i) {
                    id = (String)requestLockIDList.get(i);
                    if (((Boolean)map.get(id)).booleanValue()) {
                        lockObjs.add(id);
                        continue;
                    }
                    otherLockedList.add(id);
                }
                if (otherLockedList.size() > 0) {
                    mutex.batchReleaseObjIDForUpdate(lockObjs);
                    throw new ARAPVerifynException(ARAPVerifynException.VERIBILL_MUTEXTERROR);
                }
            }
            if (checkBizBill && (rs = DBUtil.executeQuery((Context)ctx, (String)("SELECT TOP 1 1 FROM T_AP_OTHERBILL F  WHERE  EXISTS (SELECT 1 FROM T_AP_VERIFICATIONBILLENTRY C WHERE C.FPARENTID IN (" + ArApBillHelper.ids2SqlString(billIDs) + ") AND C.FBILLID=F.FID) AND F.FISBIZBILL = 1"))).next()) {
                throw new ARAPVerifynException(ARAPVerifynException.BIZVERIBILLCANNOTUNVERI);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        VerificationBillInfo info = null;
        UserInfo userInfo = null;
        String value = null;
        int size = billColl.size();
        for (int i = 0; i < size; ++i) {
            info = billColl.get(i);
            if (!paramMap.containsKey(info.getCompany().getId().toString())) {
                value = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), (String)"AP_028");
                paramMap.put(info.getCompany().getId().toString(), value);
            } else {
                value = paramMap.get(info.getCompany().getId().toString()).toString();
            }
            if (value == null || !"true".equalsIgnoreCase(value) && !"1".equalsIgnoreCase(value) || (userInfo = ContextUtil.getCurrentUserInfo((Context)ctx)) == null || info.getCreator() == null || userInfo.getId().toString().equals(info.getCreator().getId().toString())) continue;
            throw new ARAPVerifynException(ARAPVerifynException.ARAPBILL_IS_SAMEVERIFY_PERSON);
        }
    }

    protected DAPTransformResult _generateVoucher(Context ctx, IObjectPK[] sourceBillPkList, IObjectPK botMappingPK, SelectorItemCollection botpSelectors) throws BOSException, EASBizException {
        StringBuffer ids = new StringBuffer();
        for (int i = 0; i < sourceBillPkList.length; ++i) {
            ids.append("'");
            ids.append(sourceBillPkList[i].toString());
            ids.append("',");
        }
        if (ids.length() > 0) {
            ids.deleteCharAt(ids.length() - 1);
        }
        IObjectPK logPk = this.writeVoucherLog(ctx, ids.toString(), false);
        if (this._isNeedCheckVoucherCondition()) {
            this._voucherCheck(ctx, sourceBillPkList);
        }
        DAPTransformResult result = super._generateVoucher(ctx, sourceBillPkList, botMappingPK, botpSelectors);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
        return result;
    }

    protected void _voucherCheck(Context ctx, IObjectPK[] sourceBillPkList) throws EASBizException, BOSException {
        StringBuffer ids = new StringBuffer();
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < sourceBillPkList.length; ++i) {
            idSet.add(sourceBillPkList[i].toString());
        }
        ids.append(ArApBillHelper.ids2SqlString(idSet));
        StringBuffer sql = new StringBuffer();
        IRowSet set = null;
        try {
            String id = null;
            if (ids.length() > 0) {
                sql.append("select distinct bill.fid from t_ap_verificationBill bill \n");
                sql.append(" inner join t_ap_verificationBillEntry entry on bill.fid=entry.fparentid \n");
                sql.append("where (entry.FGainAndLoss <> 0 or bill.fIsSameCurrency = 0) and  bill.fid in (").append(ids.toString()).append(")");
                set = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (set.next()) {
                    id = set.getString(1);
                    idSet.remove(id);
                }
                ids.setLength(0);
                ids.append(ArApBillHelper.ids2SqlString(idSet));
            }
            if (ids.length() > 0) {
                Boolean verifyCanVoucher = ArApParamsUtil.getBooleanBackgroundParam(ctx, "ARAP_VERIFY_CAN_VOUCHER");
                if (verifyCanVoucher.booleanValue()) {
                    sql.setLength(0);
                    sql.append("select distinct bill.fid from t_ap_verificationBill bill \n");
                    sql.append(" inner join t_ap_verificationBillEntry entry on bill.fid=entry.fparentid \n");
                    sql.append(" left join T_ap_otherBill otherBill on entry.fbillID = otherBill.fid \n");
                    sql.append(" where entry.FveriType = 1 and  bill.fid in (").append(ids.toString()).append(" )\n");
                    sql.append(" and bill.fisCashSalePur = 0 \n");
                    sql.append(" and ( otherBill.fisBizbill is null or otherBill.fisBizbill = 0 )\n");
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    while (rowSet.next()) {
                        id = rowSet.getString(1);
                        idSet.remove(id);
                    }
                }
                ids.setLength(0);
                ids.append(ArApBillHelper.ids2SqlString(idSet));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (ids.length() > 0) {
            VerificationBillCollection col = null;
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            ev.setFilter(filter);
            ev.getSelector().add("id");
            ev.getSelector().add("entrys.billSubType");
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("verificationType", (Object)Integer.valueOf(String.valueOf(201))));
            filter.getFilterItems().add(new FilterItemInfo("mainBillType", (Object)Integer.valueOf(String.valueOf(9))));
            filter.getFilterItems().add(new FilterItemInfo("secondBillType", (Object)Integer.valueOf(String.valueOf(9))));
            col = this.getVerificationBillCollection(ctx, ev);
            if (col.size() > 0) {
                throw new ARAPVerifynException(ARAPVerifynException.APBILL_ONESIDE_VERI);
            }
            filter.getFilterItems().clear();
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("verificationType", (Object)Integer.valueOf(String.valueOf(201))));
            filter.getFilterItems().add(new FilterItemInfo("mainBillType", (Object)Integer.valueOf(String.valueOf(4))));
            filter.getFilterItems().add(new FilterItemInfo("secondBillType", (Object)Integer.valueOf(String.valueOf(4))));
            col = this.getVerificationBillCollection(ctx, ev);
            VerificationBillentryCollection element = null;
            VerificationBillentryInfo entry = null;
            boolean isPreRec = false;
            boolean isRedPreRec = false;
            boolean noOtherRec = true;
            Iterator iter = col.iterator();
            while (iter.hasNext()) {
                element = ((VerificationBillInfo)iter.next()).getEntrys();
                Iterator iterator = element.iterator();
                while (iterator.hasNext()) {
                    entry = (VerificationBillentryInfo)iterator.next();
                    if (entry.getBillSubType().getValue() == 202) {
                        isPreRec = true;
                        continue;
                    }
                    if (entry.getBillSubType().getValue() == 204) {
                        isRedPreRec = true;
                        continue;
                    }
                    noOtherRec = false;
                }
                if (isPreRec && isRedPreRec && noOtherRec) {
                    throw new ARAPVerifynException(ARAPVerifynException.PAYBILL_ONESIDE_VERI);
                }
                isPreRec = false;
                isRedPreRec = false;
                noOtherRec = true;
            }
            String companyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
            boolean isPay = ApServerUtils.isPayBillCreateVoucher(ctx, companyID);
            boolean isPrePayAcct = ApServerUtils.isPrePayAcct(ctx, companyID);
            boolean isCash = ApServerUtils.iscashbillCreatVoucher(ctx, companyID);
            if (isCash) {
                set = null;
                int size = 0;
                sql.setLength(0);
                sql.append("select count(distinct bill.fid) from t_ap_verificationBill bill \n");
                sql.append("where bill.fid in (");
                sql.append(ids.toString());
                sql.append(") and \n");
                sql.append(" bill.FISCASHSALEPUR =1 \n");
                set = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                try {
                    if (set.next()) {
                        size = set.getInt(1);
                    }
                }
                catch (SQLException e) {
                    logger.info((Object)e);
                }
                if (size > 0) {
                    throw new OtherBillBizException(OtherBillBizException.CASH_RE_FORBIDENN_BILL);
                }
            } else {
                sql.setLength(0);
                sql.append("select bill.fid fid from t_ap_verificationBill bill \n");
                sql.append("where bill.fid in (");
                sql.append(ids.toString());
                sql.append(") and \n");
                sql.append(" bill.FISCASHSALEPUR =1 \n");
                set = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                try {
                    while (set.next()) {
                        if (set.getString(1) == null || set.getString(1).toString().equals("")) continue;
                        idSet.remove(set.getString(1));
                    }
                }
                catch (SQLException e) {
                    logger.info((Object)e);
                }
            }
            if (isPay) {
                ids.setLength(0);
                for (int j = 0; j < idSet.size(); ++j) {
                    ids.append("'").append((String)idSet.toArray()[j]).append("'");
                    if (j >= idSet.size() - 1) continue;
                    ids.append(",");
                }
                if (ids.length() > 0) {
                    ArrayList<Integer> params = new ArrayList<Integer>();
                    set = null;
                    int size = 0;
                    sql.setLength(0);
                    sql.append("select count(distinct bill.fid) from t_ap_verificationBill bill \n");
                    sql.append(" inner join t_ap_verificationBillEntry entry on bill.fid=entry.fparentid \n");
                    sql.append("where bill.FISCASHSALEPUR =0 and bill.fid in (");
                    sql.append(ids.toString());
                    sql.append(") and \n");
                    try {
                        if (isPrePayAcct) {
                            sql.append("((FverificationType=? and (entry.fbillSubType=? or entry.fbillSubType=?)) or fverificationType<>?)");
                            params.add(Integer.valueOf(String.valueOf(201)));
                            params.add(Integer.valueOf(String.valueOf(202)));
                            params.add(Integer.valueOf(String.valueOf(204)));
                            params.add(Integer.valueOf(String.valueOf(201)));
                            set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
                            if (set.next()) {
                                size = set.getInt(1);
                            }
                            if (size < idSet.size()) {
                                throw new ARAPVerifynException(ARAPVerifynException.PARAM_ISPAYT_ISPREPAYACCTT);
                            }
                        } else {
                            sql.append(" FverificationType=? and entry.FbillSubType=?");
                            params.add(Integer.valueOf(String.valueOf(201)));
                            params.add(Integer.valueOf(String.valueOf(201)));
                            set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
                            if (set.next()) {
                                size = set.getInt(1);
                            }
                            if (size > 0) {
                                throw new ARAPVerifynException(ARAPVerifynException.PARAM_ISPAYT_ISPREPAYACCTF);
                            }
                        }
                    }
                    catch (SQLException e) {
                        throw new BOSException((Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    protected SystemEnum getSysEnum() {
        return SystemEnum.ACCOUNTSPAYABLE;
    }

    protected boolean _isNeedCheckVoucherCondition() {
        return true;
    }

    @Override
    protected void _reverse(Context ctx, String[] idArr, Date verifyDate) throws BOSException, EASBizException {
        this.entryTab = "T_AP_VerificationBillentry";
        IVerificationBill rmi = VerificationBillFactory.getLocalInstance(ctx);
        this.reverse(ctx, rmi, idArr, verifyDate);
    }

    @Override
    protected AbstractObjectCollection getVerificationEntrys(VerificationBillBaseInfo redInfo) {
        return ((VerificationBillInfo)redInfo).getEntrys();
    }

    @Override
    protected void _unReverse(Context ctx, String[] idArr) throws BOSException, EASBizException {
        this.entryTab = "T_AP_VerificationBillentry";
        IVerificationBill rmi = VerificationBillFactory.getLocalInstance(ctx);
        this.unReverse(ctx, rmi, idArr);
    }

    @Override
    protected boolean isAR() {
        return false;
    }
}

