/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.ArApRecPayException;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.app.service.PayAddNewService;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.Locale;

public class ApPayAddNewService
extends PayAddNewService {
    String resourcePath = "com.kingdee.eas.fi.ar.ARRecPayResource";

    public void initService(Context ctx, PaymentBillInfo info) throws EASBizException, BOSException {
        super.initService(ctx, info);
        if (info.getEntries() == null || info.getEntries().size() == 0) {
            throw new ArApRecPayException(ArApRecPayException.BLANK, (Object[])new String[]{ResourceBase.getString((String)this.resourcePath, (String)"noEntryNoSave", (Locale)ctx.getLocale())});
        }
        super.initService(ctx, info);
    }

    public void beforeAddNew() throws EASBizException, BOSException {
        super.beforeAddNew();
        if (this.info.getSourceBillId() != null && !"".equals(this.info.getSourceBillId()) && "40284E81".equals(BOSUuid.read((String)this.info.getSourceBillId()).getType().toString()) && PaymentBillFactory.getLocalInstance((Context)this.ctx).exists("WHERE sourceType = 103 AND id = '" + this.info.getSourceBillId() + "'")) {
            throw new RecPayException(RecPayException.CANGENAGENTPAY);
        }
        if (EmptyUtil.isEmpty((String)this.info.getNumber())) {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)this.ctx);
            if (this.isRuleAutoNumber(this.ctx, this.info) && this.isAddView(this.ctx, iCodingRuleManager, this.info)) {
                this.info.setNumber(NumberRuleUtil.getNumberSilent((Context)this.ctx, (CoreBaseInfo)this.info, (String)this.info.getCompany().getId().toString()));
            }
        }
    }

    private boolean isAddView(Context ctx, ICodingRuleManager iCodingRuleManager, PaymentBillInfo paymentBillInfo) throws CodingRuleException, EASBizException, BOSException {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = paymentBillInfo.getCompany();
        String strCompanyID = aCompanyOrgUnitInfo.getId().toString();
        return iCodingRuleManager.isAddView((IObjectValue)paymentBillInfo, strCompanyID);
    }

    protected boolean isRuleAutoNumber(Context ctx, PaymentBillInfo paymentBillInfo) throws EASBizException, BOSException {
        String strCompanyId = null;
        if (paymentBillInfo.getCompany() != null) {
            strCompanyId = paymentBillInfo.getCompany().getId().toString();
        }
        return this.isRuleAutoNumber(ctx, paymentBillInfo, strCompanyId);
    }

    protected boolean isRuleAutoNumber(Context ctx, PaymentBillInfo paymentBillInfo, String sCompanyID) throws EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager;
        if (StringUtils.isEmpty((String)sCompanyID)) {
            CompanyOrgUnitInfo aCompanyOrgUnitInfo = null;
            aCompanyOrgUnitInfo = paymentBillInfo.getCompany() != null ? paymentBillInfo.getCompany() : ContextUtil.getCurrentFIUnit((Context)ctx);
            sCompanyID = aCompanyOrgUnitInfo.getId().toString();
        }
        return (iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx)).isExist((IObjectValue)paymentBillInfo, sCompanyID);
    }
}

