/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.app.service.handler.ArApServiceHandler;
import com.kingdee.eas.fi.arap.app.util.RecPayServiceUtil;
import com.kingdee.eas.fi.arap.util.ArApBillReverseHelper;
import com.kingdee.eas.fi.cas.BillDisposerAction;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.IPaymentDisposer;
import com.kingdee.eas.fi.cas.RecPayBillInfo;
import com.kingdee.eas.fi.cas.app.ArApRecPayServerHelper;
import com.kingdee.eas.fi.cas.app.service.PayDeleteService;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import java.util.HashSet;

public class ApPayDeleteService
extends PayDeleteService {
    ArApServiceHandler arapServiceHandler;

    private ArApServiceHandler getArApServiceHandler() {
        return new ArApServiceHandler();
    }

    public void beforeDelete() throws EASBizException, BOSException {
        String tableName = "T_CAS_PaymentBillEntry";
        HashSet<String> idSet = new HashSet<String>();
        int size = this.info.getEntries().size();
        for (int i = 0; i < size; ++i) {
            if (this.info.getEntries().get(i) == null || this.info.getEntries().get(i).getId() == null) continue;
            idSet.add(this.info.getEntries().get(i).getId().toString());
        }
        if (SCMServerUtils.isExistsBizFlowField((Context)this.ctx, (String)tableName) && SCMServerUtils.isHasBizFlowValue((Context)this.ctx, (String)tableName, idSet)) {
            this.isHasValue = true;
        }
        if (!this.info.isIsInitializeBill() && !this.info.isIsTransBill() && this.isHasValue) {
            ArApRecPayServerHelper.injectBizFlow((Context)this.ctx, (IObjectValue)this.info, (BatchActionEnum)BatchActionEnum.DELETE);
        }
        this.arapServiceHandler = this.getArApServiceHandler();
        this.arapServiceHandler.recycleUseIntermitNumber(this.ctx, this.pk, this.info);
        if (!(this.info.isIsInitializeBill() || this.info.isIsTransBill() || this.isHasValue)) {
            if (this.info.isIsDiffCurSettlement()) {
                RecPayServiceUtil.reverseOtherBillLock(this.ctx, (RecPayBillInfo)this.info, false, BOTBillOperStateEnum.DELETE);
            } else {
                ArApBillReverseHelper.reverseLockAmt(this.ctx, (RecPayBillInfo)this.info, BOTBillOperStateEnum.DELETE);
            }
        }
        RecPayServiceUtil.reverseRecPayLockAmt(this.ctx, (RecPayBillInfo)this.info, false, BOTBillOperStateEnum.DELETE);
        if (!this.isHasValue) {
            this.writeBackInitBill();
        }
        super.beforeDelete();
    }

    private void writeBackInitBill() throws BOSException {
        try {
            if (this.info != null && this.info.isIsInitializeBill() && BillStatusEnum.SUBMIT == this.info.getBillStatus()) {
                String[] disposerName = new String[]{"com.kingdee.eas.scm.sm.pur.PurOrderDisposer", "com.kingdee.eas.scm.sm.sc.SubContractOrderDisposer"};
                int size = disposerName.length;
                for (int i = 0; i < size; ++i) {
                    IPaymentDisposer disposer = (IPaymentDisposer)Class.forName(disposerName[i]).newInstance();
                    BillDisposerAction disposerAction = new BillDisposerAction();
                    disposerAction.setDestBill((CoreBaseInfo)this.info);
                    disposerAction.setActionType(DisposerActionEnum.CANCEL_PAY);
                    disposer.dispose(this.ctx, disposerAction);
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }
}

