/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.PayRequestBillBizException;
import com.kingdee.eas.fi.ap.PayRequestBillEntryCollection;
import com.kingdee.eas.fi.ap.PayRequestBillEntryFactory;
import com.kingdee.eas.fi.ap.app.util.ApServerUtils;
import com.kingdee.eas.fi.arap.app.service.handler.ArApServiceHandler;
import com.kingdee.eas.fi.arap.app.util.ArApServerUtils;
import com.kingdee.eas.fi.arap.app.util.RecPayServiceUtil;
import com.kingdee.eas.fi.arap.util.ArApBillUtil;
import com.kingdee.eas.fi.arap.util.ArApPeriodHelper;
import com.kingdee.eas.fi.cas.ArApRecPayException;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.CasForArApException;
import com.kingdee.eas.fi.cas.IsMergencyEnum;
import com.kingdee.eas.fi.cas.PaymentBillDataProcess;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayBillInfo;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.ArApRecPayServerHelper;
import com.kingdee.eas.fi.cas.app.service.PaySaveService;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;

public class ApPaySaveService
extends PaySaveService {
    String resourcePath = "com.kingdee.eas.fi.ar.ARRecPayResource";
    ArApRecPayServerHelper arapHelper = new ArApRecPayServerHelper();
    private ArApServiceHandler arapServiceHandler = new ArApServiceHandler();

    public void beforeSave() throws EASBizException, BOSException {
        super.beforeSave();
        if (this.info.getSourceSysType() == null) {
            this.info.setSourceSysType(SourceTypeEnum.AP);
        }
        if (this.info.getSourceType() == null) {
            this.info.setSourceType(this.info.getSourceSysType());
        }
        if (this.info.getBizDate() == null) {
            this.info.setBizDate(new Date());
        }
        if (this.info.getBillDate() == null) {
            this.info.setBillDate(new Date());
        }
        if (this.info.get("isEmergency") == null) {
            this.info.setIsEmergency(IsMergencyEnum.normal);
        }
        this.checkSportCBPay();
        PeriodInfo period = this.checkSystemIfStart(this.ctx, SystemEnum.ACCOUNTSPAYABLE, this.info.getCompany());
        if (period == null) {
            throw new RecPayException(RecPayException.AP_SYSTEM_NO_PERIOD);
        }
        this.checkBizDate();
        PaymentBillEntryCollection entrys = this.info.getEntries();
        if (entrys != null) {
            for (int i = entrys.size() - 1; i >= 0; --i) {
                BigDecimal amount = entrys.get(i).getAmount();
                if (amount != null && amount.compareTo(BigDecimal.ZERO) != 0) continue;
                entrys.remove(entrys.get(i));
            }
        }
        if (this.info.getEntries() == null || this.info.getEntries().size() == 0) {
            this.throwSaveExcetion(this.ctx, "noEntryNoSave");
        }
        this.arapHelper.verifyAccountView(this.ctx, this.info.getPayerAccount(), this.info.getCurrency(), this.info.getCompany());
        if (this.info.getId() != null && !this.isAddNew) {
            if (this.info.getBillStatus().getValue() == 11) {
                throw new CasForArApException(CasForArApException.SUBMMITED_CANNNOTSAVE);
            }
            if (this.info.getBillStatus().getValue() >= 12) {
                throw new CasForArApException(CasForArApException.BILLISAUDITED);
            }
        }
        if (this.info.getCU() == null && this.info.getCompany().getCU() != null) {
            if (null != this.info.getCompany().getCU().getNumber() && null != this.info.getCompany().getCU().getName() && null != this.info.getCompany().getCU().getCode()) {
                this.info.setCU(this.info.getCompany().getCU());
            } else {
                String CUID = this.info.getCompany().getCU().getId().toString();
                CtrlUnitInfo CU = CtrlUnitFactory.getLocalInstance((Context)this.ctx).getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(CUID));
                this.info.setCU(CU);
            }
        }
        this.arapServiceHandler.checkNumber(this.ctx, (RecPayBillInfo)this.info);
        if (this.info.getBillStatus() == null || this.info.getBillStatus() != BillStatusEnum.SAVE) {
            this.info.setBillStatus(BillStatusEnum.SAVE);
        }
        if (this.info.isIsDiffCurSettlement()) {
            RecPayServiceUtil.reverseOtherBillLock(this.ctx, (RecPayBillInfo)this.info, false, this.isAddNew ? BOTBillOperStateEnum.ADDNEW : BOTBillOperStateEnum.EDIT);
        } else {
            RecPayServiceUtil.reversePayAmountFields(this.ctx, this.info, BatchActionEnum.SAVE);
        }
        RecPayServiceUtil.reverseRecPayLockAmt(this.ctx, (RecPayBillInfo)this.info, false);
        ApServerUtils.lockPaymentBill(this.ctx, this.info);
        this.serviceHandler.checkIsInQueue(this.ctx, this.info);
        PaymentBillDataProcess.setAmountProp((Context)this.ctx, (PaymentBillInfo)this.info);
        if (this.info.get("id") != null && PaymentBillFactory.getLocalInstance((Context)this.ctx).exists((IObjectPK)new ObjectUuidPK(this.info.get("id").toString()))) {
            boolean isAudit = PaymentBillFactory.getLocalInstance((Context)this.ctx).exists("where billStatus>=12 and id = '" + this.info.get("id").toString() + "'");
            boolean isSubmit = PaymentBillFactory.getLocalInstance((Context)this.ctx).exists("where billStatus=11 and id = '" + this.info.get("id").toString() + "'");
            if (isAudit) {
                throw new CasForArApException(CasForArApException.BILLISAUDITED);
            }
            if (isSubmit) {
                throw new CasForArApException(CasForArApException.SUBMMITED_CANNNOTSAVE);
            }
        }
        this.checkSourcePayReqIsClose(this.ctx, this.info);
        ArApBillUtil.setDefaultValueZero(this.ctx, (BillBaseInfo)this.info);
    }

    protected void checkSourcePayReqIsClose(Context ctx, PaymentBillInfo info) throws EASBizException, BOSException {
        PaymentBillEntryCollection entrys = info.getEntries();
        if (entrys.size() == 0) {
            return;
        }
        HashSet<String> sourceEntryIdSet = new HashSet<String>();
        String sourceEntryId = null;
        for (int i = 0; i < entrys.size(); ++i) {
            sourceEntryId = entrys.get(i).getSourceBillEntryId();
            if (StringUtils.isEmpty((String)sourceEntryId)) continue;
            sourceEntryIdSet.add(sourceEntryId);
        }
        if (sourceEntryIdSet.size() == 0 || !"C84206F8".equals(BOSUuid.read((String)sourceEntryId).getType().toString())) {
            return;
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", sourceEntryIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("entryStatus", (Object)-2, CompareType.EQUALS));
        ev.setFilter(filter);
        PayRequestBillEntryCollection coll = PayRequestBillEntryFactory.getLocalInstance(ctx).getPayRequestBillEntryCollection(ev);
        if (coll.size() > 0) {
            throw new PayRequestBillBizException(PayRequestBillBizException.SOURCEPAYREQHASCLOSE);
        }
    }

    public void afterSave(IObjectPK pk) throws EASBizException, BOSException {
        super.afterSave(pk);
        BOSUuid billId = this.info.getId();
        PaymentBillEntryCollection entryColl = this.info.getEntries();
        HashSet<String> srcIdSet = new HashSet<String>();
        for (int i = 0; i < entryColl.size(); ++i) {
            String srcBillId = entryColl.get(i).getString("sourceBillId");
            if (StringUtils.isEmpty((String)srcBillId)) continue;
            srcIdSet.add(srcBillId);
        }
        String relation = this.info.getExtendedProperty("rebuildBOTRelation");
        try {
            if (this.info != null && billId != null && !srcIdSet.isEmpty() && !Boolean.parseBoolean(relation)) {
                ArApServerUtils.createBotpRelation(this.ctx, srcIdSet, billId.toString());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        ApServerUtils.checkCurrency(this.ctx, this.info);
        HashMap param = new HashMap();
        param.put("AP_037", null);
        param = this.serviceHandler.getParam(this.ctx, (IObjectPK)new ObjectUuidPK(this.info.getCompany().getId().toString()), param);
        Boolean AP_037 = param.get("AP_037") != null && "true".equalsIgnoreCase(param.get("AP_037").toString());
        if (!AP_037.booleanValue()) {
            ApServerUtils.checkAmtForDiffCurrencyPay(this.ctx, this.info);
        }
    }

    private PeriodInfo checkSystemIfStart(Context ctx, SystemEnum sourceType, CompanyOrgUnitInfo companyInfo) {
        PeriodInfo period = null;
        try {
            period = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)sourceType, (CompanyOrgUnitInfo)companyInfo);
        }
        catch (EASBizException e) {
            Logger.error((Throwable)e);
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        return period;
    }

    private void throwSaveExcetion(Context ctx, String messageItem) throws EASBizException {
        throw new ArApRecPayException(ArApRecPayException.BLANK, (Object[])new String[]{ResourceBase.getString((String)this.resourcePath, (String)messageItem, (Locale)ctx.getLocale())});
    }

    protected void checkSportCBPay() throws ArApRecPayException {
        if (this.info.isIsCBPay()) {
            throw new ArApRecPayException(ArApRecPayException.BLANK, (Object[])new String[]{ResourceBase.getString((String)this.resourcePath, (String)"AP_PAYBILL_NOTSUPPORT_CBPAY", (Locale)this.ctx.getLocale())});
        }
    }

    protected void checkBizDate() throws EASBizException, BOSException {
        PeriodInfo currentPeriod;
        if (this.info.getSourceType().getValue() == 101 && (currentPeriod = ArApPeriodHelper.getApCurrentPeriod(this.ctx, this.info.getCompany())) != null && this.info.getBizDate() != null && currentPeriod.getBeginDate().compareTo(this.info.getBizDate()) > 0 && !this.info.isIsInitializeBill()) {
            throw new RecPayException(RecPayException.AP_BILLDATEMUSTGREATTHANBEGINDATE);
        }
    }
}

