/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.ap.FinishApInitFacadeFactory;
import com.kingdee.eas.fi.ap.IFinishApInitFacade;
import com.kingdee.eas.fi.ap.PaymentBillBizException;
import com.kingdee.eas.fi.ar.app.util.CommonServerUtils;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ApServerUtils {
    private static final BOSObjectType AP_OTHERBILL_BOSTYPE = BOSObjectType.create((String)"48DA3A71");
    private static final BOSObjectType PAYREQ_BILL_BOSTYPE = BOSObjectType.create((String)"D001019A");
    private static final BOSObjectType PAYREQ_ENTRY_BOSTYPE = BOSObjectType.create((String)"C84206F8");
    private static final BOSObjectType PAYREQ_SUM_ENTRY_BOSTYPE = BOSObjectType.create((String)"ADEC60D4");
    private static final BOSObjectType PAYREQ_SUMENTRY_BOSTYPE = BOSObjectType.create((String)"ADEC60D4");
    private static final BOSObjectType PAYMENTBILL_BOSTYPE = BOSObjectType.create((String)"40284E81");

    public static SystemStatusCtrolInfo getApStatusCtrolInfo(Context ctx, Object cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        SystemStatusCtrolInfo systmSttsCtrlInf = CommonServerUtils.getSysStatusCtrolInfo(ctx, cmpnyOrgUntInfObj, SystemEnum.ACCOUNTSPAYABLE);
        return systmSttsCtrlInf;
    }

    public static boolean apIsStart(Context ctx, Object cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        SystemStatusCtrolInfo systmStsCtrlInf = ApServerUtils.getApStatusCtrolInfo(ctx, cmpnyOrgUntInfObj);
        if (systmStsCtrlInf != null) {
            return systmStsCtrlInf.isIsStart();
        }
        return false;
    }

    public static PeriodInfo getApStartPeriod(Context ctx, Object cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        SystemStatusCtrolInfo systmStsCtrlInf = ApServerUtils.getApStatusCtrolInfo(ctx, cmpnyOrgUntInfObj);
        if (systmStsCtrlInf != null) {
            return systmStsCtrlInf.getStartPeriod();
        }
        return null;
    }

    public static PeriodInfo getApCurrentPeriod(Context ctx, Object cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        SystemStatusCtrolInfo systmStsCtrlInf = ApServerUtils.getApStatusCtrolInfo(ctx, cmpnyOrgUntInfObj);
        if (systmStsCtrlInf != null) {
            return systmStsCtrlInf.getCurrentPeriod();
        }
        return null;
    }

    public static PeriodInfo getApCurrentPeriod(Context ctx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = CommonServerUtils.getCurrentCompany(ctx);
        return ApServerUtils.getApCurrentPeriod(ctx, company);
    }

    public static boolean apIsRelatedAccount(Context ctx, Object cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        SystemStatusCtrolInfo systmStsCtrlInf = ApServerUtils.getApStatusCtrolInfo(ctx, cmpnyOrgUntInfObj);
        if (systmStsCtrlInf != null) {
            return systmStsCtrlInf.isIsRelatedAccount();
        }
        return false;
    }

    public static void apStart(Context ctx, Object cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        if (ctx == null) {
            throw new IllegalArgumentException();
        }
        if (!(cmpnyOrgUntInfObj instanceof CompanyOrgUnitInfo)) {
            throw new IllegalArgumentException();
        }
        CompanyOrgUnitInfo cmpnyOrgUntInf = (CompanyOrgUnitInfo)cmpnyOrgUntInfObj;
        ISystemStatusCtrol systemStatusCtrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        systemStatusCtrol.start(SystemEnum.ACCOUNTSPAYABLE, cmpnyOrgUntInf, true);
    }

    public static void apReverseStart(Context ctx, Object cmpnyOrgUntInfObj) throws BOSException, EASBizException {
        if (ctx == null) {
            throw new IllegalArgumentException();
        }
        if (!(cmpnyOrgUntInfObj instanceof CompanyOrgUnitInfo)) {
            throw new IllegalArgumentException();
        }
        CompanyOrgUnitInfo cmpnyOrgUntInf = (CompanyOrgUnitInfo)cmpnyOrgUntInfObj;
        ISystemStatusCtrol systemStatusCtrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        systemStatusCtrol.start(SystemEnum.ACCOUNTSPAYABLE, cmpnyOrgUntInf, false);
    }

    public static boolean setApCurrentPeriod(Context ctx, Object company, PeriodInfo period) throws BOSException, EASBizException {
        SystemStatusCtrolInfo systmSttsCtrlInf = ApServerUtils.getApStatusCtrolInfo(ctx, company);
        systmSttsCtrlInf.setCurrentPeriod(period);
        systmSttsCtrlInf.setIsClosedAccount(false);
        ISystemStatusCtrol systemStatusCtrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK pk = new ObjectUuidPK(systmSttsCtrlInf.getId());
        systemStatusCtrol.update((IObjectPK)pk, (CoreBaseInfo)systmSttsCtrlInf);
        return true;
    }

    public static boolean changeApCurrentPeriodToNext(Context ctx, Object company, PeriodInfo nextPeriod) throws BOSException, EASBizException {
        PeriodInfo currentNewPeriod = null;
        while (nextPeriod != null && nextPeriod.isIsAdjustPeriod()) {
            currentNewPeriod = nextPeriod;
            nextPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)currentNewPeriod);
        }
        return ApServerUtils.setApCurrentPeriod(ctx, company, nextPeriod);
    }

    public static boolean auditPaymentBill(Context ctx, String id) throws BOSException, EASBizException {
        if (ctx == null || id == null) {
            throw new IllegalArgumentException();
        }
        if (id == null) {
            throw new IllegalArgumentException();
        }
        IFinishApInitFacade fnshApIntFcd = FinishApInitFacadeFactory.getLocalInstance(ctx);
        HashMap<String, String[]> userContext = new HashMap<String, String[]>();
        String[] ids = new String[]{id};
        userContext.put("ID_LIST", ids);
        return fnshApIntFcd.auditPaymentBill(userContext);
    }

    public static boolean auditPaymentBill(Context ctx, String[] ids) throws BOSException, EASBizException {
        if (ctx == null || ids == null) {
            throw new IllegalArgumentException();
        }
        if (ids == null || ids.length <= 0) {
            throw new IllegalArgumentException();
        }
        IFinishApInitFacade fnshApIntFcd = FinishApInitFacadeFactory.getLocalInstance(ctx);
        HashMap<String, String[]> userContext = new HashMap<String, String[]>();
        userContext.put("ID_LIST", ids);
        return fnshApIntFcd.auditPaymentBill(userContext);
    }

    public static boolean auditPurInvoice(Context ctx, String id) throws BOSException, EASBizException {
        if (ctx == null || id == null) {
            throw new IllegalArgumentException();
        }
        if (id == null) {
            throw new IllegalArgumentException();
        }
        IFinishApInitFacade fnshApIntFcd = FinishApInitFacadeFactory.getLocalInstance(ctx);
        HashMap<String, String[]> userContext = new HashMap<String, String[]>();
        String[] ids = new String[]{id};
        userContext.put("ID_LIST", ids);
        return fnshApIntFcd.auditPurInvoice(userContext);
    }

    public static boolean auditPurInvoice(Context ctx, String[] ids) throws BOSException, EASBizException {
        if (ctx == null || ids == null) {
            throw new IllegalArgumentException();
        }
        if (ids == null || ids.length <= 0) {
            throw new IllegalArgumentException();
        }
        IFinishApInitFacade fnshApIntFcd = FinishApInitFacadeFactory.getLocalInstance(ctx);
        HashMap<String, String[]> userContext = new HashMap<String, String[]>();
        userContext.put("ID_LIST", ids);
        return fnshApIntFcd.auditPurInvoice(userContext);
    }

    public static boolean auditOtherBill(Context ctx, String billId) throws BOSException, EASBizException {
        if (ctx == null || billId == null) {
            throw new IllegalArgumentException();
        }
        IFinishApInitFacade fnshApIntFcd = FinishApInitFacadeFactory.getLocalInstance(ctx);
        HashMap<String, String> userContext = new HashMap<String, String>();
        userContext.put("BILLID", billId);
        return fnshApIntFcd.auditOtherBill(userContext);
    }

    public static boolean unAuditPaymentBill(Context ctx, String id) throws BOSException, EASBizException {
        if (ctx == null || id == null) {
            throw new IllegalArgumentException();
        }
        if (id == null) {
            throw new IllegalArgumentException();
        }
        IFinishApInitFacade fnshApIntFcd = FinishApInitFacadeFactory.getLocalInstance(ctx);
        HashMap<String, String[]> userContext = new HashMap<String, String[]>();
        String[] ids = new String[]{id};
        userContext.put("ID_LIST", ids);
        return fnshApIntFcd.unAuditPaymentBill(userContext);
    }

    public static boolean unAuditPaymentBill(Context ctx, String[] ids) throws BOSException, EASBizException {
        if (ctx == null || ids == null) {
            throw new IllegalArgumentException();
        }
        if (ids == null || ids.length <= 0) {
            throw new IllegalArgumentException();
        }
        IFinishApInitFacade fnshApIntFcd = FinishApInitFacadeFactory.getLocalInstance(ctx);
        HashMap<String, String[]> userContext = new HashMap<String, String[]>();
        userContext.put("ID_LIST", ids);
        return fnshApIntFcd.unAuditPaymentBill(userContext);
    }

    public static boolean unAuditPurInvoice(Context ctx, String id) throws BOSException, EASBizException {
        if (ctx == null || id == null) {
            throw new IllegalArgumentException();
        }
        if (id == null) {
            throw new IllegalArgumentException();
        }
        IFinishApInitFacade fnshApIntFcd = FinishApInitFacadeFactory.getLocalInstance(ctx);
        HashMap<String, String[]> userContext = new HashMap<String, String[]>();
        String[] ids = new String[]{id};
        userContext.put("ID_LIST", ids);
        return fnshApIntFcd.unAuditPurInvoice(userContext);
    }

    public static boolean unAuditPurInvoice(Context ctx, String[] ids) throws BOSException, EASBizException {
        if (ctx == null || ids == null) {
            throw new IllegalArgumentException();
        }
        if (ids == null || ids.length <= 0) {
            throw new IllegalArgumentException();
        }
        IFinishApInitFacade fnshApIntFcd = FinishApInitFacadeFactory.getLocalInstance(ctx);
        HashMap<String, String[]> userContext = new HashMap<String, String[]>();
        userContext.put("ID_LIST", ids);
        return fnshApIntFcd.unAuditPurInvoice(userContext);
    }

    public static boolean changeBalancePurInvoiceAddNew(Context ctx, String[] ids) throws BOSException, EASBizException {
        if (ctx == null || ids == null) {
            throw new IllegalArgumentException();
        }
        if (ids == null || ids.length <= 0) {
            throw new IllegalArgumentException();
        }
        IFinishApInitFacade fnshApIntFcd = FinishApInitFacadeFactory.getLocalInstance(ctx);
        HashMap<String, String[]> userContext = new HashMap<String, String[]>();
        userContext.put("ID_LIST", ids);
        return fnshApIntFcd.changeBalancePurInvoiceAddNew(userContext);
    }

    public static boolean changeBalancePurInvoiceAddNew(Context ctx, String id) throws BOSException, EASBizException {
        if (ctx == null || id == null) {
            throw new IllegalArgumentException();
        }
        if (id == null) {
            throw new IllegalArgumentException();
        }
        IFinishApInitFacade fnshApIntFcd = FinishApInitFacadeFactory.getLocalInstance(ctx);
        HashMap<String, String[]> userContext = new HashMap<String, String[]>();
        String[] ids = new String[]{id};
        userContext.put("ID_LIST", ids);
        return fnshApIntFcd.changeBalancePurInvoiceAddNew(userContext);
    }

    public static boolean changeBalancePurInvoiceDelete(Context ctx, String[] ids) throws BOSException, EASBizException {
        if (ctx == null || ids == null) {
            throw new IllegalArgumentException();
        }
        if (ids == null || ids.length <= 0) {
            throw new IllegalArgumentException();
        }
        IFinishApInitFacade fnshApIntFcd = FinishApInitFacadeFactory.getLocalInstance(ctx);
        HashMap<String, String[]> userContext = new HashMap<String, String[]>();
        userContext.put("ID_LIST", ids);
        return fnshApIntFcd.changeBalancePurInvoiceDelete(userContext);
    }

    public static boolean changeBalancePurInvoiceDelete(Context ctx, String id) throws BOSException, EASBizException {
        if (ctx == null || id == null) {
            throw new IllegalArgumentException();
        }
        if (id == null) {
            throw new IllegalArgumentException();
        }
        IFinishApInitFacade fnshApIntFcd = FinishApInitFacadeFactory.getLocalInstance(ctx);
        HashMap<String, String[]> userContext = new HashMap<String, String[]>();
        String[] ids = new String[]{id};
        userContext.put("ID_LIST", ids);
        return fnshApIntFcd.changeBalancePurInvoiceDelete(userContext);
    }

    public static boolean changeBalancePurInvoicePreUpdate(Context ctx, String[] ids) throws BOSException, EASBizException {
        if (ctx == null || ids == null) {
            throw new IllegalArgumentException();
        }
        if (ids == null || ids.length <= 0) {
            throw new IllegalArgumentException();
        }
        IFinishApInitFacade fnshApIntFcd = FinishApInitFacadeFactory.getLocalInstance(ctx);
        HashMap<String, String[]> userContext = new HashMap<String, String[]>();
        userContext.put("ID_LIST", ids);
        return fnshApIntFcd.changeBalancePurInvoicePreUpdate(userContext);
    }

    public static boolean changeBalancePurInvoicePreUpdate(Context ctx, String id) throws BOSException, EASBizException {
        if (ctx == null || id == null) {
            throw new IllegalArgumentException();
        }
        if (id == null) {
            throw new IllegalArgumentException();
        }
        IFinishApInitFacade fnshApIntFcd = FinishApInitFacadeFactory.getLocalInstance(ctx);
        HashMap<String, String[]> userContext = new HashMap<String, String[]>();
        String[] ids = new String[]{id};
        userContext.put("ID_LIST", ids);
        return fnshApIntFcd.changeBalancePurInvoicePreUpdate(userContext);
    }

    public static boolean changeBalancePurInvoicePostUpdate(Context ctx, String[] ids) throws BOSException, EASBizException {
        if (ctx == null || ids == null) {
            throw new IllegalArgumentException();
        }
        if (ids == null || ids.length <= 0) {
            throw new IllegalArgumentException();
        }
        IFinishApInitFacade fnshApIntFcd = FinishApInitFacadeFactory.getLocalInstance(ctx);
        HashMap<String, String[]> userContext = new HashMap<String, String[]>();
        userContext.put("ID_LIST", ids);
        return fnshApIntFcd.changeBalancePurInvoicePostUpdate(userContext);
    }

    public static boolean changeBalancePurInvoicePostUpdate(Context ctx, String id) throws BOSException, EASBizException {
        if (ctx == null || id == null) {
            throw new IllegalArgumentException();
        }
        if (id == null) {
            throw new IllegalArgumentException();
        }
        IFinishApInitFacade fnshApIntFcd = FinishApInitFacadeFactory.getLocalInstance(ctx);
        HashMap<String, String[]> userContext = new HashMap<String, String[]>();
        String[] ids = new String[]{id};
        userContext.put("ID_LIST", ids);
        return fnshApIntFcd.changeBalancePurInvoicePostUpdate(userContext);
    }

    public static boolean changeBalancePaymentBillAddNew(Context ctx, String[] ids) throws BOSException, EASBizException {
        if (ctx == null || ids == null) {
            throw new IllegalArgumentException();
        }
        if (ids == null || ids.length <= 0) {
            throw new IllegalArgumentException();
        }
        IFinishApInitFacade fnshApIntFcd = FinishApInitFacadeFactory.getLocalInstance(ctx);
        HashMap<String, String[]> userContext = new HashMap<String, String[]>();
        userContext.put("ID_LIST", ids);
        return fnshApIntFcd.changeBalancePaymentBillAddNew(userContext);
    }

    public static boolean changeBalancePaymentBillAddNew(Context ctx, String id) throws BOSException, EASBizException {
        if (ctx == null || id == null) {
            throw new IllegalArgumentException();
        }
        if (id == null) {
            throw new IllegalArgumentException();
        }
        IFinishApInitFacade fnshApIntFcd = FinishApInitFacadeFactory.getLocalInstance(ctx);
        HashMap<String, String[]> userContext = new HashMap<String, String[]>();
        String[] ids = new String[]{id};
        userContext.put("ID_LIST", ids);
        return fnshApIntFcd.changeBalancePaymentBillAddNew(userContext);
    }

    public static boolean changeBalancePaymentBillDelete(Context ctx, String[] ids) throws BOSException, EASBizException {
        if (ctx == null || ids == null) {
            throw new IllegalArgumentException();
        }
        if (ids == null || ids.length <= 0) {
            throw new IllegalArgumentException();
        }
        IFinishApInitFacade fnshApIntFcd = FinishApInitFacadeFactory.getLocalInstance(ctx);
        HashMap<String, String[]> userContext = new HashMap<String, String[]>();
        userContext.put("ID_LIST", ids);
        return fnshApIntFcd.changeBalancePaymentBillDelete(userContext);
    }

    public static boolean changeBalancePaymentBillDelete(Context ctx, String id) throws BOSException, EASBizException {
        if (ctx == null || id == null) {
            throw new IllegalArgumentException();
        }
        if (id == null) {
            throw new IllegalArgumentException();
        }
        IFinishApInitFacade fnshApIntFcd = FinishApInitFacadeFactory.getLocalInstance(ctx);
        HashMap<String, String[]> userContext = new HashMap<String, String[]>();
        String[] ids = new String[]{id};
        userContext.put("ID_LIST", ids);
        return fnshApIntFcd.changeBalancePaymentBillDelete(userContext);
    }

    public static boolean changeBalancePaymentBillPreUpdate(Context ctx, String[] ids) throws BOSException, EASBizException {
        if (ctx == null || ids == null) {
            throw new IllegalArgumentException();
        }
        if (ids == null || ids.length <= 0) {
            throw new IllegalArgumentException();
        }
        IFinishApInitFacade fnshApIntFcd = FinishApInitFacadeFactory.getLocalInstance(ctx);
        HashMap<String, String[]> userContext = new HashMap<String, String[]>();
        userContext.put("ID_LIST", ids);
        return fnshApIntFcd.changeBalancePaymentBillPreUpdate(userContext);
    }

    public static boolean changeBalancePaymentBillPreUpdate(Context ctx, String id) throws BOSException, EASBizException {
        if (ctx == null || id == null) {
            throw new IllegalArgumentException();
        }
        if (id == null) {
            throw new IllegalArgumentException();
        }
        IFinishApInitFacade fnshApIntFcd = FinishApInitFacadeFactory.getLocalInstance(ctx);
        HashMap<String, String[]> userContext = new HashMap<String, String[]>();
        String[] ids = new String[]{id};
        userContext.put("ID_LIST", ids);
        return fnshApIntFcd.changeBalancePaymentBillPreUpdate(userContext);
    }

    public static boolean changeBalancePaymentBillPostUpdate(Context ctx, String[] ids) throws BOSException, EASBizException {
        if (ctx == null || ids == null) {
            throw new IllegalArgumentException();
        }
        if (ids == null || ids.length <= 0) {
            throw new IllegalArgumentException();
        }
        IFinishApInitFacade fnshApIntFcd = FinishApInitFacadeFactory.getLocalInstance(ctx);
        HashMap<String, String[]> userContext = new HashMap<String, String[]>();
        userContext.put("ID_LIST", ids);
        return fnshApIntFcd.changeBalancePaymentBillPostUpdate(userContext);
    }

    public static boolean changeBalancePaymentBillPostUpdate(Context ctx, String id) throws BOSException, EASBizException {
        if (ctx == null || id == null) {
            throw new IllegalArgumentException();
        }
        if (id == null) {
            throw new IllegalArgumentException();
        }
        IFinishApInitFacade fnshApIntFcd = FinishApInitFacadeFactory.getLocalInstance(ctx);
        HashMap<String, String[]> userContext = new HashMap<String, String[]>();
        String[] ids = new String[]{id};
        userContext.put("ID_LIST", ids);
        return fnshApIntFcd.changeBalancePaymentBillPostUpdate(userContext);
    }

    public static boolean isPayBillCreateVoucher(Context ctx, String sCompanyId) throws NumberFormatException, EASBizException, BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(sCompanyId);
        int checkType = 0;
        checkType = Integer.parseInt(ParamManager.getParamValue((Context)ctx, (IObjectPK)pk, (String)"AP_PAYVOUCHER_BILLTYPE"));
        return checkType != 0;
    }

    public static boolean isPrePayAcct(Context ctx, String sCompanyId) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(sCompanyId);
        String value = ParamManager.getParamValue((Context)ctx, (IObjectPK)pk, (String)"AP_IS_PRE_PAY_ACCT");
        return "true".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value);
    }

    public static boolean isPaiedBillVoucher(Context ctx, String sCompanyId) {
        ObjectUuidPK pk = new ObjectUuidPK(sCompanyId);
        String value = null;
        try {
            value = ParamManager.getParamValue((Context)ctx, (IObjectPK)pk, (String)"Pay_Vou_001");
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
        return "true".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value);
    }

    public static boolean iscashbillCreatVoucher(Context ctx, String sCompanyId) throws NumberFormatException, EASBizException, BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(sCompanyId);
        int checkType = 0;
        checkType = Integer.parseInt(ParamManager.getParamValue((Context)ctx, (IObjectPK)pk, (String)"AP_PAYVOUCHER_BILLTYPE_CASH"));
        return checkType != 0;
    }

    public static boolean isLockPaymentBill(Context ctx, String companyId, PaymentBillEntryInfo entry, Map<String, Boolean> lockCache) throws BOSException {
        boolean isNeedLock = false;
        IDynamicObject iObjectInstance = DynamicObjectFactory.getLocalInstance((Context)ctx);
        String sourceBillEntryId = entry.getSourceBillEntryId();
        String sourceBillid = entry.getSourceBillId();
        if (lockCache.get(sourceBillid) != null) {
            isNeedLock = lockCache.get(sourceBillid);
        } else if (!StringUtils.isEmpty((String)sourceBillEntryId)) {
            BOSObjectType sourceEntryType = BOSUuid.read((String)sourceBillEntryId).getType();
            BOSObjectType sourceBillType = BOSUuid.read((String)sourceBillid).getType();
            EntityViewInfo view = new EntityViewInfo();
            if (AP_OTHERBILL_BOSTYPE.equals((Object)sourceBillType)) {
                view.getSelector().add(new SelectorItemInfo("company.id"));
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)sourceBillid, CompareType.EQUALS));
                view.setFilter(filter);
                IObjectCollection srcBillColl = iObjectInstance.getCollection(sourceBillType, view);
                IObjectValue srcBillInfo = srcBillColl.getObject(0);
                IObjectValue company = (IObjectValue)srcBillInfo.get("company");
                isNeedLock = companyId.equals(company.get("id").toString());
            } else if (PAYREQ_BILL_BOSTYPE.equals((Object)sourceBillType)) {
                view.getSelector().add(new SelectorItemInfo("sourceBillId"));
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                if (PAYREQ_ENTRY_BOSTYPE.equals((Object)sourceEntryType)) {
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)sourceBillEntryId, CompareType.EQUALS));
                } else if (PAYREQ_SUM_ENTRY_BOSTYPE.equals((Object)sourceEntryType)) {
                    filter.getFilterItems().add(new FilterItemInfo("sumEntryID", (Object)sourceBillEntryId, CompareType.EQUALS));
                }
                IObjectCollection srcBillColl = iObjectInstance.getCollection(PAYREQ_ENTRY_BOSTYPE, view);
                IObjectValue srcBillInfo = srcBillColl.getObject(0);
                sourceBillid = srcBillInfo.getString("sourceBillId");
                isNeedLock = !StringUtils.isEmpty((String)sourceBillid) && AP_OTHERBILL_BOSTYPE.equals((Object)BOSUuid.read((String)sourceBillid).getType());
            } else if (PAYMENTBILL_BOSTYPE.equals((Object)sourceBillType)) {
                isNeedLock = true;
            }
        }
        lockCache.put(entry.getSourceBillId(), isNeedLock);
        return isNeedLock;
    }

    public static void lockPaymentBill(Context ctx, PaymentBillInfo info) throws BOSException {
        IDynamicObject iObjectInstance = DynamicObjectFactory.getLocalInstance((Context)ctx);
        PaymentBillEntryInfo payEntryInfo = null;
        BigDecimal apAmt = null;
        BigDecimal apLocAmt = null;
        String companyId = info.getCompany().getId().toString();
        PaymentBillEntryCollection payEntryColl = info.getEntries();
        Iterator payEntryItr = payEntryColl.iterator();
        HashMap<String, Boolean> lockCache = new HashMap<String, Boolean>();
        while (payEntryItr.hasNext()) {
            payEntryInfo = (PaymentBillEntryInfo)payEntryItr.next();
            apAmt = payEntryInfo.getAmount();
            apAmt = apAmt == null ? SysConstant.BIGZERO : apAmt;
            apLocAmt = payEntryInfo.getLocalAmt();
            BigDecimal bigDecimal = apLocAmt = apLocAmt == null ? SysConstant.BIGZERO : apLocAmt;
            if (ApServerUtils.isLockPaymentBill(ctx, companyId, payEntryInfo, lockCache)) {
                payEntryInfo.setLockAmt(apAmt);
                payEntryInfo.setLockLocAmt(apLocAmt);
                payEntryInfo.setUnLockAmt(SysConstant.BIGZERO);
                payEntryInfo.setUnLockLocAmt(SysConstant.BIGZERO);
                continue;
            }
            payEntryInfo.setLockAmt(SysConstant.BIGZERO);
            payEntryInfo.setLockLocAmt(SysConstant.BIGZERO);
            payEntryInfo.setUnLockAmt(apAmt);
            payEntryInfo.setUnLockLocAmt(apLocAmt);
        }
    }

    public static boolean isPayReqSumEntry(String entryId) {
        if (StringUtils.isEmpty((String)entryId)) {
            return false;
        }
        BOSObjectType srcBosType = BOSUuid.read((String)entryId).getType();
        return PAYREQ_SUMENTRY_BOSTYPE.equals((Object)srcBosType);
    }

    public static String getSqlIds(Set<String> idSet) {
        if (null == idSet || idSet.isEmpty()) {
            return null;
        }
        StringBuilder sqlIds = new StringBuilder();
        int index = 0;
        for (String id : idSet) {
            if (0 == index) {
                sqlIds.append("'").append(id).append("'");
            } else {
                sqlIds.append(",").append("'").append(id).append("'");
            }
            ++index;
        }
        return sqlIds.toString();
    }

    public static void checkAmtForDiffCurrencyPay(Context ctx, PaymentBillInfo info) throws BOSException, EASBizException {
        if (info.isIsCBPay()) {
            return;
        }
        Boolean isDiffCur = info.isIsDiffCurSettlement();
        if (!isDiffCur.booleanValue()) {
            return;
        }
        String payBillId = info.getId().toString();
        StringBuffer checkAmtSql = new StringBuffer(200);
        checkAmtSql.append(" select * from ");
        checkAmtSql.append(" (select apOtherBill.Fid fid, apOtherBill.fnumber fnumber , apOtherBill.Fpayeramount payeramount,sum(payBill.FAMOUNT) amount ");
        checkAmtSql.append(" from T_Cas_Paymentbillentry payBill ");
        checkAmtSql.append(" inner join t_Ap_Otherbill apOtherBill on payBill.Fsourcebillid = apOtherBill.fid ");
        checkAmtSql.append(" where payBill.Fpaymentbillid = '").append(payBillId).append("'");
        checkAmtSql.append(" group by apOtherBill.Fid,apOtherBill.fnumber,apOtherBill.Fpayeramount) temp  ");
        checkAmtSql.append(" where  abs(amount) > abs(temp.payeramount); ");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)checkAmtSql.toString());
        try {
            if (result.next()) {
                throw new PaymentBillBizException(PaymentBillBizException.PAYMENTAMT_NOTBIG_APPAYAMOUNT);
            }
        }
        catch (SQLException exc) {
            throw new BOSException((Throwable)exc);
        }
    }

    public static void checkCurrency(Context ctx, PaymentBillInfo info) throws BOSException, PaymentBillBizException {
        if (info.isIsCBPay()) {
            return;
        }
        Boolean isDiffCur = info.isIsDiffCurSettlement();
        String currencyFields = isDiffCur != false ? "FPayercurrencyid" : "FCurrencyid";
        String payBillId = info.getId().toString();
        StringBuffer checkCurrencySql = new StringBuffer(100);
        checkCurrencySql.append(" select apOtherBill.Fid as fid");
        checkCurrencySql.append(" from t_Cas_Paymentbillentry payBillEntry ");
        checkCurrencySql.append(" inner join t_Cas_Paymentbill payBill on payBill.fid = payBillEntry.FPAYMENTBILLID  ");
        checkCurrencySql.append(" inner join t_Ap_Otherbill apOtherBill on payBillEntry.Fsourcebillid = apOtherBill.fid ");
        checkCurrencySql.append(" where payBillEntry.Fpaymentbillid = '").append(payBillId).append("' ");
        checkCurrencySql.append(" and payBill.Fcurrencyid <> apOtherBill.").append(currencyFields);
        checkCurrencySql.append(" group by apOtherBill.Fid");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)checkCurrencySql.toString());
        try {
            if (result.next()) {
                if (isDiffCur.booleanValue()) {
                    throw new PaymentBillBizException(PaymentBillBizException.PAYMENTCURRENCY_APPAYCURRENCY_NOTEQ);
                }
                throw new PaymentBillBizException(PaymentBillBizException.PAYMENTCURRENCY_UPBILLCUR_NOTEQ);
            }
        }
        catch (SQLException exc) {
            throw new BOSException((Throwable)exc);
        }
        if (!isDiffCur.booleanValue()) {
            checkCurrencySql.setLength(0);
            checkCurrencySql.append(" select apOtherBill.Fid as fid");
            checkCurrencySql.append(" from T_Cas_Paymentbillentry payBillEntry ");
            checkCurrencySql.append(" inner join T_Cas_Paymentbill payBill on payBill.fid = payBillEntry.FPAYMENTBILLID ");
            checkCurrencySql.append(" inner join T_Ap_PayrequestBillEntry payReqEntry on payBillEntry.FsourceBillEntryid = payReqEntry.fid ");
            checkCurrencySql.append(" inner join T_Ap_PayrequestBill payReq on payReqEntry.FParentID = payReq.fid ");
            checkCurrencySql.append(" inner join T_Ap_Otherbill apOtherBill on payReqEntry.Fsourcebillid = apOtherBill.fid ");
            checkCurrencySql.append(" where payBillEntry.Fpaymentbillid = '").append(payBillId).append("'");
            checkCurrencySql.append(" and (payBill.Fcurrencyid <> apOtherBill.FCurrencyid");
            checkCurrencySql.append(" or apOtherBill.Fcurrencyid <> payReq.FCurrencyid");
            checkCurrencySql.append(" or payBill.Fcurrencyid <> payReq.FCurrencyid)");
            checkCurrencySql.append(" group by apOtherBill.Fid");
            result = DbUtil.executeQuery((Context)ctx, (String)checkCurrencySql.toString());
            try {
                if (result.next()) {
                    throw new PaymentBillBizException(PaymentBillBizException.PAYMENTCURRENCY_UPBILLCUR_NOTEQ);
                }
            }
            catch (SQLException exc) {
                throw new BOSException((Throwable)exc);
            }
        }
    }
}

