/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.app.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IPaymentType;
import com.kingdee.eas.basedata.assistant.PaymentTypeFactory;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.OtherBillFactory;
import com.kingdee.eas.fi.ap.OtherBillInfo;
import com.kingdee.eas.fi.ap.OtherBillPlanInfo;
import com.kingdee.eas.fi.ap.OtherBillType;
import com.kingdee.eas.fi.ap.VerificateBillTypeEnum;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.arap.app.util.ArApServerUtils;
import com.kingdee.eas.fi.arap.app.web.BaseService;
import com.kingdee.eas.fi.arap.app.web.BillCreateService;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;

public class APBillCreateService
extends BillCreateService {
    public APBillCreateService(Context context) {
        super(context);
    }

    @Override
    public int getOrgType() {
        return 1;
    }

    @Override
    public String getPermissionItem() {
        return "fi_arap_ApOtherBill_Add";
    }

    @Override
    public CoreBillBaseInfo createDefaultBill(OrgUnitInfo mainOrg, Map otherInformation) throws EASBizException, BOSException {
        OtherBillInfo info = new OtherBillInfo();
        Date date = null;
        boolean isInitBill = false;
        if (otherInformation != null && otherInformation.containsKey("isInitBill")) {
            isInitBill = (Boolean)otherInformation.get("isInitBill");
        }
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)mainOrg;
        ObjectUuidPK companypk = new ObjectUuidPK(company.getId().toString());
        SelectorItemCollection selCol = new SelectorItemCollection();
        selCol.add(new SelectorItemInfo("cu.number"));
        selCol.add(new SelectorItemInfo("name"));
        selCol.add(new SelectorItemInfo("number"));
        selCol.add(new SelectorItemInfo("baseCurrency.id"));
        selCol.add(new SelectorItemInfo("baseExchangeTable.id"));
        selCol.add(new SelectorItemInfo("accountTable.id"));
        company = CompanyOrgUnitFactory.getLocalInstance((Context)this.getContext()).getCompanyOrgUnitInfo((IObjectPK)companypk, selCol);
        ObjectUuidPK currencypk = new ObjectUuidPK(company.getBaseCurrency().getId().toString());
        CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)this.getContext()).getCurrencyInfo((IObjectPK)currencypk);
        info.setCompany(company);
        info.setCU(company.getCU());
        info.setCurrency(currency);
        info.setPayerCurrency(currency);
        info.setPayerExchangeRate(BigDecimal.ONE);
        if (isInitBill) {
            info.setIsInitializeBill(true);
            BaseService bs = new BaseService(this.getContext());
            date = bs.getBeforeSysDate(true, 13, company.getId().toString());
        } else {
            date = ArApServerUtils.getBizDateBySystem(this.getContext(), false, company);
        }
        info.setExchangeRate(BigDecimal.ONE);
        info.setBillType(OtherBillType.InvoiceBill);
        info.setIsInTax(true);
        info.setBillDate(date);
        info.setBizDate(date);
        info.setBillStatus(BillStatusEnum.SAVE);
        UserInfo creator = new UserInfo();
        creator.setId(BOSUuid.read((String)this.getContext().getCaller().toString()));
        ObjectUuidPK userpk = new ObjectUuidPK(this.getContext().getCaller().toString());
        creator = UserFactory.getLocalInstance((Context)this.getContext()).getUserInfo((IObjectPK)userpk);
        info.setCreator(creator);
        info.setCreateTime(new Timestamp(new Date().getTime()));
        ObjectUuidPK pk = new ObjectUuidPK("2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5");
        IPaymentType iPaymentType = PaymentTypeFactory.getLocalInstance((Context)this.getContext());
        PaymentTypeInfo paymentTypeInfo = iPaymentType.getPaymentTypeInfo((IObjectPK)pk);
        info.setPaymentType(paymentTypeInfo);
        info.setAsstActType(this.getAsstActType(company, SystemEnum.ACCOUNTSPAYABLE));
        info.setIsInTax(true);
        info.setIsPriceWithoutTax(true);
        info.setPurOrg(this.getDefaultPurchaseOrgUnit(company));
        info.setSourceBillType(VerificateBillTypeEnum.OTHER);
        OtherBillPlanInfo payPlan = new OtherBillPlanInfo();
        payPlan.setRecievePayDate(date);
        payPlan.setRecievePayAmount(BigDecimal.ZERO);
        payPlan.setRecievePayAmountLocal(BigDecimal.ZERO);
        payPlan.setVerifyAmount(BigDecimal.ZERO);
        payPlan.setVerifyAmountLocal(BigDecimal.ZERO);
        info.getPayPlan().add(payPlan);
        info.setInvoiceCode(null);
        info.setInvoiceNumber(null);
        info.setInvoiceType(PayInvoiceTypeEnum.DEFAULTTYPE);
        return info;
    }

    private PurchaseOrgUnitInfo getDefaultPurchaseOrgUnit(CompanyOrgUnitInfo companyOrgUnitInfo) throws EASBizException, BOSException {
        PurchaseOrgUnitInfo currentPurOrgUnit;
        if (companyOrgUnitInfo == null) {
            return null;
        }
        OrgUnitInfo currentOrgUnit = (OrgUnitInfo)this.getContext().get((Object)OrgType.getEnum((int)1));
        if (currentOrgUnit != null && currentOrgUnit.isIsCompanyOrgUnit() && currentOrgUnit.getId().toString().equals(companyOrgUnitInfo.getId().toString()) && currentOrgUnit.isIsPurchaseOrgUnit() && (currentPurOrgUnit = (PurchaseOrgUnitInfo)this.getContext().get((Object)OrgType.getEnum((int)3))) != null && currentPurOrgUnit.isIsBizUnit()) {
            return currentPurOrgUnit;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        SorterItemInfo sorterItemInfo = new SorterItemInfo("number");
        sorterItemInfo.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sorterItemInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("isBizUnit"));
        OrgUnitCollection orgUnitColl = (OrgUnitCollection)OtherBillFactory.getLocalInstance(this.getContext()).getFromUnit(companyOrgUnitInfo.getId().toString(), 1, 3, viewInfo);
        int size = orgUnitColl.size();
        for (int i = 0; i < size; ++i) {
            if (!((PurchaseOrgUnitInfo)orgUnitColl.get(i)).isIsBizUnit()) continue;
            return (PurchaseOrgUnitInfo)orgUnitColl.get(i);
        }
        return null;
    }
}

