/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.app.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.APParamEnum;
import com.kingdee.eas.fi.ap.PayRequestBillCollection;
import com.kingdee.eas.fi.ap.PayRequestBillEntryCollection;
import com.kingdee.eas.fi.ap.PayRequestBillEntryInfo;
import com.kingdee.eas.fi.ap.PayRequestBillFactory;
import com.kingdee.eas.fi.ap.PayRequestBillInfo;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.ArApParamCache;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.fi.arap.app.web.BaseService;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.util.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class PayRequestBillService {
    public static final String STATUS_ADDNEW = "ADDNEW";
    public static final String STATUS_EDIT = "EDIT";
    public static final String STATUS_VIEW = "VIEW";
    public static final String STATUS_FINDVIEW = "FINDVIEW";
    private Context ctx;

    public PayRequestBillService(Context ctx) {
        this.ctx = ctx;
    }

    public Context getContext() {
        return this.ctx;
    }

    public Map<String, Object> getExchange(String excTableid, String basecurrencyid, String currencyid, String billDate) throws EASBizException, BOSException {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date bizDate = null;
        try {
            if (!StringUtils.isEmpty((String)billDate)) {
                bizDate = sf.parse(billDate);
            }
        }
        catch (ParseException e) {
            throw new BOSException((Throwable)e);
        }
        return this.getExchange(excTableid, basecurrencyid, currencyid, bizDate);
    }

    public Map<String, Object> getExchange(String excTableid, String basecurrencyid, String currencyid, Date billDate) throws EASBizException, BOSException {
        IExchangeRate iexchangRate = ExchangeRateFactory.getLocalInstance((Context)this.getContext());
        ObjectUuidPK excTablepk = new ObjectUuidPK(excTableid);
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(currencyid);
        ObjectUuidPK destCurrpk = new ObjectUuidPK(basecurrencyid);
        ExchangeRateInfo exgRateInfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, billDate);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("exchangeRateInfo", exgRateInfo);
        CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)this.getContext()).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyid));
        int exchangeprecision = currency.getPrecision();
        if (exgRateInfo != null) {
            exchangeprecision = exgRateInfo.getPrecision();
            if (exgRateInfo.getExchangeAux() != null) {
                exchangeprecision = exgRateInfo.getExchangeAux().getPrecision();
            }
        }
        result.put("precision", currency.getPrecision());
        result.put("exchangePrecision", exchangeprecision);
        boolean isDirectExchange = true;
        if (exgRateInfo != null && exgRateInfo.getExchangeAux() != null && exgRateInfo.getExchangeAux().getConvertMode().getValue() == 1) {
            isDirectExchange = false;
        }
        result.put("isDirectExchange", isDirectExchange);
        return result;
    }

    public Map<String, Object> getUIcache(String billId, String companyid, String status) throws EASBizException, BOSException {
        PayRequestBillInfo info = new PayRequestBillInfo();
        info.getEntrys().add(new PayRequestBillEntryInfo());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("billInfo", info);
        map.put("permissionItem", this.getPermissionItem(status));
        map.put("sysEnum", SystemEnum.ACCOUNTSPAYABLE);
        map.put("bosType", new PayRequestBillInfo().getBOSType());
        CompanyOrgUnitInfo company = null;
        if (!StringUtil.isEmpty((String)companyid)) {
            ObjectUuidPK pk = new ObjectUuidPK(companyid);
            company = CompanyOrgUnitFactory.getLocalInstance((Context)this.getContext()).getCompanyOrgUnitInfo((IObjectPK)pk);
        }
        ArApSysParamInfo result = ArApBillFacadeFactory.getLocalInstance((Context)this.getContext()).getSysParams(company, map);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("company", result.getCompany());
        params.put("cuid", result.getCUId());
        HashMap paramMap = result.getParamValueMap();
        boolean isPaySchedual = null == paramMap.get("AP_PAY_SCHEDUAL") ? false : "true".equals(paramMap.get("AP_PAY_SCHEDUAL"));
        boolean isPrePayAmoutCanOverOrder = null == paramMap.get(APParamEnum.ORDERPAYMENT.getValue()) ? false : "true".equals(paramMap.get(APParamEnum.ORDERPAYMENT.getValue()));
        params.put("isPaySchedual", isPaySchedual);
        params.put("isPrePayAmoutCanOverOrder", isPrePayAmoutCanOverOrder);
        params.put("asstActTypeColl", result.getAsstActTypeColl().toArray());
        params.put("baseCurrency", result.getBaseCurrency());
        params.put("isImportBillModifiable", result.isImportBillModifiable());
        String currentAccountTableID = result.getCurrentAccountTableID();
        params.put("currentAccountTableID", currentAccountTableID);
        params.put("purchaseOrgfilter", this.getOrgFilterByCompany(companyid, 3));
        params.put("adminfilter", this.getOrgFilterByCompany(companyid, 0));
        params.put("asstActTypefilter", this.getAsstActType(companyid));
        params.put("costCenterfilter", this.getOrgFilterByCompany(companyid, 5));
        params.put("projectfilter", this.getProjectFilter(companyid));
        params.put("tracknumberfilter", this.getTracknumberFilter(companyid));
        info = null;
        if (!StringUtils.isEmpty((String)billId)) {
            FilterInfo filter = new FilterInfo();
            FilterItemCollection filterItemCol = filter.getFilterItems();
            filterItemCol.add(new FilterItemInfo("id", (Object)billId, CompareType.EQUALS));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("company.id");
            sic.add("currency.id");
            sic.add("entrys.id");
            sic.add("entrys.asstActType.id");
            sic.add("entrys.asstActType.asstHGAttribute");
            sic.add("entrys.asstActID");
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            evi.setSelector(sic);
            PayRequestBillCollection col = PayRequestBillFactory.getLocalInstance(this.ctx).getPayRequestBillCollection(evi);
            if (col != null && col.size() > 0) {
                info = col.get(0);
            }
        }
        String currencyId = info != null ? info.getCurrency().getId().toString() : result.getBaseCurrency().getId().toString();
        BaseService bs = new BaseService(this.ctx);
        params.put("contrastAccountF7", bs.getContrastAccountF7(companyid, 13, currencyId, currentAccountTableID, result.getBaseCurrency().getId().toString(), result.getCompany().getAccountTable().getId().toString()));
        params.put("entrysConfig", this.getEntryConfig(info));
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)this.ctx);
        OrgUnitCollection profitCollection = iOrgUnitRelation.getFromUnit(companyid, 1, 6);
        StringBuilder sqlIDs = new StringBuilder();
        if (profitCollection != null && profitCollection.size() > 0) {
            for (int i = 0; i < profitCollection.size(); ++i) {
                OrgUnitInfo orgUnitInfo = profitCollection.get(i);
                if ("".equals(sqlIDs.toString())) {
                    sqlIDs.append("'").append(orgUnitInfo.getId().toString()).append("'");
                    continue;
                }
                sqlIDs.append(",'").append(orgUnitInfo.getId().toString()).append("'");
            }
        }
        params.put("profitCenterFilterIds", sqlIDs.toString());
        HashMap<String, ObjectUuidPK> keyMap = new HashMap<String, ObjectUuidPK>();
        ObjectUuidPK companyPK = new ObjectUuidPK(companyid);
        keyMap.put("AR_039", companyPK);
        keyMap.put(APParamEnum.ORDERPAYMENT.getValue(), companyPK);
        HashMap paramValueMap = ParamControlFactory.getLocalInstance((Context)this.ctx).getParamHashMap(keyMap);
        params.put("paramValue", paramValueMap);
        return params;
    }

    private Map getEntryConfig(PayRequestBillInfo info) throws EASBizException, BOSException {
        if (info == null) {
            return null;
        }
        HashMap result = new HashMap();
        HashMap<String, String> config = null;
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItemCol = filter.getFilterItems();
        String companyId = info.getCompany().getId().toString();
        PayRequestBillEntryCollection entrys = info.getEntrys();
        PayRequestBillEntryInfo entry = null;
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            entry = entrys.get(i);
            config = new HashMap<String, String>();
            result.put(entry.getId().toString(), config);
            filter = new FilterInfo();
            filterItemCol = filter.getFilterItems();
            boolean isSetFilter = false;
            AsstActTypeInfo asstActTypeInfo = entry.getAsstActType();
            String asstActId = entry.getAsstActID();
            if (asstActTypeInfo != null) {
                String mappingFieldName = asstActTypeInfo.getAsstHGAttribute();
                if (mappingFieldName.equals("customer")) {
                    CustomerInfo customer;
                    if (!StringUtil.isEmpty((String)asstActId) && !(customer = CustomerFactory.getLocalInstance((Context)this.ctx).getCustomerInfo("select id, isInternalCompany where id = '" + asstActId + "'")).isIsInternalCompany()) {
                        isSetFilter = true;
                        filterItemCol.add(new FilterItemInfo("customer.id", (Object)asstActId));
                        filterItemCol.add(new FilterItemInfo("companyOrgUnit.id", (Object)companyId));
                        config.put("accountBankQuery", "com.kingdee.eas.basedata.master.cssp.app.F7CustomerCompanyInfoBankQuery");
                        config.put("accountBankFilter", filter.toString());
                        config.put("accountBankDisplayFormat", "bankAccount");
                    }
                } else if (mappingFieldName.equals("provider")) {
                    SupplierInfo supplier;
                    if (!StringUtil.isEmpty((String)asstActId) && !(supplier = SupplierFactory.getLocalInstance((Context)this.ctx).getSupplierInfo("select id, isInternalCompany where id = '" + asstActId + "'")).isIsInternalCompany()) {
                        isSetFilter = true;
                        filterItemCol.add(new FilterItemInfo("supplier.id", (Object)asstActId));
                        filterItemCol.add(new FilterItemInfo("companyOrgUnit.id", (Object)companyId));
                        config.put("accountBankQuery", "com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyInfoBankQuery");
                        config.put("accountBankFilter", filter.toString());
                        config.put("accountBankDisplayFormat", "bankAccount");
                    }
                } else if (mappingFieldName.equals("person")) {
                    isSetFilter = true;
                    config.put("accountBankQuery", "com.kingdee.eas.basedata.master.cssp.app.F7CustomerCompanyInfoBankQuery");
                    filterItemCol.add(new FilterItemInfo("customer.id", (Object)"1"));
                    config.put("accountBankFilter", filter.toString());
                    config.put("accountBankDisplayFormat", "bankAccount");
                }
            }
            if (isSetFilter) continue;
            config.put("accountBankQuery", "com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
            config.put("accountBankFilter", null);
            config.put("accountBankDisplayFormat", "bankAccountNumber");
        }
        return result;
    }

    private String getProjectFilter(String companyid) throws EASBizException, BOSException {
        BaseService f7Service = new BaseService(this.getContext());
        return f7Service.getProjectF7Filer(companyid);
    }

    private String getTracknumberFilter(String companyid) throws EASBizException, BOSException {
        BaseService f7Service = new BaseService(this.getContext());
        return f7Service.getTrackNumberF7Filer(companyid, null);
    }

    public String getOrgFilterByCompany(String companyid, int orgType) throws EASBizException, BOSException {
        OrgUnitInfo info = null;
        FilterInfo filter = new FilterInfo();
        if (!StringUtil.isEmpty((String)companyid)) {
            IOrgUnitRelation iUtilRel = OrgUnitRelationFactory.getLocalInstance((Context)this.getContext());
            OrgUnitCollection toUnit = iUtilRel.getFromUnit(companyid, 1, orgType);
            HashSet<String> set = new HashSet<String>();
            set.add("null");
            int size = toUnit.size();
            for (int i = 0; i < size; ++i) {
                info = toUnit.get(i);
                set.add(info.getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        }
        return filter.toString();
    }

    private String getAsstActType(String companyid) throws EASBizException, BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem1 = new FilterItemInfo("isAccountCussent", (Object)Boolean.TRUE);
        FilterItemInfo filterItem2 = new FilterItemInfo("company.id", (Object)companyid);
        filter.getFilterItems().add(filterItem1);
        filter.getFilterItems().add(filterItem2);
        ev.getSelector().add("asstActType.id");
        ev.setFilter(filter);
        AsstActTypeDefaultCollection asstActTypeColl = AsstActTypeDefaultFactory.getLocalInstance((Context)this.getContext()).getAsstActTypeDefaultCollection(ev);
        filter = new FilterInfo();
        HashSet<String> set = new HashSet<String>();
        int size = asstActTypeColl.size();
        for (int i = 0; i < size; ++i) {
            set.add(asstActTypeColl.get(i).getAsstActType().getId().toString());
        }
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        return filter.toString();
    }

    protected String getPermissionItem(String status) {
        if (STATUS_ADDNEW.equals(status)) {
            return "PRBill_Addnew";
        }
        if (STATUS_EDIT.equals(status)) {
            return "PRBill_Edit";
        }
        if (STATUS_VIEW.equals(status) || STATUS_FINDVIEW.equals(status)) {
            return "PRBill_View";
        }
        return "PRBill_Addnew";
    }

    public Map<String, Object> handlePersonChange(String personId) throws BOSException, EASBizException {
        AdminOrgUnitInfo info = null;
        EntityViewInfo viewIn = new EntityViewInfo();
        FilterInfo filterIn = new FilterInfo();
        filterIn.getFilterItems().add(new FilterItemInfo("person", (Object)personId));
        filterIn.getFilterItems().add(new FilterItemInfo("isPrimary", (Object)Boolean.TRUE));
        viewIn.setFilter(filterIn);
        SelectorItemCollection selectorAdmin = new SelectorItemCollection();
        selectorAdmin.add(new SelectorItemInfo("position.adminOrgUnit.id"));
        selectorAdmin.add(new SelectorItemInfo("position.adminOrgUnit.number"));
        selectorAdmin.add(new SelectorItemInfo("position.adminOrgUnit.name"));
        viewIn.setSelector(selectorAdmin);
        IPositionMember iPositionMember = PositionMemberFactory.getLocalInstance((Context)this.ctx);
        PositionMemberCollection positionColl = iPositionMember.getPositionMemberCollection(viewIn);
        if (positionColl.size() > 0) {
            info = positionColl.get(0).getPosition().getAdminOrgUnit();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("adminOrgUnitInfo", info);
        return result;
    }

    public List getCombAsstActTypeItem(String companyid) throws BOSException {
        ArApParamCache cache = new ArApParamCache(this.ctx, companyid, SystemEnum.ACCOUNTSPAYABLE);
        try {
            cache.cacheAsstActType();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        AsstActTypeCollection asstActTypeCollection = cache.getAsstActTypeInfos();
        ArrayList items = new ArrayList();
        AsstActTypeInfo defaultAsstActType = cache.getDefaultAsstActType();
        for (int i = 0; i < asstActTypeCollection.size(); ++i) {
            HashMap<String, String> item = new HashMap<String, String>();
            AsstActTypeInfo asstActTypeInfo = asstActTypeCollection.get(i);
            BOSUuid id = asstActTypeInfo.getId();
            if (defaultAsstActType != null && id.equals((Object)defaultAsstActType.getId())) {
                item.put("selected", "1");
            }
            item.put("value", id.toString());
            item.put("alias", asstActTypeInfo.getName());
            item.put("id", id.toString());
            item.put("realtionDataObject", asstActTypeInfo.getRealtionDataObject());
            item.put("defaultQueryName", asstActTypeInfo.getDefaultQueryName());
            items.add(item);
        }
        HashMap<String, String> item = new HashMap<String, String>();
        item.put("value", "");
        item.put("alias", FMSysDefinedEnum.OTHER.getAlias());
        item.put("id", "");
        items.add(item);
        return items;
    }
}

