/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.app.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.ap.PayRequestBillEntryInfo;
import com.kingdee.eas.fi.ap.PayRequestBillInfo;
import com.kingdee.eas.fi.ap.PayRequestSumEntryInfo;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.arap.app.web.BillCreateService;
import com.kingdee.eas.fi.cas.IPaymentBillType;
import com.kingdee.eas.fi.cas.PaymentBillTypeCollection;
import com.kingdee.eas.fi.cas.PaymentBillTypeFactory;
import com.kingdee.eas.fi.cas.PaymentBillTypeInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class PaymentReqBillCreateService
extends BillCreateService {
    public PaymentReqBillCreateService(Context context) {
        super(context);
    }

    @Override
    public int getOrgType() {
        return 1;
    }

    @Override
    public String getPermissionItem() {
        return "PRBill_Addnew";
    }

    @Override
    public CoreBillBaseInfo createDefaultBill(OrgUnitInfo mainOrg, Map otherInformation) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)mainOrg;
        PayRequestBillInfo objectValue = new PayRequestBillInfo();
        ObjectUuidPK companypk = new ObjectUuidPK(company.getId().toString());
        SelectorItemCollection selectorCol = new SelectorItemCollection();
        selectorCol.add("*");
        selectorCol.add("CU.id");
        selectorCol.add("CU.number");
        selectorCol.add("CU.name");
        selectorCol.add("CU.code");
        selectorCol.add("CU.longNumber");
        selectorCol.add("baseCurrency.precision");
        selectorCol.add("baseCurrency.id");
        selectorCol.add("baseCurrency.name");
        selectorCol.add("baseCurrency.number");
        company = CompanyOrgUnitFactory.getLocalInstance((Context)this.getContext()).getCompanyOrgUnitInfo((IObjectPK)companypk, selectorCol);
        objectValue.setCompany(company);
        objectValue.setCU(company.getCU());
        ObjectUuidPK currencypk = new ObjectUuidPK(company.getBaseCurrency().getId().toString());
        CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)this.getContext()).getCurrencyInfo((IObjectPK)currencypk);
        objectValue.setCurrency(currency);
        objectValue.setExchange_rate(new BigDecimal("1.00"));
        Date date = new Date();
        objectValue.setBizDate(date);
        objectValue.setBillStatus(BillStatusEnum.SAVE);
        UserInfo creator = new UserInfo();
        creator.setId(BOSUuid.read((String)this.getContext().getCaller().toString()));
        objectValue.setCreateTime(new Timestamp(date.getTime()));
        creator = UserFactory.getLocalInstance((Context)this.getContext()).getUserInfo(" select id,name ,number,person.id,person.name where id = '" + this.getContext().getCaller().toString() + "'");
        objectValue.setApplyer(creator.getPerson());
        objectValue.put("id", BOSUuid.create((String)"D001019A"));
        objectValue.setCreator(creator);
        HashMap<String, ObjectUuidPK> keyMap = new HashMap<String, ObjectUuidPK>();
        ObjectUuidPK companyPK = new ObjectUuidPK(company.getId().toString());
        keyMap.put("AP_PAY_SCHEDUAL", companyPK);
        IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)this.getContext());
        HashMap paramMap = iParamControl.getParamHashMap(keyMap);
        if (paramMap != null && paramMap.containsKey("AP_PAY_SCHEDUAL")) {
            objectValue.setIsPaySchedule("true".equals(paramMap.get("AP_PAY_SCHEDUAL")));
        }
        return objectValue;
    }

    public CoreBillEntryBaseInfo createBillEntry(String companyid) throws EASBizException, BOSException {
        PayRequestBillEntryInfo entryInfo = new PayRequestBillEntryInfo();
        entryInfo.setAsstActType(this.getAsstActType(companyid));
        entryInfo.setPayType(this.getPaymentType());
        entryInfo.setPayDay(new Date());
        entryInfo.setPayableDate(new Date());
        entryInfo.setTotalPayAmt(SysConstant.BIGZERO);
        return entryInfo;
    }

    public CoreBillEntryBaseInfo createSumEntry(String companyid) throws EASBizException, BOSException {
        PayRequestSumEntryInfo entryInfo = new PayRequestSumEntryInfo();
        entryInfo.setAsstActType(this.getAsstActType(companyid));
        entryInfo.setPayType(this.getPaymentType());
        entryInfo.setPayableDate(new Date());
        entryInfo.setPayedAmt(SysConstant.BIGZERO);
        entryInfo.setUnpayAmount(SysConstant.BIGZERO);
        entryInfo.setLockAmount(SysConstant.BIGZERO);
        entryInfo.setLockAmountLoc(SysConstant.BIGZERO);
        entryInfo.setReqPayAmount(SysConstant.BIGZERO);
        entryInfo.setUnLockAmount(SysConstant.BIGZERO);
        entryInfo.setUnLockAmountLoc(SysConstant.BIGZERO);
        entryInfo.setAuditAmount(SysConstant.BIGZERO);
        entryInfo.setAuditAmountLoc(SysConstant.BIGZERO);
        return entryInfo;
    }

    private AsstActTypeInfo getAsstActType(String companyid) throws EASBizException, BOSException {
        AsstActTypeInfo info = null;
        AsstActTypeInfo oldInfo = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem1 = new FilterItemInfo("isAccountCussent", (Object)Boolean.TRUE);
        FilterItemInfo filterItem2 = new FilterItemInfo("company.id", (Object)companyid);
        filter.getFilterItems().add(filterItem1);
        filter.getFilterItems().add(filterItem2);
        ev.getSelector().add("*");
        ev.getSelector().add("asstActType.*");
        ev.setFilter(filter);
        AsstActTypeDefaultCollection asstActTypeColl = AsstActTypeDefaultFactory.getLocalInstance((Context)this.getContext()).getAsstActTypeDefaultCollection(ev);
        info = asstActTypeColl.get(0).getAsstActType();
        int size = asstActTypeColl.size();
        for (int i = 0; i < size; ++i) {
            oldInfo = asstActTypeColl.get(i).getAsstActType();
            if (!oldInfo.getRealtionDataObject().equals("T_BD_Supplier")) continue;
            info = oldInfo;
            break;
        }
        return info;
    }

    private PaymentBillTypeInfo getPaymentType() throws BOSException, EASBizException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"201", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("sourceSysType", (Object)new Integer(SourceTypeEnum.AP.getValue())));
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
        IPaymentBillType iPaymentBillType = PaymentBillTypeFactory.getLocalInstance((Context)this.getContext());
        PaymentBillTypeCollection coll = iPaymentBillType.getPaymentBillTypeCollection(ev);
        if (coll.size() < 0) {
            filter.remove("number");
            ev.setFilter(filter);
            coll = iPaymentBillType.getPaymentBillTypeCollection(ev);
        }
        PaymentBillTypeInfo info = coll.get(0);
        return info;
    }
}

