/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.ArApConstants;
import com.kingdee.eas.fi.arap.app.util.RecPayServiceUtil;
import com.kingdee.eas.fi.arap.app.writeback.handler.BizActionEnum;
import com.kingdee.eas.fi.arap.app.writeback.handler.BizSceneEnum;
import com.kingdee.eas.fi.arap.app.writeback.handler.IWriteBackHandler;
import com.kingdee.eas.fi.arap.app.writeback.handler.WriteBackFactory;
import com.kingdee.eas.fi.cas.BillDisposerAction;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.IReceivingBill;
import com.kingdee.eas.fi.cas.IReceivingDisposer;
import com.kingdee.eas.fi.cas.RecPayBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillCollection;
import com.kingdee.eas.fi.cas.ReceivingBillEntryCollection;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.utils.ArApSelectorFactory;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;

public class ArRefundBillDisposer
implements IReceivingDisposer {
    public BigDecimal getCashRebate(Date billDate, BigDecimal apAmount, String srcBillId, String srcBillEntryId) {
        return null;
    }

    public void dispose(Context ctx, BillDisposerAction action) throws BOSException, EASBizException {
        ReceivingBillInfo info = (ReceivingBillInfo)action.getDestBill();
        if (!SourceTypeEnum.AR.equals((Object)info.getSourceType())) {
            return;
        }
        DisposerActionEnum actionType = action.getActionType();
        if (DisposerActionEnum.REC.equals((Object)actionType)) {
            this.dispose4Rec(ctx, info);
        }
        if (DisposerActionEnum.DELETE.equals((Object)actionType)) {
            this.dispose4Delete(ctx, info);
        } else if (DisposerActionEnum.CANCEL_REC.equals((Object)actionType)) {
            this.dispose4CancelRec(ctx, info);
        }
        if ((DisposerActionEnum.REC.equals((Object)actionType) || DisposerActionEnum.CANCEL_REC.equals((Object)actionType)) && !info.isIsTransBill()) {
            this.writeBackSrcBill4Refund(ctx, action);
        }
    }

    public void writeBackSrcBill4Refund(Context ctx, BillDisposerAction action) throws BOSException, EASBizException {
        DisposerActionEnum actionType = action.getActionType();
        BizActionEnum bizAction = DisposerActionEnum.REC.equals((Object)actionType) ? BizActionEnum.RECEIVE : BizActionEnum.CANCEL_RECEIVE;
        ReceivingBillInfo redRecInfo = (ReceivingBillInfo)action.getDestBill();
        boolean isPreRec = redRecInfo.getRecBillType().isIsPreRec();
        BizSceneEnum bizScene = isPreRec ? BizSceneEnum.PRE_RECPAY_SCENE : BizSceneEnum.RECPAY_SCENE;
        ArrayList<BOSObjectType> typeList = new ArrayList<BOSObjectType>();
        typeList.add(ArApConstants.SALECONTRACT_TYPE);
        typeList.add(ArApConstants.SALEORDER_TYPE);
        for (BOSObjectType type : typeList) {
            IWriteBackHandler handler = WriteBackFactory.getRefundWriteBackHandler(type);
            if (null == handler) continue;
            handler.handle(ctx, bizAction, bizScene, (IObjectValue)redRecInfo);
        }
    }

    public void dispose4Delete(Context ctx, ReceivingBillInfo recBillInfo) throws BOSException, EASBizException {
        if (!recBillInfo.isIsTransBill()) {
            RecPayServiceUtil.reverseRecPayLockAmt(ctx, (RecPayBillInfo)recBillInfo, true, BOTBillOperStateEnum.DELETE);
        }
    }

    private void dispose4Rec(Context ctx, ReceivingBillInfo destBill) throws BOSException, EASBizException {
        ArApBillFacadeFactory.getLocalInstance((Context)ctx).autoVerify4Refund((CoreBillBaseInfo)destBill);
    }

    private void dispose4CancelRec(Context ctx, ReceivingBillInfo destBill) throws BOSException, EASBizException {
        HashSet<String> billIdSet = new HashSet<String>();
        ReceivingBillEntryCollection payEntryCol = destBill.getEntries();
        for (int i = 0; i < payEntryCol.size(); ++i) {
            billIdSet.add(payEntryCol.get(i).getSourceBillId());
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = ArApSelectorFactory.getReceivingBillFullSelector((boolean)true);
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", billIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        IReceivingBill iReceivingBill = ReceivingBillFactory.getLocalInstance((Context)ctx);
        ReceivingBillCollection refundedBillCol = null;
        refundedBillCol = iReceivingBill.getReceivingBillCollection(view);
        if (refundedBillCol == null || refundedBillCol.size() == 0) {
            return;
        }
        ReceivingBillInfo receivingBillInfo = refundedBillCol.get(0);
        if (receivingBillInfo.isIsTransBill()) {
            return;
        }
    }
}

