/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;

public class CodingRuleHelper {
    public static void main(String[] args) {
    }

    public static boolean isAddView(ICodingRuleManager iCodingRuleManager, BillBaseInfo billInfo) throws CodingRuleException, EASBizException, BOSException {
        return iCodingRuleManager.isAddView((IObjectValue)billInfo, CodingRuleHelper.getCompanyId(billInfo));
    }

    public static boolean isAutoNumber(ICodingRuleManager iCodingRuleManager, BillBaseInfo billInfo) throws EASBizException, BOSException {
        return iCodingRuleManager.isExist((IObjectValue)billInfo, CodingRuleHelper.getCompanyId(billInfo));
    }

    public static String getCodeRuleClient(ICodingRuleManager iCodingRuleManager, BillBaseInfo billInfo) throws CodingRuleException, EASBizException, BOSException {
        String sysNumber = null;
        String companyID = billInfo.getCompany().getId().toString();
        if (iCodingRuleManager.isExist((IObjectValue)billInfo, companyID)) {
            sysNumber = iCodingRuleManager.isUseIntermitNumber((IObjectValue)billInfo, companyID) ? iCodingRuleManager.readNumber((IObjectValue)billInfo, companyID) : iCodingRuleManager.getNumber((IObjectValue)billInfo, companyID);
        }
        return sysNumber;
    }

    public static String getNumberFromCodeRule(ICodingRuleManager iCodingRuleManager, BillBaseInfo billInfo) throws CodingRuleException, EASBizException, BOSException {
        String sysNumber = null;
        String companyID = iCodingRuleManager.getCurrentAppOUID((IObjectValue)billInfo);
        if (iCodingRuleManager.isExist((IObjectValue)billInfo, companyID)) {
            sysNumber = iCodingRuleManager.getNumber((IObjectValue)billInfo, companyID);
        }
        return sysNumber;
    }

    public static boolean recycleNumber(CoreBillBaseInfo coreBillInfo, ICodingRuleManager iCodingRuleManager) throws CodingRuleException, EASBizException, BOSException {
        String companyID = iCodingRuleManager.getCurrentAppOUID((IObjectValue)coreBillInfo);
        if (iCodingRuleManager.isExist((IObjectValue)coreBillInfo, companyID) && iCodingRuleManager.isUseIntermitNumber((IObjectValue)coreBillInfo, companyID)) {
            iCodingRuleManager.recycleNumber((IObjectValue)coreBillInfo, companyID, coreBillInfo.getNumber());
            return true;
        }
        return false;
    }

    private static String getCompanyId(BillBaseInfo billInfo) {
        CompanyOrgUnitInfo companyInfo = billInfo.getCompany();
        return companyInfo.getId().toString();
    }
}

