/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.BizBalanceException;
import com.kingdee.eas.common.BizCheckResult;
import com.kingdee.eas.common.BizHasDealException;
import com.kingdee.eas.common.BizReferenceException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.IBizCheckBalance;
import com.kingdee.eas.common.app.IBizHasDeal;
import com.kingdee.eas.common.app.IBizReference;
import com.kingdee.eas.fi.ar.ContrastAccountViewInfo;
import com.kingdee.eas.fi.ar.app.util.CommonServerUtils;
import com.kingdee.eas.fi.gl.GLBaseDataCheckException;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;

public class ARAPAccountCheckBalance
implements IBizCheckBalance,
IBizReference,
IBizHasDeal {
    public static final String RT = " \r\n ";

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BizCheckResult checkHasBalance(Context ctx, BOSUuid id) throws BizBalanceException {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        block5: {
            BizCheckResult bizCheckResult;
            con = null;
            pstmt = null;
            rs = null;
            String strAcct = ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"Account", (Locale)ctx.getLocale());
            try {
                con = CommonServerUtils.getConnection(ctx);
                StringBuffer sql = new StringBuffer();
                sql.append("select 1 where exists ").append("\r\n");
                sql.append("(select * ").append("\r\n");
                sql.append(" from t_ar_arbalancecollate ").append("\r\n");
                sql.append(" where FAccountID = ? ").append("\r\n");
                sql.append(" and (").append("\r\n");
                sql.append("fbeginbalancefor <> 0,").append("\r\n");
                sql.append("fdebitfor <> 0,").append("\r\n");
                sql.append("fcreditfor <> 0,").append("\r\n");
                sql.append("fyeardebitfor <> 0,").append("\r\n");
                sql.append("fyearcreditfor <> 0,").append("\r\n");
                sql.append("fendbalancefor <> 0,").append("\r\n");
                sql.append("fbeginbalancelocal <> 0,").append("\r\n");
                sql.append("fdebitlocal <> 0,").append("\r\n");
                sql.append("fcreditlocal <> 0,").append("\r\n");
                sql.append("fyeardebitlocal <> 0,").append("\r\n");
                sql.append("fyearcreditlocal <> 0,").append("\r\n");
                sql.append("fendbalancelocal <> 0").append("\r\n");
                sql.append(")").append("\r\n");
                sql.append(")").append("\r\n");
                pstmt = con.prepareStatement(sql.toString());
                int index = 1;
                pstmt.setString(index, id.toString());
                rs = pstmt.executeQuery();
                if (!rs.next()) break block5;
                bizCheckResult = new BizCheckResult(true, (EASBizException)new GLBaseDataCheckException(GLBaseDataCheckException.HAS_INITACCTBAL, new Object[]{strAcct}));
            }
            catch (SQLException sqle) {
                try {
                    throw new BizBalanceException(BizBalanceException.SQL_ERR, (Throwable)sqle);
                    catch (BOSException sqle2) {
                        throw new BizBalanceException(BizBalanceException.SQL_ERR, (Throwable)sqle2);
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, pstmt, (Connection)con);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)con);
            return bizCheckResult;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return new BizCheckResult(false);
    }

    public BizCheckResult checkReferenced(Context ctx, BOSUuid id) throws BizReferenceException {
        return new BizCheckResult(false);
    }

    public BizCheckResult checkHasDeal(Context ctx, BOSUuid id) throws BizHasDealException {
        boolean isEnabled = true;
        try {
            isEnabled = this.isEnbale(ctx, id);
        }
        catch (BOSException e) {
            throw new BizHasDealException(BizBalanceException.SQL_ERR, (Throwable)e);
        }
        String acrefid = id.toString();
        String companyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        if (isEnabled) {
            return this.enableHasDeal(ctx, companyID, acrefid);
        }
        return this.disenableHasDeal(ctx, companyID, acrefid);
    }

    private boolean isEnbale(Context ctx, BOSUuid id) throws BOSException {
        String sql = "select fisenabled from t_bd_acctrefcontrast where fid=? ";
        try {
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id.toString()});
            if (set != null && set.next()) {
                return set.getBoolean("fisenabled");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    public BizCheckResult enableHasDeal(Context ctx, String companyID, String acrefid) throws BizHasDealException {
        StringBuilder sql = new StringBuilder(200);
        sql.append("select period.FNumber from t_bd_systemstatusctrol ctrl").append(RT).append(" inner join t_bd_systemstatus status on ctrl.fsystemstatusid=status.fid").append(RT).append(" inner join t_org_company com on com.fid=ctrl.fcompanyid").append(RT).append(" INNER JOIN T_BD_Period period on ctrl.fcurrentperiodid = period.FID").append(RT).append(" where status.fname=").append(6).append(RT).append(" and com.fid=? and com.FisBizUnit=1");
        try {
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID});
            int glPeriod = 0;
            if (set.next()) {
                glPeriod = set.getInt(1);
            }
            sql.setLength(0);
            sql.append(" select com.fid as comid, com.faccounttableid, fcurrentperiodid, acref.FEnabledAcctTableID as FEnabledAcctTableID,status.fname as FSystem").append(RT).append(" from t_bd_systemstatusctrol ctrl ").append(RT).append(" inner join t_bd_systemstatus status on ctrl.fsystemstatusid=status.fid").append(RT).append(" inner join t_org_company com on com.fid=ctrl.fcompanyid").append(RT).append(" inner join T_BD_AcctRefContrast acref on acref.FdisabledAcctTableID=com.faccounttableid").append(RT).append(" where (status.fname=").append(12).append(" or status.fname=").append(13).append(") ").append(RT).append(" and com.fid=? and acref.fid=? and com.FisBizUnit=1");
            set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyID, acrefid});
            int systemValue = 0;
            boolean isAr = false;
            while (set != null && set.next()) {
                String comid = set.getString("comid");
                String newAccountid = set.getString("faccounttableid");
                String enabledAcctTableID = set.getString("FEnabledAcctTableID");
                int system = set.getInt("FSystem");
                if (StringUtils.isEmpty((String)newAccountid)) continue;
                if (system == 12) {
                    systemValue = 1;
                    isAr = true;
                } else {
                    systemValue = 2;
                    isAr = false;
                }
                this.updateContrastAccount(ctx, comid, acrefid, enabledAcctTableID, systemValue, glPeriod);
                ARAPAccountCheckBalance.updateAccountBalance(ctx, comid, acrefid, glPeriod, isAr);
            }
        }
        catch (BOSException e) {
            throw new BizHasDealException(BizBalanceException.SQL_ERR, (Throwable)e);
        }
        catch (SQLException e) {
            throw new BizHasDealException(BizBalanceException.SQL_ERR, (Throwable)e);
        }
        catch (EASBizException e) {
            throw new BizHasDealException(new NumericExceptionSubItem(e.getCode(), e.getMessage()), (Throwable)e);
        }
        return new BizCheckResult(false);
    }

    public BizCheckResult disenableHasDeal(Context ctx, String companyID, String acrefid) throws BizHasDealException {
        try {
            if (acrefid != null && !"".equals(acrefid)) {
                this.deleteContrastAccount(ctx, companyID, acrefid);
                this.updateBadAcctParam(ctx, companyID, acrefid, false);
            }
        }
        catch (BOSException e) {
            throw new BizHasDealException(BizBalanceException.SQL_ERR, (Throwable)e);
        }
        catch (EASBizException e) {
            throw new BizHasDealException(new NumericExceptionSubItem(e.getCode(), e.getMessage()), (Throwable)e);
        }
        return new BizCheckResult(false);
    }

    public static void updateAccountBalance(Context ctx, String companyID, String refid, int glPeriod, boolean isAr) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)companyID) || StringUtils.isEmpty((String)refid)) {
            return;
        }
        String[] tableNameArr = null;
        tableNameArr = isAr ? new String[]{"T_AR_ArBalanceCollate", "T_AR_ArBillAccountBalance"} : new String[]{"T_AP_ApBalanceCollate", "T_AP_ApBillAccountBalance"};
        String[] updateSQLArray = new String[2];
        StringBuilder updateBuffer = new StringBuilder(200);
        String tableName = "";
        for (int i = 0; i < tableNameArr.length; ++i) {
            tableName = tableNameArr[i];
            updateBuffer.append(" UPDATE ").append(tableName).append(" AS t1 ").append(RT).append(" SET (FAccount) ").append(RT).append(" = (SELECT refContrastEntry.FNewAcctID ").append(RT).append(" FROM ").append(tableName).append(" AS t3 ").append(RT).append(" INNER JOIN T_BD_AcctRefContrastEntry AS refContrastEntry ").append(RT).append(" ON  t3.FAccount").append(" = refContrastEntry.FOldAcctID ").append(RT).append(" INNER JOIN T_BD_Period AS period ON  t3.FperiodID = period.FID ").append(RT).append(" WHERE t1.FID = t3.FID ").append(RT).append(" AND refContrastEntry.facctrefcontrastid = '").append(refid).append("'").append(RT).append(" AND t1.FCompanyID = '").append(companyID).append("'").append(RT).append(" AND period.FNumber > '").append(glPeriod).append("')");
            updateSQLArray[i] = updateBuffer.toString();
            updateBuffer.setLength(0);
        }
        KsqlUtil.executeBatch((Context)ctx, (String[])updateSQLArray);
    }

    private void updateContrastAccount(Context ctx, String orgunitid, String refid, String enabledAcctTableID, int system, int glPeriod) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder(200);
        sql.append(" update t_ar_contrastaccountview as t1 ").append(RT);
        sql.append(" set (faccountid,faccounttableid,fname_l1,fname_l2,fname_l3) = ( select ").append(RT);
        sql.append(" refContrastEntry.fnewacctid,'").append(enabledAcctTableID).append("',").append(RT);
        sql.append(" accountView.fname_l1,accountView.fname_l2,accountView.fname_l3 ").append(RT);
        sql.append(" FROM t_ar_contrastaccountview contrastAccountView ").append(RT);
        sql.append(" inner join T_BD_AcctRefContrastentry refContrastEntry ").append(RT);
        sql.append(" on contrastAccountView.faccountid = refContrastEntry.foldacctid ").append(RT);
        sql.append(" inner join T_BD_AccountView accountView ON refContrastEntry.fnewacctid = accountview.fid ").append(RT);
        int periodYear = glPeriod / 100;
        int periodNumber = glPeriod % 100;
        sql.append(" WHERE refContrastEntry.facctrefcontrastid = '").append(refid).append("'").append(RT);
        sql.append(" AND contrastAccountView.FCompanyID = '").append(orgunitid).append("'").append(RT);
        sql.append(" AND contrastAccountView.FSystem = ").append(system).append(RT);
        sql.append(" AND (contrastAccountView.FPeriodYear > ").append(periodYear).append(RT);
        sql.append(" OR (contrastAccountView.FPeriodYear = ").append(periodYear);
        sql.append(" AND contrastAccountView.FPeriodNumber > ").append(periodNumber).append(RT);
        sql.append(")) AND t1.fid = contrastAccountView.fid ");
        sql.append(" ) ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void updateContrastAccountOld(Context ctx, String orgunitid, String currentperiodid, String refid, String enabledAcctTableID, int system) throws BOSException, EASBizException {
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK periodPK = new ObjectUuidPK(currentperiodid);
        PeriodInfo periodInfo = iPeriod.getPeriodInfo((IObjectPK)periodPK);
        int periodYear = periodInfo.getPeriodYear();
        int periodNumber = periodInfo.getPeriodNumber();
        ContrastAccountViewInfo info = new ContrastAccountViewInfo();
        StringBuffer sql = new StringBuffer("");
        sql.append("INSERT INTO t_ar_contrastaccountview ( ").append(RT);
        sql.append("fid , ").append(RT);
        sql.append("fcreatorid, ").append(RT);
        sql.append("fcreatetime, ").append(RT);
        sql.append("flastupdateuserid, ").append(RT);
        sql.append("flastupdatetime, ").append(RT);
        sql.append("fcontrolunitid, ").append(RT);
        sql.append("fname_l1, ").append(RT);
        sql.append("fname_l2, ").append(RT);
        sql.append("fname_l3, ").append(RT);
        sql.append("fnumber, ").append(RT);
        sql.append("fdescription_l1, ").append(RT);
        sql.append("fdescription_l2, ").append(RT);
        sql.append("fdescription_l3, ").append(RT);
        sql.append("fsimplename, ").append(RT);
        sql.append("fcompanyid, ").append(RT);
        sql.append("fsystem, ").append(RT);
        sql.append("faccountid, ").append(RT);
        sql.append("FAsstActTypeID, ").append(RT);
        sql.append("fperiodyear, ").append(RT);
        sql.append("fperiodnumber, ").append(RT);
        sql.append("faccounttableid )").append(RT);
        sql.append(" SELECT newBosID('" + info.getBOSType().toString() + "') as FID, ").append(RT);
        sql.append("contrastAccountView.fcreatorid,").append(RT);
        sql.append("contrastAccountView.fcreatetime,").append(RT);
        sql.append("contrastAccountView.flastupdateuserid,").append(RT);
        sql.append("contrastAccountView.flastupdatetime,").append(RT);
        sql.append("contrastAccountView.fcontrolunitid,").append(RT);
        sql.append("contrastAccountView.fname_l1,").append(RT);
        sql.append("contrastAccountView.fname_l2,").append(RT);
        sql.append("contrastAccountView.fname_l3,").append(RT);
        sql.append("contrastAccountView.fnumber,").append(RT);
        sql.append("contrastAccountView.fdescription_l1,").append(RT);
        sql.append("contrastAccountView.fdescription_l2,").append(RT);
        sql.append("contrastAccountView.fdescription_l3,").append(RT);
        sql.append("contrastAccountView.fsimplename,").append(RT);
        sql.append("contrastAccountView.fcompanyid,").append(RT);
        sql.append("contrastAccountView.fsystem,").append(RT);
        sql.append("refContrastEntry.fnewacctid,").append(RT);
        sql.append("contrastAccountView.FAsstActTypeID,").append(RT);
        sql.append("contrastAccountView.fperiodyear, ").append(RT);
        sql.append("contrastAccountView.fperiodnumber, ").append(RT);
        sql.append("'").append(enabledAcctTableID).append("' ").append(RT);
        sql.append(" FROM t_ar_contrastaccountview contrastAccountView ").append(RT);
        sql.append(",T_BD_AcctRefContrastentry refContrastEntry ").append(RT);
        sql.append(" WHERE contrastAccountView.faccountid = refContrastEntry.foldacctid ").append(RT);
        sql.append(" AND refContrastEntry.facctrefcontrastid = '").append(refid).append("'").append(RT);
        sql.append(" AND contrastAccountView.FCompanyID = '").append(orgunitid).append("'").append(RT);
        sql.append(" AND contrastAccountView.FSystem = ").append(system);
        sql.append(" AND (contrastAccountView.fperiodyear > ").append(periodYear);
        sql.append(" or (contrastAccountView.fperiodyear = ").append(periodYear);
        sql.append(" and contrastAccountView.fperiodNumber >= ").append(periodNumber).append("))");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void deleteContrastAccount(Context ctx, String companyID, String refid) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select FEnabledAcctTableID as FEnabledAcctTableID,FDisabledAcctTableID from T_BD_AcctRefContrast \r\n ").append(" where fid=? \r\n");
        try {
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{refid});
            while (set != null && set.next()) {
                String enabledAcctTableID = set.getString("FEnabledAcctTableID");
                String disabledAcctTableID = set.getString("FDisabledAcctTableID");
                this.updateReverseContrastAccount(ctx, refid, companyID, enabledAcctTableID, disabledAcctTableID);
            }
        }
        catch (BOSException e) {
            throw new BizHasDealException(BizBalanceException.SQL_ERR, (Throwable)e);
        }
        catch (SQLException e) {
            throw new BizHasDealException(BizBalanceException.SQL_ERR, (Throwable)e);
        }
        catch (EASBizException e) {
            throw new BizHasDealException(new NumericExceptionSubItem(e.getCode(), e.getMessage()), (Throwable)e);
        }
    }

    private void updateReverseContrastAccount(Context ctx, String refid, String companyID, String enabledAccountTableID, String disabledAcctTableID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("");
        boolean dd = false;
        sql.append(" update t_ar_contrastaccountview as t1 ").append(RT);
        sql.append(" set (faccountid,faccounttableid,fname_l1,fname_l2,fname_l3) = ( select ").append(RT);
        sql.append(" refContrastEntry.foldacctid,'").append(disabledAcctTableID).append("',").append(RT);
        sql.append(" accountView.fname_l1,accountView.fname_l2,accountView.fname_l3 ").append(RT);
        sql.append(" FROM t_ar_contrastaccountview contrastAccountView ").append(RT);
        sql.append(" inner join T_BD_AcctRefContrastentry refContrastEntry ").append(RT);
        sql.append(" on contrastAccountView.faccountid = refContrastEntry.fnewacctid ").append(RT);
        sql.append(" inner join T_BD_AccountView accountView ON refContrastEntry.foldacctid = accountview.fid ").append(RT);
        sql.append(" WHERE refContrastEntry.facctrefcontrastid = '").append(refid).append("'").append(RT);
        sql.append(" AND contrastAccountView.FCompanyID = '").append(companyID).append("'").append(RT);
        sql.append(" AND contrastAccountView.FAccountTableID = '").append(enabledAccountTableID).append("'").append(RT);
        sql.append(" AND t1.fid = contrastAccountView.fid ");
        sql.append(" ) ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void updateBadAcctParam(Context ctx, String orgunitid, String refid, boolean isNew) throws BOSException, EASBizException {
        StringBuffer updateBuffer = new StringBuffer("");
        updateBuffer.append(" UPDATE t_bas_paramitem AS t1 ").append(RT);
        updateBuffer.append(" SET (FValue_L1,FIsModify)").append(RT);
        updateBuffer.append(" = (SELECT refContrastEntry.").append(isNew ? "FNewAcctID" : "FOldAcctID").append(",1 \r\t");
        updateBuffer.append(" FROM t_bas_paramitem AS t3  ").append(RT);
        updateBuffer.append(" INNER JOIN T_BD_AcctRefContrastEntry AS refContrastEntry  \r\n").append(RT);
        updateBuffer.append(" ON  t3.FValue_L1 = refContrastEntry.").append(isNew ? "FOldAcctID" : "FNewAcctID").append(RT);
        updateBuffer.append(" WHERE t1.FID = t3.FID \r\n");
        updateBuffer.append(" AND refContrastEntry.facctrefcontrastid = '").append(refid).append("'\r\n");
        if (orgunitid != null) {
            updateBuffer.append(" AND t1.forgunitid = '").append(orgunitid).append("'\r\n");
        }
        updateBuffer.append(" )");
        DbUtil.execute((Context)ctx, (String)updateBuffer.toString());
        StringBuffer updateBuffer1 = new StringBuffer("");
        updateBuffer1.append(" UPDATE t_bas_paramitem AS t1 ").append(RT);
        updateBuffer1.append(" SET (FValue_L2,FIsModify)").append(RT);
        updateBuffer1.append(" = (SELECT refContrastEntry.").append(isNew ? "FNewAcctID" : "FOldAcctID").append(",1 \r\t");
        updateBuffer1.append(" FROM t_bas_paramitem AS t3 ").append(RT);
        updateBuffer1.append(" INNER JOIN T_BD_AcctRefContrastEntry AS refContrastEntry  \r\n").append(RT);
        updateBuffer1.append(" ON  t3.FValue_L2 = refContrastEntry.").append(isNew ? "FOldAcctID" : "FNewAcctID").append(RT);
        updateBuffer1.append(" WHERE t1.FID = t3.FID \r\n");
        updateBuffer1.append(" AND refContrastEntry.facctrefcontrastid = '").append(refid).append("'\r\n");
        if (orgunitid != null) {
            updateBuffer1.append(" AND t1.forgunitid = '").append(orgunitid).append("'\r\n");
        }
        updateBuffer1.append(" )");
        DbUtil.execute((Context)ctx, (String)updateBuffer1.toString());
        StringBuffer updateBuffer2 = new StringBuffer("");
        updateBuffer2.append(" UPDATE t_bas_paramitem AS t1 ").append(RT);
        updateBuffer2.append(" SET (FValue_L3,FIsModify)").append(RT);
        updateBuffer2.append(" = (SELECT refContrastEntry.").append(isNew ? "FNewAcctID" : "FOldAcctID").append(",1 \r\t");
        updateBuffer2.append(" FROM t_bas_paramitem AS t3  \r\n").append(RT);
        updateBuffer2.append(" INNER JOIN T_BD_AcctRefContrastEntry AS refContrastEntry  \r\n").append(RT);
        updateBuffer2.append(" ON  t3.FValue_L3 = refContrastEntry.").append(isNew ? "FOldAcctID" : "FNewAcctID").append(RT);
        updateBuffer2.append(" WHERE t1.FID = t3.FID \r\n");
        updateBuffer2.append(" AND refContrastEntry.facctrefcontrastid = '").append(refid).append("'\r\n");
        if (orgunitid != null) {
            updateBuffer2.append(" AND t1.forgunitid = '").append(orgunitid).append("'\r\n");
        }
        updateBuffer2.append(" )");
        DbUtil.execute((Context)ctx, (String)updateBuffer2.toString());
        StringBuffer updateSalePercentBuffer = new StringBuffer("");
        updateSalePercentBuffer.append(" UPDATE T_AR_SaleIncomeParam AS t1 ").append(RT);
        updateSalePercentBuffer.append(" SET (FAccountID,FAROtherParamID)").append(RT);
        updateSalePercentBuffer.append(" = (SELECT refContrastEntry.").append(isNew ? "FNewAcctID" : "FOldAcctID").append(",t3.FAROtherParamID \r\t");
        updateSalePercentBuffer.append(" FROM T_AR_SaleIncomeParam AS t3  \r\n").append(RT);
        updateSalePercentBuffer.append(" INNER JOIN T_BD_AcctRefContrastEntry AS refContrastEntry  \r\n").append(RT);
        updateSalePercentBuffer.append(" ON  t3.FAccountID = refContrastEntry.").append(isNew ? "FOldAcctID" : "FNewAcctID").append(RT);
        updateSalePercentBuffer.append(" WHERE t1.FID = t3.FID \r\n");
        updateSalePercentBuffer.append(" AND refContrastEntry.facctrefcontrastid = '").append(refid).append("'\r\n");
        if (orgunitid != null) {
            updateSalePercentBuffer.append(" AND t3.FCompanyID = '").append(orgunitid).append("'\r\n");
        }
        updateSalePercentBuffer.append(" )");
        DbUtil.execute((Context)ctx, (String)updateSalePercentBuffer.toString());
        StringBuffer updateARBuffer = new StringBuffer("");
        updateARBuffer.append(" UPDATE T_AP_ApOtherParams AS t1 ").append(RT);
        updateARBuffer.append(" SET (FAccountID,FAROtherParamID)").append(RT);
        updateARBuffer.append(" = (SELECT refContrastEntry.").append(isNew ? "FNewAcctID" : "FOldAcctID").append(",t3.FAROtherParamID \r\t");
        updateARBuffer.append(" FROM T_AP_ApOtherParams AS t3  \r\n").append(RT);
        updateARBuffer.append(" INNER JOIN T_BD_AcctRefContrastEntry AS refContrastEntry  \r\n").append(RT);
        updateARBuffer.append(" ON  t3.FAccountID = refContrastEntry.").append(isNew ? "FOldAcctID" : "FNewAcctID").append(RT);
        updateARBuffer.append(" WHERE t1.FID = t3.FID \r\n");
        updateARBuffer.append(" AND refContrastEntry.facctrefcontrastid = '").append(refid).append("'\r\n");
        if (orgunitid != null) {
            updateARBuffer.append(" AND t3.FCompanyID = '").append(orgunitid).append("'\r\n");
        }
        updateARBuffer.append(" )");
        DbUtil.execute((Context)ctx, (String)updateARBuffer.toString());
    }
}

