/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.ap.OtherBillType;
import com.kingdee.eas.fi.ar.AccountAgeQueryParam;
import com.kingdee.eas.fi.ar.ArApCommonException;
import com.kingdee.eas.fi.ar.OtherBillTypeEnum;
import com.kingdee.eas.fi.ar.app.ArApReportHelper;
import com.kingdee.eas.fi.arap.util.CollectionUtil;
import com.kingdee.eas.framework.report.SimpleCompanyUserObject;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ArApAgingRptSqlHelper {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ar.app.ArApAgingRptSqlHelper");
    public static final String CRTL = " \r\n ";
    public static final String BASE_CURRENCY_COLS = " FBASECURRENCYID, FBASECURRPRECISION, FBASECURRNUM, FBASECURRENCY ";
    public static final String SQL = "SQL";
    public static final String SQL_PARAMS = "SqlParams";

    private ArApAgingRptSqlHelper() {
    }

    public static String getBillsSql(Context ctx, AccountAgeQueryParam param, String agedBillTable, String verifyAmtTbl, List entityCompIds) throws ArApCommonException {
        boolean fByBill = param.getAnalyseObjIndex() == 1;
        boolean isAgeByPlanDate = param.isAgeByPlanDate();
        StringBuilder sql = new StringBuilder(600);
        sql.append("insert into ").append(agedBillTable).append(CRTL);
        sql.append(" (FCompanyId, FAdminOrgId,FAsstActId, FAsstActTypeId,");
        sql.append(" FCurrencyId, FCompany, FParentCompanyId,");
        sql.append(" FCompLongNumber, FIsCompLeaf, FComplevel,").append(CRTL);
        sql.append(" FAdminOrgNumber, FAdminOrgName,").append(CRTL);
        sql.append(" FAsstActNumber, FCussAcct, FAsstActType,");
        sql.append(" FCurrPrecision, FCurrNum, FCurrency,").append(CRTL);
        sql.append(" FBillDate, FRecPayDate, FBizDate,FUnVerifyAmt, FBillId, FEntryId,").append(CRTL);
        sql.append(" FIsReversed, FIsTransBill");
        sql.append(!isAgeByPlanDate ? "" : ", FPlanId, FRecPayAmt");
        if (fByBill) {
            sql.append(", FBillType, FBillNum, FDescription");
        }
        sql.append(", FUnVerifyAmtLoc");
        sql.append(isAgeByPlanDate ? ", FRecPayAmtLoc" : "");
        sql.append(") \r\n select t1.FCompanyId, t1.FAdminOrgId FAdminOrgId,t1.FAsstActId FAsstActId,");
        sql.append(" t1.FAsstActTypeID, t1.FCurrencyId,\r\n");
        sql.append(" t1.FCompany, t1.FParentCompanyId, t1.FCompLongNumber,");
        sql.append(" t1.FIsCompLeaf, t1.FComplevel,\r\n");
        sql.append(" t1.FAdminOrgNumber, t1.FAdminOrgName,\r\n");
        sql.append(" t1.FAsstActNumber, t1.FCussAcct, t1.FAsstActType, ");
        sql.append(" t1.FCurrPrecision, t1.FCurrNum, t1.FCurrency, ");
        sql.append("\r\n t1.FBillDate FBillDate,");
        sql.append(" t1.FRecPayDate,t1.FBizDate FBizDate, t1.FUnVerifyAmt, t1.FBillId, t1.FEntryId,");
        sql.append(" t1.FIsReversed, t1.FIsTransBill");
        sql.append(!isAgeByPlanDate ? "" : ", t1.FPlanId, FRecPayAmt");
        if (fByBill) {
            sql.append(", t1.FBillType, t1.FBillNum FBillNum, ");
            sql.append(" t1.FDescription");
        }
        sql.append(", t1.FUnVerifyAmtLoc");
        sql.append(isAgeByPlanDate ? ", t1.FRecPayAmtLoc" : "");
        sql.append(" from \r\n (");
        int iDirIndex = param.getDirIndex();
        Date endDate = new Date(param.getEndDate().getTime());
        Date endNxtDay = new Date(endDate.getTime() + 86400000L);
        param.setEndDate(endNxtDay);
        if (iDirIndex == 0) {
            sql.append((CharSequence)ArApAgingRptSqlHelper.arapBillSql(ctx, param, verifyAmtTbl, entityCompIds));
        } else if (iDirIndex == 1) {
            sql.append((CharSequence)ArApAgingRptSqlHelper.recpayBillSql(ctx, param, verifyAmtTbl, entityCompIds));
        } else {
            sql.append((CharSequence)ArApAgingRptSqlHelper.arapBillSql(ctx, param, verifyAmtTbl, entityCompIds));
            sql.append(" \r\n union all \r\n ");
            sql.append((CharSequence)ArApAgingRptSqlHelper.recpayBillSql(ctx, param, verifyAmtTbl, entityCompIds));
        }
        param.setEndDate(endDate);
        sql.append(") t1 ");
        return sql.toString();
    }

    private static StringBuilder arapBillSql(Context ctx, AccountAgeQueryParam param, String verifyAmtTbl, List entityCompIds) throws ArApCommonException {
        boolean fByBill;
        boolean fAgeByPlanDate = param.isAgeByPlanDate();
        boolean fAR = param.isArRpt();
        Locale locale = ctx.getLocale();
        String nameFld = ArApReportHelper.getNameFld(ctx);
        String tbl = param.isArRpt() ? " T_AR_OtherBill" : " T_AP_OtherBill";
        StringBuilder sql = new StringBuilder(200);
        sql.append(" select t1.FCompanyId, t1.FAdminOrgUnitID FAdminOrgId,t1.FAsstActId, ");
        sql.append(" t1.FAsstActTypeId, t1.FCurrencyId,\r\n");
        sql.append(" t3.").append(nameFld);
        sql.append(" FCompany, t3.FLongNumber FCompLongNumber,");
        sql.append(" t3.FParentId FParentCompanyId,");
        sql.append(" t3.FIsLeaf FIsCompLeaf, t3.FLevel FComplevel,\r\n");
        sql.append(" t7.FNumber FAdminOrgNumber, t7.").append(nameFld).append(" FAdminOrgName,");
        sql.append(" t4.FNumber FAsstActNumber, t4.FName FCussAcct,");
        sql.append(" t5.").append(nameFld).append(" FAsstActType,");
        sql.append("\r\n t6.FPrecision FCurrPrecision, ");
        sql.append(" t6.FNumber FCurrNum, t6.");
        sql.append(nameFld).append(" FCurrency, ");
        sql.append("\r\n t1.FBillDate, ");
        if (fAgeByPlanDate) {
            sql.append("t2.FRecievePayDate FRecPayDate, t1.FBizDate FBizDate,");
            sql.append("(t2.FRecievePayAmount - t2.FVerifyAmount) FUnVerifyAmt").append(CRTL);
            sql.append(" , t1.FId FBillId, NULL FEntryId");
            sql.append(", (case when (t1.FIsReversed=1 or t1.FIsReverseBill=1) then 1 else t1.FIsReversed end) FIsReversed");
            sql.append(", t1.FIsTransBill FIsTransBill");
            sql.append(", t2.FId FPlanId, t2.FRecievePayAmount FRecPayAmt");
            sql.append(", (t2.FRecievePayAmountLocal - t2.FVerifyAmountLocal) FUnVerifyAmtLoc ");
            sql.append(", t2.FRecievePayAmountLocal FRecPayAmtLoc");
        } else {
            sql.append("t1.FBillDate FRecPayDate,  t1.FBizDate FBizDate,");
            sql.append(" t1.FUnVerifyAmount FUnVerifyAmt\r\n, t1.FId FBillId, NULL FEntryId");
            sql.append(", (case when (t1.FIsReversed=1 or t1.FIsReverseBill=1) then 1 else t1.FIsReversed end) FIsReversed");
            sql.append(", t1.FIsTransBill FIsTransBill");
            sql.append(", t1.FUnVerifyAmountLocal FUnVerifyAmtLoc");
        }
        boolean bl = fByBill = param.getAnalyseObjIndex() == 1;
        if (fByBill) {
            ArApAgingRptSqlHelper.appendArApBillTypeClause(locale, fAR, sql);
            sql.append("t1.FNumber FBillNum, ");
            sql.append(" t1.FAbstractName FDescription");
        }
        sql.append(" \r\n from ").append(tbl).append(" t1 ");
        if (fAgeByPlanDate) {
            sql.append("\r\n inner join ").append(tbl);
            sql.append("Plan t2 on t1.FId = t2.FParentId ");
        }
        sql.append("\r\n left join t_org_company t3 on t3.FId = t1.FCompanyId");
        sql.append("\r\n left join T_ORG_Admin t7 on t7.FId = t1.FAdminOrgUnitID");
        sql.append("\r\n inner join (select distinct * from ").append(param.getCussAcctTempTable()).append(") t4 on t4.FId = t1.FAsstActId");
        sql.append("\r\n left join t_bd_AsstActType t5 on t5.FId = t1.FAsstActTypeId");
        sql.append("\r\n left join t_bd_currency t6 on t6.FId = t1.FCurrencyId ");
        sql.append("\r\n where 1 = 1 ");
        if (param.isBizeCheckBox()) {
            if (param.getBizeIndex() == 1) {
                sql.append(" AND t1.FIsBizBill = 1");
            }
        } else {
            sql.append(" AND t1.FIsBizBill = 0");
        }
        if (param.isPaymentTypeCheckBox()) {
            if (param.getPaymentTypeIndex() == 1) {
                sql.append(" and t1.FPaymentTypeID = '" + (param.isArRpt() ? "cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5" : "40b75328-7f57-463f-8d19-280574ef24bf6BCA0AB5") + "' ");
            }
        } else {
            sql.append(" and t1.FPaymentTypeID = '" + (param.isArRpt() ? "91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5" : "2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5") + "' ");
        }
        sql.append(" and t1.FAsstActTypeID  = '");
        sql.append(param.getCussTypeId()).append("' ");
        if (!param.isAllCurrency()) {
            sql.append(" and t1.FCurrencyId = '");
            sql.append(param.getCurrencyId()).append("' ");
        }
        if (!param.isEndDateBal()) {
            sql.append(" and t1.FUnVerifyAmount <> 0 ");
        } else {
            sql.append(" AND (t1.FUnVerifyAmount <> 0 OR (");
            sql.append(" t1.FUnVerifyAmount = 0 AND EXISTS (");
            sql.append("SELECT 1 FROM ").append(verifyAmtTbl).append(" tVerify");
            sql.append(" WHERE t1.FID = tVerify.FBillId");
            sql.append(")))");
        }
        sql.append(" and t1.FBillStatus = ");
        sql.append(3);
        sql.append("\r\n and t1.FCompanyId in (");
        sql.append(CollectionUtil.ids2SqlString(entityCompIds));
        sql.append(") ");
        SimpleDateFormat dtFormat = new SimpleDateFormat("yyyy-MM-dd");
        sql.append("\r\n and t1.FBillDate >= {");
        sql.append(dtFormat.format(param.getBeginDate()));
        sql.append("} and t1.FBillDate < {");
        sql.append(dtFormat.format(param.getEndDate()));
        sql.append("} ");
        if (!StringUtils.isEmpty((String)param.getAdminOrgId()) || param.getBoolean("isJoinQuery")) {
            if (!StringUtils.isEmpty((String)param.getAdminOrgId())) {
                sql.append("\r\n and t1.FAdminOrgUnitId = '");
                sql.append(param.getAdminOrgId()).append("' ");
            } else {
                sql.append("\r\n and t1.FAdminOrgUnitId is null");
            }
        } else {
            List adminIds = param.getAdminOrgIds();
            if (adminIds != null && adminIds.size() > 0) {
                sql.append("\r\n and t1.FAdminOrgUnitId in (");
                sql.append(CollectionUtil.toSqlString(adminIds));
                sql.append(") ");
            }
        }
        if (!StringUtils.isEmpty((String)param.getSalesId())) {
            sql.append("\r\n and t1.FPersonId = '");
            sql.append(param.getSalesId()).append("' ");
        } else {
            List personIds = param.getPersonIds();
            if (personIds != null && personIds.size() > 0) {
                sql.append("\r\n and t1.FPersonId in (");
                sql.append(CollectionUtil.toSqlString(personIds));
                sql.append(") ");
            }
        }
        List types = param.getArapBillTypes();
        if (types != null && types.size() > 0) {
            sql.append("\r\n and (");
            int size = types.size();
            for (int i = 0; i < size; ++i) {
                sql.append(" t1.FBillType = ").append(types.get(i));
                sql.append(i + 1 < size ? " or " : "");
            }
            sql.append(")");
        }
        return sql;
    }

    private static void appendArApBillTypeClause(Locale locale, boolean fAR, StringBuilder sql) {
        sql.append("\r\n, case when t1.FBillType = ");
        sql.append(fAR ? 102 : 202);
        sql.append(" then N'");
        sql.append(fAR ? OtherBillTypeEnum.InvoiceBill.getAlias(locale) : OtherBillType.InvoiceBill.getAlias(locale));
        sql.append("' else case when t1.FBillType = ");
        sql.append(fAR ? 103 : 203);
        sql.append(" then N'");
        sql.append(fAR ? OtherBillTypeEnum.ExpenseInvoice.getAlias(locale) : OtherBillType.ExpenseInvoice.getAlias(locale));
        sql.append("' else case when t1.FBillType = ");
        sql.append(fAR ? 101 : 201);
        sql.append(" then N'");
        sql.append(fAR ? OtherBillTypeEnum.OtherReceivable.getAlias(locale) : OtherBillType.OtherPay.getAlias(locale));
        sql.append("' else case when t1.FBillType = ");
        sql.append(fAR ? 104 : 204);
        sql.append(" then N'");
        sql.append(fAR ? OtherBillTypeEnum.DebitAdjust.getAlias(locale) : OtherBillType.DebitAdjust.getAlias(locale));
        sql.append("' end end end end as FBillType\r\n, ");
    }

    private static StringBuilder recpayBillSql(Context ctx, AccountAgeQueryParam param, String verifyAmtTbl, List entityCompIds) throws ArApCommonException {
        boolean fByBill;
        String tbl = param.isArRpt() ? " T_CAS_ReceivingBill" : " T_CAS_PaymentBill";
        String typeTbl = param.isArRpt() ? " T_CAS_ReceivingBillType" : " T_CAS_PaymentBillType";
        String fld_AsstActType = param.isArRpt() ? "FPayerTypeID" : "FPayeeTypeID";
        String fld_AsstAct = param.isArRpt() ? "FPayerID" : "FPayeeID";
        String fld_Type = param.isArRpt() ? "FRecBillTypeID" : "FPayBillTypeId";
        String nameFld = ArApReportHelper.getNameFld(ctx);
        StringBuilder sql = new StringBuilder(600);
        sql.append(" select t1.FCompanyId, t1.FAdminOrgUnitID FAdminOrgId, t1.").append(fld_AsstAct);
        sql.append(" FAsstActId, t1.").append(fld_AsstActType);
        sql.append(" FAsstActTypeId, t1.FCurrencyId,\r\n");
        sql.append(" t3.").append(nameFld);
        sql.append(" FCompany, t3.FLongNumber FCompLongNumber,");
        sql.append(" t3.FParentId FParentCompanyId,");
        sql.append(" t3.FIsLeaf FIsCompLeaf, t3.FLevel FComplevel,\r\n");
        sql.append(" t7.FNumber FAdminOrgNumber, t7.").append(nameFld).append(" FAdminOrgName,");
        sql.append(" t4.FNumber FAsstActNumber, t4.FName");
        sql.append(" FCussAcct, t5.").append(nameFld).append(" FAsstActType,");
        sql.append(" t6.FPrecision FCurrPrecision, t6.FNumber FCurrNum, t6.");
        sql.append(nameFld).append(" FCurrency, ");
        sql.append("\r\n t1.FBizDate FBillDate, t1.FBizDate FRecPayDate, t1.FBizDate FBizDate,");
        sql.append("0 - entry.FUnVcAmount FUnVerifyAmt, t1.FId FBillId, entry.FID FEntryId");
        sql.append(", 0 FIsReversed, 0 FIsTransBill");
        boolean isAgeByPlanDate = param.isAgeByPlanDate();
        sql.append(!isAgeByPlanDate ? "" : ", null FPlanId, entry.FAmount FRecPayAmt");
        sql.append(", (0 - entry.FUnVcLocAmount) FUnVerifyAmtLoc ");
        if (isAgeByPlanDate) {
            sql.append(", entry.FLocalAmount FRecPayAmtLoc");
        }
        boolean bl = fByBill = param.getAnalyseObjIndex() == 1;
        if (fByBill) {
            sql.append("\r\n, t2.").append(ArApReportHelper.getNameFld(ctx));
            sql.append(" FBillType, t1.FNumber FBillNum,");
            sql.append(" t1.FDescription FDescription");
        }
        sql.append(" \r\n from ").append(tbl);
        sql.append(" t1 inner join ").append(tbl).append("Entry ");
        sql.append(" entry on t1.FId=").append("entry.").append(param.isArRpt() ? "FReceivingBillID " : "FPaymentBillID ");
        sql.append(" inner join ").append(typeTbl).append(" t2 on ");
        sql.append(param.isArRpt() ? " entry." : " t1.").append(fld_Type).append(" = t2.FId");
        sql.append("\r\n left join t_org_company t3 on t3.FId = t1.FCompanyId");
        sql.append("\r\n left join T_ORG_Admin t7 on t7.FId = t1.FAdminOrgUnitID");
        sql.append("\r\n inner join (select distinct * from ").append(param.getCussAcctTempTable()).append(") t4 on t4.FId = t1.").append(fld_AsstAct);
        sql.append("\r\n left join t_bd_AsstActType t5 on t5.FId = ").append("t1.").append(fld_AsstActType);
        sql.append("\r\n left join t_bd_currency ").append("t6 on t6.FId = t1.FCurrencyId ");
        sql.append(" \r\n where 1 = 1");
        sql.append(" AND t1.FSourceType = ").append(param.isArRpt() ? String.valueOf(100) : String.valueOf(101));
        sql.append(" and t1.").append(fld_AsstActType);
        sql.append(" = '").append(param.getCussTypeId()).append("' ");
        if (!param.isAllCurrency()) {
            sql.append(" and t1.FCurrencyId = '");
            sql.append(param.getCurrencyId()).append("' ");
        }
        if (!param.isEndDateBal()) {
            sql.append(" and entry.FUnVcAmount <> 0");
        } else {
            sql.append(" AND (entry.FUnVcAmount <> 0 OR (");
            sql.append(" entry.FUnVcAmount = 0 AND EXISTS (");
            sql.append("SELECT 1 FROM ").append(verifyAmtTbl).append(" tVerify");
            sql.append(" WHERE t1.FID = tVerify.FBillId AND entry.FID = tVerify.FEntryId");
            sql.append(")))");
        }
        sql.append(" and t1.FBillStatus >= ");
        sql.append(param.isArRpt() ? 14 : 15);
        sql.append("\r\n and t1.FCompanyId in (");
        sql.append(CollectionUtil.ids2SqlString(entityCompIds));
        sql.append(") ");
        SimpleDateFormat dtFormat = new SimpleDateFormat("yyyy-MM-dd");
        sql.append("\r\n and t1.FBizDate >= {");
        sql.append(dtFormat.format(param.getBeginDate()));
        sql.append("} and t1.FBizDate < {");
        sql.append(dtFormat.format(param.getEndDate()));
        sql.append("} ");
        if (!StringUtils.isEmpty((String)param.getAdminOrgId())) {
            sql.append("\r\n and t1.FAdminOrgUnitId = '");
            sql.append(param.getAdminOrgId()).append("' ");
        } else {
            List adminIds = param.getAdminOrgIds();
            if (adminIds != null && adminIds.size() > 0) {
                sql.append("\r\n and t1.FAdminOrgUnitId in (");
                sql.append(CollectionUtil.toSqlString(adminIds));
                sql.append(") ");
            }
        }
        if (!StringUtils.isEmpty((String)param.getSalesId())) {
            sql.append(" and t1.FPersonId = '");
            sql.append(param.getSalesId()).append("' ");
        } else {
            List personIds = param.getPersonIds();
            if (personIds != null && personIds.size() > 0) {
                sql.append("\r\n and t1.FPersonId in (");
                sql.append(CollectionUtil.toSqlString(personIds));
                sql.append(") ");
            }
        }
        List types = param.getRecpayBillTypes();
        if (types != null && types.size() > 0) {
            sql.append("\r\n and (");
            int size = types.size();
            if (param.isArRpt()) {
                for (int i = 0; i < size; ++i) {
                    sql.append(" entry.").append(fld_Type).append(" = '");
                    sql.append(types.get(i)).append("' ");
                    sql.append(i + 1 < size ? " or " : "");
                }
                sql.append(")");
            } else {
                for (int i = 0; i < size; ++i) {
                    sql.append(" t1.").append(fld_Type).append(" = '");
                    sql.append(types.get(i)).append("' ");
                    sql.append(i + 1 < size ? " or " : "");
                }
                sql.append(")");
            }
        }
        if (param.isPaymentTypeCheckBox()) {
            if (param.getPaymentTypeIndex() == 1) {
                sql.append(" and t1.FPaymentTypeID = '" + (param.isArRpt() ? "cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5" : "40b75328-7f57-463f-8d19-280574ef24bf6BCA0AB5") + "' ");
            }
        } else {
            sql.append(" and t1.FPaymentTypeID = '" + (param.isArRpt() ? "91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5" : "2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5") + "' ");
        }
        return sql;
    }

    public static String updateOtherBillsVerifiedSql(Context ctx, AccountAgeQueryParam param, String agedBillTable, String verifyAmtTbl) {
        StringBuffer sql = new StringBuffer(200);
        sql.append("update ").append(agedBillTable).append(" as t1").append(CRTL);
        sql.append(" set (FBillId, FUnVerifyAmt, FUnVerifyAmtLoc) = ").append(CRTL);
        sql.append(" (select tV.FBillId, t1.FUnVerifyAmt + tV.FVerifiedAmt  ");
        sql.append(", t1.FUnVerifyAmtLoc + tV.FVerifiedAmtLoc FUnVerifyAmtLoc");
        sql.append(CRTL).append(" from ").append(verifyAmtTbl).append(" as tV").append(CRTL);
        sql.append(" where t1.FBillId = tV.FBillId");
        sql.append(" AND tV.FType = 0");
        sql.append(")");
        return sql.toString();
    }

    public static String updateRecPayBillsVerifiedSql(Context ctx, AccountAgeQueryParam param, String agedBillTable, String verifyAmtTbl) {
        StringBuffer sql = new StringBuffer(200);
        sql.append("update ").append(agedBillTable).append(" as t1 ").append(CRTL);
        sql.append(" set (FBillId, FEntryId, FUnVerifyAmt, FUnVerifyAmtLoc) = ").append(CRTL);
        sql.append(" (select tV.FBillId, tV.FEntryId, t1.FUnVerifyAmt + tV.FVerifiedAmt ").append(CRTL);
        sql.append(", t1.FUnVerifyAmtLoc + tV.FVerifiedAmtLoc FUnVerifyAmtLoc").append(CRTL);
        sql.append("from ").append(verifyAmtTbl).append(" as tV").append(CRTL);
        sql.append(" where t1.FBillId = tV.FBillId AND t1.FEntryId = tV.FEntryId");
        sql.append(" AND tV.FType = 1");
        sql.append(")");
        return sql.toString();
    }

    public static List<String> getVerifiedAfterEndDateSql(Context ctx, AccountAgeQueryParam param, String verifyAmtTbl, List entityCompIds, String sAgingNxtDay) throws ArApCommonException {
        boolean fAR = param.isArRpt();
        int iDirIndex = param.getDirIndex();
        ArrayList<String> sqlList = new ArrayList<String>();
        StringBuilder sql = new StringBuilder(500);
        String insertPrefix = "INSERT INTO " + verifyAmtTbl;
        if (iDirIndex == 0 || iDirIndex == 2) {
            sql.append(" select t1.FBillId, NULL, ");
            sql.append("sum(t1.FThisVerificateAmt) FVerifiedAmt, 0 FType ");
            sql.append(", sum(t1.FThisVerificateAmtLoc) FVerifiedAmtLoc ").append(CRTL);
            sql.append(" from t_ap_VerificationBillEntry t1 ");
            sql.append("inner join t_ap_VerificationBill t2 ");
            sql.append("on t1.FParentId = t2.FId ");
            sql.append("\r\n  where t2.FBizDate >= {").append(sAgingNxtDay);
            sql.append("} and t1.FBillType IN (8, 9)");
            sql.append("\r\n and t2.FCompanyId in (");
            sql.append(CollectionUtil.ids2SqlString(entityCompIds));
            sql.append(") ");
            if (param.isPaymentTypeCheckBox()) {
                if (param.getPaymentTypeIndex() == 1) {
                    sql.append(" and t2.FISCASHSALEPUR = 1");
                }
            } else {
                sql.append(" and t2.FISCASHSALEPUR = 0");
            }
            sql.append("\r\n  group by t1.FBillId");
            sqlList.add(insertPrefix + sql.toString());
            sql.setLength(0);
            sql.append(" select t1.FBillId, NULL, ");
            sql.append("sum(t1.FThisVerificateAmt) FVerifiedAmt, 0 FType ");
            sql.append(", sum(t1.FThisVerificateAmtLoc) FVerifiedAmtLoc ").append(CRTL);
            sql.append(" from t_ar_VerificationBillEntry t1 ");
            sql.append("inner join t_ar_VerificationBill t2 ");
            sql.append("on t1.FParentId = t2.FId ");
            sql.append("\r\n  where t2.FBizDate >= {").append(sAgingNxtDay);
            sql.append("} and t1.FBillType IN (8, 9)");
            sql.append("\r\n and t2.FCompanyId in (");
            sql.append(CollectionUtil.ids2SqlString(entityCompIds));
            sql.append(") ");
            if (param.isPaymentTypeCheckBox()) {
                if (param.getPaymentTypeIndex() == 1) {
                    sql.append(" and t2.FISCASHSALEPUR = 1");
                }
            } else {
                sql.append(" and t2.FISCASHSALEPUR = 0");
            }
            sql.append("\r\n  group by t1.FBillId");
            sqlList.add(insertPrefix + sql.toString());
            sql.setLength(0);
            sql.append(" select t1.FSourceBillId, NULL, ");
            sql.append("sum(t3.FRecievePayAmount) FVerifiedAmt, 0 FType ");
            sql.append(", sum(t3.FRecievePayAmountLocal) FVerifiedAmtLoc ").append(CRTL);
            sql.append(" from ").append(fAR ? "t_ar_otherbill" : "t_ap_otherbill");
            sql.append(" t1\r\n inner join ");
            sql.append(fAR ? "t_ar_otherbillEntry" : "t_ap_otherbillEntry");
            sql.append(" t3 on t1.FId = t3.FParentId");
            sql.append("\r\n  where t1.FBillDate >= {").append(sAgingNxtDay);
            sql.append("} and t1.FIsTransBill = 1 ");
            sql.append(" AND t1.FBillStatus = 3");
            sql.append("\r\n and t1.FCompanyId in (");
            sql.append(CollectionUtil.ids2SqlString(entityCompIds));
            sql.append(") ");
            sql.append("\r\n  group by t1.FSourceBillId");
            sqlList.add(insertPrefix + sql.toString());
            sql.setLength(0);
            sql.append(" select t3.FSourceBillId,NULL, ");
            sql.append("sum(t3.FAmount) FVerifiedAmt, 0 FType ");
            sql.append(", sum(t3.FLocalAmount) FVerifiedAmtLoc ").append(CRTL);
            sql.append(" from ").append(fAR ? "T_CAS_PaymentBill" : "T_CAS_ReceivingBill");
            sql.append(" t1\r\n inner join ");
            sql.append(fAR ? "T_CAS_PaymentBillEntry" : "T_CAS_ReceivingBillEntry");
            sql.append(" t3 on t1.FId = t3.");
            sql.append(fAR ? "FPaymentBillID" : "FReceivingBillID");
            sql.append("\r\n  where t1.FBizDate >= {").append(sAgingNxtDay);
            sql.append("} and t1.FIsTransOtherBill = 1 ");
            sql.append(" AND t1.FBillStatus IN (12, 14, 15)");
            sql.append("\r\n and t1.FCompanyId in (");
            sql.append(CollectionUtil.ids2SqlString(entityCompIds));
            sql.append(") ");
            sql.append("\r\n  group by t3.FSourceBillId");
            sqlList.add(insertPrefix + sql.toString());
            sql.setLength(0);
            sql.append(" select t3.FSourceBillId, NULL,");
            sql.append("-1*sum(t3.FRecievePayAmount) FVerifiedAmt, 0 FType ");
            sql.append(", -1*sum(t3.FRecievePayAmountLocal) FVerifiedAmtLoc ").append(CRTL);
            sql.append(" from ").append(fAR ? "t_ar_otherbill" : "t_ap_otherbill");
            sql.append(" t1\r\n inner join ");
            sql.append(fAR ? "t_ar_otherbillEntry" : "t_ap_otherbillEntry");
            sql.append(" t3 on t1.FId = t3.FParentId");
            sql.append("\r\n  where t1.FBillDate >= {").append(sAgingNxtDay);
            sql.append("} and t1.FIsAllowanceBill = 1 ");
            sql.append(" AND t1.FBillStatus = ").append(3).append(CRTL);
            sql.append("\r\n and t1.FCompanyId in (");
            sql.append(CollectionUtil.ids2SqlString(entityCompIds));
            sql.append(") ");
            sql.append("\r\n  group by t3.FSourceBillId");
            sqlList.add(insertPrefix + sql.toString());
            if (fAR) {
                sql.setLength(0);
                sql.append(" SELECT t1.FBillId, NULL,");
                sql.append(" SUM(t1.fbadamounts) FVerifiedAmt,0 FType ");
                sql.append(", SUM(t1.FBadAmountsLocal) FVerifiedAmtLoc ").append(CRTL);
                sql.append(" from  t_ar_badacct t1 ").append(CRTL);
                sql.append(" WHERE t1.FAuditorID is not null");
                sql.append(" AND t1.fbadacctdate >= {").append(sAgingNxtDay).append("}");
                sql.append("\r\n and t1.FCompanyId in (");
                sql.append(CollectionUtil.ids2SqlString(entityCompIds));
                sql.append(") ");
                sql.append("\r\n group by t1.FBillId");
                sqlList.add(insertPrefix + sql.toString());
            }
        }
        if (iDirIndex == 1 || iDirIndex == 2) {
            sql.setLength(0);
            sql.append(" select t1.FBillId,t1.FEntryId, ").append(CRTL);
            sql.append(" 0 - sum(t1.FThisVerificateAmt) FVerifiedAmt, 1 FType ").append(CRTL);
            sql.append(", 0 - sum(t1.FThisVerificateAmtLoc) FVerifiedAmtLoc ").append(CRTL);
            sql.append(" from t_ap_VerificationBillEntry t1 ").append(CRTL);
            sql.append(" inner join t_ap_VerificationBill t2 on t1.FParentId = t2.FId ").append(CRTL);
            sql.append(" where t2.FBizDate >= {").append(sAgingNxtDay);
            sql.append("} ");
            sql.append(" and t1.FBillType IN (4, 6)").append(CRTL);
            sql.append(" and t2.FCompanyId in (");
            sql.append(CollectionUtil.ids2SqlString(entityCompIds));
            sql.append(") ").append(CRTL);
            sql.append(" group by t1.FBillId, t1.FEntryId");
            sqlList.add(insertPrefix + sql.toString());
            sql.setLength(0);
            sql.append(" select t1.FBillId,t1.FEntryId, ").append(CRTL);
            sql.append(" 0 - sum(t1.FThisVerificateAmt) FVerifiedAmt, 1 FType ").append(CRTL);
            sql.append(", 0 - sum(t1.FThisVerificateAmtLoc) FVerifiedAmtLoc ").append(CRTL);
            sql.append(" from t_ar_VerificationBillEntry t1 ").append(CRTL);
            sql.append(" inner join t_ar_VerificationBill t2 on t1.FParentId = t2.FId ").append(CRTL);
            sql.append(" where t2.FBizDate >= {").append(sAgingNxtDay);
            sql.append("} ");
            sql.append(" and t1.FBillType IN (4, 6)").append(CRTL);
            sql.append(" and t2.FCompanyId in (");
            sql.append(CollectionUtil.ids2SqlString(entityCompIds));
            sql.append(") ").append(CRTL);
            sql.append(" group by t1.FBillId, t1.FEntryId");
            sqlList.add(insertPrefix + sql.toString());
            sql.setLength(0);
            sql.append(" select t3.FSourceBillId, t3.FSourceBillEntryId, ");
            sql.append(" 0 - sum(t3.FAmount) FVerifiedAmt, 1 FType ");
            sql.append(", 0 - sum(t3.FLocalAmount) FVerifiedAmtLoc ").append(CRTL);
            sql.append(" from ").append(fAR ? "T_CAS_ReceivingBill" : "T_CAS_PaymentBill").append(" t1 ").append(CRTL);
            sql.append(" inner join ");
            sql.append(fAR ? "T_CAS_ReceivingBillEntry" : "T_CAS_PaymentBillEntry");
            sql.append(" t3 on t1.FId = t3.");
            sql.append(fAR ? "FReceivingBillID" : "FPaymentBillID").append(CRTL);
            sql.append(" where t1.FBizDate >= {").append(sAgingNxtDay);
            sql.append("} and t1.FIsTransBill = 1 AND t1.FIsTransOtherBill = 0");
            sql.append(" AND t1.FBillStatus IN (12, 14, 15)").append(CRTL);
            sql.append(" and t1.FCompanyId in (");
            sql.append(CollectionUtil.ids2SqlString(entityCompIds));
            sql.append(") ").append(CRTL);
            sql.append(" group by t3.FSourceBillId, t3.FSourceBillEntryId");
            sqlList.add(insertPrefix + sql.toString());
            sql.setLength(0);
            sql.append(" select t3.FSourceBillId,t3.FSourceBillEntryId, ");
            sql.append(" 0 - sum(t3.FRecievePayAmount) FVerifiedAmt, 1 FType ");
            sql.append(", 0 - sum(t3.FRecievePayAmountLocal) FVerifiedAmtLoc ").append(CRTL);
            sql.append(" from ").append(fAR ? "T_AP_Otherbill" : "T_AR_Otherbill").append(" t1 ").append(CRTL);
            sql.append(" inner join ");
            sql.append(fAR ? "T_AP_OtherbillEntry" : "T_AR_OtherbillEntry");
            sql.append(" t3 on t1.FId = t3.FParentId").append(CRTL);
            sql.append(" where t1.FBillDate >= {").append(sAgingNxtDay);
            sql.append("} and t1.FIsTransOtherBill = 1 ");
            sql.append(" AND t1.FBillStatus = ").append(3).append(CRTL);
            sql.append(" and t1.FCompanyId in (");
            sql.append(CollectionUtil.ids2SqlString(entityCompIds));
            sql.append(") ").append(CRTL);
            sql.append(" group by t3.FSourceBillId, t3.FSourceBillEntryId");
            sqlList.add(insertPrefix + sql.toString());
        }
        sql.setLength(0);
        sql.append(" SELECT t1.FID, NULL, FVerifyAmount FVerifiedAmt, 2 FType ");
        sql.append(", FVerifyAmountLocal FVerifiedAmtLoc ").append(CRTL);
        sql.append(" FROM ").append(fAR ? "t_ar_otherbill" : "t_ap_otherbill").append(" t1 ").append(CRTL);
        sql.append(" where (t1.FIsReversed = 1 or t1.FIsReverseBill = 1) ").append(CRTL);
        sql.append(" and t1.FBillDate >= {").append(sAgingNxtDay).append("} ").append(CRTL);
        sql.append(" and t1.FCompanyId in (");
        sql.append(CollectionUtil.ids2SqlString(entityCompIds));
        sql.append(") ");
        sqlList.add(insertPrefix + sql.toString());
        sql.setLength(0);
        sql.append(" SELECT t1.FID, NULL, FVerifyAmount FVerifiedAmt, 2 FType ");
        sql.append(", FVerifyAmountLocal FVerifiedAmtLoc ").append(CRTL);
        sql.append(" FROM ").append(fAR ? "t_ar_otherbill" : "t_ap_otherbill").append(" t1 ").append(CRTL);
        sql.append(" where (t1.FIsReversed = 1 or t1.FIsReverseBill = 1) ").append(CRTL);
        sql.append(" and t1.FCompanyId in (");
        sql.append(CollectionUtil.ids2SqlString(entityCompIds));
        sql.append(") and (t1.FSourceBillID in (select FBillID from " + verifyAmtTbl + " where FType=2))").append(CRTL);
        sql.append(" and not exists (select 1 from " + verifyAmtTbl + " where FType=2 and FBillID=t1.FID)");
        sqlList.add(insertPrefix + sql.toString());
        sql.setLength(0);
        sql.append(" SELECT t1.FID, NULL, FVerifyAmount FVerifiedAmt, 2 FType ");
        sql.append(", FVerifyAmountLocal FVerifiedAmtLoc ").append(CRTL);
        sql.append(" FROM ").append(fAR ? "t_ar_otherbill" : "t_ap_otherbill").append(" t1 ").append(CRTL);
        sql.append(" where (t1.FIsReversed = 1 or t1.FIsReverseBill = 1) ").append(CRTL);
        sql.append(" and t1.FCompanyId in (");
        sql.append(CollectionUtil.ids2SqlString(entityCompIds));
        sql.append(" ) and (t1.FID in (select distinct FSourceBillID from ");
        sql.append(fAR ? " t_ar_otherbill" : " t_ap_otherbill").append(CRTL);
        sql.append(" WHERE FID in (select FBillID from " + verifyAmtTbl + " where FType=2)))").append(CRTL);
        sql.append(" and not exists (select 1 from " + verifyAmtTbl + " where FType=2 and FBillID=t1.FID)");
        sqlList.add(insertPrefix + sql.toString());
        return sqlList;
    }

    public static String getAgeBilPlanSql(Context ctx, String agedBillTable) {
        StringBuffer sql = new StringBuffer(200);
        sql.append("select t1.FBillId, t1.FPlanId, t1.FUnVerifyAmt, ");
        sql.append("t1.FRecPayAmt\r\n from ").append(agedBillTable);
        sql.append(" t1 where t1.FBillId = ? order by t1.FRecPayDate desc");
        return sql.toString();
    }

    public static String updateReversedSql(Context ctx, String agedBillTable, String verifyAmtTbl) {
        StringBuilder sql = new StringBuilder(200);
        sql.append("update ").append(agedBillTable);
        sql.append("  t1 set (FBillID, FUnVerifyAmt, FUnVerifyAmtLoc) = ").append(CRTL);
        sql.append(" (select FBillID, FVerifiedAmt, FVerifiedAmtLoc").append(CRTL);
        sql.append("from ").append(verifyAmtTbl);
        sql.append(" t2 where t1.FBillID=t2.FBillID and t2.FType=2 and t1.FIsReversed=1) ");
        return sql.toString();
    }

    public static String updateBaseCurrencySql(Context ctx, AccountAgeQueryParam param) {
        StringBuilder sql = new StringBuilder(200);
        sql.append("UPDATE ").append(param.getTempTable());
        sql.append(" T1 set (").append(BASE_CURRENCY_COLS).append(") = ").append(CRTL);
        sql.append(" (select TBC.FID, TBC.FPrecision, TBC.FNUMBER, TBC.FNAME_" + ctx.getLocale()).append(CRTL);
        sql.append(" FROM T_ORG_Company TOC").append(CRTL);
        sql.append(" INNER JOIN T_BD_Currency TBC ON TBC.FID = TOC.FBaseCurrencyID").append(CRTL);
        sql.append(" WHERE TOC.FID = T1.FCompanyId )");
        return sql.toString();
    }

    public static String getCurrencyCols(AccountAgeQueryParam param) {
        return ArApAgingRptSqlHelper.getCurrencyCols(param, true);
    }

    public static String getCurrencyCols(AccountAgeQueryParam param, boolean needCommaPrefix) {
        String cols = "";
        if (!param.isBaseCurrency()) {
            if (needCommaPrefix) {
                cols = cols + ", ";
            }
            cols = cols + "FCurrencyId, FCurrPrecision, FCurrNum, FCurrency";
        }
        if (param.isBaseCurrency() || param.hasLocAmt()) {
            if (!StringUtils.isEmpty((String)cols) || needCommaPrefix) {
                cols = cols + ", ";
            }
            cols = cols + BASE_CURRENCY_COLS;
        }
        cols = cols + CRTL;
        return cols;
    }

    public static String getAgingDataSql(Context ctx, AccountAgeQueryParam param, String agedBillTable) {
        int i;
        boolean fByBill = param.getAnalyseObjIndex() == 1;
        boolean isAgeByPlanDate = param.isAgeByPlanDate();
        Date agingBaseDate = param.getAgingCompareDate();
        List<String> lstFlds = param.getReportFields();
        int amtFldIndex = param.getAmtColStartIndex();
        StringBuilder rsStrFlds = new StringBuilder(100);
        rsStrFlds.append(" FCompanyId, FParentCompanyId, ");
        if (param.getGroupTypeIndex() == 2) {
            rsStrFlds.append("FAdminOrgId, FAdminOrgNumber, FAdminOrgName, ");
        }
        rsStrFlds.append(" FAsstActID, FAsstActTypeID, ").append(CRTL);
        rsStrFlds.append("FCompany, FCompLongNumber, FIsCompLeaf, FComplevel, ");
        rsStrFlds.append("FAsstActNumber, FCussAcct, FAsstActType ");
        rsStrFlds.append(ArApAgingRptSqlHelper.getCurrencyCols(param));
        if (fByBill) {
            rsStrFlds.append(", FBillDate, FBillNum, FBillType");
            rsStrFlds.append(", FDescription, FBillId");
            rsStrFlds.append(isAgeByPlanDate ? ", FPlanId" : "");
        }
        StringBuilder grpSql = new StringBuilder(100);
        grpSql.append(" group by ").append(rsStrFlds.toString());
        int fldSize = lstFlds.size();
        StringBuilder qrySql = new StringBuilder(500);
        qrySql.append(" insert into ").append(param.getTempTable()).append(CRTL);
        qrySql.append(" (FId, ").append((CharSequence)rsStrFlds);
        for (i = amtFldIndex; i < fldSize; ++i) {
            qrySql.append(", ").append((Object)lstFlds.get(i));
        }
        qrySql.append(") ").append(CRTL);
        qrySql.append(" select newbosid('AGEDREPT') FId, ");
        qrySql.append((CharSequence)rsStrFlds).append(CRTL);
        for (i = amtFldIndex; i < fldSize; ++i) {
            qrySql.append(", sum(").append((Object)lstFlds.get(i)).append(") ").append((Object)lstFlds.get(i));
        }
        qrySql.append(CRTL).append(" from (").append(CRTL);
        String dateFld = null;
        switch (param.getDateFldIndex()) {
            case 0: {
                dateFld = "FRecPayDate";
                break;
            }
            case 1: {
                dateFld = "FBillDate";
                break;
            }
            case 2: {
                dateFld = "FBizDate";
            }
        }
        String amtFld = " sum(FUnVerifyAmt) ";
        String amtFldLoc = " sum(FUnVerifyAmtLoc) ";
        List lstOverdueDate = param.getOverdueDateList();
        List lstUndueDate = param.getUndueDateList();
        String fld = null;
        StringBuilder whereSql = new StringBuilder(300);
        int dateInd = -1;
        boolean fUL = false;
        boolean fOL = false;
        SimpleDateFormat dtFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date preDate = null;
        int j = 0;
        for (int i2 = amtFldIndex; i2 < fldSize; ++i2) {
            Date qryDate;
            fld = lstFlds.get(i2).toString();
            qrySql.append(" select ").append((CharSequence)rsStrFlds);
            whereSql.setLength(0);
            for (j = amtFldIndex; j < fldSize; ++j) {
                if (i2 == j) {
                    qrySql.append(", ").append(!param.isBaseCurrency() ? amtFld : amtFldLoc);
                } else if (j == i2 + 1 && param.hasLocAmt()) {
                    qrySql.append(", ").append(amtFldLoc);
                } else {
                    qrySql.append(", 0 ");
                }
                qrySql.append((Object)lstFlds.get(j));
            }
            if (fld.indexOf("FUL_") != -1) {
                dateInd = dateInd + 1 < lstUndueDate.size() ? dateInd + 1 : dateInd;
                qryDate = (Date)lstUndueDate.get(dateInd);
                Date qryNxtDate = new Date(qryDate.getTime() + 86400000L);
                if (!fUL) {
                    preDate = new Date(agingBaseDate.getTime() + 86400000L);
                    fUL = true;
                }
                if (dateInd == lstUndueDate.size() - 1) {
                    whereSql.append(" where ").append(dateFld).append(" >= {");
                    whereSql.append(dtFormat.format(qryDate));
                    whereSql.append("} ");
                } else {
                    whereSql.append(" where ").append(dateFld).append(" >= {");
                    whereSql.append(dtFormat.format(preDate));
                    whereSql.append("} and ").append(dateFld).append(" < {");
                    whereSql.append(dtFormat.format(qryNxtDate));
                    whereSql.append("} ");
                }
                preDate = qryNxtDate;
            } else if (fld.indexOf("FOL_") != -1) {
                dateInd = dateInd > 0 && !fOL ? 0 : dateInd + 1;
                qryDate = (Date)lstOverdueDate.get(dateInd);
                if (!fOL) {
                    preDate = agingBaseDate;
                    fOL = true;
                }
                if (lstOverdueDate.size() - 1 == dateInd) {
                    Date qryNextDate = new Date(qryDate.getTime() + 86400000L);
                    whereSql.append(" where ").append(dateFld).append(" < {");
                    whereSql.append(dtFormat.format(qryNextDate));
                    whereSql.append("} ");
                } else {
                    whereSql.append(" where ").append(dateFld).append(" >= {");
                    whereSql.append(dtFormat.format(qryDate));
                    whereSql.append("}  and ").append(dateFld).append(" < {");
                    whereSql.append(dtFormat.format(preDate));
                    whereSql.append("} ");
                }
                preDate = qryDate;
            } else if (fld.startsWith("FDueAmt")) {
                Date agingBaseNxtDate = new Date(agingBaseDate.getTime() + 86400000L);
                String agingBaseNxtDateStr = dtFormat.format(agingBaseNxtDate);
                whereSql.append(" Where ").append(dateFld).append(" >= {");
                whereSql.append(dtFormat.format(agingBaseDate));
                whereSql.append("} and ").append(dateFld).append(" < {");
                whereSql.append(agingBaseNxtDateStr).append("} ");
            }
            whereSql.append(whereSql.length() > 0 ? " and " : " where ");
            whereSql.append(" FUnVerifyAmt <> 0 ");
            qrySql.append(CRTL).append(" from ").append(agedBillTable);
            qrySql.append(CRTL).append((CharSequence)whereSql).append(CRTL).append((CharSequence)grpSql);
            if (param.hasLocAmt()) {
                ++i2;
            }
            if (i2 + 1 >= fldSize) continue;
            qrySql.append(" union all ").append(CRTL);
        }
        qrySql.append(CRTL).append(")  t_ar_agesRpt ").append(CRTL).append((CharSequence)grpSql);
        return qrySql.toString();
    }

    public static StringBuilder getFetchDataSql(Context ctx, AccountAgeQueryParam param, List idList) throws BOSException, ArApCommonException {
        boolean fByBill = param.getAnalyseObjIndex() == 1;
        String tempTable = param.getTempTable();
        StringBuilder sql = new StringBuilder(300);
        sql.append("select * from ").append(tempTable).append(" as t1 ").append(CRTL);
        sql.append(" where 1 = 1 ");
        List<String> lstFlds = param.getReportFields();
        int amtFldIndex = param.getAmtColStartIndex();
        int fldSize = lstFlds.size();
        for (int i = amtFldIndex; i < fldSize; ++i) {
            if (i == amtFldIndex) {
                sql.append(" and ( ").append((Object)lstFlds.get(i)).append("<>0 ");
                continue;
            }
            sql.append(" or ").append((Object)lstFlds.get(i)).append("<>0 ").append(CRTL);
        }
        sql.append(" OR ").append(" FIsSum = 1)").append(CRTL);
        if (idList != null && idList.size() > 0) {
            sql.append(" and t1.FId in (");
            sql.append(CollectionUtil.ids2SqlString(idList));
            sql.append(")").append(CRTL);
        } else if (param.isQueryComps()) {
            Set CompanyNumSet = ArApReportHelper.getCompanyNums(ctx, tempTable);
            if (CompanyNumSet.size() > 0) {
                sql.append(" and t1.FCompLongNumber in (");
                Iterator it = CompanyNumSet.iterator();
                String CompanyNum = null;
                int i = 0;
                while (it.hasNext()) {
                    CompanyNum = (String)it.next();
                    if (i > 0) {
                        sql.append(" , ");
                    }
                    sql.append(" '").append(CompanyNum).append("' ");
                    ++i;
                }
                sql.append(" ) ");
            }
            sql.append(" or t1.FCompLongNumber is null");
        }
        sql.append(ArApAgingRptSqlHelper.getAgingRptOrderSql(fByBill, param.getGroupTypeIndex(), param.isBaseCurrency(), param.hasLocAmt()));
        logger.debug((Object)("agingRpt fetch sql:\r\n" + sql));
        return sql;
    }

    public static String getAgingRptOrderSql(boolean fByBill, int groupTypeIndex, boolean isBaseCurrency, boolean hasLocAmt) {
        StringBuilder sql = new StringBuilder(200);
        sql.append(CRTL).append(" order by ");
        if (!isBaseCurrency) {
            sql.append(" FCurrNum, ");
        }
        if (isBaseCurrency || hasLocAmt) {
            sql.append(" FBASECURRNUM, ");
        }
        if (groupTypeIndex == 1) {
            sql.append(" FcompanyID || FCompLongNumber");
            sql.append(", FAsstActNumber, ");
        } else if (groupTypeIndex == 2) {
            sql.append(" FcompanyID || FCompLongNumber");
            sql.append(", FAdminOrgId || FAdminOrgNumber");
            sql.append(", FAsstActNumber, ");
        } else {
            sql.append(" FAsstActNumber || FCompLongNumber, ");
        }
        if (fByBill) {
            sql.append(" FBillDate, FBillType, FBillNum, ");
        }
        sql.append(" FISSUM ");
        return sql.toString();
    }

    public static Map getFindDataSqlAndParams(Context ctx, RptParams params, String tempTableName, SimpleCompanyUserObject treeTypeObject) {
        boolean isGroupByCom = params.getBoolean("isGroupByCom");
        boolean fByBill = params.getBoolean("isByBill");
        boolean isBaseCurrency = params.getBoolean("isBaseCurrency");
        boolean hasLocAmt = params.getBoolean("hasLocAmt");
        int groupTypeIndex = params.getInt("groupTypeIndex");
        StringBuilder sql = new StringBuilder(300);
        sql.append("SELECT * FROM ").append(tempTableName).append(CRTL);
        sql.append(" WHERE 1 = 1 ");
        if (!isGroupByCom) {
            sql.append(" AND FAsstActId = ? ").append(CRTL);
        }
        sql.append(" AND FParentCompanyId = ?").append(CRTL);
        if (!isBaseCurrency) {
            sql.append(" AND FCurrencyID = ? ").append(CRTL);
        }
        if (isBaseCurrency || hasLocAmt) {
            sql.append(" AND FBaseCurrencyId = ? ").append(CRTL);
        }
        if (isBaseCurrency || hasLocAmt) {
            sql.append(" AND FBalance_BSC <> 0 ");
        } else {
            sql.append(" AND FBalance <> 0 ");
        }
        sql.append(ArApAgingRptSqlHelper.getAgingRptOrderSql(fByBill, groupTypeIndex, isBaseCurrency, hasLocAmt));
        SqlParams sqlParam = new SqlParams();
        if (!isGroupByCom) {
            sqlParam.addString(params.getString("AsstActId"));
        }
        sqlParam.addString(params.getString("fparentid"));
        if (!isBaseCurrency) {
            sqlParam.addString(params.getString("FCurrencyId"));
        }
        if (isBaseCurrency || hasLocAmt) {
            sqlParam.addString(params.getString("FBaseCurrencyId"));
        }
        logger.debug((Object)("agingRpt expand:\r\n" + sql + "\r\nparams: " + sqlParam));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(SQL, sql.toString());
        map.put(SQL_PARAMS, (String)sqlParam);
        return map;
    }

    public static String getAgingRptOrderSql(boolean fByBill, boolean isBaseCurrency, boolean hasLocAmt) {
        StringBuilder sql = new StringBuilder(150);
        sql.append(CRTL).append(" order by ");
        if (!isBaseCurrency) {
            sql.append("FCurrNum, ");
        }
        if (isBaseCurrency && hasLocAmt) {
            sql.append("FBaseCurrNum, ");
        }
        sql.append("FIsSum, FAsstActNumber || FCompLongNumber");
        if (fByBill) {
            sql.append(", FBillDate, FBillType, FBillNum");
        }
        return sql.toString();
    }

    public static String getAgingCurrencySumSql(Context ctx, AccountAgeQueryParam param) {
        String factTbl = param.getTempTable();
        StringBuilder sql = new StringBuilder(300);
        sql.append("insert into ").append(factTbl).append(CRTL);
        sql.append(" (FId").append(ArApAgingRptSqlHelper.getCurrencyCols(param));
        sql.append(", FCussAcct, FIsSum").append(CRTL);
        List<String> flds = param.getReportFields();
        String fld = null;
        int amtIndex = param.getAmtColStartIndex();
        int n = flds.size();
        for (int i = amtIndex; i < n; ++i) {
            fld = flds.get(i);
            sql.append(", ").append(fld);
        }
        String sumLbl = ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArReport.Lbl_Sum", (Locale)ctx.getLocale());
        sql.append(")").append(CRTL).append("select newbosid('agedrept') FId ");
        sql.append(ArApAgingRptSqlHelper.getCurrencyCols(param)).append(", N'");
        sql.append(sumLbl).append("' FCussAcct, 1 FIsSum");
        for (int i = amtIndex; i < n; ++i) {
            fld = flds.get(i);
            sql.append(", sum(").append(fld).append(") ");
            sql.append(fld);
        }
        sql.append(CRTL).append(" from ").append(factTbl).append(CRTL);
        sql.append(" group by ").append(ArApAgingRptSqlHelper.getCurrencyCols(param, false));
        return sql.toString();
    }

    public static String getAgingComSumSql(Context ctx, AccountAgeQueryParam param) {
        String factTbl = param.getTempTable();
        String adminFieldStr = ",FAdminOrgId,FAdminOrgNumber,FAdminOrgName ";
        StringBuilder sql = new StringBuilder(300);
        sql.append("insert into ").append(factTbl).append(CRTL);
        sql.append(" (FId ").append(ArApAgingRptSqlHelper.getCurrencyCols(param));
        sql.append(", FCussAcct, FIsSum,").append(CRTL);
        sql.append("FCompany,FCompanyId,FCompLongNumber,fiscompleaf,FCompLevel,FParentCompanyId ").append(CRTL);
        if (param.getGroupTypeIndex() == 2) {
            sql.append(adminFieldStr);
        }
        List<String> flds = param.getReportFields();
        String fld = null;
        int amtIndex = param.getAmtColStartIndex();
        int n = flds.size();
        for (int i = amtIndex; i < n; ++i) {
            fld = flds.get(i);
            sql.append(", ").append(fld);
        }
        String sumLbl = ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArReport.Lbl_Sum", (Locale)ctx.getLocale());
        sql.append(")").append(CRTL).append("select newbosid('AGEDREPT') FId ").append(ArApAgingRptSqlHelper.getCurrencyCols(param));
        sql.append(", N'").append(sumLbl).append("' fcussAcct, 1 FIsSum").append(CRTL);
        sql.append(",FCompany,FCompanyId,FCompLongNumber,fiscompleaf,FCompLevel,FParentCompanyId ").append(CRTL);
        if (param.getGroupTypeIndex() == 2) {
            sql.append(adminFieldStr);
        }
        for (int i = amtIndex; i < n; ++i) {
            fld = flds.get(i);
            sql.append(", sum(").append(fld).append(") ");
            sql.append(fld);
        }
        sql.append(CRTL).append(" from ").append(factTbl).append(CRTL);
        sql.append(" group by ").append(ArApAgingRptSqlHelper.getCurrencyCols(param, false));
        sql.append(",FCompany,FCompanyId,FCompLongNumber,fiscompleaf,FCompLevel,FParentCompanyId").append(CRTL);
        if (param.getGroupTypeIndex() == 2) {
            sql.append(adminFieldStr);
        }
        return sql.toString();
    }

    public static String getVirtualCompanySql(Context ctx, CompanyOrgUnitInfo compInfo, AccountAgeQueryParam param) {
        String factTbl = param.getTempTable();
        StringBuilder sql = new StringBuilder(500);
        sql.append("insert into ").append(factTbl).append(CRTL);
        sql.append(" (FId,");
        if (param.getGroupTypeIndex() == 0) {
            sql.append(" FAsstActID, FAsstActNumber, ");
            sql.append("FAsstActType, FAsstActTypeID, ").append(CRTL);
        }
        sql.append("FCompanyId, FParentCompanyId, ");
        sql.append("FCompany, FCompLongNumber, ");
        sql.append("FIsCompLeaf, FComplevel ").append(CRTL);
        sql.append(ArApAgingRptSqlHelper.getCurrencyCols(param));
        sql.append(",fisSum").append(CRTL);
        if (param.getGroupTypeIndex() == 1 || param.getGroupTypeIndex() == 2) {
            sql.append(",FAsstActNumber");
        } else {
            sql.append(", FCussAcct");
        }
        List<String> flds = param.getReportFields();
        int amtIndex = param.getAmtColStartIndex();
        int n = flds.size();
        String fld = null;
        for (int i = amtIndex; i < n; ++i) {
            fld = flds.get(i);
            sql.append(", ").append(fld);
        }
        sql.append(")").append(CRTL).append(" select newbosid('agedrept') FId,");
        if (param.getGroupTypeIndex() == 0) {
            sql.append(" FAsstActId, FAsstActNumber,");
            sql.append(" FAsstActType, FAsstActTypeID, ").append(CRTL);
        }
        sql.append("'").append(compInfo.getId()).append("' FCompanyId, '");
        if (compInfo.getParent() != null) {
            sql.append(compInfo.getParent().getId());
        } else {
            sql.append("11111111111");
        }
        sql.append("' FParentCompanyId,N'");
        sql.append(compInfo.getName()).append("' FCompany, N'");
        sql.append(compInfo.getLongNumber()).append("' FCompLongNumber").append(CRTL);
        sql.append(", 0 FIsCompLeaf, ").append(compInfo.getLevel());
        sql.append(" FCompLevel ").append(CRTL);
        sql.append(ArApAgingRptSqlHelper.getCurrencyCols(param));
        sql.append(", 2 FIsSum, ");
        if (param.getGroupTypeIndex() == 1 || param.getGroupTypeIndex() == 2) {
            sql.append(" N'");
            String sumLbl = null;
            if (compInfo.getLevel() >= 2) {
                sumLbl = ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArReport.Lbl_Total", (Locale)ctx.getLocale());
            }
            if (compInfo.getLevel() == 1) {
                sumLbl = ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArReport.Lbl_allTotal", (Locale)ctx.getLocale());
            }
            sql.append(sumLbl).append("' FAsstActNumber");
        } else {
            sql.append(" FCussAcct");
        }
        for (int i = amtIndex; i < n; ++i) {
            fld = flds.get(i);
            sql.append(", sum(").append(fld).append(") ");
            sql.append(fld);
        }
        sql.append(CRTL).append(" from ").append(factTbl);
        sql.append(CRTL).append(" where CHARINDEX(N'");
        sql.append(compInfo.getLongNumber());
        sql.append("', FCompLongNumber) > 0 and FIsCompLeaf = 1 ");
        if (param.getGroupTypeIndex() == 1 || param.getGroupTypeIndex() == 2) {
            sql.append(" and fissum != 1 ").append(CRTL);
            sql.append(" group by ");
        } else {
            sql.append(CRTL).append(" group by FAsstActId, FAsstActNumber, FAsstActType,");
            sql.append(" FAsstActTypeID, FCussAcct, ").append(CRTL);
        }
        sql.append(ArApAgingRptSqlHelper.getCurrencyCols(param, false));
        return sql.toString();
    }
}

