/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.ArApQueryParam;
import com.kingdee.eas.fi.ar.app.ArApReportHelper;
import com.kingdee.eas.fi.arap.app.util.TempTableUtil;
import com.kingdee.eas.fi.arap.util.CollectionUtil;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.log4j.Logger;

public class ArApBiRptHelper {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ar.app.ArApBiRptHelper");

    private ArApBiRptHelper() {
    }

    public static String initCompanyDimension(Context ctx, List companyIds, SchemaSource ss) throws BOSException, EASBizException {
        String nameFld = ArApReportHelper.getNameFld(ctx);
        boolean fComps = companyIds.size() > 1;
        StringBuffer sql = new StringBuffer();
        String compTblDefine = " (FId varchar(44), FNumber nvarchar(80), FName nvarchar(200), FParentid varchar(44)) ";
        String compTbl = TempTableUtil.createTempTable(ctx, compTblDefine);
        if (fComps) {
            Connection con = null;
            Statement stmt = null;
            try {
                con = EJBFactory.getConnection((Context)ctx);
                stmt = con.createStatement();
                sql.append("insert into ").append(compTbl);
                sql.append(" (FId, FNumber, FName, FParentId) ");
                sql.append("\r\n select fid, fnumber, ").append(nameFld);
                sql.append(" fname, fparentid from ");
                sql.append(" t_org_company where fid in (");
                sql.append(CollectionUtil.ids2SqlString(companyIds));
                sql.append(") ");
                logger.debug((Object)("insert comp table \r\n " + sql));
                stmt.execute(sql.toString());
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"exception, preprare compids ", (Throwable)ex);
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(stmt, (Connection)con);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)stmt, (Connection)con);
        }
        if (fComps) {
            sql.delete(0, sql.length());
            sql.append("select FId, FName, FNumber, FParentId from ");
            sql.append(compTbl);
            ss.setDataItem("Company", sql.toString(), null);
        } else {
            sql.append("select FId, ").append(nameFld);
            sql.append(" FName, FNumber, FParentId from ");
            sql.append(" t_org_company where fid = ? ");
            SqlParams sqlParam = new SqlParams();
            sqlParam.addString(companyIds.get(0).toString());
            ss.setDataItem("Company", sql.toString(), sqlParam);
        }
        return compTbl;
    }

    public static void initCurrencyDimension(String nameFld, ArApQueryParam param, SchemaSource ss) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select fid, ").append(nameFld);
        sql.append(" fname, fnumber from t_bd_currency ");
        sql.append(" where ");
        SqlParams currParam = new SqlParams();
        if (param.isAllCurrency()) {
            sql.append(" FId != ? and FId != ? ");
            currParam.addString(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString());
            currParam.addString(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString());
        } else {
            sql.append(" FId = ?");
            currParam.addString(param.getCurrencyId());
        }
        ss.setDataItem("Currency", sql.toString(), currParam);
    }

    public static void initCussTypeDimension(String nameFld, String cussTypeId, SchemaSource ss) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FId, ").append(nameFld);
        sql.append(" FName, FNumber from t_bd_AsstActType where fid = ? ");
        SqlParams sqlParam = new SqlParams();
        sqlParam.addString(cussTypeId);
        ss.setDataItem("CussType", sql.toString(), sqlParam);
    }

    public static void initComanysCussAcctDimension(Context ctx, ArApQueryParam param, List companyIds, SchemaSource ss) throws BOSException, EASBizException {
        String cussAcctTbl = ArApReportHelper.getCussAcctTempTbl(ctx, param, companyIds);
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct FId, FNumber || N' ' || ");
        sql.append("case when FName is null then N' ' else FName end as FName");
        sql.append(", FNumber from ").append(cussAcctTbl);
        ss.setDataItem("CussAcct", sql.toString(), null);
    }
}

