/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.ExchangeRateUtils;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodException;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroupStandard;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.app.util.ApServerUtils;
import com.kingdee.eas.fi.ar.AccountAgeQueryParam;
import com.kingdee.eas.fi.ar.ArApCommonException;
import com.kingdee.eas.fi.ar.ArApQueryParam;
import com.kingdee.eas.fi.ar.CAStmtQueryParam;
import com.kingdee.eas.fi.ar.SummaryRptQueryParam;
import com.kingdee.eas.fi.ar.app.util.ArServerUtils;
import com.kingdee.eas.fi.arap.app.util.TempTableUtil;
import com.kingdee.eas.fi.arap.util.CollectionUtil;
import com.kingdee.eas.fi.arap.util.DBUtil;
import com.kingdee.eas.fi.arap.util.Helper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class ArApReportHelper {
    private static final Logger logger = Logger.getLogger((String)ArApReportHelper.class.getName());
    public static final String CRTL = " \r\n ";

    public static boolean detectTable(Context ctx, String tableName) {
        boolean isOk = true;
        String sql = new StringBuffer(100).append("select count(1) cnt from ").append(tableName).toString();
        try {
            DBUtil.executeQuery((Context)ctx, (String)sql);
        }
        catch (Exception e) {
            logger.error((Object)("execute sql =[" + sql + "] error:" + e.getMessage()));
            isOk = false;
        }
        return isOk;
    }

    private ArApReportHelper() {
    }

    protected static PeriodInfo getPeriodStartToCount(Context ctx, CAStmtQueryParam param, boolean fAR) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
        companyInfo.setId(BOSUuid.read((String)param.getCompanyId()));
        PeriodInfo currentPeriod = null;
        currentPeriod = fAR ? ArServerUtils.getArCurrentPeriod(ctx, companyInfo) : ApServerUtils.getApCurrentPeriod(ctx, companyInfo);
        if (currentPeriod == null) {
            throw new ArApCommonException(fAR ? ArApCommonException.AR_STARTPERIOD_NULL : ArApCommonException.AP_STARTPERIOD_NULL);
        }
        PeriodInfo qryInPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (java.util.Date)param.getBeginDate(), (CompanyOrgUnitInfo)companyInfo);
        if (qryInPeriod == null) {
            throw new ArApCommonException(fAR ? ArApCommonException.AR_STARTPERIOD_NULL : ArApCommonException.AP_STARTPERIOD_NULL);
        }
        if (ArApReportHelper.isAfter(currentPeriod, qryInPeriod)) {
            return currentPeriod;
        }
        return qryInPeriod;
    }

    public static boolean isAfter(PeriodInfo period, PeriodInfo otherPeriod) {
        if (otherPeriod.getPeriodYear() > period.getPeriodYear()) {
            return true;
        }
        return otherPeriod.getPeriodYear() == period.getPeriodYear() && otherPeriod.getPeriodNumber() > period.getPeriodNumber();
    }

    public static boolean isEquals(PeriodInfo period, PeriodInfo otherPeriod) {
        if (otherPeriod.getPeriodYear() > period.getPeriodYear()) {
            return false;
        }
        return otherPeriod.getPeriodYear() == period.getPeriodYear() && otherPeriod.getPeriodNumber() == period.getPeriodNumber();
    }

    public static boolean isSameorAfter(PeriodInfo period, PeriodInfo otherPeriod) {
        if (period.getPeriodYear() > otherPeriod.getPeriodYear()) {
            return true;
        }
        return period.getPeriodYear() == otherPeriod.getPeriodYear() && period.getPeriodNumber() >= otherPeriod.getPeriodNumber();
    }

    protected static String getAgeRptSql(Context ctx, AccountAgeQueryParam param, String agedBillTable) {
        boolean fByBill = param.getAnalyseObjIndex() == 1;
        Date endDate = param.getEndDate();
        int amtFldIndex = param.getAmtColStartIndex();
        List<String> lstFlds = param.getReportFields();
        StringBuffer grpSql = new StringBuffer(60);
        StringBuffer rsStrFlds = new StringBuffer(41);
        rsStrFlds.append("FCussAcctId, ");
        if (!fByBill) {
            grpSql.append(" group by FCussAcctId, FCussType, FCussNum, FCussName, FCurrency ");
            rsStrFlds.append((Object)lstFlds.get(0)).append(", ").append((Object)lstFlds.get(1)).append(", ").append((Object)lstFlds.get(2));
        } else {
            grpSql.append(" group by FCussAcctId, FCurrency, FBillDate, FBillNum, FBillType, ").append("FCussType, FCussAcctId, FCussNum, FCussName, FDescription").append(", FBillId ");
            rsStrFlds.append((Object)lstFlds.get(0)).append(", ").append((Object)lstFlds.get(1)).append(", ").append((Object)lstFlds.get(2)).append(", ").append((Object)lstFlds.get(3)).append(", ").append((Object)lstFlds.get(4)).append(", ").append((Object)lstFlds.get(5)).append(", ").append((Object)lstFlds.get(6)).append(", ").append((Object)lstFlds.get(7));
        }
        int fldSize = lstFlds.size();
        StringBuffer qrySql = new StringBuffer(500);
        qrySql.append(" insert into ").append(param.getTempTable());
        qrySql.append("\r\n select ").append(rsStrFlds).append("\r\n");
        for (int i = amtFldIndex; i < fldSize; ++i) {
            qrySql.append(", sum(").append((Object)lstFlds.get(i)).append(") ").append((Object)lstFlds.get(i));
        }
        qrySql.append(", 0 FDataType \r\n from (\r\n");
        String dateFld = null;
        switch (param.getDateFldIndex()) {
            case 0: {
                dateFld = "FRecPayDate";
                break;
            }
            case 1: {
                dateFld = "FBillDate";
                break;
            }
            case 2: {
                dateFld = "FBizDate";
            }
        }
        String amtFld = " sum(FUnVerifyAmt) ";
        SimpleDateFormat dtFormat = new SimpleDateFormat("yyyy-MM-dd");
        List lstOverdueDate = param.getOverdueDateList();
        List lstUndueDate = param.getUndueDateList();
        String fld = null;
        StringBuffer whereSql = new StringBuffer();
        int dateInd = -1;
        boolean fUL = false;
        boolean fOL = false;
        Date preDate = null;
        int j = 0;
        for (int i = amtFldIndex; i < fldSize; ++i) {
            Date qryDate;
            fld = lstFlds.get(i).toString();
            qrySql.append(" select ").append(rsStrFlds);
            whereSql.delete(0, whereSql.length());
            for (j = amtFldIndex; j < fldSize; ++j) {
                if (i == j) {
                    qrySql.append(", ").append(amtFld);
                } else {
                    qrySql.append(", 0 ");
                }
                qrySql.append((Object)lstFlds.get(j));
            }
            if (fld.indexOf("FUL_") != -1) {
                dateInd = dateInd + 1 < lstUndueDate.size() ? dateInd + 1 : dateInd;
                qryDate = (Date)lstUndueDate.get(dateInd);
                if (!fUL) {
                    preDate = endDate;
                    fUL = true;
                } else {
                    preDate = (Date)lstUndueDate.get(dateInd - 1);
                }
                if (dateInd == lstUndueDate.size() - 1) {
                    whereSql.append(" where ").append(dateFld).append(" > {").append(dtFormat.format(qryDate)).append("}");
                } else {
                    whereSql.append(" where ").append(dateFld).append(" > {");
                    whereSql.append(dtFormat.format(preDate)).append("} and ").append(dateFld).append(" <= {").append(dtFormat.format(qryDate)).append("} ");
                }
            } else if (fld.indexOf("FOL_") != -1) {
                dateInd = dateInd > 0 && !fOL ? 0 : dateInd + 1;
                qryDate = (Date)lstOverdueDate.get(dateInd);
                if (!fOL) {
                    preDate = endDate;
                    fOL = true;
                } else {
                    preDate = (Date)lstOverdueDate.get(dateInd - 1);
                }
                if (lstOverdueDate.size() - 1 == dateInd) {
                    whereSql.append(" where ").append(dateFld).append(" < {");
                    whereSql.append(dtFormat.format(qryDate)).append("} ");
                } else {
                    whereSql.append(" where ").append(dateFld).append("  >= {");
                    whereSql.append(dtFormat.format(qryDate));
                    whereSql.append("}  and ").append(dateFld).append("  < {");
                    whereSql.append(dtFormat.format(preDate)).append("}");
                }
            } else if (fld.equals("FDue")) {
                whereSql.append(" Where ").append(dateFld).append(" = {");
                whereSql.append(dtFormat.format(endDate)).append("} ");
            }
            qrySql.append("\r\n from ").append(agedBillTable);
            qrySql.append("\r\n ").append(whereSql).append(grpSql);
            if (i + 1 >= fldSize) continue;
            qrySql.append("\r\n union all \r\n");
        }
        qrySql.append("\r\n)  t_ar_agesRpt\r\n group by ").append(rsStrFlds);
        return qrySql.toString();
    }

    protected static String getNameFld(Context ctx) {
        String nameFld = "FName_" + ctx.getLocale().getLanguage() + " ";
        return nameFld;
    }

    protected static String getAgedBillDataSql(Context ctx, AccountAgeQueryParam param, String agedBillTable, boolean fAR) {
        boolean fByBill = param.getAnalyseObjIndex() == 1;
        boolean isAgeByPlanDate = param.isAgeByPlanDate();
        String nameFld = ArApReportHelper.getNameFld(ctx);
        String tbl = fAR ? " T_AR_OtherBill" : " T_AP_OtherBill";
        String fld_cussType = "FAsstActTypeID ";
        String fld_cussAcct = "FAsstActId ";
        boolean fAllCurrency = param.isAllCurrency();
        StringBuffer sql = new StringBuffer(200);
        sql.append("insert into ").append(agedBillTable);
        sql.append(" \r\n select t2. ").append(nameFld);
        sql.append("FCussType, t3.FId FCussAcctId, t3.FNumber FCussNum, ");
        sql.append(" t3.").append(nameFld).append(" FCussName, t4.");
        sql.append(nameFld).append(" FCurrency, t1.FBillDate FBillDate,");
        sql.append(" t1.FRecPayDate, t1.FUnVerifyAmt");
        if (fByBill) {
            sql.append(", t1.FBillType, t1.FNumber FBillNum, t1.FId FBillId, t1.FDescription");
        }
        sql.append(" from \r\n (select t1.FId, t1.");
        sql.append(fld_cussType).append(" FCussTypeId, t1.");
        sql.append(fld_cussAcct).append(" FCussAcctId, t1.FCurrencyId, ");
        sql.append(" t1.FBillDate,  ");
        sql.append(isAgeByPlanDate ? "t2.FRecievePayDate" : "t1.FBillDate");
        sql.append(" FRecPayDate, ");
        sql.append("(t2.FRecievePayAmount - t2.FVerifyAmount) FUnVerifyAmt");
        if (fByBill) {
            sql.append(", t1.FAbstractName FDescription, t1.FNumber, ").append(" t1.FBillType FBillType ");
        }
        sql.append("\r\n from ").append(tbl);
        sql.append(" t1 inner join ").append(tbl);
        sql.append(isAgeByPlanDate ? "Plan" : "Entry");
        sql.append(" t2 on t1.FId = t2.FParentId \r\n where 1 = 1 ");
        sql.append(" and t1.").append(fld_cussType).append(" = '").append(param.getCussTypeId()).append("' ");
        if (!fAllCurrency) {
            sql.append(" and t1.FCurrencyId = '").append(param.getCurrencyId()).append("' ");
        }
        sql.append(" \r\n and t1.FCompanyId = '").append(param.getCompanyId());
        sql.append("' and t1.FUnVerifyAmount <> 0 and t1.FBillStatus = 3 ");
        SimpleDateFormat dtFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date endDate = new Date(param.getEndDate().getTime());
        endDate.setTime(endDate.getTime() + 86400000L);
        sql.append(" and t1.FBillDate < {").append(dtFormat.format(endDate)).append("}");
        if (!StringUtils.isEmpty((String)param.getAdminOrgId())) {
            sql.append(" and t1.FAdminOrgUnitId = '").append(param.getAdminOrgId()).append("' ");
        }
        if (!StringUtils.isEmpty((String)param.getSalesId())) {
            sql.append(" and t1.FPersonId = '");
            sql.append(param.getSalesId()).append("' ");
        }
        sql.append(") t1 \r\n left join t_bd_asstActType t2");
        sql.append(" on t1.FCussTypeId = t2.fid ");
        sql.append("\r\n inner join ").append(param.getCussAcctTempTable());
        sql.append(" t3 on t1.FCussAcctId = t3.FId");
        sql.append("\r\n left join t_bd_currency t4 on t1.Fcurrencyid = t4.fid ");
        return sql.toString();
    }

    public static void dropView(Context ctx, String view) throws BOSException {
        if (StringUtils.isEmpty((String)view)) {
            return;
        }
        String sql = "drop view " + view;
        DbUtil.execute((Context)ctx, (String)sql);
    }

    public static EntityViewInfo getCussAcctView(Context ctx, ArApQueryParam param) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("id");
        view.getSelector().add("name");
        view.getSelector().add("number");
        FilterInfo filter = null;
        AsstActTypeInfo cussTypeInfo = param.getCussAcctTypeInfo();
        String tblName = cussTypeInfo.getRealtionDataObject();
        filter = ArApReportHelper.getNumRangeFilterItem(param.getCussAcctFromNum(), param.getCussAcctToNum());
        FilterInfo comFilter = ArApReportHelper.getCompanyCuDataAssignFilter(ctx, param);
        if (filter != null && comFilter != null) {
            try {
                filter.mergeFilter(comFilter, "and");
            }
            catch (BOSException e) {
                logger.error((Object)"filter merge exception", (Throwable)e);
            }
        } else if (filter == null && comFilter != null) {
            filter = comFilter;
        }
        if (filter == null) {
            filter = new FilterInfo();
        }
        if (tblName.equalsIgnoreCase("t_bd_generalasstacttype") && cussTypeInfo.getGlAsstActTypeGrp() != null) {
            filter.getFilterItems().add(new FilterItemInfo("group.id", (Object)cussTypeInfo.getGlAsstActTypeGrp().getId()));
        }
        view.setFilter(filter);
        return view;
    }

    protected static FilterInfo getNumRangeFilterItem(String cussFromNum, String cussToNum) {
        FilterInfo filter = null;
        if (!StringUtils.isEmpty((String)cussFromNum)) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)cussFromNum, CompareType.GREATER_EQUALS));
        }
        if (!StringUtils.isEmpty((String)cussToNum)) {
            filter = filter == null ? new FilterInfo() : filter;
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)cussToNum, CompareType.LESS_EQUALS));
        }
        return filter;
    }

    protected static FilterInfo getCompanyCuDataAssignFilter(Context ctx, ArApQueryParam param) throws BOSException, EASBizException {
        boolean fCusSup;
        String tblName = param.getCussTable().toLowerCase(Locale.ENGLISH);
        boolean fCustomer = tblName.equalsIgnoreCase("t_bd_customer");
        boolean fSupplier = tblName.equalsIgnoreCase("t_bd_supplier");
        boolean fMaterial = tblName.equalsIgnoreCase("t_bd_material");
        boolean fBank = tblName.equalsIgnoreCase("t_bd_accountbanks");
        boolean bl = fCusSup = fCustomer || fSupplier;
        if (!(fCusSup || fMaterial || fBank)) {
            return null;
        }
        String companyId = param.getCompanyId();
        FilterInfo comFilter = new FilterInfo();
        String fldCompany = ArApReportHelper.getCussAcctCompFilterFldName(fMaterial, fBank, fCusSup);
        if (fBank) {
            comFilter.getFilterItems().add(new FilterItemInfo(fldCompany, (Object)companyId));
            comFilter.getFilterItems().add(new FilterItemInfo(fldCompany, null));
            comFilter.setMaskString("#0 OR #1");
            return comFilter;
        }
        ArApReportHelper.addCustSupMaterialStatusFilter(comFilter, fMaterial, fCusSup);
        if (!StringUtils.isEmpty((String)fldCompany)) {
            FilterItemInfo item = new FilterItemInfo(fldCompany, (Object)companyId);
            comFilter.getFilterItems().add(item);
        }
        try {
            if (fCusSup) {
                if (param instanceof SummaryRptQueryParam && ((SummaryRptQueryParam)param).isExcludeInnerCust()) {
                    comFilter.getFilterItems().add(new FilterItemInfo("isInternalCompany", (Object)Boolean.FALSE));
                }
                ArApReportHelper.addCsspGrpFilter(ctx, param, comFilter, fCustomer);
            }
        }
        catch (Exception e) {
            logger.error((Object)" error! while get the asstAct's  filter ", (Throwable)e);
        }
        return comFilter;
    }

    private static String getCussAcctCompFilterFldName(boolean fMaterial, boolean fBank, boolean fCusSup) {
        String fldCompany = "";
        if (fCusSup) {
            fldCompany = "companyOrgUnit.id";
        } else if (fBank) {
            fldCompany = "company.id";
        } else if (fMaterial) {
            fldCompany = "";
        }
        return fldCompany;
    }

    private static FilterInfo getDataAssignFilter(Context ctx, String cussTable, IObjectPK cuPK) throws BOSException, EASBizException {
        FilterInfo cuFilter = null;
        if (cussTable.equalsIgnoreCase("t_bd_customer")) {
            ICustomer iCust = CustomerFactory.getLocalInstance((Context)ctx);
            cuFilter = iCust.getDatabaseDFilter(cuPK, "id", "adminCU.id");
        } else if (cussTable.equalsIgnoreCase("t_bd_supplier")) {
            ISupplier iSupp = SupplierFactory.getLocalInstance((Context)ctx);
            cuFilter = iSupp.getDatabaseDFilter(cuPK, "id", "adminCU.id");
        } else if (cussTable.equalsIgnoreCase("t_bd_material")) {
            IMaterial iMater = MaterialFactory.getLocalInstance((Context)ctx);
            cuFilter = iMater.getDatabaseDFilter(cuPK, "id", "adminCU.id");
        }
        return cuFilter;
    }

    private static FilterItemInfo getCsspGrpBasicStdFilter(Context ctx, boolean fCustomer) throws BOSException, EASBizException {
        FilterItemInfo csspGrpStdFilter = null;
        String cussSupType = fCustomer ? "1" : "2";
        try {
            ICSSPGroupStandard icssStandard = CSSPGroupStandardFactory.getLocalInstance((Context)ctx);
            String standardId = icssStandard.getBasicStandardId(cussSupType);
            String field = "browseGroup.groupStandard";
            csspGrpStdFilter = new FilterItemInfo(field, (Object)standardId);
            return csspGrpStdFilter;
        }
        catch (Exception e) {
            logger.error((Object)"error while getting the cssp group standard", (Throwable)e);
            return null;
        }
    }

    protected static String getAgedBillSumSql(Context ctx, AccountAgeQueryParam param) {
        int i;
        boolean fByBill = param.getAnalyseObjIndex() != 0;
        String res = "com.kingdee.eas.fi.ar.ArReport";
        String lbl = ResourceBase.getString((String)res, (String)"Lbl_Sum", (Locale)ctx.getLocale());
        List<String> lstFlds = param.getReportFields();
        int amtFldIndex = param.getAmtColStartIndex();
        StringBuffer sumSql = new StringBuffer();
        sumSql.append("insert into ").append(param.getTempTable());
        sumSql.append("\r\n (FCussName, FCurrency");
        int n = lstFlds.size();
        for (i = amtFldIndex; i < n; ++i) {
            sumSql.append(", ").append((Object)lstFlds.get(i));
        }
        sumSql.append(", FCussAcctId, FCussNum, FDataType) \r\n");
        sumSql.append(" select N'").append(lbl).append("' FCussName,");
        sumSql.append(" FCurrency");
        n = lstFlds.size();
        for (i = amtFldIndex; i < n; ++i) {
            sumSql.append(", sum(").append((Object)lstFlds.get(i)).append(")");
        }
        sumSql.append(", FCussAcctId, FCussNum, ");
        sumSql.append(fByBill ? 1 : 2).append(" FDataType \r\n");
        sumSql.append(" from ").append(param.getTempTable());
        sumSql.append(" group by FCurrency, FCussNum, FCussName, FCussAcctId");
        return sumSql.toString();
    }

    public static PeriodCollection getPeriodCollection(Context ctx, java.util.Date beginDate, java.util.Date endDate, String companyId) throws BOSException, EASBizException {
        if (companyId == null || companyId.length() == 0) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        if (beginDate == null || endDate == null) {
            return null;
        }
        String oql = "select id, accountPeriodType.id where id = '" + companyId + "'";
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo(oql);
        if (companyInfo.getAccountPeriodType() == null) {
            return null;
        }
        return ArApReportHelper.getPeriodCollection(ctx, beginDate, endDate, companyInfo);
    }

    protected static PeriodCollection getPeriodCollection(Context ctx, java.util.Date beginDate, java.util.Date endDate, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItems = filter.getFilterItems();
        filterItems.add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate((java.util.Date)beginDate), CompareType.GREATER_EQUALS));
        filterItems.add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate((java.util.Date)endDate), CompareType.LESS_EQUALS));
        filterItems.add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate((java.util.Date)beginDate), CompareType.GREATER_EQUALS));
        filterItems.add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate((java.util.Date)endDate), CompareType.LESS_EQUALS));
        filterItems.add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isAdjustPeriod", (Object)new Integer(0)));
        filter.setMaskString("((#0 and #1) or (#2 and #3)) and #4 and #5 ");
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("periodYear"));
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() == 0 && beginDate.equals(endDate)) {
            PeriodInfo periodFrom = PeriodUtils.getPeriodInfo((Context)ctx, (java.util.Date)beginDate, (CompanyOrgUnitInfo)companyInfo);
            periodc.add(periodFrom);
        }
        return periodc;
    }

    protected static boolean isInRange(int row, int start, int end) {
        if (start <= 0 || end <= 0) {
            return true;
        }
        return row >= start && row <= end;
    }

    public static String getCussObjsSql(Context ctx, ArApQueryParam param) throws BOSException, EASBizException {
        String queryFromIds = ArApReportHelper.getCussAcctQuery(ctx, param);
        if (!StringUtils.isEmpty((String)queryFromIds)) {
            return queryFromIds;
        }
        AsstActTypeInfo cussTypeInfo = param.getCussAcctTypeInfo();
        String qryName = cussTypeInfo.getDefaultQueryName();
        String tblName = cussTypeInfo.getRealtionDataObject();
        if ("T_BD_PERSON".equalsIgnoreCase(tblName)) {
            qryName = "com.kingdee.eas.basedata.person.app.AllPersonQuery";
        } else if ("T_BD_GeneralAsstActType".equalsIgnoreCase(tblName)) {
            qryName = "com.kingdee.eas.fi.arap.app.F7GeneralAsstActTypeQuery";
        }
        if (param.isCustSupplAcctCuss()) {
            qryName = param.isCustomerAcctCuss() ? "com.kingdee.eas.basedata.master.cssp.app.F7CustomerCompanyQuery" : "com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyQuery";
        }
        MetaDataPK cussQryPK = new MetaDataPK(qryName);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)cussQryPK);
        EntityViewInfo view = ArApReportHelper.getCussAcctView(ctx, param);
        exec.setObjectView(view);
        exec.option().isIgnoreOrder = true;
        StringBuffer sql = new StringBuffer();
        sql.append(exec.getSQL());
        return sql.toString();
    }

    private static void addCsspGrpFilter(Context ctx, ArApQueryParam param, FilterInfo comFilter, boolean fCustomer) throws BOSException, EASBizException {
        FilterItemInfo csspGrpStdFilter = null;
        csspGrpStdFilter = StringUtils.isEmpty((String)param.getCsspGrpStdId()) ? ArApReportHelper.getCsspGrpBasicStdFilter(ctx, fCustomer) : new FilterItemInfo("browseGroup.groupStandard", (Object)param.getCsspGrpStdId());
        if (csspGrpStdFilter != null) {
            comFilter.getFilterItems().add(csspGrpStdFilter);
        }
        if (!StringUtils.isEmpty((String)param.getCsspGrpId())) {
            FilterInfo grpFilter = Helper.getCsspGrpFilter(ctx, param.getCsspGrpId());
            comFilter.mergeFilter(grpFilter, "and");
        }
    }

    private static void addCustSupMaterialStatusFilter(FilterInfo comFilter, boolean fMaterial, boolean fCusSup) {
        if (fCusSup) {
            comFilter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(0), CompareType.GREATER));
        }
        if (fMaterial) {
            Integer approvedIntVal = new Integer(0);
            comFilter.getFilterItems().add(new FilterItemInfo("status", (Object)approvedIntVal, CompareType.GREATER));
        }
    }

    public static String getCussAcctTempTbl(Context ctx, ArApQueryParam param, List companyIds) throws BOSException, EASBizException {
        String tmpCussAcctTbl = null;
        String insSql = "insert into %s (FId, FName, FNumber)  \r\n ";
        StringBuilder buf = new StringBuilder(800);
        String querySql = ArApReportHelper.getCussAcctTempTblSelectSql(ctx, param);
        tmpCussAcctTbl = ArApReportHelper.createCussAcctTempTable(ctx);
        buf.append(String.format(insSql, tmpCussAcctTbl)).append(querySql);
        logger.debug((Object)("init CussAcct:\r\n" + buf.toString()));
        DBUtil.execute((Context)ctx, (String)buf.toString());
        try {
            if (null != tmpCussAcctTbl) {
                TempTablePool tmpTblPool = TempTablePool.getInstance((Context)ctx);
                tmpTblPool.createIndex(tmpCussAcctTbl, "FId", false, false);
            }
        }
        catch (Exception e) {
            logger.info((Object)"createIndex error:", (Throwable)e);
        }
        param.setCussAcctTempTable(tmpCussAcctTbl);
        return tmpCussAcctTbl;
    }

    public static void updateWrongCompanyParentId(Context ctx, ArApQueryParam param, List companyIds, CompanyOrgUnitCollection virComps) throws BOSException {
        HashMap<String, BOSUuid> vIdsMap = new HashMap<String, BOSUuid>();
        int n = virComps.size();
        for (int i = 0; i < n; ++i) {
            CompanyOrgUnitInfo compInfo = virComps.get(i);
            vIdsMap.put(compInfo.getLongNumber(), compInfo.getId());
        }
        StringBuilder sql = new StringBuilder(300);
        sql.append("select distinct FParentCompanyId, FCompLongNumber, ");
        sql.append("FCompLevel\r\n from ").append(param.getTempTable());
        sql.append(" t1\r\n where t1.FIsSum = 0 and t1.FIsCompLeaf = 1");
        sql.append(" and t1.FParentCompanyId not in (");
        sql.append(CollectionUtil.toSqlString(companyIds));
        sql.append(")\r\n order by FCompLevel, FCompLongNumber");
        logger.debug((Object)("AgingRpt wrong parentCompId:\r\n" + sql));
        Connection con = null;
        Statement stmt = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            stmt = con.createStatement();
            rs = stmt.executeQuery(sql.toString());
            StringBuilder uql = new StringBuilder(200);
            uql.append("update ").append(param.getTempTable());
            uql.append(" set FParentCompanyId = ? where FParentCompanyId = ?");
            logger.debug((Object)("AgingRpt update parentCompId:\r\n" + uql));
            pstmt = con.prepareStatement(uql.toString());
            boolean fUpdate = false;
            String pid = null;
            String compLongNum = null;
            String pNum = null;
            int level = 0;
            int lvIndex = 0;
            while (rs.next()) {
                pid = rs.getString(1);
                compLongNum = rs.getString(2);
                level = rs.getInt(3);
                pNum = compLongNum;
                for (int i = 0; i < level - 1; ++i) {
                    lvIndex = pNum.lastIndexOf("!");
                    if (vIdsMap.get(pNum = pNum.substring(0, lvIndex)) == null) continue;
                    pstmt.setString(1, vIdsMap.get(pNum).toString());
                    pstmt.setString(2, pid);
                    fUpdate = true;
                    pstmt.addBatch();
                }
            }
            if (fUpdate) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"exception, AgingRpt", (Throwable)ex);
                throw new BOSException("exception, AgingRpt", (Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
    }

    public static int getCompsTopLevel(Context ctx, List companyIds) throws BOSException {
        int compTopLevel = 1;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.getSelector().add("level");
        HashSet idSet = new HashSet();
        idSet.addAll(companyIds);
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        SorterItemInfo sorter = new SorterItemInfo("level");
        sorter.setSortType(SortType.ASCEND);
        view.getSorter().add(sorter);
        ICompanyOrgUnit iComp = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitCollection comps = iComp.getCompanyOrgUnitCollection(view);
        compTopLevel = comps.get(0).getLevel();
        return compTopLevel;
    }

    public static Set getCompanyNums(Context ctx, String tmpTable) throws BOSException {
        HashSet<String> CompanyNumSet = new HashSet<String>();
        try {
            String sql = "select FCompLongNumber from " + tmpTable + " group by FCompLongNumber order by FCompLongNumber asc ";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String CompanyNum = rs.getString(1);
                if (null == CompanyNum) continue;
                CompanyNumSet.add(CompanyNum);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return CompanyNumSet;
    }

    public static CompanyOrgUnitCollection getCompanyByIds(Context ctx, List companyIds) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("id");
        view.getSelector().add("cu.id");
        HashSet idSet = new HashSet();
        idSet.addAll(companyIds);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Integer(1)));
        view.setFilter(filter);
        CompanyOrgUnitCollection comps = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
        return comps;
    }

    public static String createCussAcctTempTable(Context ctx) throws BOSException {
        String tmpTblDefine = " (FId varchar(44), FNumber nvarchar(80), FName nvarchar(400)) ";
        String tmpCussAcctTbl = TempTableUtil.createTempTable(ctx, tmpTblDefine);
        return tmpCussAcctTbl;
    }

    public static String getCussAcctTempTblSelectSql(Context ctx, ArApQueryParam param) throws BOSException, EASBizException {
        List companyIds = param.getCompanyIds();
        StringBuilder queryBuf = new StringBuilder(800);
        queryBuf.append(ArApReportHelper.getCussAcctQuery(ctx, param));
        if (queryBuf.length() == 0) {
            CompanyOrgUnitCollection comps = ArApReportHelper.getCompanyByIds(ctx, companyIds);
            int n = comps.size();
            for (int i = 0; i < n; ++i) {
                CompanyOrgUnitInfo compInfo = comps.get(i);
                param.setCompanyId(compInfo.getId().toString());
                param.setCuId(compInfo.getCU().getId().toString());
                if (queryBuf.length() > 0) {
                    queryBuf.append(CRTL).append("UNION").append(CRTL);
                }
                queryBuf.append(ArApReportHelper.getCussObjsSql(ctx, param));
            }
        }
        logger.debug((Object)("init CussAcct queryBuf:\r\n" + queryBuf.toString()));
        return queryBuf.toString();
    }

    public static String getCussAcctQuery(Context ctx, ArApQueryParam param) {
        StringBuffer buf = new StringBuffer(300);
        if (null != param.getCussAcctFromIds() && param.getCussAcctFromIds().size() > 0) {
            buf.append(" select distinct fid, ").append(ArApReportHelper.getNameFld(ctx)).append(", fnumber\r\n from ").append(param.getCussTable()).append("\r\n where fid in (").append(CollectionUtil.toSqlString(param.getCussAcctFromIds())).append(")");
        }
        return buf.toString();
    }
}

