/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.message.BMCMessageFactory;
import com.kingdee.eas.base.message.BMCMessageInfo;
import com.kingdee.eas.base.message.MsgBizType;
import com.kingdee.eas.base.message.MsgPriority;
import com.kingdee.eas.base.message.MsgStatus;
import com.kingdee.eas.base.message.MsgType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.scm.sd.sale.SaleGroupInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.ar.ArElecInvoiceFacadeFactory;
import com.kingdee.eas.fi.ar.ArInvoiceCollection;
import com.kingdee.eas.fi.ar.ArInvoiceEntryCollection;
import com.kingdee.eas.fi.ar.ArInvoiceEntryInfo;
import com.kingdee.eas.fi.ar.ArInvoiceFactory;
import com.kingdee.eas.fi.ar.ArInvoiceInfo;
import com.kingdee.eas.fi.ar.IArElecInvoiceFacade;
import com.kingdee.eas.fi.ar.IArInvoice;
import com.kingdee.eas.fi.ar.IOtherBill;
import com.kingdee.eas.fi.ar.OtherBillCollection;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.fi.ar.OtherBillTypeEnum;
import com.kingdee.eas.fi.ar.OtherBillentryCollection;
import com.kingdee.eas.fi.ar.OtherBillentryInfo;
import com.kingdee.eas.fi.ar.app.AbstractArElecInvoiceFacadeControllerBean;
import com.kingdee.eas.fi.arap.ColorTypeEnum;
import com.kingdee.eas.fi.arap.EIVCConfigFactory;
import com.kingdee.eas.fi.arap.EIVCConfigInfo;
import com.kingdee.eas.fi.arap.EIVCreatedInvoiceCollection;
import com.kingdee.eas.fi.arap.EIVCreatedInvoiceFactory;
import com.kingdee.eas.fi.arap.EIVCreatedInvoiceInfo;
import com.kingdee.eas.fi.arap.InvoiceTypeEnum;
import com.kingdee.eas.fi.arap.electronicInvoice.eiv.EIVCService;
import com.kingdee.eas.fi.arap.util.H;
import com.kingdee.eas.fi.arap.util.remote.exception.MethodState;
import com.kingdee.eas.fi.arap.util.remote.exception.RemoteMethodException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ArElecInvoiceFacadeControllerBean
extends AbstractArElecInvoiceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ar.app.ArElecInvoiceFacadeControllerBean");
    AsstActTypeInfo asstActTypeInfo = null;

    public void throwEASException(String message, Throwable e) throws EASBizException {
        logger.error((Object)message, e);
        H.throwEASBizException(message, e);
    }

    public void throwEASException(String message) throws EASBizException {
        logger.error((Object)message);
        throw new EASBizException(new NumericExceptionSubItem("1", message));
    }

    public void throwBOSException(Throwable e) throws BOSException {
        logger.error((Object)e);
        throw new BOSException(e);
    }

    @Override
    protected Map _downloadInvoice(Context ctx, Map param) throws BOSException, EASBizException {
        block5: {
            IArElecInvoiceFacade biz;
            List ids;
            BOSObjectType srctype;
            Map cache;
            block4: {
                cache = H.CACHE();
                srctype = H.BOSTYPE(param.get("srctype"));
                ids = (List)param.get("ids");
                biz = ArElecInvoiceFacadeFactory.getLocalInstance(ctx);
                if (!H.same(srctype, H.BOSTYPE(SaleIssueBillInfo.class))) break block4;
                List<String> lshs = this.getAllLsh(ctx, ids, srctype, cache);
                if (lshs == null) {
                    return null;
                }
                for (int i = 0; i < lshs.size(); ++i) {
                    String srcid = (String)cache.get("ids" + lshs.get(i));
                    SaleIssueBillInfo srcInfo = (SaleIssueBillInfo)H.getInfo(ctx, new Object[]{srcid, H.SIC("*,customer.*,company.cu"), H.FILTER("id = '" + srcid + "'")});
                    biz.downloadInvoiceById(lshs.get(i), (CoreBillBaseInfo)srcInfo, cache);
                }
                break block5;
            }
            if (!H.same(srctype, H.BOSTYPE(OtherBillInfo.class))) break block5;
            List<String> lshs = this.getAllLsh(ctx, ids, srctype, cache);
            if (lshs == null) {
                return null;
            }
            for (int i = 0; i < lshs.size(); ++i) {
                String srcid = (String)cache.get("ids" + lshs.get(i));
                OtherBillInfo srcInfo = (OtherBillInfo)H.getInfo(ctx, new Object[]{srcid, this.getOtherBillEntityView(ctx, H.JSLIST(srcid))});
                biz.downloadInvoiceById(lshs.get(i), (CoreBillBaseInfo)srcInfo, cache);
            }
        }
        return null;
    }

    private CompanyOrgUnitInfo[] getCompanys(Context ctx, String[] companysIds) throws BOSException {
        CompanyOrgUnitCollection col = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(H.newEV(H.SIC("id,name,number,company.id,company.baseCurrency.id"), H.FILTER(H.include("id", companysIds))));
        HashMap<String, CompanyOrgUnitInfo> tmp = new HashMap<String, CompanyOrgUnitInfo>();
        for (int i = 0; i < col.size(); ++i) {
            tmp.put(H.IDSTR(col.get(i)), col.get(i));
        }
        CompanyOrgUnitInfo[] ret = new CompanyOrgUnitInfo[companysIds.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (CompanyOrgUnitInfo)tmp.get(companysIds[i]);
        }
        return ret;
    }

    private EIVCService getEIVConn(Context ctx, String companyid, Map cache) throws BOSException, EASBizException {
        EIVCService eivs;
        CompanyOrgUnitInfo company;
        Map map = cache = cache == null ? H.CACHE() : cache;
        if (cache.containsKey(companyid)) {
            company = (CompanyOrgUnitInfo)cache.get(companyid);
        } else {
            company = this.getCompanys(ctx, new String[]{companyid})[0];
            cache.put(companyid, company);
        }
        if (cache.containsKey("eivs" + companyid)) {
            eivs = (EIVCService)cache.get("eivs" + companyid);
        } else {
            EIVCConfigInfo cfg = EIVCConfigFactory.getLocalInstance(ctx).getEIVCConfigInfo("select baseurl");
            if (cfg == null) {
                this.throwEASException(this.getResourceStr(ctx, "BillCodeNoConfiger"));
            }
            String baseurl = cfg.getBaseurl();
            Map<Object, Object> row = H.getOneRow(ctx, "select fclientid,fsecretid from T_ARP_EIVCConfigCompany where FCompanyid='" + companyid + "'");
            if (row == null) {
                this.throwEASException(company.getName() + this.getResourceStr(ctx, "NoConfigureBillConnData"));
            }
            String clientId = (String)row.get("fclientid");
            String secretId = (String)row.get("fsecretid");
            eivs = new EIVCService(baseurl, clientId, secretId);
            try {
                eivs.refreshToken();
            }
            catch (RemoteMethodException e1) {
                this.throwEASException(company.getName() + this.getResourceStr(ctx, "getBillConnError"), e1);
            }
            cache.put("eivs" + companyid, company);
        }
        return eivs;
    }

    private List<String> getAllLsh(Context ctx, List ids, BOSObjectType srctype, Map cache) {
        Map<Object, List> rows = H.getRows(ctx, String.format("select flsh  from T_ARP_EIVCreatedInvoice where fsrcType='%s' and fisCreatedOK = 0 and %s ", srctype.toString(), H.include("fid", ids).toString()));
        if (rows == null) {
            return null;
        }
        List lshs = H.unique(rows.get(1));
        for (int i = 0; i < ids.size(); ++i) {
            cache.put("ids" + (String)lshs.get(i), ids.get(i));
        }
        return lshs;
    }

    @Override
    protected Map _downloadInvoiceById(Context ctx, String lsh, CoreBillBaseInfo srcInfo, Map cache) throws BOSException, EASBizException {
        ArrayList<IObjectPK> retInv = new ArrayList<IObjectPK>();
        ArrayList<IObjectPK> retOb = new ArrayList<IObjectPK>();
        IArInvoice arIbiz = ArInvoiceFactory.getLocalInstance(ctx);
        IOtherBill obbiz = OtherBillFactory.getLocalInstance(ctx);
        if (srcInfo instanceof SaleIssueBillInfo) {
            SaleIssueBillInfo _srcInfo = (SaleIssueBillInfo)srcInfo;
            ArInvoiceInfo[] infos = null;
            String companyid = H.IDSTR(_srcInfo.getCompany());
            if (H.isEmpty(companyid)) {
                this.throwEASException(this.getResourceStr(ctx, "BillCompanyCannotEmpt"));
            }
            EIVCService eivs = this.getEIVConn(ctx, companyid, cache);
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)cache.get(companyid);
            try {
                infos = eivs.getArInvoices(lsh);
                for (int i = 0; i < infos.length; ++i) {
                    ArInvoiceInfo info = infos[i];
                    if (H.hasEmpty(info.getCode(), info.getNumber())) continue;
                    info.setCreateSrcType(_srcInfo.getBOSType().toString());
                    info.setIsCreatedByElev(true);
                    info.setCompany(_srcInfo.getCompany());
                    info.setCU(_srcInfo.getCompany().getCU());
                    info.setCurrency(_srcInfo.getCurrency());
                    info.setType(InvoiceTypeEnum.VAT);
                    AccountBankInfo acctInfo = this.getAccountBank(ctx, (String)info.get("xhf_yhzh"), cache);
                    info.setAccountBank(acctInfo);
                    if (acctInfo != null) {
                        info.setCussBank(acctInfo.getBank().getName());
                    }
                    info.setCussAddress(_srcInfo.getCustomer().getAddress());
                    info.setAsstActType(this.getAsstActType(ctx));
                    info.setAsstActID(H.IDSTR(_srcInfo.getCustomer()));
                    info.setAsstActNumber(_srcInfo.getCustomer().getNumber());
                    info.setAsstActName(_srcInfo.getCustomer().getName());
                    info.setSourceBillId(H.IDSTR(_srcInfo));
                    IObjectPK aripk = arIbiz.save((CoreBaseInfo)info);
                    info = arIbiz.getArInvoiceInfo(aripk);
                    arIbiz.submit(aripk, (CoreBaseInfo)info);
                    info.setId(H.UID(aripk));
                    OtherBillInfo obinfo = this.createOtherBill(ctx, info, _srcInfo, cache);
                    IObjectPK obpk = obbiz.submit((CoreBaseInfo)obinfo);
                    obbiz.audit(obpk);
                    this.saveBotpRelation(ctx, null, aripk.toString(), obpk.toString(), H.BOSTYPE(info), H.BOSTYPE(obinfo), null);
                    retInv.add(aripk);
                    retOb.add(obpk);
                }
            }
            catch (RemoteMethodException e) {
                this.throwEASException(this.getResourceStr(ctx, "GetBillColdBillDateError"), e);
            }
            catch (SQLException e) {
                this.throwEASException(this.getResourceStr(ctx, "GetBillColdBillDateError"), e);
            }
            return H.JSMAP("aripks", retInv, "obpks", retOb);
        }
        if (srcInfo instanceof OtherBillInfo) {
            OtherBillInfo _srcInfo = (OtherBillInfo)srcInfo;
            UserInfo createInvoiceUser = _srcInfo.getCreateInvoiceUser();
            String companyid = H.IDSTR(_srcInfo.getCompany());
            if (H.isEmpty(companyid)) {
                this.throwEASException(this.getResourceStr(ctx, "BillCompanyCannotEmpt"));
            }
            EIVCService eivs = this.getEIVConn(ctx, companyid, cache);
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)cache.get(companyid);
            ArInvoiceInfo[] infos = null;
            try {
                infos = eivs.getArInvoices(lsh);
                for (int i = 0; i < infos.length; ++i) {
                    ArInvoiceInfo info = infos[i];
                    if (H.hasEmpty(info.getCode(), info.getNumber())) continue;
                    info.setDrawer(_srcInfo.getCreateInvoiceUser().getPerson());
                    if (_srcInfo.getAccountant() != null) {
                        info.setInvPerson(_srcInfo.getAccountant().getPerson());
                    }
                    if (_srcInfo.getAuditor() != null) {
                        info.setAuditPerson(_srcInfo.getAuditor().getPerson());
                    }
                    info.setCreateSrcType(_srcInfo.getBOSType().toString());
                    info.setIsCreatedByElev(true);
                    info.setCompany(_srcInfo.getCompany());
                    info.setCU(_srcInfo.getCompany().getCU());
                    info.setCurrency(_srcInfo.getCurrency());
                    info.setType(InvoiceTypeEnum.VAT);
                    AccountBankInfo acctInfo = this.getAccountBank(ctx, (String)info.get("xhf_yhzh"), cache);
                    info.setAccountBank(acctInfo);
                    if (acctInfo != null) {
                        info.setCussBank(acctInfo.getBank().getName());
                    }
                    info.setCussAddress(info.getString("ghf_dzdh"));
                    info.setAsstActType(_srcInfo.getAsstActType());
                    info.setAsstActID(_srcInfo.getAsstActID());
                    info.setAsstActNumber(_srcInfo.getAsstActNumber());
                    info.setAsstActName(_srcInfo.getAsstActName());
                    info.setSourceBillId(H.IDSTR(_srcInfo));
                    ArInvoiceEntryCollection entries = info.getEntries();
                    for (int j = 0; j < entries.size(); ++j) {
                        ArInvoiceEntryInfo entry = entries.get(j);
                        entry.setSourceBillEntryId(this.getEntryIdByMaterialName(entry.getTxtMaterial(), _srcInfo.getEntry()));
                        entry.setSourceBillId(H.IDSTR(_srcInfo));
                    }
                    IObjectPK aripk = arIbiz.save((CoreBaseInfo)info);
                    info = arIbiz.getArInvoiceInfo(aripk);
                    arIbiz.submit(aripk, (CoreBaseInfo)info);
                    this.saveBotpRelation(ctx, null, H.IDSTR(_srcInfo), aripk.toString(), H.BOSTYPE(_srcInfo), H.BOSTYPE(info), H.IDSTR(_srcInfo.getCreateInvoiceUser()));
                    retInv.add(aripk);
                }
                if (infos.length > 0) {
                    String codeAndnumbers = null;
                    Map<Object, Object> row = H.getOneRow(ctx, "select FArInvoiceNumbers from T_AR_OtherBill where fid ='" + H.IDSTR(_srcInfo) + "' ");
                    if (row != null && infos[0].getColorType() == ColorTypeEnum.red) {
                        String oldCodeAndNumber = (String)row.get(1);
                        codeAndnumbers = oldCodeAndNumber + "," + H.Join(",", H.PROPS2LIST("number", infos));
                    } else {
                        codeAndnumbers = infos[0].getCode() + ":" + H.Join(",", H.PROPS2LIST("number", infos));
                    }
                    DbUtil.execute((Context)ctx, (String)("update T_AR_OtherBill set FArInvoiceNumbers = '" + codeAndnumbers + "' where fid ='" + H.IDSTR(_srcInfo) + "' "));
                    this.updateCreatedInovice(ctx, lsh, codeAndnumbers);
                    this.notifyUser(ctx, createInvoiceUser, this.getResourceStr(ctx, "HaveReveiveARBill") + codeAndnumbers);
                }
            }
            catch (RemoteMethodException e) {
                this.throwEASException(this.getResourceStr(ctx, "GetBillColdBillDateError"), e);
            }
            return H.JSMAP("aripks", retInv);
        }
        return null;
    }

    private void updateCreatedInovice(Context ctx, String lsh, String codeAndnumbers) throws BOSException {
        DbUtil.execute((Context)ctx, (String)String.format("update T_ARP_EIVCreatedInvoice set FIsCreatedOK = 1, FReturnCodeAndNumbers='%s' where FLsh ='%s';", codeAndnumbers, lsh));
    }

    private void notifyUser(Context ctx, UserInfo createInvoiceUser, String msgstr) throws EASBizException, BOSException {
        BMCMessageInfo msg = new BMCMessageInfo();
        msg.setType(MsgType.NOTICE);
        msg.setStatus(MsgStatus.UNREADED);
        msg.setBizType(MsgBizType.ONLINE);
        msg.setPriority(MsgPriority.MIDDLE);
        msg.setTitle(this.getResourceStr(ctx, "MakeEleBillSuccess"));
        msg.setBody(msgstr);
        msg.setReceiver(createInvoiceUser.getId().toString());
        BMCMessageFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)msg);
    }

    private BOSUuid getEntryIdByMaterialName(String txtMaterial, OtherBillentryCollection entries) {
        for (int i = 0; i < entries.size(); ++i) {
            if (!txtMaterial.equalsIgnoreCase(entries.get(i).getMaterialName())) continue;
            return entries.get(i).getId();
        }
        return null;
    }

    private OtherBillInfo createOtherBill(Context ctx, ArInvoiceInfo info, SaleIssueBillInfo _srcInfo, Map cache) {
        OtherBillInfo ret = new OtherBillInfo();
        ret.setCU(info.getCU());
        ret.setCompany(info.getCompany());
        ret.setAmount(info.getAmount());
        ret.setAmountLocal(info.getAmount());
        ret.setAsstActID(info.getAsstActID());
        ret.setAsstActName(info.getAsstActName());
        ret.setAsstActNumber(info.getAsstActNumber());
        ret.setAsstActType(info.getAsstActType());
        ret.setBillDate(info.getBillDate());
        ret.setBillType(OtherBillTypeEnum.InvoiceBill);
        ret.setBizDate(info.getBizDate());
        ret.setCurrency(info.getCurrency());
        ret.setIsCreatedByArElecInvoice(true);
        ret.setDescription(info.getDescription());
        ret.setTotalAmount(info.getTotalAmount());
        ret.setTotalTax(info.getTaxRate());
        ret.setSourceBillId(H.IDSTR(info));
        SaleGroupInfo sgInfo = new SaleGroupInfo();
        sgInfo.setId(H.UID(_srcInfo.getAdminOrgUnit()));
        ret.setSaleGroup(sgInfo);
        ret.setCostCenter(_srcInfo.getCostCenterOrgUnit());
        ArInvoiceEntryCollection entires = info.getEntries();
        for (int i = 0; i < entires.size(); ++i) {
            ArInvoiceEntryInfo entry = entires.get(i);
            OtherBillentryInfo obentry = this.createOtherBillEntry(ctx, entry, _srcInfo, cache);
            ret.getEntries().addObject((IObjectValue)obentry);
        }
        return ret;
    }

    private OtherBillentryInfo createOtherBillEntry(Context ctx, ArInvoiceEntryInfo entry, SaleIssueBillInfo _srcInfo, Map cache) {
        OtherBillentryInfo einfo = new OtherBillentryInfo();
        return einfo;
    }

    private AccountBankInfo getAccountBank(Context ctx, String yhzh, Map cache) throws BOSException {
        AccountBankInfo ret = null;
        if (cache.containsKey("AccountBank" + yhzh)) {
            return (AccountBankInfo)cache.get("AccountBank" + yhzh);
        }
        ret = (AccountBankInfo)H.getInfo(ctx, new Object[]{H.SIC("*,bank.name"), H.BOSTYPE(AccountBankInfo.class), H.FITEM("bankaccountnumber ='" + yhzh + "'")});
        cache.put("AccountBank" + yhzh, ret);
        return ret;
    }

    private AsstActTypeInfo getAsstActType(Context ctx) throws SQLException, BOSException {
        if (this.asstActTypeInfo == null) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)" select  fid from T_BD_AsstActType where upper(FREALTIONDATAOBJECT) = upper('T_BD_Customer') ");
            if (rs.next()) {
                String asstActTypeId = rs.getString(1);
                this.asstActTypeInfo = new AsstActTypeInfo();
                this.asstActTypeInfo.setId(BOSUuid.read((String)asstActTypeId));
            }
            rs.close();
        }
        return this.asstActTypeInfo;
    }

    protected void saveBotpRelation(Context ctx, String BotpId, String srcId, String destId, BOSObjectType srcType, BOSObjectType destType, String operation) throws BOSException {
        BOTRelationInfo info = new BOTRelationInfo();
        info.setSrcObjectID(srcId);
        info.setDestObjectID(destId);
        info.setSrcEntityID(srcType.toString());
        info.setDestEntityID(destType.toString());
        info.setOperatorID(operation);
        info.setBOTMappingID(BotpId);
        info.setType(0);
        info.setIsEffected(true);
        BOTRelationFactory.getLocalInstance((Context)ctx).addnew(info);
    }

    @Override
    protected Map _createInvoice(Context ctx, Map param) throws BOSException, EASBizException {
        Map cache = H.CACHE();
        IOtherBill biz = OtherBillFactory.getLocalInstance(ctx);
        BOSObjectType srctype = H.BOSTYPE(param.get("srctype"));
        List ids = (List)param.get("ids");
        if (H.hasEmpty(ids)) {
            this.throwEASException(this.getResourceStr(ctx, "PleaseSelectBill"));
        }
        if (ids.size() > 1) {
            this.throwEASException(this.getResourceStr(ctx, "NotSportTogeterBill"));
        }
        if (H.same(srctype, H.BOSTYPE(OtherBillInfo.class))) {
            Map<Object, List> rows;
            boolean isCreated = biz.exists(H.FILTER(H.include("id", ids), H.FITEM("lsh is not null")));
            if (isCreated) {
                this.throwEASException(this.getResourceStr(ctx, "HaveTakedBill"));
            }
            if ((rows = H.getRows(ctx, "select finvoiceAmt, famount from T_AR_OtherBillentry where finvoiceAmt = famount and " + H.FILTER(H.include("fparentid", ids)).toString())) != null) {
                this.throwEASException(this.getResourceStr(ctx, "BillHaveAllMakeCannotRe"));
            }
        }
        OtherBillCollection infos = biz.getOtherBillCollection(this.getOtherBillEntityView(ctx, ids));
        IArElecInvoiceFacade bizf = ArElecInvoiceFacadeFactory.getLocalInstance(ctx);
        for (int i = 0; i < infos.size(); ++i) {
            OtherBillInfo info = infos.get(i);
            try {
                bizf.createInvoiceByInfo((CoreBillBaseInfo)info, cache);
                continue;
            }
            catch (Throwable e) {
                this.throwEASException(this.getResourceStr(ctx, "MakeFaiul"), e);
            }
        }
        return H.JSMAP("data", this.getResourceStr(ctx, "MakeSuccess"));
    }

    @Override
    protected Map _createInvoiceByInfo(Context ctx, CoreBillBaseInfo srcinfo, Map cache) throws BOSException, EASBizException {
        String lsh = null;
        if (srcinfo instanceof OtherBillInfo) {
            OtherBillInfo info = (OtherBillInfo)srcinfo;
            String companyid = H.IDSTR(info.getCompany());
            if (H.isEmpty(companyid)) {
                this.throwEASException(this.getResourceStr(ctx, "BillCompanyCannotEmpt"));
            }
            EIVCService eivs = this.getEIVConn(ctx, companyid, cache);
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)cache.get(companyid);
            Map Invoice2 = this.getInvoiceMap(ctx, info, cache);
            try {
                lsh = eivs.CreateInvoice(Invoice2);
            }
            catch (RemoteMethodException e) {
                this.throwEASException(this.getResourceStr(ctx, "MakeFaiul"), e);
            }
            DbUtil.execute((Context)ctx, (String)(" update T_AR_OtherBill set FLsh = '" + lsh + "', FCreateInvoiceUserID='" + H.IDSTR(ContextUtil.getCurrentUserInfo((Context)ctx)) + "' where fid='" + H.IDSTR(info) + "';"));
            this.ceateGetInvoiceTask(ctx, lsh, H.BOSTYPE(srcinfo).toString(), H.IDSTR(srcinfo));
        }
        return H.JSMAP("lsh", lsh);
    }

    private void ceateGetInvoiceTask(Context ctx, String lsh, String srcType, String srcBillId) throws EASBizException, BOSException {
        EIVCreatedInvoiceInfo info = new EIVCreatedInvoiceInfo();
        info.setLsh(lsh);
        info.setSrcType(srcType);
        info.setSrcBillId(srcBillId);
        info.setCreatedUser(H.IDSTR(ContextUtil.getCurrentUserInfo((Context)ctx)));
        info.setCreatedTime(new Date());
        info.setIsCreatedOK(false);
        EIVCreatedInvoiceFactory.getLocalInstance(ctx).addnew(info);
    }

    private Map getInvoiceMap(Context ctx, OtherBillInfo info, Map cache) throws EASBizException {
        Map ret = H.JSMAP(new Object[0]);
        ret.put("hsbz", "1");
        ret.put("kplx", H.BDEC(info.getTotalAmount()).compareTo(SysConstant.BIGZERO) > 0 ? 0 : 1);
        String companyid = H.IDSTR(info.getCompany());
        String xhf_nsrsbh = (String)cache.get("xhf_nsrsbh" + companyid);
        String xhf_mc = (String)cache.get("xhf_mc" + companyid);
        if (xhf_nsrsbh == null) {
            Map<Object, Object> row = H.getOneRow(ctx, String.format("select fid,ftaxpayerID,ftaxregisterName from T_ORG_Company where fid in('%s'); ", companyid));
            if (row == null || (xhf_nsrsbh = (String)row.get(2)) == null) {
                this.throwEASException(this.getResourceStr(ctx, "PleaseTakeOrgNumber"));
            }
            xhf_mc = (xhf_mc = (String)row.get(3)) == null ? info.getCompany().getName() : xhf_mc;
            cache.put("xhf_nsrsbh" + companyid, xhf_nsrsbh);
            cache.put("xhf_mc" + companyid, xhf_mc);
        }
        ret.put("xhf_nsrsbh", xhf_nsrsbh);
        ret.put("xhf_mc", xhf_mc);
        String cunstomid = H.IDSTR(info.getAsstActID());
        String ghf_nsrsbh = (String)cache.get("ghf_nsrsbh" + cunstomid);
        String ghf_mc = (String)cache.get("ghf_mc" + cunstomid);
        String FADDRESS = (String)cache.get("FADDRESS" + cunstomid);
        String ghf_yhzh = (String)cache.get("ghf_yhzh" + cunstomid);
        String FPHONE = (String)cache.get("FPHONE" + cunstomid + companyid);
        String FMOBILE = (String)cache.get("FMOBILE" + cunstomid + companyid);
        if (ghf_nsrsbh == null) {
            Map<Object, Object> row = H.getOneRow(ctx, String.format("select fid,FTxRegisterNo,fname_l2,faddress  from T_BD_Customer where fid in('%s'); ", cunstomid));
            if (row == null || (ghf_nsrsbh = (String)row.get(2)) == null) {
                this.throwEASException(this.getResourceStr(ctx, "PleaseTakeCustomNumber"));
            }
            cache.put("ghf_nsrsbh" + cunstomid, ghf_nsrsbh);
            ghf_mc = (String)row.get(3);
            cache.put("ghf_mc" + cunstomid, ghf_mc);
            FADDRESS = (String)row.get(4);
            cache.put("FADDRESS" + cunstomid, FADDRESS);
        }
        if (FPHONE == null) {
            Map<Object, Object> rowcomp = H.getOneRow(ctx, String.format("SELECT FMOBILE,FPHONE,FID FROM T_BD_CustomerCompanyInfo where FCUSTOMERID = '%s' and FCOMORGID = '%s';", cunstomid, companyid));
            if (rowcomp == null || (FMOBILE = (String)rowcomp.get(1)) == null) {
                this.throwEASException(this.getResourceStr(ctx, "PleaseTakeNumberInputBillPhone"));
            }
            FPHONE = (String)rowcomp.get(2);
            cache.put("FPHONE" + cunstomid + companyid, FPHONE);
            cache.put("FMOBILE" + cunstomid + companyid, FMOBILE);
            String fccid = (String)rowcomp.get(3);
            Map<Object, Object> rowcc = H.getOneRow(ctx, String.format("SELECT FBANK,FBANKACCOUNT FROM T_BD_CustomerCompanyBank where FCUSTOMERCOMPANYINFOID = '%s' ", fccid));
            if (rowcc != null) {
                ghf_yhzh = rowcc.get(1) + "," + rowcc.get(2);
            }
            cache.put("ghf_yhzh" + cunstomid, ghf_yhzh);
        }
        ret.put("ghf_nsrsbh", ghf_nsrsbh);
        ret.put("ghf_mc", ghf_mc);
        ret.put("ghf_sj", FMOBILE);
        if (FADDRESS != null) {
            ret.put("ghf_dzdh", FADDRESS + (FPHONE != null ? "," + FPHONE : ""));
        }
        if (ghf_yhzh != null) {
            ret.put("ghf_yhzh", ghf_yhzh);
        }
        if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() == null) {
            this.throwEASException(this.getResourceStr(ctx, "BillerCannotNullPleseInputPerson"));
        }
        ret.put("kpy", ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getName());
        if (info.getAccountant() != null && info.getAccountant().getPerson() != null) {
            ret.put("sky", info.getAccountant().getPerson().getName());
        }
        if (info.getAuditor() != null && info.getAuditor().getPerson() != null) {
            ret.put("fhr", info.getAuditor().getPerson().getName());
        }
        ret.put("hjbhsje", info.getTotalAmount());
        ret.put("kphjse", info.getTotalTax());
        ret.put("jshjje", info.getTotalTaxAmount());
        ret.put("bz", info.getDescription());
        ret.put("ddh", info.getNumber());
        ArrayList<Map> items = new ArrayList<Map>();
        ret.put("items", items);
        for (int i = 0; i < info.getEntry().size(); ++i) {
            OtherBillentryInfo entry = info.getEntry().get(i);
            Map item = H.JSMAP(new Object[0]);
            item.put("xmlx", 0);
            item.put("xmmc", entry.getMaterialName());
            item.put("xmdw", entry.getMeasureUnit().getName());
            item.put("ggxh", entry.getMaterialModel());
            item.put("xmsl", entry.getQuantity());
            item.put("xmdj", entry.getTaxPrice());
            item.put("xmje", H.add(entry.getTaxAmount(), entry.getAmount()));
            item.put("sl", entry.getTaxRate().divide(new BigDecimal(100)));
            item.put("se", entry.getTaxAmount());
            items.add(item);
        }
        String[] mFields = new String[]{"fpqqlsh", "mdid", "hsbz", "ddh", "kplx", "yfpdm", "yfphm", "xhf_nsrsbh", "xhf_mc", "xhf_dzdh", "xhf_yhzh", "ghf_nsrsbh", "ghf_mc", "ghf_sj", "ghf_openid", "ghf_dzdh", "ghf_yhzh", "kpy", "sky", "fhr", "hjbhsje", "kphjse", "jshjje", "bz"};
        String[] eFields = new String[]{"xmlx", "xmmc", "xmdw", "ggxh", "xmsl", "xmdj", "xmje", "sl", "se"};
        for (String f : mFields) {
            Object val = ret.get(f);
            if (val == null) {
                ret.put(f, "");
                continue;
            }
            if (val instanceof String) continue;
            ret.put(f, val.toString());
        }
        for (Map item : items) {
            for (String f : eFields) {
                Object val = item.get(f);
                if (val == null) {
                    item.put(f, "");
                    continue;
                }
                if (val instanceof String) continue;
                item.put(f, val.toString());
            }
        }
        return ret;
    }

    private EntityViewInfo getOtherBillEntityView(Context ctx, List ids) throws BOSException {
        return H.newEV(H.SIC("*,company.*,company.accountBank.*,createInvoiceUser.person.name,auditor.person.name,accountant.person.name,entry.*,entry.measureUnit.name,entry.material.name,entry.materialModel"), H.include("id", ids));
    }

    @Override
    protected Map _makeRed(Context ctx, Map param) throws BOSException, EASBizException {
        boolean hasdeleted;
        Map cache = H.CACHE();
        IArInvoice biz = ArInvoiceFactory.getLocalInstance(ctx);
        BOSObjectType srctype = H.BOSTYPE(param.get("srctype"));
        List ids = (List)param.get("ids");
        if (H.same(srctype, H.BOSTYPE(OtherBillInfo.class)) && (hasdeleted = biz.exists(H.FILTER(H.include("id", ids), H.FITEM("billstatus = 4"))))) {
            this.throwEASException(this.getResourceStr(ctx, "HaveEndBill"));
        }
        ArInvoiceCollection infos = biz.getArInvoiceCollection(H.newEV(H.SIC("*,company.*,entries.*"), H.include("id", ids)));
        IArElecInvoiceFacade bizf = ArElecInvoiceFacadeFactory.getLocalInstance(ctx);
        String detailMsg = "";
        int success = 0;
        for (int i = 0; i < infos.size(); ++i) {
            ArInvoiceInfo info = infos.get(i);
            try {
                bizf.makeRedByInfo(info, cache);
                ++success;
                continue;
            }
            catch (Throwable e) {
                detailMsg = detailMsg + info.getCompany().getName() + this.getResourceStr(ctx, "CancelDownloadError") + e.getMessage() + "<br>";
            }
        }
        return H.JSMAP("msg", String.format(this.getResourceStr(ctx, "SuccessAllBillRedPush"), success), "detailMsg", detailMsg);
    }

    @Override
    protected Map _makeRedByInfo(Context ctx, ArInvoiceInfo invinfo, Map cache) throws BOSException, EASBizException {
        String companyid = H.IDSTR(invinfo.getCompany());
        if (H.isEmpty(companyid)) {
            this.throwEASException(this.getResourceStr(ctx, "BillCompanyCannotEmpt"));
        }
        EIVCService eivs = this.getEIVConn(ctx, companyid, cache);
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)cache.get(companyid);
        String newlsh = null;
        try {
            newlsh = eivs.redinvoice(invinfo.getFpqqlsh());
        }
        catch (RemoteMethodException e) {
            e.printStackTrace();
            if (e.err.methodState == MethodState.INVOKED) {
                this.throwEASException(this.getResourceStr(ctx, "CanaelSuccessButLocalDataException"), e);
            }
            this.throwEASException(this.getResourceStr(ctx, "CanaelSuccess"), e);
        }
        this.ceateGetInvoiceTask(ctx, newlsh, invinfo.getCreateSrcType(), invinfo.getSourceBillId());
        return H.JSMAP("lsh", newlsh);
    }

    @Override
    protected Map _autoDownloadInvoices(Context ctx) throws BOSException, EASBizException {
        Map cache = H.CACHE();
        List ret = null;
        IArElecInvoiceFacade biz = ArElecInvoiceFacadeFactory.getLocalInstance(ctx);
        EIVCreatedInvoiceCollection col = EIVCreatedInvoiceFactory.getLocalInstance(ctx).getEIVCreatedInvoiceCollection(H.newEV(H.FITEM("isCreatedOK = 0")));
        for (int i = 0; i < col.size(); ++i) {
            EIVCreatedInvoiceInfo info = col.get(i);
            if (!H.same(H.BOSTYPE(info.getSrcType()), H.BOSTYPE(OtherBillInfo.class))) continue;
            OtherBillInfo srcInfo = (OtherBillInfo)H.getInfo(ctx, new Object[]{info.getSrcBillId(), this.getOtherBillEntityView(ctx, H.JSLIST(info.getSrcBillId()))});
            try {
                Map out = biz.downloadInvoiceById(info.getLsh(), (CoreBillBaseInfo)srcInfo, cache);
                if (out == null || out.get("aripks") == null) continue;
                if (ret == null) {
                    ret = (List)out.get("aripks");
                    continue;
                }
                ret.addAll((List)out.get("aripks"));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return H.JSMAP("data", ret);
    }

    private String getResourceStr(Context ctx, String key) {
        String resClassName = "com.kingdee.eas.fi.ap.ApAllResource";
        return EASResource.getString((String)resClassName, (String)key);
    }

    private String getResourceStr(Context ctx, String key, Object[] params) {
        String str = this.getResourceStr(ctx, key);
        MessageFormat mf = new MessageFormat(str);
        String result = mf.format(params);
        return result;
    }
}

