/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.ar.ArElecInvoiceFacadeFactory;
import com.kingdee.eas.fi.ar.ArInvoiceEntryCollection;
import com.kingdee.eas.fi.ar.ArInvoiceEntryInfo;
import com.kingdee.eas.fi.ar.ArInvoiceFactory;
import com.kingdee.eas.fi.ar.ArInvoiceInfo;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.ar.IArElecInvoiceFacade;
import com.kingdee.eas.fi.ar.IArInvoice;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.fi.ar.app.AbstractArInvoiceControllerBean;
import com.kingdee.eas.fi.ar.app.ArBillAutoInvGenerator;
import com.kingdee.eas.fi.ar.app.ArInvoiceReverser;
import com.kingdee.eas.fi.arap.ColorTypeEnum;
import com.kingdee.eas.fi.arap.InvoiceException;
import com.kingdee.eas.fi.arap.InvoiceTypeEnum;
import com.kingdee.eas.fi.arap.app.InvoiceValidator;
import com.kingdee.eas.fi.arap.util.ArApParamHelper;
import com.kingdee.eas.fi.arap.util.H;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ArInvoiceControllerBean
extends AbstractArInvoiceControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ar.app.ArInvoiceControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkValid(ctx, model);
        IObjectPK pk = super._submit(ctx, model);
        this.setDefaultValue(ctx, model);
        this._reverseBill(ctx, pk);
        return pk;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ArInvoiceInfo arInvoiceInfo = (ArInvoiceInfo)model;
        if (arInvoiceInfo == null) {
            return null;
        }
        arInvoiceInfo.setBillStatus(BillStatusEnum.SAVE);
        if (arInvoiceInfo.getCU() == null) {
            arInvoiceInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        if (arInvoiceInfo.getNumber() == null || arInvoiceInfo.getNumber().equals("")) {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            String strCompanyID = arInvoiceInfo.getCompany() != null ? arInvoiceInfo.getCompany().getId().toString() : null;
            String orgNumber = null;
            boolean flag = iCodingRuleManager.isExist((IObjectValue)arInvoiceInfo, strCompanyID, "type");
            orgNumber = flag ? iCodingRuleManager.getNumber((IObjectValue)arInvoiceInfo, strCompanyID, "type", "") : arInvoiceInfo.getId().toString();
            arInvoiceInfo.setNumber(orgNumber);
        }
        return super._save(ctx, (IObjectValue)arInvoiceInfo);
    }

    protected void setDefaultValue(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ArInvoiceInfo info = (ArInvoiceInfo)model;
        ArInvoiceEntryCollection entries = info.getEntries();
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            ArInvoiceEntryInfo entryInfo = (ArInvoiceEntryInfo)it.next();
            if (entryInfo.getTaxRate() == null) {
                entryInfo.setTaxRate(SysConstant.BIGZERO);
            }
            if (entryInfo.getTaxAmount() != null) continue;
            entryInfo.setTaxAmount(SysConstant.BIGZERO);
        }
    }

    @Override
    protected void _checkValid(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        InvoiceValidator.checkValid(ctx, model);
        InvoiceValidator.checkNumber(ctx, model);
        this.checkAmt(ctx, model);
        this.checkInvicesLimits(ctx, model);
        ArInvoiceInfo info = (ArInvoiceInfo)model;
        info.setBillStatus(BillStatusEnum.SUBMITED);
    }

    private void checkInvicesLimits(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BigDecimal decimalValue;
        ArInvoiceInfo info = (ArInvoiceInfo)model;
        String value = null;
        String companyId = info.getCompany().getId().toString();
        value = InvoiceTypeEnum.VAT.equals((Object)info.getType()) ? ArApParamHelper.getARInvoicesVATlimits(ctx, companyId) : ArApParamHelper.getARInvoicesNORMALlimits(ctx, companyId);
        if (value != null && (decimalValue = new BigDecimal(value)).abs().compareTo(SysConstant.BIGZERO) > 0 && this.getAmountTotal(model).abs().compareTo(decimalValue.abs()) > 0) {
            throw new InvoiceException(InvoiceException.INVOICES_LIMITS_SET);
        }
    }

    private BigDecimal getAmountTotal(IObjectValue model) {
        ArInvoiceInfo info = (ArInvoiceInfo)model;
        ArInvoiceEntryCollection entries = info.getEntries();
        Iterator it = entries.iterator();
        BigDecimal totalAmount = SysConstant.BIGZERO;
        BigDecimal amt = SysConstant.BIGZERO;
        while (it.hasNext()) {
            ArInvoiceEntryInfo entryInfo = (ArInvoiceEntryInfo)it.next();
            amt = entryInfo.getAmount();
            if (amt == null) continue;
            totalAmount = totalAmount.add(amt);
        }
        return totalAmount;
    }

    @Override
    protected void _reverseBill(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ArInvoiceReverser reverser = ArInvoiceReverser.getInstance();
        reverser.reverseBill(ctx, pk);
    }

    private void checkAmt(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ArInvoiceInfo info = (ArInvoiceInfo)model;
        ArInvoiceEntryCollection entries = info.getEntries();
        Iterator it = entries.iterator();
        ArInvoiceEntryInfo arInvoiceEntryInfo = null;
        String destEntryId = null;
        while (it.hasNext()) {
            arInvoiceEntryInfo = (ArInvoiceEntryInfo)it.next();
            destEntryId = arInvoiceEntryInfo.getId().toString();
            StringBuffer sb = new StringBuffer();
            sb.append("select sum(entry.FrecievePayAmountLocal) sumrecievePayAmountLocal ,sum(entry.FinvoicedAmt) suminvoicedAmt ,relentry.fdestentryid ");
            sb.append("from t_ar_otherbillentry entry ");
            sb.append("inner join t_bot_relationentry relentry on entry.fid = relentry.fsrcentryid ");
            sb.append("where relentry.fdestentryid = '").append(destEntryId).append("' ");
            sb.append("group by relentry.fdestentryid ");
            BigDecimal invAmt = arInvoiceEntryInfo.getActualAmount();
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            try {
                while (result.next()) {
                    BigDecimal freeInvAmt = result.getBigDecimal("sumrecievePayAmountLocal").subtract(result.getBigDecimal("suminvoicedAmt"));
                    int srcAmtSign = result.getBigDecimal("sumrecievePayAmountLocal").signum();
                    if (srcAmtSign != invAmt.signum()) {
                        logger.error((Object)("srcAmt: " + result.getBigDecimal("sumrecievePayAmount") + ", invAmt: " + invAmt));
                        throw new InvoiceException(InvoiceException.AMT_SIGN_DIFF);
                    }
                    if (srcAmtSign != -1 && invAmt.compareTo(freeInvAmt) == 1) {
                        logger.error((Object)(" invoiceAmt: " + invAmt + ", freeInvAmt:" + freeInvAmt));
                        throw new InvoiceException(InvoiceException.AMT_GT_FREEINVAMT);
                    }
                    if (srcAmtSign != -1 || invAmt.compareTo(freeInvAmt) != -1) continue;
                    logger.error((Object)(" invoiceAmt: " + invAmt + ", freeInvAmt:" + freeInvAmt));
                    throw new InvoiceException(InvoiceException.AMT_LT_FREEINVAMT);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
        }
    }

    @Override
    protected void _blankout(Context ctx, IObjectPK[] pks, boolean fRecycleNum) throws BOSException, EASBizException {
        ArrayList<IObjectPK> pkList = new ArrayList<IObjectPK>();
        IArElecInvoiceFacade biz = ArElecInvoiceFacadeFactory.getLocalInstance(ctx);
        Map cache = H.CACHE();
        int size = pks.length;
        for (int i = 0; i < size; ++i) {
            pkList.add(pks[i]);
            ArInvoiceInfo info = (ArInvoiceInfo)H.getInfo(ctx, new Object[]{H.SIC("id,company,isCreateByElev,createSrcType"), pks[i]});
            if (!info.isIsCreatedByElev()) continue;
            BOSObjectType srcType = H.BOSTYPE(info.getCreateSrcType());
            if (H.same(H.BOSTYPE(SaleIssueBillInfo.class), srcType)) {
                Map<Object, Object> row = H.getOneRow(ctx, String.format("select fid from T_AR_OtherBill where FSourceBillID = '%s'", pks[i].toString()));
                if (row != null) continue;
                String obid = (String)row.get(1);
                DBUtil.execute((Context)ctx, (String)String.format("delete from T_BOT_RELATION  where FSRCOBJECTID = '%s' and FDESTOBJECTID = '%s' ", pks[i].toString(), obid));
                OtherBillInfo obinfo = (OtherBillInfo)H.getInfo(ctx, new Object[]{obid});
                OtherBillFactory.getLocalInstance(ctx).delete(H.PK(obinfo));
                continue;
            }
            if (!H.same(H.BOSTYPE(OtherBillInfo.class), srcType)) continue;
            if (info.getColorType() == ColorTypeEnum.red) {
                H.throwEASBizException(info.getNumber() + EASResource.getString((String)"com.kingdee.eas.fi.ar.ArAllResource", (String)"HaveRedBillCannotCancel"));
            }
            biz.makeRedByInfo(info, cache);
        }
        ArInvoiceReverser reverser = ArInvoiceReverser.getInstance();
        reverser.blankout(ctx, pkList, fRecycleNum, true);
    }

    @Override
    protected boolean _isInfoValid(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean fValid = false;
        try {
            this._checkValid(ctx, model);
            fValid = true;
        }
        catch (Exception e) {
            logger.error((Object)"info Validation in wf", (Throwable)e);
        }
        return fValid;
    }

    @Override
    protected boolean _isAutoVat(Context ctx, BOSUuid companyId) throws BOSException, EASBizException {
        return ArApParamHelper.isBillAutoVatInv(ctx, companyId.toString(), true);
    }

    @Override
    protected String _getWFVatBotMappingId(Context ctx) throws BOSException, EASBizException {
        return new ArBillAutoInvGenerator().getWFBotMappingId(ctx);
    }

    @Override
    protected boolean _isVatBotShowUI(Context ctx, String mappingId) throws BOSException, EASBizException {
        return new ArBillAutoInvGenerator().isBotShowUI(ctx, mappingId);
    }

    @Override
    protected IObjectValue _getVatBotMapping(Context ctx) throws BOSException, EASBizException {
        return new ArBillAutoInvGenerator().getBotMapping(ctx, false, null);
    }

    @Override
    protected String _transVatFromSrcBill(Context ctx, BOSUuid srcBillId, String mappingId) throws BOSException, EASBizException {
        return new ArBillAutoInvGenerator().transVatFromSrcBill(ctx, srcBillId, mappingId);
    }

    @Override
    protected BTPTransformResult _transVatFromSrcBills(Context ctx, List srcBillIds, BOSUuid mappingId) throws BOSException, EASBizException {
        return new ArBillAutoInvGenerator().transVatFromSrcBills(ctx, srcBillIds, mappingId);
    }

    @Override
    protected IObjectPK _transSubmit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model != null) {
            ((ArInvoiceInfo)model).setBillStatus(BillStatusEnum.SUBMITED);
        }
        return this._submit(ctx, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IArInvoice iari = ArInvoiceFactory.getLocalInstance(ctx);
        if (!iari.exists("where billstatus=1 and id='" + pk.toString() + "'")) {
            throw new InvoiceException(InvoiceException.INVOICE_SAVE_BILL_DELETE);
        }
        super._delete(ctx, pk);
    }
}

