/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.fi.ap.VerificateBillTypeEnum;
import com.kingdee.eas.fi.ar.AbstractArApBillBaseInfo;
import com.kingdee.eas.fi.ar.AbstractOtherBillInfo;
import com.kingdee.eas.fi.ar.ArApBillBaseInfo;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.ar.IOtherBill;
import com.kingdee.eas.fi.ar.OtherBillCollection;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.fi.ar.OtherBillTypeEnum;
import com.kingdee.eas.fi.ar.OtherBillentryInfo;
import com.kingdee.eas.fi.arap.app.ARAPImportHelper;
import com.kingdee.eas.fi.arap.app.OtherBillDataImport;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;

public class ArOtherBillDataImport
extends OtherBillDataImport {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ar.app.ArOtherBillDataImport");
    private final String[] AR_DECIMAL_FIELDS = new String[]{"FExchangeRate"};
    private final String[] AR_DECIMAL_OBJS = new String[]{"exchangeRate"};
    private final String[] AR_ENTRY_DECIMAL_FIELDS = new String[]{"FEntry_recievePayAmount", "FEntry_recievePayAmountLocal", "FEntry_verifyAmount", "FEntry_verifyAmountLocal", "FEntry_quantity", "FEntry_price", "FEntry_taxPrice", "FEntry_taxRate", "FEntry_taxAmount", "FEntry_badAmount", "FEntry_badAmountLocal", "FEntry_taxAmountLocal", "FEntry_actualPrice", "FEntry_discountType", "FEntry_discountRate", "FEntry_discountAmount", "FEntry_discountAmountLocal", "FEntry_amount", "FEntry_amountLocal", "FEntry_assistQty", "FEntry_realPrice"};
    private final String[] AR_ENTRY_DECIMAL_OBJS = new String[]{"recievePayAmount", "recievePayAmountLocal", "verifyAmount", "verifyAmountLocal", "quantity", "price", "taxPrice", "taxRate", "taxAmount", "badAmount", "badAmountLocal", "taxAmountLocal", "actualPrice", "discountType", "discountRate", "discountAmount", "discountAmountLocal", "amount", "amountLocal", "assistQty", "realPrice"};

    @Override
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return OtherBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        Hashtable data = ARAPImportHelper.reverseTableValue(hsData);
        OtherBillInfo head = this.generateArOtherbillInfo(ctx, data);
        head.put("entries", (Object)head.getEntry());
        return head;
    }

    private OtherBillInfo generateArOtherbillInfo(Context ctx, Hashtable tableData) throws TaskExternalException {
        AbstractArApBillBaseInfo head = null;
        StringBuffer entryErrorMsg = new StringBuffer();
        try {
            String errorMsg = "";
            OtherBillentryInfo entry = null;
            boolean isUpdateImport = false;
            boolean isExistedBill = false;
            HashMap<Integer, OtherBillentryInfo> entryMap = new HashMap<Integer, OtherBillentryInfo>();
            Enumeration dataEnumeration = tableData.keys();
            IOtherBill iOtherBill = OtherBillFactory.getLocalInstance(ctx);
            String number = null;
            while (dataEnumeration.hasMoreElements()) {
                Object key = dataEnumeration.nextElement();
                Hashtable hsData = (Hashtable)tableData.get(key);
                this.initDatas(ctx, hsData, true);
                number = ARAPImportHelper.getDataString(hsData, "FNumber");
                this.curKey = this.currentCompany.getNumber() + number;
                if (StringUtils.isEmpty((String)number)) {
                    throw new TaskExternalException(ArOtherBillDataImport.getString("NumberNoFound", ctx));
                }
                if (!this.infoMap.containsKey(this.curKey)) {
                    OtherBillCollection otherColl;
                    this.infoMap.clear();
                    if (this.isSltImportUpdate()) {
                        otherColl = iOtherBill.getOtherBillCollection("where number = '" + number + "' and company.number = '" + this.currentCompany.getNumber().toString() + "'");
                        if (otherColl != null && otherColl.size() > 0) {
                            head = otherColl.get(0);
                            if (!BillStatusEnum.SAVE.equals((Object)head.getBillStatus())) {
                                throw new TaskExternalException(ArOtherBillDataImport.getString("BillStatusSave", ctx));
                            }
                            isExistedBill = true;
                        }
                        if (head != null) {
                            if (((AbstractOtherBillInfo)head).getEntry() != null && ((AbstractOtherBillInfo)head).getEntry().size() > 0 && ((AbstractOtherBillInfo)head).getEntry().get(0).getSourceBillId() != null) {
                                errorMsg = ArOtherBillDataImport.getString("CANNOT_OVER_IMPORT", ctx) + ArOtherBillDataImport.getString("AR_ImportARBill", ctx);
                                throw new TaskExternalException(errorMsg);
                            }
                            for (int i = 0; i < ((AbstractOtherBillInfo)head).getEntry().size(); ++i) {
                                entry = ((AbstractOtherBillInfo)head).getEntry().get(i);
                                entryMap.put(entry.getSeq(), entry);
                            }
                        }
                    } else if (!this.isSltImportUpdate() && !this.isImportDataByRule && (otherColl = iOtherBill.getOtherBillCollection("where number = '" + number + "' and company.number = '" + this.currentCompany.getNumber().toString() + "'")) != null && otherColl.size() > 0) {
                        throw new TaskExternalException(ArOtherBillDataImport.getString("FBillNumber_IsExist", ctx));
                    }
                    if (null == head) {
                        head = new OtherBillInfo();
                        head.setNumber(number);
                    }
                    head.setCompany(this.currentCompany);
                    this.parseHead(hsData, ctx, (OtherBillInfo)head);
                    this.infoMap.put(this.curKey, head);
                } else {
                    isUpdateImport = true;
                    head = (OtherBillInfo)this.infoMap.get(this.curKey);
                }
                try {
                    entry = (OtherBillentryInfo)this.parseEntry(ctx, hsData, (OtherBillInfo)head, entryMap);
                }
                catch (Exception e) {
                    String seq = ARAPImportHelper.getDataString(hsData, "FSeq");
                    entryErrorMsg.append(ARAPImportHelper.getTempleFieldName(hsData, "FSeq") + " " + seq + ":" + e.getMessage()).append("\r\n");
                    continue;
                }
                if (!this.isImportDataByRule || isUpdateImport || isExistedBill) continue;
                try {
                    ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                    String cid = this.currentCompany.getId().toString();
                    if (iCodingRuleManager.isExist((IObjectValue)head, cid)) {
                        head.setNumber(iCodingRuleManager.getNumber((IObjectValue)head, cid, ""));
                        continue;
                    }
                    throw new TaskExternalException(ArOtherBillDataImport.getString("CodingRule_Error", ctx));
                }
                catch (Exception e) {
                    throw new TaskExternalException(ArOtherBillDataImport.getString("CodingRule_Error", ctx));
                }
            }
            if (entryErrorMsg.length() > 0) {
                throw new TaskExternalException(entryErrorMsg.toString());
            }
            this.setBillAmtFromEntry((ArApBillBaseInfo)head);
            ((AbstractOtherBillInfo)head).setThisArAmount(head.getAmount());
            ARAPImportHelper.checkCalculate(ctx, (ArApBillBaseInfo)head, number);
            return head;
        }
        catch (Exception e) {
            logger.info((Object)e);
            throw new TaskExternalException(e.getMessage());
        }
    }

    private void parseHead(Hashtable hsData, Context ctx, OtherBillInfo otherBillInfo) throws TaskExternalException {
        try {
            Date date = null;
            String str = null;
            for (int i = 0; i < this.DATE_FIELDS.length; ++i) {
                date = ARAPImportHelper.getDataDate(ctx, hsData, this.DATE_FIELDS[i]);
                if (date == null) {
                    ARAPImportHelper.throwFieldNullMsg(ctx, hsData, this.DATE_FIELDS[i]);
                }
                otherBillInfo.setDate(this.DATE_OBJS[i], date);
            }
            this.isInitBill = otherBillInfo.getBillDate().before(this.startPeriod.getBeginDate());
            this.checkOrgPermission(ctx, true, this.isInitBill);
            this.isFinish = otherBillInfo.getBillDate().before(this.currentPeriod.getBeginDate());
            if (this.isInitBill && this.arIsStart) {
                String errorMsg = MessageFormat.format(ArOtherBillDataImport.getString("Cannot_InitBill_Wrong", ctx), this.defaultSysEnum.getAlias());
                throw new TaskExternalException(errorMsg);
            }
            if (!this.isInitBill && this.isFinish) {
                String errorMsg = MessageFormat.format(ArOtherBillDataImport.getString("Cannot_FinistBill_Wrong", ctx), this.defaultSysEnum.getAlias());
                throw new TaskExternalException(errorMsg);
            }
            otherBillInfo.setIsInitializeBill(this.isInitBill);
            BigDecimal decVal = null;
            CurrencyInfo currency = this.getCurrencyByCache(ctx, hsData, "FCurrency_number");
            int exgRatescale = 4;
            if (currency != null) {
                exgRatescale = currency.getPrecision();
            }
            ExchangeRateInfo exgRateInfo = null;
            if (this.currentCompany != null && currency != null) {
                exgRateInfo = this.getExchangeRateInfoByCache(ctx, this.currentCompany, currency);
            }
            if (exgRateInfo != null) {
                exgRatescale = exgRateInfo.getPrecision();
                if (exgRateInfo.getExchangeAux() != null) {
                    exgRatescale = exgRateInfo.getExchangeAux().getPrecision();
                }
            }
            for (int i = 0; i < this.AR_DECIMAL_FIELDS.length; ++i) {
                decVal = ARAPImportHelper.getDataDeciaml(ctx, hsData, this.AR_DECIMAL_FIELDS[i]);
                decVal = decVal.setScale(exgRatescale, 4);
                otherBillInfo.setBigDecimal(this.AR_DECIMAL_OBJS[i], decVal);
                if (decVal != null && decVal.compareTo(ARAPImportHelper.ZERO) != 0) continue;
                ARAPImportHelper.throwFieldNullMsg(ctx, hsData, this.AR_DECIMAL_FIELDS[i]);
            }
            BigDecimal exchangeRate = otherBillInfo.getExchangeRate();
            if (currency.getId().toString().equals(this.currentCompany.getBaseCurrency().getId().toString())) {
                exchangeRate = BigDecimal.ONE;
            }
            exchangeRate = exchangeRate.compareTo(ARAPImportHelper.ZERO) == 0 ? ARAPImportHelper.ONE : exchangeRate;
            otherBillInfo.setExchangeRate(exchangeRate);
            otherBillInfo.setLastExhangeRate(otherBillInfo.getExchangeRate());
            for (int i = 0; i < this.STRING_FIELDS.length; ++i) {
                str = ARAPImportHelper.getDataString(hsData, this.STRING_FIELDS[i]);
                otherBillInfo.setString(this.STRING_OBJS[i], str);
            }
            otherBillInfo.setBillStatus(BillStatusEnum.SAVE);
            otherBillInfo.setSourceBillType(VerificateBillTypeEnum.OTHER);
            otherBillInfo.setBillType(ARAPImportHelper.getARBillType(hsData, "FBillType"));
            boolean isInTax = true;
            boolean isPriceWiTax = true;
            if (OtherBillTypeEnum.DebitAdjust.equals((Object)otherBillInfo.getBillType())) {
                isPriceWiTax = false;
            }
            otherBillInfo.setIsInTax(isInTax);
            otherBillInfo.setIsPriceWithoutTax(isPriceWiTax);
            otherBillInfo.setIsBizBill(this.getDataboolean(hsData, "FIsBizBill"));
            PaymentTypeInfo paymentType = this.getPaymentTypeInfoByCache(ctx, hsData, "FPaymentType_number", true);
            otherBillInfo.setPaymentType(paymentType);
            otherBillInfo.setSaleGroup(this.getSaleGroupInfoByCache(ctx, hsData, "FSaleGroup_number"));
            otherBillInfo.setSettleType(this.getSettlementTypeInfoByCache(ctx, hsData, "FSettleType_number"));
            otherBillInfo.setCurrency(this.getCurrencyByCache(ctx, hsData, "FCurrency_number"));
            otherBillInfo.setCU(this.currentCompany.getCU());
            otherBillInfo.setCompany(this.currentCompany);
            otherBillInfo.setAdminOrgUnit(this.getAdminOrgUnitInfoByCache(ctx, hsData, "FAdminOrgUnit_number"));
            otherBillInfo.setPerson(this.getPersonInfoByCache(ctx, hsData, "FPerson_number"));
            SaleOrgUnitInfo saleOrg = this.getSaleOrgInfoByCache(ctx, hsData, "FSaleOrg_number");
            if (saleOrg == null && !this.isInitBill && this.isConnSCM && otherBillInfo.getBillType().getValue() != 101) {
                throw new TaskExternalException(ArOtherBillDataImport.getString("ARInvoiceBill_Org_IsNull", ctx));
            }
            otherBillInfo.setSaleOrg(saleOrg);
            AsstActTypeInfo asstActTypeInfo = this.getAsstActTypeInfoByCache(ctx, hsData, "FAsstActType_number");
            otherBillInfo.setAsstActType(asstActTypeInfo);
            if (!this.checkAsstAccID(ctx, asstActTypeInfo, hsData, otherBillInfo)) {
                throw new TaskExternalException(ArOtherBillDataImport.getString("AsstActNumber_Wrong", ctx));
            }
            if (!this.isExistAsstActByCompanyByCache(ctx, this.currentCompany, otherBillInfo.getAsstActType(), otherBillInfo.getAsstActID()).booleanValue()) {
                throw new TaskExternalException(ARAPImportHelper.getString("AsstActNotBelongCompany", ctx));
            }
            if (!this.checkAsstActStatusByCache(ctx, otherBillInfo.getAsstActType(), otherBillInfo.getAsstActID()).booleanValue()) {
                throw new TaskExternalException(ARAPImportHelper.getString("AsstActNotApproved", ctx));
            }
            otherBillInfo.setCashDiscount(this.getCashDiscountInfoByCache(ctx, hsData, "FCashDiscount_number"));
            otherBillInfo.setIsImportBill(true);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    private CoreBaseInfo parseEntry(Context ctx, Hashtable hsData, OtherBillInfo otherBillInfo, Map<Integer, OtherBillentryInfo> entryMap) throws TaskExternalException {
        OtherBillentryInfo entryInfo = null;
        try {
            String[] notNullAmountFields = new String[]{"FEntry_amount", "FEntry_amountLocal", "FEntry_recievePayAmount", "FEntry_recievePayAmountLocal"};
            this.checkFieldisNull(ctx, hsData, notNullAmountFields);
            String data = ARAPImportHelper.getDataString(hsData, "FSeq");
            if (data != null) {
                int seq = Integer.parseInt(data);
                if (this.isSltImportUpdate() && entryMap.get(seq) != null) {
                    entryInfo = entryMap.get(seq);
                }
                if (entryInfo == null) {
                    entryInfo = new OtherBillentryInfo();
                    entryInfo.setHead(otherBillInfo);
                    entryInfo.setSeq(seq);
                    otherBillInfo.getEntry().add(entryInfo);
                    entryMap.put(seq, entryInfo);
                }
            } else {
                throw new TaskExternalException(ArOtherBillDataImport.getString("EntrySeq_NoFound", ctx));
            }
            entryInfo.setCompany(String.valueOf(otherBillInfo.getCompany().getId()));
            entryInfo.setBillDate(otherBillInfo.getBillDate());
            this.createEntryInfo(ctx, otherBillInfo, entryInfo, hsData);
        }
        catch (NumberFormatException e) {
            String msg = ArOtherBillDataImport.getString("NumberField_Wrong", ctx);
            msg = MessageFormat.format(msg, "FSeq_E");
            throw new TaskExternalException(msg, (Throwable)e);
        }
        return entryInfo;
    }

    private void createEntryInfo(Context ctx, OtherBillInfo otherBillInfo, OtherBillentryInfo entryInfo, Hashtable hsData) throws TaskExternalException {
        try {
            int i;
            AccountViewInfo account = null;
            String str = null;
            CurrencyInfo currency = this.getCurrencyByCache(ctx, hsData, "FCurrency_number");
            int scale = 4;
            if (currency != null) {
                scale = currency.getPrecision();
            }
            int scaleLocal = this.baseCurrency != null ? this.baseCurrency.getPrecision() : scale;
            BigDecimal decVal = null;
            for (i = 0; i < this.AR_ENTRY_DECIMAL_FIELDS.length; ++i) {
                decVal = ARAPImportHelper.getDataDeciaml(ctx, hsData, this.AR_ENTRY_DECIMAL_FIELDS[i]);
                if (decVal != null) {
                    if (this.AR_ENTRY_DECIMAL_FIELDS[i].toLowerCase().indexOf("Local".toLowerCase()) != -1) {
                        decVal = decVal.setScale(scaleLocal, 4);
                    } else if (this.AR_ENTRY_DECIMAL_FIELDS[i].toLowerCase().indexOf("Amount".toLowerCase()) != -1) {
                        decVal = decVal.setScale(scale, 4);
                    }
                    if (!this.checkIsPositiveRate(this.AR_ENTRY_DECIMAL_OBJS[i], decVal.toString())) {
                        String msg = ArOtherBillDataImport.getString("NumberField_Wrong", ctx);
                        msg = MessageFormat.format(msg, this.AR_ENTRY_DECIMAL_FIELDS[i]);
                        throw new TaskExternalException(msg);
                    }
                    if (!this.isInitBill && (this.checkIsVerifyamount(this.AR_ENTRY_DECIMAL_OBJS[i]) || this.checkIsVerifyamountLocal(this.AR_ENTRY_DECIMAL_OBJS[i]))) continue;
                    entryInfo.setBigDecimal(this.AR_ENTRY_DECIMAL_OBJS[i], decVal);
                    continue;
                }
                entryInfo.setBigDecimal(this.AR_ENTRY_DECIMAL_OBJS[i], ARAPImportHelper.ZERO);
            }
            for (i = 0; i < this.ENTRY_STRING_FIELDS.length; ++i) {
                str = ARAPImportHelper.getDataString(hsData, this.ENTRY_STRING_FIELDS[i]);
                entryInfo.setString(this.ENTRY_STRING_OBJS[i], str);
            }
            entryInfo.setCoreBillEntrySeq(ARAPImportHelper.getCoreBillSeq(ctx, hsData, "FEntry_coreBillEntrySeq"));
            Boolean isQtyZero = this.getDataboolean(hsData, "FEntry_isQtyZero");
            entryInfo.setIsQtyZero(isQtyZero);
            OtherBillTypeEnum billType = otherBillInfo.getBillType();
            MeasureUnitInfo unit = this.getMeasureUnitInfoByCache(ctx, hsData, "FEntry$measureUnit_number");
            entryInfo.setMeasureUnit(unit);
            MultiMeasureUnitInfo multiUnifInfo = null;
            if (billType.getValue() == 102) {
                int assistQtyPrecision = 4;
                int qtyPrecision = 4;
                int pricePrcision = 4;
                MaterialInfo material = this.getMaterialInfoByCache(ctx, hsData, "FEntry$material_number");
                if (material == null) {
                    ARAPImportHelper.throwFieldErrorMsg(ctx, hsData, "FEntry$material_number");
                }
                if (unit == null) {
                    ARAPImportHelper.throwFieldErrorMsg(ctx, hsData, "FEntry$measureUnit_number");
                }
                if ((multiUnifInfo = this.getMultiMeasureUnitByCache(ctx, unit, material)) != null) {
                    qtyPrecision = multiUnifInfo.getQtyPrecision();
                }
                entryInfo.setQuantity(entryInfo.getQuantity().setScale(qtyPrecision, 4));
                pricePrcision = material.getPricePrecision();
                entryInfo.setPrice(entryInfo.getPrice().setScale(pricePrcision, 4));
                entryInfo.setTaxPrice(entryInfo.getTaxPrice().setScale(pricePrcision, 4));
                entryInfo.setMaterial(material);
                entryInfo.setMaterialName(material.getName());
                entryInfo.setBaseUnit(material.getBaseUnit());
                entryInfo.setAssistUnit(material.getAssistUnit());
                entryInfo.setMaterialModel(material.getModel());
                if (material.getAssistAttr() != null) {
                    AsstAttrValueInfo asstAttrValueInfo = this.getAsstAttrValueInfoByCache(ctx, hsData, "FEntry$assistProperty_number", material.getAssistAttr());
                    entryInfo.setAssistProperty(asstAttrValueInfo);
                }
                entryInfo.setBaseQty(this.getBaseUnitQty(ctx, unit, material, entryInfo.getQuantity()));
                if (entryInfo.getAssistUnit() != null) {
                    multiUnifInfo = this.getMultiMeasureUnitByCache(ctx, entryInfo.getAssistUnit(), material);
                    if (multiUnifInfo != null) {
                        assistQtyPrecision = multiUnifInfo.getQtyPrecision();
                    }
                    entryInfo.setAssistQty(entryInfo.getAssistQty().setScale(assistQtyPrecision, 4));
                } else {
                    entryInfo.setAssistQty(BigDecimal.ZERO);
                }
            } else {
                int qtyPrecision = 9;
                int pricePrcision = 7;
                ExpenseTypeInfo expenseItem = this.getExpenseItemInfoByCache(ctx, hsData, "FEntry$expenseItem_number");
                if (expenseItem == null) {
                    ARAPImportHelper.throwFieldErrorMsg(ctx, hsData, "FEntry$expenseItem_number");
                }
                entryInfo.setExpenseItem(expenseItem);
                entryInfo.setBaseUnit(unit);
                entryInfo.setQuantity(entryInfo.getQuantity().setScale(qtyPrecision, 4));
                entryInfo.setPrice(entryInfo.getPrice().setScale(pricePrcision, 4));
                entryInfo.setTaxPrice(entryInfo.getTaxPrice().setScale(pricePrcision, 4));
                entryInfo.setBaseQty(entryInfo.getQuantity());
                entryInfo.setAssistQty(BigDecimal.ZERO);
            }
            entryInfo.setCoreBillType(this.getBillTypeByCache(ctx, hsData, "FEntry$coreBillType_number"));
            account = this.getAccountViewInfoByCache(ctx, hsData, "FEntry$account_number", this.currentCompany.getId().toString(), currency.getId().toString());
            if (this.isInitBill && account == null) {
                throw new TaskExternalException(ArOtherBillDataImport.getString("AR_Account_Is_Null", ctx));
            }
            entryInfo.setAccount(account);
            this.checkIsContrastAccountByCache(ctx, otherBillInfo.getCompany(), entryInfo.getAccount(), true);
            entryInfo.setOppAccount(this.getAccountViewInfoByCache(ctx, hsData, "FEntry$oppAccount_number", this.currentCompany.getId().toString(), currency.getId().toString()));
            entryInfo.setDiscountType(ARAPImportHelper.getDiscountTypeInfo(ctx, hsData, "FEntry_discountType"));
            if (DiscountModeEnum.NULL.equals((Object)entryInfo.getDiscountType())) {
                entryInfo.setDiscountRate(ARAPImportHelper.ZERO);
                entryInfo.setDiscountAmount(ARAPImportHelper.ZERO);
                entryInfo.setDiscountAmountLocal(ARAPImportHelper.ZERO);
            }
            if (entryInfo.getQuantity().compareTo(ARAPImportHelper.ZERO) == 0 && otherBillInfo.getBillType().getValue() == 103) {
                entryInfo.setQuantity(BigDecimal.ONE);
            }
            if (this.isInitBill && entryInfo.getBadAmount().abs().compareTo(entryInfo.getVerifyAmount().abs()) > 0) {
                throw new TaskExternalException(ArOtherBillDataImport.getString("BadAmountNotBigVerifyAmount", ctx));
            }
            if (!this.isInitBill) {
                entryInfo.setVerifyAmount(ARAPImportHelper.ZERO);
                entryInfo.setVerifyAmountLocal(ARAPImportHelper.ZERO);
                entryInfo.setUnVerifyAmount(entryInfo.getRecievePayAmount());
                entryInfo.setUnVerifyAmountLocal(entryInfo.getRecievePayAmountLocal());
                entryInfo.setBadAmount(ARAPImportHelper.ZERO);
                entryInfo.setBadAmountLocal(ARAPImportHelper.ZERO);
            } else {
                if (entryInfo.getVerifyAmount().abs().compareTo(entryInfo.getRecievePayAmount().abs()) >= 0) {
                    throw new TaskExternalException(ArOtherBillDataImport.getString("VerifyAmtNotBigARAmt", ctx));
                }
                entryInfo.setUnVerifyAmount(entryInfo.getRecievePayAmount().subtract(entryInfo.getVerifyAmount()));
                entryInfo.setUnVerifyAmountLocal(entryInfo.getRecievePayAmountLocal().subtract(entryInfo.getVerifyAmountLocal()));
            }
            entryInfo.setLockVerifyAmt(entryInfo.getVerifyAmount());
            entryInfo.setLockVerifyAmtLocal(entryInfo.getVerifyAmountLocal());
            entryInfo.setLockUnVerifyAmt(entryInfo.getUnVerifyAmount());
            entryInfo.setLockUnVerifyAmtLocal(entryInfo.getUnVerifyAmountLocal());
            if (otherBillInfo.isIsInitializeBill()) {
                entryInfo.setHisUnVerifyAmount(entryInfo.getUnVerifyAmount());
                entryInfo.setHisUnVerifyAmountLocal(entryInfo.getUnVerifyAmountLocal());
            }
            entryInfo.setUnwriteOffBaseQty(entryInfo.getBaseQty());
            entryInfo.setLocalUnwriteOffAmount(entryInfo.getRecievePayAmountLocal());
            CustomerInfo customer = new CustomerInfo();
            if (CustomerInfo.getBosType().toString().equals(BOSUuid.read((String)otherBillInfo.getAsstActID()).getType().toString())) {
                customer.setId(BOSUuid.read((String)otherBillInfo.getAsstActID()));
                entryInfo.setOrderCustomer(customer);
                entryInfo.setOrdCustName(otherBillInfo.getAsstActName());
                entryInfo.setOrdCustNumber(otherBillInfo.getAsstActNumber());
                entryInfo.setServiceCustomer(customer);
                entryInfo.setSerCustName(otherBillInfo.getAsstActName());
                entryInfo.setSerCustNumber(otherBillInfo.getAsstActNumber());
                entryInfo.setRecAsstActType(otherBillInfo.getAsstActType());
                entryInfo.setRecAsstActID(otherBillInfo.getAsstActID());
                entryInfo.setRecAsstActName(otherBillInfo.getAsstActName());
                entryInfo.setRecAsstActNumber(otherBillInfo.getAsstActNumber());
            }
            if (entryInfo.isIsQtyZero()) {
                this.clearQtyZeroFields(entryInfo);
            }
            boolean isRedBill = entryInfo.isRed();
            ArApBillHelper.handleRedBill((IObjectValue)entryInfo, isRedBill);
            this.checkVerifyAmount(ctx, otherBillInfo, entryInfo, currency, scale);
            this.setMakeInvoiceReqRelationFields(entryInfo);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    public static String getString(String resName, Context ctx) {
        return ArOtherBillDataImport.getString("AR", resName, ctx);
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            OtherBillInfo otherBillInfo = (OtherBillInfo)coreBaseInfo;
            otherBillInfo.getEntry().sort("seq");
            otherBillInfo.setReqCalculate4Srv(false);
            otherBillInfo.getPlans().clear();
            IObjectPK pk = this.getController(ctx).save((CoreBaseInfo)otherBillInfo);
            if (otherBillInfo != null && otherBillInfo.getId() != null) {
                otherBillInfo.setId(BOSUuid.read((String)pk.toString()));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.ar.app.OtherBill";
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FCompany_number", rs.getString("company.number"));
            this.putTable(result, "FBillDate", rs.getString("billDate"));
            this.putTable(result, "FBillType", rs.getString("billType"));
            this.putTable(result, "FPaymentType_number", rs.getString("paymentType.number"));
            this.putTable(result, "FBizDate", rs.getString("bizDate"));
            this.putTable(result, "FAsstActType_number", rs.getString("asstActType.number"));
            this.putTable(result, "FAsstActNumber", rs.getString("asstActNumber"));
            this.putTable(result, "FAdminOrgUnit_number", rs.getString("adminOrgUnit.number"));
            this.putTable(result, "FSaleOrg_number", rs.getString("saleOrg.number"));
            this.putTable(result, "FSaleGroup_number", rs.getString("saleGroup.number"));
            this.putTable(result, "FPerson_number", rs.getString("person.number"));
            this.putTable(result, "FCurrency_number", rs.getString("currency.number"));
            this.putTable(result, "FExchangeRate", rs.getBigDecimal("exchangeRate"));
            this.putTable(result, "FAbstractName", rs.getString("abstractName"));
            this.putTable(result, "FCashDiscount_number", rs.getString("cashDiscount.number"));
            this.putTable(result, "FSettleType_number", rs.getString("settleType.number"));
            this.putTable(result, "FIsBizBill", rs.getString("isBizBill"));
            this.putTable(result, "FSeq", rs.getString("entry.seq"));
            this.putTable(result, "FEntry$material_number", rs.getString("material.number"));
            this.putTable(result, "FEntry$assistProperty_number", rs.getString("assistProperty.number"));
            this.putTable(result, "FEntry$expenseItem_number", rs.getString("expenseItem.number"));
            this.putTable(result, "FEntry$measureUnit_number", rs.getString("measureUnit.number"));
            this.putTable(result, "FEntry_isQtyZero", rs.getString("entry.isQtyZero"));
            this.putTable(result, "FEntry_quantity", rs.getBigDecimal("entry.quantity"));
            this.putTable(result, "FEntry$assistUnit_number", rs.getString("assistUnit.number"));
            this.putTable(result, "FEntry_assistQty", rs.getBigDecimal("entry.assistQty"));
            this.putTable(result, "FEntry_taxRate", rs.getBigDecimal("entry.taxRate"));
            this.putTable(result, "FEntry_price", rs.getBigDecimal("entry.price"));
            this.putTable(result, "FEntry_taxPrice", rs.getBigDecimal("entry.taxPrice"));
            this.putTable(result, "FEntry_discountType", rs.getString("entry.discountType"));
            this.putTable(result, "FEntry_discountRate", rs.getBigDecimal("entry.discountRate"));
            this.putTable(result, "FEntry_discountAmount", rs.getBigDecimal("entry.discountAmount"));
            this.putTable(result, "FEntry_discountAmountLocal", rs.getBigDecimal("entry.discountAmountLocal"));
            this.putTable(result, "FEntry_realPrice", rs.getBigDecimal("entry.realPrice"));
            this.putTable(result, "FEntry_actualPrice", rs.getBigDecimal("entry.actualPrice"));
            this.putTable(result, "FEntry_amount", rs.getBigDecimal("entry.amount"));
            this.putTable(result, "FEntry_amountLocal", rs.getBigDecimal("entry.amountLocal"));
            this.putTable(result, "FEntry_taxAmount", rs.getBigDecimal("entry.taxAmount"));
            this.putTable(result, "FEntry_taxAmountLocal", rs.getBigDecimal("entry.taxAmountLocal"));
            this.putTable(result, "FEntry$oppAccount_number", rs.getString("oppAccount.number"));
            this.putTable(result, "FEntry$account_number", rs.getString("account.number"));
            this.putTable(result, "FEntry_recievePayAmount", rs.getBigDecimal("entry.recievePayAmount"));
            this.putTable(result, "FEntry_recievePayAmountLocal", rs.getBigDecimal("entry.recievePayAmountLocal"));
            this.putTable(result, "FEntry_verifyAmount", rs.getBigDecimal("entry.verifyAmount"));
            this.putTable(result, "FEntry_verifyAmountLocal", rs.getBigDecimal("entry.verifyAmountLocal"));
            this.putTable(result, "FEntry_badAmount", rs.getBigDecimal("entry.badAmount"));
            this.putTable(result, "FEntry_badAmountLocal", rs.getBigDecimal("entry.badAmountLocal"));
            this.putTable(result, "FEntry$coreBillType_number", rs.getString("coreBillType.number"));
            this.putTable(result, "FEntry_coreBillNumber", rs.getString("entry.coreBillNumber"));
            this.putTable(result, "FEntry_coreBillEntrySeq", rs.getString("entry.coreBillEntrySeq"));
            this.putTable(result, "FEntry_remark", rs.getString("entry.remark"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }
}

