/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroupStandard;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.ar.ArApCommonException;
import com.kingdee.eas.fi.ar.ArApQueryParam;
import com.kingdee.eas.fi.ar.IReportHead;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.fi.ar.app.AbstractArSysFacadeControllerBean;
import com.kingdee.eas.fi.ar.app.CaItemAp2PrerecTransSql;
import com.kingdee.eas.fi.ar.app.CaItemApApVPay_PaySql;
import com.kingdee.eas.fi.ar.app.CaItemApArVAp_ApSql;
import com.kingdee.eas.fi.ar.app.CaItemApBillSql;
import com.kingdee.eas.fi.ar.app.CaItemApPrePayVPreRec_PayVRecSql;
import com.kingdee.eas.fi.ar.app.CaItemApPreRecVPrePay_RecVPaySql;
import com.kingdee.eas.fi.ar.app.CaItemApTransSql;
import com.kingdee.eas.fi.ar.app.CaItemApVAr_ArSql;
import com.kingdee.eas.fi.ar.app.CaItemApVPay_ApVArSql;
import com.kingdee.eas.fi.ar.app.CaItemAr2PrepayTransSql;
import com.kingdee.eas.fi.ar.app.CaItemArBillSql;
import com.kingdee.eas.fi.ar.app.CaItemArPrePayVPreRec_PayVRecSql;
import com.kingdee.eas.fi.ar.app.CaItemArPreRecVPrePay_RecVPaySql;
import com.kingdee.eas.fi.ar.app.CaItemArTransSql;
import com.kingdee.eas.fi.ar.app.CaItemArVRec_ArVApSql;
import com.kingdee.eas.fi.ar.app.CaItemArVRec_RecSql;
import com.kingdee.eas.fi.ar.app.CaItemBadAcctSql;
import com.kingdee.eas.fi.ar.app.CaItemBadRecASql;
import com.kingdee.eas.fi.ar.app.CaItemBadRec_BadSql;
import com.kingdee.eas.fi.ar.app.CaItemBadRec_RecSql;
import com.kingdee.eas.fi.ar.app.CaItemPay2ArTransSql;
import com.kingdee.eas.fi.ar.app.CaItemPayBillSql;
import com.kingdee.eas.fi.ar.app.CaItemPayTransSql;
import com.kingdee.eas.fi.ar.app.CaItemRec2ApTransSql;
import com.kingdee.eas.fi.ar.app.CaItemRecBillSql;
import com.kingdee.eas.fi.ar.app.CaItemRecTransSql;
import com.kingdee.eas.fi.ar.app.util.CommonServerUtils;
import com.kingdee.eas.fi.arap.app.util.TempTableUtil;
import com.kingdee.eas.fi.arap.util.CollectionUtil;
import com.kingdee.eas.fi.arap.util.DBUtil;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class ArSysFacadeControllerBean
extends AbstractArSysFacadeControllerBean {
    private static final long serialVersionUID = -1156329331248036302L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ar.app.ArSysFacadeControllerBean");

    @Override
    protected BigDecimal _getArCreditBal(Context ctx, IObjectPK companyPK, IObjectPK customerPK) throws BOSException, EASBizException {
        return this.getCreditBal(ctx, companyPK, customerPK, false);
    }

    @Override
    protected BigDecimal _getBizCodeCreditBal(Context ctx, IObjectPK companyPK, IObjectPK customerPK) throws BOSException, EASBizException {
        return this.getCreditBal(ctx, companyPK, customerPK, true);
    }

    private BigDecimal getCreditBal(Context ctx, IObjectPK companyPK, IObjectPK customerPK, boolean fBizCode) throws BOSException, EASBizException {
        this.checkParams(companyPK, customerPK);
        CompanyOrgUnitInfo companyInfo = this.getCompanyInfo(ctx, companyPK);
        Set companyIds = this.getCompanyIdSet(ctx, companyInfo);
        if (companyIds == null || companyIds.size() == 0) {
            return null;
        }
        String comPeriodTbl = this.getCompanyPeriodTbl(ctx, companyIds);
        String custSupIds = fBizCode ? this.getCustSuppIds(ctx, customerPK) : null;
        BigDecimal bal = SysConstant.BIGZERO;
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            String bizAmtSql = fBizCode ? this.bizCodeBalQuerySql(comPeriodTbl, custSupIds, true) : this.arBalQuerySql(comPeriodTbl, customerPK);
            logger.debug((Object)("credit Bal balAmt sql: \r\n" + bizAmtSql));
            pstmt = con.prepareStatement(bizAmtSql);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                bal = rs.getBigDecimal(1) != null ? bal.add(rs.getBigDecimal(1)) : bal;
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)("error while get the CreditBal(bizCode:" + fBizCode + ")"), (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)con);
        logger.debug((Object)((fBizCode ? "bizCodeCreditBal:" : "arCreditBal:") + bal));
        TempTableUtil.releasTempTable(ctx, comPeriodTbl);
        return bal;
    }

    private String getCustSuppIds(Context ctx, IObjectPK customerPK) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select Fid from t_bd_supplier where FBizAnalysisCodeId =");
        sql.append(" (select FBizAnalysisCodeId from t_bd_customer ");
        sql.append(" where fid = ?) union all ");
        sql.append("select Fid from t_bd_customer where FBizAnalysisCodeId =");
        sql.append(" (select FBizAnalysisCodeId from t_bd_customer ");
        sql.append(" where fid = ?)");
        Connection con = null;
        Statement pstmt = null;
        IRowSet rs = null;
        StringBuffer ids = new StringBuffer();
        ids.append("'").append(customerPK.toString()).append("'");
        try {
            con = this.getConnection(ctx);
            logger.debug((Object)("arSys getCustSupByWithBizcode:\r\n" + sql));
            Object[] params = new Object[]{customerPK.toString(), customerPK.toString()};
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            while (rs.next()) {
                ids.append(", '").append(rs.getString(1)).append("'");
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"arSys customerSupplierIds: ", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, pstmt, (Connection)con);
        return ids.toString();
    }

    private Set getSubCompanyIds(Context ctx, String comLongNum) throws BOSException {
        HashSet<String> subIds = new HashSet<String>();
        String sql = "select FId from t_org_company where FLongNumber like ? and FIsLeaf = 1 and FIsOnlyUnion = 0";
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            pstmt = con.prepareStatement(sql);
            pstmt.setString(1, comLongNum + "%");
            rs = pstmt.executeQuery();
            while (rs.next()) {
                subIds.add(rs.getString(1));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return subIds;
    }

    private Set getSubCreditCompanyIds(Context ctx, String comLongNum) throws BOSException {
        HashSet<String> subIds = new HashSet<String>();
        String sql = "select company.FId from t_org_company company left outer join t_bas_paramitem paramitem on paramitem.forgunitid=company.fid inner join t_bas_param param on param.fid=paramitem.fkeyid  where company.FLongNumber  like ? and company.FIsLeaf = 1 and company.FIsOnlyUnion = 0  and paramitem.Fvalue_" + ctx.getLocale() + "='true' and param.fnumber='" + "G004" + "'";
        Connection con = null;
        Statement pstmt = null;
        IRowSet rs = null;
        try {
            Object[] params = new Object[]{comLongNum + "%"};
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
            while (rs.next()) {
                subIds.add(rs.getString(1));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, pstmt, con);
        return subIds;
    }

    private String arBalQuerySql(String comPeriodTbl, IObjectPK customerPK) {
        StringBuffer sql = new StringBuffer();
        sql.append("select sum(FAmt) from \r\n(");
        sql.append("select sum(t1.FBeginBalanceLocal) FAmt from ");
        sql.append(" t_ar_arBalance t1 \r\n inner join ").append(comPeriodTbl);
        sql.append(" t2 on t1.FCompanyId = t2.FCompanyId and ");
        sql.append(" t1.FPeriodId = t2.FCurrentPeriodId\r\n where");
        sql.append(" t1.FAsstActId = '").append(customerPK);
        sql.append("' and t1.FBalType IN (");
        sql.append(101).append(", ").append(104).append(")");
        sql.append(" \r\n union all \r\n ");
        sql.append("SELECT -1* FLocalAmount FAmt FROM T_CAS_ReceivingBill");
        sql.append(" t1 inner join ").append(comPeriodTbl);
        sql.append(" t2 on t1.FCompanyId = t2.FCompanyId \r\n");
        sql.append(" where FBillStatus > 13 and FSourceType = 100");
        sql.append(" and FPayerID = '").append(customerPK);
        sql.append("' and FBizDate >= t2.FBeginDate ");
        sql.append("\r\n union all \r\n");
        sql.append("SELECT FAmountLocal FAmt FROM T_AR_OTHERBILL");
        sql.append(" t1 inner join ").append(comPeriodTbl);
        sql.append(" t2 on t1.FCompanyId = t2.FCompanyId \r\n");
        sql.append(" where FBillStatus=3 and FAsstActID = '");
        sql.append(customerPK).append("' and FBillDate >= t2.FBeginDate ");
        sql.append("\r\n union all \r\n");
        sql.append("SELECT (-1 * FBadAmountsLocal) FAmt FROM T_AR_BadAcct");
        sql.append(" t1 inner join ").append(comPeriodTbl);
        sql.append(" t2 on t1.FCompanyId = t2.FCompanyId \r\n");
        sql.append(" where FAuditorId is not null and FAcctCussentID = '");
        sql.append(customerPK).append("' and FBadAcctDate >= t2.FBeginDate ");
        sql.append("\r\n union all \r\n");
        sql.append("SELECT (-1 * FThisVerificateAmtLoc_Main) FAmt");
        sql.append(" FROM T_AR_VerificationBill");
        sql.append(" t1 inner join ").append(comPeriodTbl);
        sql.append(" t2 on t1.FCompanyId = t2.FCompanyId \r\n");
        sql.append(" where ((FVerificationType=107");
        sql.append(" or (FVerificationType=101 AND FIsSameCurrency = 0)) or");
        sql.append(" (FVerificationType=103  or   FVerificationType=109)) ");
        sql.append(" and FAcctCussID_Main = '");
        sql.append(customerPK).append("' and FBizDate >= t2.FBeginDate ");
        sql.append("\r\n union all \r\n");
        sql.append("SELECT FThisVerificateAmtLoc_Second FAmt");
        sql.append(" FROM T_AR_VerificationBill\r\n");
        sql.append(" t1 inner join ").append(comPeriodTbl);
        sql.append(" t2 on t1.FCompanyId = t2.FCompanyId \r\n");
        sql.append(" where (FVerificationType=107");
        sql.append(" or (FVerificationType=101 AND FIsSameCurrency = 0)) ");
        sql.append(" and FAcctCussID_Second = '");
        sql.append(customerPK).append("' and FBizDate >= t2.FBeginDate ");
        sql.append("\r\n union all \r\n");
        sql.append("SELECT -1*FThisVerificateAmtLoc_Second FAmt");
        sql.append(" FROM T_AP_VerificationBill");
        sql.append(" t1 inner join ").append(comPeriodTbl);
        sql.append(" t2 on t1.FCompanyId = t2.FCompanyId \r\n");
        sql.append(" where (FVerificationType=203 or FVerificationType=209)");
        sql.append(" and FAcctCussID_Second = '");
        sql.append(customerPK).append("' and FBizDate >= t2.FBeginDate ");
        sql.append("\r\n union all \r\n");
        sql.append("SELECT FThisVerificateAmtLoc_Main FAmt");
        sql.append(" FROM T_AR_VerificationBill");
        sql.append(" t1 inner join ").append(comPeriodTbl);
        sql.append(" t2 on t1.FCompanyId = t2.FCompanyId \r\n");
        sql.append("where ((FVerificationType=104  or FVerificationType=110)");
        sql.append(" or (FVerificationType=113  or   FVerificationType=114))");
        sql.append(" and FAcctCussID_Main = '");
        sql.append(customerPK).append("' and FBizDate >= t2.FBeginDate ");
        sql.append("\r\n union all \r\n");
        sql.append("SELECT FThisVerificateAmtLoc_Second FAmt");
        sql.append(" FROM T_AP_VerificationBill");
        sql.append(" t1 inner join ").append(comPeriodTbl);
        sql.append(" t2 on t1.FCompanyId = t2.FCompanyId \r\n");
        sql.append("where ((FVerificationType=204  or FVerificationType=210)");
        sql.append(" or (FVerificationType=211  or   FVerificationType=212))");
        sql.append(" and FAcctCussID_Second = '");
        sql.append(customerPK).append("' and FBizDate >= t2.FBeginDate ");
        sql.append("\r\n union all \r\n");
        sql.append("SELECT FThisVerificateAmtLoc_Main FAmt");
        sql.append(" FROM T_AR_VerificationBill");
        sql.append(" t1 inner join ").append(comPeriodTbl);
        sql.append(" t2 on t1.FCompanyId = t2.FCompanyId \r\n");
        sql.append("where (FVerificationType=111  AND FIsSameCurrency = 1)");
        sql.append(" and FAcctCussID_Main = '");
        sql.append(customerPK).append("' and FBizDate >= t2.FBeginDate ");
        sql.append("\r\n union all \r\n");
        sql.append("SELECT FThisVerificateAmtLoc_Second FAmt");
        sql.append(" FROM T_AR_VerificationBill");
        sql.append(" t1 inner join ").append(comPeriodTbl);
        sql.append(" t2 on t1.FCompanyId = t2.FCompanyId \r\n");
        sql.append(" where (FVerificationType=112 ");
        sql.append(" or (FVerificationType=111 AND FIsSameCurrency = 0))");
        sql.append(" and FAcctCussID_Second = '");
        sql.append(customerPK).append("' and FBizDate >= t2.FBeginDate ");
        sql.append("\r\n union all \r\n");
        sql.append("SELECT A.FAmountLocal FAmt\r\n");
        sql.append(" FROM T_AR_OTHERBILL A INNER JOIN T_AR_OTHERBILL B");
        sql.append(" ON A.FSourceBillID = B.FID and A.FCompanyId");
        sql.append(" = B.FCompanyId\r\n");
        sql.append(" inner join ").append(comPeriodTbl);
        sql.append(" t2 on A.FCompanyId = t2.FCompanyId ");
        sql.append("and B.FCompanyId = t2.FCompanyId\r\n ");
        sql.append(" where (A.FIsReverseBill = 0 and A.FIsTransBill = 1");
        sql.append(" and A.FBillStatus = 3 ) and B.FBillStatus = 3 ");
        sql.append(" and B.FAsstActID = '");
        sql.append(customerPK).append("' and A.FBizDate >= t2.FBeginDate ");
        sql.append("\r\n) as t1");
        return sql.toString();
    }

    private void checkParams(IObjectPK companyPK, IObjectPK customerPK) throws EASBizException {
        if (companyPK == null || StringUtils.isEmpty((String)companyPK.toString())) {
            throw new ArApCommonException(ArApCommonException.COMPANY_NULL);
        }
        if (customerPK == null || StringUtils.isEmpty((String)customerPK.toString())) {
            throw new ArApCommonException(ArApCommonException.CUSTOMER_NULL);
        }
    }

    private String bizCodeBalQuerySql(String comPeriodTbl, String custSupIds, boolean fAR) {
        StringBuffer sql = new StringBuffer(10200);
        sql.append("select sum(tBal.FAmt) from \r\n(");
        sql.append(" select t1.FBeginBalanceLocal FAmt from ");
        sql.append(fAR ? "t_ar_arBalance" : "t_ap_apBalance");
        sql.append(" t1 \r\n inner join ").append(comPeriodTbl);
        sql.append(" t2 on t1.FCompanyId = t2.FCompanyId and ");
        sql.append(" t1.FPeriodId = t2.FCurrentPeriodId\r\n where");
        sql.append(" t1.FAsstActId in (").append(custSupIds);
        sql.append(") and t1.FBalType IN (").append(101);
        sql.append(fAR ? ", 104" : "").append(")");
        sql.append("\r\n union all \r\n");
        sql.append("select -1 * t1.FBeginBalanceLocal FAmt from ");
        sql.append(fAR ? "t_ap_apBalance" : "t_ar_arBalance");
        sql.append(" t1 \r\n inner join ").append(comPeriodTbl);
        sql.append(" t2 on t1.FCompanyId = t2.FCompanyId and ");
        sql.append(" t1.FPeriodId = t2.FCurrentPeriodId\r\n where");
        sql.append(" t1.FAsstActId in (").append(custSupIds);
        sql.append(") and t1.FBalType IN (").append(101);
        sql.append(fAR ? ", 104" : "").append(")");
        sql.append(" \r\n union all \r\n ");
        sql.append(this.bizCodeArQuerySql(comPeriodTbl, custSupIds, fAR));
        sql.append("\r\n union all \r\n ");
        sql.append(this.bizCodeApQuerySql(comPeriodTbl, custSupIds, fAR));
        sql.append("\r\n) as tBal");
        return sql.toString();
    }

    private String bizCodeArQuerySql(String comPeriodTbl, String custSupIds, boolean fAR) {
        StringBuffer sql = new StringBuffer(5000);
        sql.append("select sum(FAmt) FAmt from \r\n(");
        sql.append(new CaItemArBillSql().getCompBalSql(comPeriodTbl, custSupIds, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemRecBillSql().getCompBalSql(comPeriodTbl, custSupIds, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemBadAcctSql().getCompBalSql(comPeriodTbl, custSupIds, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemBadRecASql().getCompBalSql(comPeriodTbl, custSupIds, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemBadRec_RecSql().getCompBalSql(comPeriodTbl, custSupIds, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemArVRec_ArVApSql().getCompBalSql(comPeriodTbl, custSupIds, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemArVRec_RecSql().getCompBalSql(comPeriodTbl, custSupIds, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemArPreRecVPrePay_RecVPaySql().getCompBalSql(comPeriodTbl, custSupIds, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemApVAr_ArSql().getCompBalSql(comPeriodTbl, custSupIds, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemArPrePayVPreRec_PayVRecSql().getCompBalSql(comPeriodTbl, custSupIds, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemArTransSql().getCompBalSql(comPeriodTbl, custSupIds, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemRecTransSql().getCompBalSql(comPeriodTbl, custSupIds, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemAr2PrepayTransSql().getCompBalSql(comPeriodTbl, custSupIds, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemRec2ApTransSql().getCompBalSql(comPeriodTbl, custSupIds, fAR));
        sql.append("\r\n) as t_Ar");
        return sql.toString();
    }

    private String bizCodeApQuerySql(String comPeriodTbl, String custSupIds, boolean fAR) {
        StringBuffer sql = new StringBuffer(5000);
        sql.append("select -1*sum(FAmt) FAmt from \r\n(");
        sql.append(new CaItemApBillSql().getCompBalSql(comPeriodTbl, custSupIds, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemPayBillSql().getCompBalSql(comPeriodTbl, custSupIds, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemApVPay_ApVArSql().getCompBalSql(comPeriodTbl, custSupIds, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemApApVPay_PaySql().getCompBalSql(comPeriodTbl, custSupIds, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemApPrePayVPreRec_PayVRecSql().getCompBalSql(comPeriodTbl, custSupIds, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemApArVAp_ApSql().getCompBalSql(comPeriodTbl, custSupIds, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemApPreRecVPrePay_RecVPaySql().getCompBalSql(comPeriodTbl, custSupIds, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemApTransSql().getCompBalSql(comPeriodTbl, custSupIds, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemPayTransSql().getCompBalSql(comPeriodTbl, custSupIds, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemAp2PrerecTransSql().getCompBalSql(comPeriodTbl, custSupIds, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemPay2ArTransSql().getCompBalSql(comPeriodTbl, custSupIds, fAR));
        sql.append("\r\n) as t_ap");
        return sql.toString();
    }

    @Override
    protected String _getCustomersCreditBalTable(Context ctx, IObjectPK companyPK, List customerIds, boolean fAnalyseByBizCode) throws BOSException, EASBizException {
        if (companyPK == null || StringUtils.isEmpty((String)companyPK.toString())) {
            throw new ArApCommonException(ArApCommonException.COMPANY_NULL);
        }
        CompanyOrgUnitInfo companyInfo = this.getCompanyInfo(ctx, companyPK);
        Set companyIds = this.getCreditCompanyIdSet(ctx, companyInfo);
        if (companyIds == null || companyIds.size() == 0) {
            return null;
        }
        return this.getCompsCustsCreditBalTbl(ctx, companyInfo, companyIds, customerIds, null, true, fAnalyseByBizCode);
    }

    private CompanyOrgUnitInfo getCompanyInfo(Context ctx, IObjectPK companyPK) throws BOSException, EASBizException {
        String oql = "select id, isOnlyUnion, longNumber, CU.id where id = '" + companyPK + "' ";
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo companyInfo = iCompany.getCompanyOrgUnitInfo(oql);
        if (companyInfo == null) {
            throw new ArApCommonException(ArApCommonException.COMPANY_NULL);
        }
        return companyInfo;
    }

    private Set getCompanyIdSet(Context ctx, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        Set<Object> companyIds = new HashSet<BOSUuid>();
        boolean fGroup = companyInfo.isIsOnlyUnion();
        if (fGroup) {
            companyIds = this.getSubCompanyIds(ctx, companyInfo.getLongNumber());
        } else {
            companyIds.add(companyInfo.getId());
        }
        return companyIds;
    }

    private Set getCreditCompanyIdSet(Context ctx, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        Set<BOSUuid> companyIds = new HashSet();
        boolean fGroup = companyInfo.isIsOnlyUnion();
        if (fGroup) {
            companyIds = this.getSubCreditCompanyIds(ctx, companyInfo.getLongNumber());
        } else {
            String sql = "select company.FId from t_org_company company inner join t_bas_paramitem paramitem on paramitem.forgunitid=company.fid  inner join t_bas_param param on param.fid=paramitem.fkeyid  where company.fid='" + companyInfo.getId() + "' and paramitem.Fvalue_" + ctx.getLocale() + "='true' and param.fnumber='" + "G004" + "'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                if (rs != null && rs.next()) {
                    companyIds.add(companyInfo.getId());
                }
            }
            catch (SQLException e) {
                logger.error((Object)("sql:" + sql), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        return companyIds;
    }

    private String getCompanyPeriodTbl(Context ctx, Set companyIds) throws BOSException, EASBizException {
        String tableDefine = "(FCompanyId varchar(44), FCurrentPeriodId varchar(44), FBeginDate datetime)";
        String tmpTableName = TempTableUtil.createTempTable(ctx, tableDefine);
        this.insertCompanyPeriodTbl(ctx, companyIds, true, tmpTableName);
        return tmpTableName;
    }

    private void insertCompanyPeriodTbl(Context ctx, Set companyIds, Boolean isAr, String tmpTableName) throws SQLDataException, ArApCommonException, BOSException {
        Connection con = null;
        Statement stmt = null;
        try {
            con = this.getConnection(ctx);
            StringBuffer sql = new StringBuffer();
            sql.append("insert into ").append(tmpTableName).append("\r\n ");
            sql.append("select t1.FCompanyId, t1.FCurrentPeriodId,");
            sql.append(" t4.FBeginDate from T_BD_SystemStatusCtrol t1");
            sql.append(" left join T_BD_SystemStatus t2 on");
            sql.append(" t1.FSystemStatusId = t2.FId left join t_org_company");
            sql.append(" t3 on t1.FCompanyId = t3.FId left join ");
            sql.append(" t_bd_period t4 on t1.FCurrentPeriodId = t4.FId ");
            sql.append("\r\n where t3.FId in (").append(CollectionUtil.ids2SqlString(companyIds));
            sql.append(") and t2.FName = ");
            if (isAr.booleanValue()) {
                sql.append(12);
            } else {
                sql.append(13);
            }
            sql.append(" and t1.FCurrentPeriodId is not null ");
            stmt = con.createStatement();
            logger.debug((Object)("query companys with periods :\r\n" + sql));
            stmt.execute(sql.toString());
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"get the companys with periods", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)con);
    }

    private String getCompanyPeriodTbl(Context ctx, RptParams params) throws BOSException, EASBizException {
        String tableDefine = "(FCompanyId varchar(44), FCurrentPeriodId varchar(44), FBeginDate datetime)";
        Connection con = null;
        Statement stmt = null;
        String tmpTableName = null;
        try {
            con = this.getConnection(ctx);
            tmpTableName = CommonServerUtils.createTempTable(ctx, con, "ArCustomersCredit_CompPeriodTbl", tableDefine);
            StringBuffer sql = new StringBuffer();
            sql.append("insert into ").append(tmpTableName).append("\r\n ");
            sql.append("select t1.FCompanyId, t1.FCurrentPeriodId,");
            sql.append(" t4.FBeginDate from T_BD_SystemStatusCtrol t1");
            sql.append(" left join T_BD_SystemStatus t2 on");
            sql.append(" t1.FSystemStatusId = t2.FId inner join ");
            sql.append(params.getString("CompanyTempTable"));
            sql.append(" company on t1.FCompanyId = company.fid ");
            sql.append(" inner join t_bd_period t4 on t1.FCurrentPeriodId = t4.FId ");
            sql.append("\r\n where t2.FName = ");
            sql.append(13);
            sql.append(" and t1.FCurrentPeriodId is not null ");
            stmt = con.createStatement();
            logger.debug((Object)("query companys with periods :\r\n" + sql));
            stmt.execute(sql.toString());
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"get the companys with periods", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)con);
        return tmpTableName;
    }

    /*
     * Unable to fully structure code
     */
    private String getCussAcctRange(Context ctx, CompanyOrgUnitInfo companyInfo, Set companyIds, List customerIds, boolean fAnalyseByBizCode) throws BOSException, EASBizException {
        block11: {
            block12: {
                block10: {
                    tableDefine = "(FId varchar(44), FNumber nvarchar(200),  FBizAnalysisCodeId varchar(44), FIsByBizCode int default 0, FIsCust int default 1)";
                    con = null;
                    stmt = null;
                    pstmt = null;
                    rs = null;
                    tmpTableName = TempTableUtil.createTempTable(ctx, tableDefine);
                    con = this.getConnection(ctx);
                    stmt = con.createStatement();
                    sql = null;
                    if (customerIds != null && customerIds.size() != 0) ** GOTO lbl24
                    if (companyInfo != null) break block10;
                    var13_14 = null;
                    SQLUtils.cleanup((Statement)stmt);
                    SQLUtils.cleanup(rs, pstmt, (Connection)con);
                    return var13_14;
                }
                sql = "insert into " + tmpTableName + " (FId, FNumber)\r\n" + this.companysCustsSql(ctx, companyInfo, companyIds);
                ArSysFacadeControllerBean.logger.debug((Object)("insert cust range sql \r\n" + sql));
                stmt.execute(sql);
                break block12;
lbl24:
                // 1 sources

                sql = "insert into " + tmpTableName + " (FId) values (?) ";
                ArSysFacadeControllerBean.logger.debug((Object)("insert cust range sql \r\n" + sql));
                pstmt = con.prepareStatement(sql);
                n = customerIds.size();
                for (i = 0; i < n; ++i) {
                    id = customerIds.get(i).toString();
                    pstmt.setString(1, id);
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
            }
            if (fAnalyseByBizCode) break block11;
            i = tmpTableName;
            SQLUtils.cleanup((Statement)stmt);
            SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)con);
            return i;
        }
        try {
            uSql = new StringBuffer(90);
            uSql.append("update ").append(tmpTableName);
            uSql.append(" set FBizAnalysisCodeId = ? ");
            uSql.append(" where FId = ?");
            if (pstmt != null) {
                pstmt.close();
            }
            ArSysFacadeControllerBean.logger.debug((Object)("set qryCust bizCode sql\r\n" + uSql));
            pstmt = con.prepareStatement(uSql.toString());
            sSql = new StringBuffer(200);
            sSql.append(" select t1.FBizAnalysisCodeId, t1.FId from ");
            sSql.append(" t_bd_customer t1 \r\n inner join ");
            sSql.append(tmpTableName).append(" t2 on t1.FId = t2.FId ");
            sSql.append("\r\n where t1.FBizAnalysisCodeId is not null");
            ArSysFacadeControllerBean.logger.debug((Object)("get custBizCode sql: \r\n" + sSql));
            rs = stmt.executeQuery(sSql.toString());
            fHasBizCode = false;
            while (rs.next()) {
                pstmt.setString(1, rs.getString(1));
                pstmt.setString(2, rs.getString(2));
                pstmt.addBatch();
                fHasBizCode = true;
            }
            if (fHasBizCode) {
                pstmt.executeBatch();
                iSql = new StringBuffer(300);
                iSql.append("insert into ").append(tmpTableName);
                iSql.append(" (FId, FBizAnalysisCodeId, FNumber,");
                iSql.append(" FIsByBizCode, FIsCust) \r\n");
                iSql.append(" select t1.FId, t1.FBizAnalysisCodeId, ");
                iSql.append(" t1.FNumber, 1, 1 from ");
                iSql.append(" t_bd_customer t1 ");
                iSql.append("\r\n  inner join ").append(tmpTableName);
                iSql.append(" t2 on t1.FBizAnalysisCodeId = ");
                iSql.append("t2.FBizAnalysisCodeId where t1.FId not in (");
                iSql.append(" select fid from ").append(tmpTableName);
                iSql.append(") \r\n union all \r\n");
                iSql.append(" select t1.FId, t1.FBizAnalysisCodeId, ");
                iSql.append(" t1.FNumber, 1, 0 from ");
                iSql.append(" t_bd_supplier t1 \r\n inner join ");
                iSql.append(tmpTableName);
                iSql.append(" t2 on t1.FBizAnalysisCodeId = ");
                iSql.append("t2.FBizAnalysisCodeId ");
                ArSysFacadeControllerBean.logger.debug((Object)("ins sameBizCode Sql: \r\n" + iSql));
                stmt.execute(iSql.toString());
            }
        }
        catch (SQLException e) {
            try {
                ArSysFacadeControllerBean.logger.error((Object)"excpetion while query cussAccts", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable var17_23) {
                SQLUtils.cleanup(stmt);
                SQLUtils.cleanup(rs, pstmt, (Connection)con);
                throw var17_23;
            }
        }
        SQLUtils.cleanup((Statement)stmt);
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return tmpTableName;
    }

    /*
     * Unable to fully structure code
     */
    private String getCussAcctRangeForRpt(Context ctx, CompanyOrgUnitInfo companyInfo, Set companyIds, String cusTbl, boolean fAnalyseByBizCode) throws BOSException, EASBizException {
        block10: {
            block11: {
                block9: {
                    tableDefine = "(FId varchar(44), FNumber nvarchar(200),  FBizAnalysisCodeId varchar(44), FIsByBizCode int default 0, FIsCust int default 1)";
                    con = null;
                    stmt = null;
                    pstmt = null;
                    rs = null;
                    tmpTableName = TempTableUtil.createTempTable(ctx, tableDefine);
                    con = this.getConnection(ctx);
                    stmt = con.createStatement();
                    sql = null;
                    if (cusTbl != null) ** GOTO lbl24
                    if (companyInfo != null) break block9;
                    var13_14 = null;
                    SQLUtils.cleanup((Statement)stmt);
                    SQLUtils.cleanup(rs, pstmt, (Connection)con);
                    return var13_14;
                }
                sql = "insert into " + tmpTableName + " (FId, FNumber)\r\n" + this.companysCustsSql(ctx, companyInfo, companyIds);
                ArSysFacadeControllerBean.logger.debug((Object)("insert cust range sql \r\n" + sql));
                stmt.execute(sql);
                break block11;
lbl24:
                // 1 sources

                sql = "insert into " + tmpTableName + " (FId) select fid from " + cusTbl;
                stmt.execute(sql);
            }
            if (fAnalyseByBizCode) break block10;
            var13_15 = tmpTableName;
            SQLUtils.cleanup((Statement)stmt);
            SQLUtils.cleanup(rs, pstmt, (Connection)con);
            return var13_15;
        }
        try {
            uSql = new StringBuffer(90);
            uSql.append("update ").append(tmpTableName);
            uSql.append(" set FBizAnalysisCodeId = ? ");
            uSql.append(" where FId = ?");
            if (pstmt != null) {
                pstmt.close();
            }
            ArSysFacadeControllerBean.logger.debug((Object)("set qryCust bizCode sql\r\n" + uSql));
            pstmt = con.prepareStatement(uSql.toString());
            sSql = new StringBuffer(200);
            sSql.append(" select t1.FBizAnalysisCodeId, t1.FId from ");
            sSql.append(" t_bd_customer t1 \r\n inner join ");
            sSql.append(tmpTableName).append(" t2 on t1.FId = t2.FId ");
            sSql.append("\r\n where t1.FBizAnalysisCodeId is not null");
            ArSysFacadeControllerBean.logger.debug((Object)("get custBizCode sql: \r\n" + sSql));
            rs = stmt.executeQuery(sSql.toString());
            fHasBizCode = false;
            while (rs.next()) {
                pstmt.setString(1, rs.getString(1));
                pstmt.setString(2, rs.getString(2));
                pstmt.addBatch();
                fHasBizCode = true;
            }
            if (fHasBizCode) {
                pstmt.executeBatch();
                iSql = new StringBuffer(300);
                iSql.append("insert into ").append(tmpTableName);
                iSql.append(" (FId, FBizAnalysisCodeId, FNumber,");
                iSql.append(" FIsByBizCode, FIsCust) \r\n");
                iSql.append(" select t1.FId, t1.FBizAnalysisCodeId, ");
                iSql.append(" t1.FNumber, 1, 1 from ");
                iSql.append(" t_bd_customer t1 ");
                iSql.append("\r\n  inner join ").append(tmpTableName);
                iSql.append(" t2 on t1.FBizAnalysisCodeId = ");
                iSql.append("t2.FBizAnalysisCodeId where t1.FId not in (");
                iSql.append(" select fid from ").append(tmpTableName);
                iSql.append(") \r\n union all \r\n");
                iSql.append(" select t1.FId, t1.FBizAnalysisCodeId, ");
                iSql.append(" t1.FNumber, 1, 0 from ");
                iSql.append(" t_bd_supplier t1 \r\n inner join ");
                iSql.append(tmpTableName);
                iSql.append(" t2 on t1.FBizAnalysisCodeId = ");
                iSql.append("t2.FBizAnalysisCodeId ");
                ArSysFacadeControllerBean.logger.debug((Object)("ins sameBizCode Sql: \r\n" + iSql));
                stmt.execute(iSql.toString());
            }
        }
        catch (SQLException e) {
            try {
                ArSysFacadeControllerBean.logger.error((Object)"excpetion while query cussAccts", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable var17_20) {
                SQLUtils.cleanup(stmt);
                SQLUtils.cleanup(rs, pstmt, (Connection)con);
                throw var17_20;
            }
        }
        SQLUtils.cleanup((Statement)stmt);
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return tmpTableName;
    }

    private String companysCustsSql(Context ctx, CompanyOrgUnitInfo companyInfo, Set companyIds) throws BOSException, EASBizException {
        String qryName = "com.kingdee.eas.basedata.master.cssp.app.F7CustomerCompanyQuery";
        MetaDataPK cussQryPK = MetaDataPK.create((String)qryName);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)cussQryPK);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("id");
        view.getSelector().add("number");
        ObjectUuidPK cuPK = new ObjectUuidPK(companyInfo.getCU().getId());
        ICustomer iCust = CustomerFactory.getLocalInstance((Context)ctx);
        FilterInfo cuFilter = iCust.getDatabaseDFilter((IObjectPK)cuPK, "id", "adminCU.id");
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo item = new FilterItemInfo("companyOrgUnit.id", (Object)companyIds, CompareType.INCLUDE);
        FilterItemInfo itemStatus = new FilterItemInfo("usedStatus", (Object)"1");
        filterInfo.getFilterItems().add(itemStatus);
        filterInfo.getFilterItems().add(item);
        filterInfo.mergeFilter(cuFilter, "and");
        view.setFilter(filterInfo);
        exec.setObjectView(view);
        return exec.getSQL();
    }

    private String customersBalSql(String custRange, String comCurrPeriodsTbl, Date endDate, boolean fAR) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        if (fAR) {
            sql.append("  select t1.FCompanyId FCompanyId, ");
            sql.append("t1.FAsstActId FCustomerId, ");
            sql.append(" sum(t1.FBeginBalanceLocal) FDebit, 0 FCredit,");
            sql.append(" sum(t1.FBeginBalanceLocal) FBalance\r\n from ");
            sql.append(" t_ar_arBalance");
            sql.append(" t1\r\n inner join ").append(comCurrPeriodsTbl);
            sql.append(" t2 on t1.FCompanyId = t2.FCompanyId and ");
            sql.append(" t1.FPeriodId = t2.FCurrentPeriodId \r\n");
            sql.append("  where 1=1 and t1.FAsstActId in (").append(custRange);
            sql.append(") and t1.FBalType IN (");
            sql.append(101).append(", ").append(104).append(")");
        } else {
            sql.append("  select t1.FCompanyId FCompanyId, ");
            sql.append("  t1.FAsstActId FCustomerId, ");
            sql.append(" 0 FDebit, sum(t1.FBeginBalanceLocal) FCredit,");
            sql.append(" 0-sum(t1.FBeginBalanceLocal) FBalance\r\n from ");
            sql.append(" t_ap_apBalance");
            sql.append(" t1\r\n inner join ").append(comCurrPeriodsTbl);
            sql.append(" t2 on t1.FCompanyId = t2.FCompanyId and ");
            sql.append(" t1.FPeriodId = t2.FCurrentPeriodId\r\n where");
            sql.append(" t1.FAsstActId in (").append(custRange);
            sql.append(") and t1.FBalType = ");
            sql.append(101);
        }
        sql.append("\r\n    group by t1.FCompanyId, t1.FAsstActId");
        return sql.toString();
    }

    private String compCustsBizApSql(String comCurrPeriodsTbl, String custRange, boolean hasEndDate, String sEndNxtDate, boolean fAR) {
        StringBuffer sql = new StringBuffer();
        ArApQueryParam param = new ArApQueryParam(){
            private static final long serialVersionUID = 1L;

            public String getRptPreferenceSchemaKey() {
                return null;
            }

            public IReportHead getReportHead() {
                return null;
            }

            public List getReportFields() {
                return null;
            }
        };
        param.setIncludeBizBill(false);
        param.setBizeCheckBox(false);
        sql.append("  select tBiz.FCompanyId FCompanyId, ");
        sql.append(" tBiz.FCustomerId FCustomerId, ");
        sql.append(fAR ? "0" : "sum(tBiz.FDebit)-sum(tBiz.FCredit)");
        sql.append(" FDebit, ");
        sql.append(fAR ? "sum(tBiz.FCredit)-sum(tBiz.FDebit)" : "0");
        sql.append(" FCredit, sum(tBiz.FAmt) FBalance from\r\n  (");
        sql.append(new CaItemApBillSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR, param));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemPayBillSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR, param));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemApVPay_ApVArSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemApApVPay_PaySql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemApPrePayVPreRec_PayVRecSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemApArVAp_ApSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemApPreRecVPrePay_RecVPaySql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemApTransSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR, param));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemPayTransSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR, param));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemAp2PrerecTransSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR, param));
        sql.append("\r\n union all \r\n ");
        sql.append(new CaItemPay2ArTransSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR, param));
        sql.append("\r\n  ) tBiz group by tBiz.FCompanyId, tBiz.FCustomerId");
        return sql.toString();
    }

    @Override
    protected String _getComsCustsCreditBalTable(Context ctx, List companyIds, List customerIds, Date endDate, boolean fAnalyseByBizCode) throws BOSException, EASBizException {
        if (companyIds == null || companyIds.size() == 0) {
            throw new ArApCommonException(ArApCommonException.COMPANY_NULL);
        }
        if (customerIds == null || customerIds.size() == 0) {
            throw new ArApCommonException(ArApCommonException.CUSTOMER_NULL);
        }
        HashSet companyIdSet = new HashSet(companyIds);
        return this.getCompsCustsCreditBalTbl(ctx, null, companyIdSet, customerIds, endDate, true, fAnalyseByBizCode);
    }

    private String getCompsCustsCreditBalTbl(Context ctx, CompanyOrgUnitInfo companyInfo, Set companyIdSet, List customerIds, Date endDate, boolean fAR, boolean fAnalyseByBizCode) throws BOSException, EASBizException {
        String compPeriodTbl = this.getCompanyPeriodTbl(ctx, companyIdSet);
        String custTbl = this.getCussAcctRange(ctx, companyInfo, companyIdSet, customerIds, fAnalyseByBizCode);
        return this.getCompsCustsCreditBalTbl(ctx, companyInfo, compPeriodTbl, custTbl, endDate, fAR, fAnalyseByBizCode, companyIdSet);
    }

    @Override
    protected String _getComsCustsCreditBalTable(Context ctx, List companyId, String customerTempTab, Date endDate, boolean analyseByBizCode) throws BOSException, EASBizException {
        if (companyId == null || companyId.size() == 0) {
            throw new ArApCommonException(ArApCommonException.COMPANY_NULL);
        }
        if (customerTempTab == null) {
            throw new ArApCommonException(ArApCommonException.CUSTOMER_NULL);
        }
        HashSet companyIdSet = new HashSet(companyId);
        return this.getCompsCustsCreditForRpt(ctx, null, companyIdSet, customerTempTab, endDate, true, analyseByBizCode);
    }

    private String getCompsCustsCreditForRpt(Context ctx, CompanyOrgUnitInfo companyInfo, Set companyIdSet, String customerTempTab, Date endDate, boolean fAR, boolean analyseByBizCode) throws BOSException, EASBizException {
        String compPeriodTbl = this.getCompanyPeriodTbl(ctx, companyIdSet);
        String custTbl = this.getCussAcctRangeForRpt(ctx, companyInfo, companyIdSet, customerTempTab, analyseByBizCode);
        return this.getCompsCustsCreditBalTbl(ctx, companyInfo, compPeriodTbl, custTbl, endDate, fAR, analyseByBizCode, companyIdSet);
    }

    private String getCompsCustsCreditBalTbl(Context ctx, CompanyOrgUnitInfo companyInfo, String compPeriodTbl, String custTbl, Date endDate, boolean fAR, boolean fAnalyseByBizCode, Set companyIdSet) throws BOSException, EASBizException {
        boolean hasEndDate;
        String sEndNxtDate = null;
        boolean bl = hasEndDate = endDate != null;
        if (hasEndDate) {
            Date endNxtDate = new Date(endDate.getTime() + 86400000L);
            SimpleDateFormat dtFormat = new SimpleDateFormat("yyyy-MM-dd");
            sEndNxtDate = dtFormat.format(endNxtDate);
        }
        if (StringUtils.isEmpty((String)custTbl)) {
            logger.error((Object)"arSysfacade cannot query the custRange");
            return null;
        }
        String custRange = "select Fid from " + custTbl;
        StringBuffer tmpTableDefine = new StringBuffer(100);
        tmpTableDefine.append("(FCompanyId varchar(44), ");
        tmpTableDefine.append("FCustomerId varchar(44), ");
        tmpTableDefine.append("FBizCodeId nvarchar(80), ");
        tmpTableDefine.append("FDebit decimal(28, 10) NOT NULL DEFAULT 0, ");
        tmpTableDefine.append("FCredit decimal(28, 10) NOT NULL DEFAULT 0, ");
        tmpTableDefine.append("FBalance decimal(28, 10)  DEFAULT 0, ");
        tmpTableDefine.append("FIsFinal int default 0)");
        String tempTable = TempTableUtil.createTempTable(ctx, tmpTableDefine.toString());
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        Statement pstmt = null;
        try {
            con = this.getConnection(ctx);
            stmt = con.createStatement();
            StringBuffer insPrefix = new StringBuffer();
            insPrefix.append("insert into ").append(tempTable);
            insPrefix.append(" (FCompanyId, FCustomerId, FDebit, ");
            insPrefix.append(" FCredit, FBalance) \r\n");
            StringBuffer sql = new StringBuffer();
            sql.append(insPrefix);
            sql.append(this.customersBalSql(custRange, compPeriodTbl, null, true));
            logger.debug((Object)("compCust customers Bal sql 0:\r\n" + sql));
            stmt.execute(sql.toString());
            this.compCustsBizArSqlNew(ctx, stmt, tempTable, compPeriodTbl, custRange, hasEndDate, sEndNxtDate, fAR);
            logger.debug((Object)("compCust customers Bal sql 0ar:\r\n" + sql));
            sql.delete(0, sql.length());
            sql.append("insert into ").append(tempTable);
            sql.append(" (FCompanyId, FCustomerId, FDebit, ");
            sql.append(" FCredit, FBalance, FIsFinal) \r\n");
            sql.append("  select tBiz.FCompanyId FCompanyId, ");
            sql.append(" tBiz.FCustomerId FCustomerId, ");
            sql.append(" sum(tBiz.FDebit) - sum(tBiz.FCredit) FDebit, ");
            sql.append(" 0 FCredit, ");
            sql.append(" sum(tBiz.FBalance) FBalance ,2 FIsFinal from\r\n  ");
            sql.append(tempTable);
            sql.append("\r\n   tBiz  WHERE FIsFinal = 0 group by tBiz.FCompanyId, tBiz.FCustomerId");
            logger.debug((Object)("compCust customers sumBal sql 0ar:\r\n" + sql));
            stmt.execute(sql.toString());
            sql.delete(0, sql.length());
            sql.append("delete ").append(tempTable);
            sql.append(" where FIsFinal = 0");
            logger.debug((Object)("compCust customers delTemp sql:\r\n" + sql));
            stmt.execute(sql.toString());
            sql.delete(0, sql.length());
            sql.append("delete from ").append(compPeriodTbl);
            stmt.execute(sql.toString());
            sql.delete(0, sql.length());
            this.insertCompanyPeriodTbl(ctx, companyIdSet, false, compPeriodTbl);
            sql.append(insPrefix);
            sql.append(this.customersBalSql(custRange, compPeriodTbl, null, false));
            stmt.execute(sql.toString());
            sql.delete(0, sql.length());
            sql.append(insPrefix);
            sql.append(this.compCustsBizApSql(compPeriodTbl, custRange, hasEndDate, sEndNxtDate, fAR));
            logger.debug((Object)("compCust customers Bal sql 0ap:\r\n" + sql));
            stmt.execute(sql.toString());
            sql.delete(0, sql.length());
            sql.append("insert  into ").append(tempTable);
            sql.append(" (FCompanyId, FCustomerId, FDebit, ");
            sql.append(" FCredit, FBalance, FIsFinal) \r\n");
            sql.append(" select FCompanyId, FCustomerId, 0 FDebit,");
            sql.append(" sum(FCredit) - sum(FDebit) FCredit, sum(FBalance) ");
            sql.append(" FBalance, 3 FIsFinal \r\n from ").append(tempTable);
            sql.append(" WHERE FIsFinal = 0 group by FCompanyId, FCustomerId");
            logger.debug((Object)("compCust customers sumBal sql:\r\n" + sql));
            stmt.execute(sql.toString());
            sql.delete(0, sql.length());
            sql.append("insert  into ").append(tempTable);
            sql.append(" (FCompanyId, FCustomerId, FDebit, ");
            sql.append(" FCredit, FBalance, FIsFinal) \r\n");
            sql.append(" select FCompanyId, FCustomerId, sum(FDebit) FDebit,");
            sql.append(" sum(FCredit) FCredit, sum(FBalance) ");
            sql.append(" FBalance, 1 FIsFinal \r\n from ").append(tempTable);
            sql.append(" WHERE FIsFinal IN (2, 3) group by FCompanyId, FCustomerId");
            logger.debug((Object)("compCust customers sumBal sql:\r\n" + sql));
            stmt.execute(sql.toString());
            sql.delete(0, sql.length());
            sql.append("delete ").append(tempTable);
            sql.append(" where FIsFinal = 0 or FIsFinal = 2 or FIsFinal = 3");
            logger.debug((Object)("compCust customers delTemp sql:\r\n" + sql));
            stmt.execute(sql.toString());
            if (companyInfo != null && companyInfo.isIsOnlyUnion()) {
                sql.delete(0, sql.length());
                sql.append("insert into ").append(tempTable);
                sql.append(" (FCompanyId, FCustomerId, FDebit,");
                sql.append(" FCredit, FBalance, FIsFinal) \r\n");
                sql.append(" select '").append(companyInfo.getId());
                sql.append("' FCompanyId, FCustomerId, ");
                sql.append("sum(FDebit) FDebit, sum(FCredit) FCredit, ");
                sql.append(" sum(FBalance) FBalance, 1 FIsFinal from ");
                sql.append(tempTable);
                sql.append(" group by FCustomerId");
                logger.debug((Object)("compCust sumVirtual company Bal sql 3:\r\n" + sql));
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
            if (fAnalyseByBizCode) {
                TempTablePool.getInstance((Context)ctx).analyzeTable(con, tempTable);
                this.updateBizCodeIdSql(ctx, tempTable, custTbl);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"prepareArCreditBal execute sql exception. ", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(pstmt);
            SQLUtils.cleanup(rs, (Statement)stmt, (Connection)con);
        }
        TempTableUtil.releasTempTable(ctx, compPeriodTbl);
        TempTableUtil.releasTempTable(ctx, custTbl);
        return tempTable;
    }

    @Override
    protected BillBaseInfo _getTermDate(Context ctx, IObjectValue companyInfo, IObjectPK customerid, Date endDate) throws BOSException, EASBizException {
        Set companyIds = this.getCompanyIdSet(ctx, (CompanyOrgUnitInfo)companyInfo);
        if (companyIds == null || companyIds.size() == 0) {
            return null;
        }
        String custIDString = "'" + customerid.toString() + "'";
        String sql = this.getDateQuerySql(companyIds, custIDString, endDate);
        Connection cn = null;
        Statement pstmt = null;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                OtherBillInfo info = new OtherBillInfo();
                info.setNumber(rs.getString("fnumber"));
                info.put("arDate", rs.getDate("fdate"));
                OtherBillInfo otherBillInfo = info;
                return otherBillInfo;
            }
            BillBaseInfo info = null;
            return info;
        }
        catch (SQLException e) {
            logger.error((Object)"Inside calling _getTerDate:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, pstmt, cn);
        }
    }

    @Override
    protected BillBaseInfo _getTermDateByBizCode(Context ctx, IObjectValue companyInfo, IObjectPK customerid, Date endDate) throws BOSException, EASBizException {
        BillBaseInfo info2;
        ResultSet rs;
        PreparedStatement pstmt;
        Connection cn;
        block6: {
            Set companyIds = this.getCompanyIdSet(ctx, (CompanyOrgUnitInfo)companyInfo);
            if (companyIds == null || companyIds.size() == 0) {
                return null;
            }
            String sCustomerId = this.getCustSuppIds(ctx, customerid);
            String sql = this.getDateQuerySql(companyIds, sCustomerId, endDate);
            cn = null;
            pstmt = null;
            rs = null;
            cn = this.getConnection(ctx);
            pstmt = cn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            if (!rs.next()) break block6;
            OtherBillInfo info2 = new OtherBillInfo();
            info2.setNumber(rs.getString("fnumber"));
            info2.put("arDate", rs.getDate("fdate"));
            OtherBillInfo otherBillInfo = info2;
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)cn);
            return otherBillInfo;
        }
        try {
            info2 = null;
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"Inside calling _getTermDateByBizCode:", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)cn);
        return info2;
    }

    private String getDateQuerySql(Set companyIds, String customerid, Date endDate) throws ArApCommonException {
        SimpleDateFormat dtFormat = new SimpleDateFormat("yyyy-MM-dd");
        endDate.setTime(endDate.getTime() + 86400000L);
        StringBuffer sb = new StringBuffer();
        sb.append("select top 1 totherbill.fnumber fnumber, tplan.FRecievePayDate fdate");
        sb.append(" from T_AR_OTHERBILL totherbill");
        sb.append(" left join T_AR_OTHERBILLPLAN tplan on totherbill.fid=tplan.FParentID");
        sb.append(" where totherbill.fasstactid in(").append(customerid).append(")");
        sb.append(" and totherbill.fcompanyid in(").append(CollectionUtil.ids2SqlString(companyIds)).append(")");
        sb.append(" and totherbill.fbilldate<{");
        sb.append(dtFormat.format(endDate)).append("}");
        sb.append(" and tplan.FRecievePayAmount > tplan.FVerifyAmount");
        sb.append(" and totherbill.FBillStatus = 3 and totherbill.FIsBizBill = 0 ");
        sb.append(" order by tplan.FRecievePayDate");
        return sb.toString();
    }

    @Override
    protected String _getTermBalSql(Context ctx, Date endDate, IObjectPK currencyId, String tempTable) throws BOSException {
        StringBuffer sb = new StringBuffer();
        Date endNxtDate = new Date(endDate.getTime() + 86400000L);
        SimpleDateFormat dtFormat = new SimpleDateFormat("yyyy-MM-dd");
        String sEndDate = dtFormat.format(endNxtDate);
        sb.append("select FCompanyID, FCustomerID, sum(FOutBal) FOutBal, sum(FBal) FBal from (");
        sb.append("select t1.FCompanyID FCompanyID, t1.FAsstActID FCustomerID,\r\n");
        sb.append(" sum(tplan.FRecievePayAmount - tplan.FVerifyAmount) FOutBal, 0 FBal");
        sb.append("\r\n from T_AR_OTHERBILL t1");
        sb.append("\r\n left join T_AR_OtherBillPlan tplan");
        sb.append(" on t1.FID=tplan.FParentID");
        sb.append("\r\n inner join ").append(tempTable).append(" ttemp");
        sb.append(" on t1.FCompanyId = ttemp.FCompanyId ");
        sb.append(" and t1.FAsstActId = ttemp.FCustomerId");
        sb.append("\r\n where t1.FCurrencyID='").append(currencyId.toString()).append("'");
        sb.append(" and t1.FBillDate < add_days({").append(sEndDate);
        sb.append("},  case when ttemp.FTerm <> 0 then 0-ttemp.FTerm else -1 end )");
        sb.append("\r\n and t1.FBillDate < {").append(sEndDate);
        sb.append("} and t1.fbillstatus=3 and t1.FUnVerifyAmount <>  0 and ttemp.FBizCodeID is null");
        sb.append("  and t1.FIsBizBill = 0 ");
        sb.append("\r\n group by t1.FCompanyID, t1.FAsstActID");
        sb.append("\r\n union all ");
        sb.append("\r\n select t1.FCompanyId FCompanyID, t1.FAsstActID FCustomerID,");
        sb.append(" 0 FOutBal, sum(tplan.FRecievePayAmount - tplan.FVerifyAmount) FBal");
        sb.append("\r\n from T_AR_OTHERBILL t1");
        sb.append("\r\n left join T_AR_OtherBillPlan tplan");
        sb.append(" on t1.FID=tplan.FParentID");
        sb.append("\r\n inner join ").append(tempTable).append(" ttemp");
        sb.append(" on t1.FCompanyID=ttemp.FCompanyID and t1.FAsstActID=ttemp.FCustomerID");
        sb.append("\r\n where t1.FCurrencyID='").append(currencyId.toString()).append("'");
        sb.append("\r\n and t1.FBillDate >= add_days({").append(sEndDate);
        sb.append("},  case when ttemp.FTerm <> 0 then 0-ttemp.FTerm else -1 end )");
        sb.append("\r\n and t1.FBillDate < {").append(sEndDate).append("}");
        sb.append(" and t1.Fbillstatus=3 and t1.FUnVerifyAmount <>  0 and ttemp.FBizCodeID is null");
        sb.append(" and t1.FIsBizBill = 0 ");
        sb.append("\r\n group by t1.FCompanyID, t1.FAsstActID");
        sb.append(") as temp03___ group by FCompanyID, FCustomerID");
        logger.debug((Object)("creditTerm anlaysis sql:\r\n" + sb));
        return sb.toString();
    }

    @Override
    protected String _getCustomersUnAuditBillsAmtTable(Context ctx, IObjectPK companyPK, List customerIds, boolean fAnalyseByBizCode) throws BOSException, EASBizException {
        if (companyPK == null || StringUtils.isEmpty((String)companyPK.toString())) {
            throw new ArApCommonException(ArApCommonException.COMPANY_NULL);
        }
        CompanyOrgUnitInfo companyInfo = this.getCompanyInfo(ctx, companyPK);
        Set companyIds = this.getCreditCompanyIdSet(ctx, companyInfo);
        if (companyIds == null || companyIds.size() == 0) {
            return null;
        }
        return this.getCustomersUnAuditBillsAmtTbl(ctx, companyInfo, companyIds, customerIds, fAnalyseByBizCode);
    }

    private String getCustomersUnAuditBillsAmtTbl(Context ctx, CompanyOrgUnitInfo companyInfo, Set companyIdSet, List customerIds, boolean fAnalyseByBizCode) throws BOSException, EASBizException {
        String compPeriodTbl = this.getCompanyPeriodTbl(ctx, companyIdSet);
        String custTbl = this.getCussAcctRange(ctx, companyInfo, companyIdSet, customerIds, fAnalyseByBizCode);
        if (StringUtils.isEmpty((String)custTbl)) {
            logger.error((Object)"arSysfacade cannot query the custRange");
            return null;
        }
        StringBuffer tmpTableDefine = new StringBuffer(100);
        tmpTableDefine.append("(FCompanyId varchar(44), ");
        tmpTableDefine.append("FCustomerId varchar(44), ");
        tmpTableDefine.append("FBizCodeId varchar(44), ");
        tmpTableDefine.append("FAmount decimal(28, 10) NOT NULL DEFAULT 0, ");
        tmpTableDefine.append("FIsFinal int default 0)");
        String tempTable = TempTableUtil.createTempTable(ctx, tmpTableDefine.toString());
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        Statement pstmt = null;
        try {
            con = this.getConnection(ctx);
            stmt = con.createStatement();
            String sql = this.arapUnauditSql(tempTable, custTbl, compPeriodTbl, true).toString();
            logger.debug((Object)("unaudit Bill amt sql 0:\r\n" + sql));
            stmt.execute(sql.toString());
            sql = this.arapUnauditSql(tempTable, custTbl, compPeriodTbl, false).toString();
            logger.debug((Object)("unaudit Bill amt sql 1:\r\n" + sql));
            stmt.execute(sql.toString());
            sql = this.recpayUnauditSql(tempTable, custTbl, compPeriodTbl, true).toString();
            logger.debug((Object)("unaudit Bill amt sql 2:\r\n" + sql));
            stmt.execute(sql.toString());
            sql = this.recpayUnauditSql(tempTable, custTbl, compPeriodTbl, false).toString();
            logger.debug((Object)("unaudit Bill amt sql 3:\r\n" + sql));
            stmt.execute(sql.toString());
            sql = this.sumUnauditDataSql(tempTable).toString();
            logger.debug((Object)("sumUnauditData sql:\r\n" + sql));
            stmt.execute(sql);
            sql = "delete " + tempTable + " where FisFinal = 0";
            logger.debug((Object)("del tempData sql:\r\n" + sql));
            stmt.execute(sql);
            if (companyInfo != null && companyInfo.isIsOnlyUnion()) {
                sql = this.sumUnauditCompanySql(companyInfo.getId().toString(), tempTable).toString();
                logger.debug((Object)("sumUnauditCompany \r\n" + sql));
                stmt.execute(sql);
            }
            if (fAnalyseByBizCode) {
                DBUtil.createTempTableIndex(ctx, tempTable, "FCustomerId", false);
                TempTablePool.getInstance((Context)ctx).analyzeTable(con, tempTable);
                this.updateBizCodeIdSql(ctx, tempTable, custTbl);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"prepareArCreditBal execute sql exception. ", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(pstmt);
            SQLUtils.cleanup(rs, (Statement)stmt, (Connection)con);
        }
        TempTableUtil.releasTempTable(ctx, compPeriodTbl);
        TempTableUtil.releasTempTable(ctx, custTbl);
        return tempTable;
    }

    private StringBuffer sumUnauditDataSql(String tempTable) {
        StringBuffer sql = new StringBuffer(200);
        sql.append("insert  into ").append(tempTable);
        sql.append(" (FCompanyId, FCustomerId, FAmount, ");
        sql.append(" FIsFinal) \r\n");
        sql.append(" select FCompanyId, FCustomerId, sum(FAmount) FAmount,");
        sql.append(" 1 FIsFinal \r\n from ").append(tempTable);
        sql.append(" group by FCompanyId, FCustomerId");
        return sql;
    }

    private void updateBizCodeIdSql(Context ctx, String tempTable, String custTbl) throws BOSException {
        StringBuffer sql = new StringBuffer(300);
        String tempTab = TempTableUtil.createTempTable(ctx, "(FCustomerId VARCHAR(44), FBizCodeId VARCHAR(44))");
        sql.append("insert into ").append(tempTab).append("(FCustomerId, FBizCodeId) ");
        sql.append(" select t0.FCustomerId, max(t1.FBizAnalysisCodeId) ");
        sql.append(" from ").append(tempTable).append(" as t0 ");
        sql.append(" inner join ").append(custTbl).append(" as t1 on t0.FCustomerId = t1.FID group by t0.FCustomerId");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        Connection conn = null;
        DBUtil.createTempTableIndex(ctx, tempTab, "FCustomerId", false);
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            DBUtil.AnalyseTable(ctx, conn, tempTab);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        sql.setLength(0);
        sql.append("update ").append(tempTable);
        sql.append(" as t0 set (FBizCodeId) = \r\n");
        sql.append(" (select t1.FBizCodeId");
        sql.append(" \r\n from ").append(tempTab).append(" as t1 ");
        sql.append("\r\n where t0.FCustomerId = t1.FCustomerId)");
        logger.debug((Object)("del tempData sql:\r\n" + sql.toString()));
        DbUtil.execute((Context)ctx, (String)sql.toString());
        TempTableUtil.releasTempTable(ctx, tempTab);
    }

    private StringBuffer arapUnauditSql(String tempTable, String custTbl, String compPeriodTbl, boolean fAR) {
        StringBuffer sql = new StringBuffer(200);
        sql.append("insert into ").append(tempTable);
        sql.append(" (FCompanyId, FCustomerId,");
        sql.append(" FAmount) \r\n");
        sql.append(" select t1.FCompanyId, t1.FAsstActId FCustomerId, ");
        sql.append(fAR ? "" : "0-");
        sql.append(" sum(t1.FAmountLocal) FAmount\r\n from ");
        sql.append(fAR ? "t_ar_otherbill" : "t_ap_otherbill");
        sql.append(" t1\r\n inner join ");
        sql.append(custTbl).append(" t2 on t1.FAsstActId = t2.FId ");
        sql.append("\r\n inner join ").append(compPeriodTbl);
        sql.append(" t3 on t1.FCompanyId = t3.FCompanyId ");
        sql.append("\r\n where t1.FBillDate >= t3.FBeginDate ");
        sql.append(" and t1.FBillStatus = ");
        sql.append(2);
        sql.append("\r\n and t1.FIsBizBill = 0 ");
        if (fAR) {
            sql.append("\r\n and t1.FPaymentTypeID = '91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5' ");
        } else {
            sql.append("\r\n and t1.FPaymentTypeID = '2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5' ");
        }
        sql.append("\r\n group by t1.FCompanyId, t1.FAsstActId");
        return sql;
    }

    private StringBuffer recpayUnauditSql(String tempTable, String custTbl, String compPeriodTbl, boolean fRec) {
        String fldAsstAct = fRec ? "FPayerID" : "FPayeeID";
        StringBuffer sql = new StringBuffer(200);
        sql.append("insert into ").append(tempTable);
        sql.append(" (FCompanyId, FCustomerId,");
        sql.append(" FAmount) \r\n");
        sql.append(" select t1.FCompanyId, t1.");
        sql.append(fldAsstAct).append(" FCustomerId, ");
        sql.append(fRec ? "0-" : "");
        sql.append(" sum(t1.FLocalAmount) FAmount\r\n from ");
        sql.append(fRec ? "T_CAS_ReceivingBill" : "T_CAS_PaymentBill");
        sql.append(" t1\r\n inner join ");
        sql.append(custTbl).append(" t2 on t1.").append(fldAsstAct);
        sql.append(" = t2.FId \r\n inner join ").append(compPeriodTbl);
        sql.append(" t3 on t1.FCompanyId = t3.FCompanyId ");
        sql.append("\r\n where t1.FBizDate >= t3.FBeginDate ");
        sql.append(" and t1.FBillStatus = ");
        sql.append(11);
        if (fRec) {
            sql.append("\r\n and t1.FPaymentTypeID = '91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5' ");
        } else {
            sql.append("\r\n and t1.FPaymentTypeID = '2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5' ");
        }
        sql.append("\r\n group by t1.FCompanyId, t1.").append(fldAsstAct);
        return sql;
    }

    private StringBuffer sumUnauditCompanySql(String companyId, String tempTable) {
        StringBuffer sql = new StringBuffer(200);
        sql.append("insert into ").append(tempTable);
        sql.append(" (FCompanyId, FCustomerId, ");
        sql.append(" FAmount, FIsFinal) \r\n");
        sql.append(" select '").append(companyId);
        sql.append("' FCompanyId, FCustomerId, ");
        sql.append(" sum(FAmount) FAmount, ");
        sql.append(" 1 FIsFinal from ");
        sql.append(tempTable);
        sql.append(" group by FCustomerId");
        return sql;
    }

    private void compCustsBizArSqlNew(Context ctx, Statement stmt, String tmpTableName, String comCurrPeriodsTbl, String custRange, boolean hasEndDate, String sEndNxtDate, boolean fAR) throws BOSException {
        this.insertARToTmptable(ctx, tmpTableName, comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR);
        String groupSql = this.getArGroupData(tmpTableName, fAR);
        try {
            stmt.execute(groupSql);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String getArGroupData(String tmpTable, boolean fAR) {
        StringBuffer sql = new StringBuffer();
        sql.append("  select tBiz.FCompanyId FCompanyId, ");
        sql.append(" tBiz.FCustomerId FCustomerId, ");
        sql.append(fAR ? "sum(tBiz.FDebit)-sum(tBiz.FCredit)" : "0");
        sql.append(" FDebit, ");
        sql.append(fAR ? "0" : "sum(tBiz.FCredit)-sum(tBiz.FDebit)");
        sql.append(" FCredit, sum(tBiz.FBalance) FBalance from\r\n  ");
        sql.append(tmpTable);
        sql.append("\r\n   tBiz group by tBiz.FCompanyId, tBiz.FCustomerId");
        return sql.toString();
    }

    private void insertARToTmptable(Context ctx, String tmpTable, String comCurrPeriodsTbl, String custRange, boolean hasEndDate, String sEndNxtDate, boolean fAR) throws BOSException {
        Connection con = null;
        Statement stmt = null;
        try {
            ArApQueryParam param = new ArApQueryParam(){
                private static final long serialVersionUID = 1L;

                public String getRptPreferenceSchemaKey() {
                    return null;
                }

                public IReportHead getReportHead() {
                    return null;
                }

                public List getReportFields() {
                    return null;
                }
            };
            param.setIncludeBizBill(false);
            param.setBizeCheckBox(false);
            con = EJBFactory.getConnection((Context)ctx);
            stmt = con.createStatement();
            stmt.addBatch(this.getArUnionSql1(tmpTable, comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR, param));
            stmt.addBatch(this.getArUnionSql2(tmpTable, comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR, param));
            stmt.addBatch(this.getArUnionSql3(tmpTable, comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR, param));
            stmt.executeBatch();
            try {
                TempTablePool.getInstance((Context)ctx).analyzeTable(con, tmpTable);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)con);
    }

    private String getArUnionSql1(String tmpTable, String comCurrPeriodsTbl, String custRange, boolean hasEndDate, String sEndNxtDate, boolean fAR, ArApQueryParam param) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ").append(tmpTable).append("(FCompanyId,FCustomerId,FBizCodeId,FDebit,FCredit,FBalance)");
        sql.append(new CaItemArBillSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR, param));
        sql.append(new CaItemArBillSql().setExcludeBizBill());
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemRecBillSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR, param));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemBadAcctSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR, param));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemBadRecASql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR, param));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemBadRec_BadSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR, param));
        return sql.toString();
    }

    private String getArUnionSql1(String apBalanceTable, String compPeriodTbl, String cussAcctTbl, RptParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ").append(apBalanceTable).append("(fid,FCompanyORGUnitID,FSupplierID,FDebit,FApBalance,FBalance)");
        sql.append(new CaItemArBillSql().getCompCustsQuerySql1(params, compPeriodTbl, cussAcctTbl, true));
        sql.append(new CaItemArBillSql().setExcludeBizBill());
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemRecBillSql().getCompCustsQuerySql1(params, compPeriodTbl, cussAcctTbl, true));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemBadAcctSql().getCompCustsQuerySql1(params, compPeriodTbl, cussAcctTbl, true));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemBadRecASql().getCompCustsQuerySql1(params, compPeriodTbl, cussAcctTbl, true));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemBadRec_BadSql().getCompCustsQuerySql1(params, compPeriodTbl, cussAcctTbl, true));
        return sql.toString();
    }

    private String getArUnionSql2(String tmpTable, String comCurrPeriodsTbl, String custRange, boolean hasEndDate, String sEndNxtDate, boolean fAR, ArApQueryParam param) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ").append(tmpTable).append("(FCompanyId,FCustomerId,FBizCodeId,FDebit,FCredit,FBalance)");
        sql.append(new CaItemBadRec_RecSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR, param));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemArVRec_ArVApSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR, param));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemArVRec_RecSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR, param));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemArPreRecVPrePay_RecVPaySql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR, param));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemApVAr_ArSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR, param));
        return sql.toString();
    }

    private String getArUnionSql2(String apBalanceTable, String compPeriodTbl, String cussAcctTbl, RptParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ").append(apBalanceTable).append("(fid,FCompanyORGUnitID,FSupplierID,FDebit,FApBalance,FBalance)");
        sql.append(new CaItemBadRec_RecSql().getCompCustsQuerySql1(params, compPeriodTbl, cussAcctTbl, true));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemArVRec_ArVApSql().getCompCustsQuerySql1(params, compPeriodTbl, cussAcctTbl, true));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemArVRec_RecSql().getCompCustsQuerySql1(params, compPeriodTbl, cussAcctTbl, true));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemArPreRecVPrePay_RecVPaySql().getCompCustsQuerySql1(params, compPeriodTbl, cussAcctTbl, true));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemApVAr_ArSql().getCompCustsQuerySql1(params, compPeriodTbl, cussAcctTbl, true));
        return sql.toString();
    }

    private String getArUnionSql3(String tmpTable, String comCurrPeriodsTbl, String custRange, boolean hasEndDate, String sEndNxtDate, boolean fAR, ArApQueryParam param) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ").append(tmpTable).append("(FCompanyId,FCustomerId,FBizCodeId,FDebit,FCredit,FBalance)");
        sql.append(new CaItemArPrePayVPreRec_PayVRecSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR, param));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemArTransSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR, param));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemRecTransSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR, param));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemAr2PrepayTransSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR, param));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemRec2ApTransSql().getCompCustsQuerySql(comCurrPeriodsTbl, custRange, hasEndDate, sEndNxtDate, fAR, param));
        return sql.toString();
    }

    private String getArUnionSql3(String apBalanceTable, String compPeriodTbl, String cussAcctTbl, RptParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ").append(apBalanceTable).append("(fid,FCompanyORGUnitID,FSupplierID,FDebit,FApBalance,FBalance)");
        sql.append(new CaItemArPrePayVPreRec_PayVRecSql().getCompCustsQuerySql1(params, compPeriodTbl, cussAcctTbl, true));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemArTransSql().getCompCustsQuerySql1(params, compPeriodTbl, cussAcctTbl, true));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemRecTransSql().getCompCustsQuerySql1(params, compPeriodTbl, cussAcctTbl, true));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemAr2PrepayTransSql().getCompCustsQuerySql1(params, compPeriodTbl, cussAcctTbl, true));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemRec2ApTransSql().getCompCustsQuerySql1(params, compPeriodTbl, cussAcctTbl, true));
        return sql.toString();
    }

    @Override
    protected void _getApBalance(Context ctx, String apBalanceTable, RptParams params) throws BOSException, EASBizException {
        String compPeriodTbl = this.getCompanyPeriodTbl(ctx, params);
        String cussAcctTbl = null;
        try {
            cussAcctTbl = ArSysFacadeControllerBean.getCussAcctTempTbl(ctx, params);
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        Statement pstmt = null;
        try {
            con = this.getConnection(ctx);
            stmt = con.createStatement();
            StringBuffer insPrefix = new StringBuffer();
            insPrefix.append("insert into ").append(apBalanceTable);
            insPrefix.append(" (fid,FCompanyORGUnitID, FSupplierID, FDebit, ");
            insPrefix.append(" FApBalance, FBalance) \r\n");
            StringBuffer sql = new StringBuffer();
            sql.append(insPrefix);
            sql.append(this.customersBalSql(compPeriodTbl, cussAcctTbl, params));
            logger.debug((Object)("compCust customers Bal sql 0:\r\n" + sql));
            stmt.execute(sql.toString());
            this.compCustsBizArSqlNew1(ctx, params, apBalanceTable, compPeriodTbl, cussAcctTbl);
            logger.debug((Object)("compCust customers Bal sql 0ar:\r\n" + sql));
            sql.delete(0, sql.length());
            sql.append("insert into ").append(apBalanceTable);
            sql.append(" (fid,FCompanyORGUnitID, FSupplierID, FDebit, ");
            sql.append(" FApBalance, FBalance, FIsFinal) \r\n");
            sql.append("  select newbosid('88888888') FID, tBiz.FCompanyORGUnitID FCompanyORGUnitID, ");
            sql.append(" tBiz.FSupplierID FSupplierID, ");
            sql.append("0 FDebit, ");
            sql.append("sum(tBiz.FApBalance)-sum(tBiz.FDebit)");
            sql.append(" FApBalance, sum(tBiz.FBalance) FBalance ,2 FIsFinal from\r\n  ");
            sql.append(apBalanceTable);
            sql.append("\r\n   tBiz group by tBiz.FCompanyORGUnitID, tBiz.FSupplierID");
            logger.debug((Object)("compCust customers sumBal sql 0ar:\r\n" + sql));
            stmt.execute(sql.toString());
            sql.delete(0, sql.length());
            sql.append("delete ").append(apBalanceTable);
            sql.append(" where FIsFinal = 0");
            logger.debug((Object)("compCust customers delTemp sql:\r\n" + sql));
            stmt.execute(sql.toString());
            sql.delete(0, sql.length());
            sql.append(insPrefix);
            sql.append(this.compSuppliersBizApSql(params, compPeriodTbl, cussAcctTbl));
            logger.debug((Object)("compCust customers Bal sql 0ap:\r\n" + sql));
            stmt.execute(sql.toString());
            sql.delete(0, sql.length());
            sql.append("insert  into ").append(apBalanceTable);
            sql.append(" (fid,FCompanyORGUnitID, FSupplierID, FDebit, ");
            sql.append(" FApBalance, FBalance, FIsFinal) \r\n");
            sql.append(" select newbosid('88888888'),FCompanyORGUnitID, FSupplierID, sum(FDebit) FDebit,");
            sql.append(" sum(FApBalance) FApBalance, sum(FBalance) ");
            sql.append(" FBalance, 1 FIsFinal \r\n from ").append(apBalanceTable);
            sql.append(" group by FCompanyORGUnitID, FSupplierID");
            logger.debug((Object)("compCust customers sumBal sql:\r\n" + sql));
            stmt.execute(sql.toString());
            sql.delete(0, sql.length());
            sql.append("delete ").append(apBalanceTable);
            sql.append(" where FIsFinal = 0 or FIsFinal = 2");
            logger.debug((Object)("compCust customers delTemp sql:\r\n" + sql));
            stmt.execute(sql.toString());
        }
        catch (SQLException e) {
            logger.error((Object)"prepareArCreditBal execute sql exception. ", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(pstmt);
            SQLUtils.cleanup(rs, (Statement)stmt, (Connection)con);
        }
        TempTableUtil.releasTempTable(ctx, compPeriodTbl);
    }

    private void compCustsBizArSqlNew1(Context ctx, RptParams params, String apBalanceTable, String compPeriodTbl, String cussAcctTbl) throws BOSException {
        Connection con = null;
        Statement stmt = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            stmt = con.createStatement();
            stmt.addBatch(this.getArUnionSql1(apBalanceTable, compPeriodTbl, cussAcctTbl, params));
            stmt.addBatch(this.getArUnionSql2(apBalanceTable, compPeriodTbl, cussAcctTbl, params));
            stmt.addBatch(this.getArUnionSql3(apBalanceTable, compPeriodTbl, cussAcctTbl, params));
            stmt.executeBatch();
            TempTablePool.getInstance((Context)ctx).analyzeTable(con, apBalanceTable);
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)con);
    }

    private String compSuppliersBizApSql(RptParams params, String compPeriodTbl, String cussAcctTbl) {
        StringBuffer sql = new StringBuffer();
        sql.append("  select newbosid('88888888') FID, tBiz.FCompanyId FCompanyId, ");
        sql.append(" tBiz.FCustomerId FCustomerId, ");
        sql.append("0 FDebit, ");
        sql.append("sum(tBiz.FCredit)-sum(tBiz.FDebit)");
        sql.append(" FCredit, sum(tBiz.FAmt) FBalance from\r\n  (");
        sql.append(new CaItemApBillSql().getCompCustsQuerySql1(params, compPeriodTbl, cussAcctTbl, true));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemPayBillSql().getCompCustsQuerySql1(params, compPeriodTbl, cussAcctTbl, true));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemApVPay_ApVArSql().getCompCustsQuerySql1(params, compPeriodTbl, cussAcctTbl, true));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemApApVPay_PaySql().getCompCustsQuerySql1(params, compPeriodTbl, cussAcctTbl, true));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemApPrePayVPreRec_PayVRecSql().getCompCustsQuerySql1(params, compPeriodTbl, cussAcctTbl, true));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemApArVAp_ApSql().getCompCustsQuerySql1(params, compPeriodTbl, cussAcctTbl, true));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemApPreRecVPrePay_RecVPaySql().getCompCustsQuerySql1(params, compPeriodTbl, cussAcctTbl, true));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemApTransSql().getCompCustsQuerySql1(params, compPeriodTbl, cussAcctTbl, true));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemPayTransSql().getCompCustsQuerySql1(params, compPeriodTbl, cussAcctTbl, true));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemAp2PrerecTransSql().getCompCustsQuerySql1(params, compPeriodTbl, cussAcctTbl, true));
        sql.append("\r\n union all \r\n");
        sql.append(new CaItemPay2ArTransSql().getCompCustsQuerySql1(params, compPeriodTbl, cussAcctTbl, true));
        sql.append("\r\n  ) tBiz group by tBiz.FCompanyId, tBiz.FCustomerId");
        return sql.toString();
    }

    private String customersBalSql(String comCurrPeriodsTbl, String cussAcctTbl, RptParams params) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select newbosid('88888888'),tSum.FCompanyId FCompanyId, tSum.FCustomerId ");
        sql.append("FCustomerId, sum(tSum.FDebit) FDebit,");
        sql.append(" sum(tSum.FCredit) FCredit,");
        sql.append(" sum(tSum.FBalance) FBalance from \r\n(");
        sql.append("  select t1.FCompanyId FCompanyId, ");
        sql.append("t1.FAsstActId FCustomerId, ");
        sql.append(" sum(t1.FBeginBalanceLocal) FDebit, 0 FCredit,");
        sql.append(" sum(t1.FBeginBalanceLocal) FBalance\r\n from ");
        sql.append("t_ar_arBalance");
        sql.append(" t1\r\n inner join ").append(comCurrPeriodsTbl);
        sql.append(" t2 on t1.FCompanyId = t2.FCompanyId and ");
        sql.append(" t1.FPeriodId = t2.FCurrentPeriodId \r\n");
        sql.append(" inner join ").append(cussAcctTbl);
        sql.append(" supplier on t1.FAsstActId = supplier.fid ");
        sql.append("  where t1.FBalType IN (").append(101);
        sql.append(", 104").append(")");
        sql.append("\r\n    group by t1.FCompanyId, t1.FAsstActId");
        sql.append("\r\n  union all \r\n");
        sql.append("  select t1.FCompanyId FCompanyId, ");
        sql.append("  t1.FAsstActId FCustomerId, ");
        sql.append(" 0 FDebit, sum(t1.FBeginBalanceLocal) FCredit,");
        sql.append(" 0-sum(t1.FBeginBalanceLocal) FBalance\r\n from ");
        sql.append("t_ap_apBalance");
        sql.append(" t1\r\n inner join ").append(comCurrPeriodsTbl);
        sql.append(" t2 on t1.FCompanyId = t2.FCompanyId and ");
        sql.append(" t1.FPeriodId = t2.FCurrentPeriodId\r\n ");
        sql.append(" inner join ").append(cussAcctTbl);
        sql.append(" supplier on t1.FAsstActId = supplier.fid ");
        sql.append(" where t1.FBalType = ").append(101);
        sql.append("\r\n    group by t1.FCompanyId, t1.FAsstActId");
        sql.append("\r\n) tSum group by tSum.FCompanyId, tSum.FCustomerId");
        return sql.toString();
    }

    private static FilterItemInfo getCsspGrpBasicStdFilter(Context ctx) throws BOSException, EASBizException {
        FilterItemInfo csspGrpStdFilter = null;
        String cussSupType = "2";
        try {
            ICSSPGroupStandard icssStandard = CSSPGroupStandardFactory.getLocalInstance((Context)ctx);
            String standardId = icssStandard.getBasicStandardId(cussSupType);
            String field = "browseGroup.groupStandard";
            csspGrpStdFilter = new FilterItemInfo(field, (Object)standardId);
            return csspGrpStdFilter;
        }
        catch (Exception e) {
            logger.error((Object)"error while getting the cssp group standard", (Throwable)e);
            return null;
        }
    }

    public static String getCussAcctTempTbl(Context ctx, RptParams param) throws BOSException, EASBizException, SQLException {
        String orgTableName = param.getString("CompanyTempTable");
        StringBuffer sb = new StringBuffer("");
        sb.append("SELECT fid FROM ").append(orgTableName);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        ArrayList<String> companyOrgUnitIDList = new ArrayList<String>();
        String companyOrgUnitID = null;
        while (rs.next()) {
            companyOrgUnitID = rs.getString("fid");
            companyOrgUnitIDList.add(companyOrgUnitID);
        }
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        StringBuffer oql = new StringBuffer();
        oql.append("select id, cu.id where id in (");
        int n = companyOrgUnitIDList.size();
        for (int m = 0; m < n; ++m) {
            if (m > 0) {
                oql.append(",");
            }
            oql.append("'").append(companyOrgUnitIDList.get(m).toString()).append("'");
        }
        oql.append(")");
        CompanyOrgUnitCollection comps = iCompanyOrgUnit.getCompanyOrgUnitCollection(oql.toString());
        String tmpTblDefine = " (FId varchar(44), FNumber nvarchar(80), FName nvarchar(400), FIsFinal int default 0) ";
        String cussAcctTbl = TempTableUtil.createTempTable(ctx, tmpTblDefine);
        TempTablePool tmpTblPool = TempTablePool.getInstance((Context)ctx);
        try {
            tmpTblPool.createIndex(cussAcctTbl, "FId", false, false);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        Connection con = null;
        Statement stmt = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            stmt = con.createStatement();
            String insSql = "insert into " + cussAcctTbl + " (FId, FName, FNumber) \r\n";
            String sql = null;
            int n2 = comps.size();
            for (int i = 0; i < n2; ++i) {
                CompanyOrgUnitInfo compInfo = comps.get(i);
                sql = insSql + ArSysFacadeControllerBean.getCussObjsSql(ctx, param, cussAcctTbl, compInfo.getId().toString(), compInfo.getCU().getId().toString());
                logger.debug((Object)("init CussAcct:\r\n" + sql));
                DbUtil.execute((Context)ctx, (String)sql);
            }
            StringBuffer distinctSql = new StringBuffer();
            distinctSql.append("insert into ").append(cussAcctTbl);
            distinctSql.append(" (FId, FName, FNumber, FIsFinal) \r\n");
            distinctSql.append("select distinct FId, FNumber || N' ' || ");
            distinctSql.append("case when FName is null then N' ' else FName end as FName");
            distinctSql.append(", FNumber, 2 FIsFinal from ").append(cussAcctTbl);
            DbUtil.execute((Context)ctx, (String)distinctSql.toString());
            distinctSql.delete(0, distinctSql.length());
            distinctSql.append("delete ").append(cussAcctTbl);
            distinctSql.append(" where FIsFinal = 0");
            DbUtil.execute((Context)ctx, (String)distinctSql.toString());
            try {
                tmpTblPool.analyzeTable(con, cussAcctTbl);
            }
            catch (Exception e1) {
                e1.printStackTrace(System.out);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"query the companys cussAcct.", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)con);
        return cussAcctTbl;
    }

    public static String getCussObjsSql(Context ctx, RptParams params, String cussAcctTbl, String companyID, String cuID) throws BOSException, EASBizException {
        String qryName = "com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyQuery";
        MetaDataPK cussQryPK = MetaDataPK.create((String)qryName);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)cussQryPK);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("id");
        view.getSelector().add("name");
        view.getSelector().add("number");
        FilterInfo filter = null;
        filter = ArSysFacadeControllerBean.getNumRangeFilterItem(params.getObject("SupplierFrom"), params.getString("SupplierTo"));
        ObjectUuidPK cuPK = new ObjectUuidPK(cuID);
        FilterInfo comFilter = new FilterInfo();
        String fldCompany = "companyOrgUnit.id";
        comFilter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(0), CompareType.GREATER));
        FilterItemInfo item = new FilterItemInfo(fldCompany, (Object)companyID);
        comFilter.getFilterItems().add(item);
        FilterItemInfo csspGrpStdFilter = null;
        csspGrpStdFilter = ArSysFacadeControllerBean.getCsspGrpBasicStdFilter(ctx);
        if (csspGrpStdFilter != null) {
            comFilter.getFilterItems().add(csspGrpStdFilter);
        }
        ISupplier iSupp = SupplierFactory.getLocalInstance((Context)ctx);
        FilterInfo cuFilter = iSupp.getDatabaseDFilter((IObjectPK)cuPK, "id", "adminCU.id");
        comFilter.mergeFilter(cuFilter, "and");
        if (filter != null && comFilter != null) {
            try {
                filter.mergeFilter(comFilter, "and");
            }
            catch (BOSException e) {
                logger.error((Object)"filter merge exception", (Throwable)e);
            }
        } else if (filter == null && comFilter != null) {
            filter = comFilter;
        }
        if (filter == null) {
            filter = new FilterInfo();
        }
        view.setFilter(filter);
        exec.setObjectView(view);
        StringBuffer sql = new StringBuffer();
        sql.append(exec.getSQL());
        return sql.toString();
    }

    protected static FilterInfo getNumRangeFilterItem(Object cussFromNum, String cussToNum) {
        FilterInfo filter = null;
        if (cussFromNum != null) {
            String number = null;
            HashSet<String> numberSet = new HashSet<String>();
            if (cussFromNum instanceof Object[]) {
                Object[] cussArray = (Object[])cussFromNum;
                for (int i = 0; i < cussArray.length; ++i) {
                    numberSet.add(((IObjectValue)cussArray[i]).getString("number"));
                }
            } else if (cussFromNum instanceof IObjectValue) {
                number = ((IObjectValue)cussFromNum).getString("number");
            } else if (!StringUtils.isEmpty((String)cussFromNum.toString())) {
                number = cussFromNum.toString();
            }
            filter = new FilterInfo();
            if (number != null) {
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.GREATER_EQUALS));
            } else if (numberSet.size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("number", numberSet, CompareType.INCLUDE));
            }
        }
        if (!StringUtils.isEmpty((String)cussToNum)) {
            filter = filter == null ? new FilterInfo() : filter;
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)cussToNum, CompareType.LESS_EQUALS));
        }
        return filter;
    }
}

