/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.json.Kson;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamItem;
import com.kingdee.eas.base.param.ParamInfo;
import com.kingdee.eas.base.param.ParamItemFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.ARAccountAnalysisParamsCollection;
import com.kingdee.eas.fi.ap.ARAccountAnalysisParamsFactory;
import com.kingdee.eas.fi.ap.ARAccountAnalysisParamsInfo;
import com.kingdee.eas.fi.ap.ARSaleIncomeParamCollection;
import com.kingdee.eas.fi.ap.ARSaleIncomeParamFactory;
import com.kingdee.eas.fi.ap.ARSaleIncomeParamInfo;
import com.kingdee.eas.fi.ap.ApOtherParamsCollection;
import com.kingdee.eas.fi.ap.ApOtherParamsFactory;
import com.kingdee.eas.fi.ap.ApOtherParamsInfo;
import com.kingdee.eas.fi.ap.IARAccountAnalysisParams;
import com.kingdee.eas.fi.ap.IARSaleIncomeParam;
import com.kingdee.eas.fi.ap.IApOtherParams;
import com.kingdee.eas.fi.ar.AccountBadDebtException;
import com.kingdee.eas.fi.ar.app.AbstractBadAccountFacadeControllerBean;
import com.kingdee.eas.fi.arap.ArApConstants;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.common.security.util.SCMSqlUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BadAccountFacadeControllerBean
extends AbstractBadAccountFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ar.app.BadAccountFacadeControllerBean");
    public static final String CRTL = "\n\r";

    @Override
    protected HashMap _getParams(Context ctx, IObjectValue company) throws BOSException, EASBizException {
        String lang = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuilder sql = new StringBuilder(300);
        sql.append(" select param.fid paramid,param.fnumber fnumber,");
        sql.append(" param.FDefaultVal").append("_").append(lang);
        sql.append(" as defaultvalue,item.fid itemid,");
        sql.append(" item.fvalue").append("_").append(lang);
        sql.append(" as fvalue, item.forgunitid orgunitid,");
        sql.append(" item.fiscontrolsub iscontrolsub,item.fismodify ismodify ");
        sql.append(" from t_bas_param param left join t_bas_paramitem item on param.fid=item.fkeyid ");
        sql.append(" and item.forgunitid = ? ");
        sql.append(" where param.fsubsysid = ? and param.fnumber like 'arap00%'");
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashMap<String, ParamItemInfo> prop = new HashMap<String, ParamItemInfo>();
        try {
            con = this.getConnection(ctx);
            ps = con.prepareStatement(sql.toString());
            ps.setString(1, company.get(company.getPKField()).toString());
            ps.setString(2, this.getSubSysId());
            rs = ps.executeQuery();
            while (rs.next()) {
                ParamItemInfo info = new ParamItemInfo();
                String id = rs.getString("itemid");
                String value = null;
                if (id != null) {
                    info.setId(BOSUuid.read((String)id));
                    value = rs.getString("fvalue");
                } else {
                    value = rs.getString("defaultvalue");
                }
                info.setValue(value);
                ParamInfo paraminfo = new ParamInfo();
                paraminfo.setId(BOSUuid.read((String)rs.getString("paramid")));
                String number = rs.getString("fnumber");
                paraminfo.setNumber(number);
                info.setKeyID(paraminfo);
                prop.put(number, info);
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return prop;
    }

    @Override
    protected boolean _saveParams(Context ctx, HashMap params, HashMap newParams) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)newParams.get("COMPANY");
        IParamItem paramItemCtrl = ParamItemFactory.getLocalInstance((Context)ctx);
        for (ParamItemInfo info : params.values()) {
            info.setValue(info.getValue(), ArApConstants.L1);
            info.setValue(info.getValue(), ArApConstants.L2);
            info.setValue(info.getValue(), ArApConstants.L3);
            ParamInfo paramInfo = info.getKeyID();
            if (info.getValue() == null) {
                paramInfo.setDefaultValue("true", ArApConstants.L1);
                paramInfo.setDefaultValue("true", ArApConstants.L2);
                paramInfo.setDefaultValue("true", ArApConstants.L3);
            } else {
                paramInfo.setDefaultValue(info.getValue(), ArApConstants.L1);
                paramInfo.setDefaultValue(info.getValue(), ArApConstants.L2);
                paramInfo.setDefaultValue(info.getValue(), ArApConstants.L3);
            }
            if (info.getId() != null) {
                this.update(ctx, (IObjectPK)new ObjectUuidPK(info.getId().toString()), info);
                continue;
            }
            info.setIsControlSub(false);
            info.setIsModify(false);
            info.setOrgUnitID((OrgUnitInfo)company);
            paramItemCtrl.addnewNoVerify(info, info.getKeyID());
        }
        return true;
    }

    private void update(Context ctx, IObjectPK pk, ParamItemInfo model) throws BOSException, EASBizException {
        Connection con = null;
        PreparedStatement ps = null;
        StringBuilder sql = new StringBuilder(200);
        sql.append("update t_bas_paramItem set ");
        sql.append(" fvalue_L1").append(" = ?,");
        sql.append(" fvalue_L2").append(" = ?,");
        sql.append(" fvalue_L3").append(" = ?");
        sql.append(" where fid=?");
        try {
            con = this.getConnection(ctx);
            ps = con.prepareStatement(sql.toString());
            ps.setString(1, model.getValue());
            ps.setString(2, model.getValue());
            ps.setString(3, model.getValue());
            ps.setString(4, model.getId().toString());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)con);
    }

    private String getSubSysId() {
        return "com.kingdee.eas.fi.ar.ar";
    }

    @Override
    protected String _getAccuralParam(Context ctx, IObjectValue company) throws BOSException, EASBizException {
        HashMap paramMap = this._getParams(ctx, company);
        for (String key : paramMap.keySet()) {
            String value = ((ParamItemInfo)paramMap.get(key)).getValue();
            if (value == null || !key.equalsIgnoreCase("arap003")) continue;
            return value;
        }
        return "";
    }

    @Override
    protected boolean _isDerectorTransferCancelMethod(Context ctx, IObjectValue company) throws BOSException, EASBizException {
        HashMap paramMap = this._getParams(ctx, company);
        for (String key : paramMap.keySet()) {
            String value = ((ParamItemInfo)paramMap.get(key)).getValue();
            if (value == null) {
                return false;
            }
            if (!key.equalsIgnoreCase("arap001")) continue;
            return value.equalsIgnoreCase(String.valueOf(2));
        }
        return false;
    }

    @Override
    protected boolean _isSetAccurralParam(Context ctx, IObjectValue company) throws BOSException, EASBizException {
        HashMap paramMap = this._getParams(ctx, company);
        for (String key : paramMap.keySet()) {
            String value = ((ParamItemInfo)paramMap.get(key)).getValue();
            if (!key.equalsIgnoreCase("arap001")) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean _isDisplayLocalCurrency(Context ctx) throws BOSException, EASBizException {
        String value = ParamManager.getSpecialParamValue((Context)ctx, (String)"DISPLAY_LOCAL_CURRENCY");
        if (value != null) {
            value = value.trim();
        }
        return "true".equalsIgnoreCase(value);
    }

    public CompanyOrgUnitCollection filterCompanyCollForAssign(Context ctx, String currentCompanyId, CompanyOrgUnitCollection companyColl) throws BOSException, EASBizException {
        CompanyOrgUnitCollection filterColl = this.filterCompanyColl(ctx, companyColl);
        if (null != filterColl && filterColl.size() > 0) {
            StringBuilder buf = new StringBuilder(500).append(currentCompanyId).append(",");
            HashMap<String, CompanyOrgUnitInfo> filterCompanyMap = new HashMap<String, CompanyOrgUnitInfo>(filterColl.size());
            for (int i = 0; i < filterColl.size(); ++i) {
                String companyId = filterColl.get(i).getId().toString();
                buf.append(companyId);
                if (i != filterColl.size() - 1) {
                    buf.append(",");
                }
                filterCompanyMap.put(companyId, filterColl.get(i));
            }
            List filterOrgParams = this._getOrgAccuralMethod(ctx, buf.toString(), null);
            if (null != filterOrgParams && filterOrgParams.size() > 0) {
                int i;
                OrgAccuralParam currentOrgParam = null;
                for (i = 0; i < filterOrgParams.size(); ++i) {
                    if (!currentCompanyId.equals(((OrgAccuralParam)filterOrgParams.get(i)).getCompanyId())) continue;
                    currentOrgParam = (OrgAccuralParam)filterOrgParams.get(i);
                    filterOrgParams.remove(i);
                    break;
                }
                if (null != currentOrgParam) {
                    for (i = 0; i < filterOrgParams.size(); ++i) {
                        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)filterCompanyMap.get(((OrgAccuralParam)filterOrgParams.get(i)).getCompanyId());
                        if (!currentOrgParam.getAccuralMethod().equals(((OrgAccuralParam)filterOrgParams.get(i)).getAccuralMethod())) continue;
                        filterColl.remove(company);
                        companyColl.add(company);
                    }
                }
            }
            if (filterCompanyMap.containsKey(currentCompanyId)) {
                CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)filterCompanyMap.get(currentCompanyId);
                filterColl.remove(company);
                companyColl.remove(company);
            }
        }
        return filterColl;
    }

    public static String getArResource(String key) {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArResource", (String)key, (Locale)ContextUtils.getOriginalLocaleFromEnv());
    }

    public static String getArResources(String key) {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)key, (Locale)ContextUtils.getOriginalLocaleFromEnv());
    }

    @Override
    protected String _batchUpdateParams(Context ctx, IObjectValue currentCompany, IObjectCollection selectCompany) throws BOSException, EASBizException {
        BatchResult result = new BatchResult(BadAccountFacadeControllerBean.getArResource("all_assign_success"));
        if (null == currentCompany || null == selectCompany || selectCompany.size() == 0) {
            return result.toString();
        }
        CompanyOrgUnitInfo currCompany = (CompanyOrgUnitInfo)currentCompany;
        CompanyOrgUnitCollection companyColl = (CompanyOrgUnitCollection)selectCompany;
        result.setTotalCount(companyColl.size());
        String currentCompanyId = currCompany.getId().toString();
        CompanyOrgUnitCollection filterColl = this.filterCompanyCollForAssign(ctx, currentCompanyId, companyColl);
        if (null != filterColl && filterColl.size() > 0) {
            result.setSumaryTemplate(BadAccountFacadeControllerBean.getArResource("assign_sumaryTemplate"));
            result.setErrorCount(filterColl.size());
            ArrayList<String> detailMesgs = new ArrayList<String>(filterColl.size());
            result.setDetailMesgs(detailMesgs);
            for (int i = 0; i < filterColl.size(); ++i) {
                AccountBadDebtException excp = this.getAccountBadDebtExceptionWithOrg(AccountBadDebtException.NOT_ALLOWED_ASSIGN, filterColl.get(i), currCompany);
                if (null == excp) continue;
                detailMesgs.add(excp.getMessage());
            }
        }
        if (companyColl.size() == 0) {
            return result.toString();
        }
        result.setSuccessCount(companyColl.size());
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("company", (Object)currentCompanyId);
        view.setFilter(filter);
        IApOtherParams iApOtherParams = ApOtherParamsFactory.getLocalInstance(ctx);
        IARAccountAnalysisParams iARAccountAnalysisParams = ARAccountAnalysisParamsFactory.getLocalInstance(ctx);
        IARSaleIncomeParam iARSaleIncomeParam = ARSaleIncomeParamFactory.getLocalInstance(ctx);
        ApOtherParamsCollection apOtherParamsColl = iApOtherParams.getApOtherParamsCollection(view);
        ARAccountAnalysisParamsCollection arAccountAnalysisParamsColl = iARAccountAnalysisParams.getARAccountAnalysisParamsCollection(view);
        ARSaleIncomeParamCollection arSaleIncomeParamColl = iARSaleIncomeParam.getARSaleIncomeParamCollection(view);
        HashMap params = this._getParams(ctx, currentCompany);
        HashMap company = new HashMap();
        IParamItem paramItemCtrl = ParamItemFactory.getLocalInstance((Context)ctx);
        ParamItemInfo updateParam = new ParamItemInfo();
        for (int i = 0; i < selectCompany.size(); ++i) {
            BOSUuid companyId = companyColl.get(i).getId();
            HashMap newParams = this._getParams(ctx, (IObjectValue)companyColl.get(i));
            for (Map.Entry entry : params.entrySet()) {
                ParamItemInfo info = (ParamItemInfo)entry.getValue();
                updateParam = (ParamItemInfo)newParams.get(entry.getKey());
                info.setId(updateParam.getId());
                if (updateParam != null && updateParam.getId() != null) {
                    this.update(ctx, (IObjectPK)new ObjectUuidPK(updateParam.getId()), info);
                    continue;
                }
                info.setIsControlSub(false);
                info.setIsModify(false);
                info.setOrgUnitID((OrgUnitInfo)companyColl.get(i));
                paramItemCtrl.addnewNoVerify(info, updateParam.getKeyID());
            }
            filter.getFilterItems().clear();
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)companyId, CompareType.EQUALS));
            view.setFilter(filter);
            ApOtherParamsCollection newapOtherParamsColl = iApOtherParams.getApOtherParamsCollection(view);
            ARAccountAnalysisParamsCollection newarAccountAnalysisParamsColl = iARAccountAnalysisParams.getARAccountAnalysisParamsCollection(view);
            ARSaleIncomeParamCollection newarSaleIncomeParamColl = iARSaleIncomeParam.getARSaleIncomeParamCollection(view);
            newParams = this._getParams(ctx, (IObjectValue)companyColl.get(i));
            ObjectUuidPK[] newapOtherParams = new ObjectUuidPK[newapOtherParamsColl.size()];
            for (int j = 0; j < newapOtherParamsColl.size(); ++j) {
                newapOtherParams[j] = new ObjectUuidPK(newapOtherParamsColl.get(j).getId());
            }
            iApOtherParams.deleteBatchData((IObjectPK[])newapOtherParams);
            CoreBaseCollection coll = new CoreBaseCollection();
            for (int j = 0; j < apOtherParamsColl.size(); ++j) {
                ApOtherParamsInfo apOtherParamsInfo = apOtherParamsColl.get(j);
                apOtherParamsInfo.setId(null);
                apOtherParamsInfo.setCompany(companyId);
                apOtherParamsInfo.setArOtherParam((ParamItemInfo)newParams.get("arap003"));
                coll.add((CoreBaseInfo)apOtherParamsInfo);
            }
            iApOtherParams.addnewBatchData(coll);
            ObjectUuidPK[] newarAccountAnalysisParams = new ObjectUuidPK[newarAccountAnalysisParamsColl.size()];
            for (int j = 0; j < newarAccountAnalysisParamsColl.size(); ++j) {
                newarAccountAnalysisParams[j] = new ObjectUuidPK(newarAccountAnalysisParamsColl.get(j).getId());
            }
            iARAccountAnalysisParams.deleteBatchData((IObjectPK[])newarAccountAnalysisParams);
            coll.clear();
            for (int j = 0; j < arAccountAnalysisParamsColl.size(); ++j) {
                ARAccountAnalysisParamsInfo arAccountAnalysisParamsInfo = arAccountAnalysisParamsColl.get(j);
                arAccountAnalysisParamsInfo.setId(null);
                arAccountAnalysisParamsInfo.setCompany(companyId);
                arAccountAnalysisParamsInfo.setArOtherParam((ParamItemInfo)newParams.get("arap003"));
                coll.add((CoreBaseInfo)arAccountAnalysisParamsInfo);
            }
            iARAccountAnalysisParams.addnewBatchData(coll);
            ObjectUuidPK[] newarSaleIncomeParam = new ObjectUuidPK[newarSaleIncomeParamColl.size()];
            for (int j = 0; j < newarSaleIncomeParamColl.size(); ++j) {
                newarSaleIncomeParam[j] = new ObjectUuidPK(newarSaleIncomeParamColl.get(j).getId());
            }
            iARSaleIncomeParam.deleteBatchData((IObjectPK[])newarSaleIncomeParam);
            coll.clear();
            for (int j = 0; j < arSaleIncomeParamColl.size(); ++j) {
                ARSaleIncomeParamInfo arSaleIncomeParamInfo = arSaleIncomeParamColl.get(j);
                arSaleIncomeParamInfo.setId(null);
                arSaleIncomeParamInfo.setCompany(companyId.toString());
                arSaleIncomeParamInfo.setArOtherParam((ParamItemInfo)newParams.get("arap003"));
                coll.add((CoreBaseInfo)arSaleIncomeParamInfo);
            }
            iARSaleIncomeParam.addnewBatchData(coll);
        }
        return result.toString();
    }

    private StringBuilder getSQLByAccuralMethod(Context ctx, String accuralMethod) {
        String lang = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuilder buf = new StringBuilder(600).append(" SELECT V01.COMPANYID companyId, V01.FNUMBER fnumber, V01.FVALUE_").append(lang).append(" fvalue,").append(CRTL).append(" ORG.FNAME_").append(lang).append(" as companyName, ORG.FNUMBER companyNumber").append(CRTL).append(" FROM V_AR_BADACCOUNT01 V01").append(CRTL).append(" INNER JOIN T_ORG_BASEUNIT ORG ON V01.COMPANYID = ORG.FID").append(CRTL);
        if (!StringUtils.isEmpty((String)accuralMethod)) {
            int accuralType = Integer.parseInt(accuralMethod);
            if (2 == accuralType) {
                buf.append(" WHERE V01.FNUMBER = '").append("arap001").append("' AND V01.FVALUE_").append(lang).append(" = '").append(accuralType).append("' ").append(CRTL);
            } else {
                buf.append(" WHERE V01.FNUMBER = '").append("arap003").append("' ");
                if (1 == accuralType || 3 == accuralType) {
                    buf.append(" AND V01.FVALUE_").append(lang).append(" = '").append(accuralType).append("' ").append(CRTL);
                }
                if (accuralMethod.startsWith("4")) {
                    accuralType = Integer.parseInt(accuralMethod.substring(1));
                    buf.append(" AND V01.FVALUE_").append(lang).append(" = '").append(accuralType).append("' ").append(CRTL);
                }
                buf.append(" AND ORG.FID IN (SELECT DISTINCT V02.COMPANYID FROM V_AR_BADACCOUNT01 V02 WHERE V02.FNUMBER ='").append("arap001").append("' AND V02.FVALUE_").append(lang).append(" = '").append(1).append("')").append(CRTL);
            }
        } else {
            buf.append(" WHERE V01.FNUMBER in ('").append("arap001").append("', '").append("arap003").append("')").append(CRTL);
        }
        return buf;
    }

    @Override
    public List _getOrgAccuralMethod(Context ctx, String companyIds, String accuralMethod) throws BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        LinkedList<OrgAccuralParam> totalRows;
        String tempTable;
        block26: {
            StringBuilder buf = this.getSQLByAccuralMethod(ctx, accuralMethod);
            if (null == buf || buf.length() == 0) {
                return null;
            }
            tempTable = "";
            SCMSqlUtil.Result result = SCMSqlUtil.convertIds((Context)ctx, (String)companyIds);
            if (SCMSqlUtil.resultTypeEnum.complex.equals((Object)result.getResultType())) {
                buf.append(" AND ORG.FID IN (").append(result.getSelectSQL()).append(")").append(CRTL);
                tempTable = result.getTempTable();
            } else if (SCMSqlUtil.resultTypeEnum.simple.equals((Object)result.getResultType())) {
                buf.append(" AND ORG.FID IN (").append(result.getPlaceholder()).append(")").append(CRTL);
            }
            buf.append(" ORDER BY V01.COMPANYID, V01.FNUMBER").append(CRTL);
            totalRows = new LinkedList<OrgAccuralParam>();
            con = null;
            ps = null;
            rs = null;
            try {
                HashMap<String, OrgAccuralParam> valueMap = new HashMap<String, OrgAccuralParam>(50);
                con = this.getConnection(ctx);
                ps = con.prepareStatement(buf.toString());
                if (SCMSqlUtil.resultTypeEnum.simple.equals((Object)result.getResultType())) {
                    String[] idArr = result.getParameters();
                    for (int i = 0; i < idArr.length; ++i) {
                        ps.setString(i + 1, idArr[i]);
                    }
                }
                rs = ps.executeQuery();
                while (rs.next()) {
                    String companyId = rs.getString("companyId");
                    String number = rs.getString("fnumber");
                    String value = rs.getString("fvalue");
                    String companyName = rs.getString("companyName");
                    String companyNumber = rs.getString("companyNumber");
                    if (StringUtils.isEmpty((String)value) || "true".equals(value) || "false".equals(value)) continue;
                    OrgAccuralParam paramInfo = (OrgAccuralParam)valueMap.get(companyId);
                    if (null == paramInfo) {
                        paramInfo = new OrgAccuralParam();
                        paramInfo.setCompanyId(companyId);
                        paramInfo.setCompanyNumber(companyNumber);
                        paramInfo.setCompanyName(companyName);
                        valueMap.put(companyId, paramInfo);
                    }
                    if ("arap001".equals(number)) {
                        paramInfo.setArap001(value);
                    }
                    if (!"arap003".equals(number)) continue;
                    paramInfo.setArap003(value);
                }
                if (valueMap.size() <= 0) break block26;
                for (String companyId : valueMap.keySet()) {
                    OrgAccuralParam paramInfo = (OrgAccuralParam)valueMap.get(companyId);
                    int arap001 = 0;
                    int arap003 = 0;
                    if (!StringUtils.isEmpty((String)paramInfo.getArap001())) {
                        arap001 = Integer.parseInt(paramInfo.getArap001());
                    }
                    if (!StringUtils.isEmpty((String)paramInfo.getArap003())) {
                        arap003 = Integer.parseInt(paramInfo.getArap003());
                    }
                    if (2 == arap001) {
                        paramInfo.setAccuralMethod(AccuralMethod.ZJZXF);
                    }
                    if (0 == arap001 || 1 == arap001) {
                        if (1 == arap003) {
                            paramInfo.setAccuralMethod(AccuralMethod.BDF_XSBFBF);
                        }
                        if (3 == arap003) {
                            paramInfo.setAccuralMethod(AccuralMethod.BDF_YSZKYEBFBF);
                        }
                        if (2 == arap003) {
                            paramInfo.setAccuralMethod(AccuralMethod.BDF_ZLFXF_HZJT);
                        }
                        if (5 == arap003) {
                            paramInfo.setAccuralMethod(AccuralMethod.BDF_ZLFXF_AKHJT);
                        }
                        if (6 == arap003) {
                            paramInfo.setAccuralMethod(AccuralMethod.BDF_ZLFXF_ADJT);
                        }
                        if (0 == arap003) {
                            paramInfo.setAccuralMethod(AccuralMethod.BDF_EXCP);
                        }
                    }
                    totalRows.add(paramInfo);
                }
            }
            catch (SQLException e) {
                try {
                    throw new SQLAccessException(e);
                }
                catch (Throwable throwable) {
                    if (!StringUtils.isEmpty((String)tempTable)) {
                        SCMSqlUtil.releasTempTable((Context)ctx, (String)tempTable);
                    }
                    SQLUtils.cleanup(rs, ps, (Connection)con);
                    throw throwable;
                }
            }
        }
        if (!StringUtils.isEmpty((String)tempTable)) {
            SCMSqlUtil.releasTempTable((Context)ctx, (String)tempTable);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return totalRows;
    }

    public static String getCompanyInfo(CompanyOrgUnitInfo company) {
        if (null == company) {
            return "";
        }
        return company.getName() + "\uff08" + BadAccountFacadeControllerBean.getArResources("NUMBER") + "\uff1a" + company.getNumber() + "\uff09";
    }

    public CompanyOrgUnitCollection filterCompanyColl(Context ctx, CompanyOrgUnitCollection companyColl) throws BOSException {
        String id;
        if (null == companyColl || companyColl.size() == 0) {
            return null;
        }
        HashMap<String, CompanyOrgUnitInfo> companyMap = new HashMap<String, CompanyOrgUnitInfo>(companyColl.size());
        StringBuilder buf = new StringBuilder(500).append("select distinct FCompanyID from ").append("T_AR_AccountBadDebt where FCompanyID in (");
        for (int i = 0; i < companyColl.size(); ++i) {
            CompanyOrgUnitInfo company = companyColl.get(i);
            if (StringUtils.isEmpty((String)company.getId().toString())) continue;
            id = company.getId().toString();
            buf.append("'").append(id).append("'");
            if (i != companyColl.size() - 1) {
                buf.append(",");
            }
            companyMap.put(id, company);
        }
        buf.append(")");
        CompanyOrgUnitCollection filterColl = new CompanyOrgUnitCollection();
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)buf.toString());
            while (rs.next()) {
                id = rs.getString("FCompanyID");
                CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)companyMap.get(id);
                filterColl.add(company);
                companyColl.remove(company);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (null != rs) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error((Object)"cleanup error", (Throwable)e);
                }
                rs = null;
            }
        }
        return filterColl;
    }

    public IObjectPK[] getDeleteParamItemPKArray(Context ctx, CompanyOrgUnitCollection companyColl) throws BOSException {
        if (null == companyColl || companyColl.size() == 0) {
            return null;
        }
        StringBuilder buf = new StringBuilder(500).append("SELECT DISTINCT FID FROM T_BAS_PARAMITEM ITEM").append(" INNER JOIN V_AR_BADACCOUNT01 V01 ON V01.COMPANYID = ITEM.FORGUNITID AND V01.ITEMID = ITEM.FID").append(" WHERE ITEM.FORGUNITID IN (");
        for (int i = 0; i < companyColl.size(); ++i) {
            CompanyOrgUnitInfo company = companyColl.get(i);
            if (StringUtils.isEmpty((String)company.getId().toString())) continue;
            String id = company.getId().toString();
            buf.append("'").append(id).append("'");
            if (i == companyColl.size() - 1) continue;
            buf.append(",");
        }
        buf.append(")");
        IObjectPK[] pkArr = null;
        ArrayList<ObjectUuidPK> pks = new ArrayList<ObjectUuidPK>(companyColl.size() * 18);
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)buf.toString());
            while (rs.next()) {
                pks.add(new ObjectUuidPK(rs.getString("FID")));
            }
            pkArr = new IObjectPK[pks.size()];
            pks.toArray(pkArr);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (null != rs) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error((Object)"cleanup error", (Throwable)e);
                }
                rs = null;
            }
        }
        return pkArr;
    }

    private AccountBadDebtException getAccountBadDebtExceptionWithOrg(NumericExceptionSubItem item, CompanyOrgUnitInfo ... companys) {
        AccountBadDebtException excp = null;
        if (null == item) {
            return excp;
        }
        if (null == companys || companys.length == 0) {
            excp = new AccountBadDebtException(item);
        } else if (companys.length == 1) {
            excp = new AccountBadDebtException(item, new Object[]{BadAccountFacadeControllerBean.getCompanyInfo(companys[0])});
        } else if (companys.length == 2) {
            excp = new AccountBadDebtException(item, new Object[]{BadAccountFacadeControllerBean.getCompanyInfo(companys[0]), BadAccountFacadeControllerBean.getCompanyInfo(companys[1])});
        }
        return excp;
    }

    @Override
    public String _batchDeleteParams(Context ctx, CompanyOrgUnitCollection companyColl) throws BOSException, EASBizException {
        IARSaleIncomeParam iARSaleIncomeParam;
        ARSaleIncomeParamCollection arSaleIncomeParamColl;
        IARAccountAnalysisParams iARAccountAnalysisParams;
        ARAccountAnalysisParamsCollection arAccountAnalysisParamsColl;
        BatchResult result = new BatchResult(BadAccountFacadeControllerBean.getArResource("all_delete_success"));
        if (null == companyColl || companyColl.size() == 0) {
            return result.toString();
        }
        result.setTotalCount(companyColl.size());
        CompanyOrgUnitCollection filterColl = this.filterCompanyColl(ctx, companyColl);
        HashSet<String> idSet = new HashSet<String>(companyColl.size());
        for (int i = 0; i < companyColl.size(); ++i) {
            CompanyOrgUnitInfo company = companyColl.get(i);
            if (StringUtils.isEmpty((String)company.getId().toString())) continue;
            idSet.add(company.getId().toString());
        }
        if (null != filterColl && filterColl.size() > 0) {
            result.setSumaryTemplate(BadAccountFacadeControllerBean.getArResource("delete_sumaryTemplate"));
            result.setErrorCount(filterColl.size());
            ArrayList<String> detailMesgs = new ArrayList<String>(filterColl.size());
            result.setDetailMesgs(detailMesgs);
            for (int i = 0; i < filterColl.size(); ++i) {
                AccountBadDebtException excp = this.getAccountBadDebtExceptionWithOrg(AccountBadDebtException.NOT_ALLOWED_DELETE_WITH_JT_DATA, filterColl.get(i));
                if (null == excp) continue;
                detailMesgs.add(excp.getMessage());
            }
        }
        if (idSet.size() == 0) {
            return result.toString();
        }
        result.setSuccessCount(idSet.size());
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        ObjectUuidPK[] pkArr = null;
        IApOtherParams iApOtherParams = ApOtherParamsFactory.getLocalInstance(ctx);
        ApOtherParamsCollection apOtherParamsColl = iApOtherParams.getApOtherParamsCollection(view);
        if (null != apOtherParamsColl && apOtherParamsColl.size() > 0) {
            pkArr = new ObjectUuidPK[apOtherParamsColl.size()];
            for (int j = 0; j < apOtherParamsColl.size(); ++j) {
                pkArr[j] = new ObjectUuidPK(apOtherParamsColl.get(j).getId());
            }
            iApOtherParams.deleteBatchData((IObjectPK[])pkArr);
            pkArr = null;
        }
        if (null != (arAccountAnalysisParamsColl = (iARAccountAnalysisParams = ARAccountAnalysisParamsFactory.getLocalInstance(ctx)).getARAccountAnalysisParamsCollection(view)) && arAccountAnalysisParamsColl.size() > 0) {
            pkArr = new ObjectUuidPK[arAccountAnalysisParamsColl.size()];
            for (int j = 0; j < arAccountAnalysisParamsColl.size(); ++j) {
                pkArr[j] = new ObjectUuidPK(arAccountAnalysisParamsColl.get(j).getId());
            }
            iARAccountAnalysisParams.deleteBatchData((IObjectPK[])pkArr);
            pkArr = null;
        }
        if (null != (arSaleIncomeParamColl = (iARSaleIncomeParam = ARSaleIncomeParamFactory.getLocalInstance(ctx)).getARSaleIncomeParamCollection(view)) && arSaleIncomeParamColl.size() > 0) {
            pkArr = new ObjectUuidPK[arSaleIncomeParamColl.size()];
            for (int j = 0; j < arSaleIncomeParamColl.size(); ++j) {
                pkArr[j] = new ObjectUuidPK(arSaleIncomeParamColl.get(j).getId());
            }
            iARSaleIncomeParam.deleteBatchData((IObjectPK[])pkArr);
            pkArr = null;
        }
        if (null != (pkArr = this.getDeleteParamItemPKArray(ctx, companyColl)) && pkArr.length > 0) {
            ParamItemFactory.getLocalInstance((Context)ctx).deleteBatchData((IObjectPK[])pkArr);
        }
        pkArr = null;
        return result.toString();
    }

    public static class BatchResult {
        private int totalCount = 0;
        private int successCount = 0;
        private int errorCount = 0;
        private String sumaryTemplate;
        private String summaryMsg;
        private List<String> detailMesgs;

        BatchResult(String sumaryTemplate) {
            this.sumaryTemplate = sumaryTemplate;
        }

        public int getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(int totalCount) {
            this.totalCount = totalCount;
        }

        public int getSuccessCount() {
            return this.successCount;
        }

        public void setSuccessCount(int successCount) {
            this.successCount = successCount;
        }

        public int getErrorCount() {
            return this.errorCount;
        }

        public void setErrorCount(int errorCount) {
            this.errorCount = errorCount;
        }

        public String getSummaryMsg() {
            return this.summaryMsg;
        }

        public void setSummaryMsg(String summaryMsg) {
            this.summaryMsg = summaryMsg;
        }

        public String getSumaryTemplate() {
            return this.sumaryTemplate;
        }

        public void setSumaryTemplate(String sumaryTemplate) {
            this.sumaryTemplate = sumaryTemplate;
        }

        public List<String> getDetailMesgs() {
            return this.detailMesgs;
        }

        public void setDetailMesgs(List<String> detailMesgs) {
            this.detailMesgs = detailMesgs;
        }

        public String toString() {
            if (this.totalCount > 0 && this.errorCount > 0) {
                this.successCount = this.totalCount - this.errorCount;
                this.summaryMsg = MessageFormat.format(this.sumaryTemplate, this.totalCount, this.successCount, this.errorCount);
            } else {
                this.summaryMsg = this.sumaryTemplate;
            }
            return Kson.getGson().toJson((Object)this);
        }
    }

    public static class AccuralMethod {
        public static final String ZJZXF = BadAccountFacadeControllerBean.getArResources("derect_method");
        public static final String BDF_XSBFBF = BadAccountFacadeControllerBean.getArResources("SALEPRODUCTPERCENTMETHOD");
        public static final String BDF_YSZKYEBFBF = BadAccountFacadeControllerBean.getArResources("ACCOUNTRECEIVABLEPERCENTMETHODBYGL");
        public static final String BDF_ZLFXF_HZJT = BadAccountFacadeControllerBean.getArResources("ACCOUNTRECEIVABLEPERCENTMETHODBYGL");
        public static final String BDF_ZLFXF_AKHJT = BadAccountFacadeControllerBean.getArResources("AGING_ANALYSIS_CLIENT_BASIS");
        public static final String BDF_ZLFXF_ADJT = BadAccountFacadeControllerBean.getArResources("BILLANALYSEACCOUNTDATEMETHOD");
        public static final String BDF_EXCP = BadAccountFacadeControllerBean.getArResources("ALLOWANCE_METHOD_ABNORMAL_DATA");
    }

    public static class OrgAccuralParam {
        private String companyId;
        private String companyNumber;
        private String companyName;
        private String arap001;
        private String arap003;
        private String accuralMethod;

        public String getCompanyId() {
            return this.companyId;
        }

        public void setCompanyId(String companyId) {
            this.companyId = companyId;
        }

        public String getCompanyNumber() {
            return this.companyNumber;
        }

        public void setCompanyNumber(String companyNumber) {
            this.companyNumber = companyNumber;
        }

        public String getCompanyName() {
            return this.companyName;
        }

        public void setCompanyName(String companyName) {
            this.companyName = companyName;
        }

        public String getArap001() {
            return this.arap001;
        }

        public void setArap001(String arap001) {
            this.arap001 = arap001;
        }

        public String getArap003() {
            return this.arap003;
        }

        public void setArap003(String arap003) {
            this.arap003 = arap003;
        }

        public String getAccuralMethod() {
            return this.accuralMethod;
        }

        public void setAccuralMethod(String accuralMethod) {
            this.accuralMethod = accuralMethod;
        }
    }
}

