/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.base.dap.DAPTransformerFactory;
import com.kingdee.eas.base.dap.DAPVoucherTypeEnum;
import com.kingdee.eas.base.dap.IDAPTransformer;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.wssc.BillImageFacadeFactory;
import com.kingdee.eas.base.wssc.IBillImageFacade;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.BadAccountFacadeFactory;
import com.kingdee.eas.fi.ar.BadAcctBillTypeEnum;
import com.kingdee.eas.fi.ar.BadAcctCollection;
import com.kingdee.eas.fi.ar.BadAcctException;
import com.kingdee.eas.fi.ar.BadAcctFactory;
import com.kingdee.eas.fi.ar.BadAcctInfo;
import com.kingdee.eas.fi.ar.IBadAccountFacade;
import com.kingdee.eas.fi.ar.IBadAcct;
import com.kingdee.eas.fi.ar.IOtherBill;
import com.kingdee.eas.fi.ar.IOtherBillPlan;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.OtherBillCollection;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.fi.ar.OtherBillPlanFactory;
import com.kingdee.eas.fi.ar.OtherBillentryCollection;
import com.kingdee.eas.fi.ar.OtherBillentryInfo;
import com.kingdee.eas.fi.ar.app.AbstractBadAcctControllerBean;
import com.kingdee.eas.fi.ar.app.util.ArServerUtils;
import com.kingdee.eas.fi.ar.app.util.BaseDataUtil;
import com.kingdee.eas.fi.ar.app.util.CommonServerUtils;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class BadAcctControllerBean
extends AbstractBadAcctControllerBean {
    private String CR = " \r\n ";

    protected boolean _checkLineExist(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return false;
    }

    protected SystemEnum _getOwnedSys(Context ctx) throws BOSException, EASBizException {
        return null;
    }

    private Date getCurrDate() {
        GregorianCalendar calendar = new GregorianCalendar();
        Date currDate = new Date(calendar.getTimeInMillis());
        return currDate;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        super._checkNumberDup(ctx, null, model);
        return super._submit(ctx, model);
    }

    @Override
    protected IObjectValue _saveBadAcct(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IBillImageFacade image;
        String imageNumber;
        BadAcctInfo badAcctInfo = (BadAcctInfo)model;
        IOtherBill iOtherBill = OtherBillFactory.getLocalInstance(ctx);
        ObjectUuidPK otherBillPK = new ObjectUuidPK(badAcctInfo.getBillID());
        OtherBillInfo otherBillInfo = iOtherBill.getOtherBillInfo((IObjectPK)otherBillPK);
        BadAcctBillTypeEnum billTypeEnum = badAcctInfo.getBillType();
        badAcctInfo.setBillType(billTypeEnum);
        if (badAcctInfo.getId() == null || badAcctInfo.getId().toString().equals("")) {
            badAcctInfo.setId(BOSUuid.create((String)badAcctInfo.getBOSType().toString()));
        }
        if (badAcctInfo.getBadAmounts().compareTo(new BigDecimal("0.0")) > 0) {
            this.submit(ctx, (CoreBaseInfo)badAcctInfo);
        }
        if (StringUtils.isEmpty((String)(imageNumber = (image = BillImageFacadeFactory.getLocalInstance((Context)ctx)).getImageNumber(badAcctInfo.getBOSType().toString(), badAcctInfo.getId().toString())))) {
            imageNumber = image.genImageNumber(badAcctInfo.getBOSType().toString(), badAcctInfo.getId().toString());
        }
        OtherBillentryInfo otherBillentryInfo = null;
        OtherBillentryCollection otherBillentryCol = otherBillInfo.getEntry();
        int size = otherBillentryCol.size();
        for (int i = 0; i < size; ++i) {
            otherBillentryInfo = otherBillentryCol.get(i);
            if (otherBillentryInfo.getSeq() != badAcctInfo.getEntrySeq()) continue;
            if (otherBillentryInfo.getLockVerifyAmt() != null) {
                otherBillentryInfo.setLockVerifyAmt(otherBillentryInfo.getLockVerifyAmt().add(badAcctInfo.getBadAmounts()));
            } else {
                otherBillentryInfo.setLockVerifyAmt(badAcctInfo.getBadAmounts());
            }
            if (otherBillentryInfo.getRecievePayAmount().compareTo(otherBillentryInfo.getLockVerifyAmt()) < 0) {
                String errorMsg = this.getStrResource(ctx, "WRITE_BACK_AR_BILL_ERR", new Object[]{otherBillInfo.getNumber(), badAcctInfo.getEntrySeq(), badAcctInfo.getBadAmounts(), otherBillentryInfo.getLockUnVerifyAmt()});
                throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{errorMsg});
            }
            if (otherBillentryInfo.getLockUnVerifyAmt() != null) {
                otherBillentryInfo.setLockUnVerifyAmt(otherBillentryInfo.getLockUnVerifyAmt().subtract(badAcctInfo.getBadAmounts()));
            } else {
                otherBillentryInfo.setLockUnVerifyAmt(badAcctInfo.getBadAmounts());
            }
            if (otherBillentryInfo.getLockVerifyAmtLocal() != null) {
                otherBillentryInfo.setLockVerifyAmtLocal(otherBillentryInfo.getLockVerifyAmtLocal().add(badAcctInfo.getBadAmountsLocal()));
            } else {
                otherBillentryInfo.setLockVerifyAmtLocal(badAcctInfo.getBadAmountsLocal());
            }
            if (otherBillentryInfo.getLockUnVerifyAmtLocal() != null) {
                otherBillentryInfo.setLockUnVerifyAmtLocal(otherBillentryInfo.getLockUnVerifyAmtLocal().subtract(badAcctInfo.getBadAmountsLocal()));
                break;
            }
            otherBillentryInfo.setLockUnVerifyAmtLocal(badAcctInfo.getBadAmountsLocal());
            break;
        }
        otherBillInfo.lockPlans();
        iOtherBill.update((IObjectPK)otherBillPK, (CoreBaseInfo)otherBillInfo);
        return badAcctInfo;
    }

    private void reverseOtherBill(Context ctx, BadAcctInfo badAcctInfo, boolean isAudit) throws BOSException, EASBizException {
        String otherBillID = "";
        otherBillID = badAcctInfo.getBillID();
        if (otherBillID != null) {
            Connection connection = null;
            PreparedStatement pstmt = null;
            try {
                IBadAccountFacade iBadAccountFacade;
                String accuralParam;
                connection = CommonServerUtils.getConnection(ctx);
                CompanyOrgUnitInfo companyOrgUnitInfo = CommonServerUtils.getCurrentCompany(ctx);
                String baseCurrencyId = null;
                if (companyOrgUnitInfo != null) {
                    baseCurrencyId = companyOrgUnitInfo.getBaseCurrency().getId().toString();
                }
                if ((accuralParam = (iBadAccountFacade = BadAccountFacadeFactory.getLocalInstance(ctx)).getAccuralParam(badAcctInfo.getCompany())).equalsIgnoreCase(String.valueOf(5))) {
                    StringBuffer accBadDebtSql = new StringBuffer("");
                    accBadDebtSql.append(" update T_AR_AccountBadDebtCustPrepare set ");
                    accBadDebtSql.append(" FLastPrepareAmount = FLastPrepareAmount + ? ");
                    accBadDebtSql.append(" where FCompanyID = ? and FCustomerID = ? and FCurrencyID = ? ");
                    pstmt = connection.prepareStatement(accBadDebtSql.toString());
                    if (isAudit) {
                        pstmt.setBigDecimal(1, BaseDataUtil.ZERO.subtract(badAcctInfo.getBadAmountsLocal()));
                        pstmt.setString(2, badAcctInfo.getCompany().getId().toString());
                        pstmt.setString(3, badAcctInfo.getAcctCussentID());
                        pstmt.setString(4, baseCurrencyId);
                    } else {
                        pstmt.setBigDecimal(1, badAcctInfo.getBadAmountsLocal());
                        pstmt.setString(2, badAcctInfo.getCompany().getId().toString());
                        pstmt.setString(3, badAcctInfo.getAcctCussentID());
                        pstmt.setString(4, baseCurrencyId);
                    }
                    pstmt.executeUpdate();
                    pstmt.close();
                }
                StringBuilder buffer = new StringBuilder(300);
                buffer.append(" update t_ar_otherbill set FVerifyAmount=FVerifyAmount+?,FVerifyAmountLocal=FVerifyAmountLocal+?,");
                buffer.append(" FUnVerifyAmount=FUnVerifyAmount+?,FUnVerifyAmountLocal=FUnVerifyAmountLocal+?,");
                buffer.append(" FTotalBadAmount=FTotalBadAmount+?,FTotalBadAmountLocal=FTotalBadAmountLocal+? ");
                buffer.append(" where fid=?");
                pstmt = connection.prepareStatement(buffer.toString());
                if (isAudit) {
                    pstmt.setBigDecimal(1, badAcctInfo.getBadAmounts());
                    pstmt.setBigDecimal(2, badAcctInfo.getBadAmountsLocal());
                    pstmt.setBigDecimal(3, BaseDataUtil.ZERO.subtract(badAcctInfo.getBadAmounts()));
                    pstmt.setBigDecimal(4, BaseDataUtil.ZERO.subtract(badAcctInfo.getBadAmountsLocal()));
                    pstmt.setBigDecimal(5, badAcctInfo.getBadAmounts());
                    pstmt.setBigDecimal(6, badAcctInfo.getBadAmountsLocal());
                    pstmt.setString(7, otherBillID);
                } else {
                    pstmt.setBigDecimal(1, BaseDataUtil.ZERO.subtract(badAcctInfo.getBadAmounts()));
                    pstmt.setBigDecimal(2, BaseDataUtil.ZERO.subtract(badAcctInfo.getBadAmountsLocal()));
                    pstmt.setBigDecimal(3, badAcctInfo.getBadAmounts());
                    pstmt.setBigDecimal(4, badAcctInfo.getBadAmountsLocal());
                    pstmt.setBigDecimal(5, BaseDataUtil.ZERO.subtract(badAcctInfo.getBadAmounts()));
                    pstmt.setBigDecimal(6, BaseDataUtil.ZERO.subtract(badAcctInfo.getBadAmountsLocal()));
                    pstmt.setString(7, otherBillID);
                }
                pstmt.executeUpdate();
                pstmt.close();
                buffer.setLength(0);
                buffer.append(" update t_ar_otherbill set FverifyStatus = ").append(this.CR);
                buffer.append(" case when isnull(FVerifyAmount, 0) = 0 then ").append(1).append(this.CR);
                buffer.append(" when isnull(FUnVerifyAmount, 0) = 0 then ").append(3).append(this.CR);
                buffer.append(" else ").append(2).append(" end ").append(this.CR);
                buffer.append(" where fid = ? ");
                pstmt = connection.prepareStatement(buffer.toString());
                pstmt.setString(1, otherBillID);
                pstmt.executeUpdate();
                pstmt.close();
                StringBuilder buffer1 = new StringBuilder(300);
                buffer1.append(" update t_ar_otherbillentry set FVerifyAmount=FVerifyAmount+?,FVerifyAmountLocal=FVerifyAmountLocal+?,");
                buffer1.append(" FUnVerifyAmount=FUnVerifyAmount+?,FUnVerifyAmountLocal=FUnVerifyAmountLocal+?,");
                buffer1.append(" FBadAmout=FBadAmout+?,FLocalBadAmout=FLocalBadAmout+? ");
                buffer1.append(" where fparentid=? and fseq =?");
                pstmt = connection.prepareStatement(buffer1.toString());
                if (isAudit) {
                    pstmt.setBigDecimal(1, badAcctInfo.getBadAmounts());
                    pstmt.setBigDecimal(2, badAcctInfo.getBadAmountsLocal());
                    pstmt.setBigDecimal(3, BaseDataUtil.ZERO.subtract(badAcctInfo.getBadAmounts()));
                    pstmt.setBigDecimal(4, BaseDataUtil.ZERO.subtract(badAcctInfo.getBadAmountsLocal()));
                    pstmt.setBigDecimal(5, badAcctInfo.getBadAmounts());
                    pstmt.setBigDecimal(6, badAcctInfo.getBadAmountsLocal());
                    pstmt.setString(7, otherBillID);
                    pstmt.setInt(8, badAcctInfo.getEntrySeq());
                } else {
                    pstmt.setBigDecimal(1, BaseDataUtil.ZERO.subtract(badAcctInfo.getBadAmounts()));
                    pstmt.setBigDecimal(2, BaseDataUtil.ZERO.subtract(badAcctInfo.getBadAmountsLocal()));
                    pstmt.setBigDecimal(3, badAcctInfo.getBadAmounts());
                    pstmt.setBigDecimal(4, badAcctInfo.getBadAmountsLocal());
                    pstmt.setBigDecimal(5, BaseDataUtil.ZERO.subtract(badAcctInfo.getBadAmounts()));
                    pstmt.setBigDecimal(6, BaseDataUtil.ZERO.subtract(badAcctInfo.getBadAmountsLocal()));
                    pstmt.setString(7, otherBillID);
                    pstmt.setInt(8, badAcctInfo.getEntrySeq());
                }
                pstmt.executeUpdate();
                this.writeBackArApBillPlan(ctx, otherBillID);
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pstmt, (Connection)connection);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)connection);
        }
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo botRelation = (BOTRelationInfo)bOTRelationInfo;
        BadAcctInfo badAcctInfo = (BadAcctInfo)srcBillVO;
        ObjectUuidPK badAcctPK = new ObjectUuidPK(badAcctInfo.getId());
        badAcctInfo = this.getBadAcctInfo(ctx, (IObjectPK)badAcctPK);
        if (BOTBillOperStateEnum.ADDNEW.equals((Object)bOTBillOperStateEnum) || BOTBillOperStateEnum.EDIT.equals((Object)bOTBillOperStateEnum)) {
            VoucherInfo voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(botRelation.getDestObjectID()));
            badAcctInfo.setFiVouchered(true);
            badAcctInfo.setVoucher(voucherInfo);
            badAcctInfo.setVoucherNumber(voucherInfo.getNumber());
            badAcctInfo.setVoucherType(voucherInfo.getVoucherType());
        } else if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
            if ("2652E01E".equals(botRelation.getDestEntityID())) {
                BadAcctCollection coll = this.getAllBadAcct4Voucher(ctx, (IObjectPK)badAcctPK);
                this.checkCanDeleteVoucher(ctx, coll);
            }
            badAcctInfo.setFiVouchered(false);
            badAcctInfo.setVoucher(null);
            badAcctInfo.setVoucherNumber(null);
            badAcctInfo.setVoucherType(null);
        }
        srcBillVO = badAcctInfo;
        super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
    }

    private IObjectValue auditBadAcct(Context ctx, BadAcctInfo badAcctInfo) throws BOSException, EASBizException {
        LogUtil logUtil = new LogUtil();
        String methodName = this.getStrResource(ctx, "audit_log");
        String instanceDeatil = badAcctInfo.getNumber();
        ObjectUuidPK iObjectPK = new ObjectUuidPK(badAcctInfo.getId().toString());
        IObjectPK logObjectPK = LogUtil.beginLog((Context)ctx, (String)methodName, (BOSObjectType)badAcctInfo.getBOSType(), (IObjectPK)iObjectPK, (String)instanceDeatil, (String)"fi_ar_badacct_audit");
        Date currentDate = this.getCurrDate();
        UserInfo currentUser = CommonServerUtils.getCurrentUser(ctx);
        badAcctInfo.setAuditDate(currentDate);
        badAcctInfo.setAuditor(currentUser);
        ObjectUuidPK pkBadAcct = new ObjectUuidPK(badAcctInfo.getId().toString());
        this.update(ctx, (IObjectPK)pkBadAcct, (CoreBaseInfo)badAcctInfo);
        this.reverseAudit(ctx, (IObjectValue)badAcctInfo, true);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logObjectPK);
        return badAcctInfo;
    }

    private String getStrResource(Context ctx, String resKey) {
        return EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)resKey, (Locale)ctx.getOriginLocale());
    }

    private String getStrResource(Context ctx, String resKey, Object[] params) {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)resKey, (Locale)ctx.getOriginLocale(), (Object[])params);
    }

    protected void reverseAudit(Context ctx, IObjectValue model, boolean isAudit) throws BOSException, EASBizException {
        BadAcctInfo badAcctInfo = (BadAcctInfo)model;
        this.reverseOtherBill(ctx, badAcctInfo, isAudit);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IBadAcct iBadAcct = BadAcctFactory.getLocalInstance(ctx);
        BadAcctInfo badAcctInfo = iBadAcct.getBadAcctInfo(pk);
        this.checkBadAcctDate(ctx, badAcctInfo.getCompany(), badAcctInfo.getBadAcctDate());
        if (badAcctInfo.getTakeBackAmounts().compareTo(new BigDecimal("0.0")) > 0) {
            String errorMsg = this.getStrResource(ctx, "acct_bad_take_back_remove");
            throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{errorMsg});
        }
        if (badAcctInfo.getAuditDate() != null && badAcctInfo.getAuditor() != null) {
            throw new BadAcctException(BadAcctException.BILL_AUDITED);
        }
        IObjectPK logObjectPK = ArServerUtils.beginLog(ctx, pk, "delete_log", (CoreBillBaseInfo)badAcctInfo, "fi_ar_badacct_delete");
        String billId = badAcctInfo.getBillID();
        ObjectUuidPK billPK = new ObjectUuidPK(billId);
        OtherBillInfo otherBillInfo = OtherBillFactory.getLocalInstance(ctx).getOtherBillInfo((IObjectPK)billPK);
        OtherBillentryCollection otherBillEntryCollection = otherBillInfo.getEntry();
        OtherBillentryInfo otherBillentryInfo = null;
        int size = otherBillEntryCollection.size();
        for (int j = 0; j < size; ++j) {
            otherBillentryInfo = otherBillEntryCollection.get(j);
            if (badAcctInfo.getEntrySeq() != otherBillentryInfo.getSeq()) continue;
            otherBillentryInfo.setLockVerifyAmt(otherBillentryInfo.getLockVerifyAmt().subtract(badAcctInfo.getBadAmounts()));
            otherBillentryInfo.setLockVerifyAmtLocal(otherBillentryInfo.getLockVerifyAmtLocal().subtract(badAcctInfo.getBadAmountsLocal()));
            otherBillentryInfo.setLockUnVerifyAmt(otherBillentryInfo.getLockUnVerifyAmt().add(badAcctInfo.getBadAmounts()));
            otherBillentryInfo.setLockUnVerifyAmtLocal(otherBillentryInfo.getLockUnVerifyAmtLocal().add(badAcctInfo.getBadAmountsLocal()));
            break;
        }
        otherBillInfo.lockPlans();
        OtherBillFactory.getLocalInstance(ctx).update((IObjectPK)billPK, (CoreBaseInfo)otherBillInfo);
        super._delete(ctx, pk);
        BaseDataUtil.rolbackNumber(ctx, (CoreBillBaseInfo)badAcctInfo);
        ArServerUtils.afterLog(ctx, logObjectPK);
    }

    private void checkBadAcctDate(Context ctx, CompanyOrgUnitInfo currentCompany, java.util.Date badAcctDate) throws EASBizException, BOSException {
        PeriodInfo currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (CompanyOrgUnitInfo)currentCompany);
        java.util.Date beginDate = currPeriod.getBeginDate();
        this.checkBadAcctDate(ctx, beginDate, badAcctDate);
    }

    private void checkBadAcctDate(Context ctx, java.util.Date beginDate, java.util.Date badAcctDate) throws EASBizException, BOSException {
        if (badAcctDate.before(beginDate)) {
            String errorMsg = this.getStrResource(ctx, "badacct_operate_date_invalid");
            throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{errorMsg});
        }
    }

    @Override
    protected IObjectValue _audit(Context ctx, String billID) throws BOSException, EASBizException {
        BadAcctInfo badAcctInfo = null;
        ObjectUuidPK pk = null;
        pk = new ObjectUuidPK(billID);
        badAcctInfo = this.getBadAcctInfo(ctx, (IObjectPK)pk);
        if (badAcctInfo.getAuditDate() != null && badAcctInfo.getAuditor() != null) {
            throw new BadAcctException(BadAcctException.BILL_AUDITED);
        }
        return this.auditBadAcct(ctx, badAcctInfo);
    }

    @Override
    protected IObjectValue _unAudit(Context ctx, String billID) throws BOSException, EASBizException {
        BadAcctInfo badAcctInfo = null;
        ObjectUuidPK pk = new ObjectUuidPK(billID);
        badAcctInfo = this.getBadAcctInfo(ctx, (IObjectPK)pk);
        String errorMsg = null;
        LogUtil logUtil = new LogUtil();
        String methodName = this.getStrResource(ctx, "unaudit_log");
        String instanceDeatil = badAcctInfo.getNumber();
        IObjectPK logObjectPK = LogUtil.beginLog((Context)ctx, (String)methodName, (BOSObjectType)badAcctInfo.getBOSType(), (IObjectPK)pk, (String)instanceDeatil, (String)"fi_ar_badacct_unaudit");
        this.checkBadAcctDate(ctx, badAcctInfo.getCompany(), badAcctInfo.getBadAcctDate());
        if (badAcctInfo.getAuditDate() == null || badAcctInfo.getAuditor() == null) {
            throw new BadAcctException(BadAcctException.BILL_NOT_AUDIT);
        }
        if (badAcctInfo.isFiVouchered()) {
            errorMsg = this.getStrResource(ctx, "voucher_unaudit");
            throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{errorMsg});
        }
        if (badAcctInfo.getTakeBackAmounts().compareTo(BaseDataUtil.ZERO) > 0) {
            errorMsg = this.getStrResource(ctx, "bad_acct_take_back_unaudit");
            throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{errorMsg});
        }
        badAcctInfo.setAuditDate(null);
        badAcctInfo.setAuditor(null);
        this.update(ctx, (IObjectPK)pk, (CoreBaseInfo)badAcctInfo);
        this.reverseAudit(ctx, (IObjectValue)badAcctInfo, false);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logObjectPK);
        return badAcctInfo;
    }

    protected DAPTransformResult _generateVoucher(Context ctx, IObjectPK[] sourceBillPkList, IObjectPK botMappingPK, SelectorItemCollection botpSelectors) throws BOSException, EASBizException {
        int total = sourceBillPkList.length;
        CoreBillBaseCollection allSourceBillCollection = new CoreBillBaseCollection();
        IObjectPK logPK = null;
        if (total > 0) {
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < sourceBillPkList.length; ++i) {
                idSet.add(sourceBillPkList[i].toString());
            }
            this._canVoucher(ctx, idSet);
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            if (botpSelectors != null) {
                botpSelectors.add(new SelectorItemInfo("number"));
                entityViewInfo.setSelector(botpSelectors);
            }
            FilterInfo filterInfo = new FilterInfo();
            String strIdLists = StringUtils.arrayToString((Object[])sourceBillPkList, (String)",");
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strIdLists, CompareType.INCLUDE));
            entityViewInfo.setFilter(filterInfo);
            CoreBillBaseCollection billColl = this.getCoreBillBaseCollection(ctx, entityViewInfo);
            block1: for (int i = 0; i < sourceBillPkList.length; ++i) {
                for (int j = 0; j < billColl.size(); ++j) {
                    if (!sourceBillPkList[i].toString().equals(billColl.get(j).getId().toString())) continue;
                    allSourceBillCollection.addObject((IObjectValue)billColl.get(j));
                    continue block1;
                }
            }
            StringBuilder billNumbers = new StringBuilder("");
            int size = allSourceBillCollection.size();
            for (int i = 0; i < size; ++i) {
                String billNumber = billColl.get(i).getNumber();
                billNumbers.append(billNumber).append("  ");
            }
            if (total > 0) {
                String methodName = this.getStrResource(ctx, "voucher_log");
                logPK = LogUtil.beginLog((Context)ctx, (String)methodName, (BOSObjectType)BOSUuid.getBOSObjectType((String)sourceBillPkList[0].toString(), (boolean)true), null, (String)billNumbers.toString(), (String)"fi_ar_badacct_voucher");
            }
        }
        DAPTransformResult result = super.generateVoucher(ctx, allSourceBillCollection, botMappingPK);
        if (logPK != null) {
            LogUtil.afterLog((Context)ctx, logPK);
        }
        return result;
    }

    @Override
    protected boolean _canVoucher(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("company.number"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("auditDate"));
        view.getSelector().add(new SelectorItemInfo("auditor.id"));
        view.getSelector().add("fiVouchered");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        BadAcctCollection coll = this.getBadAcctCollection(ctx, view);
        HashMap<String, Boolean> isRelationGLCacheMap = new HashMap<String, Boolean>();
        String notRelationGlMsg = this.getStrResource(ctx, "gl_not_relation_or_start");
        StringBuilder errorMsg = new StringBuilder();
        for (int i = 0; i < coll.size(); ++i) {
            BadAcctInfo badAcctInfo = coll.get(i);
            String number = badAcctInfo.getNumber();
            try {
                if (!this.checkIsRelationGL(ctx, badAcctInfo.getCompany().getId().toString(), isRelationGLCacheMap)) {
                    throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{notRelationGlMsg});
                }
                if (badAcctInfo.getAuditDate() == null || badAcctInfo.getAuditor() == null) {
                    throw new BadAcctException(BadAcctException.BILL_NOT_AUDIT);
                }
                if (!badAcctInfo.isFiVouchered()) continue;
                throw new BadAcctException(BadAcctException.BILL_VOUCHER);
            }
            catch (EASBizException e) {
                errorMsg.append(number).append("\uff1a").append(e.getMessage()).append("\r\n");
            }
        }
        if (errorMsg.length() > 0) {
            throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{errorMsg.toString()});
        }
        return true;
    }

    private boolean checkIsRelationGL(Context ctx, String companyId, Map<String, Boolean> isRelationGLCacheMap) throws EASBizException, BOSException {
        boolean isRlationGL = false;
        if (isRelationGLCacheMap.get(companyId) != null) {
            isRlationGL = isRelationGLCacheMap.get(companyId);
        } else {
            isRlationGL = this._isRelationGL(ctx, companyId);
            isRelationGLCacheMap.put(companyId, isRlationGL);
        }
        return isRlationGL;
    }

    @Override
    protected IObjectValue _genVoucher(Context ctx, String billID) throws BOSException, EASBizException {
        IObjectCollection tmpCollection = null;
        IDAPTransformer iDAPTransformer = DAPTransformerFactory.getLocalInstance((Context)ctx);
        CoreBillBaseCollection coreTransCollection = new CoreBillBaseCollection();
        ObjectUuidPK pk = new ObjectUuidPK(billID);
        BadAcctInfo model = (BadAcctInfo)this.getValue(ctx, (IObjectPK)pk);
        LogUtil logUtil = new LogUtil();
        String methodName = this.getStrResource(ctx, "voucher_log");
        String instanceDeatil = model.getNumber();
        IObjectPK logObjectPK = LogUtil.beginLog((Context)ctx, (String)methodName, (BOSObjectType)model.getBOSType(), (IObjectPK)pk, (String)instanceDeatil, (String)"fi_ar_badacct_voucher");
        IBadAcct iBadAcct = BadAcctFactory.getLocalInstance(ctx);
        BadAcctInfo badAcctInfo = iBadAcct.getBadAcctInfo((IObjectPK)pk);
        boolean isRelationGL = this._isRelationGL(ctx, badAcctInfo.getCompany().getId().toString());
        if (!isRelationGL) {
            String errorMsg = this.getStrResource(ctx, "gl_not_relation_or_start");
            throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{errorMsg});
        }
        if (badAcctInfo.getAuditDate() == null || badAcctInfo.getAuditor() == null) {
            throw new BadAcctException(BadAcctException.BILL_NOT_AUDIT);
        }
        if (badAcctInfo.isFiVouchered()) {
            throw new BadAcctException(BadAcctException.BILL_VOUCHER);
        }
        coreTransCollection.add((CoreBillBaseInfo)model);
        tmpCollection = iDAPTransformer.transformAuto(coreTransCollection, DAPVoucherTypeEnum.FIVoucher);
        IVoucher vchCtrl = VoucherFactory.getLocalInstance((Context)ctx);
        VoucherInfo vch = (VoucherInfo)tmpCollection.getObject(0);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logObjectPK);
        return vchCtrl.exteriorLazyLoad((BaseVoucherInfo)vch, VoucherInfo.getDefaultSelector());
    }

    @Override
    protected void _wfDelVoucher(Context ctx, String billID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(billID);
        this.deleteVoucher(ctx, (IObjectPK)pk);
    }

    private BadAcctCollection getAllBadAcct4Voucher(Context ctx, IObjectPK sourceBillPk) throws BOSException {
        StringBuilder sourceBillSql = new StringBuilder(100);
        sourceBillSql.append(" select b.FSRCOBJECTID from T_bot_relation a ").append(this.CR).append(" inner join T_bot_relation b on a.FDESTOBJECTID = b.FDESTOBJECTID ").append(this.CR).append(" where a.FSRCOBJECTID  = ? and a.FDESTENTITYID = '").append("2652E01E").append("' ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sourceBillSql.toString(), (Object[])new Object[]{sourceBillPk.toString()});
        HashSet<String> idSet = new HashSet<String>();
        try {
            while (rs.next()) {
                idSet.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filter);
        IBadAcct iBadAcct = BadAcctFactory.getLocalInstance(ctx);
        return iBadAcct.getBadAcctCollection(entityViewInfo);
    }

    protected boolean _deleteVoucher(Context ctx, IObjectPK sourceBillPk) throws BOSException, EASBizException {
        BadAcctCollection coll = this.getAllBadAcct4Voucher(ctx, sourceBillPk);
        if (coll == null || coll.size() == 0) {
            return false;
        }
        LogUtil logUtil = new LogUtil();
        String methodName = this.getStrResource(ctx, "delvoucher_log");
        StringBuilder billNumbers = new StringBuilder(coll.size() * 80);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            String billNumber = coll.get(i).getNumber();
            billNumbers.append(billNumber).append("  ");
        }
        IObjectPK logObjectPK = LogUtil.beginLog((Context)ctx, (String)methodName, (BOSObjectType)new BadAcctInfo().getBOSType(), (IObjectPK)sourceBillPk, (String)billNumbers.toString(), (String)"fi_ar_badacct_delvoucher");
        boolean result = super._deleteVoucher(ctx, sourceBillPk);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logObjectPK);
        return result;
    }

    protected void checkCanDeleteVoucher(Context ctx, BadAcctCollection coll) throws EASBizException, BOSException {
        String errorMsg = null;
        CompanyOrgUnitInfo company = coll.get(0).getCompany();
        PeriodInfo currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (CompanyOrgUnitInfo)company);
        java.util.Date beginDate = currPeriod.getBeginDate();
        boolean isRelationGL = this._isRelationGL(ctx, company.getId().toString());
        if (!isRelationGL) {
            errorMsg = this.getStrResource(ctx, "gl_not_relation_or_start_delVoucher");
            throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{errorMsg});
        }
        String number = "";
        for (int i = 0; i < coll.size(); ++i) {
            BadAcctInfo badAcctInfo = coll.get(i);
            number = badAcctInfo.getNumber();
            if (badAcctInfo.getBadAcctDate().before(beginDate)) {
                errorMsg = number + ":" + this.getStrResource(ctx, "badacct_operate_date_invalid");
                throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{errorMsg});
            }
            if (!badAcctInfo.isFiVouchered()) {
                errorMsg = number + ":" + this.getStrResource(ctx, "no_gen_voucher");
                throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{errorMsg});
            }
            if (badAcctInfo.getTakeBackAmounts().compareTo(BigDecimal.ZERO) <= 0) continue;
            errorMsg = number + ":" + this.getStrResource(ctx, "acct_bad_take_back_delvoucher");
            throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{errorMsg});
        }
    }

    @Override
    protected boolean _isRelationGL(Context ctx, String companyid) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(companyid);
        CompanyOrgUnitInfo currentCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)pk);
        return ArServerUtils.arIsRelatedAccount(ctx, currentCompany);
    }

    @Override
    protected Map _getAsstActName(Context ctx, String id, String billType) throws BOSException, EASBizException {
        HashMap<String, String> asstActNameMap = new HashMap<String, String>();
        StringBuffer sql = new StringBuffer("");
        if (billType.equalsIgnoreCase("otherbill")) {
            sql.append("select FAsstActName_L1 AS FActName_L1,FAsstActName_L2 AS FActName_L2,FAsstActName_L3 AS FActName_L3 ").append(" from t_ar_otherBill where fid = ?");
        } else if (billType.equalsIgnoreCase("badacct")) {
            sql.append("select FAcctCussentName_L1 AS FActName_L1,FAcctCussentName_L2 AS FActName_L2,FAcctCussentName_L3 AS FActName_L3").append(" from t_ar_badacct where fid = ?");
        } else if (billType.equalsIgnoreCase("initbadaccount")) {
            sql.append("select FAcctCussentName_L1 AS FActName_L1,FAcctCussentName_L2 AS FActName_L2,FAcctCussentName_L3 AS FActName_L3 ").append(" from t_ar_initbadaccount where fid = ?");
        }
        if (sql.toString().equals("")) {
            return asstActNameMap;
        }
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            ps = con.prepareStatement(sql.toString());
            ps.setString(1, id);
            rs = ps.executeQuery();
            if (rs.next()) {
                String asstActName_L1 = rs.getString("FActName_L1");
                String asstActName_L2 = rs.getString("FActName_L2");
                String asstActName_L3 = rs.getString("FActName_L3");
                if (asstActName_L1 == null) {
                    asstActName_L1 = "";
                }
                if (asstActName_L2 == null) {
                    asstActName_L2 = "";
                }
                if (asstActName_L3 == null) {
                    asstActName_L3 = "";
                }
                asstActNameMap.put("L1", asstActName_L1);
                asstActNameMap.put("L2", asstActName_L2);
                asstActNameMap.put("L3", asstActName_L3);
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return asstActNameMap;
    }

    protected void writeBackArApBillPlan(Context ctx, String id) throws BOSException, EASBizException {
        HashSet<String> arSet = new HashSet<String>();
        arSet.add(id);
        if (arSet.size() > 0) {
            IOtherBill iBill = OtherBillFactory.getLocalInstance(ctx);
            IOtherBillPlan iBillPlan = OtherBillPlanFactory.getLocalInstance(ctx);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo fiterInfo = new FilterInfo();
            FilterItemInfo idFilter = new FilterItemInfo("id", arSet, CompareType.INCLUDE);
            fiterInfo.getFilterItems().add(idFilter);
            view.setFilter(fiterInfo);
            view.getSelector().add(new SelectorItemInfo("recievePlan.verifyAmount"));
            view.getSelector().add(new SelectorItemInfo("recievePlan.verifyAmountLocal"));
            view.getSelector().add(new SelectorItemInfo("recievePlan.recievePayAmount"));
            view.getSelector().add(new SelectorItemInfo("recievePlan.recievePayAmountLocal"));
            view.getSelector().add(new SelectorItemInfo("recievePlan.recievePayDate"));
            view.getSelector().add(new SelectorItemInfo("verifyAmount"));
            view.getSelector().add(new SelectorItemInfo("verifyAmountLocal"));
            view.getSelector().add(new SelectorItemInfo("entry.recievePayAmount"));
            view.getSelector().add(new SelectorItemInfo("entry.recievePayAmountLocal"));
            view.getSelector().add(new SelectorItemInfo("entry.amount"));
            view.getSelector().add(new SelectorItemInfo("entry.taxAmount"));
            view.getSelector().add(new SelectorItemInfo("entry.unVerifyAmount"));
            view.getSelector().add(new SelectorItemInfo("entry.unVerifyAmountLocal"));
            view.getSelector().add(new SelectorItemInfo("entry.verifyAmount"));
            view.getSelector().add(new SelectorItemInfo("entry.verifyAmountLocal"));
            view.getSelector().add(new SelectorItemInfo("entry.lockUnVerifyAmt"));
            view.getSelector().add(new SelectorItemInfo("entry.lockUnVerifyAmtLocal"));
            view.getSelector().add(new SelectorItemInfo("entry.lockVerifyAmt"));
            view.getSelector().add(new SelectorItemInfo("entry.lockVerifyAmtLocal"));
            OtherBillCollection otherBillColl = iBill.getOtherBillCollection(view);
            OtherBillInfo otherBillInfo = null;
            CoreBaseCollection coreBaseColl = new CoreBaseCollection();
            int size = otherBillColl.size();
            for (int i = 0; i < size; ++i) {
                otherBillInfo = otherBillColl.get(i);
                otherBillInfo.verifyPlan();
                coreBaseColl.addObjectCollection((IObjectCollection)otherBillInfo.getRecievePlan());
            }
            iBillPlan.update(coreBaseColl);
        }
    }

    @Override
    protected IObjectValue _genVoucher(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return this.genVoucher(ctx, pk.toString());
    }

    @Override
    protected IObjectValue _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return this.audit(ctx, pk.toString());
    }

    @Override
    protected IObjectValue _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return this.unAudit(ctx, pk.toString());
    }

    @Override
    protected void _wfDelVoucher(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.wfDelVoucher(ctx, pk.toString());
    }
}

