/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.app.AbstractBadAcctFacadeControllerBean;
import com.kingdee.eas.fi.ar.app.util.ArServerUtils;
import com.kingdee.eas.fi.ar.app.util.CommonServerUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BadAcctFacadeControllerBean
extends AbstractBadAcctFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ar.app.BadAcctFacadeControllerBean");

    @Override
    protected void _badAcctTakeBack(Context ctx, IObjectValue receivingBill) throws BOSException, EASBizException {
    }

    private boolean isNeedChecked(Context ctx) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        boolean arIsRltdAccunt = ArServerUtils.arIsRelatedAccount(ctx, company);
        boolean glIsStart = CommonServerUtils.glIsStart(ctx, company);
        return arIsRltdAccunt && glIsStart;
    }

    @Override
    protected IRowSet _getBadAcct(Context ctx, String filter, boolean isInitBadAcct) throws BOSException, EASBizException {
        String language = ctx.getLocale().getLanguage();
        StringBuffer badAcctQuery = new StringBuffer("");
        if (isInitBadAcct) {
            badAcctQuery.append("SELECT top 100 INITBADACCOUNT.FID AS FID,");
            badAcctQuery.append(" INITBADACCOUNT.FNumber AS FNumber,");
            badAcctQuery.append(" '' AS FAccountID,");
            badAcctQuery.append(" 1 AS FBadAcctType,");
            badAcctQuery.append(" INITBADACCOUNT.FBadAccountDate AS FBadAcctDate,");
            badAcctQuery.append(" INITBADACCOUNT.FBadAcctNote AS FBadAcctNote,");
            badAcctQuery.append(" COMPANY.FID AS FCompanyID,");
            badAcctQuery.append(" COMPANY.FName_" + language + " AS FCompany,");
            badAcctQuery.append(" ADMINORGUNIT.FID AS FAdminOrgUnitID,");
            badAcctQuery.append(" ADMINORGUNIT.FName_" + language + " AS FAdminOrgUnit,");
            badAcctQuery.append(" SALESMAN.FID AS FPersonID,");
            badAcctQuery.append(" SALESMAN.FName_" + language + " AS FPerson,");
            badAcctQuery.append(" ASSTACTTYPE.FID AS FAsstAcctTypeID,");
            badAcctQuery.append(" ASSTACTTYPE.FName_" + language + " AS FAsstAcctType, ");
            badAcctQuery.append(" INITBADACCOUNT.FAcctCussentID AS FAsstAcctID, ");
            badAcctQuery.append(" INITBADACCOUNT.FAcctCussentName_" + language + " AS FAsstAcct, ");
            badAcctQuery.append(" CURRENCY.FID AS FCurrencyID,");
            badAcctQuery.append(" CURRENCY.FName_" + language + " AS FCurrency,");
            badAcctQuery.append(" INITBADACCOUNT.FExchangeRate AS FExchangeRate,");
            badAcctQuery.append(" '' AS FBillNumber,");
            badAcctQuery.append(" INITBADACCOUNT.FAmounts AS FBadAmounts,");
            badAcctQuery.append(" INITBADACCOUNT.FTakeBackAmounts AS FTakeBackMounts, ");
            badAcctQuery.append(" (INITBADACCOUNT.FAmounts - INITBADACCOUNT.FTakeBackAmounts) AS FNoTakeBackMounts, ");
            badAcctQuery.append(" (INITBADACCOUNT.FAmountsLocal - INITBADACCOUNT.FTakeBackAmountsLocal) AS FLocalNoTakeBackMounts ");
            badAcctQuery.append(" FROM T_AR_InitBadAccount AS INITBADACCOUNT ");
            badAcctQuery.append(" LEFT OUTER JOIN T_ORG_Company AS COMPANY ");
            badAcctQuery.append(" ON INITBADACCOUNT.FCompanyID = COMPANY.FID ");
            badAcctQuery.append(" LEFT OUTER JOIN T_BD_Currency AS CURRENCY ");
            badAcctQuery.append(" ON INITBADACCOUNT.FCurrencyID = CURRENCY.FID ");
            badAcctQuery.append(" INNER JOIN T_BD_AsstActType AS ASSTACTTYPE ");
            badAcctQuery.append(" ON INITBADACCOUNT.FAsstActTypeID = ASSTACTTYPE.FID ");
            badAcctQuery.append(" LEFT OUTER JOIN T_ORG_Admin AS ADMINORGUNIT ");
            badAcctQuery.append(" ON ADMINORGUNIT.FID = INITBADACCOUNT.FAdminOrgUnitID ");
            badAcctQuery.append(" LEFT OUTER JOIN T_BD_Person AS SALESMAN ");
            badAcctQuery.append(" ON INITBADACCOUNT.FBizManID = SALESMAN.FID ");
            badAcctQuery.append(" WHERE ((INITBADACCOUNT.FAmounts - INITBADACCOUNT.FTakeBackAmounts) > 0) ");
        } else {
            badAcctQuery.append(" SELECT top 100 BADACCT.FID AS FID,");
            badAcctQuery.append(" BADACCT.FNumber AS FNumber,");
            badAcctQuery.append(" BADACCT.FAccountID AS FAccountID,");
            badAcctQuery.append(" 2 AS FBadAcctType,");
            badAcctQuery.append(" BADACCT.FBadAcctDate AS FBadAcctDate,");
            badAcctQuery.append(" BADACCT.FBadAcctCause AS FBadAcctNote,");
            badAcctQuery.append(" COMPANY.FID AS FCompanyID,");
            badAcctQuery.append(" COMPANY.FName_" + language + " AS FCompany,");
            badAcctQuery.append(" ADMINORGUNIT.FID AS FAdminOrgUnitID,");
            badAcctQuery.append(" ADMINORGUNIT.FName_" + language + " AS FAdminOrgUnit,");
            badAcctQuery.append(" SALESMAN.FID AS FPersonID,");
            badAcctQuery.append(" SALESMAN.FName_" + language + " AS FPerson,");
            badAcctQuery.append(" CUSSENTTYPE.FID AS FAsstAcctTypeID,");
            badAcctQuery.append(" CUSSENTTYPE.FName_" + language + " AS FAsstAcctType,");
            badAcctQuery.append(" BADACCT.FAcctCussentID AS FAsstAcctID,");
            badAcctQuery.append(" BADACCT.FAcctCussentName_" + language + " AS FAsstAcct,");
            badAcctQuery.append(" CURRENCY.FID AS FCurrencyID,");
            badAcctQuery.append(" CURRENCY.FName_" + language + " AS FCurrency,");
            badAcctQuery.append(" BADACCT.FExchageRate AS FExchangeRate,");
            badAcctQuery.append(" BADACCT.FBillNumber AS FBillNumber,");
            badAcctQuery.append(" BADACCT.FBadAmounts AS FBadAmounts,");
            badAcctQuery.append(" BADACCT.FTakeBackAmounts AS FTakeBackMounts,");
            badAcctQuery.append(" (BADACCT.FBadAmounts - BADACCT.FTakeBackAmounts) AS FNoTakeBackMounts, ");
            badAcctQuery.append(" (BADACCT.FBadAmountsLocal - BADACCT.FTakeBackAmountsLocal) AS FLocalNoTakeBackMounts ");
            badAcctQuery.append(" FROM T_AR_BadAcct AS BADACCT ");
            badAcctQuery.append(" LEFT OUTER JOIN T_ORG_Company AS COMPANY ");
            badAcctQuery.append(" ON BADACCT.FCompanyID = COMPANY.FID ");
            badAcctQuery.append(" LEFT OUTER JOIN T_BD_AsstActType AS CUSSENTTYPE ");
            badAcctQuery.append(" ON BADACCT.FCussentTypeID = CUSSENTTYPE.FID ");
            badAcctQuery.append(" LEFT OUTER JOIN T_BD_Currency AS CURRENCY ");
            badAcctQuery.append(" ON BADACCT.FCurrencyID = CURRENCY.FID ");
            badAcctQuery.append(" LEFT OUTER JOIN T_ORG_Admin AS ADMINORGUNIT ");
            badAcctQuery.append(" ON ADMINORGUNIT.FID = BADACCT.FAdminOrgUnitID ");
            badAcctQuery.append(" LEFT OUTER JOIN T_BD_Person AS SALESMAN ");
            badAcctQuery.append(" ON BADACCT.FPersonID = SALESMAN.FID ");
            badAcctQuery.append(" WHERE (BADACCT.FBadAmounts - BADACCT.FTakeBackAmounts) > 0");
            badAcctQuery.append(" AND BADACCT.FAuditDate IS NOT NULL ");
            badAcctQuery.append(" AND BADACCT.FAuditorID IS NOT NULL ");
            if (this.isNeedChecked(ctx)) {
                badAcctQuery.append("  and BADACCT.FFiVouchered = 1  ");
            }
        }
        badAcctQuery.append(filter);
        return DbUtil.executeQuery((Context)ctx, (String)badAcctQuery.toString());
    }

    @Override
    protected IRowSet _getBadAcctLossData(Context ctx, String filter, Map options) throws BOSException {
        Set companyIdSet;
        SimpleDateFormat sdf = new SimpleDateFormat("yyy-MM-dd HH:mm:ss");
        String language = ctx.getLocale().getLanguage();
        CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
        StringBuffer badAcctLossDataSql = new StringBuffer("");
        boolean arIsRltdAccunt = true;
        Set set = companyIdSet = options.get("companyIdSet") instanceof Set ? (Set)options.get("companyIdSet") : null;
        if (companyIdSet == null || companyIdSet.size() == 0) {
            return null;
        }
        badAcctLossDataSql.append("SELECT DISTINCT * FROM (");
        Iterator iterator = companyIdSet.iterator();
        int index = 0;
        SystemStatusCtrolInfo systmStatusCtrlInf = null;
        String companyId = null;
        PeriodInfo startPeriod = null;
        while (iterator.hasNext()) {
            ++index;
            try {
                companyId = (String)iterator.next();
                companyInfo.setId(BOSUuid.read((String)companyId));
                systmStatusCtrlInf = CommonServerUtils.getSysStatusCtrolInfo(ctx, companyInfo, SystemEnum.ACCOUNTSRECEIVABLE);
                arIsRltdAccunt = systmStatusCtrlInf.isIsRelatedAccount();
                startPeriod = systmStatusCtrlInf.getStartPeriod();
            }
            catch (EASBizException e) {
                throw new BOSException(e.getMessage());
            }
            badAcctLossDataSql.append(" SELECT  ");
            badAcctLossDataSql.append(" OTHERBILL .FID AS  ID ,  ");
            badAcctLossDataSql.append(" 0 AS  CHECKBOX ,  ");
            badAcctLossDataSql.append("  OTHERBILL .FBillType AS  BILLTYPE ,  ");
            badAcctLossDataSql.append(" '' AS  SOURCEBILLNAME ,  ");
            badAcctLossDataSql.append("  OTHERBILL .FBillStatus AS  BILLSTATUS ,  ");
            badAcctLossDataSql.append("  OTHERBILL .FID AS  OTHERBILLID ,  ");
            badAcctLossDataSql.append("  OTHERBILL .FBillDate AS  BILLDATE ,  ");
            badAcctLossDataSql.append("  CURRENCY .FID AS  CURRENCYID ,  ");
            badAcctLossDataSql.append("  CURRENCY .FName_" + language + " AS  CURRENCYNAME ,  ");
            badAcctLossDataSql.append("  OTHERBILL .FLastExhangeRate AS  EXCHANGERATE ,  ");
            badAcctLossDataSql.append("  ASSTACTTYPE .FID AS  ASSTACTTYPEID ,  ");
            badAcctLossDataSql.append("  ASSTACTTYPE .FName_" + language + " AS  ASSTACTTYPENAME ,  ");
            badAcctLossDataSql.append("  OTHERBILL .FAsstActID AS  ASSTACTID ,  ");
            badAcctLossDataSql.append("  OTHERBILL .FAsstActName_" + language + " AS  ASSTACTNAME ,  ");
            badAcctLossDataSql.append("  OTHERBILL .FCompanyID AS  COMPANYID ,  ");
            badAcctLossDataSql.append("  COMPANY .FName_" + language + " AS  COMPANYNAME ,  ");
            badAcctLossDataSql.append("  COMPANY .FNumber AS  COMPANYNUMBER ,  ");
            badAcctLossDataSql.append("  OTHERBILL .FNumber AS  BILLNUMBER ,  ");
            badAcctLossDataSql.append("  OTHERBILL .FFiVouchered AS  FIVOUCHERED ,  ");
            badAcctLossDataSql.append("  OTHERBILL .FAuditDate AS  AUDITDATE ,  ");
            badAcctLossDataSql.append("  ENTRY .FID AS  ENTRYID ,  ");
            badAcctLossDataSql.append("  ENTRY .FSeq AS  ENTRYSEQ ,  ");
            badAcctLossDataSql.append("  ENTRY .FRecievePayAmount AS  RECIEVEPAYAMOUNT ,  ");
            badAcctLossDataSql.append("  ENTRY .FRecievePayAmountLocal AS  RECIEVEPAYAMOUNTLOCAL ,  ");
            badAcctLossDataSql.append("  ENTRY .FVerifyAmount AS  VERIFYAMOUNT ,  ");
            badAcctLossDataSql.append("  ENTRY .FVerifyAmountLocal AS  VERIFYAMOUNTLOCAL ,  ");
            badAcctLossDataSql.append("  ENTRY .FUnVerifyAmount AS  UNVERIFYAMOUNT ,  ");
            badAcctLossDataSql.append("  ENTRY .FUnVerifyAmountLocal AS  UNVERIFYAMOUNTLOCAL ,  ");
            badAcctLossDataSql.append("  ENTRY .FLockVerifyAmt AS  LOCKVERIFYAMT ,  ");
            badAcctLossDataSql.append("  ENTRY .FLockVerifyAmtLocal AS  LOCKVERIFYAMTLOCAL ,  ");
            badAcctLossDataSql.append(" ( ENTRY .FRecievePayAmount -  ENTRY .FLockVerifyAmt) AS  LOCKUNVERIFYAMT ,  ");
            badAcctLossDataSql.append(" ( ENTRY .FRecievePayAmountLocal -  ENTRY .FLockVerifyAmtLocal) AS  LOCKUNVERIFYAMTLOCAL ,  ");
            badAcctLossDataSql.append("  ENTRY .FBadAmout AS  BADAMOUNT ,  ");
            badAcctLossDataSql.append("  ENTRY .FLocalBadAmout AS  BADAMOUNTLOCAL ,  ");
            badAcctLossDataSql.append("  OTHERBILL .FAdminOrgUnitID AS  ADMINORGUNITID ,  ");
            badAcctLossDataSql.append("  ADMINORGUNIT .FName_" + language + " AS  ADMINORGUNITNAME ,  ");
            badAcctLossDataSql.append("  PERSON .FName_" + language + " AS  PERSONNAME ,  ");
            badAcctLossDataSql.append("  OTHERBILL .FPersonId AS  PERSONID ,  ");
            badAcctLossDataSql.append("  CURRENCY .FPrecision AS  CURRENCYPRECISION ,  ");
            badAcctLossDataSql.append("  BASECURRENCY .FPrecision AS  BASECURRENCYPRECISION ,  ");
            badAcctLossDataSql.append("  OTHERBILL .FIsBizBill AS  ISBIZBILL  ");
            badAcctLossDataSql.append(" FROM T_AR_OtherBill AS  OTHERBILL  ");
            badAcctLossDataSql.append(" LEFT OUTER JOIN T_BD_Currency AS  CURRENCY  ");
            badAcctLossDataSql.append(" ON  CURRENCY .FID =  OTHERBILL .FCurrencyID ");
            badAcctLossDataSql.append(" LEFT OUTER JOIN T_BD_AsstActType AS  ASSTACTTYPE  ");
            badAcctLossDataSql.append(" ON  ASSTACTTYPE .FID =  OTHERBILL .FAsstActTypeID ");
            badAcctLossDataSql.append(" LEFT OUTER JOIN T_AR_OtherBillentry AS  ENTRY  ");
            badAcctLossDataSql.append(" ON  OTHERBILL .FID =  ENTRY .FParentID ");
            badAcctLossDataSql.append(" LEFT OUTER JOIN T_ORG_Company AS  COMPANY  ");
            badAcctLossDataSql.append(" ON  OTHERBILL .FCompanyID =  COMPANY .FID ");
            badAcctLossDataSql.append(" LEFT OUTER JOIN T_BD_Currency AS  BASECURRENCY  ");
            badAcctLossDataSql.append(" ON  BASECURRENCY .FID =  COMPANY.FBaseCurrencyID ");
            badAcctLossDataSql.append(" LEFT OUTER JOIN T_ORG_Admin AS  ADMINORGUNIT  ");
            badAcctLossDataSql.append(" ON  OTHERBILL .FAdminOrgUnitID =  ADMINORGUNIT .FID ");
            badAcctLossDataSql.append(" LEFT OUTER JOIN T_BD_Person AS  PERSON  ");
            badAcctLossDataSql.append(" ON  OTHERBILL .FPersonId =  PERSON .FID ");
            badAcctLossDataSql.append(" WHERE (( ENTRY .FRecievePayAmount -  ENTRY .FLockVerifyAmt) > 0) AND  OTHERBILL .FBillStatus = 3 ");
            badAcctLossDataSql.append(" AND OTHERBILL.FCompanyID = '" + companyId + "'");
            if (!StringUtils.isEmpty((String)filter)) {
                badAcctLossDataSql.append(" AND ").append(filter);
            }
            if (arIsRltdAccunt) {
                badAcctLossDataSql.append(" AND (FFiVouchered = 1");
                badAcctLossDataSql.append(" OR OTHERBILL.FBillDate < {" + sdf.format(startPeriod.getBeginDate()) + "})");
            }
            if (index == companyIdSet.size()) continue;
            badAcctLossDataSql.append(" \r\n UNION ALL \r\n");
        }
        badAcctLossDataSql.append(")");
        badAcctLossDataSql.append(" as Temp");
        badAcctLossDataSql.append(" ORDER BY  ");
        badAcctLossDataSql.append(" COMPANYNUMBER  DESC, ");
        badAcctLossDataSql.append(" BILLNUMBER  DESC, ");
        badAcctLossDataSql.append(" ENTRYSEQ  ASC");
        Object startIndexStr = options.get("startIndex");
        Object endIndexStr = options.get("endIndex");
        if (startIndexStr != null && endIndexStr != null) {
            int startIndex = (Integer)startIndexStr;
            int endIndex = (Integer)endIndexStr;
            return DbUtil.executeQuery((Context)ctx, (String)badAcctLossDataSql.toString(), (int)(startIndex - 1), (int)(endIndex - (startIndex - 1)));
        }
        return DbUtil.executeQuery((Context)ctx, (String)badAcctLossDataSql.toString());
    }
}

