/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.AccountBadDebtException;
import com.kingdee.eas.fi.ar.app.AbstractBadAcctLossListUIHandler;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.framework.app.BaseFrameService;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import java.util.HashMap;
import java.util.Map;

public class BadAcctLossListUIHandler
extends AbstractBadAcctLossListUIHandler {
    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleInit(request, response, context);
        HashMap uiParam = (HashMap)request.get("uiParam");
        CompanyOrgUnitInfo currentCompany = (CompanyOrgUnitInfo)request.get("currentCompany");
        ArApSysParamInfo cache = ArApBillFacadeFactory.getLocalInstance((Context)context).getSysParams(currentCompany, uiParam);
        String badAccountEnum = this.getBadAccountEnum(cache, true);
        Map countBadDebtMethodOptions = cache.getBadAccountFacadeParams();
        this.getBadAcctPrepareAccount(context, countBadDebtMethodOptions, badAccountEnum);
    }

    @Override
    protected void _handleActionSave(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionAudit(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionGenVoucher(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    public String getBadAccountEnum(ArApSysParamInfo cache, boolean isBadAcct) throws Exception {
        String accuralParam = cache.getBadAccountFacadeAccuralParam();
        String badAccountEnum = null;
        if (cache.isDerectorTransferCancelMethod()) {
            badAccountEnum = "arap001002005";
        } else if (accuralParam.equalsIgnoreCase(String.valueOf(2))) {
            badAccountEnum = isBadAcct ? "arap001001002003" : "arap001002002004";
        } else if (accuralParam.equalsIgnoreCase(String.valueOf(5))) {
            badAccountEnum = isBadAcct ? "arap001001002001" : "arap001002002002";
        } else if (accuralParam.equalsIgnoreCase(String.valueOf(6))) {
            badAccountEnum = isBadAcct ? "arap001001002" : "arap001002002";
        } else if (accuralParam.equalsIgnoreCase(String.valueOf(3))) {
            badAccountEnum = isBadAcct ? "arap001001003" : "arap001002003";
        } else if (accuralParam.equalsIgnoreCase(String.valueOf(1))) {
            badAccountEnum = isBadAcct ? "arap001001001" : "arap001002001";
        }
        return badAccountEnum;
    }

    private AccountViewInfo getBadAcctPrepareAccount(Context ctx, Map countBadDebtMethodOptions, String key) throws BOSException, EASBizException {
        AccountViewInfo accountViewInfo = null;
        if (countBadDebtMethodOptions.get(key) != null && ((ParamItemInfo)countBadDebtMethodOptions.get(key)).getValue() != null && ((ParamItemInfo)countBadDebtMethodOptions.get(key)).getValue().toString().length() != 0) {
            accountViewInfo = BadAcctLossListUIHandler.getBadDebtPrepareAccount(ctx, countBadDebtMethodOptions, key);
        }
        return accountViewInfo;
    }

    public static AccountViewInfo getBadDebtPrepareAccount(Context ctx, Map value, String key) throws BOSException, EASBizException {
        AccountViewInfo account = null;
        if (value == null) {
            throw new IllegalArgumentException();
        }
        if (value.size() <= 0) {
            throw new IllegalArgumentException();
        }
        ParamItemInfo accountIDItem = null;
        accountIDItem = (ParamItemInfo)value.get(key);
        if (accountIDItem == null) {
            throw new AccountBadDebtException(AccountBadDebtException.PREPARE_SUBJECT_NOT_EXISTS);
        }
        String accountIDString = "";
        if (accountIDItem.getValue() != null) {
            accountIDString = accountIDItem.getValue();
        }
        if (accountIDString != null) {
            BOSUuid accountID = BOSUuid.read((String)accountIDString);
            ObjectUuidPK accountPK = new ObjectUuidPK(accountID);
            account = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)accountPK);
        }
        return account;
    }

    public void _handleAfterDataFill(RequestContext request, ResponseContext response, Context context) throws Exception {
        new BaseFrameService().batchRequestMutext(request, response, context);
    }

    public void _handleRefreshList(RequestContext request, ResponseContext response, Context context) throws Exception {
        new BaseFrameService().repleaseMutextControl(request, response, context);
    }
}

