/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.CAStmtQueryParam;
import com.kingdee.eas.fi.ar.app.ArApReportHelper;
import com.kingdee.eas.fi.ar.app.CaItemAp2PrerecTransSql;
import com.kingdee.eas.fi.ar.app.CaItemApApVPay_PaySql;
import com.kingdee.eas.fi.ar.app.CaItemApArVAp_ApSql;
import com.kingdee.eas.fi.ar.app.CaItemApBillSql;
import com.kingdee.eas.fi.ar.app.CaItemApPrePayVPreRec_PayVRecSql;
import com.kingdee.eas.fi.ar.app.CaItemApPreRecVPrePay_RecVPaySql;
import com.kingdee.eas.fi.ar.app.CaItemApTransSql;
import com.kingdee.eas.fi.ar.app.CaItemApVAr_ArSql;
import com.kingdee.eas.fi.ar.app.CaItemApVPay_ApVArSql;
import com.kingdee.eas.fi.ar.app.CaItemAr2PrepayTransSql;
import com.kingdee.eas.fi.ar.app.CaItemArBillSql;
import com.kingdee.eas.fi.ar.app.CaItemArPrePayVPreRec_PayVRecSql;
import com.kingdee.eas.fi.ar.app.CaItemArPreRecVPrePay_RecVPaySql;
import com.kingdee.eas.fi.ar.app.CaItemArTransSql;
import com.kingdee.eas.fi.ar.app.CaItemArVRec_ArVApSql;
import com.kingdee.eas.fi.ar.app.CaItemArVRec_RecSql;
import com.kingdee.eas.fi.ar.app.CaItemBadAcctSql;
import com.kingdee.eas.fi.ar.app.CaItemBadRecASql;
import com.kingdee.eas.fi.ar.app.CaItemBadRec_BadSql;
import com.kingdee.eas.fi.ar.app.CaItemBadRec_RecSql;
import com.kingdee.eas.fi.ar.app.CaItemPay2ArTransSql;
import com.kingdee.eas.fi.ar.app.CaItemPayBillSql;
import com.kingdee.eas.fi.ar.app.CaItemPayTransSql;
import com.kingdee.eas.fi.ar.app.CaItemRec2ApTransSql;
import com.kingdee.eas.fi.ar.app.CaItemRecBillSql;
import com.kingdee.eas.fi.ar.app.CaItemRecTransSql;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.sql.Date;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class CaStmtItemSqlBuilder {
    private static final Logger logger = Logger.getLogger(CaStmtItemSqlBuilder.class);
    protected static final int DATA_START = 0;
    protected static final int DATA_BILLS = 1;
    protected static final int DATA_TOTAL = 2;
    public static final String CTRL = " \r\n ";

    private CaStmtItemSqlBuilder() {
    }

    protected static String getCAItemDataSql(Context ctx, CAStmtQueryParam param, boolean fAR) throws BOSException, EASBizException {
        Locale locale = ctx.getLocale();
        String tempTable = param.getTempTable();
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(tempTable);
        sql.append("\r\n (FBillId, FBizAnalysisCode, ");
        sql.append(" FCussAcctId, FCurrencyId, FCurrency,");
        sql.append(" FBillDate, FBillType, FRecPayType, FBillNum,\r\n");
        sql.append(" FVoucherType, FVoucherNum, FDescription, FDebitAmt,");
        sql.append(" FDebitAmtLocal,FCreditAmt,FCreditAmtLocal, FBalanceAmt,FBalanceAmtLocal, FMainBillType, FDataType)\r\n");
        if (fAR) {
            sql.append(new CaItemArBillSql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemRecBillSql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            if (param.hasBadAcct()) {
                sql.append(new CaItemBadAcctSql().getItemQuerySql(param, locale));
                sql.append(CTRL).append(" union all ").append(CTRL);
                sql.append(new CaItemBadRecASql().getItemQuerySql(param, locale));
                sql.append(CTRL).append(" union all ").append(CTRL);
                sql.append(new CaItemBadRec_BadSql().getItemQuerySql(param, locale));
                sql.append(CTRL).append(" union all ").append(CTRL);
                sql.append(new CaItemBadRec_RecSql().getItemQuerySql(param, locale));
                sql.append(CTRL).append(" union all ").append(CTRL);
            }
            sql.append(new CaItemArVRec_ArVApSql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemArVRec_RecSql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemArPreRecVPrePay_RecVPaySql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemApVAr_ArSql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemArPrePayVPreRec_PayVRecSql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemArTransSql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemRecTransSql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemAr2PrepayTransSql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemRec2ApTransSql().getItemQuerySql(param, locale));
        } else {
            sql.append(new CaItemApBillSql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemPayBillSql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemApVPay_ApVArSql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemApApVPay_PaySql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemApPrePayVPreRec_PayVRecSql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemApArVAp_ApSql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemApPreRecVPrePay_RecVPaySql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemApTransSql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemPayTransSql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemAp2PrerecTransSql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemPay2ArTransSql().getItemQuerySql(param, locale));
        }
        logger.debug((Object)("caStmtItem sql:\r\n" + sql));
        return sql.toString();
    }

    protected static String getRemitCAItemDataSql(Context ctx, CAStmtQueryParam param, boolean fAR) throws BOSException, EASBizException {
        Locale locale = ctx.getLocale();
        String tempTable = param.getTempTable();
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(tempTable);
        sql.append("\r\n (FBillId, FBizAnalysisCode, ");
        sql.append(" FCussAcctId, FCurrencyId, FCurrency,");
        sql.append(" FBillDate, FBillType, FRecPayType, FBillNum,\r\n");
        sql.append(" FVoucherType, FVoucherNum, FDescription, FDebitAmt,");
        sql.append(" FDebitAmtLocal,FCreditAmt,FCreditAmtLocal, FBalanceAmt,FBalanceAmtLocal, FMainBillType, FDataType)\r\n");
        sql.append("select ");
        sql.append("\r\n tab.FBillId, tab.FBizAnalysisCode, ");
        sql.append(" tab.FCussAcctId, tab.FCurrencyId, tab.FCurrency,");
        sql.append(" tab.FBillDate, tab.FBillType, tab.FRecPayType, tab.FBillNum,\r\n");
        sql.append(" tab.FVoucherType, tab.FVoucherNum, tab.FDescription, sum(tab.FDebitAmt) FDebitAmt,");
        sql.append(" sum(tab.FDebitAmtLocal) FDebitAmtLocal,sum(tab.FCreditAmt) FCreditAmt,sum(tab.FCreditAmtLocal) FCreditAmtLocal, sum(tab.FBalanceAmt) FBalanceAmt,sum(tab.FBalanceAmtLocal) FBalanceAmtLocal, tab.FMainBillType, tab.FDataType \r\n from (");
        if (fAR) {
            sql.append(new CaItemArBillSql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemArBillSql().getRemitItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemRecBillSql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemRecBillSql().getRemitItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            if (param.hasBadAcct()) {
                sql.append(new CaItemBadAcctSql().getItemQuerySql(param, locale));
                sql.append(CTRL).append(" union all ").append(CTRL);
                sql.append(new CaItemBadRecASql().getItemQuerySql(param, locale));
                sql.append(CTRL).append(" union all ").append(CTRL);
                sql.append(new CaItemBadRec_BadSql().getItemQuerySql(param, locale));
                sql.append(CTRL).append(" union all ").append(CTRL);
                sql.append(new CaItemBadRec_RecSql().getItemQuerySql(param, locale));
                sql.append(CTRL).append(" union all ").append(CTRL);
            }
            sql.append(new CaItemArVRec_ArVApSql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemArVRec_RecSql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemArPreRecVPrePay_RecVPaySql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemApVAr_ArSql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemArPrePayVPreRec_PayVRecSql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemArTransSql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemArTransSql().getRemitItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemRecTransSql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemRecTransSql().getRemitItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemAr2PrepayTransSql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemAr2PrepayTransSql().getRemitItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemRec2ApTransSql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemRec2ApTransSql().getRemitItemQuerySql(param, locale));
        } else {
            sql.append(new CaItemApBillSql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemApBillSql().getRemitItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemPayBillSql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemPayBillSql().getRemitItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemApVPay_ApVArSql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemApApVPay_PaySql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemApPrePayVPreRec_PayVRecSql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemApArVAp_ApSql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemApPreRecVPrePay_RecVPaySql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemApTransSql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemApTransSql().getRemitItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemPayTransSql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemPayTransSql().getRemitItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemAp2PrerecTransSql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemAp2PrerecTransSql().getRemitItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemPay2ArTransSql().getItemQuerySql(param, locale));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemPay2ArTransSql().getRemitItemQuerySql(param, locale));
        }
        sql.append(" ) tab group by ");
        sql.append("\r\n tab.FBillId, tab.FBizAnalysisCode, ");
        sql.append(" tab.FCussAcctId, tab.FCurrencyId, tab.FCurrency,");
        sql.append(" tab.FBillDate, tab.FBillType, tab.FRecPayType, tab.FBillNum,\r\n");
        sql.append(" tab.FVoucherType, tab.FVoucherNum, tab.FDescription,tab.FMainBillType, tab.FDataType");
        logger.debug((Object)("caStmtItem sql:\r\n" + sql));
        return sql.toString();
    }

    protected static String getCAItemStartSql(CAStmtQueryParam param, PeriodInfo countArStartPeriod, PeriodInfo countApStartPeriod) throws BOSException, EASBizException {
        StringBuffer commonWhere = CaStmtItemSqlBuilder.getItemStartCommonWhere(param);
        String balType = String.valueOf(101);
        boolean fArRpt = param.isArRpt();
        if (fArRpt && param.hasBadAcct()) {
            balType = balType + ", " + 104;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select t2.FBizAnalysisCode, t1.FAsstActId FCussAcctId,");
        sql.append(" t1.FCurrencyId, sum(t1.FBeginBalanceFor) FAmt, sum(t1.FBeginBalanceLocal) FAmtLocal from ");
        sql.append(fArRpt ? "t_ar_arBalance" : "t_ap_apBalance");
        sql.append(" t1 inner join ").append(param.getCussAcctTempTable());
        sql.append(" t2 on t1.FAsstActId = t2.FId ");
        sql.append("\r\n where t1.FBalType IN (");
        if (param.isBizeCheckBox()) {
            if (param.getBizeIndex() == 0) {
                sql.append(balType + (param.isIncludeBizBill() ? ", 102" : "") + "," + 103);
            } else {
                sql.append(103);
            }
        } else {
            sql.append(balType + (param.isIncludeBizBill() ? ", 102" : ""));
        }
        sql.append(")").append(commonWhere).append(" and t1.FPeriodId = '");
        sql.append(fArRpt ? countArStartPeriod.getId() : countApStartPeriod.getId());
        sql.append("' group by t2.FBizAnalysisCode, t1.FAsstActId,");
        sql.append(" t1.FCurrencyId ");
        sql.append(CTRL).append(" union all ").append(CTRL);
        if (!fArRpt && param.hasBadAcct()) {
            balType = balType + ", " + 104;
        }
        sql.append(" select t2.FBizAnalysisCode, t1.FAsstActId FCussAcctId, ");
        sql.append(" t1.FCurrencyId,sum(-1 * t1.FBeginBalanceFor) FAmt,sum(-1 * t1.FBeginBalanceLocal) FAmtLocal from ");
        sql.append(fArRpt ? "t_ap_apBalance" : "t_ar_arBalance");
        sql.append(" t1 left join ").append(param.getCussAcctTempTable());
        sql.append(" t2 on t1.FAsstActId = t2.FId ");
        sql.append("\r\n where t1.FBalType IN (");
        if (param.isBizeCheckBox()) {
            if (param.getBizeIndex() == 0) {
                sql.append(balType + (param.isIncludeBizBill() ? ", 102" : "") + "," + 103);
            } else {
                sql.append(103);
            }
        } else {
            sql.append(balType + (param.isIncludeBizBill() ? ", 102" : ""));
        }
        sql.append(")").append(commonWhere).append(" and t1.FPeriodId = '");
        sql.append(fArRpt ? countApStartPeriod.getId() : countArStartPeriod.getId());
        sql.append("' group by t2.FBizAnalysisCode, t1.FAsstActId,");
        sql.append(" t1.FCurrencyId ");
        if (!param.hasBadAcct()) {
            sql.append("\r\n union all \r\n ");
            sql.append(CaStmtItemSqlBuilder.itemStartBadAcctBalanceSql(param));
        }
        sql.append(CaStmtItemSqlBuilder.itemStartBizAmtSql(param, countArStartPeriod, countApStartPeriod));
        return sql.toString();
    }

    private static StringBuffer getItemStartCommonWhere(CAStmtQueryParam param) {
        StringBuffer postfixSql = new StringBuffer();
        postfixSql.append("\r\n");
        if (!StringUtils.isEmpty((String)param.getAdminOrgIds())) {
            postfixSql.append(" and t1.FAdminOrgUnitId in (");
            postfixSql.append(param.getAdminOrgIds()).append(") \r\n");
        }
        if (!param.isAllCurrency()) {
            postfixSql.append(" and t1.FCurrencyId = '");
            postfixSql.append(param.getCurrencyId()).append("' ");
        }
        postfixSql.append(" and t1.FCompanyid = '");
        postfixSql.append(param.getCompanyId()).append("' \r\n");
        return postfixSql;
    }

    private static StringBuffer itemStartBizAmtSql(CAStmtQueryParam param, PeriodInfo countStartArPeriod, PeriodInfo countStartApPeriod) {
        boolean fApNeedCalc;
        StringBuffer sql = new StringBuffer();
        Date ctArStartPeriodBegin = new Date(countStartArPeriod.getBeginDate().getTime());
        Date ctApStartPeriodBegin = new Date(countStartApPeriod.getBeginDate().getTime());
        boolean fArNeedCalc = !DateTimeUtils.dayEquals((java.util.Date)param.getBeginDate(), (java.util.Date)ctArStartPeriodBegin);
        boolean bl = fApNeedCalc = !DateTimeUtils.dayEquals((java.util.Date)param.getBeginDate(), (java.util.Date)ctApStartPeriodBegin);
        if (!fArNeedCalc && !fApNeedCalc) {
            return sql;
        }
        Date queryBegin = param.getBeginDate();
        Date queryEnd = param.getEndDate();
        param.setEndDate(queryBegin);
        if (fArNeedCalc) {
            param.setBeginDate(ctArStartPeriodBegin);
            sql.append(" \r\n union all \r\n  ");
            sql.append("select t2.FBizAnalysisCode, t1.FCustomerId");
            sql.append(" FCussAcctId, t1.FCurrencyId, ");
            sql.append(param.isArRpt() ? " sum(t1.FReceiving) - sum(t1.FActual) " : " sum(t1.FActual) - sum(t1.FReceiving)  ");
            sql.append("FAmt, ");
            sql.append(param.isArRpt() ? " sum(t1.FReceivingLocal) - sum(t1.FActualLocal) " : " sum(t1.FActualLocal) - sum(t1.FReceivingLocal) ");
            sql.append("FAmtLocal from ");
            sql.append(CaStmtItemSqlBuilder.stmtViewDataSelectCopy(param, true));
            sql.append(" t1 left join ").append(param.getCussAcctTempTable());
            sql.append(" t2 on t1.FCustomerId = t2.FId ");
            sql.append(" group by t2.FBizAnalysisCode, t1.FCustomerId,");
            sql.append(" t1.FCurrencyId");
        }
        if (fApNeedCalc) {
            param.setBeginDate(ctApStartPeriodBegin);
            sql.append("\r\n union all \r\n ");
            sql.append("select t2.FBizAnalysisCode, t1.FSupplierId");
            sql.append(" FCussAcctId, t1.FCurrencyId, ");
            sql.append(param.isArRpt() ? " sum(t1.FActual) - sum(t1.FPayment) " : " sum(t1.FPayment) - sum(t1.FActual) ");
            sql.append("FAmt, ");
            sql.append(param.isArRpt() ? " sum(t1.FActualLocal) - sum(t1.FPaymentLocal) " : " sum(t1.FPaymentLocal) - sum(t1.FActualLocal) ");
            sql.append("FAmtLocal from ");
            sql.append(CaStmtItemSqlBuilder.stmtViewDataSelectCopy(param, false));
            sql.append(" t1 left join ").append(param.getCussAcctTempTable());
            sql.append(" t2 on t1.FSupplierId = t2.FId ");
            sql.append(" group by t2.FBizAnalysisCode, t1.FSupplierId,");
            sql.append(" t1.FCurrencyId");
        }
        param.setBeginDate(queryBegin);
        param.setEndDate(queryEnd);
        return sql;
    }

    private static StringBuffer itemStartBadAcctBalanceSql(CAStmtQueryParam param) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select t2.FBizAnalysisCode, t1.FAcctCussentID FCussAcctId,");
        sql.append(" t1.FCurrencyId, ").append(param.isArRpt() ? " " : "-1 * ");
        sql.append("sum(t1.FAmounts) FAmt");
        sql.append(",sum(t1.FAmountsLocal) FAmtLocal");
        sql.append("\r\n from T_AR_InitBadAccount t1 ");
        sql.append(" left join ").append(param.getCussAcctTempTable());
        sql.append(" t2 on t1.FAcctCussentID = t2.FId ");
        sql.append("\r\n where 1= 1 ");
        sql.append(" and t1.FAcctCussentID in (select FId from ");
        sql.append(param.getCussAcctTempTable()).append(") ");
        if (!param.isAllCurrency()) {
            sql.append("\r\n and t1.FCurrencyId = '");
            sql.append(param.getCurrencyId()).append("' ");
        }
        if (!StringUtils.isEmpty((String)param.getAdminOrgIds())) {
            sql.append(" and t1.FAdminOrgUnitId in (");
            sql.append(param.getAdminOrgIds()).append(")");
        }
        sql.append(" and t1.FCompanyid = '").append(param.getCompanyId());
        sql.append("' \r\n group by t2.FBizAnalysisCode, t1.FAcctCussentID,");
        sql.append(" t1.FCurrencyId");
        return sql;
    }

    protected static String getCAStmtSql(Context ctx, CAStmtQueryParam param, PeriodInfo countStartArPeriod, PeriodInfo countStartApPeriod) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder(500);
        sql.append(" insert into ").append(param.getTempTable()).append(CTRL);
        sql.append(" (FCurrency,FCurrencyLocal, ");
        sql.append(param.isCustSupplAcctCuss() ? "FBizAnalysisCode, " : "");
        sql.append(" FCussTypeId, FCussType, FCussNum, FCussName, ");
        sql.append("FCussAcctId, FCurrencyId\r\n, FStartBalanceAmt, FStartBalanceAmtLocal, ");
        sql.append("FDebitAmt, FDebitAmtLocal, FCreditAmt, FCreditAmtLocal, FBalanceAmt, FBalanceAmtLocal )").append(CTRL);
        sql.append(CaStmtItemSqlBuilder.queryStartBalanceSql(ctx, param, countStartArPeriod, countStartApPeriod));
        sql.append(CTRL).append(" union all ").append(CTRL);
        sql.append(CaStmtItemSqlBuilder.stmtBizAmtSql(ctx, param, true));
        sql.append(CTRL).append(" union all ").append(CTRL);
        sql.append(CaStmtItemSqlBuilder.stmtBizAmtSql(ctx, param, false));
        return sql.toString();
    }

    private static String queryStartBalanceSql(Context ctx, CAStmtQueryParam param, PeriodInfo countStartArPeriod, PeriodInfo countStartApPeriod) throws BOSException, EASBizException {
        boolean fApNeedCalc;
        String nameFld = ArApReportHelper.getNameFld(ctx);
        List rptFlds = param.getReportFields();
        boolean fCusSupp = param.isCustSupplAcctCuss();
        StringBuilder sql = new StringBuilder(200);
        String balType = String.valueOf(101);
        boolean fArRpt = param.isArRpt();
        if (fArRpt && param.hasBadAcct()) {
            balType = balType + ", " + 104;
        }
        sql.append(" select ");
        sql.append(CaStmtItemSqlBuilder.getStmtSqlFlds(rptFlds, nameFld, fCusSupp, false));
        sql.append(" from ");
        sql.append(param.isArRpt() ? "t_ar_arBalance" : "t_ap_apBalance");
        sql.append(" t1 left join t_bd_AsstActType t2 on t2.FId =");
        sql.append(" t1.FAsstActTypeId").append(CTRL);
        sql.append(" inner join ").append(param.getCussAcctTempTable());
        sql.append(" t3 on t3.FId = t1.FAsstActId");
        sql.append(" left join t_bd_currency t4 on t4.FId = t1.FCurrencyId ");
        sql.append(CTRL).append(" where 1 = 1 and FBalType IN (");
        if (param.isBizeCheckBox()) {
            if (param.getBizeIndex() == 0) {
                sql.append(balType + (param.isIncludeBizBill() ? ", 102" : "") + "," + 103);
            } else {
                sql.append(103);
            }
        } else {
            sql.append(balType + (param.isIncludeBizBill() ? ", 102" : ""));
        }
        sql.append(")");
        sql.append(CaStmtItemSqlBuilder.getStmtClause(param, param.isArRpt() ? countStartArPeriod.getId().toString() : countStartApPeriod.getId().toString(), nameFld));
        sql.append(CTRL).append(" union all ").append(CTRL).append(" select ");
        sql.append(CaStmtItemSqlBuilder.getStmtSqlFlds(rptFlds, nameFld, fCusSupp, true));
        sql.append(" from ");
        sql.append(param.isArRpt() ? "t_ap_apBalance" : "t_ar_arBalance");
        sql.append(" t1 left join t_bd_AsstActType t2 on t2.FId = ");
        sql.append(" t1.FAsstActTypeId").append(CTRL);
        sql.append(" inner join ").append(param.getCussAcctTempTable());
        sql.append(" t3 on t3.FId = t1.FAsstActId");
        sql.append(" left join t_bd_currency t4 on t4.FId = t1.FCurrencyId ");
        if (!fArRpt && param.hasBadAcct()) {
            balType = balType + ", " + 104;
        }
        sql.append(CTRL).append(" where 1 = 1  and FBalType IN (");
        if (param.isBizeCheckBox()) {
            if (param.getBizeIndex() == 0) {
                sql.append(balType + (param.isIncludeBizBill() ? ", 102" : "") + "," + 103);
            } else {
                sql.append(103);
            }
        } else {
            sql.append(balType + (param.isIncludeBizBill() ? ", 102" : ""));
        }
        sql.append(")");
        sql.append(CaStmtItemSqlBuilder.getStmtClause(param, param.isArRpt() ? countStartApPeriod.getId().toString() : countStartArPeriod.getId().toString(), nameFld));
        if (!param.hasBadAcct() && fCusSupp) {
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(CaStmtItemSqlBuilder.stmtStartBadAcctBalanceSql(ctx, param, rptFlds));
        }
        Date ctArStartPeriodBegin = new Date(countStartArPeriod.getBeginDate().getTime());
        Date ctApStartPeriodBegin = new Date(countStartApPeriod.getBeginDate().getTime());
        boolean fArNeedCalc = !DateTimeUtils.dayEquals((java.util.Date)param.getBeginDate(), (java.util.Date)ctArStartPeriodBegin);
        boolean bl = fApNeedCalc = !DateTimeUtils.dayEquals((java.util.Date)param.getBeginDate(), (java.util.Date)ctApStartPeriodBegin);
        if (fArNeedCalc || fApNeedCalc) {
            Date queryBegin = param.getBeginDate();
            Date queryEnd = param.getEndDate();
            param.setEndDate(queryBegin);
            if (fArNeedCalc) {
                param.setBeginDate(ctArStartPeriodBegin);
                sql.append(CTRL).append(" union all ").append(CTRL);
                sql.append(CaStmtItemSqlBuilder.stmtStartAmtSql(ctx, param, true));
            }
            if (fApNeedCalc) {
                param.setBeginDate(ctApStartPeriodBegin);
                sql.append(CTRL).append(" union all ").append(CTRL);
                sql.append(CaStmtItemSqlBuilder.stmtStartAmtSql(ctx, param, false));
            }
            param.setBeginDate(queryBegin);
            param.setEndDate(queryEnd);
        }
        return sql.toString();
    }

    private static StringBuffer getStmtSqlFlds(List rptFlds, String nameFld, boolean fCusSupp, boolean fNegative) {
        StringBuffer sql = new StringBuffer(200);
        int index = 0;
        sql.append(" t4.").append(nameFld).append(rptFlds.get(index++));
        sql.append(", N'' ").append(rptFlds.get(index++));
        if (fCusSupp) {
            sql.append(", t3.FBizAnalysisCode ").append(rptFlds.get(index++));
        }
        sql.append(", t2.FId ").append(rptFlds.get(index++));
        sql.append(", t2.").append(nameFld).append(rptFlds.get(index++));
        sql.append(CTRL).append(", t3.FNumber ").append(rptFlds.get(index++));
        sql.append(", t3.").append(nameFld).append(rptFlds.get(index++));
        sql.append(", t3.FId ").append(rptFlds.get(index++));
        sql.append(", t1.FCurrencyId ").append(rptFlds.get(index++));
        sql.append(CTRL).append(", ").append(fNegative ? "-1 * " : " ");
        sql.append("sum(t1.FBeginBalanceFor) ").append(rptFlds.get(index++));
        sql.append(" , ").append(fNegative ? "-1 * " : " ");
        sql.append("sum(t1.FBeginBalanceLocal) ").append(rptFlds.get(index++));
        sql.append(", 0 ").append(rptFlds.get(index++));
        sql.append(", 0 ").append(rptFlds.get(index++));
        sql.append(", 0 ").append(rptFlds.get(index++));
        sql.append(", 0 ").append(rptFlds.get(index++));
        sql.append(", 0 ").append(rptFlds.get(index++));
        sql.append(", 0 ").append(rptFlds.get(index++));
        sql.append(CTRL);
        return sql;
    }

    private static StringBuffer stmtStartBadAcctBalanceSql(Context ctx, CAStmtQueryParam param, List rptFlds) throws BOSException, EASBizException {
        String nameFld = ArApReportHelper.getNameFld(ctx);
        boolean fCusSupp = param.isCustSupplAcctCuss();
        StringBuffer sql = new StringBuffer();
        int index = 0;
        sql.append(" select ");
        sql.append(" t4.").append(nameFld).append(rptFlds.get(index++));
        sql.append(", N'' ").append(rptFlds.get(index++));
        if (fCusSupp) {
            sql.append(", t3.FBizAnalysisCode ").append(rptFlds.get(index++));
        }
        sql.append(", t2.FId ").append(rptFlds.get(index++));
        sql.append(", t2.").append(nameFld).append(rptFlds.get(index++));
        sql.append("\r\n, t3.FNumber ").append(rptFlds.get(index++));
        sql.append(", t3.").append(nameFld).append(rptFlds.get(index++));
        sql.append(", t3.FId ").append(rptFlds.get(index++));
        sql.append(", t1.FCurrencyId ").append(rptFlds.get(index++));
        sql.append("\r\n, ").append(param.isArRpt() ? " " : "-1 * ");
        sql.append("sum(t1.FAmounts) ").append(rptFlds.get(index++));
        sql.append(" , ").append(param.isArRpt() ? " " : "-1 * ");
        sql.append("sum(t1.FAmountsLocal) ").append(rptFlds.get(index++));
        sql.append(", 0 ").append(rptFlds.get(index++));
        sql.append(", 0 ").append(rptFlds.get(index++));
        sql.append(", 0 ").append(rptFlds.get(index++));
        sql.append(", 0 ").append(rptFlds.get(index++));
        sql.append(", 0 ").append(rptFlds.get(index++));
        sql.append(", 0 ").append(rptFlds.get(index++));
        sql.append("\r\n  from T_AR_InitBadAccount t1 left join t_bd_AsstActType t2");
        sql.append(" on t2.FId = t1.FAsstActTypeID\r\n");
        sql.append(" left join ").append(param.getCussAcctTempTable());
        sql.append(" t3 on t3.FId = t1.FAcctCussentID\r\n");
        sql.append(" left join t_bd_currency t4 on t4.FId = t1.FCurrencyId ");
        sql.append("\r\n where 1= 1 and t1.FAcctCussentID");
        sql.append(" in (select FId from ");
        sql.append(param.getCussAcctTempTable()).append(")\r\n");
        sql.append(" and (t1.FAsstActTypeID = '");
        sql.append(param.getCussTypeId());
        if (!StringUtils.isEmpty((String)param.getOtherTypeId())) {
            sql.append("' or t1.FAsstActTypeID = '");
            sql.append(param.getOtherTypeId());
        }
        sql.append("') ");
        if (!"base".equalsIgnoreCase(param.getCurrencyId()) && !param.isAllCurrency()) {
            sql.append("\r\n and t1.FCurrencyId = '");
            sql.append(param.getCurrencyId()).append("' ");
        }
        if (!StringUtils.isEmpty((String)param.getAdminOrgIds())) {
            sql.append(" and t1.FAdminOrgUnitId in (");
            sql.append(param.getAdminOrgIds()).append(")");
        }
        sql.append(" and t1.FCompanyid = '").append(param.getCompanyId());
        sql.append("' \r\n group by ");
        sql.append(fCusSupp ? "t3.FBizAnalysisCode, " : "");
        sql.append(" t2.FId, t2.").append(nameFld);
        sql.append(", t3.FNumber, t3.").append(nameFld);
        sql.append(", t3.FId, t4.").append(nameFld);
        sql.append(", t1.FCurrencyId");
        return sql;
    }

    private static StringBuffer getStmtClause(CAStmtQueryParam param, String countStartPeriodId, String nameFld) {
        boolean fCusSupp = param.isCustSupplAcctCuss();
        StringBuffer sql = new StringBuffer(200);
        sql.append(" and (t1.FAsstActTypeId = '");
        sql.append(param.getCussTypeId());
        if (!StringUtils.isEmpty((String)param.getOtherTypeId())) {
            sql.append("' or t1.FAsstActTypeId = '");
            sql.append(param.getOtherTypeId());
        }
        sql.append("') ");
        if (!"base".equalsIgnoreCase(param.getCurrencyId()) && !param.isAllCurrency()) {
            sql.append("\r\n and t1.FCurrencyId = '");
            sql.append(param.getCurrencyId()).append("' ");
        }
        if (!StringUtils.isEmpty((String)param.getAdminOrgIds())) {
            sql.append(" and t1.FAdminOrgUnitId in (");
            sql.append(param.getAdminOrgIds()).append(")");
        }
        sql.append(" and t1.FCompanyid = '").append(param.getCompanyId());
        sql.append("' \r\n and t1.FPeriodId = '");
        sql.append(countStartPeriodId);
        sql.append("' \r\n group by ");
        sql.append(fCusSupp ? "t3.FBizAnalysisCode, " : "");
        sql.append(" t2.FId, t2.").append(nameFld);
        sql.append(", t3.FNumber, t3.").append(nameFld);
        sql.append(", t1.FAsstActId, t4.").append(nameFld);
        sql.append(", t1.FCurrencyId, t3.FId");
        return sql;
    }

    private static String stmtBizAmtSql(Context ctx, CAStmtQueryParam param, boolean fAR) {
        String nameFld = ArApReportHelper.getNameFld(ctx);
        int index = 0;
        List rptFlds = param.getReportFields();
        boolean fCusSupp = param.isCustSupplAcctCuss();
        String fldArAp = "";
        String fldArApLocal = "";
        String fldActual = "";
        String fldActualLocal = "";
        if (param.isArRpt()) {
            fldArAp = fAR ? "FReceiving" : "FActual";
            fldArApLocal = fAR ? "FReceivingLocal" : "FActualLocal";
            fldActual = fAR ? "FActual" : "FPayment";
            fldActualLocal = fAR ? "FActualLocal" : "FPaymentLocal";
        } else {
            fldArAp = fAR ? "FActual" : "FPayment";
            fldArApLocal = fAR ? "FActualLocal" : "FPaymentLocal";
            fldActual = fAR ? "FReceiving" : "FActual";
            fldActualLocal = fAR ? "FReceivingLocal" : "FActualLocal";
        }
        StringBuffer sql = new StringBuffer(200);
        sql.append(" select ");
        sql.append("t4.").append(nameFld).append(rptFlds.get(index++));
        sql.append(",N'' ").append(rptFlds.get(index++));
        if (fCusSupp) {
            sql.append(", t3.FBizAnalysisCode ").append(rptFlds.get(index++));
        }
        sql.append(", t2.FId ").append(rptFlds.get(index++));
        sql.append("\r\n, t2.").append(nameFld).append(rptFlds.get(index++));
        sql.append(", t3.FNumber ").append(rptFlds.get(index++));
        sql.append(", t3.").append(nameFld).append(rptFlds.get(index++));
        sql.append(", t3.FId ").append(rptFlds.get(index++));
        sql.append("\r\n, t4.FId ").append(rptFlds.get(index++));
        sql.append(", 0 ").append(rptFlds.get(index++));
        sql.append(", 0 ").append(rptFlds.get(index++));
        sql.append(", sum(t1.").append(fldArAp).append(") ").append(rptFlds.get(index++));
        sql.append(", sum(t1.").append(fldArApLocal).append(") ").append(rptFlds.get(index++));
        sql.append(", sum(t1.").append(fldActual).append(") ").append(rptFlds.get(index++));
        sql.append(", sum(t1.").append(fldActualLocal).append(") ").append(rptFlds.get(index++));
        sql.append(", 0 ").append(rptFlds.get(index++));
        sql.append(", 0 ").append(rptFlds.get(index++));
        sql.append(" \r\n from ");
        sql.append(CaStmtItemSqlBuilder.stmtViewDataSelectCopy(param, fAR));
        sql.append(" t1 left join t_bd_AsstActType t2 on t2.FId = t1.FAsstActTypeId");
        sql.append("\r\n left join ").append(param.getCussAcctTempTable());
        sql.append(" t3 on t3.FId = t1.").append(fAR ? "FCustomerId" : "FSupplierId");
        sql.append(" left join t_bd_currency t4 on t4.FId = t1.FCurrencyId ");
        sql.append(" \r\n group by ");
        sql.append(fCusSupp ? "t3.FBizAnalysisCode, " : "");
        sql.append(" t2.FId, t2.").append(nameFld);
        sql.append(", t3.FNumber, t3.").append(nameFld);
        sql.append(", t3.FId, t4.").append(nameFld).append(", t4.FId");
        return sql.toString();
    }

    private static String stmtStartAmtSql(Context ctx, CAStmtQueryParam param, boolean fAR) throws BOSException, EASBizException {
        String nameFld = ArApReportHelper.getNameFld(ctx);
        int index = 0;
        List rptFlds = param.getReportFields();
        boolean fCusSupp = param.isCustSupplAcctCuss();
        String fldStart = "";
        String fldStartLocal = "";
        if (param.isArRpt() && fAR) {
            fldStart = " sum(FReceiving) - sum(FActual) ";
            fldStartLocal = " sum(FReceivingLocal) - sum(FActualLocal) ";
        } else if (param.isArRpt() && !fAR) {
            fldStart = " sum(FActual) - sum(FPayment) ";
            fldStartLocal = " sum(FActualLocal) - sum(FPaymentLocal) ";
        } else if (!param.isArRpt() && fAR) {
            fldStart = " sum(FActual) - sum(FReceiving) ";
            fldStartLocal = " sum(FActualLocal) - sum(FReceivingLocal) ";
        } else if (!param.isArRpt() && !fAR) {
            fldStart = " sum(FPayment) - sum(FActual) ";
            fldStartLocal = " sum(FPaymentLocal) - sum(FActualLocal) ";
        }
        StringBuilder sql = new StringBuilder(200);
        sql.append(" select ");
        sql.append("t4.").append(nameFld).append(rptFlds.get(index++));
        sql.append(", N'' ").append(rptFlds.get(index++));
        if (fCusSupp) {
            sql.append(", t3.FBizAnalysisCode ").append(rptFlds.get(index++));
        }
        sql.append(", t2.FId ").append(rptFlds.get(index++));
        sql.append(", t2.").append(nameFld).append(rptFlds.get(index++));
        sql.append(CTRL).append(", t3.FNumber ").append(rptFlds.get(index++));
        sql.append(", t3.").append(nameFld).append(rptFlds.get(index++));
        sql.append(", t3.FId ").append(rptFlds.get(index++));
        sql.append(", t4.FId ").append(rptFlds.get(index++));
        sql.append(CTRL).append(", ").append(fldStart).append(rptFlds.get(index++));
        sql.append(" , ").append(fldStartLocal).append(rptFlds.get(index++));
        sql.append(", 0 ").append(rptFlds.get(index++));
        sql.append(", 0 ").append(rptFlds.get(index++));
        sql.append(", 0 ").append(rptFlds.get(index++));
        sql.append(", 0 ").append(rptFlds.get(index++));
        sql.append(", 0 ").append(rptFlds.get(index++));
        sql.append(", 0 ").append(rptFlds.get(index++));
        sql.append(CTRL).append(" from ");
        sql.append(CaStmtItemSqlBuilder.stmtViewDataSelectCopy(param, fAR));
        sql.append(" t1 left join t_bd_AsstActType t2 on t2.FId =");
        sql.append(" t1.FAsstActTypeId\r\n");
        sql.append(" left join ").append(param.getCussAcctTempTable());
        sql.append(" t3 on t3.FId = t1.");
        sql.append(fAR ? "FCustomerId" : "FSupplierId");
        sql.append(" left join t_bd_currency t4 on t4.FId = t1.FCurrencyId ");
        sql.append("\r\n group by ");
        sql.append(fCusSupp ? "t3.FBizAnalysisCode, " : "");
        sql.append(" t2.FId, t2.").append(nameFld);
        sql.append(", t3.FNumber, t3.").append(nameFld);
        sql.append(", t3.FId, t4.").append(nameFld).append(", t4.FId");
        return sql.toString();
    }

    protected static StringBuffer delBizZeroSql(String tempTable, boolean fItemRpt) {
        StringBuffer delSql = new StringBuffer();
        if (fItemRpt) {
            delSql.append("delete from ").append(tempTable);
            delSql.append(" where FCurrency in (select FCurrency");
            delSql.append(" from ").append(tempTable);
            delSql.append(" where FDebitAmt = 0  and FCreditAmt = 0 ");
            delSql.append("and FDataType = 2)");
        } else {
            delSql.append("delete from ").append(tempTable);
            delSql.append(" where FCurrency = ? and FCussNum = ? ");
            delSql.append(" and FIsFinal = 1");
        }
        return delSql;
    }

    protected static StringBuffer delBalZeroSql(String tempTable, boolean fItemRpt) {
        StringBuffer delSql = new StringBuffer();
        if (fItemRpt) {
            delSql.append("delete from ").append(tempTable);
            delSql.append(" where FCurrency in \r\n(select ");
            delSql.append(" t1.FCurrency from (select FCurrency,");
            delSql.append(" FBalanceAmt from ");
            delSql.append(tempTable);
            delSql.append(" where FDataType = 0) t1 ");
            delSql.append("\r\n left join (select FCurrency,");
            delSql.append(" FDebitAmt, FCreditAmt from ");
            delSql.append(tempTable);
            delSql.append(" where FDataType = 2) t2 on ");
            delSql.append(" t1.FCurrency = t2.FCurrency \r\n ");
            delSql.append("where (t1.FBalanceAmt + ");
            delSql.append(" t2.FDebitAmt -  t2.FCreditAmt ) = 0 )");
        } else {
            delSql.append("delete from ").append(tempTable);
            delSql.append(" where FCurrency = ? and FCussNum = ? ");
            delSql.append(" and FIsFinal = 1");
        }
        return delSql;
    }

    private static StringBuffer stmtViewDataSelect(CAStmtQueryParam param, boolean fAR) {
        StringBuffer sql = new StringBuffer();
        sql.append("\r\n (");
        if (fAR) {
            sql.append(new CaItemArBillSql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemRecBillSql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            if (param.hasBadAcct()) {
                sql.append(new CaItemBadAcctSql().getStmtQuerySql(param));
                sql.append(CTRL).append(" union all ").append(CTRL);
                sql.append(new CaItemBadRecASql().getStmtQuerySql(param));
                sql.append(CTRL).append(" union all ").append(CTRL);
                sql.append(new CaItemBadRec_BadSql().getStmtQuerySql(param));
                sql.append(CTRL).append(" union all ").append(CTRL);
                sql.append(new CaItemBadRec_RecSql().getStmtQuerySql(param));
                sql.append(CTRL).append(" union all ").append(CTRL);
            }
            sql.append(new CaItemArVRec_ArVApSql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemArVRec_RecSql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemArPreRecVPrePay_RecVPaySql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemApVAr_ArSql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemArPrePayVPreRec_PayVRecSql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemArTransSql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemRecTransSql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemAr2PrepayTransSql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemRec2ApTransSql().getStmtQuerySql(param));
        } else {
            sql.append(new CaItemApBillSql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemPayBillSql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemApVPay_ApVArSql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemApApVPay_PaySql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemApPrePayVPreRec_PayVRecSql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemApArVAp_ApSql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemApPreRecVPrePay_RecVPaySql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemApTransSql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemPayTransSql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemAp2PrerecTransSql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemPay2ArTransSql().getStmtQuerySql(param));
        }
        sql.append("\r\n ) ");
        return sql;
    }

    private static StringBuffer stmtViewDataSelectCopy(CAStmtQueryParam param, boolean fAR) {
        StringBuffer sql = new StringBuffer();
        sql.append(CTRL).append(" (");
        if (fAR) {
            sql.append(new CaItemArBillSql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemArBillSql().getRemitStmtQuerySqlCopy(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemRecBillSql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemRecBillSql().getRemitStmtQuerySqlCopy(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            if (param.hasBadAcct()) {
                sql.append(new CaItemBadAcctSql().getStmtQuerySql(param));
                sql.append(CTRL).append(" union all ").append(CTRL);
                sql.append(new CaItemBadRecASql().getStmtQuerySql(param));
                sql.append(CTRL).append(" union all ").append(CTRL);
                sql.append(new CaItemBadRec_BadSql().getStmtQuerySql(param));
                sql.append(CTRL).append(" union all ").append(CTRL);
                sql.append(new CaItemBadRec_RecSql().getStmtQuerySql(param));
                sql.append(CTRL).append(" union all ").append(CTRL);
            }
            sql.append(new CaItemArVRec_ArVApSql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemArVRec_RecSql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemArPreRecVPrePay_RecVPaySql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemApVAr_ArSql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemArPrePayVPreRec_PayVRecSql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemArTransSql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemArTransSql().getRemitStmtQuerySqlCopy(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemRecTransSql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemRecTransSql().getRemitStmtQuerySqlCopy(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemAr2PrepayTransSql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemAr2PrepayTransSql().getRemitStmtQuerySqlCopy(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemRec2ApTransSql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemRec2ApTransSql().getRemitStmtQuerySql(param));
        } else {
            sql.append(new CaItemApBillSql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemApBillSql().getRemitStmtQuerySqlCopy(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemPayBillSql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemPayBillSql().getRemitStmtQuerySqlCopy(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemApVPay_ApVArSql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemApApVPay_PaySql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemApPrePayVPreRec_PayVRecSql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemApArVAp_ApSql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemApPreRecVPrePay_RecVPaySql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemApTransSql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemApTransSql().getRemitStmtQuerySqlCopy(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemPayTransSql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemPayTransSql().getRemitStmtQuerySqlCopy(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemAp2PrerecTransSql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemAp2PrerecTransSql().getRemitStmtQuerySqlCopy(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemPay2ArTransSql().getStmtQuerySql(param));
            sql.append(CTRL).append(" union all ").append(CTRL);
            sql.append(new CaItemPay2ArTransSql().getRemitStmtQuerySql(param));
        }
        sql.append(CTRL).append(" ) ");
        return sql;
    }
}

