/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountControlAttribute;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.app.AbstractContrastAccountViewControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class ContrastAccountViewControllerBean
extends AbstractContrastAccountViewControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.ar.app.ContrastAccountViewControllerBean");
    private static final String CR = "\r\t";

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CacheServiceFactory.getInstance().discardQuery((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.ar.app.F7AccountViewQuery"));
        return super._submit(ctx, model);
    }

    @Override
    protected IObjectCollection _getControlAccountView(Context ctx, int system, IObjectValue company, String accountTableID) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)company;
        IAccountView iAccountView = AccountViewFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        view.getSorter().add(new SorterItemInfo("number"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemInfo cuFilterItemInfo = new FilterItemInfo("company.id", (Object)companyInfo.getId().toString());
        filter.getFilterItems().add(cuFilterItemInfo);
        FilterItemInfo isGFreezeFilterItemInfo = new FilterItemInfo("isGFreeze", (Object)new Integer(0));
        filter.getFilterItems().add(isGFreezeFilterItemInfo);
        FilterItemInfo isCFreezeFilterItemInfo = new FilterItemInfo("isCFreeze", (Object)new Integer(0));
        filter.getFilterItems().add(isCFreezeFilterItemInfo);
        FilterItemInfo leafFilterItemInfo = new FilterItemInfo("isLeaf", (Object)new Integer(1));
        filter.getFilterItems().add(leafFilterItemInfo);
        FilterItemInfo controlFilterItemInfo = new FilterItemInfo("control", (Object)new Integer(system));
        filter.getFilterItems().add(controlFilterItemInfo);
        StringBuffer mask = new StringBuffer("");
        mask.append("#0 and #1 and #2 and #3 and #4");
        if (StringUtils.isEmpty((String)accountTableID)) {
            accountTableID = companyInfo.getAccountTable().getId().toString();
        }
        FilterItemInfo accountTalbeFilterItemInfo = new FilterItemInfo("accountTableID.id", (Object)accountTableID);
        filter.getFilterItems().add(accountTalbeFilterItemInfo);
        mask.append(" and #5 ");
        filter.setMaskString(mask.toString());
        view.setFilter(filter);
        return iAccountView.getAccountViewCollection(view);
    }

    @Override
    protected boolean _existAccouSettle(Context ctx, String companyID, String accountID, int system) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("");
        sql.append("select fid from ");
        if (system == 1) {
            sql.append(" T_AR_ArBalanceCollate ");
        } else {
            sql.append(" T_AP_ApBalanceCollate ");
        }
        sql.append(" where fcompanyid = ? and faccount = ? ");
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        boolean value = false;
        try {
            con = this.getConnection(ctx);
            ps = con.prepareStatement(sql.toString());
            ps.setString(1, companyID);
            ps.setString(2, accountID);
            rs = ps.executeQuery();
            if (rs.next()) {
                value = true;
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return value;
    }

    @Override
    protected IRowSet _getAccountView(Context ctx, int system, IObjectValue company, String accountTableID, int periodYear, int periodNumber) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)company;
        StringBuffer sql = new StringBuffer("");
        sql.append("SELECT contrastAccountView.FID AS FID,").append(CR);
        sql.append("contrastAccountView.FAccountID AS FAccountID, ").append(CR);
        sql.append("contrastAccountView.FDataDirection as FDataDirection,").append(CR);
        sql.append("contrastAccountView.FAsstActTypeID as fAsstActTypeID,").append(CR);
        sql.append("contrastAccountView.FPeriodYear as FPeriodYear,").append(CR);
        sql.append("contrastAccountView.FPeriodNumber as FPeriodNumber, ").append(CR);
        sql.append("contrastAccountView.FisContrast as FisContrast ").append(CR);
        sql.append(" FROM T_AR_ContrastAccountView AS contrastAccountView ").append(CR);
        sql.append(" INNER JOIN T_BD_AccountView AS account ").append(CR);
        sql.append(" ON contrastAccountView.FAccountID = account.FID ").append(CR);
        sql.append(" where  contrastAccountView.FCompanyID = '").append(companyInfo.getId().toString()).append("'").append(CR);
        sql.append(" and contrastAccountView.FControlUnitID = '").append(companyInfo.getCU().getId().toString()).append("'").append(CR);
        sql.append(" and contrastAccountView.FSystem = ").append(String.valueOf(system)).append(CR);
        if (accountTableID != null && !"".equals(accountTableID)) {
            sql.append(" and contrastAccountView.FAccountTableID = '").append(accountTableID).append("'").append(CR);
        } else if (companyInfo.getAccountTable() != null) {
            sql.append(" and contrastAccountView.FAccountTableID = '").append(companyInfo.getAccountTable().getId().toString()).append("'").append(CR);
        }
        sql.append(" and contrastAccountView.FPeriodYear = ").append(String.valueOf(periodYear)).append(CR);
        sql.append(" and contrastAccountView.FPeriodNumber = ").append(String.valueOf(periodNumber)).append(CR);
        sql.append(" ORDER BY account.FNumber ASC ").append(CR);
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    @Override
    protected IObjectCollection _getContrastAccount(Context ctx, int system, IObjectValue company, String accountTableID, int periodYear, int periodNumber, boolean isCloseAccount) throws BOSException, EASBizException {
        String lang = ctx.getLocale().getLanguage();
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)company;
        StringBuffer sql = new StringBuffer(300);
        sql.append("SELECT account.FID AS FID").append(CR);
        sql.append(" ,account.FNumber AS FNumber").append(CR);
        sql.append(" ,account.FName_").append(lang).append(" AS FName").append(CR);
        sql.append(" ,account.FCAA").append(" AS FCAA").append(CR);
        sql.append(" FROM T_AR_ContrastAccountView AS contrastAccountView ").append(CR);
        sql.append(" INNER JOIN T_BD_AccountView AS account ").append(CR);
        sql.append(" ON contrastAccountView.FAccountID = account.FID ").append(CR);
        sql.append(" where  contrastAccountView.FCompanyID = '").append(companyInfo.getId().toString()).append("'").append(CR);
        sql.append(" and contrastAccountView.FControlUnitID = '").append(companyInfo.getCU().getId().toString()).append("'").append(CR);
        sql.append(" and contrastAccountView.FSystem = ").append(String.valueOf(system)).append(CR);
        if (!isCloseAccount) {
            sql.append(" and contrastAccountView.FisContrast = 1").append(CR);
        }
        if (accountTableID != null && !"".equals(accountTableID)) {
            sql.append(" and contrastAccountView.FAccountTableID = '").append(accountTableID).append("'").append(CR);
        } else if (companyInfo.getAccountTable() != null) {
            sql.append(" and contrastAccountView.FAccountTableID = '").append(companyInfo.getAccountTable().getId().toString()).append("'").append(CR);
        }
        sql.append(" and contrastAccountView.FPeriodYear = ").append(String.valueOf(periodYear)).append(CR);
        sql.append(" and contrastAccountView.FPeriodNumber = ").append(String.valueOf(periodNumber)).append(CR);
        sql.append(" ORDER BY account.FNumber ASC ").append(CR);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        AccountViewCollection objCol = new AccountViewCollection();
        try {
            while (rs.next()) {
                AccountViewInfo info = new AccountViewInfo();
                info.setId(BOSUuid.read((String)rs.getString("FID")));
                info.setName(rs.getString("FName"));
                info.setNumber(rs.getString("FNumber"));
                String caaId = rs.getString("FCAA");
                if (!StringUtils.isEmpty((String)caaId)) {
                    AsstAccountInfo asstAccountInfo = new AsstAccountInfo();
                    asstAccountInfo.setId(BOSUuid.read((String)caaId));
                    info.setCAA(asstAccountInfo);
                }
                objCol.add(info);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return objCol;
    }

    @Override
    protected IObjectValue _getPreAdjPeriod(Context ctx, IObjectValue curPeriod) throws BOSException, EASBizException {
        return PeriodUtils.getPreAdjPeriodInfo((Context)ctx, (PeriodInfo)((PeriodInfo)curPeriod));
    }

    @Override
    protected boolean _isContrastAccount(Context ctx, String controlUnitID, String companyID, String accountID, AccountControlAttribute system) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("");
        sql.append("select fid from V_AR_AccountViewUnion where faccountid='").append(accountID).append("'").append(" and (fcompanyid='").append(companyID).append("'").append(" or fcompanyid='111')").append(" and fcontrolunitid='").append(controlUnitID).append("'").append(" and fsystem=").append(system.getValue());
        try {
            if (DbUtil.executeQuery((Context)ctx, (String)sql.toString()).next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    @Override
    protected IObjectCollection _getAsstActType(Context ctx, String accountViewID, String CompanyId) throws BOSException {
        if (StringUtils.isEmpty((String)accountViewID) || StringUtils.isEmpty((String)CompanyId)) {
            return new AsstActTypeCollection();
        }
        String lang = ctx.getLocale().getLanguage();
        StringBuffer sql = new StringBuffer("select distinct ty.fid as fid, ty.fname_").append(lang).append(" as fname, ty.fnumber as fnumber, ty.FAsstHGAttribute as FAsstHGAttribute").append(CR);
        sql.append("from t_bd_accountview av").append(CR);
        sql.append("inner join t_bd_asstaccount ass on av.fcaa = ass.fid").append(CR);
        sql.append("inner join t_bd_asstactgroupdetail det on det.fasstaccountid=ass.fid").append(CR);
        sql.append("inner join t_bd_asstacttype ty on ty.fid=det.fasstacttypeid").append(CR);
        sql.append("inner join t_bd_asstacttypedefault de on de.fasstacttypeid = ty.fid").append(CR);
        sql.append("where de.fisaccountcussent = 1 and av.fid=? and de.FCompanyID = ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{accountViewID, CompanyId});
        AsstActTypeCollection objCol = new AsstActTypeCollection();
        try {
            while (rs.next()) {
                AsstActTypeInfo info = new AsstActTypeInfo();
                info.setId(BOSUuid.read((String)rs.getString("fid")));
                info.setName(rs.getString("fname"));
                info.setNumber(rs.getString("fnumber"));
                info.setAsstHGAttribute(rs.getString("FAsstHGAttribute"));
                objCol.add(info);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return objCol;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._delete(ctx, pk);
        CacheServiceFactory.getInstance().discardQuery((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.ar.app.F7AccountViewQuery"));
    }
}

