/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ar.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.ContrastGLQueryParam;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContrastGLHelper {
    protected static final int ACCTS_LIMITED = 50;
    private static final int GL = 0;
    private static final int AR = 1;
    private static final int AP = 2;
    protected static final String VOU_TYPE = new VoucherInfo().getBOSType().toString();
    public static final String NEW_LINE = " \r\n ";

    private ContrastGLHelper() {
    }

    public static StringBuffer getGLDataSql(Context ctx, ContrastGLQueryParam param, boolean fArRpt) throws BOSException, EASBizException {
        return ContrastGLHelper.getDataSql(ctx, param, null, 0, fArRpt);
    }

    public static Map<String, AsstActTypeInfo> getCussTypeMap(Context ctx, String companyId, int periodYear, int periodNumber, boolean fArRpt) throws BOSException {
        HashMap<String, AsstActTypeInfo> map = null;
        if (StringUtils.isEmpty((String)companyId)) {
            return map;
        }
        StringBuilder buf = new StringBuilder(200).append("SELECT DISTINCT TCAV.FACCOUNTID, TAS.FID, TAS.").append("FNAME_" + ctx.getLocale().getLanguage()).append(" AS FCUSSTYPE, TAS.FREALTIONDATAOBJECT, TAS.FMAPPINGFIELDNAME ").append(NEW_LINE).append(" FROM T_AR_CONTRASTACCOUNTVIEW TCAV ").append(NEW_LINE).append(" INNER JOIN T_BD_ASSTACTTYPE TAS ON TCAV.FASSTACTTYPEID = TAS.FID ").append(NEW_LINE).append(" WHERE TCAV.FCOMPANYID = '").append(companyId).append("'").append(NEW_LINE).append(" AND TCAV.FSYSTEM = ").append(fArRpt ? "1" : "2").append(NEW_LINE).append(" AND TCAV.FPERIODYEAR = ").append(periodYear).append(" AND TCAV.FPERIODNUMBER = ").append(periodNumber);
        AsstActTypeInfo typeInfo = null;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buf.toString());
        try {
            map = new HashMap<String, AsstActTypeInfo>(100);
            String accountId = null;
            while (rs.next()) {
                typeInfo = new AsstActTypeInfo();
                accountId = rs.getString("FACCOUNTID");
                typeInfo.put("id", (Object)rs.getString("FID"));
                typeInfo.setRealtionDataObject(rs.getString("FREALTIONDATAOBJECT"));
                typeInfo.setMappingFieldName(rs.getString("FMAPPINGFIELDNAME"));
                typeInfo.setName(rs.getString("FCUSSTYPE"), ctx.getLocale());
                map.put(accountId, typeInfo);
                accountId = null;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    private static StringBuffer getGLAcctDataSql(Context ctx, ContrastGLQueryParam param, boolean fSubtract, boolean fAR) {
        boolean needAccount;
        String negativeStr = fSubtract ? " -1 * " : "";
        String nameFld = "FName_" + ctx.getLocale().getLanguage() + " ";
        String cussTbl = param.getCussTable();
        String cussMappingFld = param.getCussMappingFld();
        boolean hasCussAcct = !StringUtils.isEmpty((String)param.getCussTypeId());
        boolean hasItem = hasCussAcct && param.isHasItem();
        StringBuffer sql = new StringBuffer(200);
        int allamout = param.getAllAmountLocal();
        sql.append("select tCurr.fid AS FCurrencyID, tCurr.").append(nameFld).append(" AS FCurrency, ").append(NEW_LINE).append(allamout == 1 || allamout == 2 ? "'" + param.getCurrencyLocal() + "' AS FCurrencyLocal, " : " ");
        boolean bl = needAccount = !param.isBySum() && !param.isByBillSum();
        if (needAccount) {
            sql.append(" tAcct.FNumber || ' ' || tAcct.").append(nameFld).append(" AS FAccount, ");
            sql.append(" tAcct.FID ").append(" AS FAccountID, ").append(NEW_LINE);
        }
        if (hasItem) {
            sql.append("'").append(param.getCussTypeId()).append("' AS FCussTypeID, ");
            sql.append("N'").append(param.getCussTypeName()).append("' AS FCussType, ");
            sql.append("t3.FId FCussAcct, t3.FNumber FCussNum, t3.");
            sql.append(nameFld).append(" AS FCussName, ");
        } else {
            sql.append(" ' ' FCussTypeID, N' ' FCussType, ");
            sql.append(" ' ' FCussAcct, N' ' FCussNum, N' ' FCussName, ");
        }
        sql.append(NEW_LINE).append(" 0 FArStartAmt, 0 FArDebitAmt, 0 FArCreditAmt, ");
        sql.append(" 0 FArBalanceAmt, ").append(NEW_LINE);
        sql.append(negativeStr).append(!fAR ? "-1*" : "");
        sql.append(" sum(t1.FBeginBalanceFor) FGLStartAmt, ");
        sql.append(negativeStr).append(" sum(t1.FDebitFor) FGLDebitAmt, ");
        sql.append(negativeStr).append(" sum(t1.FCreditFor) FGLCreditAmt, ");
        sql.append(negativeStr).append(!fAR ? "-1*" : "");
        sql.append(" sum(FEndBalanceFor) FGLBalancedAmt ").append(NEW_LINE).append(" from ");
        if (hasCussAcct) {
            String tableName = param.isHasUnRegVoucher() ? "T_GL_AssistBalance_1f" : "T_GL_AssistBalance_5f";
            sql.append(" ").append(tableName).append(" t1 ").append(NEW_LINE).append(" inner join t_bd_AssistantHG t2 on t1.FAssistGrpId = t2.FId ");
            if (hasItem) {
                sql.append(" left join ").append(cussTbl).append(" t3 on t2.");
                sql.append(cussMappingFld).append(" = t3.FId ");
            }
        } else {
            String tableName = param.isHasUnRegVoucher() ? "T_GL_AccountBalance_1f" : "T_GL_AccountBalance_5f";
            sql.append(" ").append(tableName).append(" t1 ").append(NEW_LINE);
        }
        if (needAccount) {
            sql.append(" left join t_bd_accountView tAcct on tAcct.FId = t1.FAccountId ").append(NEW_LINE);
        }
        sql.append(" left join t_bd_currency tCurr on tCurr.FId = t1.FCurrencyId ").append(NEW_LINE);
        sql.append(" where t1.FOrgUnitID = '").append(param.getCompanyId()).append("' ").append(NEW_LINE);
        if (param.getCurrencyId().equals("all") || param.getCurrencyId().equals("base")) {
            sql.append(" and (t1.FCurrencyId != '").append(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID);
            sql.append("' and t1.FCurrencyId != '").append(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID);
            sql.append("' ) ").append(NEW_LINE);
        } else {
            sql.append(" and t1.FCurrencyId = '").append(param.getCurrencyId()).append("' ").append(NEW_LINE);
        }
        sql.append(" and t1.FAccountId = '").append(param.getAccountId());
        sql.append("' and t1.FPeriod = ").append(param.getPeriodYear() * 100 + param.getPeriodNum()).append(" ").append(NEW_LINE);
        if (!StringUtils.isEmpty((String)param.getCussAcctId())) {
            sql.append(" and t2.").append(cussMappingFld).append(" in (");
            sql.append(param.getCussAcctId()).append(") ").append(NEW_LINE);
        }
        sql.append(" group by tCurr.fid, tCurr.").append(nameFld);
        if (hasItem) {
            sql.append(" , t3.FId, t3.FNumber, t3.").append(nameFld);
        }
        if (needAccount) {
            sql.append(", tAcct.FNumber, tAcct.").append(nameFld).append(", tAcct.FID");
        }
        return sql;
    }

    private static StringBuffer getArApAcctDataSql(Context ctx, ContrastGLQueryParam param, String acctBalTbl, boolean fAR, boolean fSubtract) throws BOSException, EASBizException {
        boolean needAccount;
        String negativeStr = fSubtract ? " -1 * " : "";
        String nameFld = "FName_" + ctx.getLocale().getLanguage() + " ";
        String cussTbl = param.getCussTable();
        boolean hasCussAcct = !StringUtils.isEmpty((String)param.getCussTypeId());
        boolean hasItem = hasCussAcct && param.isHasItem();
        StringBuffer sql = new StringBuffer(200);
        int allAmout = param.getAllAmountLocal();
        sql.append("select t3.fid AS FCurrencyID, t3.").append(nameFld).append(" AS FCurrency, ").append(allAmout == 1 || allAmout == 2 ? "'" + param.getCurrencyLocal() + "' AS FCurrencyLocal, " : " ").append(NEW_LINE);
        String cussAcctTemp = null;
        if (!StringUtils.isEmpty((String)param.getCussAcctId())) {
            cussAcctTemp = param.getCussAcctId().substring(param.getCussAcctId().indexOf("FROM") + 4).trim();
        }
        boolean bl = needAccount = !param.isBySum() && !param.isByBillSum();
        if (needAccount) {
            sql.append(" t4.FNumber || ' ' || t4.").append(nameFld).append(" AS FAccount, ");
            sql.append(" t4.FID as FAccountID, ").append(NEW_LINE);
        }
        if (hasItem) {
            sql.append("t1.FAsstActTypeId FCussTypeID, tas.");
            sql.append(nameFld).append(" AS FCussType,");
            sql.append("t1.FAsstActId FCussAcct, t2.FNumber FCussNum, t2.");
            sql.append(nameFld).append("FCussName, ");
        } else {
            sql.append(" ' ' FCussTypeID, N' ' FCussType, ");
            sql.append(" ' ' FCussAcct, N' ' FCussNum, N' ' FCussName, ");
        }
        sql.append(NEW_LINE);
        sql.append(negativeStr).append(fAR ? "" : " -1 * ");
        sql.append(" sum(t1.FBeginBalanceFor) FArStartAmt, ").append(NEW_LINE);
        sql.append(negativeStr);
        sql.append(" sum(t1.FDebitFor) FArDebitAmt, ").append(NEW_LINE);
        sql.append(negativeStr);
        sql.append(" sum(t1.FCreditFor) FArCreditAmt, ").append(NEW_LINE);
        sql.append(negativeStr).append(fAR ? "" : " -1 * ");
        sql.append(" (sum(t1.FBeginBalanceFor) + sum(t1.FDebitFor) - sum(t1.FCreditFor)) AS FArBalanceAmt, ").append(NEW_LINE);
        sql.append(" 0 FGLStartAmt, 0 FGLDebitAmt, 0 FGLCreditAmt, 0 FGLBalanceAmt ").append(NEW_LINE);
        sql.append(" from ").append(acctBalTbl).append(" t1 ").append(NEW_LINE);
        if (hasItem) {
            sql.append(" inner join ").append(cussTbl);
            sql.append(" t2 on t2.FId = t1.FAsstActId ").append(NEW_LINE);
            sql.append(" inner join T_BD_AsstActType tas on tas.FId = t1.FAsstActTypeId ").append(NEW_LINE);
        }
        if (needAccount) {
            sql.append(" left join t_bd_accountView t4 on t4.FId = t1.FAccount").append(NEW_LINE);
        }
        sql.append(" inner join t_bd_currency t3 on t3.FId = t1.FCurrencyId ").append(NEW_LINE);
        if (cussAcctTemp != null) {
            sql.append(" inner join " + cussAcctTemp + " tempTbl on tempTbl.FId =  t1.fasstActId ").append(NEW_LINE);
        }
        sql.append("where t1.FCompanyID = '").append(param.getCompanyId()).append("' ").append(NEW_LINE);
        if (hasCussAcct) {
            sql.append(" and t1.FAsstActTypeId = '").append(param.getCussTypeId()).append("' ").append(NEW_LINE);
        }
        if (!param.getCurrencyId().equals("all") && !param.getCurrencyId().equals("base")) {
            sql.append(" and t1.FCurrencyId = '").append(param.getCurrencyId()).append("' ").append(NEW_LINE);
        }
        if (!param.isByBillSum()) {
            sql.append(" and t1.FAccount").append(" = '").append(param.getAccountId());
            sql.append("' and t1.FPeriodId = '").append(param.getPeriodId());
            sql.append("' ").append(NEW_LINE);
        }
        sql.append(" and t1.FBalType IN (");
        if (param.isContrastByBillAccount()) {
            sql.append("'").append("20").append("'");
            sql.append(param.isIncludeBizBill() ? ", '10'" : "");
        } else if (!param.isIncludeUnvoucheredBills()) {
            sql.append(3);
            sql.append(param.isIncludeBizBill() ? ", 5" : "");
        } else {
            sql.append("3, 2");
            sql.append(param.isIncludeBizBill() ? ", 4, 5" : "");
        }
        sql.append(") ").append(NEW_LINE).append(" group by t3.fid, t3.").append(nameFld);
        if (hasItem) {
            sql.append(" , t1.FAsstActTypeId,tas.");
            sql.append(nameFld);
            sql.append(", t1.FAsstActId, t2.FNumber, t2.");
            sql.append(nameFld);
        }
        if (needAccount) {
            sql.append(", t4.FNumber, t4.").append(nameFld).append(",t4.FID").append(NEW_LINE);
        }
        return sql;
    }

    public static StringBuffer getArApDataSql(Context ctx, ContrastGLQueryParam param, String acctBalTable, boolean fArRpt) throws BOSException, EASBizException {
        return ContrastGLHelper.getDataSql(ctx, param, acctBalTable, fArRpt ? 1 : 2, fArRpt);
    }

    public static StringBuffer getDataSql(Context ctx, ContrastGLQueryParam param, String acctBalTable, int type, boolean fArRpt) throws BOSException, EASBizException {
        List idFormula = param.getAcctFormula();
        if (idFormula == null || idFormula.size() == 0) {
            return null;
        }
        StringBuffer sql = new StringBuffer(200);
        boolean fBySum = param.isBySum();
        boolean fByBillSum = param.isByBillSum();
        ContrastGLQueryParam qryParam = new ContrastGLQueryParam();
        qryParam.setBySum(fBySum);
        qryParam.setAmountLocal(param.isAmountLocal());
        qryParam.setAllAmountLocal(param.getAllAmountLocal());
        qryParam.setCurrencyLocal(param.getCurrencyLocal());
        qryParam.setByBillSum(fByBillSum);
        qryParam.setCompanyId(param.getCompanyId());
        qryParam.setCurrencyId(param.getCurrencyId());
        qryParam.setPeriodId(param.getPeriodId());
        qryParam.setPeriodYear(param.getPeriodYear());
        qryParam.setPeriodNum(param.getPeriodNum());
        qryParam.setCussAcctFromNum(param.getCussAcctFromNum());
        qryParam.setCussAcctToNum(param.getCussAcctToNum());
        qryParam.setHasItem(param.isHasItem());
        qryParam.setHasUnRegVoucher(param.isHasUnRegVoucher());
        qryParam.setIsIncludeUnvoucheredBills(param.isIncludeUnvoucheredBills());
        qryParam.setIncludeBizBill(param.isIncludeBizBill());
        qryParam.setisCash(param.isCash());
        qryParam.setContrastByBillAccount(param.isContrastByBillAccount());
        int n = idFormula.size();
        String elmnt = null;
        boolean fSubtract = false;
        ArrayList<String> cussTypeIdList = new ArrayList<String>();
        Map<String, AsstActTypeInfo> asstActMap = ContrastGLHelper.getCussTypeMap(ctx, param.getCompanyId(), param.getPeriodYear(), param.getPeriodNum(), fArRpt);
        int sqlCount = 0;
        for (int i = 0; i < n; ++i) {
            elmnt = idFormula.get(i).toString();
            if (elmnt.equals("+") || elmnt.equals("-")) {
                fSubtract = elmnt.equals("-");
                continue;
            }
            qryParam.setAccountId(elmnt);
            AsstActTypeInfo cussTypeInfo = asstActMap.get(elmnt);
            String cussTypeId = "";
            if (cussTypeInfo != null) {
                cussTypeId = cussTypeInfo.getId().toString();
                qryParam.setCussTypeId(cussTypeId);
                qryParam.setCussTypeName(cussTypeInfo.getName().toString());
                qryParam.setCussTable(cussTypeInfo.getRealtionDataObject());
                qryParam.setCussMappingFld(cussTypeInfo.getMappingFieldName());
                if (cussTypeId.equals(param.getCussTypeId())) {
                    qryParam.setCussAcctId(param.getCussAcctId());
                }
            } else {
                qryParam.setCussTypeId(null);
                qryParam.setCussTable(null);
                qryParam.setCussMappingFld(null);
                qryParam.setCussAcctId(null);
            }
            if (type == 0) {
                if (sqlCount > 0) {
                    sql.append(NEW_LINE).append(" UNION ALL ").append(NEW_LINE);
                }
                sql.append(ContrastGLHelper.getGLAcctDataSql(ctx, qryParam, fSubtract, fArRpt));
                ++sqlCount;
                continue;
            }
            if (qryParam.isByBillSum() && (type == 1 || type == 2)) {
                if (param.getCussTypeId() == null) {
                    qryParam.setCussTypeId(null);
                    qryParam.setCussTable(null);
                    qryParam.setCussMappingFld(null);
                    qryParam.setCussAcctId(null);
                    if (sqlCount > 0) {
                        sql.append(NEW_LINE).append(" UNION ALL ").append(NEW_LINE);
                    }
                    sql.append(ContrastGLHelper.getArApAcctDataSql(ctx, qryParam, acctBalTable, fArRpt, fSubtract));
                    ++sqlCount;
                    return sql;
                }
                if (param.getCussTypeId() != null && param.getCussTypeId().equals("all")) {
                    if (cussTypeIdList.contains(cussTypeId)) continue;
                    cussTypeIdList.add(cussTypeId);
                    if (sqlCount > 0) {
                        sql.append(NEW_LINE).append(" UNION ALL ").append(NEW_LINE);
                    }
                    sql.append(ContrastGLHelper.getArApAcctDataSql(ctx, qryParam, acctBalTable, fArRpt, fSubtract));
                    ++sqlCount;
                    continue;
                }
                if (param.getCussTypeId() == null || param.getCussTypeId().equals("all") || !cussTypeId.equals(param.getCussTypeId())) continue;
                if (sqlCount > 0) {
                    sql.append(NEW_LINE).append(" UNION ALL ").append(NEW_LINE);
                }
                sql.append(ContrastGLHelper.getArApAcctDataSql(ctx, qryParam, acctBalTable, fArRpt, fSubtract));
                ++sqlCount;
                return sql;
            }
            if (sqlCount > 0) {
                sql.append(NEW_LINE).append(" UNION ALL ").append(NEW_LINE);
            }
            sql.append(ContrastGLHelper.getArApAcctDataSql(ctx, qryParam, acctBalTable, fArRpt, fSubtract));
            ++sqlCount;
        }
        return sql;
    }
}

